@extends('layouts.horizontal', ['title' => 'Attendance Report', 'topbarTitle' => 'Attendance Report'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/dropzone/dist/dropzone.css',
'node_modules/select2/dist/css/select2.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css'])
<style>
    .card-background {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        border: 1px solid #e9ecef;
    }
    .table-card {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .table-card .table {
        margin-bottom: 0;
    }
    .table-card .table thead th {
        background-color: #f1f5f9;
        border-bottom: 2px solid #dee2e6;
    }
    .detail-card {
        background: white;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    /* Footer styling */
    .dataTables_wrapper .dataTables_footer {
        background: #f8f9fa;
        padding: 10px;
        border-top: 2px solid #dee2e6;
    }
    .dataTables_wrapper .dataTables_footer th {
        font-weight: bold;
        background: #e9ecef !important;
    }
    /* Back button margin */
    .btn-back {
        margin-bottom: 15px !important;
    }
    /* Business selector width fix */
    #businessSelector {
        width: fit-content !important;
        min-width: 200px;
        max-width: 400px;
    }
    #businessSelector + .select2-container {
        width: fit-content !important;
        min-width: 200px;
        max-width: 400px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-sm-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2>
                    @if($viewType === 'detail')
                        Attendance Details: {{ $staff->staff_fullname }} - {{ $monthName }}-{{ $year }}
                    @else
                        Staff Attendance Report
                    @endif
                </h2>
                <div class="page-title-right">
                    @if($viewType === 'detail')
                        <a href="{{ route('hrm.staff_attendance_report') }}" class="btn btn-outline-secondary btn-back">
                            <iconify-icon icon="mdi:arrow-left"></iconify-icon> Back to Report
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if($viewType === 'detail')
        <!-- DETAIL VIEW WITH CARDS -->
        <div class="row">
            <div class="col-sm-12">
                <div class="detail-card">
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card-background">
                                <strong>Staff Name:</strong><br>
                                <h5 class="mt-1">{{ $staff->staff_fullname }}</h5>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="card-background">
                                <strong>Staff ID:</strong><br>
                                <span class="text-primary">{{ $staff->id_staff }}</span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card-background">
                                <strong>Business:</strong><br>
                                <span>{{ $staff->business->business_name ?? 'N/A' }}</span>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="card-background">
                                <strong>Salary Type:</strong><br>
                                <span class="badge bg-info">{{ ucfirst($staff->salary_type) }}</span>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="card-background">
                                <strong>Week Off:</strong><br>
                                <span class="text-danger">{{ $staff->week_day_off ?? 'N/A' }}</span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="card-background">
                                <div class="row text-center">
                                    <div class="col">
                                        <strong>Present:</strong>
                                        <h4 class="text-success">{{ $presents }}</h4>
                                    </div>
                                    <div class="col">
                                        <strong>Absent:</strong>
                                        <h4 class="text-danger">{{ $absents }}</h4>
                                    </div>
                                    <div class="col">
                                        <strong>Late:</strong>
                                        <h4 class="text-primary">{{ $late }}</h4>
                                    </div>
                                    <div class="col">
                                        <strong>Leave:</strong>
                                        <h4 class="text-warning">{{ $leave }}</h4>
                                    </div>
                                    <div class="col">
                                        <strong>Holiday:</strong>
                                        <h4 class="text-info">{{ $holiday }}</h4>
                                    </div>
                                    <div class="col">
                                        <strong>Work Hours:</strong>
                                        <h4 class="text-success">{{ number_format($workhours_total, 2) }}</h4>
                                    </div>
                                    <div class="col">
                                        <strong>Overtime Hours:</strong>
                                        <h4 class="text-warning">{{ number_format($overtime_hours_total, 2) }}</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="table-card">
                        <div class="table-responsive">
                            <table id="attendanceDetailTable" class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Day</th>
                                        <th>Time In</th>
                                        <th>Time Out</th>
                                        <th>Work Hours</th>
                                        <th>Overtime Hours</th>
                                        <th>Present</th>
                                        <th>Absent</th>
                                        <th>Late</th>
                                        <th>Leave</th>
                                        <th>Holiday</th>
                                        <th>Marked From</th>
                                        <th>Remarks</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($payables as $payable)
                                        @php
                                            $date = \Carbon\Carbon::parse($payable['Date']);
                                            $formattedDate = $date->format('d-M-Y');
                                            
                                            $offday = '';
                                            $dayClass = '';
                                            
                                            if ($payable['is_weekend']) {
                                                $dayClass = 'text-danger';
                                                $offday = '(Day Off)';
                                            } elseif ($payable['Holiday'] != 0) {
                                                $dayClass = 'text-primary';
                                            } elseif ($payable['is_overtime_day']) {
                                                $dayClass = 'text-warning';
                                            }
                                            
                                            $dayText = $payable['Day'];
                                            if ($payable['leave_reason']) {
                                                $dayText .= ' ' . $payable['leave_reason'];
                                            }
                                            if ($payable['holiday_reason']) {
                                                $dayText .= ' ' . $payable['holiday_reason'];
                                            }
                                            $dayText .= ' ' . $offday;
                                        @endphp
                                        
                                        <tr>
                                            <td>{{ $formattedDate }}</td>
                                            <td class="{{ $dayClass }}">
                                                {{ $dayText }}
                                                @if($payable['is_overtime_day'])
                                                    <br><small class="text-muted">(Overtime Day)</small>
                                                @endif
                                            </td>
                                            <td class="text-center">{{ $payable['time_in'] }}</td>
                                            <td class="text-center">{{ $payable['time_out'] }}</td>
                                            <td class="text-center">{{ number_format($payable['Work_Hours'], 2) }}</td>
                                            <td class="text-center {{ $payable['is_overtime_day'] ? 'text-warning' : '' }}">
                                                {{ number_format($payable['overtime_hours'] ?? 0, 2) }}
                                            </td>
                                            <td class="text-center {{ $payable['Present'] == 1 ? 'text-success' : '' }}">
                                                @if($payable['Present'] == 1)
                                                    <iconify-icon icon="mdi:check" style="color: #198754;"></iconify-icon>
                                                @else
                                                    <iconify-icon icon="mdi:close" style="color: #dc3545;"></iconify-icon>
                                                @endif
                                            </td>
                                            <td class="text-center {{ $payable['Absent'] == 1 ? 'text-danger' : '' }}">
                                                @if($payable['Absent'] == 1)
                                                    <iconify-icon icon="mdi:check" style="color: #198754;"></iconify-icon>
                                                @else
                                                    <iconify-icon icon="mdi:close" style="color: #dc3545;"></iconify-icon>
                                                @endif
                                            </td>
                                            <td class="text-center {{ $payable['Late'] == 1 ? 'text-primary' : '' }}">
                                                @if($payable['Late'] == 1)
                                                    <iconify-icon icon="mdi:check" style="color: #198754;"></iconify-icon>
                                                @else
                                                    <iconify-icon icon="mdi:close" style="color: #dc3545;"></iconify-icon>
                                                @endif
                                            </td>
                                            <td class="text-center {{ $payable['Leaves'] == 1 ? 'text-warning' : '' }}">
                                                @if($payable['Leaves'] == 1)
                                                    <iconify-icon icon="mdi:check" style="color: #198754;"></iconify-icon>
                                                @else
                                                    <iconify-icon icon="mdi:close" style="color: #dc3545;"></iconify-icon>
                                                @endif
                                            </td>
                                            <td class="text-center {{ $payable['Holiday'] == 1 ? 'text-warning' : '' }}">
                                                @if($payable['Holiday'] == 1)
                                                    <iconify-icon icon="mdi:check" style="color: #198754;"></iconify-icon>
                                                @else
                                                    <iconify-icon icon="mdi:close" style="color: #dc3545;"></iconify-icon>
                                                @endif
                                            </td>
                                            <td>{{ $payable['address'] ?? '' }}</td>
                                            <td>
                                                @if($payable['leave_reason'])
                                                    <span class="badge bg-warning">Leave: {{ $payable['leave_reason'] }}</span>
                                                @endif
                                                @if($payable['holiday_reason'])
                                                    <span class="badge bg-info">Holiday: {{ $payable['holiday_reason'] }}</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr class="table-active">
                                        <th colspan="4" class="text-end">Totals:</th>
                                        <th class="text-center text-success">{{ number_format($workhours_total, 2) }}</th>
                                        <th class="text-center text-warning">{{ number_format($overtime_hours_total, 2) }}</th>
                                        <th class="text-center text-success">{{ $presents }}</th>
                                        <th class="text-center text-danger">{{ $absents }}</th>
                                        <th class="text-center text-primary">{{ $late }}</th>
                                        <th class="text-center text-warning">{{ $leave }}</th>
                                        <th class="text-center text-warning">{{ $holiday }}</th>
                                        <th colspan="2"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        <!-- Business Selector Section - Only show for HO users -->
        @if($isHoUser)
            <div class="row mb-3">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row align-items-center">
                                    <div class="col-md-12">
                                    <label class="form-label">Select Business</label><br>
                                    <select class="form-control" id="businessSelector">
                                        <option value=""></option>
                                        @foreach($businesses as $biz)
                                            <option value="{{ $biz->id_business }}" 
                                                {{ (session('business_id') == $biz->id_business) ? 'selected' : '' }}>
                                                {{ $biz->business_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form id="attendanceFilterForm" method="GET">
                            <div class="row">
                                <!-- Hidden business_id field for filtering -->
                                <input type="hidden" name="business_id" id="filter_business_id" value="{{ session('business_id') }}">
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Staff</label>
                                        <select class="form-control select2" name="staff" id="staffSelect">
                                            <option value="0">All Staff</option>
                                            @foreach($staffList as $staffItem)
                                                <option value="{{ $staffItem->id_staff }}" 
                                                    {{ $staffId == $staffItem->id_staff ? 'selected' : '' }}>
                                                    {{ $staffItem->staff_fullname }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Month</label>
                                        <select class="form-select select2" name="month" id="monthSelect">
                                            @for($i = 1; $i <= 12; $i++)
                                                <option value="{{ sprintf('%02d', $i) }}" 
                                                    {{ $month == sprintf('%02d', $i) ? 'selected' : '' }}>
                                                    {{ date('F', mktime(0, 0, 0, $i, 1)) }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label class="form-label">Year</label>
                                        <select class="form-select select2" name="year" id="yearSelect">
                                            @php
                                                $earliestYear = $earliestYear ?? date('Y');
                                                $currentYear = $currentYear ?? date('Y');
                                            @endphp
                                            @for($y = $currentYear; $y >= $earliestYear; $y--)
                                                <option value="{{ $y }}" 
                                                    {{ $year == $y ? 'selected' : ($y == date('Y') && !$request->has('year') ? 'selected' : '') }}>
                                                    {{ $y }}
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="table-card">
                    <div class="table-responsive">
                        <table id="attendanceReportTable" class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Staff Name</th>
                                    <th>Business</th>
                                    <th>Present</th>
                                    <th>Absent</th>
                                    <th>Late</th>
                                    <th>Leave</th>
                                    <th>Holiday</th>
                                    <th>Work Hours</th>
                                    <th>Overtime Hours</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be loaded via AJAX -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection
@section('scripts')
@vite(['resources/js/app.js'])
<script>
$(document).ready(function() {
    @if($viewType === 'detail')
        // Initialize DataTable for detail view
        $('#attendanceDetailTable').DataTable({
            stateSave: true,
            paging: false,
            dom: "Bfrtip",
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
            ],
            responsive: 0,
            "order": [[ 0, "asc" ]],
            "language": {
                "emptyTable": "No attendance data available for this month"
            }
        });
    @else
        // Initialize Select2 for staff dropdown
        $('#staffSelect').select2({
            width: '100%',
            placeholder: 'Select Staff'
        });
        
        // Initialize Select2 for month dropdown
        $('#monthSelect').select2({
            width: '100%'
        });
        
        // Initialize Select2 for year dropdown
        $('#yearSelect').select2({
            width: '100%'
        });

        // Initialize Select2 for business selector
        $('#businessSelector').select2({
            width: 'fit-content',
            placeholder: 'Select Business'
        });

        $('#businessSelector').on('change', function() {
            const businessId = $(this).val();
            $('#filter_business_id').val(businessId);
            $.ajax({
                url: "{{ route('hrm.get_staff_by_business') }}",
                type: 'GET',
                data: {
                    business_id: businessId
                },
                success: function(response) {
                    if (response.success) {
                        const staffSelect = $('#staffSelect');
                        staffSelect.empty();
                        staffSelect.append('<option value="0">All Staff</option>');
                        
                        $.each(response.staff, function(index, staff) {
                            staffSelect.append(`<option value="${staff.id_staff}">${staff.staff_fullname}</option>`);
                        });
                        
                        // Re-initialize Select2
                        staffSelect.select2({
                            width: '100%',
                            placeholder: 'Select Staff'
                        });

                        staffSelect.val('0').trigger('change');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading staff:', error);
                }
            });
            
            // Reload the DataTable
            if (window.attendanceTable) {
                window.attendanceTable.ajax.reload();
            }
        });

       // Initialize DataTable for summary view
        var table = $('#attendanceReportTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('hrm.get_attendance_report') }}",
                type: 'POST',
                data: function(d) {
                    // DataTables automatically sends these parameters when serverSide: true
                    // We need to forward them to the server
                    return {
                        draw: d.draw,
                        start: d.start,
                        length: d.length,
                        
                        // Your custom parameters
                        business_id: $('#filter_business_id').val(),
                        staff_id: $('#staffSelect').val(),
                        month: $('#monthSelect').val(),
                        year: $('#yearSelect').val(),
                        _token: "{{ csrf_token() }}"
                    };
                },
                error: function(xhr, error, thrown) {
                    console.error('AJAX Error:', xhr.responseText);
                    alert('Error loading data. Please check console for details.');
                }
            },
            pageLength: 10,
            lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
            columns: [
                { data: 'staff_fullname', name: 'staff_fullname' },
                { data: 'business_name', name: 'business_name' },
                { 
                    data: 'total_present', 
                    name: 'total_present', 
                    className: 'text-center',
                    render: function(data, type, row) {
                        return '<span class="text-success">' + (data || 0) + '</span>';
                    }
                },
                { 
                    data: 'total_absent', 
                    name: 'total_absent', 
                    className: 'text-center',
                    render: function(data, type, row) {
                        return '<span class="text-danger">' + (data || 0) + '</span>';
                    }
                },
                { 
                    data: 'total_late', 
                    name: 'total_late', 
                    className: 'text-center',
                    render: function(data, type, row) {
                        return '<span class="text-primary">' + (data || 0) + '</span>';
                    }
                },
                { 
                    data: 'total_leave', 
                    name: 'total_leave', 
                    className: 'text-center',
                    render: function(data, type, row) {
                        return '<span class="text-warning">' + (data || 0) + '</span>';
                    }
                },
                { 
                    data: 'total_holiday', 
                    name: 'total_holiday', 
                    className: 'text-center',
                    render: function(data, type, row) {
                        return '<span class="text-warning">' + (data || 0) + '</span>';
                    }
                },
                { 
                    data: 'total_work_hours', 
                    name: 'total_work_hours',
                    className: 'text-center',
                    render: function(data, type, row) {
                        const value = parseFloat(data) || 0;
                        return '<span class="text-success">' + value.toFixed(2) + '</span>';
                    }
                },
                { 
                    data: 'total_overtime_hours', 
                    name: 'total_overtime_hours',
                    className: 'text-center',
                    render: function(data, type, row) {
                        const value = parseFloat(data) || 0;
                        return '<span class="text-warning">' + value.toFixed(2) + '</span>';
                    }
                },
                {
                    data: 'view_link',
                    name: 'actions',
                    orderable: false,
                    searchable: false,
                    className: 'text-center',
                    render: function(data, type, row) {
                        if (!data) return '';
                        return '<a href="' + data + '" class="btn btn-sm btn-ghost-secondary rounded-circle btn-icon">' +
                            '<iconify-icon icon="mdi:eye-outline" class="fs-22"></iconify-icon>' +
                            '</a>';
                    }
                }
            ],
            layout: {
                topStart: null,
                topEnd: null,
                bottomStart: {
                    pageLength: { menu: [[10, 25, 50, 100], [10, 25, 50, 100]] },
                    info: {}
                },
                bottomEnd: "paging"
            },
            searching: false,
            buttons: [
                'copy', 'csv', 'excel', 'pdf'
            ],
            "language": {
                "emptyTable": "No data available in table",
                "info": "Showing _START_ to _END_ of _TOTAL_ entries",
                "infoEmpty": "Showing 0 to 0 of 0 entries",
                "infoFiltered": "(filtered from _MAX_ total entries)",
                "loadingRecords": "Loading...",
                "processing": "Processing...",
                "zeroRecords": "No matching records found"
            }
        });

        window.attendanceTable = table;

        // When filters change, reload the table
        $('#staffSelect, #monthSelect, #yearSelect').change(function() {
            table.ajax.reload();
        });

        // Handle form submission
        $('#attendanceFilterForm').submit(function(e) {
            e.preventDefault();
            table.ajax.reload();
        });
    @endif
});
</script>
@endsection
