@extends('layouts.horizontal', ['title' => 'Staff Payable and Receivable', 'topbarTitle' => 'Staff Payable and Receivable'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css'])
<style>
    .wrapper {
        min-height: 100vh;
        background-color: #f5f7fb;
    }
    .container {
        padding-top: 20px;
        padding-bottom: 20px;
    }
    .card-box {
        background: white;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        margin-bottom: 20px;
    }
   
    .radio-inline {
        margin-right: 15px;
    }
    #tblstaff th {
        background-color: #f8f9fa;
        font-weight: 600;
    }
    .text-right {
        text-align: right;
    }
    .checkbox {
        margin: 0;
        padding: 0;
    }
    .checkbox-row {
        width: 18px;
        height: 18px;
    }
  
</style>
@endsection

@section('content')
<div class="wrapper">
    <div class="container">
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Staff Payment Calculator</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
        <!-- Payment Mode Selection -->
         @if(session('ho') === 'Yes')
            <div class="row mb-3">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row align-items-center">
                                <div class="col-md-12">
                                    <label class="form-label">Select Business</label>
                                    <select class="form-control select2" id="businessSelector">
                                        @foreach($businesses as $business)
                                            <option value="{{ $business->id_business }}" 
                                                {{ session('selected_business_id') == $business->id_business ? 'selected' : '' }}>
                                                {{ $business->business_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        <div class="row" id="divselection">
            <div class="col-sm-12">
                <div class="card-box ">
                 <div class="d-flex justify-content-between align-items-center mb-3">
                       <h4 class="page-title">Staff Payable and Receivable as on : {{ date('d-m-Y') }}</h4>
                        <div class="d-flex align-items-center gap-2">
                            <button type="button" class="btn btn-outline-warning dropdown-toggle waves-effect waves-light" data-bs-toggle="dropdown" aria-expanded="true">
                                <iconify-icon icon="mdi:cash"></iconify-icon> Staff Payments
                            </button>
                            <ul class="dropdown-menu" role="menu">
                                <li><a href="{{ route('staff.staff_list') }}" class="dropdown-item">Staff</a></li>
                                <li><a href="{{ route('hrm.staff_payment_calculator') }}" class="dropdown-item">Monthly Salary Calculation</a></li>
                                <li><a href="{{ route('hrm.staff_paymentslips') }}" class="dropdown-item">Payment Slips</a></li>
                            </ul>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" onclick="showhidebank();" value="Bank" required name="voucher_payment_mode" id="bank_mode">
                                        <label class="form-check-label" for="bank_mode">Bank</label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" onclick="showhidebank();" value="Cash" required name="voucher_payment_mode" id="cash_mode">
                                        <label class="form-check-label" for="cash_mode">Cash</label>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="radio" onclick="showhidebank();" value="Card" required name="voucher_payment_mode" id="card_mode">
                                        <label class="form-check-label" for="card_mode">Card</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div id="showbank" style="display:none">
                                <label class="form-label">Select Bank</label>
                                <select class="form-control" name="bank_accounts" id="bank_account">
                                    @foreach($bank_accounts as $ba)
                                        <option value="{{ $ba->id_account_heads }}">
                                            {{ $ba->account_head }} ({{ $ba->account_head_number ?? '' }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        
                       <div class="col-md-12 mb-3">
                            <div id="showcash" style="display:none">
                                <label class="form-label">Select Cash Account</label>
                                <select class="form-control" name="cash_accounts" id="cash_account">
                                    @foreach($cash_accounts as $ca)
                                        <option value="{{ $ca->id_account_heads }}">
                                            {{ $ca->account_head }} ({{ $ca->account_head_number ?? '' }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12 mb-3">
                            <div id="showcard" style="display:none">
                                <label class="form-label">Select Card Account</label>
                                <select class="form-control" name="card_accounts" id="card_account">
                                    @foreach($card_accounts as $ca)
                                        <option value="{{ $ca->id_account_heads }}">
                                            {{ $ca->account_head }} ({{ $ca->account_head_number ?? '' }})
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <label class="form-label">Instrument #</label>
                                    <input class="form-control d-none" name="payment_mode" id="payment_mode" value="">
                                    <input class="form-control numeric" name="instrument_number" id="instrument_number" value="">
                                </div>
                                <div class="col-md-4">
                                    <label for="account_voucher_date" class="form-label">Payment Date</label>
                                    <input class="form-control datepicker" required id="account_voucher_date" name="account_voucher_date">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Action</label>
                                    <select class="form-control" name="select_action" id="select_action">
                                        <option value="payment">Payment</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row text-right mt-3">
                        <div class="col-md-12 ">
                            <button onclick="select_action();" type="button" class="btn btn-outline-primary btn-bordred waves-effect w-md waves-light">Run</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Staff Payables Table -->
        <div class="row" id="divselection">
            <div class="col-sm-12">
                <div class="card-box">
                    <table id="tblstaff" class="table table-bordered">
                        <thead>
                            <tr>
                                <th><input class="form-check-input" type="checkbox" id="checkall" onclick="selectall();"></th>
                                <th>ID</th>
                                <th>Name</th>
                                <th>Voucher</th>
                                <th>Month</th>
                                <th>Year</th>
                                <th class="text-right">Wages Payable</th>
                                <th class="text-right">Clearing Now</th>
                                <th>Receivable & Payables</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $totalpayables = 0; $totalreceivables = 0; @endphp
                            @foreach($payables as $payable)
                                @if($payable['salary_payable'] > 0)
                                    @php $totalpayables = $totalpayables + $payable['salary_payable']; @endphp
                                    <tr id="{{ $payable['id_staff'] }}_{{ $payable['id_account_vouchers'] }}">
                                        <td key="checkbox" type="checkbox">
                                            <input id="checkbox_{{ $payable['id_staff'] }}_{{ $payable['id_account_vouchers'] }}" type="checkbox" class="form-check-input checkbox-row" onclick="selectsingle();">
                                        </td>
                                        <td key="staff_id" type="ignore">{{ $payable['id_staff'] }}</td>
                                        <td key="staff_fullname" type="ignore" name="staff_name">{{ $payable['staff_fullname'] }}</td>
                                        <td key="voucher_id" type="ignore">{{ $payable['id_account_vouchers'] }}</td>
                                        <td key="month" type="ignore">{{ $payable['voucher_month'] }}</td>
                                        <td key="year" type="ignore">{{ $payable['voucher_year'] }}</td>
                                        <td key="payable" type="ignore" name="payable" id="payable_{{ $payable['id_staff'] }}_{{ $payable['id_account_vouchers'] }}" class="text-right">
                                            {{ number_format($payable['salary_payable'], 2) }}
                                        </td>
                                        <td key="payingnow" type="add_input" name="payingnow" class="text-right">
                                            <input onchange="" style="text-align: right; width:80px; border:none;" 
                                                class="text-primary decimal" 
                                                onkeyup="if(this.value > parseFloat($('#payable_{{ $payable['id_staff'] }}_{{ $payable['id_account_vouchers'] }}').text().replace(',',''))){this.value=parseFloat($('#payable_{{ $payable['id_staff'] }}_{{ $payable['id_account_vouchers'] }}').text().replace(',',''));}" 
                                                id="payingnow_{{ $payable['id_staff'] }}_{{ $payable['id_account_vouchers'] }}" 
                                                name="paying_now" type="number" min="0" 
                                                value="{{ $payable['salary_payable'] }}" 
                                                step="0.01">
                                        </td>
                                        <!-- ADD key="description" HERE -->
                                        <td key="description" type="ignore">{{ $payable['description'] }}</td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="6"></th>
                                <th class="text-right">{{ number_format($totalpayables, 2) }}</th>
                                <th class="text-right">
                                    <label style="text-align: right;" class="form-label" id="totalpayablelabel"></label>
                                </th>
                                <th class="text-right"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@vite(['resources/js/app.js'])
<script>
$(document).ready(function() {
    $('#businessSelector').on('change', function () {
        const businessId = $(this).val();
        if (businessId) {
            window.location.href = "{{ url('hrm/staff-payables-receivables') }}/" + businessId;
        }
    });

    $('#tblstaff').DataTable({
        lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
        stateSave: true,
        dom: "Bfrtip",
        "bPaginate": false,
        buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
            ],
        responsive: 0,
        "order": [[1, "asc"]],
        "columnDefs": [{targets: 0, orderable: false}]
    });
    
    // Numeric input validation
    $(".numeric").keypress(function(e) {
        if (e.which != 13 && e.which != 8 && e.which != 0 && e.which != 46 && (e.which < 48 || e.which > 57)) {
            return false;
        }
    });

    $(".decimal").keypress(function(e) {
        if (e.which != 13 && e.which != 8 && e.which != 0 && e.which != 46 && (e.which < 48 || e.which > 57)) {
            return false;
        }
    });

    flatpickr("#account_voucher_date", {
        dateFormat: "Y-m-d",
        defaultDate: new Date()
    });

    checkRunButtonState();

    $('input[name="voucher_payment_mode"]').change(function() {
        showhidebank();
        checkRunButtonState();
    });

    $('#instrument_number').on('input', function() {
        checkRunButtonState();
    });

    // Listen to checkbox changes in the table
    $(document).on('change', '.checkbox-row, #checkall', function() {
        checkRunButtonState();
    });
});

// Function to check and update Run button state
function checkRunButtonState() {
    const runButton = $('button[onclick*="select_action"]');
    
    // Check condition 1: Bank or Cash not selected
    const isPaymentModeSelected = $('input[name="voucher_payment_mode"]:checked').length > 0;
    
    // Check condition 2: Instrument Number empty
    const instrumentNumber = $('#instrument_number').val().trim();
    const isInstrumentNumberEmpty = instrumentNumber === '';
    
    // Check condition 3: No checkbox checked in the table
    let isAnyCheckboxChecked = false;
    
    // Check individual checkboxes
    $('.checkbox-row').each(function() {
        if ($(this).is(':checked')) {
            isAnyCheckboxChecked = true;
            return false; // break the loop
        }
    });
    
    // Also check the "check all" checkbox
    if ($('#checkall').is(':checked')) {
        isAnyCheckboxChecked = true;
    }
    
    // Determine if button should be disabled
    const shouldDisableButton = !isPaymentModeSelected || isInstrumentNumberEmpty || !isAnyCheckboxChecked;
    
    // Update button state
    if (shouldDisableButton) {
        runButton.prop('disabled', true);
        runButton.addClass('disabled');
    } else {
        runButton.prop('disabled', false);
        runButton.removeClass('disabled');
    }
}

function showhidebank() {
    var selectedMode = $('input[name=voucher_payment_mode]:checked').val();
    
    if (selectedMode == "Bank") {
        $("#showbank").show();
        $("#showcash").hide();
        $("#showcard").hide();
        $("#payment_mode").val("Bank");
    } else if (selectedMode == "Cash") {
        $("#showbank").hide();
        $("#showcard").hide();
        $("#showcash").show();
        $("#payment_mode").val("Cash");
    }else{
        $("#showbank").hide();
        $("#showcash").hide();
         $("#showcard").show();
        $("#payment_mode").val("Card");
    }
    
    // Check Run button state after showing/hiding bank/cash
    checkRunButtonState();
}

function select_action() {
    var action = $("#select_action option:selected").val();
    
    if (action == "payment") {
        staff_payment();
    } else {
        // staff_receiving(); // Uncomment if you implement receiving function
    }
}

function staff_payment() {
    var TableData = storeOTblValues();
    TableData = JSON.stringify(TableData);
    
    var businessId = $('#businessSelector').val() || '{{ $business->id_business }}';
    
    if (TableData.length > 0) {
        $.ajax({
            type: "POST",
            url: '{{ route("hrm.check_staff_payment") }}',
            data: {
                _token: '{{ csrf_token() }}',
                business_id: businessId,
                account_voucher_date: $("#account_voucher_date").val(),
                payment_mode: $("#payment_mode").val(),
                instrument_number: $("#instrument_number").val(),
                bank_account: $("#bank_account").val(),
                cash_account: $("#cash_account").val(),
                card_account: $("#card_account").val(),
                TableData: TableData
            },
            success: function(data) {
                if (data.success) {
                    toastr.success(data.message, 'Success!');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    toastr.error(data.message, 'Error');
                }
            },
            error: function(xhr) {
                toastr.error('Error processing payment', 'Error');
                console.error(xhr.responseText);
            }
        });
    }
}

function storeOTblValues() {
    var TableData = [];
    var count = 0;
    
    $('#tblstaff tr').each(function(row, tr) {
        var a = {};
        var dothis = false;
        
        var staffId = $(tr).find('td:eq(1)').text().trim();
        var voucherId = $(tr).find('td:eq(3)').text().trim();
        
        $('#tblstaff tr[id="' + staffId + '_' + voucherId + '"] td').each(function(col, td) {
            var elem = $(td).attr('key');
            if (typeof elem !== 'undefined' && elem !== '') {
                var type = $(td).attr('type');
                
                if (type == 'checkbox') {
                    if ($(td).find('input[type="checkbox"]').is(':checked') == true) {
                        dothis = true;
                    } else {
                        dothis = false;
                    }
                } else if (type !== 'add_input' && type !== 'subtract_input') {
                    a[elem] = $(td).text().trim();
                } else {
                    a[elem] = $(td).find('input[type="text"], input[type="number"]').val();
                }
            }
        });
        
        if (typeof a !== 'undefined' && dothis == true) {
            TableData[count] = a;
            a = {};
            count++;
        }
    });
    
    return TableData;
}

function selectall() {
    var totalpayable = 0;
    
    if ($("#checkall").is(':checked') == true) {
        $('#tblstaff tr').each(function(row, tr) {
            var staffId = $(tr).find('td:eq(1)').text().trim();
            var voucherId = $(tr).find('td:eq(3)').text().trim();
            
            $("#checkbox_" + staffId + "_" + voucherId).prop("checked", true);
            
            var payingNowVal = $(tr).find('td:eq(7) input[type="text"], td:eq(7) input[type="number"]').val();
            if (typeof payingNowVal !== 'undefined') {
                totalpayable = totalpayable + parseFloat(payingNowVal);
            }
        });
    } else {
        $('#tblstaff tr').each(function(row, tr) {
            var staffId = $(tr).find('td:eq(1)').text().trim();
            var voucherId = $(tr).find('td:eq(3)').text().trim();
            $("#checkbox_" + staffId + "_" + voucherId).prop("checked", false);
        });
    }
    
    $("#totalpayablelabel").html(Math.round(totalpayable * 100) / 100);
    checkRunButtonState();
}

function selectsingle() {
    var totalpayable = 0;
    
    $('#tblstaff tr').each(function(row, tr) {
        var staffId = $(tr).find('td:eq(1)').text().trim();
        var voucherId = $(tr).find('td:eq(3)').text().trim();
        
        if ($("#checkbox_" + staffId + "_" + voucherId).is(':checked') === true) {
            var payingNowVal = $(tr).find('td:eq(7) input[type="text"], td:eq(7) input[type="number"]').val();
            if (typeof payingNowVal !== 'undefined') {
                totalpayable = totalpayable + parseFloat(payingNowVal);
            }
        }
    });
    
    $("#totalpayablelabel").html(Math.round(totalpayable * 100) / 100);
    checkRunButtonState();
}
</script>
@endsection