@extends('layouts.horizontal', ['title' => 'Staff Payment Calculator', 'topbarTitle' => 'Staff Payment Calculator'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/dropzone/dist/dropzone.css',
'node_modules/select2/dist/css/select2.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css'])
<style>
    tr.strike-through > td {text-decoration:line-through !important; color:red;} 
    .filter-row { background-color: #f9f9f9; }
    .form-filter { font-size: 12px; padding: 4px 6px; height: 30px; width: 100%; }
    .filter-row th { padding: 4px 6px !important; vertical-align: middle; }
    .dataTables_wrapper .dataTables_filter { float: right; }
    .dataTables_wrapper .dataTables_length { float: left; }
    .dataTables_wrapper .dataTables_paginate { float: right; }
    .filter-buttons { display: flex; gap: 5px; }
    .filter-buttons button { padding: 4px 8px; font-size: 12px; }
    .action-buttons { white-space: nowrap; }
    .amount-cell { text-align: right; }
    .status-badge {
        padding: 4px 8px;
        border-radius: 4px;
        font-size: 12px;
        font-weight: 500;
    }
    
    .dataTables_scrollHead { background: #f8f9fa; }
    
    /* Hide hidden elements */
    .hidden {
        display: none;
    }
    
    .form-control-sm {
        padding: 2px 5px;
        height: 30px;
        font-size: 12px;
    }
    
    /* Table styling */
    #staffPaymentTable_wrapper {
        overflow: auto;
    }
    #staffPaymentTable {
        min-width: 2000px;
    }
    .text-end {
        text-align: right !important;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Staff Payment Calculator</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if(session('Success'))
    <div class="row">
        <div class="col-12">
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <strong>Success!</strong> {{ session('Success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        </div>
    </div>
    @endif

    @if(session('Error'))
    <div class="row">
        <div class="col-12">
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong>Error!</strong> {{ session('Error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        </div>
    </div>
    @endif

    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h4 class="card-title mb-0">Calculate Payments For: {{ $monthName }}-{{ $year }}</h4>
                        <div class="d-flex align-items-center gap-2">
                            <button type="button" class="btn btn-outline-warning dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="true">
                                <iconify-icon icon="mdi:cash"></iconify-icon> Staff Payments
                            </button>
                            <ul class="dropdown-menu" role="menu">
                                <li><a href="{{ route('staff.staff_list') }}" class="dropdown-item">Staff</a></li>
                                <li><a href="{{ route('hrm.staff_payables_receivables', ['businessid' => session('business_id')]) }}" class="dropdown-item">Make Payments To Staff</a></li>
                                <li><a href="{{ route('hrm.staff_paymentslips') }}" class="dropdown-item">Payment Slips</a></li>
                                <li><hr class="dropdown-divider"></li>
                            </ul>
                        </div>
                    </div>
                    
                    <form action="{{ route('hrm.staff_payment_calculator') }}" method="GET" id="paymentFilterForm">
                        @csrf
                        <div class="row g-3">
                            @if(session('ho') === 'Yes')
                            <div class="col-md-2">
                                <label class="form-label">Business</label>
                                <select class="form-control select2" name="business_id" id="business_id" onchange="updateStaffList()">
                                    <option value="">All Businesses</option>
                                    @foreach($businesses as $biz)
                                        <option value="{{ $biz->id_business }}" 
                                            {{ ($selectedBusinessId == $biz->id_business) ? 'selected' : '' }}>
                                            {{ $biz->business_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                            
                            <div class="col-md-2">
                                <label class="form-label">Month</label>
                                <select class="form-control" name="month" id="monthSelect">
                                    @php
                                        $months = [
                                            1 => 'Jan', 2 => 'Feb', 3 => 'Mar', 4 => 'Apr',
                                            5 => 'May', 6 => 'Jun', 7 => 'Jul', 8 => 'Aug',
                                            9 => 'Sep', 10 => 'Oct', 11 => 'Nov', 12 => 'Dec'
                                        ];
                                    @endphp
                                    @foreach($months as $num => $name)
                                        <option value="{{ $num }}" {{ $month == $num ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-2">
                                <label class="form-label">Year</label>
                                <select class="form-control" name="year" id="yearSelect">
                                    @php
                                        $currentYear = date('Y');
                                        $years = range($currentYear - 1, $currentYear);
                                    @endphp
                                    @foreach($years as $yr)
                                        <option value="{{ $yr }}" {{ $year == $yr ? 'selected' : '' }}>
                                            {{ $yr }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="account_voucher_date" class="form-label">Voucher Date</label>
                                    <input type="text" class="form-control form-control" id="account_voucher_date" name="account_voucher_date" value="{{ old('account_voucher_date', $voucherDate ?? '') }}">
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <label class="form-label">Staff</label>
                                <select class="form-control select2" name="staff" id="staff_id">
                                    <option value="">Select Staff</option>
                                    @foreach($staff as $item)
                                        <option value="{{ $item->id_staff }}" {{ $staffId == $item->id_staff ? 'selected' : '' }}>
                                            {{ $item->staff_fullname }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-md-1 d-flex align-items-end">
                                <button type="submit" form="paymentFilterForm" class="btn btn-outline-primary w-100" id="calculateBtn">
                                    <iconify-icon icon="mdi:calculator"></iconify-icon> Calculate
                                </button>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12 d-flex align-items-end justify-content-end gap-2">
                                <button type="button" onclick="create_vouchers();" class="btn btn-outline-success me-3" id="btn_create" {{ empty($payables) ? 'disabled' : '' }}>
                                   <iconify-icon icon="mdi:plus" class="fs-20 me-1"></iconify-icon> Create Vouchers
                                </button>
                                <button type="button" onclick="clearFilters();" class="btn btn-outline-secondary">
                                    <iconify-icon icon="mdi:filter-remove"></iconify-icon> Clear
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Table Card -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if(!empty($payables) && count($payables) > 0)
                        <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                            <table id="staffPaymentTable" class="table table-centered table-bordered table-nowrap mb-0">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Name</th>
                                        <th>Branch</th>
                                        <th class="text-end text-primary">Basic Salary</th>
                                        <th class="text-end text-primary overtime-total-cell">Total Overtime</th>
                                        <th class="text-end text-primary">Salary (Excl. OT)</th>
                                        <th class="text-end text-primary">Salary Type</th>
                                        <th>Commission Mode</th>
                                        <th class="text-end">Income Generated</th>
                                        <th class="text-end">Service Commission</th>
                                        <th class="text-end">Retail Commission</th>
                                        
                                        @php $allowance_list=0; @endphp
                                        @foreach($allowances as $allowance)
                                            <th class="text-end" id="{{ $allowance->id_allowances }}">
                                                {{ $allowance->allowance_name }}
                                                @php $allowance_list++; @endphp
                                            </th>
                                        @endforeach
                                        
                                        <th class="text-end">Miscellaneous</th>
                                        <th class="text-end">Reimbursements</th>
                                        <th class="text-end text-success">Provident Fund 'Employer'</th>
                                        <th class="text-end text-danger">Deduction Absents</th>
                                        <th class="text-end text-danger">Deduction Late</th>
                                        <th class="text-end text-danger">Provident Fund 'Employee'</th>
                                        <th class="text-end text-danger">Tax Deduction</th>
                                        <th class="text-end text-danger">Other Deduction</th>
                                        <th class="text-end text-danger">Loan Deduction</th>
                                        <th class="text-end text-success">Total Payable (Excl. OT)</th>
                                        <th class="text-end text-danger">Total Deductions</th>
                                        <th class="text-end text-primary">Final Payable (Incl. OT)</th>
                                        <th class="text-end text-primary">Decimal Adjustment</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                
                                <tbody>
                                    @php 
                                        $x=1; 
                                        $totalpayable=0; 
                                        $grandTotalPayable = 0;
                                        $grandTotalDeductions = 0;
                                        $grandTotalFinal = 0;
                                        $grandTotalAdjustment = 0;
                                        $grandTotalOTAmount = 0;
                                        $grandTotalBasicSalary = 0;
                                        $grandTotalSalaryWithoutOT = 0;
                                        $grandTotalPayableWithoutOT = 0;
                                    @endphp
                                    @foreach($payables as $payable)
                                    @php
                                        $rowId = $payable['id_staff'] ?? $x;
                                        $salaryType = $payable['staff_salary_type'] ?? 'monthly';
                                        $presentDays = $payable['Present'] ?? 0;
                                        $workHours = $payable['WorkHours'] ?? 0;
                                        $basicSalary = $payable['calculated_salary'] ?? 0;
                                        
                                        // Overtime data
                                        $totalOTAmount = $payable['total_overtime_amount'] ?? 0;
                                        $salaryWithoutOT = $basicSalary;
                                        $salaryWithOT = $basicSalary + $totalOTAmount;
                                        
                                        // Calculate allowance total
                                        $allowance_total = 0;
                                        $allowance_amounts = [];
                                        if(isset($payable['allowances'])) {
                                            foreach($payable['allowances'] as $allowance) {
                                                $allowance_total += $allowance['allowance_amount'] ?? 0;
                                                $allowance_amounts[$allowance['entity_name']] = $allowance['allowance_amount'] ?? 0;
                                            }
                                        }
                                        
                                     
                                            // Use the calculated PF from calculateStaffMonthPayables
                                        $employeePF = $payable['provident_fund']  / 2;
                                        $employerPF = $payable['provident_fund']  / 2;
                                        
                                        // Calculate totals
                                        $serviceCommission = $payable['service_commission'] ?? 0;
                                        $retailCommission = $payable['retail_commission'] ?? 0;
                                        $absentDeduction = $payable['absent_deduction'] ?? 0;
                                        $lateDeduction = $payable['late_deduction'] ?? 0;
                                        $taxDeduction = $payable['salary_monthly_tax'] ?? 0;
                                        $loanDeduction = $payable['loan_deduction'] ?? 0;
                                        
                                        // Get miscellaneous and other deductions
                                        $miscellaneous = 0;
                                        $reimbursements = 0;
                                        $otherDeduction = 0;
                                        
                                        // Calculate row totals WITHOUT overtime for Total Payable
                                        $tr_payable_without_ot = $salaryWithoutOT + $serviceCommission + $retailCommission + $allowance_total + $miscellaneous + $reimbursements;
                                        $tr_deductions = $absentDeduction + $lateDeduction + $employeePF + $taxDeduction + $otherDeduction + $loanDeduction;
                                        
                                        // Calculate final payable WITH overtime
                                        $tr_final_payable_with_ot = $tr_payable_without_ot - $tr_deductions + $totalOTAmount;
                                        
                                        // Update grand totals
                                        $grandTotalPayableWithoutOT += $tr_payable_without_ot;
                                        $grandTotalDeductions += $tr_deductions;
                                        $grandTotalFinal += floor($tr_final_payable_with_ot);
                                        $grandTotalAdjustment += ($tr_final_payable_with_ot - floor($tr_final_payable_with_ot));
                                        $grandTotalOTAmount += $totalOTAmount;
                                        $grandTotalBasicSalary += $basicSalary;
                                        $grandTotalSalaryWithoutOT += $salaryWithoutOT;
                                        
                                        $totalpayable += floor($tr_final_payable_with_ot);
                                    @endphp
                                    
                                    <tr id="row_{{ $rowId }}">
                                        <td key="staff_id" type="ignore" name="id_staff" onclick="updatetotal({{ $rowId }});">
                                            {{ $rowId }}
                                        </td>
                                        
                                        <td key="staff_fullname" type="ignore" name="staff_name">
                                            {{ $payable['staff_fullname'] ?? 'N/A' }}
                                        </td>
                                        
                                        <td key="business_name" type="ignore" name="business_name">
                                            {{ $payable['business_name'] ?? ($business->business_name ?? 'N/A') }}
                                        </td>

                                        <td key="basic_salary" type="ignore" name="basic_salary" class="text-end">
                                            <span class="basic-salary-amount">{{ number_format($basicSalary, 2) }}</span>
                                        </td>
                                        
                                        <td key="total_overtime_amount" type="ignore" name="overtime_total" class="text-end overtime-total-cell">
                                            <span class="overtime-amount">{{ number_format($totalOTAmount, 2) }}</span>
                                        </td>
                                        
                                        <td key="staff_salary" type="add" name="salary" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            class="text-end text-primary">
                                            <span class="salary-amount">{{ number_format($salaryWithoutOT, 2) }}</span>
                                        </td>
                                        
                                        <td key="staff_salary_type" type="ignore" name="staff_salary_type" class="text-end">
                                            <span class="badge bg-info">{{ ucfirst($salaryType) }}</span>
                                        </td>
                                        
                                        <td type="ignore" name="commission_mode">
                                            <span class="badge bg-secondary">{{ $payable['commission_mode'] ?? 'N/A' }}</span>
                                        </td>
                                        
                                        <td type="ignore" name="income" class="text-end">
                                            {{ number_format($payable['service_income'] + $payable['retail_income'] ?? 0, 2) }}
                                        </td>
                                        
                                        <td key="service_commission" type="add" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="commission" class="text-end">
                                            <span class="commission-amount">{{ number_format($serviceCommission, 2) }}</span>
                                        </td>
                                        
                                        <td key="retail_commission" type="add" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="retail_commission" class="text-end">
                                            <span class="retail-commission-amount">{{ number_format($retailCommission, 2) }}</span>
                                        </td>
                                        
                                        @foreach($allowances as $a)
                                            @php 
                                                $allowance_amount = $allowance_amounts[$a->entity_name] ?? 0;
                                            @endphp
                                            
                                            <td key="{{ $a->entity_name }}" type="add" 
                                                staff_salary_type="{{ $salaryType }}" 
                                                presents="{{ $presentDays }}" 
                                                workhours="{{ $workHours }}" 
                                                name="{{ $a->allowance_name }}" class="text-end">
                                                <span class="allowance-amount">{{ number_format($allowance_amount, 2) }}</span>
                                            </td>
                                        @endforeach
                                        
                                        <td key="miscellanous" type="add_input" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="miscellaneous" class="text-end">
                                            <span class="hidden" id="me_span_{{ $rowId }}">0.00</span>
                                            <input onchange="updatetotal({{ $rowId }}); $('#me_span_{{ $rowId }}').html($(this).val());" 
                                                style="text-align: right; width:80px; border:1px solid #ddd; padding: 2px;" 
                                                class="text-primary decimal form-control-sm" 
                                                id="miscellaneous_{{ $rowId }}" 
                                                name="miscellaneous" type="number" min="0" value="0" step="0.01">
                                        </td>
                                        
                                        <td key="reimbursements" type="add_input" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="reimbursements" class="text-end">
                                            <span class="hidden" id="r_span_{{ $rowId }}">0.00</span>
                                            <input onchange="updatetotal({{ $rowId }}); $('#r_span_{{ $rowId }}').html($(this).val());" 
                                                style="text-align: right; width:80px; border:1px solid #ddd; padding: 2px;" 
                                                class="text-primary decimal form-control-sm" 
                                                id="reimbursements_{{ $rowId }}" 
                                                name="reimbursements" type="number" min="0" value="0" step="0.01">
                                        </td>
                                        
                                        <td key="provident_fund_employer" type="ignore" name="pf_employer" class="text-end">
                                            <span class="pf-employer-amount">{{ number_format($employerPF, 2) }}</span>
                                        </td>
                                        
                                        <td key="deduction_absent" type="subtract" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="absent" class="text-end">
                                            <span class="absent-deduction-amount">{{ number_format($absentDeduction, 2) }}</span>
                                        </td>
                                        
                                        <td key="deduction_late" type="subtract" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="late" class="text-end">
                                            <span class="late-deduction-amount">{{ number_format($lateDeduction, 2) }}</span>
                                        </td>
                                        
                                        <td key="provident_fund_employee" type="subtract" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="pf_employee" class="text-end">
                                            <span class="pf-employee-amount">{{ number_format($employeePF, 2) }}</span>
                                        </td>
                                        
                                        <td key="tax_deduction" type="subtract" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="tax" class="text-end">
                                            <span class="tax-deduction-amount">{{ number_format($taxDeduction, 2) }}</span>
                                        </td>
                                        
                                        <td key="other_deduction" type="subtract_input" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="other_deduction" class="text-end">
                                            <span class="hidden" id="od_span_{{ $rowId }}">0.00</span>
                                            <input onchange="updatetotal({{ $rowId }}); $('#od_span_{{ $rowId }}').html($(this).val());" 
                                                style="text-align: right; width:80px; border:1px solid #ddd; padding: 2px;" 
                                                class="text-primary decimal form-control-sm" 
                                                id="other_deduction_{{ $rowId }}" 
                                                name="other_deduction" type="number" min="0" value="0" step="0.01">
                                        </td>
                                        
                                        <td key="loan_deduction" type="subtract_input" 
                                            staff_salary_type="{{ $salaryType }}" 
                                            presents="{{ $presentDays }}" 
                                            workhours="{{ $workHours }}" 
                                            name="loan_deduction" class="text-end">
                                            <span class="hidden" id="ld_span_{{ $rowId }}">{{ number_format($loanDeduction, 2) }}</span>
                                            <input onchange="updatetotal({{ $rowId }}); $('#ld_span_{{ $rowId }}').html($(this).val());" 
                                                style="text-align: right; width:80px; border:1px solid #ddd; padding: 2px;" 
                                                class="text-primary decimal form-control-sm" 
                                                id="loan_deduction_{{ $rowId }}" 
                                                name="loan_deduction" type="number" min="0" value="{{ $loanDeduction }}" step="0.01">
                                        </td>
                                        
                                        <td key="total_payable_without_ot" type="ignore" name="total_payable_without_ot" style="font-weight: bold;" 
                                            class="text-end text-success" id="payable_{{ $rowId }}">
                                            {{ number_format($tr_payable_without_ot, 2) }}
                                        </td>
                                        
                                        <td key="total_deductions" type="ignore" name="total_deductions" style="font-weight: bold;" 
                                            class="text-end text-danger" id="deductions_{{ $rowId }}">
                                            {{ number_format($tr_deductions, 2) }}
                                        </td>
                                        
                                        <!-- Final Payable WITH Overtime -->
                                        <td key="final_payable_with_ot" type="ignore" name="final_payable" style="font-weight: bold;" 
                                            class="text-end text-primary" id="total_payable_{{ $rowId }}">
                                            {{ floor($tr_final_payable_with_ot) }}
                                        </td>
                                        
                                        <td key="rounded_adjustment" type="ignore" name="rounded_adjustment" style="font-weight: bold;" 
                                            class="text-end text-primary" id="rounded_adjustment_{{ $rowId }}">
                                            {{ number_format($tr_final_payable_with_ot - floor($tr_final_payable_with_ot), 2) }}
                                        </td>
                                        
                                        <td type="ignore">
                                            <div class="filter-buttons d-flex gap-1">
                                                <a class="btn btn-sm btn-primary rounded-circle btn-icon" target="_blank" 
                                                    href="{{ route('hrm.staff_attendance_report', [
                                                            'staff' => $rowId,
                                                            'month' => $month,
                                                            'year' => $year,
                                                            'view' => 'detail',
                                                            'business_id' => $businessId
                                                    ]) }}">
                                                    <iconify-icon icon="mdi:calendar-check" class="fs-22"></iconify-icon>
                                                </a>
                                               <a class="btn btn-sm btn-primary rounded-circle btn-icon" target="_blank" 
                                                    href="{{ route('hrm.commission_breakdown', [
                                                            'staffId' => $rowId,
                                                            'businessId' => $businessId,
                                                            'year' => $year,
                                                            'month' => $month
                                                    ]) }}" title="View Commission Breakdown">
                                                    <iconify-icon icon="mdi:percent-box" class="fs-22"></iconify-icon>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    @php $x++; @endphp
                                    @endforeach
                                </tbody>
                                
                                <tfoot>
                                    <tr>
                                        <th colspan="3" class="text-end"><strong>Grand Totals:</strong></th>
                                        <th class="text-end text-primary"><strong>{{ number_format($grandTotalBasicSalary, 2) }}</strong></th>
                                        <th class="text-end text-primary overtime-total-cell"><strong>{{ number_format($grandTotalOTAmount, 2) }}</strong></th>
                                        <th class="text-end text-primary"><strong>{{ number_format($grandTotalSalaryWithoutOT, 2) }}</strong></th>
                                        <th class="text-end"></th>
                                        <th></th>
                                        <th class="text-end"><strong>{{ number_format(($payable['service_income'] + $payable['retail_income'] ?? 0) * ($x-1), 2) }}</strong></th>
                                        <th class="text-end"><strong>{{ number_format($serviceCommission * ($x-1), 2) }}</strong></th>
                                        <th class="text-end"><strong>{{ number_format($retailCommission * ($x-1), 2) }}</strong></th>
                                        @foreach($allowances as $allowance)
                                            @php
                                                $allowanceTotal = 0;
                                                if(isset($allowance_amounts[$allowance->entity_name])) {
                                                    $allowanceTotal = $allowance_amounts[$allowance->entity_name] * ($x-1);
                                                }
                                            @endphp
                                            <th class="text-end"><strong>{{ number_format($allowanceTotal, 2) }}</strong></th>
                                        @endforeach
                                        <th class="text-end"><strong>0.00</strong></th>
                                        <th class="text-end"><strong>0.00</strong></th>
                                        <th class="text-end text-success"><strong>{{ number_format($employerPF * ($x-1), 2) }}</strong></th>
                                        <th class="text-end text-danger"><strong>{{ number_format($absentDeduction * ($x-1), 2) }}</strong></th>
                                        <th class="text-end text-danger"><strong>{{ number_format($lateDeduction * ($x-1), 2) }}</strong></th>
                                        <th class="text-end text-danger"><strong>{{ number_format($employeePF * ($x-1), 2) }}</strong></th>
                                        <th class="text-end text-danger"><strong>{{ number_format($taxDeduction * ($x-1), 2) }}</strong></th>
                                        <th class="text-end text-danger"><strong>0.00</strong></th>
                                        <th class="text-end text-danger"><strong>{{ number_format($loanDeduction * ($x-1), 2) }}</strong></th>
                                        <th class="text-end text-success"><strong>{{ number_format($grandTotalPayableWithoutOT, 2) }}</strong></th>
                                        <th class="text-end text-danger"><strong>{{ number_format($grandTotalDeductions, 2) }}</strong></th>
                                        <th id="grand_total" class="text-end text-primary"><strong>{{ number_format($grandTotalFinal, 2) }}</strong></th>
                                        <th class="text-end text-primary"><strong>{{ number_format($grandTotalAdjustment, 2) }}</strong></th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div class="mb-3">
                                <iconify-icon icon="mdi:calculator-off" class="text-muted" style="font-size: 48px;"></iconify-icon>
                            </div>
                            <h4 class="text-muted">No Payment Data Available</h4>
                            <p class="text-muted">Please select staff, month, and year filters and click "Calculate" to generate payment data.</p>
                            @if($staffId > 0)
                            <div class="mt-3">
                                <p class="text-danger">
                                    <iconify-icon icon="mdi:alert-circle"></iconify-icon> 
                                    No payment data found for the selected staff in {{ $monthName }}-{{ $year }}
                                </p>
                            </div>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
@vite(['resources/js/app.js'])
<script>
    function applyRoundingOnLoad() {
        $('#staffPaymentTable tbody tr').each(function () {
            var rowId = $(this).attr('id');
            if (!rowId) return;

            var staffId = rowId.replace('row_', '');
            updatetotal(staffId);
        });
    }
    function updateVoucherDateToLastDay() {
        var month = $('#monthSelect').val();
        var year = $('#yearSelect').val();
        
        if (month && year) {
            var lastDay = new Date(year, month, 0).getDate();
            var voucherDate = year + '-' + month.toString().padStart(2, '0') + '-' + lastDay.toString().padStart(2, '0');
            $('#account_voucher_date').val(voucherDate);

            var fp = $("#account_voucher_date")[0]._flatpickr;
            if (fp) {
                fp.setDate(voucherDate, true);
            }
        }
    }
    
   



    $(document).ready(function() {
        var initialMonth = $('#monthSelect').val();
        var initialYear = $('#yearSelect').val();
        if (initialMonth && initialYear) {
            var initialLastDay = new Date(initialYear, initialMonth, 0).getDate();
            var initialVoucherDate = initialYear + '-' + initialMonth.toString().padStart(2, '0') + '-' + initialLastDay.toString().padStart(2, '0');
            
            flatpickr("#account_voucher_date", {
                dateFormat: "Y-m-d",
                defaultDate: initialVoucherDate
            });
            
            $('#account_voucher_date').val(initialVoucherDate);
        } else {
            flatpickr("#account_voucher_date", {
                dateFormat: "Y-m-d",
                defaultDate: "{{ date('Y-m-d') }}"
            });
        }
        updateVoucherDateToLastDay();
        $('#monthSelect, #yearSelect').on('change', function() {
            updateVoucherDateToLastDay();
        });

        $(".numeric").keypress(function(e) {
            if (e.which != 13 && e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
                return false;
            }
        });

        $(".decimal").keypress(function(e) {
            if (e.which != 13 && e.which != 8 && e.which != 0 && e.which != 46 && (e.which < 48 || e.which > 57)) {
                return false;
            }
        });

        $(".select2").each(function() {
            $(this).select2({
                width: '100%',
                dropdownParent: $(this).closest('.card-body'),
                placeholder: 'Select Staff',
                allowClear: true
            });
        });

        function checkStaffSelection() {
            var staffSelect = $('#staff_id');
            var calculateBtn = $('#calculateBtn');
            
            if (staffSelect.val() === '') {
                calculateBtn.prop('disabled', true);
            } else {
                calculateBtn.prop('disabled', false);
            }
        }
        checkStaffSelection();

        $('#staff_id').on('change', function() {
            checkStaffSelection();
        });

        if ($('#staffPaymentTable').length && $('#staffPaymentTable tbody tr').length > 0) {
            var table = $('#staffPaymentTable').DataTable({
                scrollX: true,
                scrollY: "400px",
                scrollCollapse: true,
                fixedHeader: {
                    header: true,
                    footer: false
                },
                paging: false,
                info: false,
                searching: false,
                ordering: false,
                responsive: false,
                lengthChange: false,
                dom: 'Bfrtip',
                buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
                drawCallback: function () {
                    applyRoundingOnLoad();
                }
            });
             applyRoundingOnLoad();
        }

        // Update staff list when business changes (for HO users)
        window.updateStaffList = function() {
            var businessId = $('#business_id').val();
            if (businessId) {
                // Destroy existing Select2 instance properly
                var staffSelect = $('#staff_id');
                if (staffSelect.hasClass('select2-hidden-accessible')) {
                    staffSelect.select2('destroy');
                }
                
                // Clear and add default option
                staffSelect.empty().append('<option value="">Select Staff</option>');
                
                $.ajax({
                    url: '{{ route("hrm.get_staff_by_business") }}',
                    type: 'GET',
                    data: {
                        business_id: businessId
                    },
                    success: function(response) {
                        if (response.success && response.staff.length > 0) {
                            response.staff.forEach(function(staff) {
                                staffSelect.append('<option value="' + staff.id_staff + '">' + staff.staff_fullname + '</option>');
                            });
                            
                            // Reinitialize select2 with proper settings
                            staffSelect.select2({
                                width: '100%',
                                dropdownParent: staffSelect.closest('.col-md-3'),
                                placeholder: 'Select Staff',
                                allowClear: true
                            });
                            
                            // Check selection after reload
                            checkStaffSelection();
                        } else {
                            // Reinitialize even if no staff
                            staffSelect.select2({
                                width: '100%',
                                dropdownParent: staffSelect.closest('.col-md-3'),
                                placeholder: 'Select Staff',
                                allowClear: true
                            });
                        }
                    },
                    error: function() {
                        toastr.error('Error loading staff list', 'Error!');
                        // Reinitialize even on error
                        staffSelect.select2({
                            width: '100%',
                            dropdownParent: staffSelect.closest('.col-md-3'),
                            placeholder: 'Select Staff',
                            allowClear: true
                        });
                        checkStaffSelection();
                    }
                });
            } else {
                // If no business selected, reset staff dropdown
                var staffSelect = $('#staff_id');
                if (staffSelect.hasClass('select2-hidden-accessible')) {
                    staffSelect.select2('destroy');
                }
                staffSelect.empty().append('<option value="">Select Staff</option>');
                
                // Reinitialize
                staffSelect.select2({
                    width: '100%',
                    dropdownParent: staffSelect.closest('.col-md-3'),
                    placeholder: 'Select Staff',
                    allowClear: true
                });
                checkStaffSelection();
            }
        };

        // Clear filters function
        window.clearFilters = function() {
            $('#staff_id').val('').trigger('change');
            $('#monthSelect').val('{{ date("n") }}');
            $('#yearSelect').val('{{ date("Y") }}');
            $('#account_voucher_date').val('{{ date("Y-m-d") }}');
             updateVoucherDateToLastDay();
            @if(session('ho') === 'Yes')
            $('#business_id').val('').trigger('change');
            @endif
            
            checkStaffSelection();
        };
    });

    function create_vouchers() {
        $("#btn_create").attr("disabled", "disabled");
        
        var TableData = storeOTblValues();
        TableData = JSON.stringify(TableData);
        
        if($("#account_voucher_date").val() == '') {
            toastr.error('Select the Date you want the vouchers to be created on', 'Info!');
            $("#btn_create").removeAttr("disabled");
            return false;
        }
        
        if (TableData.length > 2) {
            $.ajax({
                type: "POST",
                url: '{{ route("hrm.check_payable") }}',
                data: {
                    _token: '{{ csrf_token() }}',
                    month: '{{ $month }}',
                    year: '{{ $year }}',
                    voucher_date: $("#account_voucher_date").val(),
                    TableData: TableData
                },
                success: function(data) {
                    $("#btn_create").removeAttr("disabled");
                    if(data.success) {
                        if(data.has_warnings) {
                            // Show success with warnings in modal
                            Swal.fire({
                                icon: 'warning',
                                title: 'Success with Warnings!',
                                html: '<div>' + data.message + '</div>' +
                                    '<div class="text-start mt-3">' +
                                    '<h6>Warnings:</h6>' +
                                    '<div style="max-height: 200px; overflow-y: auto; font-size: 0.9rem;">' +
                                    data.warnings.map(warning => 
                                        '<div class="mb-1"><i class="ri-alert-line me-2"></i>' + warning + '</div>'
                                    ).join('') +
                                    '</div>' +
                                    '</div>',
                                customClass: {
                                    confirmButton: "btn btn-warning me-2"
                                },
                                showCloseButton: true,
                            });
                        } else {
                            // Show simple success
                            Swal.fire({
                                icon: 'success',
                                title: 'Success!',
                                text: data.message,
                                customClass: {
                                    confirmButton: "btn btn-success me-2"
                                },
                            });
                        }
                        
                        // Refresh the page after successful creation
                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    } else {
                        // Show errors in modal
                        let errorHtml = '<div class="text-danger">' + data.message + '</div>';
                        
                        if(data.errors && data.errors.length > 0) {
                            errorHtml += '<div class="text-start mt-3">' +
                                        '<h6>Details:</h6>' +
                                        '<div style="max-height: 200px; overflow-y: auto; font-size: 0.9rem;">' +
                                        data.errors.map(error => 
                                            '<div class="mb-1"><i class="ri-error-warning-line me-2 text-danger"></i>' + error + '</div>'
                                        ).join('') +
                                        '</div>' +
                                        '</div>';
                        }
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Error!',
                            html: errorHtml,
                            customClass: {
                                confirmButton: "btn btn-danger me-2"
                            },
                            showCloseButton: true,
                        });
                    }
                },
                error: function(xhr) {
                    $("#btn_create").removeAttr("disabled");
                    var errorMsg = xhr.responseJSON && xhr.responseJSON.message ? xhr.responseJSON.message : 'Error creating vouchers';
                    var errorDetails = '';
                    
                    if(xhr.responseJSON && xhr.responseJSON.errors) {
                        errorDetails = '<div class="text-start mt-3">' +
                                    '<h6>Details:</h6>' +
                                    '<div style="max-height: 200px; overflow-y: auto; font-size: 0.9rem;">' +
                                    xhr.responseJSON.errors.map(error => 
                                        '<div class="mb-1"><i class="ri-error-warning-line me-2 text-danger"></i>' + error + '</div>'
                                    ).join('') +
                                    '</div>' +
                                    '</div>';
                    }
                    
                    Swal.fire({
                        icon: 'error',
                        title: 'Error!',
                        html: '<div>' + errorMsg + '</div>' + errorDetails,
                        customClass: {
                            confirmButton: "btn btn-danger me-2"
                        },
                        showCloseButton: true,
                    });
                }
            });
        } else {
            $("#btn_create").removeAttr("disabled");
            toastr.error('No data to create vouchers', 'Error!');
        }
    }

    function storeOTblValues() {
        var TableData = [];
        
        $('#staffPaymentTable tbody tr').each(function() {
            var row = $(this);
            var rowData = {};
            
            // Get all cells with key attribute
            row.find('td[key]').each(function() {
                var cell = $(this);
                var key = cell.attr('key');
                var type = cell.attr('type');
                
                if (key && key !== '') {
                    if (type === 'add_input' || type === 'subtract_input') {
                        var inputVal = cell.find('input').val();
                        rowData[key] = inputVal ? parseFloat(inputVal) : 0;
                    } else {
                        var cellText = cell.find('span').first().text() || cell.text();
                        cellText = cellText.trim().replace(/,/g, '');
                        rowData[key] = cellText ? parseFloat(cellText) : 0;
                    }
                }
            });
            
            // Get overtime amount - IMPORTANT: Send to backend
            var overtimeCell = row.find('td[key="total_overtime_amount"]');
            if (overtimeCell.length) {
                var overtimeText = overtimeCell.find('span').text().trim().replace(/,/g, '');
                rowData['total_overtime_amount'] = overtimeText ? parseFloat(overtimeText) : 0;
            }
            
            // Get adjustment amount
            var adjustmentCell = row.find('td[key="rounded_adjustment"]');
            if (adjustmentCell.length) {
                var adjustmentText = adjustmentCell.text().trim().replace(/,/g, '');
                rowData['adjustment_amount'] = adjustmentText ? parseFloat(adjustmentText) : 0;
            }
            
            // Get the actual payable (before rounding)
            var finalPayableActual = row.find('input[name="final_payable_actual"]').val();
            if (finalPayableActual) {
                rowData['final_payable_actual'] = parseFloat(finalPayableActual);
            }
            
            // Get the rounded payable
            var finalPayableRounded = row.find('td[key="final_payable_with_ot"]').text().trim().replace(/,/g, '');
            if (finalPayableRounded) {
                rowData['final_payable'] = parseFloat(finalPayableRounded);
            }
            
            // Add essential fields
            var staffId = row.find('td[key="staff_id"]').text().trim();
            var staffName = row.find('td[key="staff_fullname"]').text().trim();
            var businessName = row.find('td[key="business_name"]').text().trim();
            
            if (staffId) {
                rowData['staff_id'] = staffId;
            }
            if (staffName) {
                rowData['staff_fullname'] = staffName;
            }
            if (businessName) {
                rowData['business_name'] = businessName;
            }
            
            // Add salary fields - Note: 'staff_salary' now contains salary WITHOUT overtime
            rowData['staff_salary'] = row.find('td[key="staff_salary"]').find('span.salary-amount').text().trim().replace(/,/g, '') || 0;
            rowData['basic_salary'] = row.find('td[key="basic_salary"]').find('span.basic-salary-amount').text().trim().replace(/,/g, '') || 0;
            rowData['total_overtime_amount'] = row.find('td[key="total_overtime_amount"]').find('span.overtime-amount').text().trim().replace(/,/g, '') || 0;
            rowData['service_commission'] = row.find('td[key="service_commission"]').find('span.commission-amount').text().trim().replace(/,/g, '') || 0;
            rowData['retail_commission'] = row.find('td[key="retail_commission"]').find('span.retail-commission-amount').text().trim().replace(/,/g, '') || 0;
            rowData['provident_fund_employer'] = row.find('td[key="provident_fund_employer"]').find('span.pf-employer-amount').text().trim().replace(/,/g, '') || 0;
            rowData['provident_fund_employee'] = row.find('td[key="provident_fund_employee"]').find('span.pf-employee-amount').text().trim().replace(/,/g, '') || 0;
            rowData['deduction_absent'] = row.find('td[key="deduction_absent"]').find('span.absent-deduction-amount').text().trim().replace(/,/g, '') || 0;
            rowData['deduction_late'] = row.find('td[key="deduction_late"]').find('span.late-deduction-amount').text().trim().replace(/,/g, '') || 0;
            rowData['tax_deduction'] = row.find('td[key="tax_deduction"]').find('span.tax-deduction-amount').text().trim().replace(/,/g, '') || 0;
            rowData['loan_deduction'] = row.find('td[key="loan_deduction"]').find('input').val() || row.find('td[key="loan_deduction"]').find('span').text().trim().replace(/,/g, '') || 0;
            rowData['other_deduction'] = row.find('td[key="other_deduction"]').find('input').val() || 0;
            rowData['miscellanous'] = row.find('td[key="miscellanous"]').find('input').val() || 0;
            rowData['reimbursements'] = row.find('td[key="reimbursements"]').find('input').val() || 0;
            rowData['total_deductions'] = row.find('td[key="total_deductions"]').text().trim().replace(/,/g, '') || 0;
            
            if (Object.keys(rowData).length > 0) {
                TableData.push(rowData);
            }
        });
        
        return TableData;
    }

    function updatetotal(id_staff) {
        var row = $('#row_' + id_staff);
        if (!row.length) return;
        
        var payables_without_ot = 0;
        var deductions = 0;
        var overtime_amount = 0;
        
        // Get overtime amount (NOT included in payables calculation)
        var overtime_cell = row.find('td[key="total_overtime_amount"]');
        overtime_amount = parseFloat(overtime_cell.find('span').text().replace(/,/g, '')) || 0;
        // This excludes the "total_overtime_amount" column from calculations
        // The salary cell contains salary WITHOUT overtime
        row.find('td[type="add"]').each(function() {
            var cell = $(this);
            var cellValue = parseFloat(cell.find('span').first().text().replace(/,/g, '')) || 0;
            payables_without_ot += cellValue;
        });
        
        row.find('td[type="add_input"]').each(function() {
            var cell = $(this);
            var inputValue = parseFloat(cell.find('input').val()) || 0;
            payables_without_ot += inputValue;
        });
        
        row.find('td[type="subtract"]').each(function() {
            var cell = $(this);
            var cellValue = parseFloat(cell.find('span').first().text().replace(/,/g, '')) || 0;
            deductions += cellValue;
        });
        
        row.find('td[type="subtract_input"]').each(function() {
            var cell = $(this);
            var inputValue = parseFloat(cell.find('input').val()) || 0;
            deductions += inputValue;
        });
        
        // Round all calculations to 2 decimal places
        payables_without_ot = Math.round(payables_without_ot * 100) / 100;
        deductions = Math.round(deductions * 100) / 100;
        
        // Calculate final payable WITH overtime added after deductions
        var total_before_rounding = payables_without_ot - deductions + overtime_amount;
        total_before_rounding = Math.round(total_before_rounding * 100) / 100;
        
        // === MATCHING INVOICE PAGE ROUNDING LOGIC ===
        var decimal_part = total_before_rounding - Math.floor(total_before_rounding);
        decimal_part = Math.round(decimal_part * 100) / 100;
        
        var final_payable_rounded = 0;
        var adjustment_value = 0;
        
        if (decimal_part >= 0.5) {
            adjustment_value = 1 - decimal_part;
            final_payable_rounded = Math.ceil(total_before_rounding);
        } else {
            adjustment_value = -decimal_part;
            final_payable_rounded = Math.floor(total_before_rounding);
        }
        
        adjustment_value = Math.round(adjustment_value * 100) / 100;
        
        // Update display
        $('#payable_' + id_staff).text(payables_without_ot.toFixed(2));
        $('#deductions_' + id_staff).text(deductions.toFixed(2));
        $('#total_payable_' + id_staff).text(final_payable_rounded.toFixed(2));
        $('#rounded_adjustment_' + id_staff).text(adjustment_value.toFixed(2));
        
        // Store values for backend - including overtime amount separately
        if (!row.find('input[name="final_payable_actual"]').length) {
            row.append('<input type="hidden" name="final_payable_actual" value="' + total_before_rounding + '">');
            row.append('<input type="hidden" name="final_payable_rounded" value="' + final_payable_rounded + '">');
            row.append('<input type="hidden" name="overtime_amount" value="' + overtime_amount + '">');
        } else {
            row.find('input[name="final_payable_actual"]').val(total_before_rounding);
            row.find('input[name="final_payable_rounded"]').val(final_payable_rounded);
            row.find('input[name="overtime_amount"]').val(overtime_amount);
        }
        
        updateGrandTotal();
    }

    function updateGrandTotal() {
        var grand_total = 0;
        $('td[key="final_payable"]').each(function() {
            var value = parseFloat($(this).text().replace(/,/g, '')) || 0;
            grand_total += value;
        });
        
        grand_total = Math.round(grand_total * 100) / 100;
        $("#grand_total").text(grand_total.toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ","));
    }
</script>
@endsection