@extends('layouts.horizontal', ['title' => 'Yearly Attendance Report', 'topbarTitle' => 'Yearly Attendance Report'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/dropzone/dist/dropzone.css',
'node_modules/select2/dist/css/select2.min.css',
'node_modules/flatpickr/dist/flatpickr.min.css'])
<style>
    .card-background {
        background: #f8f9fa;
        border-radius: 10px;
        padding: 15px;
        margin-bottom: 15px;
        border: 1px solid #e9ecef;
    }
    .table-card {
        background: white;
        border-radius: 8px;
        overflow: hidden;
        box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    .table-card .table {
        margin-bottom: 0;
    }
    .table-card .table thead th {
        background-color: #f1f5f9;
        border-bottom: 2px solid #dee2e6;
        position: sticky;
        top: 0;
        z-index: 10;
    }
    .month-cell {
        cursor: pointer;
        transition: background-color 0.2s;
        min-width: 160px;
        padding: 10px 5px !important;
    }
    .month-cell:hover {
        background-color: rgba(13, 110, 253, 0.08) !important;
    }
    .totals-row {
        background-color: #e9ecef !important;
        font-weight: bold;
    }
    
    /* BIGGER BADGES WITH BLACK TEXT FOR BETTER VISIBILITY */
    .attendance-badge {
        padding: 8px 12px !important;
        font-size: 13px !important;
        font-weight: 700 !important;
        border-radius: 6px !important;
        margin: 3px 0 !important;
        text-align: center;
        display: block;
        width: 100%;
        color: #000000 !important; /* Black text for maximum visibility */
        border: 2px solid;
    }
    
    .present-badge {
        background-color: rgba(25, 135, 84, 0.25) !important;
        border-color: #198754 !important;
    }
    .absent-badge {
        background-color: rgba(220, 53, 69, 0.25) !important;
        border-color: #dc3545 !important;
    }
    .late-badge {
        background-color: rgba(13, 110, 253, 0.25) !important;
        border-color: #0d6efd !important;
    }
    .leave-badge {
        background-color: rgba(255, 193, 7, 0.25) !important;
        border-color: #ffc107 !important;
    }
    .holiday-badge {
        background-color: rgba(13, 202, 240, 0.25) !important;
        border-color: #0dcaf0 !important;
    }
    .overtime-badge {
        background-color: rgba(111, 66, 193, 0.25) !important;
        border-color: #6f42c1 !important;
    }
    
    /* Hours display */
    .hours-display {
        font-size: 13px !important;
        font-weight: 800 !important;
        padding: 6px 8px !important;
        border-radius: 5px !important;
        margin: 4px 0 !important;
        background-color: rgba(0, 0, 0, 0.05);
        border: 1px solid #dee2e6;
        text-align: center;
    }
    .work-hours {
        color: #198754 !important;
        background-color: rgba(25, 135, 84, 0.15) !important;
        border-color: #198754 !important;
    }
    .overtime-hours {
        color: #fd7e14 !important;
        background-color: rgba(253, 126, 20, 0.15) !important;
        border-color: #fd7e14 !important;
    }
    
    /* Fixed columns */
    .fixed-column {
        position: sticky;
        left: 0;
        background: white;
        z-index: 5;
        min-width: 220px;
        padding: 12px 15px !important;
    }
    .fixed-column-header {
        position: sticky;
        left: 0;
        background: #f1f5f9;
        z-index: 20;
        min-width: 220px;
        padding: 12px 15px !important;
    }
    
    /* Table styling */
    .table-bordered {
        border: 1px solid #dee2e6;
    }
    .table-bordered th, .table-bordered td {
        border: 1px solid #dee2e6;
        vertical-align: middle !important;
    }
    .month-header {
        background-color: #f8f9fa;
        font-weight: 700;
        font-size: 14px;
        padding: 10px 5px !important;
    }
    .year-total-cell {
        background-color: #e7f1ff;
        min-width: 180px;
        padding: 12px 10px !important;
    }
    
    
    
    /* Staff row styling */
    .staff-info {
        background-color: #f8f9fa;
        border-left: 4px solid #0d6efd;
    }
    .staff-info:hover {
        background-color: rgba(13, 110, 253, 0.05) !important;
    }
    
    /* Badge container */
    .badge-container {
        display: flex;
        flex-direction: column;
        gap: 8px;
        width: 100%;
    }
    
    /* Totals styling */
    .grand-total-badge {
        padding: 10px 14px !important;
        font-size: 14px !important;
        font-weight: 800 !important;
        margin: 5px 0 !important;
    }
    
    /* Footer styling - hidden since we removed footer */
    .footer-cell {
        background-color: #e9ecef !important;
        font-weight: 700;
        padding: 12px 5px !important;
    }
    
    /* Responsive adjustments */
    @media (max-width: 1400px) {
        .month-cell {
            min-width: 140px;
        }
        .fixed-column, .fixed-column-header {
            min-width: 200px;
        }
    }
    
    /* Pagination styling */
    .dataTables_paginate {
        margin-top: 15px !important;
    }
    
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 6px 12px !important;
        margin: 0 2px !important;
        border-radius: 4px !important;
    }
    
    /* Remove footer totals styling */
    #yearlyDataFooter {
        display: none;
    }
</style>
@endsection
@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-sm-12">
           <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2>Yearly Attendance Report</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if($isHoUser)
    <div class="row mb-3">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="d-flex align-items-center justify-content-between gap-3">
                                <div class="flex-grow-1">
                                    <label class="form-label">Select Business</label>
                                    <select class="form-control" id="businessSelector">
                                        <option value="">All Businesses (HO Accounts)</option>
                                        @foreach($businesses as $biz)
                                            <option value="{{ $biz->id_business }}" 
                                                {{ (session('business_id') == $biz->id_business) ? 'selected' : '' }}>
                                                {{ $biz->business_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div>
                                    <button onclick="exportToExcel()" class="btn btn-outline-success">
                                        <iconify-icon icon="mdi:microsoft-excel"></iconify-icon> Export Excel
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @else
    <div class="row mb-3">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-end">
                        <button onclick="exportToExcel()" class="btn btn-outline-success">
                            <iconify-icon icon="mdi:microsoft-excel"></iconify-icon> Export Excel
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
    
    <!-- Filters Section -->
    <div class="row mb-3">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <form id="yearlyFilterForm" method="GET">
                        <div class="row">
                            <!-- Hidden business_id field for filtering -->
                            <input type="hidden" name="business_id" id="filter_business_id" value="{{ session('business_id') }}">
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Staff</label>
                                    <select class="form-control select2" name="staff" id="staffSelect">
                                        <option value="0">All Staff</option>
                                        @foreach($staffList as $staffItem)
                                            <option value="{{ $staffItem->id_staff }}" 
                                                {{ $staffId == $staffItem->id_staff ? 'selected' : '' }}>
                                                {{ $staffItem->staff_fullname }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Year</label>
                                    <select class="form-select" name="year" id="yearSelect">
                                        @php
                                            $currentYear = date('Y');
                                            $startYear = 2020;
                                        @endphp
                                        @for($y = $currentYear; $y >= $startYear; $y--)
                                            <option value="{{ $y }}" 
                                                {{ $year == $y ? 'selected' : ($y == date('Y') && !request()->has('year') ? 'selected' : '') }}>
                                                {{ $y }}
                                            </option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Report Table -->
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="yearlyAttendanceTable" class="table table-bordered table-hover" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th class="fixed-column-header text-center" rowspan="2">
                                        <div class="d-flex flex-column">
                                            <span>Staff Name</span>
                                            <small class="header-text">ID & Month</small>
                                        </div>
                                    </th>
                                    <th class="text-center" rowspan="2">Business</th>
                                    <th class="text-center" rowspan="2">Salary Type</th>
                                    @for($i = 1; $i <= 12; $i++)
                                        <th class="text-center month-header">{{ date('M', mktime(0, 0, 0, $i, 1)) }}</th>
                                    @endfor
                                    <th class="text-center year-total-cell" rowspan="2">
                                        <div class="d-flex flex-column">
                                            <span>Year Total</span>
                                            <small class="header-text">P/A/Hours</small>
                                        </div>
                                    </th>
                                </tr>
                                <tr>
                                    @for($i = 1; $i <= 12; $i++)
                                        <th class="text-center small text-muted">
                                            <div class="header-text">Present/Absent/Late</div>
                                        </th>
                                    @endfor
                                </tr>
                            </thead>
                            <tbody id="yearlyDataBody">
                                <!-- Data will be loaded via DataTables -->
                            </tbody>
                            <!-- Footer removed as requested -->
                        </table>
                    </div>
                    
                    <!-- Pagination will be handled by DataTables -->
                    <div class="row mt-3">
                        <div class="col-sm-12 col-md-5">
                            <div class="dataTables_info" id="yearlyAttendanceTable_info" role="status" aria-live="polite"></div>
                        </div>
                        <div class="col-sm-12 col-md-7">
                            <div class="dataTables_paginate paging_simple_numbers" id="yearlyAttendanceTable_paginate">
                                <!-- Pagination will be inserted here by DataTables -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function exportToExcel() {
        var table = document.getElementById('yearlyAttendanceTable');
        var tableClone = table.cloneNode(true);
        
        $(tableClone).find('.select2-container, .select2-selection, .select2-search__field, .select2-dropdown').remove();
        $(tableClone).find('[style*="position: sticky"]').removeAttr('style');
        $(tableClone).find('[onclick]').removeAttr('onclick');
        $(tableClone).find('[class*="badge"]').each(function() {
            $(this).replaceWith($('<span>').text($(this).text()));
        });
        
        $(tableClone).find('iconify-icon').each(function() {
            $(this).remove();
        });
        
        try {
            var wb = XLSX.utils.table_to_book(tableClone, {sheet: "Yearly Attendance"});
            XLSX.writeFile(wb, `Yearly_Attendance_${$('#yearSelect').val()}_${new Date().toISOString().split('T')[0]}.xlsx`);
        } catch (e) {
            var html = tableClone.outerHTML;
            var blob = new Blob([html], {type: 'application/vnd.ms-excel'});
            var url = URL.createObjectURL(blob);
            var link = document.createElement('a');
            link.download = `Yearly-Attendance-${$('#yearSelect').val()}-${new Date().toISOString().split('T')[0]}.xls`;
            link.href = url;
            link.click();
        }
    }
    $(document).ready(function() {
        let dataTable;
        
        // Initialize DataTable
        function initializeDataTable() {
            if (dataTable) {
                dataTable.destroy();
                $('#yearlyDataBody').empty();
            }
            
            dataTable = $('#yearlyAttendanceTable').DataTable({
                processing: true,
                serverSide: true,
                searching: true,
                ordering: true,
                paging: true,
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
                ajax: {
                    url: "{{ route('hrm.get_yearly_attendance_data') }}",
                    type: 'POST',
                    data: function(d) {
                        // Add custom parameters to DataTables request
                        d.business_id = $('#filter_business_id').val();
                        d.staff_id = $('#staffSelect').val();
                        d.year = $('#yearSelect').val();
                        d._token = "{{ csrf_token() }}";
                    },
                    error: function(xhr, error, thrown) {
                        console.error('DataTables error:', error);
                        console.error('Response:', xhr.responseText);
                    }
                },
                columns: [
                    {
                        data: null,
                        name: 'staff_name',
                        orderable: true,
                        searchable: true,
                        render: function(data, type, row, meta) {
                            return `
                                <div class="d-flex flex-column">
                                    <span class="text-primary mb-1 fw-bold">${row.staff_fullname}</span>
                                    <small class="text-muted">ID: ${row.id_staff}</small>
                                    <small class="text-info mt-1">${row.salary_type}</small>
                                </div>
                            `;
                        }
                    },
                    {
                        data: 'business_name',
                        name: 'business_name',
                        orderable: true,
                        searchable: true,
                        render: function(data) {
                            return `<div class="fw-semibold">${data}</div>`;
                        }
                    },
                    {
                        data: 'salary_type',
                        name: 'salary_type',
                        orderable: true,
                        searchable: true,
                        render: function(data) {
                            return `<span class="badge bg-primary p-2 fw-bold">${data}</span>`;
                        }
                    },
                    // Month columns will be dynamically created
                    ...Array.from({length: 12}, (_, i) => {
                        const monthNumber = i + 1;
                        return {
                            data: null,
                            name: `month_${monthNumber}`,
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row, meta) {
                                const monthData = row.months && row.months[monthNumber] ? row.months[monthNumber] : null;
                                if (!monthData) return '';
                                
                                return createMonthCellContent(monthData, row, monthNumber);
                            }
                        };
                    }),
                    {
                        data: null,
                        name: 'year_total',
                        orderable: false,
                        searchable: false,
                        render: function(data, type, row, meta) {
                            return createYearTotalCell(row);
                        }
                    }
                ],
                createdRow: function(row, data, dataIndex) {
                    $(row).addClass('staff-info');
                    
                    // Make fixed column sticky
                    $(row).find('td:first-child').addClass('fixed-column');
                },
                initComplete: function() {
                    // Adjust column widths after initialization
                    this.api().columns.adjust();
                },
                drawCallback: function() {
                    // Adjust column widths on each draw
                    this.api().columns.adjust();
                },
                language: {
                    processing: '<div class="spinner-border text-primary" role="status"><span class="visually-hidden">Loading...</span></div>',
                    emptyTable: 'No attendance data found for the selected criteria',
                    info: 'Showing _START_ to _END_ of _TOTAL_ staff',
                    infoEmpty: 'Showing 0 to 0 of 0 staff',
                    infoFiltered: '(filtered from _MAX_ total staff)',
                    lengthMenu: 'Show _MENU_ staff',
                    loadingRecords: 'Loading...',
                    zeroRecords: 'No matching staff found',
                    paginate: {
                        first: 'First',
                        last: 'Last',
                        next: 'Next',
                        previous: 'Previous'
                    },
                    search: 'Search Staff:'
                }
            });
        }
        
        // Helper functions for rendering
        function formatNumber(num) {
            return parseFloat(num).toFixed(2);
        }
        
        function createBadge(type, text, isLarge = false) {
            return `<span class="attendance-badge ${type}-badge ${isLarge ? 'grand-total-badge' : ''}">${text}</span>`;
        }
        
        function createHoursDisplay(hours, type = 'work') {
            return `<div class="hours-display ${type === 'work' ? 'work-hours' : 'overtime-hours'}">${formatNumber(hours)}h${type === 'overtime' ? ' OT' : ''}</div>`;
        }
        
        function createMonthCellContent(monthData, row, monthNumber) {
            const detailUrl = monthData.detail_url || 
                `{{ route('hrm.staff_attendance_report', ['staff' => 'STAFF_ID', 'month' => 'MM', 'year' => 'YYYY']) }}`
                    .replace('STAFF_ID', row.id_staff)
                    .replace('MM', monthNumber.toString().padStart(2, '0'))
                    .replace('YYYY', $('#yearSelect').val());
            
            let content = `<div class="badge-container" onclick="window.location.href='${detailUrl}'" 
                style="cursor: pointer;" 
                title="Click to view ${monthData.month_name} ${row.staff_fullname} details\nPresent: ${monthData.present}\nAbsent: ${monthData.absent}\nLate: ${monthData.late}">`;
            
            // Present
            if (monthData.present > 0) {
                content += createBadge('present', `P: ${monthData.present}`);
            }
            
            // Absent
            if (monthData.absent > 0) {
                content += createBadge('absent', `A: ${monthData.absent}`);
            }
            
            // Late
            if (monthData.late > 0) {
                content += createBadge('late', `L: ${monthData.late}`);
            }
            
            // Work hours
            if (monthData.work_hours > 0) {
                content += createHoursDisplay(monthData.work_hours, 'work');
            }
            
            content += '</div>';
            return content;
        }
        
        function createYearTotalCell(row) {
            const totals = row.yearly_totals || {};
            let content = '<div class="badge-container">';
            
            // Present total
            if (totals.present > 0) {
                content += createBadge('present', `Present: ${totals.present}`, true);
            }
            
            // Absent total
            if (totals.absent > 0) {
                content += createBadge('absent', `Absent: ${totals.absent}`, true);
            }
            
            // Work hours total
            if (totals.work_hours > 0) {
                content += createHoursDisplay(totals.work_hours, 'work');
            }
            
            // Overtime total
            if (totals.overtime_hours > 0) {
                content += createHoursDisplay(totals.overtime_hours, 'overtime');
            }
            
            content += '</div>';
            return content;
        }
        
        // Export function
 
        
        // Initialize select2
        $('#staffSelect').select2({
            width: '100%',
            placeholder: 'Select Staff',
            allowClear: true
        });
        
        $('#businessSelector').select2({
            width: '100%',
            placeholder: 'Select Business'
        });
        
        // Business selector change event
        $('#businessSelector').on('change', function() {
            const businessId = $(this).val();
            $('#filter_business_id').val(businessId);
            
            // Load staff based on business
            $.ajax({
                url: "{{ route('hrm.get_staff_by_business') }}",
                type: 'GET',
                data: { business_id: businessId },
                success: function(response) {
                    if (response.success) {
                        const staffSelect = $('#staffSelect');
                        staffSelect.empty();
                        staffSelect.append('<option value="0">All Staff</option>');
                        
                        $.each(response.staff, function(index, staff) {
                            staffSelect.append(`<option value="${staff.id_staff}">${staff.staff_fullname}</option>`);
                        });
                        
                        staffSelect.val('0').trigger('change');
                        staffSelect.select2({
                            width: '100%',
                            placeholder: 'Select Staff',
                            allowClear: true
                        });
                        
                        // Refresh DataTable with new business filter
                        if (dataTable) {
                            dataTable.ajax.reload();
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error loading staff:', error);
                    alert('Error loading staff data');
                }
            });
        });
        
        // Filter change events
        $('#staffSelect, #yearSelect').on('change', function() {
            if (dataTable) {
                dataTable.ajax.reload();
            }
        });
        
        // Initialize DataTable
        initializeDataTable();
    });
</script>
@endsection