@extends('layouts.horizontal', ['title' => 'Invoice', 'topbarTitle' => 'View Invoice', 'nonav' => true])

@section('css')
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body" >
                <!-- Invoice Logo-->
                <div class="d-flex align-items-start justify-content-between mb-4">
                    <div>
                        <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                            <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>     
                        <div class="mt-2">                            
                            <h6 class="fs-14 mb-0 lh-base font-monospace"> {!! $invoice[0]->business_address !!} </h6>
                            <h6 class="fs-14 mb-2 font-monospace">Phone: {{ $invoice[0]->business_phone }}</h6>
                        </div>   
                         <div style="text-align: left;" class="mt-3">
                            <h6 class="fs-14 fw-bolder mb-0 font-monospace">{{ $invoice[0]->customer_name }}</h6>
                            <abbr class="fs-14 mb-2 font-monospace">{{ $invoice[0]->customer_cell }}</abbr>
                         </div>                
                    </div>
                    <div class="text-end">                        
                        @if($checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number)
                            @if($invoice[0]->invoice_status == 'valid')
                            <span class="badge bg-success-subtle text-success px-1 fs-12 mb-3  font-monospace">{{ $checkquery->invoice_status }}</span>
                            @else
                            <span class="badge bg-danger-subtle text-danger px-1 fs-20 mb-3  font-monospace">{{ $checkquery->invoice_status }}</span>
                            @endif   

                            <h6 class="m-0 fw-bolder fs-20 font-monospace">Recovery</h6>
                            <h3 class="fs-14 mb-0 lh-base font-monospace">Ref: #{{ $checkquery->reference_invoice_number }}</h3>
                            <h3 class="{{ $business->invoicenumber == 'No' ? 'd-print-none' : '' }} m-0 fw-bolder fs-20 font-monospace">Invoice: #{{ $checkquery->invoice_number }}</h3>

                            <div style="text-align: left;" class="mt-3">
                                <h6 style="font-size:14px !important;" class="{{ $business->invoicenumber == 'No' ? 'd-print-none' : '' }} m-0 fs-20 font-monospace">Visit: #{{ $checkquery->visit_id }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">ID: {{ $checkquery->id_invoice }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Date: {{ $checkquery->invoice_date_formatted }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Time: {{ $checkquery->invoice_time }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Payment: {{ $checkquery->payment_mode }}</h6>
                                @if($checkquery->instrument_number != '' && $checkquery->instrument_number != null)
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Instrument#: {{ $checkquery->instrument_number }}</h6>
                                @endif
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Agent: {{ $checkquery->created_by }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Type: {{ $checkquery->invoice_type == 'service' ? 'Service' : 'Retail' }}</h6>
                            </div>
                        
                        
                        @else

                            @if($invoice[0]->invoice_status == 'valid')
                            <span class="badge bg-success-subtle text-success px-1 fs-12 mb-3  font-monospace">{{ $invoice[0]->invoice_status }}</span>
                            @else
                            <span class="badge bg-danger-subtle text-danger px-1 fs-20 mb-3  font-monospace">{{ $invoice[0]->invoice_status }}</span>
                            @endif
                            <h3 class="{{ $business->invoicenumber == 'No' ? 'd-print-none' : '' }} m-0 fw-bolder fs-20 font-monospace">Invoice: #{{ $invoice[0]->invoice_number }}</h3>

                            <div style="text-align: left;" class="mt-3">
                                <h6 style="font-size:14px !important;" class="{{ $business->invoicenumber == 'No' ? 'd-print-none' : '' }} m-0 fs-20 font-monospace">Visit: #{{ $invoice[0]->visit_id }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">ID: {{ $invoice[0]->id_invoice }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Date: {{ $invoice[0]->invoice_date_formatted }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Time: {{ $invoice[0]->invoice_time }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Payment: {{ $invoice[0]->payment_mode }}</h6>
                                @if($invoice[0]->instrument_number != '' && $invoice[0]->instrument_number != null)
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Instrument#: {{ $invoice[0]->instrument_number }}</h6>
                                @endif
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Agent: {{ $invoice[0]->created_by }}</h6>
                                <h6 style="font-size:14px !important;" class="m-0 fs-20 font-monospace">Type: {{ $invoice[0]->invoice_type == 'service' ? 'Service' : 'Retail' }}</h6>
                            </div>
                        @endif
                        
                    </div>
                </div>

                <div class="mt-4">
                    <div class="table">
                        <table class="table text-left align-middle mb-0 font-monospace" style="overflow-x: hidden;">
                            <thead>
                                <tr class="bg-light bg-opacity-50">
                                    <th class="border-0" scope="col" style="width: 50px;">#</th>
                                    
                                    
                                    @if($invoice[0]->invoice_type=='sale')
                                        <th class="hidden-xs d-print-none text-start border-0" scope="col">Brand</th>
                                        <th class="text-start border-0" scope="col">Item</th>
                                        <th class="hidden-xs d-print-none border-0" scope="col">Sold By</th>
                                        <th class="hidden-xs d-print-none border-0" scope="col">Batch</th>
                                        <th class="text-end border-0" scope="col">Unit</th>
                                        <th class="text-end border-0" scope="col">Qty.</th>
                                          
                                    @elseif($invoice[0]->invoice_type=='service')
                                        <th class="text-start border-0" scope="col">Item</th>
                                        <th class="text-start border-0 border-0" scope="col">Discription</th>
                                        <th class="hidden-xs d-print-none border-0" scope="col">Staff</th>
                                        <th class="hidden-xs d-print-none border-0" scope="col">Requested</th>
                                        <th class="hidden-xs d-print-none border-0" scope="col">Recipe</th>
                                        <th class="hidden-xs d-print-none text-end border-0" scope="col">Addition</th>
                                    @endif
                                      
                                    <th class="text-end border-0" scope="col">Discount</th>                                    
                                    <th class="text-end border-0" scope="col" class="text-end">Total</th>
                                    @if($invoice[0]->invoice_type=='sale' && ($checkquery->reference_invoice_number == '' || null == $checkquery->reference_invoice_number))
                                        <th class="hidden-xs d-print-none text-end border-0" scope="col">Tax</th>                                    
                                        <th class="hidden-xs d-print-none text-end border-0" scope="col" class="text-end">Final</th>
                                    @endif
                                </tr>
                            </thead>
                            <tbody id="services-list">
                                @php
                                    $counter = 1; $total_discounted_price=0;
                                @endphp
                                @foreach($invoice as $item)
                                <tr>
                                    <th scope="row">{{ $counter }}</th>
                                    
                                    @if($invoice[0]->invoice_type=='sale')
                                        <td class="d-print-none text-start">{{ $item->brand_name }}</td>
                                        <td>{{ $item->product_name }}</td>
                                        <td class="hidden-xs d-print-none">{!! $item->staff_names !!}</td>
                                        <td class="hidden-xs d-print-none">{{ $item->batch_id .'|' .$item->batch_number }}</td>
                                        <td class="text-end border-0">{{ number_format((float)$item->price + ((float)$item->dservice_addition), 2, '.', '') }}</td>
                                        <td class="text-end border-0">{{ $item->invoice_qty }}</td>
                                        
                                    @elseif($invoice[0]->invoice_type=='service')
                                        <td class="text-start">{{ $item->dservice_type }}</td>
                                        <td>{{ $item->dservice_name }}</td>
                                        <td class="hidden-xs d-print-none">{!! $item->staff_names !!}</td>
                                        <td class="hidden-xs d-print-none">{{ $item->requested }}</td>
                                        <td class="hidden-xs d-print-none">{!! $item->invoice_products !!}</td>
                                        <td class="hidden-xs d-print-none text-end">{{ number_format((float)$item->dservice_addition, 2, '.', '') }}</td>
                                    @endif
                                    
                                    <td class="text-end">{{ number_format((float)$item->dservice_discount, 2, '.', '') }}</td>                                    
                                    @if($invoice[0]->invoice_type=='sale')
                                        <td class="text-end">{{ number_format((float)$item->ddiscounted_price, 2, '.', '') }}</td>
                                    @else
                                    <td class="text-end">{{ number_format((float)$item->ddiscounted_price + (float)$item->dservice_addition, 2, '.', '') }}</td>
                                    @endif
                                    @php 
                                        $total_discounted_price = $total_discounted_price + (float)$item->ddiscounted_price;
                                    @endphp
                                    @if($invoice[0]->invoice_type=='sale' && ($checkquery->reference_invoice_number == '' || null == $checkquery->reference_invoice_number))
                                        <td class="hidden-xs d-print-none text-end">{{ number_format((float)$item->dtaxes, 2, '.', '') }}</td>                                    
                                        <td class="hidden-xs d-print-none text-end">{{ number_format((float)$item->final_price, 2, '.', '') }}</td>
                                    @endif
                                </tr>
                                @php
                                    $counter++;
                                @endphp
                                @endforeach
                            </tbody>
                        </table>                   
                    </div>

                    <div>
                        <table class="table table-nowrap align-middle mb-0 ms-auto font-monospace" style="width:335px">
                            <tbody>         
                                <tr>
                                    
                                    @if($invoice[0]->invoice_type == 'sale')
                                    <td class="fw-bolder">Value before Tax </td>
                                    <td class="text-end fw-bolder">{{ $total_discounted_price != null ? config('constants.CURRENCY') . ' ' . number_format($total_discounted_price, 2) : config('constants.CURRENCY') . ' 0.00' }}</td>
                                    @elseif($invoice[0]->invoice_type == 'service')
                                    <td class="fw-bolder">SubTotal </td>
                                    <td class="text-end fw-bolder">{{ $invoice[0]->sub_total != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->sub_total, 2) : config('constants.CURRENCY') . ' 0.00' }}</td>
                                    @endif
                                </tr>
                                @if($invoice[0]->invoice_type == 'service' && $invoice[0]->idiscount != null && $invoice[0]->idiscount != 0)
                                <tr>
                                    <td class="fw-medium">Discount </td>
                                    <td class="text-end">{{   $invoice[0]->idiscount != null ? config('constants.CURRENCY') . ' -' . number_format($invoice[0]->idiscount, 2) : '0.00'  }}</td>
                                </tr>
                                @endif
                                @if($invoice[0]->invoice_type == 'service' && $invoice[0]->other_charges != null && $invoice[0]->other_charges != 0)
                                <tr>
                                    <td class="fw-medium">Other Charges </td>
                                    <td class="text-end">{{  $invoice[0]->other_charges != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->other_charges, 2) : '0.00'  }}</td>
                                </tr>
                                @endif
                                @if($invoice[0]->tax_total != null && (float)$invoice[0]->tax_total > 0)
                                <tr>
                                    @if($invoice[0]->invoice_type == 'service')
                                    <td class="fw-bolder">Value Exclusive of Tax </td>                                   
                                    <td class="text-end fw-bolder">{{  $invoice[0]->gross_wo_tax != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->gross_wo_tax, 2) : '0.00'  }}</td>
                                    @endif
                                </tr>
                                
                                <tr>
                                    <td class="fw-medium">Amount of Sales Tax </td>
                                    <td class="text-end">{{ $invoice[0]->tax_total != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->tax_total, 2) : '0.00'  }}</td>
                                </tr>

                                <tr>
                                    <td class="fw-bolder">Value Inclusive of Tax </td>
                                    <td class="text-end fw-bolder">{{ $invoice[0]->gross_amount != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->gross_amount, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                @if (!empty($invoice[0]->other_charges) && $invoice[0]->invoice_type != 'service')
                                    <tr>
                                        <td class="fw-bolder">Other Charges </td>
                                        <td class="text-end fw-bolder">{{ $invoice[0]->other_charges != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->other_charges, 2) : '0.00' }}</td>
                                    </tr>
                                @endif
                                @if($invoice[0]->round_off != null && $invoice[0]->round_off != 0)
                                <tr>
                                    <td class="fw-medium">Round Off </td>
                                    <td class="text-end">{{ $invoice[0]->round_off != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->round_off, 2) : '0.00' }}</td> 
                                </tr>
                                @endif

                                @if($invoice[0]->icc_charge != null && $invoice[0]->icc_charge != 0)
                                 <tr>
                                    <td class="fw-medium">Card Fee </td>
                                    <td class="text-end">{{ $invoice[0]->icc_charge != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->icc_charge, 2) : '0.00' }}</td> 
                                </tr>
                                @endif
                                 @if($invoice[0]->cctip != null && $invoice[0]->cctip != 0)
                                 <tr>
                                    <td class="fw-medium">Tip Charged on Card </td>
                                    <td class="text-end">{{ $invoice[0]->cctip != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->cctip, 2) : '0.00' }}</td> 
                                </tr>
                                @endif
                                @if($invoice[0]->advance_amount != null && $invoice[0]->advance_amount > 0)
                                <tr>
                                    <td class="fw-medium">Advance Payment <small class="text-muted">(Paid)</small>
                                    </td>
                                    <td class="text-end">{{ $invoice[0]->advance_amount != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->advance_amount, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                <tr style="border-bottom: 2px dashed #000 !important; " class="border-top border-top-dashed fs-16">
                                    <td class="fw-bold">Total Payable</td>
                                    <td class="fw-bold text-end">{{ $invoice[0]->total_payable != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->total_payable, 2) : '0.00' }}</td>
                                </tr>


                                <!--Payment Section--> 
                                @if($invoice[0]->paid_amount != null && $invoice[0]->paid_amount > 0)                               
                                <tr class="border-top border-top-dashed fs-16">
                                    <td class="fw-medium">{{ $checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number ? 'Recovered' : 'Paid ' }} ({{ $invoice[0]->payment_mode }}) </td>
                                    <td class="fw-medium text-end">{{ $invoice[0]->paid_amount != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->paid_amount, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                @if($invoice[0]->retained_amount != null && $invoice[0]->retained_amount > 0)                               
                                <tr class="border-top border-top-dashed fs-16">
                                    <td class="fw-medium">{{ $checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number ? 'Retained' : 'Retained' }} ({{ $invoice[0]->payment_mode }}) </td>
                                    <td class="fw-medium text-end">{{ $invoice[0]->retained_amount != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->retained_amount, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                @if($invoice[0]->paid_voucher != null && $invoice[0]->paid_voucher > 0)
                                <tr class="border-top fs-16">
                                    <td class="fw-medium">{{ $checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number ? 'Recovered' : 'Used Voucher' }} </td>
                                    <td class="fw-medium text-end">{{ $invoice[0]->paid_voucher != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->paid_voucher, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                @if($invoice[0]->paid_loyalty != null && $invoice[0]->paid_loyalty > 0)
                                <tr class="border-top fs-16">
                                    <td class="fw-medium">{{ $checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number ? 'Recovered' : 'Used Loyalty' }} </td>
                                    <td class="fw-medium text-end">{{ $invoice[0]->paid_loyalty != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->paid_loyalty, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                               @if($invoice[0]->paid_retained != null && $invoice[0]->paid_retained > 0)
                                <tr class="border-top fs-16">
                                    <td class="fw-medium">{{ $checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number ? 'Recovered' : 'Used Retained ' }}  </td>
                                    <td class="fw-medium text-end">{{ $invoice[0]->paid_retained != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->paid_retained, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                               
                                @if($invoice[0]->returnamount != null && $invoice[0]->returnamount > 0)
                                <tr>
                                    <td class="fw-medium">Returned <small class="text-muted"></small>
                                    </td>
                                    <td class="text-end">{{ $invoice[0]->returnamount != null ? config('constants.CURRENCY') . ' ' .  number_format($invoice[0]->returnamount, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                @if($invoice[0]->balance != null && $invoice[0]->balance > 0)
                                <tr class="border-top border-top-dashed fs-16">
                                    <td class="fw-medium">{{ $checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number ? 'Recoverable' : 'Balance' }}
                                    </td>
                                    <td class="fw-medium text-end">{{ $invoice[0]->balance != null ? config('constants.CURRENCY') . ' ' . number_format($invoice[0]->balance, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                

                                @if($checkquery->reference_invoice_number != '' && null != $checkquery->reference_invoice_number)
                                @if($checkquery->cc_charge != null && $checkquery->cc_charge > 0)
                                <tr class="border-top border-top-dashed fs-16">
                                    <td class="fw-medium"> CC Fee </td>
                                    <td class="fw-medium text-end">{{ $checkquery->cc_charge != null ? config('constants.CURRENCY') . ' ' . number_format($checkquery->cc_charge, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                @if($checkquery->rounded_adjustment != null && $checkquery->rounded_adjustment > 0)
                                <tr class="border-top border-top-dashed fs-16">
                                    <td class="fw-medium"> Rounded Adjustment </td>
                                    <td class="fw-medium text-end">{{ $checkquery->rounded_adjustment != null ? config('constants.CURRENCY') . ' ' . number_format($checkquery->rounded_adjustment, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                                <tr class="border-top border-top-dashed fs-16">
                                    <td class="fw-medium"> Paid Amount </td>
                                    <td class="fw-medium text-end">{{ $checkquery->paid_amount != null ? config('constants.CURRENCY') . ' ' . number_format($checkquery->paid_amount, 2) : '0.00' }}</td>
                                </tr>
                                <tr class="border-top border-top-dashed fs-16">
                                    <td class="fw-medium"> Remaining </td>
                                    <td class="fw-medium text-end">{{ $checkquery->balance != null ? config('constants.CURRENCY') . ' ' . number_format($checkquery->balance, 2) : '0.00' }}</td>
                                </tr>
                                @endif
                            
                            </tbody>
                        </table>
                        <!--end table-->
                    </div>
                </div>

                <div class="card-body">
                    <div class="mt-4">
                        <p class=" justify-content-center pb-2  font-monospace">
                            <b>THANK YOU FOR YOUR VISIT!</b> It has been our pleasure to serve you, and we hope we see you again soon.
                        </p>

                        <!-- <div class="d-inline-block">
                            <img src=" {{ asset('images/png/signature.png') }}" alt="signature" height="32">
                            <h5 class="mb-0 mt-2">Authorized Sign</h5>
                        </div> -->
                    </div>
                    @if($business->invoice_terms == 'Yes')
                    <div class="bg-body p-2 rounded-2 mt-4 mb-4  font-monospace">
                        <p class="mb-0"><span class="fs-12 fw-bold text-uppercase">Terms : </span>
                        {!!  $business->payment_terms !!}
                        </p>
                    </div>
                    @endif

                    @if($invoice[0]->imsfiscal_invoice_number != null && $invoice[0]->imsfiscal_invoice_number != '')
                     <div class="mt-4">
                        
                        @if($business->imsfiscal == 'No')
                            <p class="mb-2 text-center pb-2  font-monospace"><img style="width:150px;"  src="{{ asset('images/pra_logo.png') }}" alt="PRA" /></p>
                            @php
                                $path = 'https://e.pra.punjab.gov.pk/IMSFiscalReport/SearchPOSInvoice_Report.aspx?PRAInvNo='.$invoice[0]->imsfiscal_invoice_number;
                            @endphp
                            <p class="mb-2 text-center pb-2">
                             {!! QrCode::size(150)->generate($path) !!}
                              </p>
                        @elseif($business->srb_fiscal_service == 'Yes')  
                            <p class="mb-2 text-center pb-2  font-monospace"><img style="width:150px;"  src="{{ asset('images/srb_logo.png') }}" alt="SRB" /></p>
                            @php
                                $path = 'https://pos.srb.gos.pk/InvoiceVerification/InvoiceStatus.jsp?invoiceVerification='.$invoice[0]->imsfiscal_invoice_number; 
                            @endphp
                            <p class="mb-2 text-center pb-2  font-monospace">
                            {!! QrCode::size(150)->generate($path) !!}
                             </p>
                        @endif
                       
                        @if($business->imsfiscal == 'Yes')
                            <p>PRA Invoice Number: </p>{{ $invoice[0]->imsfiscal_invoice_number }}
                        @elseif($business->srb_fiscal_service == 'Yes')  
                            <p>SRB Invoice Number:</p>{{ $invoice[0]->imsfiscal_invoice_number }}
                        @endif
                    </div> <!-- end card-body-->    
                        
                    @endif
                

                <div class="d-print-none mb-5">
                    <div class="d-flex justify-content-center gap-2">
                        <a href="javascript:window.print()" class="btn btn-primary"><i
                                class="ti ti-printer me-1"></i> Print</a>
                        <a href="javascript: void(0);" class="btn btn-secondary"><i class="ti ti-send me-1"></i>
                            Send</a>
                       
                    </div>
                </div>
                @if($invoice[0]->receipt_url != null && $invoice[0]->receipt_url != ''  )
                <div class="d-print-none mb-5 mt-4">
                    <div class="d-flex justify-content-center gap-2">
                        <a target="_blank" href="{{ $invoice[0]->receipt_url }}" class="link link-primary"><i class="ti ti-cell me-1"></i> View Digital Reciept</a>
                        <a target="_blank" href="{{ $invoice[0]->receipt_url }}" class="link link-secondary"><i class="ti ti-puzzle me-1"></i> Create Feed Back Link</a>
                    </div>
                </div>
                @endif
                <!-- end link -->
                
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
@endsection