@extends('layouts.horizontal', ['title' => 'Create Service Invoice', 'topbarTitle' => 'Create Invoice'])

@section('css')
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])
@endsection

@section('content')

<div class="row">
    <div class="col-12">
        <div class="card position-relative">
            <form>
                <div class="card-body">
                    <!-- Invoice Logo-->
                    <div class="d-flex align-items-start justify-content-between mb-4">
                        <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                            <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>

                        <div class="text-end">
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="invoiceNo"
                                        class="col-form-label fs-16 fw-bold">#INV</label>
                                </div>
                                <div class="col-auto">
                                    <input type="number" id="invoiceNo" class="form-control"
                                        placeholder="00001234">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3">
                            <div class="mb-2">
                                <label class="form-label">Invoice Date :</label>
                                <input type="text" data-provider="flatpickr" data-date-format="d M, Y"
                                    data-deafult-date="today" class="form-control"
                                    placeholder="Select Date">
                            </div> 
                            <div class="mb-2">
                                <label for="InvoicePaymentStatus" class="form-label">Payment Status</label>
                                <select class="form-select" id="InvoicePaymentStatus">
                                    <option value="">Select Status</option>
                                    <option value="Choice 1">Paid</option>
                                    <option value="Choice 2">Unpaid</option>
                                    <option value="Choice 3">Cancelled</option>
                                    <option value="Choice 4">Refunded</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <div class="mb-4">
                                <label class="form-label">Billing Address :</label>
                                <div class="mb-2 pb-1">
                                    <input type="text" id="BName" class="form-control" placeholder="Full Name" value="{{ $customer->customer_name }}">
                                </div>
                                <div class="mb-2 pb-1">
                                    <textarea type="text" id="BAddress" rows="3" class="form-control" placeholder="Address"  value="{{ null!==$customer->customer_address ? $customer->customer_address : $customer->customer_area }}"></textarea>
                                </div>
                                <div>
                                    <input type="text" id="BNumber" class="form-control" placeholder="Phone Number" value="{{ $customer->customer_cell }}">
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3">
                            <div class="mb-4">
                                <label class="form-label">Shipping Address :</label>
                                <div class="mb-2 pb-1">
                                    <input type="text" id="SName" class="form-control"
                                        placeholder="Full Name">
                                </div>
                                <div class="mb-2 pb-1">
                                    <textarea type="text" id="SAddress" rows="3" class="form-control"
                                        placeholder="Address"></textarea>
                                </div>
                                <div>
                                    <input type="text" id="SNumber" class="form-control"
                                        placeholder="Phone Number">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <div class="table-responsive">
                            <table class="table text-center table-nowrap align-middle mb-0">
                                <thead>
                                    <tr class="bg-light bg-opacity-50">
                                        <th scope="col" class="border-0" style="width: 70px;">...</th>
                                        <th scope="col" class="border-0" style="width: 70px;">#</th>
                                        <th scope="col" class="border-0 text-start" style="width: 140px">Item</th>
                                        <th scope="col" class="border-0" >Discription</th>
                                        <th scope="col" class="border-0" style="width: 140px;">Staff</th>
                                        <th scope="col" class="border-0" style="width: 240px">Requested</th>
                                        <th scope="col" class="border-0" style="width: 50px;">Discount Type</th>
                                        <th scope="col" class="border-0" style="width: 50px;">Discount</th>
                                        <th scope="col" class="border-0" style="width: 50px;">Addition</th>
                                        <th scope="col" class="border-0" style="width: 50px;">Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php 
                                        $subTotal=0; 
                                        $row = 1; 
                                    @endphp

                                    @foreach($visit_services as $service)
                                    <tr>
                                        <td>
                                            <button type="button"
                                                class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger">
                                                <iconify-icon icon="solar:trash-bin-trash-bold-duotone"class="fs-20"></iconify-icon>
                                            </button>
                                        </td>
                                        <th scope="row">{{ $row }}</th>

                                        <td class="text-start">
                                            {{ $service->s_type }}
                                        </td>
                                        <td class="text-start">
                                            {{ $service->service_name }}
                                        </td>
                                        <td class="text-start">
                                            {!! $service->staff !!}
                                        </td>
                                        <td>
                                            @if($service->requested = "Yes")
                                                <input class="form-check-input fs-16 text-primary" type="checkbox">
                                            @endif
                                        </td>
                                        <td>
                                            <select class="form-select" name="select-discount-type">
                                                <option value=""></option>
                                            </select>
                                        </td>
                                        <td>
                                            <input class="form-control decimal" name="input-discount" value="0.00">
                                        </td>
                                        <td>
                                            <input class="form-control decimal" name="input-addition" value="0.00">
                                        </td>
                                        <td>
                                            {{ $service->s_rate }}
                                        </td>
                                        
                                    </tr>
                                    @endforeach
                                    
                                </tbody>
                            </table><!--end table-->
                            
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="p-2">
                                    <button type="button" class="btn btn-primary"><i class="ti ti-circle-plus me-1"></i> Add Products</button>
                                </div>
                                <div>
                                    <label class="form-label" for="InvoiceNote"> Note : </label>
                                    <textarea class="form-control" id="InvoiceNote" placeholder="Thanks for your business " rows="3"></textarea>
                                </div>
                            </div>
                            <div class="col-6">
                                <table class="table table-sm table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:300px">
                                    <tbody>
                                        <tr>
                                            <td class="fw-medium">Subtotal</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productSubtotal"
                                                        class="form-control" placeholder="$0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Shipping</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productShipping"
                                                        class="form-control" placeholder="$0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Discount <small
                                                    class="text-muted">(10%)</small></td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productDiscount"
                                                        class="form-control" placeholder="$0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Tax <small
                                                    class="text-muted">(18%)</small></td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTaxes"
                                                        class="form-control" placeholder="$0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Amount</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalAmount" disabled
                                                        class="form-control" placeholder="$0.00">
                                                </div>
                                            </th>
                                        </tr>
                                    </tbody>
                                </table>
                            <!--end table-->
                            </div>
                        </div>
                    </div>
                    
                </div> <!-- end card-body-->
            </form>
        </div><!-- end card -->
        <div class="mb-5">
            <div class="d-flex justify-content-center gap-2">
                <a href="javascript:window.print()" class="btn btn-primary gap-1"><i class="ti ti-eye fs-16"></i> Preview</a>
                <a href="javascript: void(0);" class="btn btn-success gap-1"><i class="ti ti-device-floppy fs-16"></i> Save</a>
                <a href="javascript: void(0);" class="btn btn-info gap-1"><i class="ti ti-send fs-16"></i> Send Invoice</a>
            </div>
        </div>
        <!-- end buttons -->
    </div>
</div>

@endsection

@section('scripts')

@endsection