<!-- @php 
    echo '<pre>';
    print_r($invoice);
    echo '<pre>';
@endphp -->

@extends('layouts.horizontal', ['title' => 'Create Service Invoice', 'topbarTitle' => 'Create Invoice'])

@section('css')
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])
@endsection

@section('content')

<div class="row">
    <div class="col-12">
        <div class="card position-relative">
            <form>
                <div class="card-body">
                    <!-- Invoice Logo-->
                    <div class="d-flex align-items-start justify-content-between mb-4">
                        <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                            <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>    

                        <div class="text-end">
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="VisitNo" class="col-form-label fs-16 fw-bold">#RECOVERY FOR</label>
                                </div>
                                <div class="col-auto">
                                    <input type="number" id="originalInvoiceID" class="form-control border-0" readonly="readonly" placeholder="00001234" value="{{ $invoice->id_invoice }}">
                                    <input type="hidden" id="customerID" value="{{ $invoice->customer_id }}">
                                    
                                </div>
                            </div>
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label  class="col-form-label fs-16 fw-bold d-print-none">DATED</label>
                                </div>
                                <div class="col-auto">
                                    <input type="text" readonly="readonly" id="visitDate" class="form-control  border-0" placeholder="Select Date" value="{{ $invoice->invoice_date }}">
                                </div> 
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        
                        <div class="col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-0">
                            <div class="mb-2">
                                <label class="form-label">Billing Address :</label>
                                <div class="">
                                    <input type="text" id="BName" readonly="readonly" class="form-control  border-0" placeholder="Full Name" value="{{ $invoice->customer_name }}">
                                </div>
                                <div  class=""> 
                                    <input type="text" id="BNumber" readonly="readonly" class="form-control  border-0" placeholder="Phone Number" value="{{ $invoice->customer_cell }}">
                                </div>
                                <div class="d-print-none d-none">
                                    <textarea type="text" id="BAddress" readonly="readonly" rows="3" class="form-control  border-0" placeholder="Address"  >{{ '' != $invoice->customer_address ? $invoice->customer_address : $invoice->customer_area }}</textarea>
                                </div>                                
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3 d-print-none">                            
                        </div>
                       <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3 d-print-none">
                        </div>
                    </div>

                    <div class="mt-1">
                        <div class="table">
                            <table class="table text-center  mb-0" id="services_table">
                                <thead>
                                    <tr class="bg-light bg-opacity-50">
                                        <th scope="col" class="border-0 d-print-none" style="width: 30px;">...</th>
                                        <th scope="col" class="border-0 d-print-none" style="width: 30px;">#</th>
                                        <th scope="col" class="border-0 d-print-none text-start" style="width: 50px">Item</th>
                                        <th scope="col" class="border-0 text-start" style="width: 140px;">Discription</th>
                                        <th scope="col" class="border-0 text-start " style="width: 100px;">Staff</th>
                                        <th scope="col" class="border-0  d-print-none" style="width: 70px">Requested</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Discount Type</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Discount</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Addition</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php 
                                        $subTotal=0; 
                                        $row = 1; 
                                    @endphp

                                    @foreach($invoice_services as $service)
                                    <tr>
                                        
                                        <td scope="row" class="d-print-none">{{ $row }}</td>

                                        <td class="text-start d-print-none">
                                            {{ $service->service_type }}
                                        </td>
                                        <td class="text-start service" data-id-visit-services="{{ $service->id_invoice_details }}" data-id-service="{{ $service->service_id }}" data-service-price="{{ $service->price }}" data-service-flag="{{ $service->service_flag }}" data-service-type="{{ $service->service_type }}" data-service-category="{{ $service->service_category }}" >
                                            {{ $service->service_category }}
                                        </td>
                                        <td class="text-start service" data-id-visit-services="{{ $service->id_invoice_details }}" data-id-service="{{ $service->service_id }}" data-service-price="{{ $service->price }}" data-service-flag="{{ $service->service_flag }}" data-service-type="{{ $service->service_type }}" data-service-category="{{ $service->service_category }}" >
                                            {{ $service->service_name }}
                                        </td>
                                        <td class="text-start">
                                            {!! $service->staff !!}
                                        </td>
                                        <td class="d-print-none">                                            
                                             {{ $service->requested }}                                           
                                        </td>
                                        
                                        <td class="d-print-none">
                                            {{ $service->discount_type }}
                                        </td>
                                         <td class="d-print-none">
                                            {{ sprintf('%.2f', $service->discount) }}
                                        </td>
                                        <td class="d-print-none">
                                            {{ sprintf('%.2f', $service->addition) }}
                                        </td>
                                        <td class="d-print-none" id="service_price_{{ $service->id_invoice_details }}" data-s-rate="{{ $service->price }}">
                                            {{ sprintf('%.2f', $service->price) }}
                                        </td>
                                        @php 
                                            $subTotal = $subTotal + $service->price;
                                        @endphp 
                                    </tr>
                                    @php $row++ @endphp
                                    @endforeach
                                    
                                </tbody>
                            </table><!--end table-->
                            
                        </div>
                        <div class="row  d-print-none">
                            <div class="col-6 mt-4 d-print-none">
                                 <div>
                                    <label class="form-label" for="InvoiceNote"> Note : </label>
                                    <textarea class="form-control" id="InvoiceNote" placeholder="Any Information you need to save with the invoice . . . " rows="3"></textarea>
                                </div>
                            </div>
                            <div class="col-6">
                                <table class="table table-sm table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:300px">
                                    <tbody>
                                        <tr>
                                            <td class="fw-medium">Subtotal {{  config('constants.CURRENCY') }}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f', $subTotal) }}
                                                </div>
                                            </td>
                                        </tr>
                                        
                                        <tr>
                                            <td class="fw-medium">
                                                Discount
                                            </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' ,  $invoice->discount*-1) }}
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Other Charges </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' ,  $invoice->other_charges) }}
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Before Tax</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' ,  $invoice->gross_wo_tax) }}
                                                </div>
                                            </th>
                                        </tr>
                                        
                                        <tr  class="tax-item">
                                            <td class="fw-medium">Tax </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">                                                    
                                                    {{ sprintf('%.2f' , $invoice->tax_total) }}
                                                </div>
                                            </td>
                                        </tr>
                                        
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Amount</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' ,  $invoice->gross_amount) }}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">CC Fee </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' , $invoice->cc_charge) }}
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="">
                                            <td class="fw-medium">CC Tip </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' , $invoice->cc_tip) }}
                                                </div>
                                            </td>
                                        </tr>

                                        <tr class="{{ $invoice->pos_charge == '' || $invoice->pos_charge=='0' ? 'd-none' : '' }} POSCharges">
                                            <td class="fw-bold">POS Charges </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' , $invoice->pos_charge) }}
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Advance </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' , $invoice->advance_amount*-1) }}
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Rounding Adjustment </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    {{ sprintf('%.2f' , $invoice->rounding_adjustment) }}
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Payable</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                   {{ sprintf('%.2f' , $invoice->total_payable) }}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Paid Amount</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                   {{ sprintf('%.2f' , $invoice->paid_amount) }}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Recovered Amount</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                   {{ sprintf('%.2f' , $invoice->paid_earlier) }}
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="credit-card-item credit-card-fee-item d-none" id="ccfee_row">
                                            <td class="fw-medium">CC Fee </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productCCFee" data-cc-fee="{{ $business->cc_charge }}" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                         <tr class="credit-card-item d-none">
                                            <td class="fw-medium">Rounding Adjustment </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productAdjustment" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold fs-20">Reveivable</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalPayable" data-total-payable="{{ $invoice->balance }}" class="form-control fw-bold text-end" disabled  value="{{ sprintf('%.2f' , $invoice->balance) }}">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold fs-20">Paying Now</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="PayingNow"  class="form-control text-end" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none mixed-payment">
                                            <th scope="row" class="fw-bold text-success">Paid Cash</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingCash" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none mixed-payment">
                                            <th scope="row" class="fw-bold text-success">Paid Card</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingCard"  class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>                                        
                                        <tr class="fs-15 d-none loyalty">
                                            <th scope="row" class="fw-bold text-success">Loyalty Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingLoyalty" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none retainedamount">
                                            <th scope="row" class="fw-bold text-success">Retained Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingRetained" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none giftvoucher">
                                            <th scope="row" class="fw-bold text-success">Voucher Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingVoucher" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium  text-success">Return Cash</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="ReturnAmount" readonly="readonly" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                    <div class="form-checkbox-dark">
                                                        <input type="checkbox" class="form-check-input text-secondary me-1" id="retain"><label class="form-label label-sm" for="retain">Retain</label>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium text-danger">Balance</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="BalanceAmount" readonly="readonly" class="form-control text-end text-danger payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none instrument-number-item">
                                            <th scope="row" class="fw-medium border-1">Instrument # : </th>
                                            <th class="border-1 ">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" class="form-control" id="productInstrumentNumber" placeholder="xxxx" value="">     
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none gift-voucher-item">
                                            <th scope="row" class="fw-medium border-1">Verify Voucher# : </th>
                                            <th class="border-1 ">
                                                <div class="input-group ms-auto" class="d-flex" style="width: 160px;">
                                                    <input type="text" style="width:80px;" class="form-control" id="productGiftVoucher" placeholder="xxx" value="">  
                                                    <button type="button" style="width:50px;" onclick="verifyVoucher();" class="btn btn-sm btn-success">
                                                        <iconify-icon icon="solar:check-read-broken"class="fs-24"></iconify-icon>
                                                    </button>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium border-1">Payment Mode : </th>
                                            <th class="border-1 ">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <label><span id="selectedPaymentMode">Cash</span></label>     
                                                </div>
                                            </th>
                                        </tr>
                                    </tbody>
                                </table>
                            <!--end table-->

                            </div>
                        </div>
                    </div>
                    <div class="card-foorter d-print-none mt-4">
                        <div class="row">
                            <div class="col-4 text-success">
                                <span class="">Customer Retained Amount: {{ config('constants.CURRENCY') }} </span><span id="retained_amount" class="gap-1">{{ $retained_amount }}</span>
                                <button type="button" onclick="use_retained()" class="btn btn-light gap-1"><i class ="ti ti-moneybag fs-16"></i> Retained</button>
                            </div>
                            <div class="col-4 text-success">
                                <span class="">Loyalty Points: {{ config('constants.CURRENCY') }} </span><span data-loyalty-rate="{{ $business->l_point_discount }}" id="loyalty_points" class="gap-1">{{ $customer->loyalty_points }}</span>
                                <button type="button" onclick="redeem_loyalty();"  class="btn btn-light gap-1"><i class ="ti ti-affiliate fs-16"></i> Loyalty</button>
                            </div>
                            <div class="col-4 text-end">
                                <a href="javascript:window.print()"  type="button" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success">
                                    <iconify-icon icon="solar:printer-line-duotone"class="fs-24"></iconify-icon>
                                </a>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-info dropdown-toggle  gap-1" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class ="ti ti-cash-register fs-16"></i> Payment Mode</button>
                                    <div class="dropdown-menu">
                                        <a style="cursor:pointer" onclick="paymentModeChange('Cash');" class="dropdown-item">Cash</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Card');" class="dropdown-item">Card</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('D-Card');" class="dropdown-item">Debit Card</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Online');" class="dropdown-item">Online</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Check');" class="dropdown-item">Bank Transfer</a>
                                        <div class="dropdown-divider"></div>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Voucher');" class="dropdown-item">Gift Voucher</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Mixed');" class="dropdown-item">Mixed</a>                                        
                                    </div>
                                </div>
                                
                                <button type="button" onclick="GenerateInvoice();" class="btn btn-success gap-1"><i class="ti ti-device-floppy fs-16"></i> Save</button>
                            </div>
                        </div>

                    </div>
                </div> <!-- end card-body-->
            </form>
        </div><!-- end card -->
        
    </div>

    <div id="voucherHtml" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="voucherHtml" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-md" >
            <div class="modal-content">
                <div class="modal-header">                    
                    <h4 class="modal-title" id="custom-width-modalLabel">Voucher Verification</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="voucherRemainingServices">
                    <input type="hidden" id="voucherRemainingAmount">
                    <div id="voucher-details">

                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('scripts')
<script>

    let timer = null;

    document.getElementById("payingCard").onkeyup = function () {
        clearTimeout(timer); // cancel previous timer
        timer = setTimeout(() => {
            recalculate_totals();
        }, 1000); // 1 second delay
    };

    document.getElementById("PayingNow").onkeyup = function () {
        if($("#selectedPaymentMode").html() == "Cash"){
            recalculate_totals();
        } else {
            clearTimeout(timer); // cancel previous timer
            timer = setTimeout(() => {
                recalculate_totals();
            }, 1000); // 1 second delay
        }
    };

    $(document).ready(function() {
        // recalculate_totals();
        $("#PayingNow").focus();
    });

   

    function recalculate_totals(){
        let totalPayable = $("#productTotalPayable").attr("data-total-payable") != "" ? parseFloat($("#productTotalPayable").attr("data-total-payable")) : 0; 
        console.log("totalpayable:"+totalPayable);
        //CC items addition
        $(".credit-card-item").each(function(index, input){
            
            if($(this).hasClass('d-none')){
                // Do Nothing
            } else if($(this).find('input').attr("id") == "productCCFee"){                
                   
                if($("#selectedPaymentMode").html()=="Card" || $("#selectedPaymentMode").html()=="Mixed") {
                    console.log("ccfee " + $(this).find('input').attr("data-cc-fee")); 
                    
                    //check if cc charge is defined
                        let cc_charge = $(this).find('input').attr("data-cc-fee");
                        if(cc_charge != null && cc_charge != 'undefined'){
                            //Add cc charge if defined
                            if($('#PayingNow').val() != "" && parseFloat($('#PayingNow').val()) > 0){
                                console.log("PayingNow " + $("#PayingNow").val());
                                totalCCFee = parseFloat(cc_charge) * parseFloat($('#PayingNow').val())/100;
                                $(this).find('input').val(totalCCFee.toFixed(2));
                               // thisVal = parseFloat(thisVal) + parseFloat(totalCCFee);
                            } else if($("#payingCard").val() != "" && parseFloat($("#payingCard").val()) > 0){
                                console.log("paying card " + $("#payingCard").val());
                                totalCCFee = parseFloat(cc_charge) * parseFloat($("#payingCard").val())/100;
                                $(this).find('input').val(totalCCFee.toFixed(2));
                               // thisVal = parseFloat(thisVal) + parseFloat(totalCCFee);
                            } else {
                                $(this).find('input').val("0.00");
                            }
                        }
                    
                } else {
                    $(this).find('input').val("0.00");
                }

                var thisVal = $(this).find('input').val() != "" ? $(this).find('input').val() : 0;

                totalPayable = totalPayable + parseFloat(thisVal);

                 if($('#PayingNow').val() != "" &&  parseFloat($('#PayingNow').val()) != 0 && parseFloat($('#PayingNow').val()) < totalPayable && parseFloat($("#productCCFee").val()) > 0){
                    $('#PayingNow').val(parseFloat($('#PayingNow').val()) + parseFloat(thisVal));
                    $("#PayingNow").val(Math.round(parseFloat($("#PayingNow").val())));
                } else if ($("#payingCard").val() != "" && parseFloat($("#payingCard").val()) != 0 && parseFloat($("#payingCard").val()) < totalPayable && parseFloat($("#productCCFee").val()) > 0){
                    $("#payingCard").val(parseFloat($("#payingCard").val()) + parseFloat(thisVal));
                    $("#payingCard").val(Math.round(parseFloat($("#payingCard").val())));
                }
               // console.log("totalpayable + ccfee:"+totalPayable);
            }
        });

        //Round it Off
        let totalRounding = getDecimalDigits(totalPayable);
       
        totalRounding = totalRounding != null ? parseFloat("0." + totalRounding) : 0;
        
       // console.log(totalRounding);
        if(totalRounding > 0.5){
            totalPayable = totalPayable + (1 -totalRounding);
             $("#productAdjustment").val((1-totalRounding).toFixed(2));
        } else {
            totalPayable = totalPayable - totalRounding;
             $("#productAdjustment").val(totalRounding.toFixed(2));
        }              

        $("#productTotalPayable").val(totalPayable.toFixed(2));

        //Check paying now return and balance
        let PayingNow = $("#PayingNow").val() != "" ? $("#PayingNow").val() : 0;
        let payingCash = $("#payingCash").val() != "" ? $("#payingCash").val() : 0;
        let payingCard = $("#payingCard").val() != "" ? $("#payingCard").val() : 0;
        let payingLoyalty = $("#payingLoyalty").val() != "" ? $("#payingLoyalty").val() : 0;
        let payingRatained = $("#payingRetained").val() != "" ? $("#payingRetained").val() : 0;
        let payingVoucher = $("#payingVoucher").val() != "" ? $("#payingVoucher").val() : 0;

         console.log(totalPayable);
        console.log(PayingNow);
        console.log(payingCash);
        console.log(payingCard);

        let difference = totalPayable - (parseFloat(PayingNow) + parseFloat(payingCash) + parseFloat(payingCard) + parseFloat(payingLoyalty) + parseFloat(payingRatained) + parseFloat(payingVoucher));

        console.log(difference);

        if(difference < 0){
            $("#ReturnAmount").val((difference * -1).toFixed(2)) 
            $("#BalanceAmount").val("");
        } else if(difference >= 0) {
            $("#ReturnAmount").val("");
            $("#BalanceAmount").val(difference.toFixed(2));
        }

    }

    function getDecimalDigits(num) {
        if (num % 1 === 0) {
            return null; // no decimals
        }
        return num.toString().split(".")[1];
    }

     function paymentModeChange(mode){

        $(".payment").val("");


        $("#PayingNow").prop('disabled',false);
        $('.loyalty').addClass('d-none');
        $('.retainedamount').addClass('d-none');
        $('.giftvoucher').addClass('d-none');

        $(".mixed-payment").addClass('d-none');
        $("#retain").prop("checked", false);

        $(".tax-item").addClass('d-none');
               
        $(".tax-item[data-tax-mode='"+mode+"']").removeClass("d-none"); //Enable one

        let visibleCount = $(".tax-item").not(".d-none").length;
        if(visibleCount <=0 ){            
            $(".tax-item[data-tax-mode='All']").removeClass("d-none"); //Enable one
        }
        //set default focus
        setTimeout(function () {
            $("#PayingNow").focus();
        }, 100); // 100ms delay

        if(mode != 'Cash'  &&  mode != 'Voucher'){            
            $(".credit-card-item").removeClass('d-none');
            $(".instrument-number-item").removeClass('d-none');   
            $(".gift-voucher-item").addClass('d-none');
            console.log(mode);
            if(mode == "Card"){
                
                $(".credit-card-fee-item").removeClass('d-none');
                let cc_charge = $("#productCCFee").attr("data-cc-fee");
                // /cc_charge != "" ? $("#productCCFee").val(cc_charge) : $("#productCCFee").val("");
                setTimeout(function () {
                    $("#productInstrumentNumber").focus();
                }, 100); // 100ms delay

            } else {
                $("#productCCFee").val("");
                $(".credit-card-fee-item").addClass('d-none');
            }

            if(mode == 'Mixed'){
                $("#PayingNow").val("0.00");
                $("#PayingNow").prop('disabled','disabled');
                $(".mixed-payment").removeClass('d-none');
               
                setTimeout(function () {
                    $("#payingCash").focus();
                }, 100); // 100ms delay
               
            }

        } else {
            $(".credit-card-item").addClass('d-none');
            $(".instrument-number-item").addClass('d-none');     
            $("#productCCFee").val("");

            if(mode == "Voucher"){        
                
                $(".gift-voucher-item").removeClass('d-none');
                setTimeout(function () {
                    $("#productGiftVoucher").focus();
                }, 100); // 100ms delay
            } else {
                
                $(".gift-voucher-item").addClass('d-none');
                setTimeout(function () {
                    $("#PayingNow").focus();
                }, 100); // 100ms delay
            }
        }

        $("#selectedPaymentMode").html(mode);

        recalculate_totals();
    }

    function removeService(){
            Swal.fire({
                text: "Please Select The Visit on The Scheduler or Appointment Listing To Edit / Add / Remove Services.",
                icon: "info",
                buttonsStyling: true,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
    }

    function verifyVoucher(){
        if($("#productGiftVoucher").val() == ""){
             Swal.fire({
                text: "Enter a Valid Voucher Number to verify and apply.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            });
        }

        var voucherno = 'C'+$('#productGiftVoucher').val();

            $.ajax({
                type: 'GET',
                url: '{{ route("validate_voucher") }}',
                data: {
                    voucher_no: voucherno
                },
                success: function(response) {
                    var data = response.data;
                    //console.log(data);

                    if(null != data){
                        var html = '<table class="table">';
                            html += '<thead>';
                                html += '<tr><th colspan="3">Customer Details</th></tr>';
                            html += '</thead>';
                            html += '<tbody>';
                                html += '<tr><td>Customer Name</td><td>'+data.customer_name+'</td></tr>';
                                html += '<tr><td>Customer Email</td><td>'+data.customer_email+'</td></tr>';
                                html += '<tr><td>Customer Phone</td><td>'+data.customer_cell+'</td></tr>';
                            html += '</tbody>'; 
                            html += '<thead>';
                                html += '<tr><th colspan="3">Voucher Details</th></tr>';
                            html += '</thead>';
                            html += '<tbody>';
                                html += '<tr><td>Type</td><td>'+data.type.toUpperCase()+'</td></tr>';
                                html += '<tr><td>Generated on</td><td>'+data.voucher_date+'</td></tr>';
                                html += '<tr><td>Expires on</td><td>'+data.valid_until+'</td></tr>';
                                html += '<tr><td>Voucher #</td><td>'+data.voucher_number+'</td></tr>';
                                html += '<tr><td>Worth Services</td><td>'+data.voucher_value+'</td></tr>';
                                if(data.type === 'amount'){
                                    html += '<tr><td>Total Amount {{ config("constants.CURRENCY") }}.</td><td>'+data.amount+'</td></tr>';
                                    html += '<tr><td>Remaining Amount {{ config("constants.CURRENCY") }}.</td><td>'+data.remaining_amount+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-size: 11px;">(This amount will be used in the invoice)</span></td></tr>';
                                }
                                if(data.type === 'service'){
                                    html += '<tr><td>Services: </td><td class="voucher-services" data-id-voucher-services="'+data.service_ids+'">'+data.service_names.replace(/\|/g, '<div class="voucher-service-item" style="border-bottom: 1px solid #eee;"></div>')+'</td></tr>';
                                }

                                html += '<tr><td></td><td></td></tr>';
                            html += '</tbody>';
                        html += '</table>';
                        
                        html += '<a href="viewvoucher/' + data.id_order_vouchers +'" target="_blank" class="btn btn-secondary btn-sm gap-1 me-1">Print Preview</a>';
                        if($("#customerID").val() == data.id_customers){
                            html += '<button onclick="applyVoucher(\''+data.type+'\')" class="btn btn-primary btn-sm">Apply</button>';                        
                        }
                        $('#voucher-details').html(html);
                        $("#idOrderVoucher").val(data.id_order_vouchers);
                        $("#voucherRemainingServices").val(data.remaining_service_ids);
                        $("#voucherRemainingAmount").val(data.remaining_amount);
                        //$('#voucherHtml').fadeIn();

                        
                        $("#PayingNow").prop("disabled", true);
                        $("#productGiftVoucher").prop("disabled", true); 

                        var myModal = new bootstrap.Modal(document.getElementById('voucherHtml'));
                        myModal.show();


                    } else{
                         Swal.fire({
                            text: "The provided voucher number " +voucherno+" was not found or has EXPIRED.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });
                       
                    }
                }
            });
    }

    function applyVoucher(voucher_type){

        $(".giftvoucher").removeClass('d-none');

        if(voucher_type=='amount'){
            var remaining = parseInt($('#voucherRemainingAmount').val());
            var grandtotal = parseInt($('#productTotalPayable').val());
            if (remaining >= grandtotal) {
                $('#payingVoucher').val(grandtotal);
                $('#voucherRemainingAmount').val(parseInt(remaining) - parseInt(grandtotal));
            }
            if (remaining < grandtotal) {
                $('#payingVoucher').val(remaining);
                $('#voucherRemainingAmount').val('0');
            }
            recalculate_totals();

            //Hide Voucher Modal
            var myModal = new bootstrap.Modal(document.getElementById('voucherHtml'));
            myModal.hide();
            


        }else if(voucher_type=='service'){
            var sids = [];
            var rs = $(".voucher-services").attr('data-id-voucher-services');

            
            var remainingServiceIds =rs.split('|');

            $('.service').each(function () {
                sids.push($(this).attr("data-id-service"));
            });

            var diff_ids = arrayDifference(remainingServiceIds, sids);
            var remainingservices = "";

            $.each(diff_ids, function (index, value) {
                remainingservices += value + "|";
            });

            remainingservices = remainingservices.slice(0, -1);

            //console.log(remainingservices);

            $('#voucherRemainingServices').val(remainingservices);

            var remaining = parseInt($('#voucherRemainingAmount').val());
            var grandtotal = parseInt($('#productTotalPayable').val());

            if (remaining >= grandtotal) {
                $('#payingVoucher').val(grandtotal);
                $('#voucherRemainingAmount').val(parseInt(remaining) - parseInt(grandtotal));
                 $(".mixed-payment").addClass('d-none');
            }
            if (remaining < grandtotal) {
                $('#payingVoucher').val(remaining);
                $('#voucherRemainingAmount').val('0');
                $(".mixed-payment").removeClass('d-none');
            }

            
             recalculate_totals();
            //set default focus
            setTimeout(function () {
                $("#payingCash").focus();
            }, 100); // 100ms delay
            

            //Hide Voucher Modal
            var myModal = new bootstrap.Modal(document.getElementById('voucherHtml'));
            myModal.hide();

           
        }
    }

    function arrayDifference(array1, array2) {
        var difference = [];
        for (var i = 0; i < array1.length; i++) {
            if ($.inArray(array1[i], array2) == -1) {
                difference.push(array1[i]);
            }
        }
        return difference;
    }

    function redeem_loyalty(){
        console.log('redeem loyalty');

        let loyalty_points = parseFloat($("#loyalty_points").html());
        let loyalty_Rate = parseFloat($("#loyalty_points").attr('data-loyalty-rate'));
        if(loyalty_points > 0 && loyalty_Rate > 0){

            let use_points = 0;

            Swal.fire({
                    input: "number",
                    inputLabel: "Total Available Point "+loyalty_points,
                    inputPlaceholder: "Enter Points You Want To Utilize Now . . .",
                    inputAttributes: {
                        "aria-label": "Use Loyalty Points"
                    },
                    showCancelButton: true,
                    icon: "question",
                    customClass: {
                        confirmButton: 'btn btn-primary me-2',
                        cancelButton: 'btn btn-secondary'
                    },
                    buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
                }).then((result) => {
                    if (result.value) {
                        if(result.value >= 0){
                            use_points = result.value;
                        }

                        
                        use_points = use_points * loyalty_Rate;
                        
                        var total_payable = $("#productTotalPayable").val();

                        

                        if(total_payable >= use_points){
                            //Nothing
                            $("#payingLoyalty").val(use_points);
                            $("#payingLoyalty").prop("disabled", true);
                        
                            $(".loyalty").removeClass("d-none");

                            $("#InvoiceNote").val($("#InvoiceNote").val() + ' | ' + use_points + ' Loyalty Points used for Payment!');
                        } else {
                            use_points = 0;
                        }
                            
                        
                        recalculate_totals();

                    }
                
                });

            
        } else {
            $("#payingLoyalty").val("");
            $("#payingLoyalty").prop("disabled", false);
            $(".loyalty").addClass("d-none");
        }
        recalculate_totals();
    }

    function use_retained(){

        console.log('redeem loyalty');

        let retained_amount = parseFloat($("#retained_amount").html());
        
         Swal.fire({
                    input: "number",
                    inputLabel: "Total Available Point "+retained_amount,
                    inputPlaceholder: "Enter Points You Want To Utilize Now . . .",
                    inputAttributes: {
                        "aria-label": "Use Loyalty Points"
                    },
                    showCancelButton: true,
                    icon: "question",
                    customClass: {
                        confirmButton: 'btn btn-primary me-2',
                        cancelButton: 'btn btn-secondary'
                    },
                    buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
                }).then((result) => {

                    if(result.value){
                        if(result.value <= retained_amount){
                            $(".retainedamount").removeClass('d-none');
                            $("#payingRetained").val(result.value);
                        }
                        recalculate_totals();
                    }
                }
            );

    }

    

    function GenerateInvoice(){

        orinalInvoiceID = $("#originalInvoiceID").val();

        //Get all payment values
        payingNow = $("#PayingNow").val() != "" ? parseFloat($("#PayingNow").val()) : 0;
        payingCash = $("#payingCash").val() != "" ? parseFloat($("#payingCash").val()) : 0;
        payingCard = $("#payingCard").val() != "" ? parseFloat($("#payingCard").val()) : 0;
       
        
        payingLoyalty = $("#payingLoyalty").val() != "" ? parseFloat($("#payingLoyalty").val()) : 0;
        payingVoucher = $("#payingVoucher").val() != "" ? parseFloat($("#payingVoucher").val()) : 0;
        payingRetained = $("#payingRetained").val() != "" ? parseFloat($("#payingRetained").val()) : 0;

        paymentMode = $("#selectedPaymentMode").html() != "" ? $("#selectedPaymentMode").html().trim() : null;

        //Get Balance / Return / Retain Values
        
        balance = $("#BalanceAmount").val() != "" ? parseFloat($("#BalanceAmount").val()) : 0; 
        return_cash = $("#ReturnAmount").val() != "" ? parseFloat($("#ReturnAmount").val()) : 0;        
        retain = $("#retain").prop("checked") == true ? "Yes" : "No";
        rounding_adjustment = $("#productAdjustment").val() != "" ? parseFloat($("#productAdjustment").val()) : 0;      
        //Get Total Payable 
        productTotalPayable =   $("#productTotalPayable").val() != "" ? parseFloat($("#productTotalPayable").val()) : 0; 

        //get Credit Card or Online Transactions Related info
        CC_Fee = $("#productCCFee").val() != "" ? parseFloat($("#productCCFee").val()) : 0;
        //CCTip = $("#productCCTip").val() != "" ? parseFloat($("#productCCTip").val()) : 0;
        instrument_number = $("#productInstrumentNumber").val() != "" ? $("#productInstrumentNumber").val() : null;

       
        //Get Gift Voucher / Coupon / 
        productGiftVoucher = $("#productGiftVoucher").val() != "" ? $("#productGiftVoucher").val() : null;
        CouponNumber = $("#CouponNumber").val() != "" ? $("#CouponNumber").val() : null;

        
        //Get Visit ID / Services / Customer ID
        
        customerID = $("#customerID").val();        
        invoiceNote = $("#InvoiceNote").val();

         

        if(orinalInvoiceID=="" || customerID==""){
            Swal.fire({
                text: "Customer Not Mentioned or No Invoice Selected.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        console.log("creating recovery invoice for balance ID "+ orinalInvoiceID);
        try {
            $.ajax({
                url : "{{ route('create_recovery_invoice') }}",
                data: { 
                    "original_invoice_id" : orinalInvoiceID,                      
                    "id_customers" : customerID, 
                    "invoice_type" : 'service',
                    
                    "total_payable" : productTotalPayable,
                    
                    "paid_amount" : payingNow,
                    "paid_cash" : payingCash,
                    "paid_card" : payingCard,                
                    "paid_voucher" : payingVoucher,
                    "paid_loyalty" : payingLoyalty,
                    "paid_retained" : payingRetained, 
                    "return_cash" : return_cash,
                    "retain" : retain, 
                    "balance" : balance,
                    "rounding_adjustment" : rounding_adjustment,
                    "payment_mode" : paymentMode,
                    "voucher_number" : productGiftVoucher,
                    "coupon_number" : CouponNumber,
                    "instrument_number" : instrument_number,
                    "invoice_remarks" : invoiceNote,
                    "cc_fee": CC_Fee,
                    "rounded_adjustment": rounding_adjustment,

                },
                type: "POST", // The POST method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {
                    console.log(data);
                    var btn = "btn btn-" +data.message_btn;
                    Swal.fire({
                        text: data.message,
                        icon: data.message_type,
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: btn
                        }
                    });

                    if(data.message_type == "success"){
                        //load the invoice page
                        url = "{{ route('existing_invoice', ['invoice_id' => ':id']) }}";
                        url = url.replace(':id', data.new_id_invoice);
                        //window.open(url, '_blank');
                        location.href = url;
                    }
                },
                error: function(xhr, status, error) {
                    // Handle errors
                    console.error("AJAX Error:", status, error);
                }  
            });
        } catch (e) {
            console.error("JS error before AJAX:", e);
        }
    }


</script>
@endsection