@extends($ajax_request ? 'layouts.blank' : 'layouts.horizontal', ['title' => 'Create Order Invoice', 'topbarTitle' => 'Create Invoice'])
@section('css')
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card position-relative">
            <form>
                <div class="card-body">
                    <!-- Invoice Logo-->
                    <div class="d-flex align-items-start justify-content-between mb-4">
                        <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                            <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>     
                        <div class="text-end">
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="OrderNo" class="col-form-label fs-16 fw-bold">#Order</label>
                                </div>
                                <div class="col-auto">
                                    <input type="number" id="orderID" class="form-control border-0 h-100" readonly="readonly" placeholder="00001234" value="{{ $order != null ? $order->id_customer_order : '' }}">
                                    <input type="hidden" id="customerID" value="{{ $order != null ? $order->customer_id : '' }}">
                                </div>
                            </div>
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label  class="col-form-label fs-16 fw-bold d-print-none">DATE</label>
                                </div>
                                <div class="col-auto">
                                    <input type="text" readonly="readonly" id="orderDate" class="form-control  border-0" placeholder="Select Date" value="{{ $order ? $order->customer_order_date : '' }}">
                                </div> 
                            </div>
                        </div>
                    </div>

                    <div class="row" id="customer_details">                        
                        <div class="col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-0">
                            <div class="mb-2 {{ $customer != null ? 'd-none' : '' }} d-print-none">
                                <label class="form-label">Select Customer :</label>
                                <select class="form-select" id="selectCustomer">                                                                  
                                </select>                                
                            </div>
                            <div class="mb-2">
                                <label class="form-label">Billing Details :</label>
                                <div class="">
                                    <input type="text" id="BName" readonly class="form-control border-0" placeholder="Full Name" value="{{ $customer != null ? $customer->customer_name : '' }}">
                                </div>
                                <div  class="">
                                    <input type="text" id="BNumber" readonly class="form-control  border-0" placeholder="Phone Number" value="{{ $customer != null ? $customer->customer_cell : '' }}">
                                </div>
                                <div class="">
                                    <div class="form-control border-0" style="min-height: 60px; padding: 0.375rem 0.75rem;">
                                        @if(isset($billing_address) && !empty($billing_address))
                                            {{ $billing_address }}
                                        @endif
                                    </div>
                                </div>
                                <div class="d-print-none d-none">
                                    <textarea id="BAddress" readonly rows="3" class="form-control border-0" placeholder="Address">
                                    @if(isset($billing_address) && !empty($billing_address))
                                        {{ $billing_address }}
                                    @endif
                                    </textarea>
                                </div>                                
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3 d-print-none">                            
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3 d-print-none">
                        </div>
                    </div>

                    <div class="mt-1">                        
                        <div class="row mb-2 {{ count($order_products) > 0 ? 'd-none' : '' }} d-print-none" id="no_products">
                            <div class="col-4 text-start d-print-none">
                                <label class="form-label">Add Products :</label>
                                <select id="selectProduct" class="form-select">                                           
                                </select>                                        
                            </div>
                            <div class="col-4 text-start d-print-none">
                                <label class="form-label">Assign Staff :</label>
                                <select id="selectStaff" class="form-select">
                                    <option value=""></option>
                                    @foreach($staffs as $st)
                                        <option value="{{ $st->id_staff }}"  data-image="{{ $st->staff_image }}">{{ $st->staff_name }}</option>                                      
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-2 text-start d-print-none">
                                <label class="form-label">&nbsp;</label>
                                <button type="button" onclick="add_product();" class="btn btn-primary mt-3"><i class="ti ti-circle-plus me-1"></i> Add Product</button>
                            </div>
                        </div>
                        <div class="table">    
                            <table class="table text-center  mb-0" id="orders_table">
                                <thead>                                   
                                    <tr class="bg-light bg-opacity-50">
                                        <th eq="0" scope="col" class="border-0 d-print-none" style="width: 30px;">...</th>
                                        <th eq="1" scope="col" class="border-0 d-print-none" style="width: 30px;">#</th>
                                        <th eq="2" scope="col" class="border-0 d-print-none text-start" style="width: 50px">Item</th>
                                        <th eq="3" scope="col" class="border-0 text-start" style="width: 140px;">Discription</th>
                                        <th eq="4" scope="col" class="border-0 text-start " style="width: 100px;">Staff</th>
                                        <th eq="5" scope="col" class="border-0 text-start " style="width: 60px;">Qty.</th>
                                        <th eq="6" scope="col" class="border-0 text-start " style="width: 100px;">Unit Price</th>
                                        <th eq="7" scope="col" class="border-0 text-start d-print-none" style="width: 50px;">Discount Type</th>
                                        <th eq="8" scope="col" class="border-0 text-start d-print-none" style="width: 50px;">Discount</th>
                                        <th eq="9" scope="col" class="border-0 text-start d-print-none d-none" style="width: 50px;">Product Discount</th>
                                        <th eq="10" scope="col" class="border-0 text-start d-print-none" style="width: 50px;">Addition</th>
                                        <th eq="11" scope="col" class="border-0 text-start d-print-none" style="width: 50px;">SubTotal</th>                                        
                                        <th eq="12" scope="col" class="border-0 text-start d-print-none text-muted" style="width: 50px;">Tax</th>
                                        <th eq="13" scope="col" class="border-0 text-start d-print-none" style="width: 50px;">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php 
                                        $subTotal=0; 
                                        $row = 1; 
                                    @endphp

                                    @foreach($order_products as $product)

                                    @php
                                     $unit_price_with_qty = $product->qty* $product->product_unit_price; 
                                     $discount_amount = $product->qty* ($product->product_discount_amount ?? 0); 
                                     $discounted_price = $unit_price_with_qty - $discount_amount;
                                    @endphp
                                    <tr>
                                        <td eq="0" class="d-print-none"><button onclick="removeOrder();" type="button" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger"><iconify-icon icon="solar:trash-bin-trash-bold-duotone"class="fs-20"></iconify-icon></button></td>
                                        <td eq="1" scope="row" class="d-print-none">{{ $row }}</td>
                                        <td eq="2" class="text-start d-print-none">{{ $product->business_brand_name }}</td>
                                        <td eq="3" class="text-start product" data-batch-id="{{ $product->batch_id }}" data-batch="{{ $product->batch }}" data-id-order-products="{{ $product->id_order_products }}" data-id-customer-order="{{ $order->id_customer_order }}" data-id-product="{{ $product->product_id }}" data-product="{{ $product->product }}" data-order-price="{{ $product->price }}" data-order-category="{{ $product->category }}" data-product-type="{{ $product->product_type }}" data-id-order-category="{{ $product->brand_id }}" data-order-tax="{{ $product->product_sales_tax }}" data-track-inventory="{{ $product->track_inventory }}" data-unit-type="{{ $product->unit_type }}">{{ $product->product }}</td>
                                        <td eq="4" class="text-start" data-id-staff="{{ $product->staff_id }}">{!! $product->staff !!}</td>
                                        <td eq="5" class="text-start"><input onchange="recalculate_totals();" {{ $order == null ? '' : 'readonly' }} id="order_quantity_{{ $product->id_order_products }}" class="form-control decimal " name="input-quantity" value="{{ $product->qty }}" ></td>
                                        <td eq="6" class="text-start"><input readonly id="order_unit_price_{{ $product->id_order_products }}" class="form-control decimal" name="input-unit-price" value="{{ $product->product_unit_price }}" ></td>                                       
                                        <td eq="7" class="d-print-none">
                                            <select id="order_discount_type_{{ $product->id_order_products }}" onchange="order_discount('{{ $product->id_order_products }}', 'discount');" class="form-select" name="select-discount-type">
                                                @if (isset($product->product_discount_amount) && $product->product_discount_amount > 0)
                                                {{-- <option value=""></option> --}}
                                                <option data-order-price = "{{ $product->price }}" data-discount-percentage="0" data-discount-amount="{{ $product->product_discount_amount }}" data-discount-type="{{'Amount'}}" value="order discount">{{'order product discount per unit '.$product->product_discount_amount}}</option>
                                                @else
                                                <option value=""></option>
                                                @foreach($discount_types as $dt)
                                                    <option data-order-price = "{{ $product->price }}" data-discount-percentage="{{ $dt->discount_perc }}" data-discount-amount="{{ $dt->fixed_amount }}" data-discount-type="{{ $dt->discount_perc > 0 ? 'Percentage' : 'Amount' }}" value="{{ $dt->discount_reason }}">{{  $dt->discount_perc > 0 ? $dt->discount_reason . ' ' . $dt->discount_perc .'%' : $dt->discount_reason .' '. $dt->fixed_amount }}</option>
                                                @endforeach   
                                                @endif
                                   
                                            </select></td>
                                        <td eq="8" class="d-print-none"> <input id="order_discount_{{ $product->id_order_products }}" readonly  class="form-control decimal" name="input-discount" value="{{$product->product_discount_amount}}"></td>
                                        <td eq="9" class="d-print-none d-none"> <input id="order_product_discount_{{ $product->id_order_products }}" readonly  class="form-control decimal" name="input-product-discount" value="0" ></td>
                                        <td eq="10" class="d-print-none"><input onchange="order_discount('{{ $product->id_order_products }}', 'addition');" id="order_addition_{{ $product->id_order_products }}" class="form-control decimal" name="input-addition" value="0.00"></td>
                                        <td eq="11" class="text-start"><input id="order_subtotal_{{ $product->id_order_products }}" class="form-control decimal" readonly name="input-subtotal" value="{{ ($discounted_price ?? 0)  }}" readonly ></td>      
                                        <td eq="12" class="d-print-none tax text-muted" id="order_tax_{{ $product->id_order_products }}" data-order-product-id="{{ $product->id_order_products }}" data-sales-tax="{{ $product->product_sales_tax }}">{{ $discounted_price  > 0 ? $product->product_sales_tax / 100 * $discounted_price : 0 }} </td>           

                                        <td eq="13" class="d-print-none" id="order_price_{{ $product->id_order_products }}" data-s-rate="{{ $product->product_unit_price }}">{{ $discounted_price +  ($discounted_price  > 0 ? $product->product_sales_tax / 100 * $discounted_price : 0 )  }}</td>                                                                            
                                        @php 
                                            $subTotal = $subTotal + $product->price;
                                        @endphp 
                                    </tr>
                                    @php $row++ @endphp
                                    @endforeach
                                    
                                </tbody>
                            </table><!--end table-->                            
                        </div>
                        <div class="row  d-print-none">
                            <div class="col-6 mt-4 d-print-none">
                                <div class="row">
                                    <div class="col-8">
                                        <input class="form-control" placeholder="Discount Coupon#" id="CouponNumber" style="display:inline">
                                    </div>
                                    <div class="col-4">
                                        <button type="button" onclick="applycoupondiscount();" style="display:inline"  class="btn btn-primary"><i class="ti ti-circle-plus me-1"></i> Apply</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12 mt-3">
                                        <label class="form-label" for="InvoiceNote"> Note : </label>
                                        <textarea class="form-control" id="InvoiceNote" placeholder="Any Information you need to save with the invoice . . . " rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <table class="table table-sm table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:300px">
                                    <tbody>
                                        <tr>
                                            <td class="fw-medium">Subtotal {{  config('constants.CURRENCY') }}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productSubtotal" readonly="readonly" class="form-control text-end" placeholder="0.00" value="{{ sprintf('%.2f', $subTotal) }}">
                                                </div>
                                            </td>
                                        </tr>        
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Before Tax</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalBeforeTax" disabled class="form-control text-end" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ sprintf('%.2f' , $subTotal)  }}">
                                                </div>
                                            </th>
                                        </tr>
                                        
                                        <tr>
                                            <td class="fw-medium">Sales Tax </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">                                                   
                                                    <input type="number" id="productTaxes" readonly="readonly" class="form-control text-end tax" placeholder="{{ config('constants.CURRENCY') }}0.00" value= "">
                                                </div>
                                            </td>
                                        </tr>
                                       
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Amount</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalAmount" disabled class="form-control text-end" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ sprintf('%.2f' , $subTotal) }}">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="credit-card-item credit-card-fee-item d-none">
                                            <td class="fw-medium">CC Fee </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productCCFee" data-cc-fee="{{ $business->cc_charge }}" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="credit-card-item d-none">
                                            <td class="fw-medium">CC Tip </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" onkeyup="recalculate_totals();" id="productCCTip" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        
                                        <tr class="{{ $business->imsfiscal == 'No' && $business->srb_fiscal_order=='No' ? 'd-none' : '' }} POSCharges">
                                            <td class="fw-bold">POS Charges </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productPOSCharges" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ $business->imsfiscal == 'Yes' || $business->srb_fiscal_order == 'Yes' ? (!empty($business->ims_fee) ? $business->srb_fees : '0.00') : '0.00' }}">
                                                </div>
                                            </td>
                                        </tr>
                                        {{-- @if (!empty($order->delivery_charges) && $order->delivery_charges > 0) --}}
                                            <tr>
                                                <td class="fw-bold">Delivery Charges</td>
                                                <td class="text-end">
                                                    <div class="ms-auto" style="width: 160px;">
                                                        <input type="number" step="any" value="{{ $order->delivery_charges ?? 0 }}" id="deliveryCharges" onchange="recalculate_totals();" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                    </div>
                                                </td>
                                            </tr>
                                        {{-- @endif --}}
                                        <tr>
                                            <td class="fw-medium">Advance </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productAdvance" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ $advance_amount ?? 0 }}">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Rounding Adjustment </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productAdjustment" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Payable</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalPayable" disabled class="form-control text-end" placeholder="Rs0.00" value="{{ sprintf('%.2f' , $subTotal)  }}">
                                                </div>
                                            </th>
                                        </tr>
                                      
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold fs-20">Paying Now</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="PayingNow"  class="form-control text-end" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none mixed-payment">
                                            <th scope="row" class="fw-bold text-success">Paid Cash</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingCash" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none mixed-payment">
                                            <th scope="row" class="fw-bold text-success">Paid Card</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingCard"  class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>                                        
                                        <tr class="fs-15 d-none loyalty">
                                            <th scope="row" class="fw-bold text-success">Loyalty Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingLoyalty" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none retainedamount">
                                            <th scope="row" class="fw-bold text-success">Retained Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingRetained" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none giftvoucher">
                                            <th scope="row" class="fw-bold text-success">Voucher Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingVoucher" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium  text-success">Return Cash</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="ReturnAmount" readonly="readonly" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                    <div class="form-checkbox-dark">
                                                        <input type="checkbox" class="form-check-input text-secondary me-1" id="retain"><label class="form-label label-sm" for="retain">Retain</label>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium text-danger">Balance</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="BalanceAmount" readonly="readonly" class="form-control text-end text-danger payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none instrument-number-item">
                                            <th scope="row" class="fw-medium border-1">Instrument # : </th>
                                            <th class="border-1 ">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" class="form-control" id="productInstrumentNumber" placeholder="xxxx" value="">     
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none gift-voucher-item">
                                            <th scope="row" class="fw-medium border-1">Verify Voucher# : </th>
                                            <th class="border-1 ">
                                                <div class="input-group ms-auto" class="d-flex" style="width: 160px;">
                                                    <input type="text" style="width:80px;" class="form-control" id="productGiftVoucher" placeholder="xxx" value="">  
                                                    <button type="button" style="width:50px;" onclick="verifyVoucher();" class="btn btn-sm btn-success">
                                                        <iconify-icon icon="solar:check-read-broken"class="fs-24"></iconify-icon>
                                                    </button>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr>
                                             <th scope="row" class="fw-medium">Store : </th>
                                            <th>
                                                <select id="business_store_id" name="business_store_id" class="form-select">  
                                                    @if (isset($stores))
                                                        @foreach($stores as $store)
                                                        <option  value="{{ $store->id_business_stores }}">{{ $store->business_store }} ({{ $store->business_name }})</option>
                                                        @endforeach
                                                    @endif
                                                </select>  
                                               
                                            </th>
                                        </tr>  
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium border-1">Payment Mode : </th>
                                            <th class="border-1 ">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <label><span id="selectedPaymentMode">Cash</span></label>     
                                                </div>
                                            </th>
                                        </tr>
                                        
                                      
                                    </tbody>
                                </table>
                            <!--end table-->

                            </div>
                        </div>
                    </div>
                    <div class="card-foorter d-print-none mt-4">
                        <div class="row">
                            <div class="col-4 text-success">
                                <span class="">Customer Retained Amount: {{ config('constants.CURRENCY') }} </span><span id="retained_amount" class="gap-1">{{ $retained_amount }}</span>
                                <button type="button" onclick="use_retained()" class="btn btn-light gap-1"><i class ="ti ti-moneybag fs-16"></i> Retained</button>
                            </div>
                            <div class="col-4 text-success">
                                <span class="">Loyalty Points: {{ config('constants.CURRENCY') }} </span><span data-loyalty-rate="{{ $business->l_point_discount }}" id="loyalty_points" class="gap-1">{{ $customer != null ? $customer->loyalty_points : 0 }}</span>
                                <button type="button" onclick="redeem_loyalty();"  class="btn btn-light gap-1"><i class ="ti ti-affiliate fs-16"></i> Loyalty</button>
                            </div>
                            <div class="col-4 text-end">
                                <a href="javascript:window.print()"  type="button" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success">
                                    <iconify-icon icon="solar:printer-line-duotone"class="fs-24"></iconify-icon>
                                </a>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-info dropdown-toggle  gap-1" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class ="ti ti-cash-register fs-16"></i> Payment Mode</button>
                                    <div class="dropdown-menu">
                                        <a style="cursor:pointer" onclick="paymentModeChange('Cash');" class="dropdown-item">Cash</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Card');" class="dropdown-item">Card</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('D-Card');" class="dropdown-item">Debit Card</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Online');" class="dropdown-item">Online</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Check');" class="dropdown-item">Bank Transfer</a>
                                        <div class="dropdown-divider"></div>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Voucher');" class="dropdown-item">Gift Voucher</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Mixed');" class="dropdown-item">Mixed</a>                                        
                                    </div>
                                </div>
                                
                                {{-- <button type="button" onclick="GenerateInvoice();" class="btn btn-success gap-1"><i class="ti ti-device-floppy fs-16"></i> Save</button> --}}
                                <button id="saveInvoiceButton" type="button" onclick="GenerateInvoice();" class="btn btn-success gap-1"><span id="generateInvoiceSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" ></span>  <i class="ti ti-device-floppy fs-16"></i> Save</button>
                            </div>
                        </div>

                    </div>
                </div> <!-- end card-body-->
            </form>
        </div><!-- end card -->
        
    </div>

    <div id="voucherHtml" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="voucherHtml" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-md" >
            <div class="modal-content">
                <div class="modal-header">                    
                    <h4 class="modal-title" id="custom-width-modalLabel">Voucher Verification</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="voucherRemainingOrders">
                    <input type="hidden" id="voucherRemainingAmount">
                    <div id="voucher-details">

                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('scripts')
<script>
   var is_pos_request = @json($ajax_request ?? false);

    //  timer = null;
    var staffImageBase = "{{ asset('images/staff') }}/";
    var ImageBase = "{{ asset('images') }}/";

    document.getElementById("payingCard").onchange = function () {
       // clearTimeout(timer); // cancel previous timer
        // timer = setTimeout(() => {
            recalculate_totals();
        //}, 1000); // 1 second delay
    };

    document.getElementById("PayingNow").onchange = function () {
        if($("#selectedPaymentMode").html() == "Cash"){
            recalculate_totals();
        } else {
            // clearTimeout(timer); // cancel previous timer
            // timer = setTimeout(() => {
                recalculate_totals();
            //}, 3000); // 1 second delay
        }
    };

    //document loaded
    document.addEventListener("DOMContentLoaded", function () {    
     
       document.querySelectorAll('select[id^="order_discount_type_"]').forEach(function (el) {
            if (!el || el.disabled) return;
            if (el.value === '' || el.selectedIndex === -1) return;
            const option = el.options[el.selectedIndex];
            if (!option || !option.dataset) return;
            el.dispatchEvent(new Event('change', { bubbles: true }));
        });


        $("#selectStaff").select2({
            placeholder: "Select Staff",
            width: '100%',
            closeOnSelect: true,
            allowClear: true,
            placeholder: "Select Staff",
            dropdownParent: $('#no_products').parent(),
            templateResult: formatStaff,
            templateSelection: formatStaff

        });

         function formatStaff (option) {
            if (!option.id) {
                    return option.text;
                }
                var imgSrc = staffImageBase + $(option.element).data('image');
                return $('<span><img src="'+ imgSrc +'" class="avatar-sm rounded-circle me-2" style="color:#000 !important" /> ' + option.text + '</span>');
            }
        //initialize customer select2
        $("#selectCustomer").select2({
            placeholder: "Select a Customer",
            allowClear: true,
            width: '100%',
            minimumInputLength: 3,
            closeOnSelect: true,
            dropdownParent: $('#customer_details').parent(),
            ajax: {
                url: '{{ route("customer_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { term: params.term };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.customer_name || (item.customer_name + ' (' + item.customer_cell + ')'),
                                customer_name: item.customer_name,
                                customer_cell: item.customer_cell,
                                customer_type: item.customer_type // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatCustomer,      // dropdown items
            templateSelection: formatCustomerSel // selected item
        });

        function formatCustomer(customer) {
            // Select2 calls this for placeholder items where id is undefined/empty.
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }
            // defensive: unify the type so comparisons are reliable
            var type = (customer.customer_type || '').toString().toLowerCase();
            console.log('Customer type:', type);
            // decide icon & color (use Bootstrap Icons classes as example)
            var iconClass = 'ti-user fs-4 text-secondary';
            var nameClass = '';
            if (type === 'orange' || type === '1') {
                iconClass = 'ti-star fs-4 text-warning';
                nameClass = 'text-warning';
            } else if (type === 'green' || type === '2') {
                iconClass = 'ti-flag fs-4 text-success';
                nameClass = 'text-success';
            }  else if (type === 'red' || type === '3') {
                iconClass = 'ti-flag-question fs-4 text-danger';
                //nameClass = 'text-danger';
            } 
            
            // add branches as needed

            // safe-escape text pieces
            var nameEsc = $('<div/>').text(customer.customer_name || customer.text || '').html();
            var cellEsc = $('<div/>').text(customer.customer_cell || '').html();

            var $node = $(
                '<div class="d-flex justify-content-between align-items-center">' +
                    '<div>' +
                        '<div class="fw-bold  '+nameClass+'">' + nameEsc + '</div>' +
                        '<div class="small">' + cellEsc + '</div>' +
                    '</div>' +
                    '<i class="ti ' + iconClass + ' ms-2" aria-hidden="true"></i>' +
                '</div>'
            );
            return $node;
        }

        function formatCustomerSel(customer) {
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }
            var name = customer.customer_name || customer.text;
            var cell = customer.customer_cell ? ' (' + customer.customer_cell + ')' : '';
            // return a simple node — keep selection compact
            return $('<span>').text(name + cell);
        }

        //intialize product select2
        $('#selectProduct').select2({
             width: '100%',
            dropdownParent: $('#no_products').parent(),
            closeOnSelect: true,
            ajax: {
                url: '{{ route("products.search_products_instock") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term, // search term                        
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function (item) {
                            return {
                                id: item.id,
                                text: item.business_brand_name + ' ' + item.product + ' ' + (item.mcategory ? ' (Category: ' + item.mcategory + ')' : ''),
                                measure_unit: item.measure_unit,
                                qty_per_unit: item.qty_per_unit,
                                product: item.product,
                                brand: item.business_brand_name,
                                batch_id: item.batch_id,
                                batch_no: item.batch_no,
                                store: item.store,
                                price: item.price,
                                instock: item.instock
                            };
                        })
                    };
                },
                cache: true
            },
            minimumInputLength: 1,

            // Formatting should be outside the ajax block
            templateResult: function (item) {
                if (item.loading) return item.text;

                return $(
                    "<div class='d-flex justify-content-between'>" +
                        "<div class='col-md-6 d-flex justify-content-between'>" + item.text + "</div>" +
                        "<div class='col-md-6 me-auto text-end text-muted' style='font-size: 12px;'>" + (item.store ? item.store : '') + ' ' + (item.batch_id ? item.batch_id : '') + ' - ' + (item.qty_per_unit ? item.qty_per_unit : '') + ' ' + (item.measure_unit ? item.measure_unit : '') + ' - Remaining: ' + (item.instock ? parseFloat(item.instock).toFixed(2) : '') + "</div>" +
                    "</div>"
                );
            },

            templateSelection: function (item) {
                return item.text || item.id;
            },

            escapeMarkup: function (markup) {
                return markup;
            }
        });

        recalculate_totals();
        $("#PayingNow").focus();

    });

    function order_discount(id_order_orders, element=null){

        let discount_type_El = "#order_discount_type_"+id_order_orders + " option:selected";
        let discount_input_El = "#order_discount_"+id_order_orders;
        let price_El = "#order_unit_price_"+id_order_orders;
        let addition_input_El = "#order_addition_" + id_order_orders;
        let tax_El = "#order_tax_" + id_order_orders;
        let order_subtotal_El = "#order_subtotal_" + id_order_orders;
        let qty_El = "#order_quantity_" + id_order_orders;
        let order_product_discount = $('#order_product_discount_'+ id_order_orders);
        let discount_type = $(discount_type_El).attr("data-discount-type") ? $(discount_type_El).attr("data-discount-type") : "0"; 
        let price = $(price_El).val() ? $(price_El).val() : "0"; 
         //console.log(price);
        let discount_amount = $(discount_type_El).attr("data-discount-amount") ? $(discount_type_El).attr("data-discount-amount") : "0"; 
        let discount_perc = $(discount_type_El).attr("data-discount-percentage") ? $(discount_type_El).attr("data-discount-percentage") : "0"; 
        let tax_perc = $(tax_El).attr("data-sales-tax") ? $(tax_El).attr("data-sales-tax") : "0";
        let qty = $(qty_El).val() ? $(qty_El).val() : "1";
        let tax = $(tax_El).val() ? $(tax_El).val() : "0";

        let addition_amount = 0; 
        if($(addition_input_El).val() > 0){
            addition_amount = $(addition_input_El).val();             
            //console.log(addition_amount);
        }

        var discount = 0;
        if(discount_type == "Percentage"){
            discount = (parseFloat(price)*parseFloat(discount_perc))/100
        }else if(discount_type == "Amount"){
            discount = parseFloat(discount_amount);
        }
        // let price_after_discount = (parseFloat(price) + parseFloat(addition_amount) - parseFloat(discount)) * parseFloat(qty);
        let price_after_discount = (parseFloat(price) + parseFloat(addition_amount) - parseFloat(discount) - parseFloat(order_product_discount.val())) * parseFloat(qty);
        $(order_subtotal_El).val(price_after_discount.toFixed(2));

        if(tax_perc > 0){            
            tax = (price_after_discount * tax_perc)/100;
             $(tax_El).html(parseFloat(tax).toFixed(2));
        }

       

        let order_price_El = "#order_price_"+id_order_orders;
        let org_price = parseFloat($(order_price_El).attr("data-s-rate") || 0);

        // let discounted_price = ((parseFloat(org_price) - discount) + parseFloat(addition_amount)) * parseFloat(qty);
        let discounted_price = (((parseFloat(org_price) - discount)-order_product_discount.val()) + parseFloat(addition_amount)) * parseFloat(qty);
       // order_subtotal_2199 = price_after_discount

        if(discount > org_price){
            //show error and reset on user confirmation
            Swal.fire({
                text: "Discount cannot be more then the Order Price.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            }).then(function(result) {
                if (result.isConfirmed) {
                    //reload the page
                    window.location.reload();
                }
            });         
            return false;
        }

        $(discount_input_El).val(discount);

        $(order_price_El).html((parseFloat(discounted_price) + parseFloat(tax)).toFixed(2));

        recalculate_totals();

    }

    function invoiceDiscountChanged(){
        

        let discount_type = $("#productDiscountType option:selected").attr("data-discount-type");       
        //console.log(discount_type);

        let discount_amount = $("#productDiscountType  option:selected").attr("data-discount-amount"); 
        let discount_perc = $("#productDiscountType  option:selected").attr("data-discount-percentage"); 
        let org_price = parseFloat($("#productSubtotal").val() || 0);

        let addition_amount = 0; 
        if($("#productOtherCharges").val() > 0){
            addition_amount = $("#productOtherCharges").val();           
        }

        var discount = 0;
        if(discount_type == "Percentage"){
            discount = (parseFloat(org_price)*parseFloat(discount_perc))/100
        }else if(discount_type == "Amount"){
            discount = parseFloat(discount_amount);
        }
        // console.log(org_price);
        // console.log(discount);
        // console.log(addition_amount);

        let discounted_price = (parseFloat(org_price) - discount) + parseFloat(addition_amount); 


        if(discount > org_price){
            Swal.fire({
                text: "Discount cannot be more then the Order Price.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            });
            $(discount_input_El).val("0.00");
            
            $("#order_price_"+id_order_orders).html(org_price);
            return false;
        }

        $("#productDiscount").val(discount);
        
        recalculate_totals();

    }


    function recalculate_totals(){
       
        let invoice_discount = 0;
        let order_price=0;
        let other_charges = 0;        
        let tax = 0;
        let delivery_charges = parseFloat($("#deliveryCharges").val() || 0);

        let subTotal = 0; let discountTotal = 0; let otherChargesTotal = 0; let totalTax = 0; 

        $('#orders_table tr').each(function(row, tr) {
            if(row>0){
                //sub total from the input box in col 10

                order_price = $(tr).find('td:eq(11)').find('input').val().trim();
                if( '' != order_price){
                    subTotal = subTotal + parseFloat(order_price);
                }
                invoice_discount = $(tr).find('td:eq(8)').text().trim();
                if( '' != invoice_discount){
                    discountTotal = discountTotal + parseFloat(invoice_discount);
                }
               
                other_charges = $(tr).find('td:eq(10)').text().trim();
                if( '' != other_charges){
                    otherChargesTotal = otherChargesTotal + parseFloat(other_charges);
                }
                tax = $(tr).find('td:eq(12)').text().trim();
                if( '' != tax){
                    totalTax = totalTax + parseFloat(tax);
                }
                
            }
        });       

        $("#productSubtotal").val(subTotal.toFixed(2));        
       
        let total_before_tax = subTotal;
        $("#productTotalBeforeTax").val(total_before_tax.toFixed(2));

        $("#productTaxes").val(totalTax.toFixed(2));

        
        let totalAmount = subTotal+totalTax;
         $("#productTotalAmount").val(totalAmount.toFixed(2));

        let cc_tip = $("#productCCTip").val() != "" ? parseFloat($("#productCCTip").val()) : 0;

        totalPayable = (totalAmount + cc_tip);
        
         //Add POS Charges
        if($(".POSCharges").hasClass("d-none")){

        }else{
            let totalPOSCharge = $("#productPOSCharges").val() != "" ? parseFloat($("#productPOSCharges").val()) : 0 ;
            totalPayable = totalPayable + parseFloat(totalPOSCharge);
        }

        
        //CC items addition
        $(".credit-card-item").each(function(index, input){
            
            if($(this).hasClass('d-none')){
                // Do Nothing
            } else {                  
                if($("#selectedPaymentMode").html()!="Cash" || $("#selectedPaymentMode").html()!="Voucher") {                    
                    //check if cc charge is defined
                        let cc_charge = $(this).find('input').attr("data-cc-fee");
                        if(cc_charge != null && cc_charge != 'undefined'){
                            console.log("ccfee " + $(this).find('input').attr("data-cc-fee")); 
                            //Add cc charge if defined
                            if($('#PayingNow').val() != "" && parseFloat($('#PayingNow').val()) > 0){
                                console.log("PayingNow " + $("#PayingNow").val());
                                totalCCFee = parseFloat(cc_charge) * parseFloat($('#PayingNow').val())/100;
                                $(this).find('input').val(totalCCFee.toFixed(2));
                                thisVal = parseFloat(thisVal) + parseFloat(totalCCFee);
                            } else if($("#payingCard").val() != "" && parseFloat($("#payingCard").val()) > 0){
                                console.log("paying card " + $("#payingCard").val());
                                totalCCFee = parseFloat(cc_charge) * parseFloat($("#payingCard").val())/100;
                                $(this).find('input').val(totalCCFee.toFixed(2));
                                thisVal = parseFloat(thisVal) + parseFloat(totalCCFee);
                            } else {
                                $(this).find('input').val("0.00");
                            }

                            var thisVal = $(this).find('input').val() != "" ? $(this).find('input').val() : 0;

                            totalPayable = totalPayable + parseFloat(thisVal);
                            //console.log(parseFloat($('#PayingNow').val()) < totalPayable);
                            if($('#PayingNow').val() != "" &&  parseFloat($('#PayingNow').val()) != 0 && parseFloat($('#PayingNow').val()) < totalPayable && parseFloat($("#productCCFee").val()) > 0){
                                $('#PayingNow').val(parseFloat($('#PayingNow').val()) + parseFloat(thisVal));
                                $("#PayingNow").val(Math.round(parseFloat($("#PayingNow").val())));
                            } else if ($("#payingCard").val() != "" && parseFloat($("#payingCard").val()) != 0 && parseFloat($("#payingCard").val()) < totalPayable && parseFloat($("#productCCFee").val()) > 0){
                                $("#payingCard").val(parseFloat($("#payingCard").val()) + parseFloat(thisVal));
                                $("#payingCard").val(Math.round(parseFloat($("#payingCard").val())));
                            }

                        } else { //it is TIP

                            // let cc_tip = $(this).find('input').val() != "" ? $(this).find('input').val() : 0;
                            // totalPayable = totalPayable + parseFloat(cc_tip);
                        }
                    
                } else {
                    $(this).find('input').val("0.00");
                }
            }
        });
        
        
        // ADVANCE PAYMENT DEDUCTION
        let advance_payment = $("#productAdvance").val() != "" ? parseFloat($("#productAdvance").val()) : 0;
        totalPayable = totalPayable - parseFloat(advance_payment);  

        //Round it Off
        let totalRounding = getDecimalDigits(totalPayable);
       
        totalRounding = totalRounding != null ? parseFloat("0." + totalRounding) : 0;
        
       // console.log(totalRounding);
        if(totalRounding >= 0.5){
            totalPayable = totalPayable + (1 -totalRounding);
             $("#productAdjustment").val((1-totalRounding).toFixed(2));
        } else {
            totalPayable = totalPayable - totalRounding;
             $("#productAdjustment").val(totalRounding.toFixed(2));
        }              
        totalPayable = totalPayable+ parseFloat(delivery_charges);
        $("#productTotalPayable").val(totalPayable.toFixed(2));

        //Check paying now return and balance
        let PayingNow = $("#PayingNow").val() != "" ? $("#PayingNow").val() : 0;
        let payingCash = $("#payingCash").val() != "" ? $("#payingCash").val() : 0;
        let payingCard = $("#payingCard").val() != "" ? $("#payingCard").val() : 0;
        let payingLoyalty = $("#payingLoyalty").val() != "" ? $("#payingLoyalty").val() : 0;
        let payingRatained = $("#payingRetained").val() != "" ? $("#payingRetained").val() : 0;
        let payingVoucher = $("#payingVoucher").val() != "" ? $("#payingVoucher").val() : 0;


        let difference = totalPayable - (parseFloat(PayingNow) + parseFloat(payingCash) + parseFloat(payingCard) + parseFloat(payingLoyalty) + parseFloat(payingRatained) + parseFloat(payingVoucher));


        if(difference < 0){
            $("#ReturnAmount").val((difference * -1).toFixed(2)) 
            $("#BalanceAmount").val("");
        } else if(difference >= 0) {
            $("#ReturnAmount").val("");
            $("#BalanceAmount").val(difference.toFixed(2));
        }

    }

    function getDecimalDigits(num) {
        if (num % 1 === 0) {
            return null; // no decimals
        }
        return num.toString().split(".")[1];
    }

    function paymentModeChange(mode){
        $("#PayingNow").val("");
        $(".payment").val("");

        $("#PayingNow").prop('disabled',false);
        $('.loyalty').addClass('d-none');
        $('.retainedamount').addClass('d-none');
        $('.giftvoucher').addClass('d-none');

        $(".mixed-payment").addClass('d-none');
        $("#retain").prop("checked", false);

        $(".tax-item").addClass('d-none');
               
        $(".tax-item[data-tax-mode='"+mode+"']").removeClass("d-none"); //Enable one

        let visibleCount = $(".tax-item").not(".d-none").length;
        if(visibleCount <=0 ){            
            $(".tax-item[data-tax-mode='All']").removeClass("d-none"); //Enable one
        }
        //set default focus
        setTimeout(function () {
            $("#PayingNow").focus();
        }, 100); // 100ms delay

        if(mode != 'Cash'  &&  mode != 'Voucher'){            
            $(".credit-card-item").removeClass('d-none');
            $(".instrument-number-item").removeClass('d-none');   
            $(".gift-voucher-item").addClass('d-none');
            console.log(mode);
            if(mode == "Card"){
                
                $(".credit-card-fee-item").removeClass('d-none');
                let cc_charge = $("#productCCFee").attr("data-cc-fee");
                // /cc_charge != "" ? $("#productCCFee").val(cc_charge) : $("#productCCFee").val("");
                setTimeout(function () {
                    $("#productInstrumentNumber").focus();
                }, 100); // 100ms delay

            } else {
                $("#productCCFee").val("");
                $(".credit-card-fee-item").addClass('d-none');
            }

            if(mode == 'Mixed'){
                $("#PayingNow").val("0.00");
                $("#PayingNow").prop('disabled','disabled');
                $(".mixed-payment").removeClass('d-none');
               
                setTimeout(function () {
                    $("#payingCash").focus();
                }, 100); // 100ms delay
               
            }

        } else {
            $(".credit-card-item").addClass('d-none');
            $(".instrument-number-item").addClass('d-none');     
            $("#productCCFee").val("");

            if(mode == "Voucher"){        
                
                $(".gift-voucher-item").removeClass('d-none');
                setTimeout(function () {
                    $("#productGiftVoucher").focus();
                }, 100); // 100ms delay
            } else {
                
                $(".gift-voucher-item").addClass('d-none');
                setTimeout(function () {
                    $("#PayingNow").focus();
                }, 100); // 100ms delay
            }
        }

        $("#selectedPaymentMode").html(mode);

        recalculate_totals();
    }

    function removeOrder(){
            Swal.fire({
                text: "Please Select The Visit on The Scheduler or Appointment Listing To Edit / Add / Remove Orders.",
                icon: "info",
                buttonsStyling: true,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
    }

    function verifyVoucher(){
        if($("#productGiftVoucher").val() == ""){
             Swal.fire({
                text: "Enter a Valid Voucher Number to verify and apply.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            });
        }

        var voucherno = 'C'+$('#productGiftVoucher').val();

            $.ajax({
                type: 'GET',
                url: '{{ route("validate_voucher") }}',
                data: {
                    voucher_no: voucherno
                },
                success: function(response) {
                    var data = response.data;
                    //console.log(data);
                   if (data.type.toUpperCase() !== 'AMOUNT') {
                        Swal.fire({
                            text: "Only vouchers of type 'AMOUNT' can be used for product orders. Other voucher types are not applicable.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });

                        return false;
                    }


                    if(null != data){
                        var html = '<table class="table">';
                            html += '<thead>';
                                html += '<tr><th colspan="3">Customer Details</th></tr>';
                            html += '</thead>';
                            html += '<tbody>';
                                html += '<tr><td>Customer Name</td><td>'+data.customer_name+'</td></tr>';
                                html += '<tr><td>Customer Email</td><td>'+data.customer_email+'</td></tr>';
                                html += '<tr><td>Customer Phone</td><td>'+data.customer_cell+'</td></tr>';
                            html += '</tbody>'; 
                            html += '<thead>';
                                html += '<tr><th colspan="3">Voucher Details</th></tr>';
                            html += '</thead>';
                            html += '<tbody>';
                                html += '<tr><td>Type</td><td>'+data.type.toUpperCase()+'</td></tr>';
                                html += '<tr><td>Generated on</td><td>'+data.voucher_date+'</td></tr>';
                                html += '<tr><td>Expires on</td><td>'+data.valid_until+'</td></tr>';
                                html += '<tr><td>Voucher #</td><td>'+data.voucher_number+'</td></tr>';
                                html += '<tr><td>Worth Orders</td><td>'+data.voucher_value+'</td></tr>';
                                if(data.type === 'amount'){
                                    html += '<tr><td>Total Amount {{ config("constants.CURRENCY") }}.</td><td>'+data.amount+'</td></tr>';
                                    html += '<tr><td>Remaining Amount {{ config("constants.CURRENCY") }}.</td><td>'+data.remaining_amount+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-size: 11px;">(This amount will be used in the invoice)</span></td></tr>';
                                }
                                if(data.type === 'order'){
                                    html += '<tr><td>Orders: </td><td class="voucher-orders" data-id-voucher-orders="'+data.order_ids+'">'+data.order_names.replace(/\|/g, '<div class="voucher-order-item" style="border-bottom: 1px solid #eee;"></div>')+'</td></tr>';
                                }

                                html += '<tr><td></td><td></td></tr>';
                            html += '</tbody>';
                        html += '</table>';
                        
                        html += '<a href="viewvoucher/' + data.id_order_vouchers +'" target="_blank" class="btn btn-secondary btn-sm gap-1 me-1">Print Preview</a>';
                        // if($("#customerID").val() == data.id_customers){
                            html += '<button onclick="applyVoucher(\''+data.type+'\')" class="btn btn-primary btn-sm">Apply</button>';                        
                        // }

                        if (parseFloat(data.remaining_amount) <= 0) {
                            Swal.fire({
                                text: "The voucher number " + voucherno + " has already been fully used and cannot be used again.",
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            });
                            return false;
                        }

                        $('#voucher-details').html(html);
                        $("#idOrderVoucher").val(data.id_order_vouchers);
                        $("#voucherRemainingOrders").val(data.remaining_order_ids);
                        $("#voucherRemainingAmount").val(data.remaining_amount);
                        //$('#voucherHtml').fadeIn();

                        
                        $("#PayingNow").prop("disabled", true);
                        $("#productGiftVoucher").prop("disabled", true); 

                        var myModal = new bootstrap.Modal(document.getElementById('voucherHtml'));
                        myModal.show();


                    } else{
                         Swal.fire({
                            text: "The provided voucher number " +voucherno+" was not found or has EXPIRED.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });
                       
                    }
                }
            });
    }

    function applyVoucher(voucher_type){

        $(".giftvoucher").removeClass('d-none');

        if(voucher_type=='amount'){
            var remaining = parseInt($('#voucherRemainingAmount').val());
            var grandtotal = parseInt($('#productTotalPayable').val());
            if (remaining >= grandtotal) {
                $('#payingVoucher').val(grandtotal);
                $('#voucherRemainingAmount').val(parseInt(remaining) - parseInt(grandtotal));
            }
            if (remaining < grandtotal) {
                $('#payingVoucher').val(remaining);
                $('#voucherRemainingAmount').val('0');
            }
            recalculate_totals();

            //Hide Voucher Modal
            const modalEl = document.getElementById('voucherHtml');
            const myModal = bootstrap.Modal.getInstance(modalEl);
            myModal.hide();
            


        }else if(voucher_type=='order'){
            var sids = [];
            var rs = $(".voucher-orders").attr('data-id-voucher-orders');

            
            var remainingOrderIds =rs.split('|');

            $('.order').each(function () {
                sids.push($(this).attr("data-id-order"));
            });

            var diff_ids = arrayDifference(remainingOrderIds, sids);
            var remainingorders = "";

            $.each(diff_ids, function (index, value) {
                remainingorders += value + "|";
            });

            remainingorders = remainingorders.slice(0, -1);

            //console.log(remainingorders);

            $('#voucherRemainingOrders').val(remainingorders);

            var remaining = parseInt($('#voucherRemainingAmount').val());
            var grandtotal = parseInt($('#productTotalPayable').val());

            if (remaining >= grandtotal) {
                $('#payingVoucher').val(grandtotal);
                $('#voucherRemainingAmount').val(parseInt(remaining) - parseInt(grandtotal));
                 $(".mixed-payment").addClass('d-none');
            }
            if (remaining < grandtotal) {
                $('#payingVoucher').val(remaining);
                $('#voucherRemainingAmount').val('0');
                $(".mixed-payment").removeClass('d-none');
            }

            
             recalculate_totals();
            //set default focus
            setTimeout(function () {
                $("#payingCash").focus();
            }, 100); // 100ms delay
            


            //Hide Voucher Modal
            const modalEl = document.getElementById('voucherHtml');
            const myModal = bootstrap.Modal.getInstance(modalEl);
            myModal.hide();

           
        }
    }

    function arrayDifference(array1, array2) {
        var difference = [];
        for (var i = 0; i < array1.length; i++) {
            if ($.inArray(array1[i], array2) == -1) {
                difference.push(array1[i]);
            }
        }
        return difference;
    }

    function redeem_loyalty(){
        console.log('redeem loyalty');

        let loyalty_points = parseFloat($("#loyalty_points").html());
        let loyalty_Rate = parseFloat($("#loyalty_points").attr('data-loyalty-rate'));
        if(loyalty_points > 0 && loyalty_Rate > 0){

            let use_points = 0;

            Swal.fire({
                    input: "number",
                    inputLabel: "Total Available Point "+loyalty_points,
                    inputPlaceholder: "Enter Points You Want To Utilize Now . . .",
                    inputAttributes: {
                        "aria-label": "Use Loyalty Points"
                    },
                    showCancelButton: true,
                    icon: "question",
                    customClass: {
                        confirmButton: 'btn btn-primary me-2',
                        cancelButton: 'btn btn-secondary'
                    },
                    buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
                }).then((result) => {
                    if (result.value) {
                        if(result.value >= 0){
                            use_points = result.value;
                        }

                        
                        use_points = use_points * loyalty_Rate;
                        
                        var total_payable = $("#productTotalPayable").val();

                        

                        if(total_payable >= use_points){
                            //Nothing
                            $("#payingLoyalty").val(use_points);
                            $("#payingLoyalty").prop("disabled", true);
                        
                            $(".loyalty").removeClass("d-none");
                            $("#InvoiceNote").val($("#InvoiceNote").val() + ' | ' + use_points + ' Loyalty Points used for Payment!');
                        } else {
                            use_points = 0;
                        }
                            
                        
                        
                        recalculate_totals();

                    }
                
                });

            
        } else {
            $("#payingLoyalty").val("");
            $("#payingLoyalty").prop("disabled", false);
            $(".loyalty").addClass("d-none");
        }
        recalculate_totals();
    }

    function use_retained(){

        console.log('redeem loyalty');

        let retained_amount = parseFloat($("#retained_amount").html());
        
         Swal.fire({
                    input: "number",
                    inputLabel: "Total Available Point "+retained_amount,
                    inputPlaceholder: "Enter Points You Want To Utilize Now . . .",
                    inputAttributes: {
                        "aria-label": "Use Loyalty Points"
                    },
                    showCancelButton: true,
                    icon: "question",
                    customClass: {
                        confirmButton: 'btn btn-primary me-2',
                        cancelButton: 'btn btn-secondary'
                    },
                    buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
                }).then((result) => {

                    if(result.value){
                        if(result.value <= retained_amount){
                            $(".retainedamount").removeClass('d-none');
                            $("#payingRetained").val(result.value);
                        }
                        recalculate_totals();
                    }
                }
            );

    }

     function applycoupondiscount(){
        console.log('start');
        var couponnumber = $("#CouponNumber").val();
        
         $.ajax({
            type: 'GET',
            url: '{{ route("validate_coupon") }}',
            data: {
                coupon: couponnumber
            },
           success: function(data) {
                //console.log(data);
                var coupon = data.coupon;
                var orders = data.orders;
                //console.log(coupon);
                if(coupon!==null){
                    
                    console.log(coupon.coupon_type);
                    if(coupon.coupon_type =='order'){
                        $("#productDiscount").val(0);
                        $("#productDiscount").prop("readonly", true);
                        $("#productDiscountType").prop("disabled", true);
                        
                        for(a=0; a<orders.length; a++){
                            
                            $('#orders_table .order').each(function(y) {
                                // console.log($(this).data('id-order'));
                                // console.log(orders[a].order_id);
                                if ($(this).data('id-order') == orders[a].order_id) {
                                    //console.log('found');
                                    orderfound = true;

                                    let order_price = 0;
                                    let discount_amount = coupon.fixed_amount;
                                    let discount_type="Amount";

                                    order_price = parseFloat($(this).data('order-price')) || 0;

                                    if (coupon.discount_perc > 0) {                                        
                                        discount_amount = order_price * parseFloat(coupon.discount_perc) / 100;
                                        discount_type="Percentage";
                                    }
                                    console.log('discount amount from fixed amount: ' + discount_amount);
                                    // scope only to this row
                                    $(this).closest('tr').find('input[name=input-discount]')
                                        .val(discount_amount)
                                        .prop('readonly', true);

                                    var o = "<option data-order-price='" + order_price + "' data-discount-percentage= '"+ parseFloat(coupon.discount_perc) +"' data-discount-amount='"+ discount_amount +"' data-discount-type='" + discount_type + "' value='" + coupon.coupon_number + "'>" +coupon.coupon_number + "<option>";
                                    //find the discount type select
                                    console.log($(this).closest('tr').find('select[name=select-discount-type]').attr('id'));
                                    $(this).closest('tr').find('select[name=select-discount-type]')    
                                        .append(o)
                                        .prop('disabled', true);
                                    
                                    $("option:contains("+ coupon.coupon_number +")", $(this).closest('tr').find('select[name=select-discount-type]')).prop('selected', 'selected');    
                                    $(this).closest('tr').find('select[name=select-discount-type]').trigger('change');

                                    $('#CouponNumber').prop('readonly', true);

                                    let row = y + 1; // if you actually need this index
                                }
                            });
                        }
                       
                    } else {
                        
                        console.log(coupon['fixed_amount']);
                        discount_amount = coupon.fixed_amount;
                        let discount_type="Amount";

                        if (coupon.discount_perc > 0) {                                        
                            discount_amount = order_price * parseFloat(coupon.discount_perc) / 100;
                            let discount_type="Percentage";
                        }

                        $("#productDiscount").val(discount_amount);
                                                
                        recalculate_totals();
                        
                        var o = "<option data-price='" + $("#productSubtotal").val() + "' data-discount-percentage= '"+ parseFloat(coupon.discount_perc) +"' data-discount-amount='"+ discount_amount +"' data-discount-type='" + discount_type + "' value='" + coupon.coupon_number + "'>" +coupon.coupon_number + "<option>";
                        $("#productDiscountType").append(o);
                        $("option:contains("+ coupon['coupon_number'] +")", '#productDiscountType').prop('selected', 'selected');
                        
                       
                        $('#productDiscount').prop('disabled', true);
                        $("#productDiscountType").prop('disabled', true);
                        $('#CouponNumber').prop('readonly', true);
                    }
                    
                } else {
                   
                    Swal.fire({
                        text: "The provided coupon number " +couponnumber+" is INVALID or has EXPIRED.",
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: "btn btn-danger"
                        }
                    });
                }
               
           }
       });
     
    }


    function GenerateInvoice(){

        //check if balance invoice is allowed in business settings
        var allow_balance_invoice = "{{ $business->allow_balance }}";

        if(allow_balance_invoice == 'No'){
            if($("#BalanceAmount").val() != "" && parseFloat($("#BalanceAmount").val()) > 0 && $("#selectedPaymentMode").html().trim() != "Voucher" && parseFloat($("#payingRetained").val()) != 0){
                 Swal.fire({
                    text: "Balance Invoices are not allowed. Please receive the full amount to generate the invoice.",
                    icon: "error",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-danger"
                    }
                });
                return false;
            }
        }

        //Get all payment values
        payingNow = $("#PayingNow").val() != "" ? parseFloat($("#PayingNow").val()) : 0;
        payingCash = $("#payingCash").val() != "" ? parseFloat($("#payingCash").val()) : 0;
        payingCard = $("#payingCard").val() != "" ? parseFloat($("#payingCard").val()) : 0;
        
       
        
        payingLoyalty = $("#payingLoyalty").val() != "" ? parseFloat($("#payingLoyalty").val()) : 0;
        payingVoucher = $("#payingVoucher").val() != "" ? parseFloat($("#payingVoucher").val()) : 0;
        payingRetained = $("#payingRetained").val() != "" ? parseFloat($("#payingRetained").val()) : 0;

        paymentMode = $("#selectedPaymentMode").html() != "" ? $("#selectedPaymentMode").html().trim() : null;

        //Get Balance / Return / Retain Values
        subTotal = $("#productSubtotal").val();
        productTotalBeforeTax = $("#productTotalBeforeTax").val();
        balance = $("#BalanceAmount").val() != "" ? parseFloat($("#BalanceAmount").val()) : 0; 
        return_cash = $("#ReturnAmount").val() != "" ? parseFloat($("#ReturnAmount").val()) : 0;        
        retain = $("#retain").prop("checked") == true ? "Yes" : "No";
        var advance_amount = $("#productAdvance").val() != "" ? parseFloat($("#productAdvance").val()) : 0;     
        rounding_adjustment = $("#productAdjustment").val() != "" ? parseFloat($("#productAdjustment").val()) : 0;      
        productTotalAmount = $("#productTotalAmount").val() != "" ? parseFloat($("#productTotalAmount").val()) : 0; 
        productTotalPayable =   $("#productTotalPayable").val() != "" ? parseFloat($("#productTotalPayable").val()) : 0; 

        //get Credit Card or Online Transactions Related info
        CCFee = $("#productCCFee").val() != "" ? parseFloat($("#productCCFee").val()) : 0;
        CCTip = $("#productCCTip").val() != "" ? parseFloat($("#productCCTip").val()) : 0;
        instrument_number = $("#productInstrumentNumber").val() != "" ? $("#productInstrumentNumber").val() : null;
        productPOS = $("#productPOSCharges").val() != "" ? parseFloat($("#productPOSCharges").val()) : 0;

        //get Tax, Advance and Discount
        productDiscountType = $("#productDiscountType option:selected").val() != "" ? $("#productDiscountType option:selected").val() : null;
        productDiscount = $("#productDiscount").val() != "" ? parseFloat($("#productDiscount").val()) : 0;
        productOtherCharges = $("#productOtherCharges").val() != "" ? parseFloat($("#productOtherCharges").val()) : 0;
        productTax = $("#productTaxes").val() != "" ? parseFloat($("#productTaxes").val()) : 0; 
        

        productAdvance = $("#productAdvance").val() != "" ? parseFloat($("#productAdvance").val()) : 0;

        //Get Gift Voucher / Coupon / 
        productGiftVoucher = $("#productGiftVoucher").val() != "" ? $("#productGiftVoucher").val() : null;
        CouponNumber = $("#CouponNumber").val() != "" ? $("#CouponNumber").val() : null;

        
        //Get Order ID / Orders / Customer ID
        orderID =$("#orderID").val();
        customerID = $("#customerID").val();
        orderDate = $("#orderDate").val();
        invoiceNote = $("#InvoiceNote").val();

         var ordersData = [];
        $("#orders_table tr").each(function(row, tr){
           //console.log(tr);
            
                let data = {
                    order_id : $(this).find('td:eq(3)').attr('data-id-customer-order'),
                    order_product_id : $(this).attr('data-id-order-products'),
                    product_id : $(this).find('td:eq(3)').attr('data-id-product') != null ? $(this).find('td:eq(3)').attr('data-id-product') : null,
                    product : $(this).find('td:eq(3)').html() != null ? $(this).find('td:eq(3)').html().trim() : null,
                    
                    batch_id : $(this).find('td:eq(3)').attr('data-batch-id') != null ? $(this).find('td:eq(3)').attr('data-batch-id') : null,
                    batch : $(this).find('td:eq(3)').attr('data-batch') != null ? $(this).find('td:eq(3)').attr('data-batch').trim() : null,

                    order_price : $(this).find('td:eq(3)').attr('data-order-price') != null ? $(this).find('td:eq(3)').attr('data-order-price') : 0,
                    
                    order_type : $(this).find('td:eq(3)').attr('data-order-type') != null ? $(this).find('td:eq(3)').attr('data-order-type').trim() : null,
                    order_category : $(this).find('td:eq(3)').attr('data-order-category') != null ?  $(this).find('td:eq(3)').attr('data-order-category').trim() : null,
                    id_order_category : $(this).find('td:eq(3)').attr('data-id-order-category') != "" ? $(this).find('td:eq(3)').attr('data-id-order-category') : null,
                    id_order_type : $(this).find('td:eq(3)').attr('data-id-order-type') != "" ? $(this).find('td:eq(3)').attr('data-id-order-type') : null,
                    staff : $(this).find('td:eq(4)').html() != null ? $(this).find('td:eq(4)').html().trim() : null,
                    staff_id : $(this).find('td:eq(4)').attr('data-id-staff') != "" ? $(this).find('td:eq(4)').attr('data-id-staff') : null,
                    requested : $(this).find('td:eq(5)').find('input[name=requested]').prop("checked") == true ? "Yes" : "No",
                    membership: null, //membership not applicable for orders

                    product_quantity : $(this).find('td:eq(5)').find('input[name=input-quantity]').val() != "" ? $(this).find('td:eq(5)').find('input[name=input-quantity]').val() : 1,

                    unit_price : $(this).find('td:eq(6)').find('input[name=input-unit-price]').val() != "" ? $(this).find('td:eq(6)').find('input[name=input-unit-price]').val() : 0,

                    discount_type : $(this).find('td:eq(7)').find('select[name=select-discount-type] option:selected').text() != null ? $(this).find('td:eq(7)').find('select[name=select-discount-type] option:selected').text().trim() : null,

                    discount : $(this).find('td:eq(8)').find('input[name=input-discount]').val() != "" ? $(this).find('td:eq(8)').find('input[name=input-discount]').val() : 0,

                    addition : $(this).find('td:eq(10)').find('input[name=input-addition]').val() != "" ? $(this).find('td:eq(10)').find('input[name=input-addition]').val() : 0,
                    subtotal : $(this).find('td:eq(11)').find('input[name=input-subtotal]').val() != "" ? $(this).find('td:eq(11)').find('input[name=input-subtotal]').val() : 0, //order Subtotal

                    tax : $(this).find('td:eq(12)').html() != null ? $(this).find('td:eq(12)').html().trim() : 0, //order Tax

                    final_order_price : $(this).find('td:eq(12-13)').html() != null ? $(this).find('td:eq(13)').html().trim() : 0, //final Order Price
                }
                //console.log(data);
                ordersData.push(data);
                

        });
        ordersData.shift();  // first row will be empty - so remove
        //ordersData.pop();  // last row will be empty - so remove

        if(ordersData.length < 1){
            Swal.fire({
                text: "There are no products in this order.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        if(orderID=="" || customerID==""){
            Swal.fire({
                text: "Customer Not Mentioned or No Order Selected.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        if((paymentMode =='Card' || paymentMode =='Mixed' || paymentMode =='D-Card' || paymentMode =='Online' || paymentMode =='Mixed' || paymentMode =='Check') && (instrument_number == '' || instrument_number === null)){
           Swal.fire({
                text: "Instrument number is required for the selected payment mode.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        var giftVoucherRemainingAmount = $("#voucherRemainingAmount").val() || 0;
        var giftVoucherRemainingServices = $("#voucherRemainingServices").val() || '';

        try {

            $("#saveInvoiceButton").prop("disabled", true);
            $("#generateInvoiceSpinner").removeClass("d-none");

            $.ajax({
                url : "{{ route('create_order_invoice') }}",
                data: { 
                    "id_customer_orders" : orderID,  
                    "visit_date" : orderDate,  
                    "id_customers" : customerID, 
                    "invoice_type" : 'sale',
                    "sub_total" : subTotal,
                    "taxes" : productTax, 
                    "gross_wo_tax" : productTotalBeforeTax,
                    "advance" : advance_amount,
                    "total_payable" : productTotalPayable,
                    "total_amount" : productTotalAmount,
                    "paid_amount" : payingNow,
                    "paid_cash" : payingCash,
                    "paid_card" : payingCard,   
                    "taxes" : productTax,
                    "paid_voucher" : payingVoucher,
                    "paid_loyalty" : payingLoyalty,
                    "paid_ratained" : payingRetained, 
                    "return_cash" : return_cash,
                    "retain" : retain, 
                    "balance" : balance,
                    "is_recovery" : balance > 0 ? "Yes" : "No",
                    "reference_invoice_number" : null,
                    "paid_earlier" : 0,
                    "rounded_adjustment" : rounding_adjustment,
                    "payment_mode" : paymentMode,
                    "voucher_number" : productGiftVoucher,
                    "gift_vouche_remaining_amount" : giftVoucherRemainingAmount,
                    "gift_voucher_remaining_services" : giftVoucherRemainingServices,
                    "coupon_number" : CouponNumber,
                    "instrument_number" : instrument_number,
                    "invoice_remarks" : invoiceNote,
                    "cc_fee": CCFee,
                    "cc_tip" : CCTip,
                    "pos_fee" : productPOS,
                    "delivery_charges" : $("#deliveryCharges").val() || 0,
                    "business_store_id" : $("#business_store_id").val() || 0,
                    "products" : ordersData

                },
                type: "POST", // The POST method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {

                    $("#saveInvoiceButton").prop("disabled", false);
                    $("#generateInvoiceSpinner").addClass("d-none"); 
                    
                    var btn = "btn btn-" +data.message_btn;
                    Swal.fire({
                        text: data.message,
                        icon: data.message_type,
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: btn
                        }
                    });

                    if(data.message_type == "success"){
                        url = "{{ route('existing_invoice', ['invoice_id' => ':id']) }}";
                        url = url.replace(':id', data.new_id_invoice);
                        if(is_pos_request){
                            //---------- POS PART START 
                                const el = document.getElementById('invoiceModal');
                                const modal = bootstrap.Modal.getInstance(el);
                                if (modal) { modal.hide();}
                                $("#invoiceModalBody").empty();
                                $('#running-order-'+orderID).remove();
                                clearCart();
                                window.open(url, '_blank');
                            //---------- POS PART END     
                        }else{
                         location.href = url;
                        }
                    }
                    if(data.product_shortage == true){

                          let shortageHtml = "";
                            if (data.data && data.data.length > 0) {
                                shortageHtml += `
                                    <table class="table table-bordered text-start" style="font-size:14px;">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Product</th>
                                                <th>O.Qty</th>
                                                <th>Avail</th>
                                                <th>Short</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                `;
                                data.data.forEach(item => {
                                    shortageHtml += `
                                        <tr>
                                            <td><a href="${item.product_batch_route}" target="_blank">${item.productid}</a></td>
                                            <td><a href="${item.product_batch_route}" target="_blank">${item.productname}</a></td>
                                            <td>${item.required_qty}</td>
                                            <td>${item.available_qty}</td>
                                            <td class="text-danger fw-bold">${item.shortage}</td>
                                        </tr>
                                    `;
                                });
                                shortageHtml += `</tbody></table>`;
                            }
                            Swal.fire({
                                icon: data.message_type,
                                title: data.message,
                                width: '40%',
                                html: `
                                    <div style="text-align:left;">
                                        ${shortageHtml}
                                    </div>
                                `,
                                confirmButtonText: 'OK',
                                customClass: {
                                    confirmButton: 'btn btn-danger'
                                }
                            });
                            
                    }

                },
                error: function(xhr, status, error) {
                    $("#saveInvoiceButton").prop("disabled", false);
                    $("#generateInvoiceSpinner").addClass("d-none");
                    // Handle errors
                    console.error("AJAX Error:", status, error);
                }  
            });
        } catch (e) {
            console.error("JS error before AJAX:", e);
        }
    }

//////////////////////// NEW ORDER CREATION FUNCTIONS ////////////////////////

    function add_product(){

        let data = $("#selectProduct").select2('data');
        data = data[0]; 

        var product_id = data.id;
        var product_name = data.text;
        var product_brand = data.brand;
        var product_batch_id = data.batch_id;
        var product_batch_no = data.batch_no;
        var product_price = parseFloat(data.price);
        var product_qty_per_unit = parseFloat(data.qty_per_unit);
        var product_measure_unit = data.measure_unit;
        
        
        if(product_id == "" || product_id == null){
            Swal.fire({
                text: "Please select a product to add.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        // if(isNaN(product_quantity) || product_quantity <= 0){
        //     Swal.fire({
        //         text: "Please enter a valid quantity.",
        //         icon: "info",
        //         buttonsStyling: false,
        //         confirmButtonText: "Ok",
        //         customClass: {
        //             confirmButton: "btn btn-info"
        //         }
        //     });
        //     return false;
        // }

        if(isNaN(product_price) || product_price < 0){
            Swal.fire({
                text: "Please enter a valid price.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        var total_price = product_price; // * product_quantity;

        //Add to the table
        var newRow = '<tr data-id-product="' + product_id + '">' +
                        '<td>' + product_id + '</td>' +
                        '<td>' + product_name + '</td>' +
                        '<td>' + product_brand + '</td>' +
                        '<td data-batch-no="' + product_batch_no + '">' + product_batch_id + '</td>' +
                        '<td class="text-end"></td>' +
                        '<td class="text-end">' + product_price.toFixed(2) + '</td>' +
                        '<td class="text-end">' + total_price.toFixed(2) + '</td>' +
                        '<td class="text-center"><button class="btn btn-sm btn-danger" onclick="remove_product_from_table(this);"><i class="ti ti-trash"></i></button></td>' +
                    '</tr>';

        $("#orders_table").append(newRow);
    }

</script>
@endsection