@extends('layouts.horizontal', ['title' => 'Create Service Invoice', 'topbarTitle' => 'Create Invoice', 'nonav' => true])

@section('css')
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])
@endsection

@section('content')

<div class="row">
    <div class="col-12">
        <div class="card position-relative">
            <form>
                <div class="card-body">
                    <!-- Invoice Logo-->
                    <div class="d-flex align-items-start justify-content-between mb-4">
                         <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72x;">
                            <img style="height: 72px;" id="logo" src="{{ asset('images').'/business/'.$business->business_logo }}" alt="{{ $business->business_name }}">
                        </div>     
                        <div class="text-end">
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label for="VisitNo" class="col-form-label fs-16 fw-bold">#VISIT</label>
                                </div>
                                <div class="col-auto">
                                    <input type="number" id="visitID" class="form-control border-0" readonly="readonly" placeholder="00001234" value="{{ $visit->id_customer_visits }}">
                                    <input type="hidden" id="customerID" value="{{ $visit->customer_id }}">
                                    
                                </div>
                            </div>
                            <div class="row g-1 align-items-center">
                                <div class="col-auto">
                                    <label  class="col-form-label fs-16 fw-bold d-print-none">DATE</label>
                                </div>
                                <div class="col-auto">
                                    <input type="text" readonly="readonly" id="visitDate" class="form-control  border-0" placeholder="Select Date" value="{{ $visit->customer_visit_date }}">
                                </div> 
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        
                        <div class="col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-0">
                            <div class="mb-2">
                                <label class="form-label">Billing Address :</label>
                                <div class="">
                                    <input type="text" id="BName" readonly="readonly" class="form-control  border-0" placeholder="Full Name" value="{{ $customer->customer_name }}">
                                </div>
                                <div  class=""> 
                                    <input type="text" id="BNumber" readonly="readonly" class="form-control  border-0" placeholder="Phone Number" value="{{ $customer->customer_cell }}">
                                </div>
                                <div class="d-print-none d-none">
                                    <textarea type="text" id="BAddress" readonly="readonly" rows="3" class="form-control  border-0" placeholder="Address"  >{{ '' != $customer->customer_address ? $customer->customer_address : $customer->customer_area }}</textarea>
                                </div>                                
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3 d-print-none">                            
                        </div>
                       <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mt-sm-0 mt-3 d-print-none">
                        </div>
                    </div>

                    <div class="mt-1">
                        <div class="table">
                            <table class="table text-center  mb-0" id="services_table">
                                <thead>
                                    <tr class="bg-light bg-opacity-50">
                                        <th scope="col" class="border-0 d-print-none" style="width: 30px;">...</th>
                                        <th scope="col" class="border-0 d-print-none" style="width: 30px;">#</th>
                                        <th scope="col" class="border-0 d-print-none text-start" style="width: 50px">Item</th>
                                        <th scope="col" class="border-0 text-start" style="width: 140px;">Discription</th>
                                        <th scope="col" class="border-0 text-start " style="width: 100px;">Staff</th>
                                        <th scope="col" class="border-0  d-print-none" style="width: 70px">Requested</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Discount Type</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Discount</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Addition</th>
                                        <th scope="col" class="border-0  text-start d-print-none" style="width: 50px;">Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php 
                                        $subTotal=0; 
                                        $row = 1; 
                                    @endphp

                                    @foreach($visit_services as $service)
                                    <tr>
                                        <td class="d-print-none">
                                            <button onclick="removeService();" type="button" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger">
                                                <iconify-icon icon="solar:trash-bin-trash-bold-duotone"class="fs-20"></iconify-icon>
                                            </button>
                                        </td>
                                        <td scope="row" class="d-print-none">{{ $row }}</td>

                                        <td class="text-start d-print-none">
                                            {{ $service->s_type }}
                                        </td>
                                        <td class="text-start service" data-id-visit-services="{{ $service->id_visit_services }}" data-id-service="{{ $service->service_id }}" data-service-price="{{ $service->s_rate }}" data-service-flag="{{ $service->service_flag }}" data-service-type="{{ $service->s_type }}" data-service-category="{{ $service->s_category }}" data-id-service-type="{{ $service->id_service_type }}" data-id-service-category="{{ $service->id_service_category }}">
                                            {{ $service->service_name }}
                                        </td>
                                        <td class="text-start">
                                            {!! $service->staff !!}
                                        </td>
                                        <td class="d-print-none">                                            
                                            <input class="form-check-input fs-16 text-primary" {{ $service->requested }} name="requested" type="checkbox">                                            
                                        </td>
                                        <td class="d-print-none">
                                            <select id="service_discount_type_{{ $service->id_visit_services }}" onchange="service_discount('{{ $service->id_visit_services }}');" class="form-select" name="select-discount-type">
                                                <option value=""></option>
                                                @foreach($discount_types as $dt)
                                                    <option data-service-price = "{{ $service->s_rate }}" data-discount-percentage="{{ $dt->discount_perc }}" data-discount-amount="{{ $dt->fixed_amount }}" data-discount-type="{{ $dt->discount_perc > 0 ? 'Percentage' : 'Amount' }}" value="{{ $dt->discount_reason }}">{{  $dt->discount_perc > 0 ? $dt->discount_reason . ' ' . $dt->discount_perc .'%' : $dt->discount_reason .' '. $dt->fixed_amount }}</option>
                                                @endforeach
                                            </select>
                                        </td>
                                        <td class="d-print-none">
                                            <input id="service_discount_{{ $service->id_visit_services }}"  class="form-control decimal" name="input-discount" value="0.00">
                                        </td>
                                        <td class="d-print-none">
                                            <input onchange="service_discount('{{ $service->id_visit_services }}');" id="service_addition_{{ $service->id_visit_services }}" class="form-control decimal" name="input-addition" value="0.00">
                                        </td>
                                        <td class="d-print-none" id="service_price_{{ $service->id_visit_services }}" data-s-rate="{{ $service->s_rate }}">
                                            {{ $service->s_rate }}
                                        </td>
                                        @php 
                                            $subTotal = $subTotal + $service->s_rate;
                                        @endphp 
                                    </tr>
                                    @php $row++ @endphp
                                    @endforeach
                                    
                                </tbody>
                            </table><!--end table-->
                            
                        </div>
                        <div class="row  d-print-none">
                            <div class="col-6 mt-4 d-print-none">
                                <div class="row">
                                    <div class="col-8">
                                        <input class="form-control" placeholder="Discount Coupon#" id="CouponNumber" style="display:inline">
                                    </div>
                                    <div class="col-4">
                                        <button type="button" onclick="applycoupondiscount();" style="display:inline"  class="btn btn-primary"><i class="ti ti-circle-plus me-1"></i> Apply</button>
                                    </div>
                                </div>
                                <div>
                                    <label class="form-label" for="InvoiceNote"> Note : </label>
                                    <textarea class="form-control" id="InvoiceNote" placeholder="Any Information you need to save with the invoice . . . " rows="3"></textarea>
                                </div>
                            </div>
                            <div class="col-6">
                                <table class="table table-sm table-borderless table-nowrap align-middle mb-0 ms-auto" style="width:300px">
                                    <tbody>
                                        <tr>
                                            <td class="fw-medium">Subtotal {{  config('constants.CURRENCY') }}</td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productSubtotal" readonly="readonly" class="form-control text-end" placeholder="0.00" value="{{ sprintf('%.2f', $subTotal) }}">
                                                </div>
                                            </td>
                                        </tr>
                                        
                                        <tr>
                                            <td class="fw-medium">
                                                 <select onchange="invoiceDiscountChanged();" id="productDiscountType" class="form-select discount-type" placeholder="Select Discount Type">
                                                        <option value=""><small class="text-muted">Select Discount Type</small></option>
                                                        @foreach($discount_types as $dt)
                                                            @php 
                                                                $discount_name = $dt->discount_perc > 0 ? $dt->discount_reason . ' ' . $dt->discount_perc .'%' : $dt->discount_reason .' '. $dt->fixed_amount; 
                                                            @endphp
                                                            <option {{ $discount_name == $visit->discount_reason ? 'selected' : '' }} data-price = "{{ $subTotal }}" data-discount-percentage="{{ $dt->discount_perc }}" data-discount-amount="{{ $dt->fixed_amount }}" data-discount-type="{{ $dt->discount_perc > 0 ? 'Percentage' : 'Amount' }}" value="{{ $dt->discount_reason }}">{{  $dt->discount_perc > 0 ? $dt->discount_reason . ' ' . $dt->discount_perc .'%' : $dt->discount_reason .' '. $dt->fixed_amount }}</option>
                                                        @endforeach
                                                    </select> 
                                        
                                            </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input onchange="recalculate_totals();" readonly="readonly" type="number" id="productDiscount" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ $visit->discount }}">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Other Charges </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input onchange="recalculate_totals();" type="number" id="productOtherCharges" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Before Tax</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalBeforeTax" disabled class="form-control text-end" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ sprintf('%.2f' , ($subTotal + $visit->other_charges) - $visit->discount)  }}">
                                                </div>
                                            </th>
                                        </tr>
                                        @php $tax_amount = 0; @endphp
                                        @foreach($business_taxes as $bt)
                                        <tr data-tax-mode = "{{ $bt->tax_payment_mode }}" class="tax-item {{ strtoupper($bt->tax_payment_mode) == 'CASH' ? '' : 'd-none' }}">
                                            <td data-tax-mode = "{{ $bt->tax_payment_mode }}" class="fw-medium">{{ $bt->tax_name }} <small class="text-muted">({{ $bt->tax_percentage }}%)</small></td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    @php
                                                        $tax_perc = $bt->tax_percentage;
                                                        $tax_amount = ($subTotal*$tax_perc)/100;
                                                    @endphp
                                                    <input type="number" id="productTaxes_{{ $bt->id_business_taxes }}" readonly="readonly" data-tax-percentage="{{ $bt->tax_percentage }}" class="form-control text-end tax" placeholder="{{ config('constants.CURRENCY') }}0.00" value= "{{ sprintf('%.2f' , $tax_amount) }}">
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Amount</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalAmount" disabled class="form-control text-end" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ sprintf('%.2f' , ($subTotal + $tax_amount) - $visit->discount) }}">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="credit-card-item credit-card-fee-item d-none">
                                            <td class="fw-medium">CC Fee </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productCCFee" data-cc-fee="{{ $business->cc_charge }}" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="credit-card-item d-none">
                                            <td class="fw-medium">CC Tip </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" onkeyup="recalculate_totals();" id="productCCTip" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        
                                        <tr class="{{ $business->imsfiscal == 'No' && $business->srb_fiscal_service=='No' ? 'd-none' : '' }} POSCharges">
                                            <td class="fw-bold">POS Charges </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productPOSCharges" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ $business->imsfiscal == 'Yes' || $business->srb_fiscal_service == 'Yes' ? (!empty($business->ims_fee) ? $business->srb_fees : '0.00') : '0.00' }}">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Advance </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productAdvance" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00" value="{{ $visit_advance->advance_amount }}">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-medium">Rounding Adjustment </td>
                                            <td class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productAdjustment" readonly="readonly" class="form-control text-end decimal" placeholder="{{ config('constants.CURRENCY') }}0.00">
                                                </div>
                                            </td>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold">Total Payable</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="productTotalPayable" disabled class="form-control text-end" placeholder="Rs0.00" value="{{ sprintf('%.2f' , ($subTotal + $tax_amount) - ($visit->discount + $visit_advance->advance_amount))  }}">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-bold fs-20">Paying Now</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="PayingNow"  class="form-control text-end" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none mixed-payment">
                                            <th scope="row" class="fw-bold text-success">Paid Cash</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingCash" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none mixed-payment">
                                            <th scope="row" class="fw-bold text-success">Paid Card</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingCard"  class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>                                        
                                        <tr class="fs-15 d-none loyalty">
                                            <th scope="row" class="fw-bold text-success">Loyalty Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingLoyalty" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none retainedamount">
                                            <th scope="row" class="fw-bold text-success">Retained Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingRetained" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none giftvoucher">
                                            <th scope="row" class="fw-bold text-success">Voucher Used</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="payingVoucher" readonly="readonly" onkeyup="recalculate_totals();" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium  text-success">Return Cash</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="ReturnAmount" readonly="readonly" class="form-control text-end text-success payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                    <div class="form-checkbox-dark">
                                                        <input type="checkbox" class="form-check-input text-secondary me-1" id="retain"><label class="form-label label-sm" for="retain">Retain</label>
                                                    </div>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium text-danger">Balance</th>
                                            <th class="text-end">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="number" id="BalanceAmount" readonly="readonly" class="form-control text-end text-danger payment" placeholder="{{ config('constants.CURRENCY') }}0.00" value="">
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none instrument-number-item">
                                            <th scope="row" class="fw-medium border-1">Instrument # : </th>
                                            <th class="border-1 ">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <input type="text" class="form-control" id="productInstrumentNumber" placeholder="xxxx" value="">     
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15 d-none gift-voucher-item">
                                            <th scope="row" class="fw-medium border-1">Verify Voucher# : </th>
                                            <th class="border-1 ">
                                                <div class="input-group ms-auto" class="d-flex" style="width: 160px;">
                                                    <input type="text" style="width:80px;" class="form-control" id="productGiftVoucher" placeholder="xxx" value="">  
                                                    <button type="button" style="width:50px;" onclick="verifyVoucher();" class="btn btn-sm btn-success">
                                                        <iconify-icon icon="solar:check-read-broken"class="fs-24"></iconify-icon>
                                                    </button>
                                                </div>
                                            </th>
                                        </tr>
                                        <tr class="fs-15">
                                            <th scope="row" class="fw-medium border-1">Payment Mode : </th>
                                            <th class="border-1 ">
                                                <div class="ms-auto" style="width: 160px;">
                                                    <label><span id="selectedPaymentMode">Cash</span></label>     
                                                </div>
                                            </th>
                                        </tr>
                                    </tbody>
                                </table>
                            <!--end table-->

                            </div>
                        </div>
                    </div>
                    <div class="card-foorter d-print-none mt-4">
                        <div class="row">
                            <div class="col-4 text-success">
                                <span class="">Customer Retained Amount: {{ config('constants.CURRENCY') }} </span><span id="retained_amount" class="gap-1">{{ $retained_amount }}</span>
                                <button type="button" onclick="use_retained()" class="btn btn-light gap-1"><i class ="ti ti-moneybag fs-16"></i> Retained</button>
                            </div>
                            <div class="col-4 text-success">
                                <span class="">Loyalty Points: {{ config('constants.CURRENCY') }} </span><span data-loyalty-rate="{{ $business->l_point_discount }}" id="loyalty_points" class="gap-1">{{ $customer->loyalty_points }}</span>
                                <button type="button" onclick="redeem_loyalty();"  class="btn btn-light gap-1"><i class ="ti ti-affiliate fs-16"></i> Loyalty</button>
                            </div>
                            <div class="col-4 text-end">
                                <a href="javascript:window.print()"  type="button" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-success">
                                    <iconify-icon icon="solar:printer-line-duotone"class="fs-24"></iconify-icon>
                                </a>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-info dropdown-toggle  gap-1" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class ="ti ti-cash-register fs-16"></i> Payment Mode</button>
                                    <div class="dropdown-menu">
                                        <a style="cursor:pointer" onclick="paymentModeChange('Cash');" class="dropdown-item">Cash</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Card');" class="dropdown-item">Card</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('D-Card');" class="dropdown-item">Debit Card</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Online');" class="dropdown-item">Online</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Check');" class="dropdown-item">Bank Transfer</a>
                                        <div class="dropdown-divider"></div>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Voucher');" class="dropdown-item">Gift Voucher</a>
                                        <a style="cursor:pointer" onclick="paymentModeChange('Mixed');" class="dropdown-item">Mixed</a>                                        
                                    </div>
                                </div>
                                
                                <button id="saveInvoiceButton" type="button" onclick="GenerateInvoice();" class="btn btn-success gap-1"><span id="generateInvoiceSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" ></span>  <i class="ti ti-device-floppy fs-16"></i> Save</button>
                            </div>
                        </div>

                    </div>
                </div> <!-- end card-body-->
            </form>
        </div><!-- end card -->
        
    </div>

    <div id="voucherHtml" class="modal fade in" tabindex="-1" role="dialog" aria-labelledby="voucherHtml" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-md" >
            <div class="modal-content">
                <div class="modal-header">                    
                    <h4 class="modal-title" id="custom-width-modalLabel">Voucher Verification</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="voucherRemainingServices">
                    <input type="hidden" id="voucherRemainingAmount">
                    <div id="voucher-details">

                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

@endsection

@section('scripts')
<script>

    let timer = null;
    let baseURL = '{{ url("") }}'; // Use relative paths
    document.getElementById("payingCard").onchange = function () {
        // clearTimeout(timer); // cancel previous timer
        // timer = setTimeout(() => {
            recalculate_totals();
        //}, 1000); // 1 second delay
    };

    document.getElementById("PayingNow").onchange = function () {
        if($("#selectedPaymentMode").html() == "Cash"){
            recalculate_totals();
        } else {
            // clearTimeout(timer); // cancel previous timer
            // timer = setTimeout(() => {
                recalculate_totals();
            //}, 1000); // 1 second delay
        }
    };

    $(document).ready(function() {
        recalculate_totals();
        $("#PayingNow").focus();

    });

    function service_discount(id_visit_services){

        let discount_type_El = "#service_discount_type_"+id_visit_services + " option:selected";
        let discount_input_El = "#service_discount_"+id_visit_services;
        let price_El = "#service_discount_type_"+id_visit_services + " option:selected";
        let addition_input_El = "#service_addition_" + id_visit_services;

        let discount_type = $(discount_type_El).attr("data-discount-type"); 
        let price = $(discount_type_El).attr("data-service-price"); 
        let discount_amount = $(discount_type_El).attr("data-discount-amount"); 
        let discount_perc = $(discount_type_El).attr("data-discount-percentage"); 
        
        let addition_amount = 0; 
        if($(addition_input_El).val() > 0){
            addition_amount = $(addition_input_El).val();
            //console.log(addition_amount);
        }
        var discount = 0;
        if(discount_type == "Percentage"){
            discount = (parseFloat(price)*parseFloat(discount_perc))/100
        }else if(discount_type == "Amount"){
            discount = discount_amount;
        }

        let service_price_El = "#service_price_"+id_visit_services;
        let org_price = $(service_price_El).attr("data-s-rate");
        

        let discounted_price = (parseFloat(org_price) - discount) + parseFloat(addition_amount); 
        

        if(discount > org_price){
            Swal.fire({
                text: "Discount cannot be more then the Service Price.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            });
             $(discount_input_El).val("0.00");
            $("#service_price_"+id_visit_services).html(org_price);
            return false;
        }

        $(discount_input_El).val(discount);
             
        $("#service_price_"+id_visit_services).html(discounted_price.toFixed(2));
        
        recalculate_totals();

    }

    function invoiceDiscountChanged(){

        let discount_type = $("#productDiscountType option:selected").attr("data-discount-type");       
        //console.log(discount_type);

        let discount_amount = $("#productDiscountType  option:selected").attr("data-discount-amount"); 
        let discount_perc = $("#productDiscountType  option:selected").attr("data-discount-percentage"); 
        let org_price = $("#productSubtotal").val();

        let addition_amount = 0; 
        if($("#productOtherCharges").val() > 0){
            addition_amount = $("#productOtherCharges").val();           
        }

        var discount = 0;
        if(discount_type == "Percentage"){
            discount = (parseFloat(org_price)*parseFloat(discount_perc))/100
        }else if(discount_type == "Amount"){
            discount = discount_amount;
        }
        // console.log(org_price);
        // console.log(discount);
        // console.log(addition_amount);

        let discounted_price = (parseFloat(org_price) - discount) + parseFloat(addition_amount); 

        if(discount > org_price){
            Swal.fire({
                text: "Discount cannot be more then the Service Price.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            });
             $(discount_input_El).val("0.00");
            $("#service_price_"+id_visit_services).html(org_price);
            return false;
        }

        $("#productDiscount").val(discount);
        
        recalculate_totals();

    }


    function recalculate_totals(){
        //Disable Save Button
        $("#saveInvoiceButton").prop("disabled", true);
        $("#generateInvoiceSpinner").removeClass("d-none");

        let subTotal = 0; 
        let discountTotal = 0;
        let service_price=0;
        $('#services_table tr').each(function(row, tr) {
            if(row>0){
                //sub total           
                service_price = $(tr).find('td:eq(9)').text().trim();
                if( '' != service_price){
                    subTotal = subTotal + parseFloat(service_price);
                }
            }
        });       

        $("#productSubtotal").val(subTotal.toFixed(2));        

        let invoice_discount = $("#productDiscount").val() != '' ?  parseFloat($("#productDiscount").val()) : 0;
        let other_charges = $("#productOtherCharges").val() != '' ?  parseFloat($("#productOtherCharges").val()) : 0;
        
        let total_before_tax = (subTotal + other_charges) - invoice_discount;

        $("#productTotalBeforeTax").val(total_before_tax.toFixed(2));

        let tax = 0;
        $(".tax").each(function (index, value){
            if($(this).closest('tr').hasClass('d-none')){

            } else {
                let tax_perc = $(this).attr("data-tax-percentage");
                let tax_amount = ((subTotal + other_charges -invoice_discount) * tax_perc)/100;
                //console.log(tax_perc + ' - ' + tax_amount);
                tax = tax + parseFloat(tax_amount);
                $(this).val(tax_amount.toFixed(2));
            }
        });

        // console.log('subTotal  '+ subTotal);
        // console.log('- invoice_discount '+ invoice_discount);
        // console.log(' + other charges '+ other_charges);
        // console.log(' + total before tax  '+ total_before_tax);
        // console.log(' + tax  '+ tax);
        

        let totalAmount = (total_before_tax + tax);
        //console.log('totalAmount  '+ totalAmount);
        $("#productTotalAmount").val(totalAmount.toFixed(2));

        let totalPayable = totalAmount;
        //CC items addition
        $(".credit-card-item").each(function(index, input){
            
            if($(this).hasClass('d-none')){
                // Do Nothing
            } else {                  
                if($("#selectedPaymentMode").html()!="Cash" || $("#selectedPaymentMode").html()!="Voucher") {                    
                    //check if cc charge is defined
                        let cc_charge = $(this).find('input').attr("data-cc-fee");
                        if(cc_charge != null && cc_charge != 'undefined'){
                            //console.log("ccfee " + $(this).find('input').attr("data-cc-fee")); 
                            //Add cc charge if defined
                            if($('#PayingNow').val() != "" && parseFloat($('#PayingNow').val()) > 0){
                                //console.log("PayingNow " + $("#PayingNow").val());
                                totalCCFee = parseFloat(cc_charge) * parseFloat($('#PayingNow').val())/100;
                                $(this).find('input').val(totalCCFee.toFixed(2));
                                thisVal = parseFloat(thisVal) + parseFloat(totalCCFee);
                            } else if($("#payingCard").val() != "" && parseFloat($("#payingCard").val()) > 0){
                                //console.log("paying card " + $("#payingCard").val());
                                totalCCFee = parseFloat(cc_charge) * parseFloat($("#payingCard").val())/100;
                                $(this).find('input').val(totalCCFee.toFixed(2));
                                thisVal = parseFloat(thisVal) + parseFloat(totalCCFee);
                            } else {
                                $(this).find('input').val("0.00");
                            }

                            var thisVal = $(this).find('input').val() != "" ? $(this).find('input').val() : 0;

                            totalPayable = totalPayable + parseFloat(thisVal);
                            //console.log(parseFloat($('#PayingNow').val()) < totalPayable);
                            if($('#PayingNow').val() != "" &&  parseFloat($('#PayingNow').val()) != 0 && parseFloat($('#PayingNow').val()) < totalPayable && parseFloat($("#productCCFee").val()) > 0){
                                $('#PayingNow').val(parseFloat($('#PayingNow').val()) + parseFloat(thisVal));
                                $("#PayingNow").val(Math.round(parseFloat($("#PayingNow").val())));
                            } else if ($("#payingCard").val() != "" && parseFloat($("#payingCard").val()) != 0 && parseFloat($("#payingCard").val()) < totalPayable && parseFloat($("#productCCFee").val()) > 0){
                                $("#payingCard").val(parseFloat($("#payingCard").val()) + parseFloat(thisVal));
                                $("#payingCard").val(Math.round(parseFloat($("#payingCard").val())));
                            }

                        } else { //it is TIP

                            let cc_tip = $(this).find('input').val() != "" ? $(this).find('input').val() : 0;
                            totalPayable = totalPayable + parseFloat(cc_tip);

                        }
                    
                } else {
                    $(this).find('input').val("0.00");
                }

                
            }
        });
        

        //Add POS Charges
        if($(".POSCharges").hasClass("d-none")){

        }else{
            let totalPOSCharge = $("#productPOSCharges").val() != "" ? parseFloat($("#productPOSCharges").val()) : 0 ;
            totalPayable = totalPayable + parseFloat(totalPOSCharge);
        }

        //Subtract Advance Amount
        let totalAdvance = $("#productAdvance").val() != "" ? parseFloat($("#productAdvance").val()) : 0;
        //console.log($("#productAdvance").val());
        totalPayable = totalPayable - totalAdvance;

        //Round it Off
        let totalRounding = getDecimalDigits(totalPayable);
       
        totalRounding = totalRounding != null ? parseFloat("0." + totalRounding) : 0;
        
       // console.log(totalRounding);
        if(totalRounding >= 0.5){
            totalPayable = totalPayable + (1 -totalRounding);
             $("#productAdjustment").val((1-totalRounding).toFixed(2));
        } else {
            totalPayable = totalPayable - totalRounding;
             $("#productAdjustment").val(totalRounding.toFixed(2));
        }              

        $("#productTotalPayable").val(totalPayable.toFixed(2));

        //Check paying now return and balance
        let PayingNow = $("#PayingNow").val() != "" ? $("#PayingNow").val() : 0;
        let payingCash = $("#payingCash").val() != "" ? $("#payingCash").val() : 0;
        let payingCard = $("#payingCard").val() != "" ? $("#payingCard").val() : 0;
        let payingLoyalty = $("#payingLoyalty").val() != "" ? $("#payingLoyalty").val() : 0;
        let payingRatained = $("#payingRetained").val() != "" ? $("#payingRetained").val() : 0;
        let payingVoucher = $("#payingVoucher").val() != "" ? $("#payingVoucher").val() : 0;

            // console.log(payingLoyalty);
            // console.log(payingRatained);
            // console.log(payingVoucher);

        let difference = totalPayable - (parseFloat(PayingNow) + parseFloat(payingCash) + parseFloat(payingCard) + parseFloat(payingLoyalty) + parseFloat(payingRatained) + parseFloat(payingVoucher));

        // console.log(difference);
        if(difference < 0){
            $("#ReturnAmount").val((difference * -1).toFixed(2)) 
            $("#BalanceAmount").val("");
        } else if(difference >= 0) {
            $("#ReturnAmount").val("");
            $("#BalanceAmount").val(difference.toFixed(2));
        }
        //Enable Save Button
        $("#saveInvoiceButton").prop("disabled", false);
        $("#generateInvoiceSpinner").addClass("d-none");

    }

    function getDecimalDigits(num) {
        if (num % 1 === 0) {
            return null; // no decimals
        }
        return num.toString().split(".")[1];
    }

    function paymentModeChange(mode){
        $("#PayingNow").val("");
        $(".payment").val("");
        // recalculate_totals();

        $("#PayingNow").prop('disabled',false);
        $('.loyalty').addClass('d-none');
        $('.retainedamount').addClass('d-none');
        $('.giftvoucher').addClass('d-none');

        $(".mixed-payment").addClass('d-none');
        $("#retain").prop("checked", false);

        $(".tax-item").addClass('d-none');
               
        $(".tax-item[data-tax-mode='"+mode+"']").removeClass("d-none"); //Enable one

        let visibleCount = $(".tax-item").not(".d-none").length;
        if(visibleCount <=0 ){            
            $(".tax-item[data-tax-mode='All']").removeClass("d-none"); //Enable one
        }
        //set default focus
        setTimeout(function () {
            $("#PayingNow").focus();
        }, 100); // 100ms delay

        if(mode != 'Cash'  &&  mode != 'Voucher'){            
            $(".credit-card-item").removeClass('d-none');
            $(".instrument-number-item").removeClass('d-none');   
            $(".gift-voucher-item").addClass('d-none');
            console.log(mode);
            if(mode == "Card"){
                
                $(".credit-card-fee-item").removeClass('d-none');
                let cc_charge = $("#productCCFee").attr("data-cc-fee");
                // /cc_charge != "" ? $("#productCCFee").val(cc_charge) : $("#productCCFee").val("");
                setTimeout(function () {
                    $("#productInstrumentNumber").focus();
                }, 100); // 100ms delay

            } else {
                $("#productCCFee").val("");
                $(".credit-card-fee-item").addClass('d-none');
            }

            if(mode == 'Mixed'){
                $("#PayingNow").val("0.00");
                $("#PayingNow").prop('disabled','disabled');
                $(".mixed-payment").removeClass('d-none');
               
                setTimeout(function () {
                    $("#payingCash").focus();
                }, 100); // 100ms delay
               
            }

        } else {
            $(".credit-card-item").addClass('d-none');
            $(".instrument-number-item").addClass('d-none');     
            $("#productCCFee").val("");

            if(mode == "Voucher"){        
                
                $(".gift-voucher-item").removeClass('d-none');
                setTimeout(function () {
                    $("#productGiftVoucher").focus();
                }, 100); // 100ms delay
            } else {
                
                $(".gift-voucher-item").addClass('d-none');
                setTimeout(function () {
                    $("#PayingNow").focus();
                }, 100); // 100ms delay
            }
        }

        $("#selectedPaymentMode").html(mode);

        recalculate_totals();
    }

    function removeService(){
            Swal.fire({
                text: "Please Select The Visit on The Scheduler or Appointment Listing To Edit / Add / Remove Services.",
                icon: "info",
                buttonsStyling: true,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
    }

    function verifyVoucher(){
        if($("#productGiftVoucher").val() == ""){
             Swal.fire({
                text: "Enter a Valid Voucher Number to verify and apply.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            });
        }

        var voucherno = 'C'+$('#productGiftVoucher').val();

            $.ajax({
                type: 'GET',
                url: '{{ route("validate_voucher") }}',
                data: {
                    voucher_no: voucherno
                },
                success: function(response) {
                    var data = response.data;
                    //console.log(data);

                    if(null != data){
                        var html = '<table class="table">';
                            html += '<thead>';
                                html += '<tr><th colspan="3">Customer Details</th></tr>';
                            html += '</thead>';
                            html += '<tbody>';
                                html += '<tr><td>Customer Name</td><td>'+data.customer_name+'</td></tr>';
                                html += '<tr><td>Customer Email</td><td>'+data.customer_email+'</td></tr>';
                                html += '<tr><td>Customer Phone</td><td>'+data.customer_cell+'</td></tr>';
                            html += '</tbody>'; 
                            html += '<thead>';
                                html += '<tr><th colspan="3">Voucher Details</th></tr>';
                            html += '</thead>';
                            html += '<tbody>';
                                html += '<tr><td>Type</td><td>'+data.type.toUpperCase()+'</td></tr>';
                                html += '<tr><td>Generated on</td><td>'+data.voucher_date+'</td></tr>';
                                html += '<tr><td>Expires on</td><td>'+data.valid_until+'</td></tr>';
                                html += '<tr><td>Voucher #</td><td>'+data.voucher_number+'</td></tr>';
                                html += '<tr><td>Worth Services</td><td>'+data.voucher_value+'</td></tr>';
                                if(data.type === 'amount'){
                                    html += '<tr><td>Total Amount {{ config("constants.CURRENCY") }}.</td><td>'+data.amount+'</td></tr>';
                                    html += '<tr><td>Remaining Amount {{ config("constants.CURRENCY") }}.</td><td>'+data.remaining_amount+'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-size: 11px;">(This amount will be used in the invoice)</span></td></tr>';
                                }
                                if(data.type === 'service'){
                                    html += '<tr><td>Services: </td><td class="voucher-services" data-id-voucher-services="'+data.service_ids+'">'+data.service_names.replace(/\|/g, '<div class="voucher-service-item" style="border-bottom: 1px solid #eee;"></div>')+'</td></tr>';
                                }

                                html += '<tr><td></td><td></td></tr>';
                            html += '</tbody>';
                        html += '</table>';
                        let url = baseURL + '/gift_voucher_print/' + data.id_order_vouchers;
                        html += '<a href="' + url +'" target="_blank" class="btn btn-secondary btn-sm gap-1 me-1">Print Preview</a>';
                        // if($("#customerID").val() == data.id_customers){
                            html += '<button onclick="applyVoucher(\''+data.type+'\')" class="btn btn-primary btn-sm">Apply</button>';                        
                        // }

                        if (parseFloat(data.remaining_amount) <= 0) {
                            Swal.fire({
                                text: "The voucher number " + voucherno + " has already been fully used and cannot be used again.",
                                icon: "error",
                                buttonsStyling: false,
                                confirmButtonText: "Ok",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            });
                            return false;
                        }


                        $('#voucher-details').html(html);
                        $("#idOrderVoucher").val(data.id_order_vouchers);
                        $("#voucherRemainingServices").val(data.remaining_service_ids);
                        $("#voucherRemainingAmount").val(data.remaining_amount);
                        //$('#voucherHtml').fadeIn();

                        $("#PayingNow").prop("disabled", true);
                        $("#productGiftVoucher").prop("disabled", true); 

                        var myModal = new bootstrap.Modal(document.getElementById('voucherHtml'));
                        myModal.show();


                    } else{
                         Swal.fire({
                            text: "The provided voucher number " +voucherno+" was not found or has EXPIRED.",
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });
                       
                    }
                }
            });
    }

    function applyVoucher(voucher_type){

        $(".giftvoucher").removeClass('d-none');

        if(voucher_type=='amount'){
            var remaining = parseInt($('#voucherRemainingAmount').val());
            var grandtotal = parseInt($('#productTotalPayable').val());
            if (remaining >= grandtotal) {
                $('#payingVoucher').val(grandtotal);
                $('#voucherRemainingAmount').val(parseInt(remaining) - parseInt(grandtotal));
            }
            if (remaining < grandtotal) {
                $('#payingVoucher').val(remaining);
                $('#voucherRemainingAmount').val('0');
            }
            recalculate_totals();

           
            


        }else if(voucher_type=='service'){
            var sids = [];
            var rs = $(".voucher-services").attr('data-id-voucher-services');

            
            var remainingServiceIds =rs.split('|');

            $('.service').each(function () {
                sids.push($(this).attr("data-id-service"));
            });

            var diff_ids = arrayDifference(remainingServiceIds, sids);
            var remainingservices = "";

            $.each(diff_ids, function (index, value) {
                remainingservices += value + "|";
            });

            remainingservices = remainingservices.slice(0, -1);

            //console.log(remainingservices);

            $('#voucherRemainingServices').val(remainingservices);

            var remaining = parseInt($('#voucherRemainingAmount').val());
            var grandtotal = parseInt($('#productTotalPayable').val());

            if (remaining >= grandtotal) {
                $('#payingVoucher').val(grandtotal);
                $('#voucherRemainingAmount').val(parseInt(remaining) - parseInt(grandtotal));
                 $(".mixed-payment").addClass('d-none');
            }
            if (remaining < grandtotal) {
                $('#payingVoucher').val(remaining);
                $('#voucherRemainingAmount').val('0');
                $(".mixed-payment").removeClass('d-none');
            }

            
             recalculate_totals();
            //set default focus
            setTimeout(function () {
                $("#payingCash").focus();
            }, 100); // 100ms delay
            
        }

         //Hide Voucher Modal
        const modalEl = document.getElementById('voucherHtml');
        const myModal = bootstrap.Modal.getInstance(modalEl);
        myModal.hide();
    }

    function arrayDifference(array1, array2) {
        var difference = [];
        for (var i = 0; i < array1.length; i++) {
            if ($.inArray(array1[i], array2) == -1) {
                difference.push(array1[i]);
            }
        }
        return difference;
    }

    function redeem_loyalty(){
        console.log('redeem loyalty');

        let loyalty_points = parseFloat($("#loyalty_points").html());
        let loyalty_Rate = parseFloat($("#loyalty_points").attr('data-loyalty-rate'));
        if(loyalty_points > 0 && loyalty_Rate > 0){

            let use_points = 0;

            Swal.fire({
                    input: "number",
                    inputLabel: "Total Available Point "+loyalty_points,
                    inputPlaceholder: "Enter Points You Want To Utilize Now . . .",
                    inputAttributes: {
                        "aria-label": "Use Loyalty Points"
                    },
                    showCancelButton: true,
                    icon: "question",
                    customClass: {
                        confirmButton: 'btn btn-primary me-2',
                        cancelButton: 'btn btn-secondary'
                    },
                    buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
                }).then((result) => {
                    if (result.value) {
                        if(result.value >= 0){
                            use_points = result.value;
                        }

                        
                        use_points = use_points * loyalty_Rate;
                        
                        var total_payable = $("#productTotalPayable").val();

                        

                        if(total_payable >= use_points){
                            //Nothing
                            $("#payingLoyalty").val(use_points);
                            $("#payingLoyalty").prop("disabled", true);
                        
                            $(".loyalty").removeClass("d-none");
                            $("#InvoiceNote").val($("#InvoiceNote").val() + ' | ' + use_points + ' Loyalty Points used for Payment!');
                        } else {
                            use_points = 0;
                        }
                            
                        
                        
                        recalculate_totals();

                    }
                
                });

            
        } else {
            $("#payingLoyalty").val("");
            $("#payingLoyalty").prop("disabled", false);
            $(".loyalty").addClass("d-none");
        }
        recalculate_totals();
    }

    function use_retained(){

        console.log('redeem loyalty');

        let retained_amount = parseFloat($("#retained_amount").html());
        
         Swal.fire({
                    input: "number",
                    inputLabel: "Total Available Amount "+retained_amount,
                    inputPlaceholder: "Enter Amount You Want To Utilize Now . . .",
                    inputAttributes: {
                        "aria-label": "Use Retained Amount"
                    },
                    showCancelButton: true,
                    icon: "question",
                    customClass: {
                        confirmButton: 'btn btn-primary me-2',
                        cancelButton: 'btn btn-secondary'
                    },
                    buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
                }).then((result) => {

                    if(result.value){
                        if(result.value <= retained_amount){
                            $(".retainedamount").removeClass('d-none');
                            $("#payingRetained").val(result.value);
                        }
                        recalculate_totals();
                    }
                }
            );

    }

     function applycoupondiscount(){
        console.log('start');
        var couponnumber = $("#CouponNumber").val();
        
         $.ajax({
            type: 'GET',
            url: '{{ route("validate_coupon") }}',
            data: {
                coupon: couponnumber
            },
           success: function(data) {
                //console.log(data);
                var coupon = data.coupon;
                var services = data.services;
                //console.log(coupon);
                if(coupon!==null){
                    
                    console.log(coupon.coupon_type);
                    if(coupon.coupon_type =='service'){
                        $("#productDiscount").val(0);
                        $("#productDiscount").prop("readonly", true);
                        $("#productDiscountType").prop("disabled", true);
                        
                        for(a=0; a<services.length; a++){
                            
                            $('#services_table .service').each(function(y) {
                                // console.log($(this).data('id-service'));
                                // console.log(services[a].service_id);
                                if ($(this).data('id-service') == services[a].service_id) {
                                    //console.log('found');
                                    servicefound = true;

                                    let service_price = 0;
                                    let discount_amount = coupon.fixed_amount;
                                    let discount_type="Amount";

                                    service_price = parseFloat($(this).data('service-price')) || 0;

                                    if (coupon.discount_perc > 0) {                                        
                                        discount_amount = service_price * parseFloat(coupon.discount_perc) / 100;
                                        discount_type="Percentage";
                                    }
                                    console.log('discount amount from fixed amount: ' + discount_amount);
                                    // scope only to this row
                                    $(this).closest('tr').find('input[name=input-discount]')
                                        .val(discount_amount)
                                        .prop('readonly', true);

                                    var o = "<option data-service-price='" + service_price + "' data-discount-percentage= '"+ parseFloat(coupon.discount_perc) +"' data-discount-amount='"+ discount_amount +"' data-discount-type='" + discount_type + "' value='" + coupon.coupon_number + "'>" +coupon.coupon_number + "<option>";
                                    //find the discount type select
                                    console.log($(this).closest('tr').find('select[name=select-discount-type]').attr('id'));
                                    $(this).closest('tr').find('select[name=select-discount-type]')    
                                        .append(o)
                                        .prop('disabled', true);
                                    
                                    $("option:contains("+ coupon.coupon_number +")", $(this).closest('tr').find('select[name=select-discount-type]')).prop('selected', 'selected');    
                                    $(this).closest('tr').find('select[name=select-discount-type]').trigger('change');

                                    $('#CouponNumber').prop('readonly', true);

                                    let row = y + 1; // if you actually need this index
                                }
                            });
                        }
                       
                    } else {
                        
                        console.log(coupon['fixed_amount']);
                        discount_amount = coupon.fixed_amount;
                        let discount_type="Amount";

                        if (coupon.discount_perc > 0) {                                        
                            discount_amount = service_price * parseFloat(coupon.discount_perc) / 100;
                            let discount_type="Percentage";
                        }

                        $("#productDiscount").val(discount_amount);
                                                
                        recalculate_totals();
                        
                        var o = "<option data-price='" + $("#productSubtotal").val() + "' data-discount-percentage= '"+ parseFloat(coupon.discount_perc) +"' data-discount-amount='"+ discount_amount +"' data-discount-type='" + discount_type + "' value='" + coupon.coupon_number + "'>" +coupon.coupon_number + "<option>";
                        $("#productDiscountType").append(o);
                        $("option:contains("+ coupon['coupon_number'] +")", '#productDiscountType').prop('selected', 'selected');
                        
                       
                        $('#productDiscount').prop('disabled', true);
                        $("#productDiscountType").prop('disabled', true);
                        $('#CouponNumber').prop('readonly', true);
                    }
                    
                } else {
                   
                    Swal.fire({
                        text: "The provided coupon number " +couponnumber+" is INVALID or has EXPIRED.",
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: "btn btn-danger"
                        }
                    });
                }
               
           }
       });
     
    }


    function GenerateInvoice(){
        
        //Disable Save Button
        $("#saveInvoiceButton").prop("disabled", true);
        $("#generateInvoiceSpinner").removeClass("d-none");

        //check if balance invoice is allowed in business settings
        var allow_balance_invoice = "{{ $business->allow_balance }}";

        if(allow_balance_invoice == 'No'){
            if($("#BalanceAmount").val() != "" && parseFloat($("#BalanceAmount").val()) > 0 && $("#selectedPaymentMode").html().trim() != "Voucher" && parseFloat($("#payingRetained").val()) != 0){
                 Swal.fire({
                    text: "Balance Invoices are not allowed. Please receive the full amount to generate the invoice.",
                    icon: "error",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-danger"
                    }
                });
                $("#saveInvoiceButton").prop("disabled", false);
                $("#generateInvoiceSpinner").addClass("d-none");
                return false;
            }
        }

        //Get all payment values
        payingNow = $("#PayingNow").val() != "" ? parseFloat($("#PayingNow").val()) : 0;
        payingCash = $("#payingCash").val() != "" ? parseFloat($("#payingCash").val()) : 0;
        payingCard = $("#payingCard").val() != "" ? parseFloat($("#payingCard").val()) : 0;
        
       
        
        payingLoyalty = $("#payingLoyalty").val() != "" ? parseFloat($("#payingLoyalty").val()) : 0;
        payingVoucher = $("#payingVoucher").val() != "" ? parseFloat($("#payingVoucher").val()) : 0;
        payingRetained = $("#payingRetained").val() != "" ? parseFloat($("#payingRetained").val()) : 0;

        paymentMode = $("#selectedPaymentMode").html() != "" ? $("#selectedPaymentMode").html().trim() : null;

        //Get Balance / Return / Retain Values
        subTotal = $("#productSubtotal").val();
        balance = $("#BalanceAmount").val() != "" ? parseFloat($("#BalanceAmount").val()) : 0; 
        return_cash = $("#ReturnAmount").val() != "" ? parseFloat($("#ReturnAmount").val()) : 0;        
        retain = $("#retain").prop("checked") == true ? "Yes" : "No";
        rounding_adjustment = $("#productAdjustment").val() != "" ? parseFloat($("#productAdjustment").val()) : 0;      
        productTotalAmount = $("#productTotalAmount").val() != "" ? parseFloat($("#productTotalAmount").val()) : 0; 
        productTotalPayable =   $("#productTotalPayable").val() != "" ? parseFloat($("#productTotalPayable").val()) : 0; 

        //get Credit Card or Online Transactions Related info
        CCFee = $("#productCCFee").val() != "" ? parseFloat($("#productCCFee").val()) : 0;
        CCTip = $("#productCCTip").val() != "" ? parseFloat($("#productCCTip").val()) : 0;
        instrument_number = $("#productInstrumentNumber").val() != "" ? $("#productInstrumentNumber").val() : null;
        productPOS = $("#productPOSCharges").val() != "" ? parseFloat($("#productPOSCharges").val()) : 0;

        //get Tax, Advance and Discount
        productDiscountType = $("#productDiscountType option:selected").val() != "" ? $("#productDiscountType option:selected").val() : null;
        productDiscount = $("#productDiscount").val() != "" ? parseFloat($("#productDiscount").val()) : 0;
        productOtherCharges = $("#productOtherCharges").val() != "" ? parseFloat($("#productOtherCharges").val()) : 0;
        productTax = 0; 
        
       $(".tax-item:not(.d-none)").each(function () {
            let val = $(this).find("input.tax").val();  // target the input
            productTax += parseFloat(val) || 0;        // add safely, avoid NaN
        });
        productAdvance = $("#productAdvance").val() != "" ? parseFloat($("#productAdvance").val()) : 0;

        //Get Gift Voucher / Coupon / 
        productGiftVoucher = $("#productGiftVoucher").val() != "" ? $("#productGiftVoucher").val() : null;
        CouponNumber = $("#CouponNumber").val() != "" ? $("#CouponNumber").val() : null;

        
        //Get Visit ID / Services / Customer ID
        visitID =$("#visitID").val();
        customerID = $("#customerID").val();
        visitDate = $("#visitDate").val();
        invoiceNote = $("#InvoiceNote").val();

         var servicesData = [];
        $("#services_table tr").each(function(row, tr){
           //console.log(tr);
            
                let data = {
                    visit_service_id : $(this).find('td:eq(3)').attr('data-id-visit-services'),
                    service_id : $(this).find('td:eq(3)').attr('data-id-service'),
                    service_name : $(this).find('td:eq(3)').html() != null ? $(this).find('td:eq(3)').html().trim() : null,
                    visit_service_price : $(this).find('td:eq(3)').attr('data-service-price') != null ? $(this).find('td:eq(3)').attr('data-service-price') : 0,
                    service_flag : $(this).find('td:eq(3)').attr('data-service-flag') != "" ? $(this).find('td:eq(3)').attr('data-service-flag') : null,
                    service_type : $(this).find('td:eq(3)').attr('data-service-type') != null ? $(this).find('td:eq(3)').attr('data-service-type').trim() : null,
                    service_category : $(this).find('td:eq(3)').attr('data-service-category') != null ?  $(this).find('td:eq(3)').attr('data-service-category').trim() : null,
                    id_service_category : $(this).find('td:eq(3)').attr('data-id-service-category') != "" ? $(this).find('td:eq(3)').attr('data-id-service-category') : null,
                    id_service_type : $(this).find('td:eq(3)').attr('data-id-service-type') != "" ? $(this).find('td:eq(3)').attr('data-id-service-type') : null,
                    staff : $(this).find('td:eq(4)').html() != null ? $(this).find('td:eq(4)').html().trim() : null,
                    requested : $(this).find('td:eq(5)').find('input[name=requested]').prop("checked") == true ? "Yes" : "No",
                    membership: null, //membership not applicable for services
                    service_discount_type : $(this).find('td:eq(6)').find('select[name=select-discount-type] option:selected').text() != null ? $(this).find('td:eq(6)').find('select[name=select-discount-type] option:selected').text().trim() : null,

                    service_discount : $(this).find('td:eq(7)').find('input[name=input-discount]').val() != "" ? $(this).find('td:eq(7)').find('input[name=input-discount]').val() : 0,

                    service_addition : $(this).find('td:eq(8)').find('input[name=input-addition]').val() != "" ? $(this).find('td:eq(8)').find('input[name=input-addition]').val() : 0,

                    final_service_price : $(this).find('td:eq(9)').html() != null ? $(this).find('td:eq(9)').html().trim() : 0, //final Service Price
                }
                //console.log(data);
                servicesData.push(data);
                

        });
        servicesData.shift();  // first row will be empty - so remove
        //servicesData.pop();  // last row will be empty - so remove

        if(servicesData.length < 1){
            //Enable Save Button
            $("#saveInvoiceButton").prop("disabled", false);
            $("#generateInvoiceSpinner").addClass("d-none");

            Swal.fire({
                text: "There are no services in this invoice.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            $("#saveInvoiceButton").prop("disabled", false);
            $("#generateInvoiceSpinner").addClass("d-none");
            return false;
        }

        if(visitID=="" || customerID==""){
            //Enable Save Button
            $("#saveInvoiceButton").prop("disabled", false);
            $("#generateInvoiceSpinner").addClass("d-none");
            Swal.fire({
                text: "Customer Not Mentioned or No Visit Selected.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            $("#saveInvoiceButton").prop("disabled", false);
            $("#generateInvoiceSpinner").addClass("d-none");
            return false;
        }

        if((paymentMode =='Card' || paymentMode =='Mixed' || paymentMode =='D-Card' || paymentMode =='Online' || paymentMode =='Mixed' || paymentMode =='Check') && (instrument_number == '' || instrument_number === null)){
           Swal.fire({
                text: "Instrument number is required for the selected payment mode.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            $("#saveInvoiceButton").prop("disabled", false);
            $("#generateInvoiceSpinner").addClass("d-none");
            return false;
        }

        var giftVoucherRemainingAmount = $("#voucherRemainingAmount").val() || 0;
        var giftVoucherRemainingServices = $("#voucherRemainingServices").val() || '';

        try {
            $.ajax({
                url : "{{ route('create_service_invoice') }}",
                data: { 
                    "id_customer_visits" : visitID,  
                    "visit_date" : visitDate,  
                    "id_customers" : customerID, 
                    "invoice_type" : 'service',
                    "sub_total" : subTotal,
                    "invoice_discount_type" : productDiscountType,
                    "invoice_discount" : productDiscount,
                    "taxes" : productTax, 
                    "invoice_other_charges" : productOtherCharges,
                    "advance" : productAdvance,
                    "total_payable" : productTotalPayable,
                    "total_amount" : productTotalAmount,
                    "paid_amount" : payingNow,
                    "paid_cash" : payingCash,
                    "paid_card" : payingCard,   
                    
                    "paid_voucher" : payingVoucher,
                    "paid_loyalty" : payingLoyalty,
                    "paid_ratained" : payingRetained, 
                    "return_cash" : return_cash,
                    "retain" : retain, 
                    "balance" : balance,
                    "rounded_adjustment" : rounding_adjustment,
                    "payment_mode" : paymentMode,
                    "voucher_number" : productGiftVoucher,
                    "gift_vouche_remaining_amount" : giftVoucherRemainingAmount,
                    "gift_voucher_remaining_services" : giftVoucherRemainingServices,
                    "coupon_number" : CouponNumber,
                    "instrument_number" : instrument_number,
                    "invoice_remarks" : invoiceNote,
                    "cc_fee": CCFee,
                    "cc_tip" : CCTip,
                    "pos_fee" : productPOS,
                    "services" : servicesData

                },
                type: "POST", // The POST method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {
                    console.log(data);
                    var btn = "btn btn-" +data.message_btn;
                    Swal.fire({
                        text: data.message,
                        icon: data.message_type,
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: btn
                        }
                    });

                    if(data.message_type == "success"){
                        //load the invoice page
                        url = "{{ route('existing_invoice', ['invoice_id' => ':id']) }}";
                        url = url.replace(':id', data.new_id_invoice);
                        //window.open(url, '_blank');
                        location.href = url;
                    }
                },
                error: function(xhr, status, error) {
                    //Enable Save Button
                    $("#saveInvoiceButton").prop("disabled", false);
                    $("#generateInvoiceSpinner").addClass("d-none");
                    // Handle errors
                    console.error("AJAX Error:", status, error);
                }  
            });
        } catch (e) {
            //Enable Save Button
            $("#saveInvoiceButton").prop("disabled", false);
            $("#generateInvoiceSpinner").addClass("d-none");
            console.error("JS error before AJAX:", e);
        }
    }


</script>
@endsection