@extends('layouts.horizontal', ['title' => 'Recovery Invoices', 'topbarTitle' => 'Recovery Invoices'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
     /* Make the DataTables scroll container behave */
        div.dataTables_wrapper div.dataTables_scrollHead {
            overflow: visible !important;
        }

        /* Keep the fixed header aligned with the table */
        table.dataTable.fixedHeader-floating {
            margin-top: 0 !important;
            margin-left: 0 !important;
        }

        /* Prevent weird shifts when horizontal scrolling */
        .dataTables_scrollBody {
            overflow-x: auto !important;
        }

</style>


<div class="Tinvoices ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Recovery Invoices</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <table style="font-size: .753rem !important;" id="recovery-invoices-table"  class="table table-striped dt-responsive nowrap w-100">
                                <thead>
                                    <tr>
                                        <th>ID Invoice</th>
                                        <th>Invoice #</th>
                                        <th>Invoice Date</th>
                                        <th>visit Date</th>
                                        <th>Customer</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th>Recovery</th>
                                        <th>Balance</th>
                                        <th>Paid Amount</th>
                                        <th>Advance Used</th>
                                        <th>Sub Total</th>
                                        <th>Other Charges</th>
                                        <th>Discount</th>
                                        <th>Gross Amount</th>
                                        <th>Taxes</th>
                                        <th>Net Amount</th>
                                        <th>Payment Mode</th>
                                        <th>Instrument</th>
                                        <th>Remarks</th>
                                        <th>Discount Remarks</th>
                                        <th>IMS</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                   

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="8" style="text-align:right">Totals:</th>
                                        <th></th> <!-- balance total -->
                                        <th></th> <!-- paid_amount total -->
                                        <th colspan="13"></th>
                                    </tr>
                            </table>
                        </div>
                    </div>
                    

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div> <!-- end row-->
</div> <!-- end Tinvoices-->


@endsection

@section('scripts')
@vite(['resources/js/components/table-datatable.js'])

<script>
    $(document).ready(function() {
        //Today Invoices Datatable
        var table = $('#recovery-invoices-table').DataTable({
            scrollX:true,
            scrollY: 350,
            scrollCollapse: true,
            lengthChange: true,
            stateSave: true,
            ajax: {
                url: "{{ route('recovery_invoices.recoveryinvoicesdata') }}"
            },       
            fixedHeader: {header:true, footer:true},
            processing: true,
            serverSide: true,
            buttons: ['copy', 'print'],
            responsive: false,
            
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'>",
                    "next": "<i class='ti ti-chevron-right'>"
                }
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            lengthChange: true,   // show page length dropdown
            pageLength: 10,       // default rows per page
            searching: true,      // show search box
            info: true,           // show "Showing 1 to 10 of N entries"
            paging: true,         // show pagination
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            columns: [
                { data: 'id_invoice', 
                    orderable: true, 
                    searchable: true,
                    name: 'id_invoice' },
                { data: null, 
                    name: 'invoice_number',
                    orderable: true, 
                    searchable: true,
                    render: function (data, type, row) {
                        return `<a target="_blank" href="existing_service_invoice/${data.id_invoice}" class="link invoice-link" data-id="${row.id_invoice}">${data.invoice_number}</a>`;
                    }

                },
                { data: 'invoice_date_formatted', name: 'invoice_date_formatted' },
                { data: 'visit_time', name: 'visit_time' },
                { data: 'customer_name', name: 'customer_name' },
                { data: 'invoice_status', name: 'invoice_status' },
                { data: 'invoice_type', name: 'invoice_type' },
                { data: 'reference_invoice_number', name: 'reference_invoice_number' },
                { data: 'balance', name: 'balance' },
                { data: 'paid_amount', name: 'paid_amount' },
                { data: 'advance_amount', name: 'advance_amount' },
                { data: 'sub_total', name: 'sub_total' },
                { data: 'other_charges', name: 'other_charges' },
                { data: 'discount', name: 'discount' },
                { data: 'gross_amount', name: 'gross_amount' },
                { data: 'tax_total', name: 'tax_total' },  
                { data: 'net_amount', name: 'net_amount' },  
                { data: 'payment_mode', name: 'payment_mode' },  
                { data: 'instrument_number', name: 'instrument_number' },  
                { data: 'remarks', name: 'remarks' },  
                { data: 'discount_reason', name: 'discount_reason' },  
                { data: 'imsfiscal_invoice_number', name: 'imsfiscal_invoice_number' },
                // Actions column with button
                { 
                    data: null, 
                    name: 'actions', 
                    orderable: false, 
                    searchable: false,
                    render: function (data, type, row) {
                        let flag = row.invoice_type.toLowerCase();
                        var mRoute = "";
                        if(flag == 'service'){
                            mRoute = 'existing_service_invoice/';
                        } else {
                            mRoute = 'existing_retail_invoice/';
                        }
                        return `<a target="_blank" href="`+ mRoute +`${data.id_invoice}" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info" data-id="${row.id}">
                                    <iconify-icon icon="line-md:watch-loop"class="fs-20"></iconify-icon>
                                </a>
                                <button onclick="bad_invoice(${data.id_invoice});" class="btn btn-sm btn-danger baddebt-btn" data-id="${row.id}">
                                    <iconify-icon icon="line-md:trash"class="fs-20"></iconify-icon> Bad Dept
                                </button>
                                <a href="new_recovery_invoice/${data.id_invoice}" target="invoice" class="btn btn-sm btn-primary recovery-btn " data-id="${row.id}">
                                    <iconify-icon icon="solar:hand-money-outline"class="fs-20"></iconify-icon> Recover
                                </a>
                                `;


                    }
                }
                

            ],
            "drawCallback": function () {
                $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
                $('.dataTables_paginate > .pagination').addClass('btn-dark');
            },
            "rowCallback": function(row, data, displayNum, displayIndex, dataIndex) {
                // 'row' is the TR element for the current row
                // 'data' is the data array/object for the current row
                // 'displayNum' is the row number in the current page of displayed rows
                // 'displayIndex' is the row index in the current page of displayed rows
                // 'dataIndex' is DataTables' internal index for the row (useful for accessing data via API)

                // Strike Through rows where a specific data field meets a condition
                if (data.invoice_status != 'valid') {
                    $(row).addClass('strike-through'); // Add a class to the row
                }

                if(data.reference_invoice_number != '') {
                    //$('td:eq(7)', row).addClass('badge bg-primary  mt-2'); // Change text color of the 8th column (index 7)
                    //$('td:eq(7)', row).css('color', 'white'); // Change text color of the 8th column (index 7)
                    $('td:eq(7)', row).html('<span class="badge bg-primary ">Recovery</span>'); // Change text color of the 8th column (index 7)
                    
                }

                // Example: Add an icon to the first column
                //$('td:eq(0)', row).prepend('<span class="info-icon"></span>');
            },
            "footerCallback": function (row, data, start, end, display) {
                var api = this.api();

                // grab server totals
                var totals = api.ajax.json().totals;

                // balance is column index 8
                $(api.column(8).footer()).html(
                    totals ? totals.balance : 0
                );

                // paid_amount is column index 9
                $(api.column(9).footer()).html(
                    totals ? totals.paid_amount : 0
                );
            }

        });

        // Sometimes a redraw is needed to sync the cloned header after init
        table.on('draw', function () {
            table.fixedHeader.adjust();
        });

        $('#btn_refresh_table').click(function() {
           // table.draw();
            table.ajax.reload(); 
        });

    });

   
    //////////////////////Open Invoice and Cancel Invoice Functions//////////////////////        
    function cancelinvoice(invoiceid, visit_order_id, flag){
        //Warning Message

        swal({
            title: "Are you sure?",
            text: "Give Reason For Cancelling This Invoice:",
            type: "input",
            showCancelButton: true,
            closeOnConfirm: false,
            inputPlaceholder: "reason for cancelling"
            }, function (inputValue) {
            if (inputValue === false) return false;
            if (inputValue === "") {
                swal.showInputError("You need to write something!");
                return false
            }
            
            if(flag=='service'){
                var check = "";
                check = '<?php if(isset($business[0]['srb_fiscal_service'])){ if($business[0]['srb_fiscal_service']=='Yes'){ echo "true";} else { echo "false";}}?>';
                
                if(check=="false"){

                    check = '<?php if(isset($business[0]['imsfiscal'])){ if($business[0]['imsfiscal']=='Yes'){ echo "true";} else { echo "false";}}?>';

                }

                console.log('srb' + check);
                if(check==="true"){
                    swal.showInputError("Connected with Taxation systems. You Cannot Cancel Invoices!");
                    return false
                }else {
                    updateimsfiscal(invoiceid, visit_order_id, 3, flag, inputValue);
                }
            } else {
                var check = "";
                check = '<?php if(isset($business[0]['srb_fiscal_sale'])){ if($business[0]['srb_fiscal_sale']=='Yes'){ echo "true";} else { echo "false";}}?>';
                
                if(check=="false"){

                    check = '<?php if(isset($business[0]['imsfiscal_r'])){ if($business[0]['imsfiscal_r']=='Yes'){ echo "true";} else { echo "false";}}?>';

                }

                console.log('pra ' + check);
                if(check==="true"){
                    swal.showInputError("Connected with Taxation systems. You Cannot Cancel Invoices!");
                    return false
                }else {
                    updateimsfiscal(invoiceid, visit_order_id, 3, flag, inputValue);
                }
            }
        });
        
    }



</script>

@endsection

