<!DOCTYPE html>
<html lang="en" data-layout="topnav" data-bs-theme="light" data-menu-color="dark" data-topbar-color="dark">


<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @include('layouts.partials/title-meta', ['title' => $title])
    @include('layouts.partials/head-css')
    
    <script src="{{ asset('vendor/jquery/jquery-3.7.1.min.js') }}"></script>

    @section('css')
    @vite(['node_modules/sweetalert2/dist/sweetalert2.css'])
    @endsection
    
</head>

<body @yield('body_attribute')>
  

    <div class="wrapper">
        @include('layouts.partials/topbar', ['topbarTitle' => 'Horizontal'])
        @if (isset($nonav) && $nonav==true)
            <!-- No Navigation -->
        @else
            @include('layouts.partials/horizontal-nav')
        @endif
        <div class="page-content">
            <div class="page-container">
            @yield('content')        
            </div>
        </div>        
        
        @include('layouts.partials/footer')
        
    </div>
    
    @include('layouts.partials/customizer')
    @include('layouts.partials/footer-scripts')
</body>

</html>