<!-- App js -->
@vite(['resources/js/app.js'])

@yield('scripts')

<script>

    $(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        });
    });

    const tabId = Math.random().toString(36).slice(2);
    const channel = new BroadcastChannel('sked-tabs');
    let anotherTabExists = false;

    // Listen for pings and reply back
    channel.onmessage = (e) => {
        if (e.data.type === 'hello' && e.data.key === 'sked' && e.data.id !== tabId) {
            // Someone else is asking "anybody there?"
            channel.postMessage({ type: 'reply', key: 'sked', id: tabId });
            anotherTabExists = true;
        } else if (e.data.type === 'reply' && e.data.key === 'sked' && e.data.id !== tabId) {
            // We got a reply → another tab is alive
            anotherTabExists = true;
        }
    };


    $(function() {

        <?php if(null != session('user_id')) { ?>
        // Set the Global reset counter variable
        var resetCounter = 0;

        // Set the interval for the reset function
        setInterval(function() {
            resetCounter++;
            if (resetCounter >= 60) { // Reset every 60 seconds
                console.log('Resetting global state after 3 minutes and logging out');                
               // Logout of the current session
               resetCounter = 0; // Reset the counter
                window.location.href = "{{ route('logout') }}";
                
            }
        }, 600000); // Check every three minutes

        $('html').on("click" , function(event){
            resetGlobal();
        });
        
        $('html').on("keyup", function(event){
            resetGlobal();                    
        });

        $('html').on("keydown", function(event){
            resetGlobal();
        });

        $('html').on("mousemove", function(event){
            resetGlobal();
        });
        <?php } ?>
        // Uncomment the following lines if you want to use these functions
        //getCustomerBirthdays();        
        //checkpayment();
        
        $(".alpha").on("keypress", function(e) {
            // console.log(e.which);
            //stop character if not a letter or control key
            if (e.which != 13 && e.which != 8 && e.which != 0 && e.which != 32 && (e.which < 65 || e.which > 90) && (e.which < 97 || e.which > 122)) {
                return false;
            }
        });

        $(".numeric").on("keypress", function (e) {
            //stop character if not a digit or control key
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && (e.which < 48 || e.which > 57)) {
               return false;
           }
        });
        
        $(".multinumeric").on("keypress", function (e) {
            //stop character if not a digit, comma, period or control key
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && e.which != 44 && (e.which < 48 || e.which > 57)) {
               return false;
           }
        });

        $(".decimal").on("keypress", function(e) {
            //stop character if not a digit, period or control key
            if (e.which != 13 && e.which != 8 && e.which != 0  && e.which != 46 && (e.which < 48 || e.which > 57) ) {

                return false;
            }
        });
        
    });

    function b_switch() {
        anotherTabExists = false; // reset before each check

        // Ask if any other tabs are open
        channel.postMessage({ type: 'hello', key: 'sked', id: tabId });

        setTimeout(() => {
            if (!anotherTabExists) {
                console.log("This is the only 'sked' tab open.");

                var businessId = $('#business-meta').data('business-id');
                var token = $('#business-meta').data('token');
                var ajaxUrl = $('#ajax-business-url').data('url');

                $.ajax({
                    type: 'POST',
                    url: ajaxUrl,
                    data: {
                        business_id: businessId,
                        _token: token,
                        openagain: 1
                    },
                    dataType: "json",
                    cache: false,
                    async: true,
                    success: function (data) {
                        $("#modalbusinesslist").html('');
                        if (data.length > 0) {
                            var chtml = '';
                            for (let x = 0; x < data.length; x++) {
                                chtml += '<li onclick="submit_business('
                                    + data[x]['id_business'] + ',\''
                                    + data[x]['business_name'] + '\',\''
                                    + data[x]['ho'] + '\',\''
                                    + data[x]['common_products'] + '\',\''
                                    + data[x]['common_services'] + '\',\''
                                    + data[x]['business_type_id'] + '\',\''
                                    + data[x]['ho_accounts'] + '\');">'
                                    + '<img src="{{ asset("images/business/")}}/' + data[x]['business_logo'] + '" alt=""> - '
                                    + '<span class="business_name">' + data[x]['business_name'].trim() + '</span></li>';
                            }
                            $("#modalbusinesslist").html(chtml);

                            var myModal = new bootstrap.Modal(document.getElementById('businessmodal'));
                            myModal.show();

                            var options = { valueNames: ['business_name'] };
                            var businessList = new List('pick-business-div', options);
                           
                        }


                    }
                });

            } else {
                Swal.fire({
                    title: 'Close All Other Tabs',
                    text: "You cannot switch if more than one tab is open!",
                    icon: "warning",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: { confirmButton: "btn btn-warning" }
                });
                return false;
            }
        }, 500);
    }
    
    function submit_business(id_business, business_name, business_ho, common_products, common_services, business_type, ho_accounts) {
        
        $('#openagain #id_business').val(id_business);
        $('#openagain #business_name').val(business_name);
        $('#openagain #business_ho').val(business_ho);
        $('#openagain #common_products').val(common_products);
        $('#openagain #common_services').val(common_services);
        $('#openagain #business_type').val(business_type);
        $('#openagain #ho_accounts').val(ho_accounts);
        //return true;
        $("#openagain").submit();
    }

    function resetGlobal() {
        // Reset any global variables or states here
        //console.log('Global state reset');

        resetCounter = 0; // Reset the counter

    }
</script>