<!-- Horizontal Menu Start -->
<header class="topnav">
    <nav class="navbar navbar-expand-lg">
        <nav class="page-container">
        <!-- Delete the justify content if you want to go back to the left-aligned menu-->
            <div class="collapse navbar-collapse justify-content-around" id="topnav-menu-content"> 
                <ul class="navbar-nav">
                    @foreach ($menus as $menu)
                        
                        @php
                            $has_child = $menu->childsActive->isNotEmpty();
                            $params = $menu->route_params ? json_decode($menu->route_params, true) : [];
                            $menu_url = !empty($menu->route) ? route($menu->route, $params) : '#';
                            $link_target = !empty($menu->link_target) ? $menu->link_target : '_self';
                            $menu_id = 'topnav-'. str_replace(' ', '_', $menu->name) .'_'.$menu->id;
                        @endphp

                        @can($menu->permission)

                        <li class="nav-item dropdown {{ $has_child ? 'hover-dropdown' : '' }}">

                            <a class="nav-link arrow-none" href="{{$menu_url}}"    @if(!empty($menu_url)) target="{{ $link_target }}" @endif id="{{$menu_id}}" role="button" 
                            @if ($has_child)
                                data-bs-toggle="dropdown"
                            @endif
                            aria-haspopup="true" aria-expanded="false">
                                <span class="menu-icon"><iconify-icon icon="{{ $menu->icon }}" class="fs-20"></iconify-icon></span>
                                <span class="menu-text">{{ $menu->name }}</span>
                                @if ($has_child)
                                    <div class="menu-arrow"></div>
                                @endif
                            </a>

                            @if ($has_child)
                                <div class="dropdown-menu" aria-labelledby="{{$menu_id}}">     
                                    @foreach ($menu->childsActive as $child)
                                        @php
                                            $has_sub_child = $child->childsActive->isNotEmpty();
                                            $params = $child->route_params ? json_decode($child->route_params, true) : [];
                                            $child_menu_url = !empty($child->route) ? route($child->route, $params) : '#';
                                            $child_link_target = !empty($child->link_target) ? $child->link_target : '_self';
                                            $child_menu_id = 'topnav-'. str_replace(' ', '_', $child->name) .'_'.$child->id;
                                        @endphp

                                        @can($child->permission)

                                            @if (!$has_sub_child)

                                                @if ($child->before_separator) <hr> @endif                                
                                                <a href="{{ $child_menu_url }}"  @if (!empty($child_menu_url)) target="{{ $child_link_target }}" @endif class="dropdown-item">{{ $child->name }}</a>
                                                @if ($child->after_separator) <hr> @endif                                

                                            @else
                                                <div  class="dropdown hover-dropdown">
                                                    
                                                    @if ($child->before_separator) <hr> @endif     
                                                    <a class="dropdown-item dropdown-toggle drop-arrow-none" href="{{ $child_menu_url }}" @if (!empty($child_menu_url)) target="{{ $child_link_target }}" @endif id="{{$child_menu_id}}" role="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                        {{ $child->name }} <div class="menu-arrow"></div>
                                                    </a>          

                                                    <div class="dropdown-menu" aria-labelledby="{{$child_menu_id}}">

                                                        @foreach ($child->childsActive as $sub_child)
                                                            @php
                                                                $params = $sub_child->route_params ? json_decode($sub_child->route_params, true) : [];
                                                                $sub_child_menu_url = !empty($sub_child->route) ? route($sub_child->route, $params) : '#';
                                                                $sub_child_link_target = !empty($sub_child->link_target) ? $sub_child->link_target : '_self';
                                                            @endphp

                                                            @can($sub_child->permission)
                                                                @if ($sub_child->before_separator) <hr> @endif                                
                                                                <a href="{{ $sub_child_menu_url }}" @if(!empty($sub_child_menu_url)) target="{{ $sub_child_link_target }}" @endif class="dropdown-item">
                                                                    @if (!empty($sub_child->child_icon) && $sub_child->child_icon_position == 'start')<iconify-icon icon="{{$sub_child->child_icon}}" class="fs-22"></iconify-icon>@endif
                                                                    {{ $sub_child->name }}
                                                                    @if (!empty($sub_child->child_icon) && $sub_child->child_icon_position == 'end') <iconify-icon icon="{{$sub_child->child_icon}}" class="fs-22 ms-2"></iconify-icon> @endif
                                                                </a> 
                                                                @if ($sub_child->after_separator) <hr> @endif                                
                                                            @endcan

                                                        @endforeach

                                                    </div>

                                                    @if ($child->after_separator) <hr> @endif           
                                                </div>
                                            @endif
                                        
                                        @endcan

                                    @endforeach                     
                                </div>
                            @endif
                        </li>

                        @endcan

                    @endforeach
                </ul>
            </div>
        </nav>
    </nav>
</header>
<!-- Horizontal Menu End -->
