<!-- Topbar Start -->
<header class="app-topbar" id="header">
    <div class="page-container topbar-menu">
        <div class="d-flex align-items-center gap-2">

            <!-- Brand Logo -->
            <a href="{{ route('home') }}" class="logo">
                <span class="logo-light">
                    <span class="logo-lg"><img src="{{ asset('images/logo.png') }}" alt="logo"></span>
                    <span class="logo-sm"><img src="{{ asset('images/logo-sm.png') }}" alt="small logo"></span>
                </span>

                <span class="logo-dark">
                    <span class="logo-lg"><img src="{{ asset('images/logo-dark.png') }}" alt="dark logo"></span>
                    <span class="logo-sm"><img src="{{ asset('images/logo-sm.png') }}" alt="small logo"></span>
                </span>
            </a>

            <!-- Sidebar Menu Toggle Button -->
            <button class="sidenav-toggle-button px-2">
                <i class="ri-menu-5-line fs-24"></i>
            </button>

            <!-- Horizontal Menu Toggle Button -->
            <button class="topnav-toggle-button px-2" data-bs-toggle="collapse" data-bs-target="#topnav-menu-content">
                <i class="ri-menu-5-line fs-24"></i>
            </button>

            <!-- Topbar Page Title -->

            <div class="topbar-item d-none d-md-flex px-2">
                @if(isset($topbarTitle))
                <div>
                    <h4 class="page-title fs-20 fw-semibold mb-0">{{ session('business_name') }}</h4>
                </div>
                @else
                <div>
                    <h4 class="page-title fs-20 fw-semibold mb-0">Welcome!</h4>
                </div>
                @endif
            </div>

        </div>

        <div class="d-flex align-items-center gap-2">

            <!-- Search for small devices -->
            <div class="topbar-item d-flex d-xl-none">
                <button class="topbar-link" data-bs-toggle="modal" data-bs-target="#searchModal" type="button">
                    <i class="ri-search-line fs-22"></i>
                </button>
            </div>

            <!-- Button Trigger Search Modal -->
            <div class="topbar-search text-muted d-none d-xl-flex gap-2 me-2 align-items-center" data-bs-toggle="modal"
                data-bs-target="#searchModal" type="button">
                <i class="ri-search-line fs-18"></i>
                <span class="me-2">Search something..</span>
            </div>

            <li class="topbar-item">              
                
                <?php if(session('switch') == 'Yes'){ ?>
                    <button onclick="b_switch();" class="btn btn-default btn-sm waves-effect waves-light text-success  mt-1" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        switch <i class="fe-repeat"></i>
                    </button>   
                <?php } elseif(session('user_role') == 'Super User') { ?>
                    <button onclick="b_switch();" class="btn btn-default btn-sm waves-effect waves-light text-success  mt-1" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        switch <i class="fe-repeat"></i>
                    </button>    
                <?php } ?>
            
            </li>


            <!-- Language Dropdown -->
            <div class="topbar-item d-none d-sm-flex">
                <div class="dropdown">
                    <button class="topbar-link" data-bs-toggle="dropdown" data-bs-offset="0,32" type="button"
                        aria-haspopup="false" aria-expanded="false">
                        <img src="{{ asset('images/flags/pk.svg') }}" alt="user-image" class="w-100 rounded" height="18"
                            id="selected-language-image">
                    </button>

                    <div class="dropdown-menu dropdown-menu-end">
                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item" data-translator-lang="en">
                            <img src="{{ asset('images/flags/us.svg') }}" alt="user-image" class="me-1 rounded" height="18"
                                data-translator-image> <span class="align-middle">United States</span>
                        </a>

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item" data-translator-lang="hi">
                            <img src="{{ asset('images/flags/ua.svg') }}" alt="user-image" class="me-1 rounded" height="18"
                                data-translator-image> <span class="align-middle">UAE</span>
                        </a>

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item">
                            <img src="{{ asset('images/flags/gb.svg') }}" alt="user-image" class="me-1 rounded" height="18">
                            <span class="align-middle">Britain</span>
                        </a>

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item">
                            <img src="{{ asset('images/flags/au.svg') }}" alt="user-image" class="me-1 rounded" height="18">
                            <span class="align-middle">Australia</span>
                        </a>

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item">
                            <img src="{{ asset('images/flags/qa.svg') }}" alt="user-image" class="me-1 rounded" height="18">
                            <span class="align-middle">Qatar</span>
                        </a>

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item">
                            <img src="{{ asset('images/flags/sa.svg') }}" alt="user-image" class="me-1 rounded" height="18">
                            <span class="align-middle">Saudi Arabia</span>
                        </a>

                    </div>
                </div>
            </div>

            <!-- Notification Dropdown -->
            <div class="topbar-item">
                <div class="dropdown">
                    <button class="topbar-link dropdown-toggle drop-arrow-none" data-bs-toggle="dropdown"
                        data-bs-offset="0,25" type="button" data-bs-auto-close="outside" aria-haspopup="false"
                        aria-expanded="false">
                        <i class="ri-notification-snooze-line animate-ring fs-22"></i>
                        <span class="noti-icon-badge"></span>
                    </button>

                    <div class="dropdown-menu p-0 dropdown-menu-end dropdown-menu-lg" style="min-height: 300px;">
                        <div class="p-2 border-bottom position-relative border-dashed">
                            <div class="row align-items-center">
                                <div class="col">
                                    <h6 class="m-0 fs-16 fw-semibold"> Notifications</h6>
                                </div>
                                <div class="col-auto">
                                    <div class="dropdown">
                                        <a href="#" class="dropdown-toggle drop-arrow-none link-dark"
                                            data-bs-toggle="dropdown" data-bs-offset="0,15" aria-expanded="false">
                                            <i class="ri-settings-2-line fs-22 align-middle"></i>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-end">
                                            <!-- item-->
                                            <a href="javascript:void(0);" class="dropdown-item">Mark as Read</a>
                                            <!-- item-->
                                            <a href="javascript:void(0);" class="dropdown-item">Delete All</a>
                                            <!-- item-->
                                            <a href="javascript:void(0);" class="dropdown-item">Do not Disturb</a>
                                            <!-- item-->
                                            <a href="javascript:void(0);" class="dropdown-item">Other Settings</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="position-relative rounded-0" style="max-height: 300px;" data-simplebar>
                            <!-- item-->
                            <div class="dropdown-item notification-item py-2 text-wrap active" id="notification-1">
                                <span class="d-flex align-items-center">
                                    <span class="me-3 position-relative flex-shrink-0">
                                        <img src="{{ asset('images/users/avatar-2.jpg') }}" class="avatar-lg rounded-circle"
                                            alt="" />
                                    </span>
                                    <span class="flex-grow-1 text-muted">
                                        <span class="fw-medium text-body">{{ session('user_name')}}</span> commented on <span
                                            class="fw-medium text-body">SkedWise admin status</span>
                                        <br />
                                        <span class="fs-12">25m ago</span>
                                    </span>
                                    <span class="notification-item-close">
                                        <button type="button"
                                            class="btn btn-ghost-danger rounded-circle btn-sm btn-icon"
                                            data-dismissible="#notification-1">
                                            <i class="ri-close-line fs-16"></i>
                                        </button>
                                    </span>
                                </span>
                            </div>

                            <!-- item-->
                            <div class="dropdown-item notification-item py-2 text-wrap" id="notification-2">
                                <span class="d-flex align-items-center">
                                    <span class="me-3 position-relative flex-shrink-0">
                                        <img src="{{ asset('images/users/avatar-4.jpg')}}" class="avatar-lg rounded-circle"
                                            alt="" />
                                    </span>
                                    <span class="flex-grow-1 text-muted">
                                        <span class="fw-medium text-body">Tommy Berry</span> donated <span
                                            class="text-success">$100.00</span> for <span
                                            class="fw-medium text-body">Carbon removal program</span>
                                        <br />
                                        <span class="fs-12">58m ago</span>
                                    </span>
                                    <span class="notification-item-close">
                                        <button type="button"
                                            class="btn btn-ghost-danger rounded-circle btn-sm btn-icon"
                                            data-dismissible="#notification-2">
                                            <i class="ri-close-line fs-16"></i>
                                        </button>
                                    </span>
                                </span>
                            </div>

                            <!-- item-->
                            <div class="dropdown-item notification-item py-2 text-wrap" id="notification-3">
                                <span class="d-flex align-items-center">
                                    <div class="avatar-lg flex-shrink-0 me-3">
                                        <span class="avatar-title bg-success-subtle text-success rounded-circle fs-22">
                                            <iconify-icon icon="solar:wallet-money-bold-duotone"></iconify-icon>
                                        </span>
                                    </div>
                                    <span class="flex-grow-1 text-muted">
                                        You withdraw a <span class="fw-medium text-body">$500</span> by <span
                                            class="fw-medium text-body">New York ATM</span>
                                        <br />
                                        <span class="fs-12">2h ago</span>
                                    </span>
                                    <span class="notification-item-close">
                                        <button type="button"
                                            class="btn btn-ghost-danger rounded-circle btn-sm btn-icon"
                                            data-dismissible="#notification-3">
                                            <i class="ri-close-line fs-16"></i>
                                        </button>
                                    </span>
                                </span>
                            </div>

                            
                          
                        </div>

                        <!-- All-->
                        <a href="javascript:void(0);"
                            class="dropdown-item notification-item text-center text-reset text-decoration-underline fw-bold notify-item border-top border-light py-2">
                            View All
                        </a>
                    </div>
                </div>
            </div>

            <!-- Apps Dropdown -->
            <div class="topbar-item d-none d-sm-flex">
                <div class="dropdown">
                    <button class="topbar-link dropdown-toggle drop-arrow-none" data-bs-toggle="dropdown"
                        data-bs-offset="0,25" type="button" aria-haspopup="false" aria-expanded="false">
                        <i class="ri-apps-2-add-line fs-22"></i>
                    </button>
                    <div class="dropdown-menu dropdown-menu-end dropdown-menu-lg p-0">
                        <div class="p-2">
                            <div class="row g-0">
                                <div class="col">
                                    <a class="dropdown-icon-item" target="_blank" href="https://receipts.mexyon.com/">
                                        <img style="height:45px !important;" src="{{ asset('images/brands/upload.svg') }}" alt="slack">
                                        <span>OnlineSlip</span>
                                    </a>
                                </div>
                                <div class="col">
                                    <a class="dropdown-icon-item" target="_blank" href="https://feedback.mexyon.com/">
                                        <img style="height:45px !important;"  src="{{ asset('images/brands/good-review.svg') }}" alt="feedmax">
                                        <span>FeedMex</span>
                                    </a>
                                </div>
                                <div class="col">
                                    <a class="dropdown-icon-item" target="_blank" href="https://referral.mexyon.com/">
                                        <img style="height:45px !important;" src="{{ asset('images/brands/user-check-mark.svg') }}" alt="referral">
                                        <span>Referral</span>
                                    </a>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
            </div>

            <!-- Button Trigger Customizer Offcanvas -->
            <div class="topbar-item d-none d-sm-flex">
                <button class="topbar-link" data-bs-toggle="offcanvas" data-bs-target="#theme-settings-offcanvas"
                    type="button">
                    <i class="ri-settings-4-line fs-22"></i>
                </button>
            </div>

            <!-- Light/Dark Mode Button -->
            <div class="topbar-item d-none d-sm-flex">
                <button class="topbar-link" id="light-dark-mode" type="button">
                    <i class="ri-moon-line light-mode-icon fs-22"></i>
                    <i class="ri-sun-line dark-mode-icon fs-22"></i>
                </button>
            </div>

            <!-- User Dropdown -->
            <div class="topbar-item nav-user d-none d-sm-flex">
                <div class="dropdown">
                    <a class="topbar-link dropdown-toggle drop-arrow-none px-2" data-bs-toggle="dropdown"
                        data-bs-offset="0,25" type="button" aria-haspopup="false" aria-expanded="false">
                        <img src="{{ asset('images/users/' . (session('user_image') ?? 'avatar-1.jpg')) }}" width="32" class="rounded-circle me-lg-2 d-flex"
                            alt="user-image">
                        <span class="d-lg-flex flex-column gap-1 d-none">
                            <h5 class="my-0">{{ session('user_name') }}</h5>
                        </span>
                        <i class="ri-arrow-down-s-line d-none d-lg-block align-middle ms-1"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end">
                        <!-- item-->
                        <div class="dropdown-header noti-title">
                            <h6 class="text-overflow m-0">Welcome !</h6>
                        </div>

                        <!-- item-->
                        <a href="{{ route('my-account') }}" class="dropdown-item">
                            <i class="ri-account-circle-line me-1 fs-16 align-middle"></i>
                            <span class="align-middle">My Account</span>
                        </a>

                        <!-- item-->
                        {{-- Settings: Available to all users (Appearance is public), but individual sections require permissions --}}
                        <a href="{{ route('settings.appearance') }}" class="dropdown-item">
                            <i class="ri-settings-2-line me-1 fs-16 align-middle"></i>
                            <span class="align-middle">Settings</span>
                        </a>

                        <!-- item-->
                        <a href="{{ route('clear-cache') }}" class="dropdown-item">
                            <i class="ri-question-line me-1 fs-16 align-middle"></i>
                            <span class="align-middle">Clear Cache</span>
                        </a>

                        <div class="dropdown-divider"></div>

                        <!-- item-->
                        <a href="javascript:void(0);" class="dropdown-item">
                            <i class="ri-lock-line me-1 fs-16 align-middle"></i>
                            <span class="align-middle">Lock Screen</span>
                        </a>

                        <!-- item-->
                        <a href="{{ route('logout') }}" class="dropdown-item active fw-semibold text-danger">
                            <i class="ri-logout-box-line me-1 fs-16 align-middle"></i>
                            <span class="align-middle">Sign Out</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<!-- Topbar End -->

<!-- Search Modal -->
<div class="modal fade" id="searchModal" tabindex="-1" aria-labelledby="searchModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content bg-transparent">
                <div class="card mb-1">
                    <div class="px-3 py-2 d-flex flex-row align-items-center" id="top-search">
                        <i class="ri-search-line fs-22"></i>
                        <input type="search" class="form-control border-0" id="search-modal-input"
                        placeholder="Search pages..." autocomplete="off">
                    <button type="button" class="btn p-0" data-bs-dismiss="modal" aria-label="Close">[esc]</button>
                    </div>
                </div>
            <div id="search-results" class="card" style="display:none; max-height: 400px; overflow-y: auto;"></div>
        </div>
    </div>
</div>

<script>
(function() {
    // Build searchable items from dynamically generated navbar - permission-aware
    // Only includes menu items that are visible to the current user
    const navItems = [
        @php
        // Use searchableMenuItems if available (from AppServiceProvider)
        // This contains only menu items the user has permission to see
        $items = isset($searchableMenuItems) ? $searchableMenuItems : [];
        @endphp
        @foreach($items as $item)
        {name: @json($item['name']), url: @json($item['url']), group: @json($item['group'])},
        @endforeach
    ];

    let selectedIndex = -1;
    let debounceTimer = null;
    const searchInput = document.getElementById('search-modal-input');
    const resultsContainer = document.getElementById('search-results');

    // Fuzzy match with up to 3 typos (Levenshtein distance)
    function fuzzyMatch(text, query) {
        text = text.toLowerCase();
        query = query.toLowerCase();
        if (text.includes(query)) return { match: true, distance: 0 };
        const distance = levenshtein(text, query);
        return { match: distance <= 3, distance: distance };
    }

    function levenshtein(a, b) {
        if (a.length === 0) return b.length;
        if (b.length === 0) return a.length;
        const matrix = [];
        for (let i = 0; i <= b.length; i++) matrix[i] = [i];
        for (let j = 0; j <= a.length; j++) matrix[0][j] = j;
        for (let i = 1; i <= b.length; i++) {
            for (let j = 1; j <= a.length; j++) {
                if (b.charAt(i - 1) === a.charAt(j - 1)) {
                    matrix[i][j] = matrix[i - 1][j - 1];
                } else {
                    matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1, matrix[i][j - 1] + 1, matrix[i - 1][j] + 1);
                }
            }
        }
        return matrix[b.length][a.length];
    }

    function highlightMatch(text, query) {
        const lowerText = text.toLowerCase();
        const lowerQuery = query.toLowerCase();
        const idx = lowerText.indexOf(lowerQuery);
        if (idx >= 0) {
            return text.substring(0, idx) + '<mark>' + text.substring(idx, idx + query.length) + '</mark>' + text.substring(idx + query.length);
        }
        return text;
    }

    function search(query) {
        if (!query || query.length < 1) {
            resultsContainer.style.display = 'none';
            return;
        }
        const results = navItems.filter(item => {
            const nameMatch = fuzzyMatch(item.name, query);
            const groupMatch = fuzzyMatch(item.group, query);
            return nameMatch.match || groupMatch.match;
        }).sort((a, b) => {
            const aDist = Math.min(fuzzyMatch(a.name, query).distance, fuzzyMatch(a.group, query).distance);
            const bDist = Math.min(fuzzyMatch(b.name, query).distance, fuzzyMatch(b.group, query).distance);
            return aDist - bDist;
        });

        if (results.length === 0) {
            resultsContainer.innerHTML = '<div class="p-3 text-muted">No results found</div>';
            resultsContainer.style.display = 'block';
            selectedIndex = -1;
            return;
        }

        // Group results by parent menu
        const grouped = {};
        results.forEach(item => {
            const g = item.group || 'General';
            if (!grouped[g]) grouped[g] = [];
            grouped[g].push(item);
        });

        let html = '';
        let idx = 0;
        for (const group in grouped) {
            html += `<div class="px-3 py-1 bg-light fw-semibold text-muted small">${group}</div>`;
            grouped[group].forEach(item => {
                const highlighted = highlightMatch(item.name, query);
                html += `<a href="${item.url}" class="search-result-item d-block px-3 py-2 text-dark text-decoration-none" data-index="${idx}">${highlighted}</a>`;
                idx++;
            });
        }

        resultsContainer.innerHTML = html;
        resultsContainer.style.display = 'block';
        selectedIndex = -1;
    }

    function updateSelection() {
        const items = resultsContainer.querySelectorAll('.search-result-item');
        items.forEach((el, i) => {
            el.classList.toggle('bg-primary', i === selectedIndex);
            el.classList.toggle('text-white', i === selectedIndex);
            el.classList.toggle('text-dark', i !== selectedIndex);
        });
        if (selectedIndex >= 0 && items[selectedIndex]) {
            items[selectedIndex].scrollIntoView({ block: 'nearest' });
        }
    }

    searchInput?.addEventListener('input', function() {
        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => search(this.value.trim()), 150);
    });

    searchInput?.addEventListener('keydown', function(e) {
        const items = resultsContainer.querySelectorAll('.search-result-item');
        if (e.key === 'ArrowDown') {
            e.preventDefault();
            selectedIndex = Math.min(selectedIndex + 1, items.length - 1);
            updateSelection();
        } else if (e.key === 'ArrowUp') {
            e.preventDefault();
            selectedIndex = Math.max(selectedIndex - 1, 0);
            updateSelection();
        } else if (e.key === 'Enter') {
            e.preventDefault();
            if (selectedIndex >= 0 && items[selectedIndex]) {
                window.location.href = items[selectedIndex].href;
            }
        }
    });

    resultsContainer?.addEventListener('mouseover', function(e) {
        const item = e.target.closest('.search-result-item');
        if (item) {
            selectedIndex = parseInt(item.dataset.index, 10);
            updateSelection();
        }
    });

    document.getElementById('searchModal')?.addEventListener('shown.bs.modal', function() {
        searchInput.value = '';
        resultsContainer.style.display = 'none';
        searchInput.focus();
    });

    document.getElementById('searchModal')?.addEventListener('hidden.bs.modal', function() {
        searchInput.value = '';
        resultsContainer.style.display = 'none';
        selectedIndex = -1;
    });
})();
</script>