<!DOCTYPE html>
<html lang="en" data-layout="topnav" data-bs-theme="light" data-menu-color="dark" data-topbar-color="dark">

<head>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @include('layouts.partials/title-meta', ['title' => $title ?? 'Settings'])
    @include('layouts.partials/head-css')
    
    <script src="{{ asset('vendor/jquery/jquery-3.7.1.min.js') }}"></script>

    @section('css')
    <style>
        .settings-menu-list {
            display: flex;
            flex-direction: column;
            gap: 4px;
        }
        .settings-menu-item {
            display: flex;
            align-items: center;
            padding: 10px 15px;
            color: #495057;
            text-decoration: none;
            border-radius: 4px;
            transition: all 0.2s;
        }
        .settings-menu-item:hover {
            background-color: #f8f9fa;
            color: #0d6efd;
        }
        .settings-menu-item.active {
            background-color: #e7f1ff;
            color: #0d6efd;
            font-weight: 500;
        }
    </style>
    @endsection
    <style>
        @media (min-width: 768px) {
    .sticky-md {
        position: sticky;
        top: 150px;
    }
}
    </style>
</head>

<body>
    <div class="wrapper">
        @include('layouts.partials/topbar', ['topbarTitle' => $topbarTitle ?? 'Settings'])
        @include('layouts.partials/horizontal-nav')
        
        <div class="page-content">
            <div class="page-container">
                <div class="row">
                    <!-- Settings Sidebar -->
                    <div class="col-xl-3 col-lg-4">
                    <div class="card   sticky-md" >
                            <div class="card-header border-bottom border-dashed d-flex align-items-center">
                                <h4 class="header-title">Settings</h4>
                            </div>

                            <div class="card-body">
                                <div class="list-group">
                                    {{-- Appearance - No permission required, visible to all users --}}
                                    <a href="{{ route('settings.appearance') }}" class="list-group-item d-flex  list-group-item-action {{ request()->routeIs('settings.appearance*') ? 'active' : '' }}">
                                        <iconify-icon icon="mdi:palette" class="me-1 fs-18"></iconify-icon>
                                        <span>Appearance</span>
                                    </a>
                                    
                                    {{-- User Management - Requires user_management permission --}}
                                    @can('User Management')
                                    <a href="{{ route('settings.users') }}" class="list-group-item d-flex  list-group-item-action {{ request()->routeIs('settings.users*') ? 'active' : '' }}">
                                        <iconify-icon icon="mdi:account-group" class="me-1 fs-18"></iconify-icon>
                                        <span>User Management</span>
                                    </a>
                                    @endcan
                                    
                                    {{-- Role Management - Requires role_management permission --}}
                                    @can('Role Management')
                                    <a href="{{ route('settings.role-management.index') }}" class="list-group-item d-flex  list-group-item-action {{ request()->routeIs('settings.role-management*') ? 'active' : '' }}">
                                        <iconify-icon icon="mdi:shield-account" class="me-1 fs-18"></iconify-icon>
                                        <span>Role Management</span>
                                    </a>
                                    @endcan
                                    
                                    {{-- Login Logs - Requires login_logs permission --}}
                                    @can('Login Logs')
                                    <a href="{{ route('settings.login-logs.index') }}" class="list-group-item d-flex  list-group-item-action {{ request()->routeIs('settings.login-logs*') ? 'active' : '' }}">
                                        <iconify-icon icon="mdi:file-document-edit" class="me-1 fs-18"></iconify-icon>
                                        <span>Login Logs</span>
                                    </a>
                                    @endcan
                                    
                                    {{-- Menus - Requires menu_management permission --}}
                                    @can('Menus')
                                    <a href="{{ route('settings.menus.index') }}" class="list-group-item d-flex  list-group-item-action {{ request()->routeIs('settings.menus.*') ? 'active' : '' }}">
                                        <iconify-icon icon="mdi:menu" class="me-1 fs-18"></iconify-icon>
                                        <span>Menus</span>
                                    </a>
                                    @endcan
                                    
                                    {{-- Advanced - Requires advanced_settings permission --}}
                                    @can('advanced_settings')
                                    <a href="{{ route('settings.advanced') }}" class="list-group-item d-flex  list-group-item-action {{ request()->routeIs('settings.advanced*') ? 'active' : '' }}">
                                        <iconify-icon icon="mdi:cog" class="me-1 fs-18"></iconify-icon>
                                        <span>Advanced</span>
                                    </a>
                                    @endcan
                                </div>

                            </div> <!-- end card-body -->
                        </div> <!-- end card-->
                    </div>
                    
                    <!-- Settings Content -->
                    <div class="col-xl-9 col-lg-8">
                        @yield('content')
                    </div>
                </div>
            </div>
        </div>
        
        @include('layouts.partials/footer')
    </div>

    @include('layouts.partials/customizer')
    @include('layouts.partials/footer-scripts')
    
    @yield('scripts')
</body>

</html>
