@extends('layouts.settings', ['title' => 'Menu', 'topbarTitle' => 'Settings'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/dragula@3.7.3/dist/dragula.min.css">
<style>
.dragula-handle {
    cursor: move;
    width: 20px;
    height: 20px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin-right: 10px;
    color: #6c757d;
    flex-shrink: 0;
}

.dragula-handle:hover {
    color: #495057;
}

.dragula-handle::before {
    content: "⋮⋮";
    font-size: 16px;
    line-height: 1;
    letter-spacing: -2px;
}

.accordion-button:not(.collapsed) .dragula-handle {
    color: #495057;
}

.accordion-header {
    position: relative;
}

.accordion-button {
    padding-left: 50px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.accordion-button-disabled,
.accordion-button:disabled {
    cursor: default;
    opacity: 1;
}

.accordion-button-disabled::after,
.accordion-button:disabled::after {
    display: none;
}

.accordion-button .menu-content {
    display: flex;
    align-items: center;
    gap: 10px;
    flex: 1;
    min-width: 0;
}

.accordion-button .menu-actions {
    display: flex;
    align-items: center;
    gap: 8px;
    margin-left: auto;
    flex-shrink: 0;
}

.child-accordion {
    margin-left: 20px;
    margin-top: 10px;
}

input[data-switch].switch + label {
    width: 80px !important;
}

input[data-switch].switch:checked + label:after {
    left: 58px !important;
}

.accordion-item {
    border: 1px solid rgba(0, 0, 0, 0.125);
    margin-bottom: 8px;
}

.cursor-pointer {
    cursor: pointer;
}
</style>
@endsection


@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Menus</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Settings</a></li>
                        <li class="breadcrumb-item active">Menus</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            @if($all_menus->isNotEmpty())
                <div class="accordion accordion-bordered" id="menusContainer">
                    @foreach($all_menus as $menu)
                        @php
                            $params = $menu->route_params ? json_decode($menu->route_params, true) : [];
                            $menu_url = !empty($menu->route) ? route($menu->route, $params) : '#';
                        @endphp
                        <div class="accordion-item" data-id="{{ $menu->id }}" data-parent-id="0">
                            <h2 class="accordion-header" id="heading-{{ $menu->id }}">
                                <button class="accordion-button collapsed {{ $menu->childs->count() == 0 ? 'accordion-button-disabled' : '' }}" 
                                    type="button" 
                                    @if($menu->childs->count() > 0)
                                        data-bs-toggle="collapse"
                                        data-bs-target="#collapse-{{ $menu->id }}"
                                    @endif
                                    aria-expanded="false" 
                                    aria-controls="collapse-{{ $menu->id }}"
                                    @if($menu->childs->count() == 0)
                                        disabled
                                    @endif>
                                    <span class="dragula-handle" onclick="event.stopPropagation();"></span>
                                    <div class="menu-content">
                                        <a href="{{ $menu_url }}" onclick="event.stopPropagation();" class="text-primary text-decoration-none">
                                            <strong>{{ $menu->name }}</strong>
                                        </a>
                                        @if($menu->childs->count())
                                            <span class="badge bg-info">{{ $menu->childs->count() }}</span>
                                        @endif
                                    </div>
                                    <div class="menu-actions" onclick="event.stopPropagation();">
                                        <div>
                                            <input {{ $menu->is_active ? 'checked' : '' }} type="checkbox" menuId="{{ $menu->id }}"
                                                data-switch="{{ $menu->is_active ? 'success' : 'danger' }}" class="form-check-input switch menu-status-toggle" id="switch{{ $menu->id }}" onclick="event.stopPropagation();">
                                            <label data-bs-toggle="tooltip" data-bs-placement="top" title="Status" for="switch{{ $menu->id }}" data-on-label="Active" data-off-label="Inactive" onclick="event.stopPropagation();"></label>
                                        </div>
                                        <iconify-icon icon="mdi:add" onclick="event.stopPropagation(); addChildMenu('{{ $menu->id }}', '{{ $menu->name }}');" class="fs-22 cursor-pointer"></iconify-icon>
                                        <iconify-icon icon="line-md:edit-twotone" class="fs-22 cursor-pointer" onclick="event.stopPropagation(); editMenuModal({{ Js::from($menu) }});">
                                        </iconify-icon>
                                    </div>
                                </button>
                            </h2>
                            <div id="collapse-{{ $menu->id }}" class="accordion-collapse collapse" aria-labelledby="heading-{{ $menu->id }}">
                                <div class="accordion-body">
                                    @if($menu->childs->count())
                                        <div class="accordion accordion-bordered child-accordion" id="child-accordion-{{ $menu->id }}">
                                            @foreach($menu->childs as $child)
                                                @php
                                                    $child_params = $child->route_params ? json_decode($child->route_params, true) : [];
                                                    $child_menu_url = !empty($child->route) ? route($child->route, $child_params) : '#';
                                                @endphp
                                                <div class="accordion-item" data-id="{{ $child->id }}" data-parent-id="{{ $menu->id }}">
                                                    <h2 class="accordion-header" id="heading-child-{{ $child->id }}">
                                                        <button class="accordion-button collapsed {{ $child->childs->count() == 0 ? 'accordion-button-disabled' : '' }}" 
                                                            type="button" 
                                                            @if($child->childs->count() > 0)
                                                                data-bs-toggle="collapse"
                                                                data-bs-target="#collapse-child-{{ $child->id }}"
                                                            @endif
                                                            aria-expanded="false" 
                                                            aria-controls="collapse-child-{{ $child->id }}"
                                                            @if($child->childs->count() == 0)
                                                                disabled
                                                            @endif>
                                                            <span class="dragula-handle" onclick="event.stopPropagation();"></span>
                                                            <div class="menu-content">
                                                                <a href="{{ $child_menu_url }}" onclick="event.stopPropagation();" class="text-secondary text-decoration-none">
                                                                    <strong>{{ $child->name }}</strong>
                                                                </a>
                                                                @if($child->childs->count())
                                                                    <span class="badge bg-info">{{ $child->childs->count() }}</span>
                                                                @endif
                                                            </div>
                                                            <div class="menu-actions" onclick="event.stopPropagation();">
                                                                <div>
                                                                    <input {{ $child->is_active ? 'checked' : '' }} type="checkbox" menuId="{{ $child->id }}"
                                                                        data-switch="{{ $child->is_active ? 'success' : 'danger' }}" class="form-check-input switch menu-status-toggle" id="switch{{ $child->id }}" onclick="event.stopPropagation();">
                                                                    <label data-bs-toggle="tooltip" data-bs-placement="top" title="Status" for="switch{{ $child->id }}" data-on-label="Active" data-off-label="Inactive" onclick="event.stopPropagation();"></label>
                                                                </div>
                                                                <iconify-icon icon="mdi:add" onclick="event.stopPropagation(); addChildMenu('{{ $child->id }}', '{{ $child->name }}');" class="fs-22 cursor-pointer"></iconify-icon>
                                                                <iconify-icon icon="line-md:edit-twotone" class="fs-22 cursor-pointer" onclick="event.stopPropagation(); editMenuModal({{ Js::from($child) }});"></iconify-icon>
                                                            </div>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse-child-{{ $child->id }}" class="accordion-collapse collapse" aria-labelledby="heading-child-{{ $child->id }}">
                                                        <div class="accordion-body">
                                                            @if($child->childs->count())
                                                                <div class="accordion accordion-bordered child-accordion" id="grandchild-accordion-{{ $child->id }}">
                                                                    @foreach($child->childs as $grand)
                                                                        @php
                                                                            $grand_params = $grand->route_params ? json_decode($grand->route_params, true) : [];
                                                                            $grand_menu_url = !empty($grand->route) ? route($grand->route, $grand_params) : '#';
                                                                        @endphp
                                                                        <div class="accordion-item" data-id="{{ $grand->id }}" data-parent-id="{{ $child->id }}">
                                                                            <h2 class="accordion-header" id="heading-grand-{{ $grand->id }}">
                                                                                <button class="accordion-button collapsed accordion-button-disabled" 
                                                                                    type="button" 
                                                                                    aria-expanded="false" 
                                                                                    aria-controls="collapse-grand-{{ $grand->id }}"
                                                                                    disabled>
                                                                                    <span class="dragula-handle" onclick="event.stopPropagation();"></span>
                                                                                    <div class="menu-content">
                                                                                        <a href="{{ $grand_menu_url }}" onclick="event.stopPropagation();" class="text-dark text-decoration-none">
                                                                                            <strong>{{ $grand->name }}</strong>
                                                                                        </a>
                                                                                    </div>
                                                                                    <div class="menu-actions" onclick="event.stopPropagation();">
                                                                                        <div>
                                                                                            <input {{ $grand->is_active ? 'checked' : '' }} type="checkbox" menuId="{{ $grand->id }}"
                                                                                                data-switch="{{ $grand->is_active ? 'success' : 'danger' }}" class="form-check-input switch menu-status-toggle" id="switch{{ $grand->id }}" onclick="event.stopPropagation();">
                                                                                            <label data-bs-toggle="tooltip" data-bs-placement="top" title="Status" for="switch{{ $grand->id }}" data-on-label="Active" data-off-label="Inactive" onclick="event.stopPropagation();"></label>
                                                                                        </div>
                                                                                        <iconify-icon icon="line-md:edit-twotone" class="fs-22 cursor-pointer" onclick="event.stopPropagation(); editMenuModal({{ Js::from($grand) }});"></iconify-icon>
                                                                                    </div>
                                                                                </button>
                                                                            </h2>
                                                                            <div id="collapse-grand-{{ $grand->id }}" class="accordion-collapse collapse" aria-labelledby="heading-grand-{{ $grand->id }}">
                                                                                <div class="accordion-body">
                                                                                    <!-- Grandchildren content if needed -->
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <form id="addMenuForm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="add_for_menu_name"  ></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" style="height: 66vh; overflow: auto;" >
                    <input type="hidden" name="parent_id" id="addMenuParent">

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="addMenuName" class="form-label">Name</label>
                            <input type="text" class="form-control" id="addMenuName" name="name" required>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="addMenuPermission" class="form-label">Permission</label>
                            <select name="permission" id="addMenuPermission" class="form-select select2">
                                <option value="">Select Permission</option>
                                @foreach($permissions as $permission)
                                    <option value="{{ $permission->name }}">{{ str_replace('_', ' ', $permission->name) }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="addMenuRoute" class="form-label">Route</label>
                            <input type="text" class="form-control" id="addMenuRoute" name="route">
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-2 mb-3">
                            <label for="addMenuTargetLink" class="form-label">Link Target</label>
                            <select name="link_target" id="addMenuTargetLink" class="form-control" >
                                <option value="_self" >Self</option>
                                <option value="_blank" >Blank</option>
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="addMenuRouteParams" class="form-label">Route Params  (comma-separated or key:value)</label>
                            <input type="text" class="form-control" id="addMenuRouteParams" name="route_params" placeholder="e.g. id:5,status:active or param1,param2">
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="addMenuIcon" class="form-label">Icon <span class="text-info">iconify-icon</span></label>
                            <input type="text" class="form-control" id="addMenuIcon" name="icon">
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="addMenuChildIcon" class="form-label">Child Icon <span class="text-info">iconify-icon</span></label>
                            <input type="text" class="form-control" id="addMenuChildIcon" name="child_icon">
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-2 mb-3">
                            <label for="addMenuChildIconPos" class="form-label">Child Icon Position</label>
                            <select class="form-select" id="addMenuChildIconPos" name="child_icon_position">
                                <option value="start">Start</option>
                                <option value="end">End</option>
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="addMenuBeforeSep" name="before_separator">
                        <label class="form-check-label" for="addMenuBeforeSep">Before Separator</label>
                        <div class="invalid-feedback"></div>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="addMenuAfterSep" name="after_separator">
                        <label class="form-check-label" for="addMenuAfterSep">After Separator</label>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <form id="editMenuForm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Menue</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" style="height: 66vh; overflow: auto;" >
                    <input type="hidden" name="id" id="editMenuId">

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="editMenuName" class="form-label">Name</label>
                            <input type="text" class="form-control" id="editMenuName" name="name" required>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="editMenuPermission" class="form-label">Permission</label>
                            <select name="permission" id="editMenuPermission" class="form-select select2">
                                <option value="">Select Permission</option>
                                @foreach($permissions as $permission)
                                    <option value="{{ $permission->name }}">{{ str_replace('_', ' ', $permission->name) }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label for="editMenuRoute" class="form-label">Route</label>
                            <input type="text" class="form-control" id="editMenuRoute" name="route">
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-2 mb-3">
                            <label for="editMenuTargetLink" class="form-label">Link Target</label>
                            <select name="link_target" id="editMenuTargetLink" class="form-control" >
                                <option value="_self" >Self</option>
                                <option value="_blank" >Blank</option>
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="editMenuRouteParams" class="form-label">Route Params  (comma-separated or key:value)</label>
                            <input type="text" class="form-control" id="editMenuRouteParams" name="route_params" placeholder="e.g. id:5,status:active or param1,param2">
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="editMenuIcon" class="form-label">Icon <span class="text-info">iconify-icon</span></label>
                            <input type="text" class="form-control" id="editMenuIcon" name="icon">
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <label for="editMenuChildIcon" class="form-label">Child Icon <span class="text-info">iconify-icon</span></label>
                            <input type="text" class="form-control" id="editMenuChildIcon" name="child_icon">
                            <div class="invalid-feedback"></div>
                        </div>
                        <div class="col-md-2 mb-3">
                            <label for="editMenuChildIconPos" class="form-label">Child Icon Position</label>
                            <select class="form-select" id="editMenuChildIconPos" name="child_icon_position">
                                <option value="start">Start</option>
                                <option value="end">End</option>
                            </select>
                            <div class="invalid-feedback"></div>
                        </div>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="editMenuBeforeSep" name="before_separator">
                        <label class="form-check-label" for="editMenuBeforeSep">Before Separator</label>
                        <div class="invalid-feedback"></div>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="editMenuAfterSep" name="after_separator">
                        <label class="form-check-label" for="editMenuAfterSep">After Separator</label>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/dragula@3.7.3/dist/dragula.min.js"></script>
<script>

    $(function(){
        
        $('#editMenuPermission').select2({
            dropdownParent: $('#editModal')
        });
        // $('#addMenuPermission').select2({
        //     dropdownParent: $('#addModal')
        // });

        $('#addMenuPermission').select2({
            dropdownParent: $('#addModal'),
            tags: true,
            placeholder: "Select or add permission",
            createTag: function (params) {
                let term = $.trim(params.term);

                if (term === '') return null;

                return {
                    id: term,
                    text: '➕ Add "' + term + '"',
                    newPermission: true
                };
            }
        });

        $(document).off('select2:select', '#addMenuPermission').on('select2:select', '#addMenuPermission', function (e) {
            let data = e.params.data;

            if (data.newPermission) {
                createPermission(data.id);
            }
        });

        // Add Menu
        $(document).off('submit', '#addMenuForm').on('submit', '#addMenuForm', function (e) {
            e.preventDefault();
            let form = $(this);
            let url = "{{ route('settings.menus.store') }}";
            
 
            form.find('.is-invalid').removeClass('is-invalid');
            form.find('.invalid-feedback').text('');
            $.ajax({
                url: url,
                type: 'POST',
                data: form.serialize(),
                success: function (res) {
                    if (res.success) {
                        toastr.success(res.message);
                        new bootstrap.Modal(document.getElementById('addModal')).hide();
                        location.reload();
                    } else {
                        toastr.error(res.message);
                    }
                },
                error: function (xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.message;

                        $.each(errors, function (field, messages) {
                            let input = form.find(`[name="${field}"]`);

                            input.addClass('is-invalid');
                            input.next('.invalid-feedback').text(messages[0]);

                            if (input.hasClass('select2')) {
                                input.next('.select2-container').find('.select2-selection').addClass('is-invalid');
                            }
                        });
                    } else {
                        toastr.error('Something went wrong');
                    }
                }
            });
        });

        // Update Menu
        $(document).off('submit', '#editMenuForm').on('submit', '#editMenuForm', function (e) {
            e.preventDefault();
            let form = $(this);
            let menuId = $('#editMenuId').val();
            let url = "{{ route('settings.menus.update', ':id') }}";
            url = url.replace(':id', menuId);
            form.find('.is-invalid').removeClass('is-invalid');
            form.find('.invalid-feedback').text('');
            $.ajax({
                url: url,
                type: 'POST',
                data: form.serialize() + '&_method=PUT',
                success: function (res) {
                    if (res.success) {
                        toastr.success(res.message);
                        new bootstrap.Modal(document.getElementById('editModal')).hide();
                        location.reload();
                    } else {
                        toastr.error(res.message);
                    }
                },
                error: function (xhr) {
                    if (xhr.status === 422) {
                        let errors = xhr.responseJSON.message;

                        $.each(errors, function (field, messages) {
                            let input = form.find(`[name="${field}"]`);

                            input.addClass('is-invalid');
                            input.next('.invalid-feedback').text(messages[0]);

                            // Select2 special case
                            if (input.hasClass('select2')) {
                                input
                                .next('.select2-container')
                                .find('.select2-selection')
                                .addClass('is-invalid');
                            }
                        });
                    } else {
                        toastr.error('Something went wrong');
                    }
                }
            });
        });

        $(document)
        .off('change', '.menu-status-toggle')
        .on('change', '.menu-status-toggle', function () {

            let menuId   = $(this).attr('menuId');
            let isActive = $(this).is(':checked') ? 1 : 0;
            let $switch = $(this);

            // Update data-switch attribute based on checked state
            // success = green (active), danger = red (inactive)
            $switch.attr('data-switch', isActive ? 'success' : 'danger');

            $.ajax({
                url:  `/settings/menus/${menuId}/update-status`,
                type: 'POST',
                data: {
                    is_active: isActive
                },
                success: function (res) {
                    if (res.success) {
                        toastr.success(res.message);
                    } else {
                        toastr.error('Something went wrong');
                        // Revert the switch state on error
                        $switch.attr('data-switch', isActive ? 'danger' : 'success');
                        $switch.prop('checked', !isActive);
                    }
                },
                error: function (xhr) {

                    if (xhr.status === 422) {
                        toastr.error('Validation failed');
                    } else if (xhr.status === 403) {
                        toastr.error('You are not authorized');
                    } else {
                        toastr.error('Server error');
                    }
                    
                    // Revert the switch state on error
                    $switch.attr('data-switch', isActive ? 'danger' : 'success');
                    $switch.prop('checked', !isActive);

                }
            });

        });

        // Initialize Dragula with hierarchy rules after a short delay to ensure extended-dragula.js has loaded
        setTimeout(function() {
            initMenuDragula();
        }, 100);

        // Note: Accordion toggle prevention is handled by inline onclick handlers with stopPropagation
        // No need for delegated handlers that might interfere with onclick execution

        // Prevent accordion toggle for disabled accordion buttons
        $(document).on('click', '.accordion-button:disabled, .accordion-button-disabled', function(e) {
            e.preventDefault();
            e.stopPropagation();
            return false;
        });

    });

    function initMenuDragula() {
        // Get all accordion containers (parent, child, grandchild)
        const containers = [];
        
        // Main container
        const mainContainer = document.getElementById('menusContainer');
        if (mainContainer) containers.push(mainContainer);
        
        // Child containers
        document.querySelectorAll('[id^="child-accordion-"]').forEach(container => {
            containers.push(container);
        });
        
        // Grandchild containers
        document.querySelectorAll('[id^="grandchild-accordion-"]').forEach(container => {
            containers.push(container);
        });

        if (containers.length === 0) return;

        // Destroy any existing dragula instances on these containers
        containers.forEach(container => {
            if (container.__dragula) {
                container.__dragula.destroy();
            }
        });

        // Initialize dragula with handle-only dragging and hierarchy rules
        const drake = dragula(containers, {
            moves: function (el, source, handle, sibling) {
                // Only allow dragging via the handle
                return handle && handle.classList.contains('dragula-handle');
            },
            accepts: function (el, target, source, sibling) {
                // Enforce hierarchy rules
                const draggedItem = el;
                const draggedParentId = draggedItem.getAttribute('data-parent-id');
                
                // If dragging to main container, only accept items with parent-id="0"
                if (target.id === 'menusContainer') {
                    return draggedParentId === '0';
                }
                
                // If dragging to a child container, check if it matches the dragged item's parent
                if (target.id && target.id.startsWith('child-accordion-')) {
                    const targetMenuId = target.id.replace('child-accordion-', '');
                    return draggedParentId === targetMenuId;
                }
                
                // If dragging to a grandchild container, check if it matches the dragged item's parent
                if (target.id && target.id.startsWith('grandchild-accordion-')) {
                    const targetChildId = target.id.replace('grandchild-accordion-', '');
                    return draggedParentId === targetChildId;
                }
                
                // Same container is always allowed
                if (source === target) {
                    return true;
                }
                
                return false;
            }
        });

        // Store drake instance for cleanup
        containers.forEach(container => {
            container.__dragula = drake;
        });

        drake.on('drop', function (el, target, source, sibling) {
            // Update order on server
            updateMenuOrder(target);
        });

        drake.on('cancel', function (el, container, source) {
            // Handle cancel if needed
        });
    }

    function updateMenuOrder(container) {
        // Get all menu items in the container
        const items = Array.from(container.querySelectorAll('.accordion-item[data-id]'));
        
        const menus = items.map((item, index) => {
            const menuId = item.getAttribute('data-id');
            const parentId = item.getAttribute('data-parent-id') || '0';
            
            return {
                id: menuId,
                parent_id: parentId,
                sort_order: index + 1
            };
        });

        // Send update to server
        fetch("{{ route('settings.menus.updateOrder') }}", {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({ menus: menus })
        })
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                toastr.success('Menu order updated successfully');
            } else {
                toastr.error('Failed to update menu order');
            }
        })
        .catch(error => {
            console.error('Error updating menu order:', error);
            toastr.error('Error updating menu order');
        });
    }

    function editMenuModal(menu) {
        $('#editMenuId').val(menu.id);
        $('#editMenuName').val(menu.name);
        $('#editMenuPermission').val(menu.permission).change();
        $('#editMenuRoute').val(menu.route);
        $('#editMenuTargetLink').val(menu.link_target);
        $('#editMenuRouteParams').val(menu.route_params);
        $('#editMenuIcon').val(menu.icon);
        $('#editMenuChildIcon').val(menu.child_icon);
        $('#editMenuChildIconPos').val(menu.child_icon_position);
        $('#editMenuBeforeSep').prop('checked', menu.before_separator == '1' ? true : false);
        $('#editMenuAfterSep').prop('checked', menu.after_separator == '1' ? true : false);
        $('#editMenuParent').val(menu.parent_id);

        new bootstrap.Modal(document.getElementById('editModal')).show();
    }

    function addChildMenu(parentId, parentName) {
        $('#add_for_menu_name').text('Add Child Menu for "' + parentName + '"');
        $('#addMenuParent').val(parentId);
        $('#addMenuName').val('');
        $('#addMenuPermission').val('').change();
        $('#addMenuRoute').val('');
        $('#addMenuTargetLink').val('_self');
        $('#addMenuRouteParams').val('');
        $('#addMenuIcon').val('');
        $('#addMenuChildIcon').val('');
        $('#addMenuChildIconPos').val('end');
        $('#addMenuBeforeSep').prop('checked', false);
        $('#addMenuAfterSep').prop('checked', false);

        new bootstrap.Modal(document.getElementById('addModal')).show();
    }

    function createPermission(permissionName) {

        $.ajax({
            url: "{{ route('settings.role-permissions.permissions.store') }}",
            type: "POST",
            data: {
                name: permissionName,
            },
            success: function (res) {

                let newOption = new Option(
                    permissionName.replaceAll('_', ' '),
                    permissionName,
                    true,
                    true
                );

                $('#addMenuPermission')
                    .append(newOption)
                    .trigger('change');
            },
            error: function () {
                toastr.error('Unable to create permission');
            }
        });
    }
</script>

@endsection
