<div class="modal fade" id="customerAddModal" tabindex="-1" aria-labelledby="customerAddModal" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customerAddModal">Customer</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="customerForm">
                    @csrf
                    <input type="hidden" name="id_customers" id="id_customers" value="">
                    <input type="hidden" name="business_id" id="business_id" value="">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_name" class="form-label">Customer Name *</label>
                                <input type="text" class="form-control" id="customer_name" name="customer_name" required>
                            </div>
                        </div>                    
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_cell" class="form-label">Customer Cell *</label>
                                <input type="text" class="form-control numeric" id="customer_cell" name="customer_cell" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_card" class="form-label">Customer Card (optional)</label>
                                <input type="text" class="form-control" id="customer_card" name="customer_card">
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_careof" class="form-label">Care of</label><span id="careof_info" class="ms-2 text-success fw-bolder"></span>
                                <select onchange="updateCareOfSelection()" class="form-control" id="customer_careof" name="customer_careof">
                                    <option value="">Select Care of</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_gender" class="form-label">Customer Gender *</label>
                                <select class="form-select" id="customer_gender" name="customer_gender" required>
                                    <option value="">Select Gender</option>
                                    <option value="F">Female</option>
                                    <option value="M">Male</option>                                        
                                    <option value="O">Other</option>
                                </select>
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="allowed_balance" class="form-label">Customer Credit Limit *</label>
                                <input type="text" class="form-control" id="allowed_balance" name="allowed_balance" value="" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_email" class="form-label">Customer Email</label>
                                <input type="email" class="form-control" id="customer_email" name="customer_email">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_area" class="form-label">Customer Area</label>
                                <select class="form-select" id="customer_area" name="customer_area">
                                    <option value="">Select Area</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_phone1" class="form-label">Customer Phone 1</label>
                                <input type="text" class="form-control numeric" id="customer_phone1" name="customer_phone1">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_phone2" class="form-label">Customer Phone 2</label>
                                <input type="text" class="form-control numeric" id="customer_phone2" name="customer_phone2">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_birthday" class="form-label">Customer Birthday</label>
                                <input type="text" class="form-control numeric" id="customer_birthday" name="customer_birthday">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_birthmonth" class="form-label">Customer Birth Month</label>
                                <select class="form-select" id="customer_birthmonth" name="customer_birthmonth">
                                    <option value="">Select Month</option>
                                    @foreach (range(1, 12) as $month)
                                        <option value="{{ $month }}">{{ date('F', mktime(0, 0, 0, $month, 1)) }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_type" class="form-label">Customer Type</label>
                                <select class="form-select" id="customer_type" name="customer_type">
                                    <option value="blue">Regular Customer</option>
                                    <option value="orange">Star Customer</option>
                                    <option value="green">Important Customer</option>
                                    <option value="red">Red Flagged Customer</option>
                                    
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="profession" class="form-label">Customer Profession</label>
                                <input type="text" class="form-control" id="profession" name="profession">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_alert" class="form-label">Customer Alert</label>
                                <textarea class="form-control" id="customer_alert" name="customer_alert"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="customer_allergies" class="form-label">Customer Allergies</label>
                                <textarea class="form-control" id="customer_allergies" name="customer_allergies"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="customer_address" class="form-label">Customer Address</label>
                                <textarea class="form-control" id="customer_address" name="customer_address"></textarea>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" id="saveCustomerButton" onclick="add_customer()" class="btn btn-primary">
                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="saveCustomerSpinner"></span> Save Customer</button>
            </div>
        </div>
    </div>
</div>
 @vite(['resources/js/modals/customer_add.js'])