 <div class="modal fade" id="productEditModal" tabindex="-1" aria-labelledby="productEditModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form id="productEditForm">
                <div class="modal-header">
                    <h5 class="modal-title" id="productEditModalLabel">Edit Product</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <!-- Modal body content goes here -->
                    
                        <div class="row">
                            <div class="col-md-6  mb-3">
                                <label for="productID" class="form-label">Product ID</label>
                                <input type="text" class="form-control bg-light" id="productID" name="id_business_products" readonly required>
                            </div>  
                            <div class="col-md-6 mb-3">
                                <label for="productName" class="form-label">Product Name</label>
                                <input type="text" class="form-control" id="productName" name="productName" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="productBrand" class="form-label">Brand</label>
                                <select class="form-select" id="productBrand" name="brand_id" required>
                                    @foreach($brands as $brand)
                                        <option value="{{ $brand->id_business_brands }}">{{ $brand->business_brand_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="productCategory" class="form-label">Product Category</label>
                                <input type="text" class="form-control" id="productCategory" name="category" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="productPrice" class="form-label">Retail Price</label>
                                <input type="number" class="form-control {{ auth()->user()->cannot('add-product_retail_price') ? 'bg-light' : '' }}" id="productPrice" step="0.01"
                                    @can('add-product_retail_price') 
                                        name="price"
                                        required
                                    @else
                                        readonly value="0.00" 
                                    @endcan >
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productTax" class="form-label">Retail Tax</label>
                                <input type="number" class="form-control {{ auth()->user()->cannot('add-product_retail_price') ? 'bg-light' : '' }} " id="productTax" step="0.01" 
                                    @can('add-product_retail_price') 
                                        name="product_sales_tax"
                                        required
                                    @else
                                        readonly value="0.00" 
                                    @endcan
                                    >
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productPurchase" class="form-label">Purchase Price</label>
                                <input type="number" class="form-control {{ auth()->user()->cannot('add-product_purchase_price') ? 'bg-light' : '' }} " id="productPurchase" step="0.01"
                                    @can('add-product_purchase_price') 
                                        name="purchase_price" 
                                        required
                                    @else
                                        readonly value="0.00" 
                                    @endcan
                                    >
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productTrackInventory" class="form-label">Track Inventory</label>
                                <select class="form-control" id="productTrackInventory" name="track_inventory" required>
                                    <option value="Yes">Yes</option>
                                    <option value="No">No</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="productUnitType" class="form-label">Unit Type</label>
                                <select class="form-select" id="productUnitType" name="unit_type" required>
                                    @foreach($unit_types as $unit)
                                        <option value="{{ $unit->unit_type }}">{{ $unit->unit_type }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productQtyPerUnit" class="form-label">Quantity Per Unit</label>
                                <input type="number" class="form-control" id="productQtyPerUnit" name="qty_per_unit" step="0.01" required>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productMeasureUnit" class="form-label">Measure Unit</label>
                                <select class="form-select" id="productMeasureUnit" name="measure_unit" required>
                                    @foreach($measure_units as $unit)
                                        <option value="{{ $unit->m_unit }}">{{ $unit->m_unit }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="productSKU" class="form-label">SKU</label>
                                <input type="text" class="form-control" id="productSKU" name="sku">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productBarCode" class="form-label">Bar Code</label>
                                <input type="text" class="form-control" id="productBarCode" name="barcode_products">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productCommissionType" class="form-label">Commission Type</label>
                                <select class="form-select" id="productCommissionType" name="commission_type" required>
                                    <option value="Fixed">Fixed</option>
                                    <option value="Percentage">Percentage</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productCommission" class="form-label">Commission</label>
                                <input type="text" class="form-control" id="productCommission" name="commission" required>
                            </div>                            
                        </div>
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label for="productProfessional" class="form-label">Professional</label>
                                <select type="text" class="form-control" id="productProfessional" name="professional" required>
                                    <option value="y">Yes</option>
                                    <option value="n">No</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productActive" class="form-label">Active</label>
                                <select type="text" class="form-control" id="productActive" name="business_product_active" required>
                                    <option value="Yes">Yes</option>
                                    <option value="No">No</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productThreshold" class="form-label">Threshold</label>
                                <input type="text" class="form-control" id="productThreshold" name="product_threshold" required>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label for="productType" class="form-label">Product Type</label>
                                <select class="form-select" id="productType" name="product_type" required>
                                    <option value="">Select Product Type</option>
                                    <option value="Physical">Physical</option>
                                    <option value="Subscription">Subscription</option>
                                    <option value="Digital">Digital</option>
                                    <option value="Compiled Kit">Compiled Kit</option>
                                </select>
                            </div>                            
                        </div>
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" id="saveProductButton" class="btn btn-primary">
                        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="saveProductSpinner"></span> Save Changes</button>
                </div>
                </form>
            </div>
        </div>
    </div>

