<style>
    /* Force visible highlight for Select2 results */
.select2-results__option--highlighted {
    background-color: #b37393 !important; /* Bootstrap primary */
    color: #fff !important;
}

</style>
<div id="visit-details-modal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="fullWidthModalLabel" aria-hidden="true"  data-bs-focus="false">
    <div class="modal-dialog modal-full-width modal-dialog-scrollable">
        <div class="modal-content" style="border-radius: 6px">
            <div class="modal-header">
                <h4 class="modal-title" id="fullWidthModalLabel">
                    <span id="visit-details-id-customers" class=""></span>
                    <span id="visit-details-customer-name" class="fw-bolder"></span> 
                    Visit ID: <span id="visit-details-id-customer-visits"></span> <br>
                    <span id="visit-details-customer-cell" class="text-muted"></span><br>
                    <span id="visit-details-visit-status-header" class="text-muted"></span>
                </h4>
                <span id="visit-details-balance-div" class="ms-4 d-none text-danger">Customer has balances of: </span><span id="visit-details-recovery-btn-div" class="ms-4"></span>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                
            </div>
            <div class="modal-body " style="font-size:12px;">
                
                <input type="hidden" id="business-tax-cash" value="{{ $business_taxes->tax_percentage_cash_service ?? 0 }}">
                <input type="hidden" id="business-tax-card" value="{{ $business_taxes->tax_percentage_card_service ?? 0 }}">
                <input type="hidden" id="business-tax-online" value="{{ $business_taxes->tax_percentage_online_service ?? 0 }}">
                <input type="hidden" id="business-tax-check" value="{{ $business_taxes->tax_percentage_check_service ?? 0 }}">
                <input type="hidden" id="business-tax-voucher" value="{{ $business_taxes->tax_percentage_voucher_service ?? 0 }}">
                <input type="hidden" id="business-cc-fee-percent" value="{{ $business->cc_charge ?? 0 }}">

             

               <div class="row mb-0" id="visit-details-customer-notification-div" class="d-none">
                    <div class="col-12 p-1">
                        <div id="visit-details-customer-notification" class="alert alert-info" ></div>
                    </div> 
               </div>
               <div id="visit-detail-modal-select-customer-panel" class="d-none" >                   
                    <div class="row mt-2 mb-2">                        
                        <div class="col-4">
                            <input type="hidden" id="temp_customer_search_value" value="">
                            <label for="visit-details-new-visit-select-customer" class="form-label fs-14 fw-bolder text-primary">Select Customer: <span class="text-muted fs-12">(Name / Cell / Card / Email)</span> </label>
                            <select onchange="selectCustomerForVisit()" id="visit-details-new-visit-select-customer" class="form-select">                               
                            </select>
                            
                        </div>
                        <div class="col-2 customer-panel-extras  d-none" id="selected-staff-combo-box-div">
                            <label for="visit-details-new-visit-selected-staff" class="form-label fs-14  text-secondary">Selected Staff: </label>
                            <select id="visit-details-new-visit-selected-staff" class="form-select">                               
                            </select>
                        </div>
                        <div class="col-2 customer-panel-extras d-none">
                            <label class="form-label fs-14 text-success">Selected Date & Time: </label>
                            <input  id="visit-details-new-visit-datetime" class="form-control flatpickr visit-date-time d-inline-block w-auto fs-12" value="{{ date('Y-m-d\TH:i:s') }}">
                            <input type="hidden" id="visit-details-new-visit-date" value="">
                        </div>
                        <div class="col-4 customer-panel-extras d-none">
                            <label class="form-label fs-14">Additional Visit Info: </label>
                            <div class="row">
                                <div class="col-4">
                                    <input type="checkbox" id="visit-details-new-visit-requested" class = "form-check-input fs-16">
                                    <label class="form-label p-1" for="visit-details-new-visit-requested">Requested Staff</label>
                                </div>
                                 <div class="col-4">
                                    <input type="checkbox" id="visit-details-new-visit-promo" class = "form-check-input fs-16">
                                    <label class="form-label p-1" for="visit-details-new-visit-promo">Promotion</label>
                                </div>
                                <div class="col-4">
                                    <input type="checkbox" id="visit-details-new-visit-strict-time" class = "form-check-input fs-16">
                                    <label class="form-label p-1" for="visit-details-new-visit-strict-time">Strict Time</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-8 customer-panel-extras-replacement bg-soft-success p-2">
                            <label for="visit-details-new-visit-customer-notes" class="form-label fs-14 fw-bolder text-success">Search Hints: </label>
                            <p>Use Customer Cell when ever possible. Cell numbers are the primary identifier for customer records.</p>
                            <p>Any Part of Customer Name or Customer's Email Address can also be used</p>
                            <p>Customer Card if assigned can also be used</p>
                        </div>
                    </div>
                    
               </div>

                <div id="visit-detail-modal-gift-voucher-panel" class="d-none mt-2">                    
                    <div class="row mt-2 mb-1 border-top pt-2 pb-2">
                        <div class="col-3">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-type">Voucher Type:</label>
                            <div id="visit-details-modal-gift-voucher-type" class="d-flex justify-content-between align-items-center p-1 border rounded">
                                <!-- Left (start) radio -->
                                <div class="form-check form-check-inline m-0">
                                    <input onclick="gift_voucher_type_changed()" type="radio" id="gift_voucher_type_amount" name="gift_voucher_type" value="amount" checked="checked" class="form-check-input">
                                    <label class="form-check-label" for="gift_voucher_type_amount">Amount</label>
                                </div>

                                <!-- Right (end) radio -->
                                <div class="form-check form-check-inline m-0">
                                    <input onclick="gift_voucher_type_changed()" type="radio" id="gift_voucher_type_service" value="service" name="gift_voucher_type" class="form-check-input">
                                    <label class="form-check-label" for="gift_voucher_type_service">Service</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-2">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-validity">Valid Until:</label>
                            <input type="date" class="form-control" id="visit-details-modal-gift-voucher-validity">
                        </div>
                        <div class="col-2">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-payment-mode">Payment Mode:</label>
                            <select onchange="gift_voucher_paid_amount_changed()" class="form-select" id="visit-details-modal-gift-voucher-payment-mode" >
                                <option value="Cash">Cash</option>
                                <option value="Card">Card</option>
                                <option value="D-Card">D.Card</option>
                                <option value="Check">Check</option>
                                <option value="Online">Online</option>
                            </select>
                        </div>
                        <div class="col-2">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-instrument">Instrument#:</label>
                            <input type="text" class="form-control" id="visit-details-modal-gift-voucher-instrument" placeholder="Enter Instrument Number">
                        </div>
                    </div>
                    <div class="row mb-2" id="gift-voucher-amount-row">
                        <div class="col-3">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-paid">Amount / Service Price:</label>
                            <input onkeyup="gift_voucher_paid_amount_changed()" type="text" class="form-control decimal" id="visit-details-modal-gift-voucher-paid" placeholder="Enter Amount / Service Price">
                        </div>
                        <div class="col-2">
                            <label class="form-label fs-14 fw-bolder"  for="visit-details-modal-gift-voucher-tax">Tax <span id="visit-details-modal-gift-voucher-tax-percent"></span>%:</label>
                            <input type="number" class="form-control" disabled id="visit-details-modal-gift-voucher-tax" placeholder="Tax" value="0">                            
                        </div>
                        <div class="col-2">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-cc-fee">CC-Fee:</label>
                            <input type="number" class="form-control" disabled id="visit-details-modal-gift-voucher-cc-fee" placeholder="CC-Fee" value="0" min="0">
                        </div>
                        <div class="col-2">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-total-amount">Total</label>
                            <input type="number" class="form-control" disabled id="visit-details-modal-gift-voucher-total-amount" placeholder="Total" value="0">
                        </div>
                        <div class="col-3">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-gift-voucher-heading">Printable Voucher Heading:</label>
                            <input type="text" class="form-control" id="visit-details-modal-gift-voucher-heading" placeholder="Happy Birthday" value="" >
                        </div>
                    </div>
                </div>

               <div id="visit-detail-modal-products-panel" class="d-none mt-2">                    
                    <div class="row mt-2 mb-2 border-top border-bottom border-light pt-2 pb-2">
                        <div class="col-4">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-product-search">Select Product:</label>
                            <select class="form-select" onchange="update_product_details()" id="visit-details-modal-product-search">
                            </select>
                        </div>
                        <div class="col-2">
                            <label class="form-label fs-14 fw-bolder" for="visit-details-modal-product-quantity">Quantity:</label>
                            <input type="number" class="form-control" id="visit-details-modal-product-quantity" placeholder="Quantity" value="1" min="1">
                        </div>
                        <div class="col-2">
                            <button onclick="add_product_to_product_table();" class="btn btn-primary btn-sm mt-4"><i class="ti ti-arrow-down fs-16"></i> Add Product</button>
                            <input type="hidden" id="visit-details-modal-product-id">
                            <input type="hidden" id="visit-details-modal-product-name">
                            <input type="hidden" id="visit-details-modal-product-brand">
                            <input type="hidden" id="visit-details-modal-product-batch-id">
                            <input type="hidden" id="visit-details-modal-product-batch-no">
                            <input type="hidden" id="visit-details-modal-product-price">
                            <input type="hidden" id="visit-details-modal-product-qty-per-unit">
                            <input type="hidden" id="visit-details-modal-product-measure-unit">
                        </div>
                        
                    </div>
                    <div class="row mb-3">
                        <div class="col-12">
                            <table class="table table-striped table-bordered border-light fs-13 h-100" id="visit-details-modal-products-table">
                                <thead class="table-dark text-white">
                                    <th>ID</th>
                                    <th>Product</th>
                                    <th>Brand</th>
                                    <th>Batch</th>
                                    <th class="text-end">Qty</th>
                                    <th class="text-end">Price</th>
                                    <th class="text-end">Total</th>
                                    <th></th>
                                </thead>
                                <tbody id="visit-details-modal-products-tbody">                                        
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td class="text-end fw-bolder" colspan="6">Total: </td>
                                        <td class="text-end fw-bolder" id="visit-details-modal-products-total"></td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
               </div>

               <div id="visit-detail-modal-main-panel" class="m-0"  style="display:none;">
                    <div id="overlaydiv" class="" style="position:absolute; z-index:10; width:100%; height:100%; background:rgba(255,255,255,0.7);">
                        <div class="overlay" style="position:relative; top:40%; left:45%;">
                            <div class="cv-spinner">
                                <span class="spinner spinner-border avatar-lg text-primary m-2"></span>
                            </div>
                        </div>
                    </div>
                    <div class="row">                    
                        <!--- LEFT BAR --->   
                        <div class="col-10  p-3" >  
                             <div class="row">
                                <div class="col-1 p-1"> 
                                    <input onchange="stricttimechanged();" type="checkbox" id="visit-details-strict-time" class = "form-check-input fs-16">
                                    <label class="form-label p-1" for="visit-details-strict-time">Strict <iconify-icon icon="material-symbols:access-time" class="fs-16"></iconify-icon></label>
                                </div>
                                <div class="col-1 p-1"> 
                                    <input onchange="reminderchanged('sms');" type="checkbox" id="visit-details-sms-reminder" class = "form-check-input fs-16">
                                    <label class="form-label p-1" for="visit-details-sms-reminder">SMS</label>
                                </div>
                                <div class="col-1 p-1"> 
                                    <input onchange="reminderchanged('call');" type="checkbox" id="visit-details-call-reminder" class = "form-check-input fs-16">
                                    <label class="form-label p-1" for="visit-details-call-reminder">Call</label>
                                </div>
                                <div class="col-2 p-1">                                     
                                    <select class="form-select" id="visit-details-assign-all-to-staff" aria-placeholder="Assign All to ...">
                                        <option></option>
                                    </select>    
                                </div>
                                <div class="col-1 me-auto"> 
                                    <button class="btn btn-sm btn-primary mt-2" id="visit-details-assign-all-to-btn" onclick="assign_all_to_staff();">Assign</button>
                                </div>                                
                                <div class="col-2 p-1"> 
                                    <input class="form-control flatpickr-date-input" id="visit-details-visit-start-date">
                                </div>
                                <div class="col-2 me-auto"> 
                                    <button class="btn btn-sm btn-primary mt-2" id="visit-details-check-in-btn" onclick="updateVisitDate();">Change</button>
                                </div>
                            </div>                                            
                            <div class="row" style="font-size: .753rem !important;" id="visit-details-table-div">
                                <table id="visit-details-table" class="table table-striped table-bordered border-light fs-13 h-100">
                                    <thead class="table-light text-white">
                                        <th></th>
                                        <th class="d-none">ID</th>
                                        <th class="d-none">Service ID</th>
                                        <th  class="d-none">Type</th>
                                        <th class="d-none" style=" width:150px;">Category</th>
                                        <th style="width:150px;">Service</th>
                                        <th>Staff</th>                                
                                        <th>Start</th>
                                        <th>End </th>
                                        <th></th>
                                        <th class="text-end">Price</th>
                                        <th>Req.</th>
                                        <th>Promo</th>
                                        <th>Dup.</th>
                                        <th></th>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td class="text-end fw-bolder" colspan="6">Before Tax: </td>
                                            <td class="text-end fw-bolder" id="total_price"></td>
                                            <td colspan="9" ></td>
                                        </tr>
                                    </tfoot>
                                </table>
                                <table id="visit-staff-table" class="table table-striped table-bordered border-light fs-13 h-100">
                                    <thead class="table-light text-white">
                                        <th></th>
                                        <th class="d-none">ID</th>
                                        <th class="d-none">Service ID</th>
                                        <th  class="d-none">Type</th>
                                        <th class="d-none" style=" width:150px;">Category</th>
                                        <th style="width:150px;">Service</th>
                                        <th >Visit Staff ID</th>
                                        <th style="width:150px;">Staff Name</th>          
                                        <th>Additional</th>                      
                                        <th class="text-end">Replace With?</th>                         
                                    </thead>
                                    <tbody>
                                    </tbody>
                                    
                                </table>
                            </div>                            
                            <div class="row mb-2" style="font-size: .753rem !important;" id="visit-details-discount-div">
                                <div class="row">
                                    <div class="col-2 text-end">
                                        <label class ="form-label  p-1" for="">Discount: </label>                                
                                    </div>
                                    <div class="col-4">                                    
                                        <select onchange="calculate_discount_apply();" class="form-select" id="visit-details-discount-reasons">  
                                            <option value="">Select Reason</option>                                      
                                        </select>                                        
                                    </div>
                                    <div class="col-2">
                                        <div class="input-group">
                                            <input id="visit-details-modal-discount-value" class="form-control " disabled="disabled" value="0.00">
                                            <button onclick="add_discount();" class="btn btn-secondary" type="button"><i class="ti ti-plus"></i></button>
                                        </div>
                                    </div>
                                    <div class="col-4 text-end">
                                        <button onclick="openAddServices();" class="btn btn-sm btn-primary"><i class="ti ti-shopping-bag-plus fs-20"></i>  Service</button>
                                    </div>
                                </div>
                            </div>   
                            <div class="row m-0" id="visit-details-customer-detail-div">
                                <div class="col-12 p-2 border-top border-light">                           
                                    <div class="row mt-2">
                                        <div class="col-1 mb-0">
                                            <label class="form-label">Add Extra:</label>
                                        </div>                              
                                        <div class="col-1 mb-0">
                                            <label class="form-label">Visit Color:</label>
                                        </div>   
                                        
                                        <div class="col-3 mb-0">
                                            <label class="form-label">Remarks:</label>
                                        </div>
                                        <div class="col-4 mb-0">
                                            <label class="form-label">Dispatch:</label>
                                        </div>    
                                    </div>
                                    <div class="row">                            
                                        <div class="col-1 pe-1">                                
                                            <div class="input-group">
                                                <input id="visit-details-visit-extra" class="form-control" type="text" name="extra" value="">
                                                <button onclick="addVisitExtra();" class="btn btn-primary p-1"><i class="ti ti-plus"></i></button>
                                            </div>                                
                                        </div>               
                                        <div class="col-1 pe-1">
                                            <div class="input-group">
                                                <input class="form-control" id="visit-details-visit-color" type="color" name="color" value="">
                                                <button onclick="changeVisitColor();" class="btn btn-md btn-secondary p-1"><i class="ti ti-plus"></i></button>
                                            </div>
                                        </div>                      
                                        <div class="col-3 pe-1">
                                            <div class="input-group">
                                                <textarea class="form-control" id="visit-details-visit-remarks" col=4 rows=1></textarea>                           
                                                <button onclick="add_remarks();" class="btn btn-md btn-warning p-1"><i class="ti ti-plus"></i></button>
                                            </div>                                
                                        </div>                                
                                        <div class="col-4 text-start">
                                            <button id="dispatch-request-button" class="btn btn-md btn-soft-dark p-1"><i class="ti ti-shopping-cart-cog fs-16"></i> Dispatch Request</button>
                                        </div> 
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--- MIDDLE BAR END--->   
                        <!-------RIGHT BAR ------->
                        <div class="col-2 border-start border-light p-1">                        
                            <div class="row mt-1 ">
                                <div class="col-12 ">
                                    <table class="table" cellpadding=2px; id="visit-details-adv-table" style="font-size: .753rem !important;">
                                        <tbody>                                        
                                        </tbody>
                                        <tfoot></tfoot>
                                    </table>
                                </div>
                            </div>
                            <div class="row mt-1" id="visit-details-add-advance-div">
                                <!----Add Advance ----> 
                                <div class="col-12">
                                    <h5>Add Advance:</h5>                                
                                </div>
                                <div class="row">
                                    <div class="col-4">Adv. Amount</div>
                                    <div class="col-8">
                                        <input onkeydown="checkAdvanceCCFee();" class="decimal form-control mb-1 decimal" id="visit-details-adv-amount">
                                    </div>
                                </div>
                                <div class="row d-none" id="div-cc-inst">
                                    <div class="col-4">Inst. #</div>
                                    <div class="col-8">
                                        <input class="form-control mb-1" id="visit-details-adv-cc-inst">
                                    </div>
                                </div>
                                <div class="row d-none" id="div-cc-fee">
                                    <div class="col-4">CC. Fee</div>
                                    <div class="col-8">
                                        <input data-fee-percent="0" class="decimal form-control mb-1 decimal" disabled id="visit-details-adv-ccfee">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-4 p-2">Mode</div>
                                    <div class="col-8">
                                        <select onchange="payment_mode_changed();" class="form-select mb-1" id="visit-details-adv-mode">
                                            <option>Cash</option>
                                            <option value="Card">C.Card</option>
                                            <option value="Card">D.Card</option>
                                            <option value="Check">Check</option>
                                            <option value="Online">Online</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-4">Adv. Comment</div>
                                    <div class="col-8">
                                        <input class="form-control mb-1" id="visit-details-adv-comment">
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col-8 text-end">
                                        <button id="btn-add-adv" onclick="add_advance();" class="btn btn-sm btn-soft-dark">Add Adv.</button>
                                    </div>
                                    <div class="col-4 me-auto">
                                        <a href="#" target="_blank" id="visit-details-modal-advance-receipt" class="btn btn-md btn-soft-dark"><i class="ti ti-printer fs-16"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 p-2 border-end border-light">
                                <div class="row">
                                    <h5 class="" id="visit-details-visit-status"></h5>
                                </div>
                                
                                <!--Vist Cancel Butons-->
                                <div id="visit-details-adv-cancel-btn-div" class="d-none">
                                    <div class="row mt-2">
                                        <div class="col-12 text-start">
                                            <button onclick="changeVisitStatus('cancelVisitKeepAdv');" class="btn btn-md btn btn-soft-danger p-1"><i class="ti ti-circle-letter-x fs-16"></i>  Cancel Visit Keep Adv.</button>
                                        </div>  
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-12 text-start">
                                            <button onclick="changeVisitStatus('cancelVisitReturnAdv');" class="btn btn-md btn btn-soft-danger p-1"><i class="ti ti-circle-letter-x fs-16"></i>  Cancel Visit Return Adv.</button>
                                        </div>  
                                    </div>
                                    <div class="row mt-2">
                                        <div class="col-12 text-start">
                                            <button onclick="changeVisitStatus('cancelVisitRetainAdv');" class="btn btn-md btn btn-soft-danger p-1"><i class="ti ti-circle-letter-x fs-16"></i>  Cancel Visit Retain Adv.</button>
                                        </div>  
                                    </div>                            
                                </div>
                                <div id="visit-details-visit-cancel-btn-div" >
                                    <div class="row mt-2">
                                        <div class="col-12 text-start">
                                            <button onclick="changeVisitStatus('cancelled');" class="btn btn-md btn btn-soft-danger p-1"><i class="ti ti-circle-letter-x fs-16"></i>  Cancel Visit</button>
                                        </div>  
                                    </div>
                                </div>
                                <!--Visit Cancel Buttons End-->
                            </div>
                        </div>                        
                    </div>   
                </div>  
                <!---Sliding Divs For Service Addition-->
                <div id="visit-detail-modal-add-service-panel" class="d-none" >
                    <div class="row text-right">
                        <div class="col-12">
                            <button type="button" onclick="slide_div_backwards('visit-detail-modal-add-service-panel');" class="btn btn-soft-dark btn-back"><i class="ti ti-arrow-left"></i> Back</button>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-4">                           
                             <div class="row">
                                <div class="col-6 cross-sell">
                                    <lable for="crosssell" class="form-label">Cross Selling by:</lable>
                                    <select id="crosssell" class="form-select crosssell">                                       
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-2">                    
                        <div class="col-3 border-end border-light">                            
                            <div class="list-group" id="visit-details-modal-service-types" >
                                <a href="#" class="list-group-item list-group-item-action active">
                                    Service Types
                                </a>
                                <input id="searchgetservicestypes" class="form-control servicetypesearch list-group-item" type="text" placeholder="Search . . ."/>
                                <div class="list" style="max-height:400px; min-height:400px; overflow-y:scroll;"></div>
                            </div>
                        </div>
                        
                        <div class="col-3  border-end border-light">
                             <div class="list-group" id="visit-details-modal-service-categories" >
                                <a href="#" class="list-group-item list-group-item-action active">
                                    Service Categories
                                </a>
                                <input id="searchgetservicescategories" class="form-control servicecategorysearch list-group-item" type="text" placeholder="Search . . ."/>
                                <div class="list" style="max-height:400px; min-height:400px; overflow-y:scroll;"></div>
                            </div>
                        </div>
                        <div class="col-3  border-end border-light">
                            <div id="visit-details-modal-services" class="list-group" >
                                <a href="#" class="list-group-item list-group-item-action active">
                                    Services
                                </a>
                                <input id="searchgetservices" class="form-control servicetypesearch list-group-item" type="text" placeholder="Search . . ."/>
                                <div class="list" style="max-height:400px; min-height:400px; overflow-y:scroll;"></div>
                            </div>
                        </div>
                        <div class="col-3">
                            <div id="TableSelectedServices" class="list-group" >
                                <a href="#" class="list-group-item list-group-item-action active">
                                    Selected Services
                                </a>                                
                                <div class="list" style="max-height:400px; min-height:400px; overflow-y:scroll;">
                                    <table class="table table-striped table-bordered border-light fs-13 h-100" id="visit-details-modal-selected-services-table">
                                        <thead class="table-soft-dark text-white">
                                            <th>Service</th>
                                            <th class="text-end">Price</th>
                                            <th></th>
                                        </thead>
                                        <tbody>                                        
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td class="text-end fw-bolder">Total: </td>
                                                <td class="text-end fw-bolder" id="visit-details-modal-selected-services-total"></td>
                                                <td></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>                        
                    </div>
                    <!---End Sliding Divs For Service Addition-->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" onclick="openConsentForms();" class="btn btn-outline-secondary btn-customer-on">Consent</button>        
                <button type="button" class="btn btn-outline-secondary me-4 btn-customer-on">Notes</button>   
                <button type="button" class="btn btn-outline-primary btn-customer-on">
                    <iconify-icon icon="mdi:paper-plane" class="fs-20 me-1"></iconify-icon>
                    SMS
                </button>
                <button type="button" onclick="openCustomerAccount();" class="btn btn-outline-success btn-customer-on" id="customer_open_account_id">
                    <iconify-icon icon="mdi:account" class="fs-20 me-1"></iconify-icon>
                    Customer Account
                </button>
                <button type="button" onclick="markInService();" id="visit-details-in-service-btn" class="btn btn-warning btn-visit-on">
                    <iconify-icon icon="mdi:tools" class="fs-20 me-1"></iconify-icon>
                    Mark In Service
                </button>
                <button type="button" onclick="create_service_invoice();" id="visit-details-generate-invoice-btn" class="btn btn-danger btn-visit-on">Generate Invoice</button>
                <button type="button" onclick="open_invoice();" id="visit-details-view-invoice-btn" data-id-invoice="" class="btn btn-success btn-visit-on">View Invoice</button>

                <button type="button" onclick="open_new_customer_modal();" id="visit-details-create-new-customer-btn" class="btn btn-dark btn-create-on"><i class="ti ti-plus fs-16"></i> Add New Customer</button>

                <button type="button" onclick="create_gift_voucher();" id="visit-details-create-voucher-btn" class="btn btn-warning btn-create-on">Create Voucher</button>
                <button type="button" onclick="create_order();" id="visit-details-create-order-btn" class="btn btn-info btn-create-on">Product Order</button>
                <button type="button" onclick="create_visit();" id="visit-details-create-visit-btn" class="btn btn-success btn-create-on">Create Visit</button>
                
                <button type="button" onclick="addServicesToVisits();" id="visit-details-add-services-btn" class="btn btn-danger btn-add-service-on">Add Services</button>
                
                <button type="button" class="btn btn-light btn-always-on" data-bs-dismiss="modal">Close</button>
                
                <select class="d-none" id="globalstafflist"></select>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

@section('scripts')
<script>
    const staffImageBase = "{{ asset('images/staff') }}/";
    const ImageBase = "{{ asset('images') }}/";
    let businessStartTime = "";
    let businessEndTime = "";
    

    $(document).ready(function() {
        
        //initialize product search select2
        $('#visit-details-modal-product-search').select2({
             width: '100%',
            dropdownParent: $('#visit-details-modal'),
            ajax: {
                url: '{{ route("products.search_products_instock") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term, // search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function (item) {
                            return {
                                id: item.id,
                                text: item.business_brand_name + ' ' + item.product + ' ' + (item.mcategory ? ' (Category: ' + item.mcategory + ')' : ''),
                                measure_unit: item.measure_unit,
                                qty_per_unit: item.qty_per_unit,
                                product: item.product,
                                brand: item.business_brand_name,
                                batch_id: item.batch_id,
                                batch_no: item.batch_no,
                                store: item.store,
                                price: item.price,
                                instock: item.instock
                            };
                        })
                    };
                },
                cache: true
            },
            minimumInputLength: 1,

            // Formatting should be outside the ajax block
            templateResult: function (item) {
                if (item.loading) return item.text;

                return $(
                    "<div class='d-flex justify-content-between'>" +
                        "<div class='col-md-6 d-flex justify-content-between'>" + item.text + "</div>" +
                        "<div class='col-md-6 me-auto text-end text-muted' style='font-size: 12px;'>" + (item.store ? item.store : '') + ' ' + (item.batch_id ? item.batch_id : '') + ' - ' + (item.qty_per_unit ? item.qty_per_unit : '') + ' ' + (item.measure_unit ? item.measure_unit : '') + ' - Remaining: ' + (item.instock ? parseFloat(item.instock).toFixed(2) : '') + "</div>" +
                    "</div>"
                );
            },

            templateSelection: function (item) {
                return item.text || item.id;
            },

            escapeMarkup: function (markup) {
                return markup;
            }
        });

        //get business start - end time once
        //function getBusinessHours(){
        $.ajax({
            url : "{{ route('get_business_hours') }}",
            type: "GET", // The GET method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                businessStartTime = data.start_time + ":00";
                businessEndTime = data.end_time + ":00";
                console.log("Business Hours: " + businessStartTime + " to " + businessEndTime);
            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }  
        });
        //}

        //get discount reasons
        $.ajax({
            url : "{{ route('get_discount_reasons') }}",
            type: "GET", // The GET method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                discount_list = data.discountList;
                var dhtml="";
                $.each(discount_list, function(index, item){
                    var discount = 0;
                    discount_text = item.fixed_amount > 0 ? "{{ config('constants.CURRENCY') }}" + item.fixed_amount : item.discount_perc+"%";
                    discount = item.fixed_amount > 0 ? item.fixed_amount :  parseFloat(item.discount_perc);
                    var discount_type = item.fixed_amount > 0 ? 'fixed' : 'percentage';
                    dhtml += '<option data-discount-type="' + discount_type + '" data-discount="'+discount+'" value="'+ item.id_discount_reasons +'" >' +item.discount_reason + ' ' + discount_text + '</option>';
                    
                });

                $("#visit-details-discount-reasons").append(dhtml);
            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

        ////initialize select2 for Customer Search
        $('#visit-details-new-visit-select-customer').select2({
            dropdownParent: $('#visit-details-modal'),
            placeholder: 'Select Customer',
            minimumInputLength: 3,
            ajax: {
                url: '{{ route("customer_search") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return { term: params.term };
                },
                transport: function (params, success, failure) {
                    let $select = $('#visit-details-new-visit-select-customer');
                    $.ajax(params).then(function (data) {
                        success(data);

                        // Executed AFTER results loaded
                        setTimeout(() => {
                            let select2 = $select.data('select2');
                            let $first = select2.$results.find('.select2-results__option:first');
                            if ($first.length) {
                                $first.addClass('select2-results__option--highlighted');
                            }
                        }, 500);
                    }, failure);
                },
                processResults: function (data) {
                    return {
                        results: data.map(function(item){
                            return {
                                id: item.id,
                                text: item.customer_name || (item.customer_name + ' (' + item.customer_cell + ')'),
                                customer_name: item.customer_name,
                                customer_cell: item.customer_cell,
                                customer_type: item.customer_type // <- make sure server sends this
                            };
                        })
                    };
                },
                cache: true
            },
            templateResult: formatCustomer,      // dropdown items
            templateSelection: formatCustomerSel // selected item
        });

        function formatCustomer(customer) {
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }

            var type = (customer.customer_type || '').toString().toLowerCase();
            var iconClass = 'ti-user fs-4 text-secondary';
            var nameClass = '';

            if (type === 'orange' || type === '1') {
                iconClass = 'ti-star fs-4 text-warning';
                nameClass = 'text-warning';
            } else if (type === 'green' || type === '2') {
                iconClass = 'ti-flag fs-4 text-success';
                nameClass = 'text-success';
            } else if (type === 'red' || type === '3') {
                iconClass = 'ti-flag-question fs-4 text-danger';
            }

            var nameEsc = $('<div/>').text(customer.customer_name || customer.text || '').html();
            var cellEsc = $('<div/>').text(customer.customer_cell || '').html();

            var $node = $(`
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="fw-bold ${nameClass}">${nameEsc}</div>
                        <div class="small">${cellEsc}</div>
                    </div>
                    <i class="ti ${iconClass} ms-2" aria-hidden="true"></i>
                </div>
            `);

            //important: return plain DOM node, not jQuery object
            return $node[0];
        }

        function formatCustomerSel(customer) {
            if (!customer || !customer.id) {
                return customer && customer.text ? customer.text : '';
            }
            var name = customer.customer_name || customer.text;
            var cell = customer.customer_cell ? ' (' + customer.customer_cell + ')' : '';
            // return a simple node — keep selection compact
            return $('<span>').text(name + cell);
        }

        $('#visit-details-new-visit-select-customer')
            .on('select2:open', function () {

                // Select2 creates the search input only AFTER open
                const searchInput = document.querySelector(
                    '.select2-container--open .select2-search__field'
                );

                if (!searchInput) return;

                searchInput.addEventListener('input', function () {
                    $('#temp_customer_search_value').val(this.value);
                });
            });

        let staff_list = JSON.parse(localStorage.getItem('staffList') || '[]');
        var ohtml = '';
        if(staff_list){
            if(staff_list.length > 0){
                $.each(staff_list, function(index, item){
                    ohtml += '<option value="'+ item.id_staff +'" data-image="'+ item.staff_image +'">' +
                                item.staff_fullname +
                            '</option>';
                });
                
                $('#visit-details-new-visit-selected-staff').html(ohtml);

                $('#visit-details-new-visit-selected-staff').select2({
                    dropdownParent: $('#visit-details-modal'),
                    templateResult: formatStaff,
                    templateSelection: formatStaff
                });
            }
        }
       
        document.getElementById('visit-details-modal')
            .addEventListener('show.bs.modal', function (event) {
                const zIndex = 1040 + (10 * $('.modal:visible').length);
                $(this).css('z-index', zIndex);
                setTimeout(() => {
                    $('.modal-backdrop').not('.modal-stack')
                        .css('z-index', zIndex - 1)
                        .addClass('modal-stack');
                }, 0);

                var vd = new Date();
                if (vd.getHours() > parseInt(businessEndTime.split(":")[0], 10)) {
                    vd.setDate(vd.getDate() + 1); // next day                    
                    vd.setHours(parseInt(businessStartTime.split(":")[0], 10));
                    vd.setMinutes(parseInt(businessStartTime.split(":")[1], 10) + 15);
                    vd.setSeconds(parseInt(businessStartTime.split(":")[2], 10));
                } else if (vd.getHours() < parseInt(businessStartTime.split(":")[0], 10)) {
                    //same day but after business start time
                    vd.setHours(parseInt(businessStartTime.split(":")[0], 10));
                    vd.setMinutes(parseInt(businessStartTime.split(":")[1], 10) + 15);
                    vd.setSeconds(parseInt(businessStartTime.split(":")[2], 10));
                }

                ///initialize flatpickr                
                if($("#visit-details-new-visit-date").val() != ""){
                    flatpickr(".visit-date-time", {
                        enableTime: true,
                        dateFormat: "Y-m-d H:i:S",
                        minTime: businessStartTime,
                        maxTime: businessEndTime,
                        minuteIncrement: 1,    // still needed
                        secondIncrement: 15,    // 👈 works in newer versions
                        time_24hr: true,
                        defaultDate: $("#visit-details-new-visit-date").val(),
                    });
                } else {
                    flatpickr(".visit-date-time", {
                        enableTime: true,
                        dateFormat: "Y-m-d H:i:S",
                        minTime: businessStartTime,
                        maxTime: businessEndTime,
                        minuteIncrement: 1,    // still needed
                        secondIncrement: 15,    // 👈 works in newer versions
                        time_24hr: true,
                        defaultDate: vd,
                    });
                }

                if($("#visit-details-id-customer-visits").html() != ""){ 
                    //visit created viewing details
                  
                    // $('#visit-detail-modal-select-customer-panel').hide();
                    document.getElementById('visit-detail-modal-select-customer-panel').classList.add('d-none');
                    document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');
                    document.getElementById('visit-details-customer-notification-div').classList.add('d-none');
                    document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
                    document.getElementById('visit-detail-modal-gift-voucher-panel').classList.add('d-none');
                    
                    $('#visit-detail-modal-main-panel').show();
                    //Handle button visibilities
                    $(".btn-visit-on").removeClass("d-none");                   
                    $(".btn-customer-on").removeClass("d-none");
                    $(".btn-add-service-on").addClass("d-none");
                    $(".btn-create-on").addClass("d-none");
                    
                } else if($("#visit-details-customer-name").html() != "" && $("#visit-details-id-customer-visits").html() == ""){ 
                    //customer selected but visit not created                    
                    

                    document.getElementById('visit-detail-modal-select-customer-panel').classList.remove('d-none');
                    document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');                    
                    document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
                    document.getElementById('visit-details-customer-notification-div').classList.add('d-none');
                    document.getElementById('visit-detail-modal-gift-voucher-panel').classList.add('d-none');
                    $('#visit-detail-modal-main-panel').hide();
                    //Handle button visibilities
                    $(".btn-visit-on").addClass("d-none");
                    $(".btn-customer-on").removeClass("d-none");
                    $(".btn-add-service-on").addClass("d-none");
                    $(".btn-create-on").removeClass("d-none");
                     document.getElementById("visit-details-create-visit-btn").textContent = "Create Visit";
                } else { //new visit
                    //show the customer-panel-extras-replacement
                   

                    //Select customer view                   
                    document.getElementById('visit-detail-modal-select-customer-panel').classList.remove('d-none');                    
                    document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');                                 
                    document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');                   
                    document.getElementById('visit-details-customer-notification-div').classList.add('d-none'); 
                    document.getElementById('visit-detail-modal-gift-voucher-panel').classList.add('d-none');
                    $('#visit-detail-modal-main-panel').hide();
                    //Handle button visibilities
                    $(".btn-visit-on").addClass("d-none");
                    $(".btn-customer-on").addClass("d-none");
                    $(".btn-add-service-on").addClass("d-none");
                    $(".btn-create-on").removeClass("d-none");
                     document.getElementById("visit-details-create-visit-btn").textContent = "Create Visit";
                }
               
                
                $("#overlaydiv").removeClass("d-none").delay(2000);
                getvisitdetails();
                getserviceslist();
        });

        document.getElementById('dispatch-request-button')
        .addEventListener('click', function (event) {
            var id_visit = $("#visit-details-id-customer-visits").html();  
            if(id_visit != "" && id_visit != null){
                var url = "{{ route('dispatch_request.visit_dispatch_request', ['id_visit' => ':id']) }}";
                url = url.replace(':id', id_visit);

                fetch(url, {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json",
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr('content')
                    },
                    body: JSON.stringify({ id_visit: id_visit })
                })
                .then(response => response.json())
                .then(data => {
                    if(data.message_type === "success"){
                        Swal.fire({
                            text: data.message,
                            icon: "success",
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: data.message_button
                            }
                        });
                    } else {
                        Swal.fire({
                            text: data.message,
                            icon: "error",
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });
                    }
                })
                .catch((error) => {
                    console.error("Error:", error);
                });
            }
        });
            
    });

    document.getElementById('visit-details-modal')
            .addEventListener('shown.bs.modal', function (event) { 
                // Set focus to select customer when modal is shown
                let visit_button = document.getElementById('visit-details-new-visit-select-customer');
                //if the create visit button does not have d-none class, set focus to select customer
                if(!document.getElementById('visit-details-create-visit-btn').classList.contains('d-none')){  
                    console.log("Focusing on select customer");                
                    setTimeout(function() {
                        $('#visit-details-new-visit-select-customer').select2('open');
                    }, 500); // Adjust the timeout as needed
                }else{
                    visit_button.blur();
                }
            });

     document.getElementById('visit-details-modal')
            .addEventListener('hidden.bs.modal', function (event) {

                // Clear previous data
                $("#visit-details-id-customer-visits").html("");
                $("#visit-details-id-customers").html("");
                $("#visit-details-customer-cell").html(""); 
                $("#visit-details-customer-name").html("");
                $("#visit-details-visit-status").html("");
                $("#visit-details-visit-status-header").html("");
                $("#visit-details-visit-remarks").val("");

                $("#visit-details-table tbody").html("");
                $("#total_price").html("0.00");

                $("#visit-details-adv-table tbody").html("");
                $("#visit-details-adv-table tfoot").html("");

                $("#visit-details-adv-amount").val("0.00");
                $("#visit-details-adv-ccfee").val("0.00");
                $("#visit-details-adv-cc-inst").val("");
                $("#visit-details-adv-mode").val("Cash");
                $("#visit-details-adv-comment").val("");

                $("#visit-details-visit-extra").val("");
                
                $("#visit-details-visit-start-date").val("");
                
                $("#visit-details-customer-notification").html("");

                $("#visit-details-product-search").val(null).trigger('change');
                $("#visit-details-product-quantity").val("1");
                $("#visit-details-modal-product-id").val("0.00");
                $("#visit-details-product-discount").val("0.00");
                $("#visit-details-product-total").val("0.00");

                //reset the create buttons to normal
                document.getElementById("visit-details-create-visit-btn").textContent = "Create Visit";
                document.getElementById("visit-details-create-order-btn").textContent = "Product Order";
                document.getElementById("visit-details-create-voucher-btn").textContent = "Create Voucher";

                //Reset cancel buttons
                $("#visit-details-adv-cancel-btn-div").addClass("d-none");
                $("#visit-details-visit-cancel-btn-div").removeClass("d-none");

                // $("#visit-details-customer-notification-div").hide();
                document.getElementById('visit-details-customer-notification-div').classList.add('d-none'); 
                $("#visit-details-strict-time").prop('checked', false);
                $("#visit-details-sms-reminder").prop('checked', false);
                $("#visit-details-call-reminder").prop('checked', false);
                $("#visit-details-email-reminder").prop('checked', false);
                $("#visit-details-balance-div").addClass("d-none");
                $("#visit-details-recovery-btn-div").html("");                
                
                $('#visit-details-discount-reasons')
                .prop('selectedIndex', 0)
                .trigger('change');
                $("#visit-details-modal-discount-value").val("0.00");

                //Hide all buttons
                $(".btn-visit-on").addClass("d-none");
                $(".btn-customer-on").addClass("d-none");
                $(".btn-add-service-on").addClass("d-none");
                $(".btn-create-on").addClass("d-none");
                //Clear select2 customer selection
                $('#visit-details-new-visit-select-customer').val(null).trigger('change');

                $("#overlaydiv").removeClass("d-none").delay(2000);

                $(".btn-back").removeClass('d-none');
                $(".cross-sell").removeClass('d-none');
                //Hide all sliding divs  
                document.getElementById('visit-details-customer-notification-div').classList.add('d-none');  
                document.getElementById('visit-detail-modal-select-customer-panel').classList.add('d-none');
                document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');
                document.getElementById('visit-detail-modal-gift-voucher-panel').classList.add('d-none');
                document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
                $('#visit-detail-modal-main-panel').hide();

                // Show the customer-panel-extras
                console.log("Hiding customer panel extras on modal close");
                 //hide the customer-panel-extras-replacement
                document.getElementsByClassName('customer-panel-extras-replacement')[0].classList.remove('d-none');
                //Hide all the customer-panel-extras
                var extras = document.getElementsByClassName('customer-panel-extras');
                for (var i = 0; i < extras.length; i++) {
                    extras[i].classList.add('d-none');
                }

                //Reset Gift Voucher Fields
                $("#visit-details-modal-gift-voucher-paid").val("0.00");
                $("#visit-details-modal-gift-voucher-tax").val("0.00");
                $("#visit-details-modal-gift-voucher-cc-fee").val("0.00");
                $("#visit-details-modal-gift-voucher-amount").val("0.00");
                $("#visit-details-modal-gift-voucher-payment-mode").val("Cash");
                $("#visit-details-modal-gift-voucher-instrument-number").val("");

                // Clear selected services table
                $("#visit-details-modal-selected-services-table tbody").html("");
                $("#visit-details-modal-selected-services-total").html("0.00");
                //Hide service list items
                $(".checkservice").prop('checked', false);
                var extras = document.getElementsByClassName("id-business-services-item");
                for (var i = 0; i < extras.length; i++) {
                    extras[i].classList.add('d-none');
                }
                var extras = document.getElementsByClassName("id-service-category-item");
                for (var i = 0; i < extras.length; i++) {
                    extras[i].classList.add('d-none');
                }

                $("#visit-details-assign-all-to-btn").prop('disabled', false);
                $("#visit-details-check-in-btn").prop('disabled', false);
                $(".visit-services-time-btn").prop('disabled', false);
                $(".form-select").prop('disabled', false);                        
                $(".select2").prop('disabled', false);
                

    });          

    function getvisitdetails(){
            ////console.log($("#visit-details-assign-all-to-staff option").length);
            let getstaff = true;
            if ($("#visit-details-assign-all-to-staff option").length > 1) {
                getstaff = false;
            } 
            let getdiscounts = true;
            if ($("#visit-details-discount-reasons option").length > 1) {        
                getdiscounts = false;
            }


            $.ajax({
                url : "{{ route('visitdetaildata') }}",
                data: { "id_customer_visits" : $("#visit-details-id-customer-visits").html(), "getstaff" : getstaff, "getdiscounts" : getdiscounts },
                type: "GET", // The HTTP method
                dataType: "json", // Expected data type of the response
                success: function(data) {
                    let visit = data.visit;
                    let visit_services = data.servicesWithStaff;
                    let staff_list = data.staffList;
                    let visit_advance = data.visitAdvance;
                    let discount_list = data.discountList;
                    let recoveries = data.recoveries;

                    if(staff_list){
                        if(staff_list.length > 0){
                            localStorage.setItem('staffList', JSON.stringify(staff_list));
                        }
                    }
                    //if data.visit is null, show error and return
                    if(visit == null){
                        return;
                    }

                    // Handle the successful response data
                    ////console.log("Data received:", data);
                    
                    $("#visit-details-id-customer-visits").html(visit.id_customer_visits);
                    $("#visit-details-id-customers").html(visit.customer_id);
                    $("#visit-details-customer-cell").html(visit.customer_cell); // Update a part of the page
                    $("#visit-details-customer-name").html(visit.customer_name);
                    $("#visit-details-visit-status").html(visit.visit_status);
                    $("#visit-details-visit-status-header").html(visit.visit_status);
                    $("#visit-details-visit-remarks").val(visit.advance_comment);
                    //let baseURL = "{{ url('advance_receipt') }}";
                    let href = baseURL + '/advance_receipt/' + visit.id_customer_visits;
                    $("#visit-details-modal-advance-receipt").attr("href", href);
                    $("#visit-details-modal-advance-receipt").attr("target", "advance");

                    $("#visit-details-adv-ccfee").attr("data-fee-percent", visit.cc_charge);

                    visit.visit_status == "open" ? $("#visit-details-customer-detail-div").removeClass("d-none") : $("#visit-details-customer-detail-div").addClass("d-none");
                    visit.visit_status == "open" ? $("#visit-details-add-advance-div").removeClass("d-none") : $("#visit-details-add-advance-div").addClass("d-none");
                    visit.visit_status == "open" ? $("#visit-details-discount-div").removeClass("d-none") : $("#visit-details-discount-div").addClass("d-none");
                    // visit.visit_status == "open" ? $("#visit-details-table-div").css("min-height", "250px") : $("#visit-details-table-div").css("min-height", "0px");
                    visit.visit_status == "open" ? $("#visit-details-generate-invoice-btn").removeClass("d-none") : $("#visit-details-generate-invoice-btn").addClass("d-none");
                    visit.visit_status == "invoiced" ? $("#visit-details-view-invoice-btn").removeClass('d-none') : $("#visit-details-view-invoice-btn").addClass('d-none');
                    visit.visit_status == "open" ? $("#visit-details-in-service-btn").removeClass("d-none") : $("#visit-details-in-service-btn").addClass("d-none")

                    if(visit.visit_status == "invoiced" && visit.id_invoice != null){
                        $("#visit-details-view-invoice-btn").attr('data-id-invoice', visit.id_invoice);
                    }

                    visit.visit_status == "open" ? $("#visit-details-visit-cancel-btn-div").removeClass('d-none') : $("#visit-details-visit-cancel-btn-div").addClass('d-none');
                    visit.visit_status == "cancelled" ?? $("#visit-details-visit-cancel-btn-div").addClass('d-none');
                    visit.visit_status == "invoiced" ?? $("#visit-details-visit-cancel-btn-div").addClass('d-none');      
                    
                    
                    

                    if(visit_advance.length > 0){
                        $("#visit-details-adv-cancel-btn-div").removeClass('d-none'); 
                        $("#visit-details-visit-cancel-btn-div").addClass('d-none'); 
                    } else {
                        $("#visit-details-adv-cancel-btn-div").addClass('d-none'); 
                        if(visit.visit_status == "open"){
                            $("#visit-details-visit-cancel-btn-div").removeClass('d-none'); 
                        
                        } else {
                            $("#visit-details-visit-cancel-btn-div").addClass('d-none');
                        }
                    }

                    var checkin ="";
                    $.each(visit_services, function(index, service){
                        if(checkin==""){checkin=service.checkin;}
                    });
                    ////console.log(checkin);
                    $("#visit-details-visit-start-date").val(visit_services[0].checkin);
                    
                    visit.reminder_stricttime == "Y" ? $("#visit-details-strict-time").prop('checked', true) : $("#visit-details-strict-time").prop('checked', false) ;

                    visit.reminder_sms == "Y" ? $("#visit-details-sms-reminder").prop('checked', true) : $("#visit-details-sms-reminder").prop('checked', false) ;
                    visit.reminder_call == "Y" ? $("#visit-details-call-reminder").prop('checked', true) : $("#visit-details-call-reminder").prop('checked', false) ;
                    visit.reminder_email == "Y" ? $("#visit-details-email-reminder").prop('checked', true) : $("#visit-details-email-reminder").prop('checked', false) ;

                    $(".modal-content").css("style", "border-radius: 2px"); 
                    $(".modal-content").css("style", "border-top: 6px solid "+ visit.visit_color);

                    var border = '6px solid '+visit.visit_color;
                    ////console.log(border);
                    $("#visit-details-modal .modal-content").css('border-top', border);
                    $("#visit-details-modal .modal-content").css('border-bottom', border);

                    if(visit.customer_alert != "" || visit.customer_allergies != ""){
                        $("#visit-details-customer-notification").html(visit.customer_alert + '<br>' + visit.customer_allergies);
                        $("#visit-details-customer-notification-div").show();
                        document.getElementById('visit-details-customer-notification-div').classList.remove('d-none'); 
                    } else {
                        $("#visit-details-customer-notification").html("");
                        document.getElementById('visit-details-customer-notification-div').innerHTML = ""; 
                    }

                    var mhtml = ""; var total=0;
                
                    for(x=0; x<=visit_services.length -1; x++){
                    
                        //check if visit date is in future
                    
                        if(visit_services[x].futurevisit == "future"){
                            
                            $("#visit-details-generate-invoice-btn").addClass("d-none");
                            $("#visit-details-in-service-btn").addClass("d-none");
                        }

                        mhtml += "<tr>";
                        if(visit.visit_status == "open"){
                            mhtml += '<td><i onclick="cancelService('+visit_services[x].id_visit_services+')" class="ri ri-delete-bin-line text-danger" style="cursor:pointer;"></i></td>';
                        }else{
                            mhtml += '<td><i class="ri ri-check-line text-success"></i></td>';
                        }
                        mhtml += '<td class="d-none">' + visit_services[x].id_visit_services + '</td>';                    
                        mhtml += '<td class="d-none">' + visit_services[x].service_id  + '</td>';                     
                        mhtml += '<td class="d-none">' + visit_services[x].s_type + '</td>';
                        mhtml += '<td class="d-none">' + visit_services[x].s_category + '</td>';
                        mhtml += "<td>" + visit_services[x].s_category +' | '+ visit_services[x].service_name + "</td>";
                        
                        mhtml += '<td>'; 
                        if(visit.visit_status == "open" || visit.invoiced_drag == "No"){
                        
                            mhtml += '<select id="visit-detail-modal-staff_' + visit_services[x].id_visit_services + '" onchange="assign_visit_service_staff('+ visit_services[x].id_visit_services +')" class="select2 text-left select2-multiple visit-detail-modal-staff choices__input p-0"  data-choices data-choices-removeitem data-toggle="select2" multiple="multiple" style="padding:0px !important; line-height:1.5px; font-size:11px; border: none !important; max-width: 50px !important; display:inline-block;" >';
                                let service_staff = visit_services[x].staff; 
                                //console.log(service_staff);
                                var selected = ""; var requested_checked = "";
                                let staff_list = JSON.parse(localStorage.getItem('staffList') || '[]');

                                ////console.log(staff_list);
                                requested_checked= '';
                                for(y=0; y <= staff_list.length -1; y++){                      
                                    selected=''; 
                                    $.each(service_staff, function(index, item) {
                                        {
                                            if(item.staff_id ==staff_list[y].id_staff){
                                                selected = ' selected="selected" ';
                                                
                                                if(item.requested == "Yes"){
                                                // //console.log(item.requested);
                                                    requested_checked = ' checked="checked" ';
                                                    ////console.log(requested_checked);
                                                }
                                            } 
                                        }
                                    });
                                    mhtml += '<option ' + selected + ' value="'+ staff_list[y].id_staff +'" data-image="'+ staff_list[y].staff_image +'">'+staff_list[y].staff_fullname +'</option>'; 
                                }
                            mhtml += '</select></td>';

                            mhtml += '<td><input id="vs_start_time_'+visit_services[x].id_visit_services+'" onchange="service_time_changed('+visit_services[x].id_visit_services+');" class="form-control flatpickr-time-input" style="border:none; line-height:1.5px; font-size:11px; border-radius:2px; width:80px; display:inline-block;" value="'+ visit_services[x].service_start +'" ></td>';
                            mhtml += '<td><input id="vs_end_time_'+visit_services[x].id_visit_services+'" onchange="service_time_changed('+visit_services[x].id_visit_services+');" class="form-control flatpickr-time-input" style="border:none; line-height:1.5px; font-size:11px; border-radius:2px; width:80px; display:inline-block;" value="'+ visit_services[x].service_end +'" ></td>';
                            mhtml += '<td><button id="visit-services-time-btn_'+visit_services[x].id_visit_services+'" onclick="update_visit_service_time('+visit_services[x].id_visit_services+')" class="visit-services-time-btn btn btn-sm btn-secondary"  style="line-height:1.5px; font-size:12px; border-radius:2px; padding:5px;  display:inline-block;"><i class="ti ti-pencil"></i></button></td>';

                            mhtml += '<td class="text-end">' + visit_services[x].s_rate + '</td>';
                                total = total + parseFloat(visit_services[x].s_rate);
                                //console.log(requested_checked);
                            mhtml += '<td><input onclick="updateStaffReq('+visit_services[x].id_visit_services+')" id="visit-details-staff-req_'+visit_services[x].id_visit_services+'" class="form-check-input" type="checkbox" ' + requested_checked + ' ></td>';
                            var promo_checked="";
                            promo_checked = visit_services[x].promo == "Yes" ?  ' checked="checked" ' : "";
                            mhtml += '<td><input onclick="updateServicePromo('+visit_services[x].id_visit_services+')" id="visit-details-service-promo_'+visit_services[x].id_visit_services+'" class="form-check-input" type="checkbox" ' + promo_checked + ' ></td>';
                            if(visit.visit_status == "open"){
                            mhtml += '<td><button onclick="duplicate('+visit_services[x].id_visit_services+');" class="btn btn-sm btn-secondary" style="line-height:1.5px; font-size:12px; border-radius:2px;  padding:5px; display:inline-block;"><i class="ti ti-refresh"></i></td>';
                            } else {
                            mhtml += '<td><button class="btn btn-sm btn-secondary" style="line-height:1.5px; font-size:12px; border-radius:2px;  padding:5px; display:inline-block;" disabled><i class="ti ti-refresh"></i></td>';
                            }
                            mhtml += '<td><button onclick="show_staff_replace_div('+visit_services[x].id_visit_services+');" class="btn btn-sm btn-secondary" style="line-height:1.5px; font-size:12px; border-radius:2px;  padding:5px; display:inline-block;"><i class="ti ti-player-track-next"></i></td>';
                            mhtml += "</tr>";
                        } else {
                            mhtml += '<td colspan="3">';
                            mhtml += '</td>';
                            mhtml +="</tr>";

                            let service_staff = visit_services[x].staff; 
                            let staff_list = JSON.parse(localStorage.getItem('staffList') || '[]');
                            //create a new table row for each staff assigned
                            $.each(service_staff, function(index, item) {

                                mhtml += "<tr>";
                                mhtml += '<td></td>';
                                mhtml += '<td class="d-none">' + visit_services[x].id_visit_services + '</td>';
                                mhtml += '<td class="d-none">' + visit_services[x].service_id  + '</td>';
                                mhtml += '<td class="d-none">' + visit_services[x].s_type + '</td>';
                                mhtml += '<td class="d-none">' + visit_services[x].s_category + '</td>';
                                mhtml += "<td></td>";     
                                mhtml += '<td >' + item.id_visit_service_staffs + '</td>';                          
                                mhtml += '<td>' + item.staff_name + '</td>';
                                mhtml += '<td>' + item.additional_staff + '</td>';
                                mhtml += '<td>';
                                mhtml += '<select id="visit-detail-modal-staff_' + item.id_visit_service_staffs + '" onchange="replace_invoiced_staff('+ item.id_visit_service_staffs +')" class="select2 text-left visit-detail-modal-staff p-0" style="padding:0px !important; line-height:1.5px; font-size:11px; border: none !important; max-width: 50px !important; display:inline-block;" >';
                                $.each(staff_list, function(index, item) {
                                    mhtml += '<option  value="'+ item.id_staff +'" data-image="'+ item.staff_image +'">'+item.staff_fullname +'</option>'; 
                                });
                                mhtml += '</select></td>';
                                
                                mhtml += '</tr>';
                            });

                        }
                    }
                    $("#total_price").html(total);

                    if(visit.visit_status == "open" || visit.invoiced_drag == "No"){
                        $("#visit-details-table tbody").html(mhtml);
                        $("#visit-details-table").css("display", "table");
                        $("#visit-staff-table").css("display", "none");
                    } else {
                        $("#visit-staff-table tbody").html(mhtml);
                        $("#visit-staff-table").css("display", "table");
                        $("#visit-details-table").css("display", "none");
                        
                    }
                   

                    $(".visit-detail-modal-staff").select2({
                        width: '150px',
                        templateResult: formatStaff,
                        templateSelection: formatStaff
                    });

                    flatpickr(".flatpickr-time-input", {
                        enableTime: true,
                        noCalendar: true,
                        dateFormat: "H:i",
                        time_24hr: true,
                        minuteIncrement: 15,
                        minTime: "{{ $business->business_opening_time }}",
                        maxTime: "{{ $business->business_closing_time }}",
                    });

                    flatpickr(".flatpickr-date-input", {
                        enableTime: false,
                        noCalendar: false,
                        dateFormat: "Y-m-d"
                    });

                    var ohtml = "";


                    $.each(staff_list, function(index, item){
                        ohtml += '<option value="'+ item.id_staff +'" data-image="'+ item.staff_image +'">' +
                            item.staff_fullname +
                        '</option>';
                    });

                    $("#visit-details-assign-all-to-staff").append(ohtml);
                   
                    $('#visit-details-assign-all-to-staff').select2({
                        dropdownParent: $('#visit-details-modal'),
                        templateResult: formatStaff,
                        templateSelection: formatStaff,
                        placeholder: 'Assign All to ...',
                    });

                    
                    var dhtml="";
                    $.each(discount_list, function(index, item){
                        var discount = 0;
                        discount_text = item.fixed_amount > 0 ? "{{ config('constants.CURRENCY') }}" + item.fixed_amount : item.discount_perc+" %";
                        discount = item.fixed_amount > 0 ? item.fixed_amount : parseFloat(item.discount_perc);
                        var discount_type = item.fixed_amount > 0 ? 'fixed' : 'percentage';
                        dhtml += '<option data-discount-type="' + discount_type + '" data-discount="'+discount+'" value="'+ item.id_discount_reasons +'" >' +item.discount_reason + ' - ' + discount_text + '</option>';
                        
                    });

                    $("#visit-details-discount-reasons").append(dhtml);
                    $('#visit-details-discount-reasons').select2({
                        dropdownParent: $('#visit-details-modal'),
                    });

                    $('#visit-details-discount-reasons option')
                        .filter(function() {
                            return $(this).text() === visit.discount_reason;
                        })
                        .prop("selected", true)
                        .trigger("change");

                    

                    ///Advance table
                    var advhtml="<tr><th colspan=3>Advance</th></tr>"; var total_adv =0;
                    $.each(visit_advance, function(index, adv){
                        var advClass = adv.advance_status == "Cancelled" ? 'Class="strike-through"' : '';
                        advhtml += '<tr ' + advClass + '>';
                        
                        advhtml += '<td>' + adv.formatted_advance_date + '</td>';
                        advhtml += '<td>' + adv.advance_amount + '</td>';
                        total_adv= adv.advance_status == "Active" ? total_adv + parseFloat(adv.advance_amount) : total_adv;
                        advhtml += '<td><i onclick="remove_advance('+adv.id_visit_advance+');" class="ti ti-circle-letter-x text-danger fs-16" style="cursor:pointer;"></i></td>';
                        advhtml += '</tr>';
                    });

                    $("#visit-details-adv-table tbody").html(advhtml);
                    var advfoothtml = '<tr><th class="border-top border-light" colspan=2>Total Adv.</th><th class="border-top border-light" colspan=2>' + total_adv + '<th><tr>';
                    $("#visit-details-adv-table tfoot").html(advfoothtml);

                    ///set color
                    $("#visit-details-visit-color").val(visit.visit_color);
                    $("#visit-details-visit-extra").val(visit.visit_extra);


                    //Recovery Invoice Buttons
                    var bhtml="";
                    $("#visit-details-recovery-btn-div").html();
                    if(recoveries.length > 0){
                        $("#visit-details-balance-div").removeClass('d-none');                        
                    } else { 
                        $("#visit-details-balance-div").addClass('d-none');                        
                    }

                    $.each(recoveries, function(index, invoice){
                        bhtml += '<button class="btn btn-soft-danger me-1" onclick="open_new_recovery_invoice(' + invoice.id_invoice+ ')" data-id-invoice = ' + invoice.id_invoice + '>' + invoice.balance + '</button>';
                    });
                    $("#visit-details-recovery-btn-div").html(bhtml);
                    

                    if(visit.visit_status == 'invoiced'){
                        $("#visit-details-assign-all-to-btn").prop('disabled', true);
                        $("#visit-details-check-in-btn").prop('disabled', true);
                        $(".visit-services-time-btn").prop('disabled', true);
                        //disable all select2 elements
                        $(".form-select").prop('disabled', true);

                        if(visit.invoiced_drag == "No"){
                            $(".select2").prop('disabled', true);
                        } else {
                            $(".select2").prop('disabled', false);
                        }
                    }else{
                        $("#visit-details-assign-all-to-btn").prop('disabled', false);
                        $("#visit-details-check-in-btn").prop('disabled', false);
                        $(".visit-services-time-btn").prop('disabled', false);
                        $(".form-select").prop('disabled', false);                        
                        $(".select2").prop('disabled', false);
                    }

                    document.getElementById('visit-details-generate-invoice-btn').disabled=false;

                    $("#overlaydiv").addClass("d-none").delay(2000);
                },
                error: function(xhr, status, error) {
                    // Handle errors
                    console.error("AJAX Error:", status, error);
                }
            });
    }
    
    function formatStaff (option) {
       if (!option.id) {
            return option.text;
        }

        var imgSrc = staffImageBase + $(option.element).data('image');
        return $('<span><img src="'+ imgSrc +'" class="avatar-sm rounded-circle me-2" /> ' + option.text + '</span>');
    }

    function open_new_recovery_invoice(id_invoice){
        let url = "new_recovery_invoice";
        window.open(url+ "/" +id_invoice, "invoice" );
    }

    function markInService(){
        document.getElementById("visit-details-in-service-btn").disabled = true;

        if($("#visit-details-id-customer-visits").html() == ""){
            return false;   
        }

        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : $("#visit-details-id-customer-visits").html(), "mark_in_service" : 1 },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                document.getElementById("visit-details-in-service-btn").disabled = false;
                //console.log(data);
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                
               
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                document.getElementById("visit-details-in-service-btn").disabled = false;
                console.error("AJAX Error:", status, error);
            }
        });
    }

    function assign_all_to_staff(){

        if($("#visit-details-assign-all-to-staff").val() == "" || $("#visit-details-assign-all-to-staff").val()  < 1){
            return false;   
        }

        id_visit = $("#visit-details-id-customer-visits").html();
        visit_status = $('#visit-details-visit-status').html();
        //disable btn
        document.getElementById("visit-details-assign-all-to-btn").disabled = true;

        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : $("#visit-details-id-customer-visits").html(), "visit_status": visit_status, "reassign_all_to_staff" : $("#visit-details-assign-all-to-staff").val() },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                ////console.log(data);
                var btn= "btn btn-" +  data.message_btn
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                
                $("#visit-details-assign-all-to-staff").val($('#visit-details-assign-all-to-staff option:first').val()).trigger('change');

                //enable btn
                document.getElementById("visit-details-assign-all-to-btn").disabled = false;

                // var modalEl = document.getElementById('visit-details-modal');
                // var modalObj = bootstrap.Modal.getInstance(modalEl);
                // modalObj.hide();

                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

    }

    function assign_visit_service_staff(id_visit_services){
        if($("#visit-detail-modal-staff").val() == "" || $("#visit-detail-modal-staff").val()  < 1){
            return false;   
        }

        elem = "#visit-detail-modal-staff_"+id_visit_services;
        var staffData = $(elem).val();
        if(staffData.length <=0){
            return false;
        }

        var visit_status = $("#visit-details-visit-status").html();
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : $("#visit-details-id-customer-visits").html(), "visit_status": visit_status, "staff_add": true, "id_visit_services": id_visit_services, "reassign_service_staff" : staffData },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                //console.log(data);
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                
               
                getvisitdetails();

                // var modalEl = document.getElementById('visit-details-modal');
                // var modalObj = bootstrap.Modal.getInstance(modalEl);
                // modalObj.hide();


            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

    }

    function replace_invoiced_staff(id_visit_service_staffs){
        if($("#visit-detail-modal-staff").val() == "" || $("#visit-detail-modal-staff").val()  < 1){
            return false;   
        }

        elem = "#visit-detail-modal-staff_"+id_visit_service_staffs;
        var staffData = $(elem).val();
       
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : $("#visit-details-id-customer-visits").html(), "replace_invoiced_staff": true, "id_visit_service_staffs": id_visit_service_staffs, "staff_id" : staffData },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                //console.log(data);
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                
               
                getvisitdetails();
            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });
    }

    function updateVisitDate(){
        //disable btn
        document.getElementById("visit-details-check-in-btn").disabled = true;

        if($("#visit-details-visit-start-date").val() == ""){
            return false;   
        }

        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : $("#visit-details-id-customer-visits").html(), "update_visit_service_date" : $("#visit-details-visit-start-date").val() },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                //console.log(data);
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                
                //enable btn
                document.getElementById("visit-details-check-in-btn").disabled = false;
               
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

    }

    function service_time_changed(vs_id){

        var startElem = "#vs_start_time_"+vs_id;
        var endElem = "#vs_end_time_"+vs_id;

        let startVal = normalizeTime($(startElem).val());
        let endVal   = normalizeTime($(endElem).val());

            // get today's date
            let today = new Date();

            // format YYYY-MM-DD from today
            let yyyy = today.getFullYear();
            let mm   = String(today.getMonth() + 1).padStart(2, '0'); // months are 0-based
            let dd   = String(today.getDate()).padStart(2, '0');

            // build datetime string with fixed time
            let start_datetimeStr = `${yyyy}-${mm}-${dd}T`+startVal;            
            let end_datetimeStr = `${yyyy}-${mm}-${dd}T`+endVal;

            // build datetimes Objects
            let startdatetime = new Date(`${yyyy}-${mm}-${dd}T${startVal}`);
            let enddatetime   = new Date(`${yyyy}-${mm}-${dd}T${endVal}`);

            if(startdatetime >= enddatetime){
                Swal.fire({
                    text: "Start Time cannot be GREATER then or SAME as End time",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
               return false;
            }

           // check duration
            let diffMins = (enddatetime - startdatetime) / (1000 * 60);
            if (diffMins < 15) {
                Swal.fire({
                    text: "Select At Least 15 minutes for a service!",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
               return false;
               
            }

    }

    function update_visit_service_time(vs_id){

        var startElem = "#vs_start_time_"+vs_id;
        var endElem = "#vs_end_time_"+vs_id;

        let startVal = normalizeTime($(startElem).val());
        let endVal   = normalizeTime($(endElem).val());


        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "update_service_time": "true", "id_customer_visits" : $("#visit-details-id-customer-visits").html(), "id_visit_services" : vs_id, "visit_service_start" :  startVal, "visit_service_end" : endVal },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

    }

    function stricttimechanged(){

        var id_visit = $("#visit-details-id-customer-visits").html();

        var strictTime = "N";
        if($('#visit-details-strict-time').is(':checked')){strictTime="Y";}
        
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "update_strict_time": strictTime, "id_customer_visits" : id_visit  },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });


    }

    function reminderchanged(val){
        var id_visit = $("#visit-details-id-customer-visits").html();
        var data = '';
        if(val=="sms"){
            var smsReminder = "N";
            if($('#visit-details-sms-reminder').is(':checked')){smsReminder="Y";}
            data = { "update_sms_reminder": smsReminder, "id_customer_visits" : id_visit  }
        } else if(val=="email"){
            var emailReminder = "N";
            if($('#visit-details-email-reminder').is(':checked')){emailReminder="Y";}
            data = { "update_email_reminder": emailReminder, "id_customer_visits" : id_visit  }
        } else if(val=="call"){
            var emailReminder = "N";
            if($('#visit-details-call-reminder').is(':checked')){callReminder="Y";}
            data = { "update_call_reminder": callReminder, "id_customer_visits" : id_visit  }
        }
        
        
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: data,
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });
    }

    function addVisitExtra(){

        var id_visit = $("#visit-details-id-customer-visits").html();
        var visitExtra = $("#visit-details-visit-extra").val();
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : id_visit,  "add_visit_extra" : visitExtra},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

    }

    function changeVisitColor(){
        var id_visit = $("#visit-details-id-customer-visits").html();
        var color = $("#visit-details-visit-color").val();

        //console.log(color);
         $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : id_visit,  "visit_color" : color},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                
                var btn = "btn btn-" +data.message_btn;
                 Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

    }

    function changeVisitStatus(status){
        var id_visit = $("#visit-details-id-customer-visits").html();        

        var cancelReason ="";

        // var modalEl = document.getElementById('visit-details-modal');
        // var modalObj = bootstrap.Modal.getInstance(modalEl);
        // modalObj.hide();
       
        
        Swal.fire({
            input: "textarea",
            inputLabel: "Cancellation Reason",
            inputPlaceholder: "Type your cancellation reason here...",
            inputAttributes: {
                "aria-label": "Type your cancellation reason here"
            },
            showCancelButton: true,
            icon: "question",
            customClass: {
                confirmButton: 'btn btn-primary',
                cancelButton: 'btn btn-secondary'
            },
            buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
        }).then((result) => {
            if (result.value) {
                //Swal.fire(result.value);
                cancelReason=result.value;
                    
                $.ajax({
                    url : "{{ route('update_visit') }}",
                    data: { "id_customer_visits" : id_visit,  "update_visit_status" : status, cancel_reason : cancelReason},
                    type: "POST", // The POST method
                    dataType: "json", // Expected data type of the response
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                    success: function(data) {
                        
                        var btn = "btn btn-" +data.message_btn;
                        Swal.fire({
                            text: data.message,
                            icon: data.message_type,
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: btn
                            }
                        });
                        
                        //close modal
                        var modalEl = document.getElementById('visit-details-modal');
                        var modalObj = bootstrap.Modal.getInstance(modalEl);
                        modalObj.hide();



                    },
                    error: function(xhr, status, error) {
                        // Handle errors
                        console.error("AJAX Error:", status, error);
                    }
                });
            }
        });

    }

    function updateStaffReq(vs_id){

        var id_visit = $("#visit-details-id-customer-visits").html();  

        var elem = $("#visit-details-staff-req_"+vs_id);
        var req="No";
        if($(elem).is(':checked')){
            req="Yes";
        }

        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : id_visit,  "update_staff_req" : req, "id_visit_services" : vs_id},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                
                var btn = "btn btn-" +data.message_btn;
                Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });
    }

    function updateServicePromo(vs_id){

        var id_visit = $("#visit-details-id-customer-visits").html();  

        var elem = $("#visit-details-service-promo_"+vs_id);
        var promo="No";
        if($(elem).is(':checked')){
            promo="Yes";
        }

        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : id_visit,  "update_service_promo" : promo, "id_visit_services" : vs_id},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                
                var btn = "btn btn-" +data.message_btn;
                Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });
                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });
    }

    function openAddServices(){
        // $('#visit-detail-modal-add-service-panel').removeClass('d-none');
        // $("#visit-detail-modal-main-panel").addClass('d-none');

        let staff_list = JSON.parse(localStorage.getItem('staffList') || '[]');

        var ohtml='<option value=""></option>';
        if($("#crosssell option").length < 1){            
            $.each(staff_list, function(index, item){
                        ohtml += '<option value="'+ item.id_staff +'" data-image="'+ item.staff_image +'">' +
                            item.staff_fullname +
                        '</option>';
                    });
            $("#crosssell").append(ohtml);
                   
            $('#crosssell').select2({
                dropdownParent: $('#visit-details-modal'),
                templateResult: formatStaff,
                templateSelection: formatStaff
            });
        }

        $('#visit-detail-modal-main-panel').slideUp();
        // $('#visit-detail-modal-add-service-panel').fadeIn(); 
        document.getElementById('visit-detail-modal-add-service-panel').classList.remove('d-none');
        //Handle Button Visibility
        $(".btn-visit-on").addClass('d-none');
        $(".btn-customer-on").addClass('d-none');
        $(".btn-create-on").addClass('d-none');
        $(".btn-add-service-on").removeClass('d-none');        

    }

    function slide_div_backwards(current_div){
        
        current_div = "#" + current_div;

        // if($("#visit-details-customer-name").html() != "" && $("#visit-details-id-visit-services").html != ""){
        //     //visit details and services are loaded
        //     backto_div = "#visit-detail-modal-main-panel";
        //     $(".btn-visit-on").removeClass('d-none');
        //     $(".btn-customer-on").removeClass('d-none');
        //     $(".btn-create-on").addClass('d-none');
        //     $(".btn-add-service-on").addClass('d-none');
        // } else if($("#visit-details-customer-name").html() != "" && $("#visit-details-id-visit-services").html == ""){
        //     //customer selected but visit not created
        //     backto_div = "#visit-detail-modal-select-customer-panel";
        //     $(".btn-visit-on").addClass('d-none');
        //     $(".btn-customer-on").removeClass('d-none');
        //     $(".btn-create-on").removeClass('d-none');
        //     $(".btn-add-service-on").addClass('d-none');
        // } else {
        //     //no details are loaded
        //     backto_div = "#visit-detail-modal-select-customer-panel";
        // }

       
        if($("#visit-details-id-customer-visits").html() != ""){ 
            //visit created viewing details
            // $('#visit-detail-modal-select-customer-panel').hide();
            document.getElementById('visit-detail-modal-select-customer-panel').classList.add('d-none');
            document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');
            //$('#visit-detail-modal-add-service-panel').hide();
            document.getElementById('visit-details-customer-notification-div').classList.add('d-none');
            document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
            
            $('#visit-detail-modal-main-panel').show();
            //Handle button visibilities
            $(".btn-visit-on").removeClass("d-none");                   
            $(".btn-customer-on").removeClass("d-none");
            $(".btn-add-service-on").addClass("d-none");
            $(".btn-create-on").addClass("d-none");
            
        } else if($("#visit-details-customer-name").html() != "" && $("#visit-details-id-customer-visits").html() == ""){ 
            //customer selected but visit not created            
            document.getElementById('visit-detail-modal-select-customer-panel').classList.remove('d-none');
            document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');            
            document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
            $('#visit-detail-modal-main-panel').hide();
            //Handle button visibilities
            $(".btn-visit-on").addClass("d-none");
            $(".btn-customer-on").removeClass("d-none");
            $(".btn-add-service-on").addClass("d-none");
            $(".btn-create-on").removeClass("d-none");
            document.getElementById("visit-details-create-visit-btn").textContent = "Create Visit";
        } else { //new visit
            //Select customer view            
            document.getElementById('visit-detail-modal-select-customer-panel').classList.remove('d-none');            
            document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');            
            document.getElementById('visit-details-customer-notification-div').classList.add('d-none'); 
            $('#visit-detail-modal-main-panel').hide();
            //Handle button visibilities
            $(".btn-visit-on").addClass("d-none");
            $(".btn-customer-on").addClass("d-none");
            $(".btn-add-service-on").addClass("d-none");
            $(".btn-create-on").removeClass("d-none");
            document.getElementById("visit-details-create-visit-btn").textContent = "Create Visit";
        }

        $(current_div).slideUp();
        $(backto_div).fadeIn();        

    }

    function normalizeTime(val) {
        let parts = val.split(':'); // ["12","30","0"]
        if (parts.length === 2) {
            // HH:mm → add :00
            return `${parts[0].padStart(2, '0')}:${parts[1].padStart(2, '0')}:00`;
        } else if (parts.length === 3) {
            // HH:mm:s → pad seconds properly
            return `${parts[0].padStart(2, '0')}:${parts[1].padStart(2, '0')}:${parts[2].padStart(2, '0')}`;
        }
        return val; // fallback
    }

    function getserviceslist(){
        
        //console.log($("#visit-details-modal-service-types .list .id-service-type-item").length);
        if($("#visit-details-modal-service-types .list .id-service-type-item").length <= 1){
            $.ajax({
                url : "{{ route('get_services_list') }}",                
                type: "GET", // The GET method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {
                    console.log(data,"data");
                    var service_type = data.service_types;
                    var service_category = data.service_categories;
                    var services_list = data.services_list;

                    ///Service Types List
                    if(service_type.length > 0){
                        
                        ///fill the service types list
                        type_html = "";
                        $.each(service_type, function(index, servicetype){
                            type_html += `<div style="cursor:pointer;" onclick="$('.id-service-type-item').css('background-color','transparent'); $(this).css('background-color','#e7e7e7');  display_categories(`+servicetype.id_service_types+`,'`+servicetype.serviceflag+`');"  data-id-service-type="`+servicetype.id_service_types+`" data-service-flag="`+servicetype.serviceflag+`" class="list-group-item list-group-item-action id-service-type-item">
                                            <img src="`+ ImageBase +`services/types/`+servicetype.service_type_image+`" style="width:27px;" class="img-responsive"> <span class="fs-14 service-type">`+servicetype.service_type+`</span>
                                            </div>`;
                        });
                        //console.log(type_html);
                        $(".id-service-type-item").remove();
                        $("#visit-details-modal-service-types .list").append(type_html);
                        var options = {
                            valueNames: [ 'service-type' ] // searchable fields
                        };

                        var myserviceTypeList = new List('visit-details-modal-service-types', options);

                        // tie search input explicitly
                        document.getElementById('searchgetservicestypes').addEventListener('keyup', function() {
                            myserviceTypeList.search(this.value);
                        });
                    }

                    ///Category List
                    if(service_category.length > 0){
                        
                        ///fill the service categories list
                        category_html = "";
                        $.each(service_category, function(index, servicecategory){
                            if(null != servicecategory.service_type_id){
                            category_html += `<div onclick="$('.id-service-category-item').css('background-color','transparent'); $(this).css('background-color','#e7e7e7'); display_services(`+servicecategory.service_type_id+`,`+servicecategory.id_service_category+`, '`+ servicecategory.serviceflag  +`');" type="button" data-id-service-type="`+servicecategory.service_type_id+`" data-id-service-category="`+servicecategory.id_service_category+`" data-service-flag="`+servicecategory.serviceflag+`" 
                            data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="right" data-bs-custom-class="tooltip-primary" data-bs-title="`+ servicecategory.service_type + ` - ` +servicecategory.service_category +`"
                            class="list-group-item list-group-item-action id-service-category-item d-none">
                                                <img src="`+ ImageBase +`services/categories/`+servicecategory.service_category_image+`" style="width:27px;" class="img-responsive"> 
                                                <span class="fs-14 service-category">`+servicecategory.service_category+`</span>
                                            </div>`;
                            }                            
                        });
                        //console.log(category_html);
                        $(".id-service-category-item").remove();
                        $("#visit-details-modal-service-categories .list").append(category_html);

                        // Initialize tooltips for the newly added buttons
                        $('#visit-details-modal-service-categories [data-bs-toggle="tooltip"]').each(function () {
                            new bootstrap.Tooltip(this, {
                                container: '#visit-details-modal' // keeps tooltips inside the modal
                            });
                        });

                        ///Enable list search
                        var options = {
                        valueNames: [ 'service-category' ] // searchable fields
                        };

                        var myserviceCategoryList = new List('visit-details-modal-service-categories', options);

                        // tie search input explicitly
                        document.getElementById('searchgetservicescategories').addEventListener('keyup', function() {
                            s = this.value;
                            myserviceCategoryList.search(this.value);
                            // First hide everything
                            myserviceCategoryList.items.forEach(function(item) {
                                item.elm.classList.add('d-none');
                            });

                            // Show only the matching (visible) ones
                            myserviceCategoryList.visibleItems.forEach(function(item) {
                                if(s != ""){
                                    item.elm.classList.remove('d-none');
                                }
                            });
                        });

                    }
                    ///Services List
                    if(services_list.length > 0){
                        var services_html="";
                        $.each(services_list, function(index, service){     
                            if(null != service.service_type_id && null != service.category_id){ 
                                services_html += `<div onclick="addServiceToTable(`+service.service_type_id+`,`+service.category_id+`,`+service.id_business_services+`,'`+service.service_flag+`');" 
                                class="d-none list-group-item d-flex justify-content-between align-items-start id-business-services-item" data-id-service-types="`+service.service_type_id+`" data-type-name="`+ service.service_type_name+`" data-category-name="`+ service.service_category_name +`" 
                                data-id-service-category="`+service.category_id+`" data-service-flag="`+service.service_flag+`"  data-id-business-services="`+service.id_business_services+`" 
                                data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="right" data-bs-custom-class="tooltip-primary" data-bs-title="`+ service.service_type_name + ` ` +  service.service_name  + `-`+service.service_rate+`">
                                    <div class=" me-auto" style="cursor: pointer;">
                                        <span class="d-none service-id">`+service.id_business_services+`</span>
                                        <input style="cursor: pointer;" class="form-check-input me-1 checkservice" type="checkbox" value="" id="serviceCheckbox_`+ service.category_id + `_` + service.service_type_id + `_` + service.id_business_services +`">
                                        <label style="cursor: pointer;" class="form-check-label fs-14 service-name" style="overflow-wrap: break-all;"  for="serviceCheckbox_`+ service.category_id + `_` + service.service_type_id + `_` + service.id_business_services +`">`+  service.service_name +`</label>
                                    </div>
                                    <span  class="badge bg-success rounded-pill fs-12 service-price">`+service.service_price+`</span>
                                </div>`;
                            }          
                        });
                        

                        //console.log(services_html);
                        $(".id-business-services-item").remove();
                        $("#visit-details-modal-services .list").append(services_html);

                        // Initialize tooltips for the newly added buttons
                        $('#visit-details-modal-services [data-bs-toggle="tooltip"]').each(function () {
                            new bootstrap.Tooltip(this, {
                                container: '#visit-details-modal' // keeps tooltips inside the modal
                            });
                        });

                        var options = {
                        valueNames: [ 'service-name', 'service-price', 'service-id' ] // searchable fields
                        };
                        var myserviceList = new List('visit-details-modal-services', options);

                        // tie search input explicitly
                        document.getElementById('searchgetservices').addEventListener('keyup', function() {
                            //Run List Js Search
                            s=this.value;
                            myserviceList.search(this.value);
                            
                            // First hide everything
                            myserviceList.items.forEach(function(item) {
                                item.elm.classList.add('d-none');
                            });

                            // Show only the matching (visible) ones
                            myserviceList.visibleItems.forEach(function(item) {                                
                                if(s != ""){
                                    item.elm.classList.remove('d-none');
                                }
                            });
                        });                        
                    }
                },
                error: function(xhr, status, error) {
                    console.log(error,"error");
                    // Handle errors
                    console.error("AJAX Error:", status, error);
                }
            });
        }
    }

    function display_categories(id_service_types, serviceflag){
        console.log('Filling categories list for type:', id_service_types + ' and flag:', serviceflag);
        id_service_types = parseInt(id_service_types);
        serviceflag = String(serviceflag);
        // hide everything first
        $('#visit-details-modal-service-categories .list [data-id-service-type]').addClass('d-none');

        // then show only the matching ones
        $('#visit-details-modal-service-categories .list [data-id-service-type="' + id_service_types + '"][data-service-flag="' + serviceflag + '"]').removeClass('d-none');

    }

    function display_services(id_service_types, id_service_category, service_flag) {
        console.log('Filling services list for type:', id_service_types, 'and category:', id_service_category);

        id_service_types = parseInt(id_service_types);
        id_service_category = parseInt(id_service_category);
        // Hide all services first
        $('#visit-details-modal-services .list [data-id-service-category]').addClass('d-none');

        // Show only matching ones
        $('#visit-details-modal-services .list [data-id-service-category="' + id_service_category + '"][data-id-service-types="' + id_service_types + '"]').removeClass('d-none');

        // Find the matching service element
        let service_El = $('#visit-details-modal-services .list [data-id-service-category="' + id_service_category + '"][data-id-service-types="' + id_service_types + '"]');
       // console.log("Service Element Found:", service_El);

        // Make sure element exists
        for (let i = 0; i < service_El.length; i++) {
            console.log("Element Count:", service_El.length);

            if (service_flag === "packagetype") {                

                let serviceType = service_El.eq(i).attr('data-id-service-types');
                let serviceCategory = service_El.eq(i).attr('data-id-service-category');
                let businessService = service_El.eq(i).attr('data-id-business-services');
                let flag = service_El.eq(i).attr('data-service-flag');
                let rate = service_El.eq(i).attr('data-service-rate') || 0;

                // make the checkbox checked first
                console.log("Checking Package Type Service Checkbox: " + '#serviceCheckbox_' + serviceCategory + '_' + serviceType + '_' + businessService);
                $('#serviceCheckbox_' + serviceCategory + '_' + serviceType + '_' + businessService).prop('checked', true);

                console.log("Adding Package Type Service Directly:", businessService);

                // Add to Selected Services Table
                addServiceToTable(serviceType, serviceCategory, businessService, flag, rate);

                // Mark checkbox as checked
                $('#serviceCheckbox_' + serviceCategory + '_' + serviceType + '_' + businessService).prop('checked', true);
            }
        } 
    }

    function addServiceToTable(id_service_types, id_service_category, id_business_services, service_flag, service_rate){
        console.log("Adding Service: " + id_business_services);

        //Get The Service Details
        $("#visit-details-modal-selected-services-table tbody").html('');

        var thtml = ""; var total = 0;
        $('#visit-details-modal-services .list input[type="checkbox"]:checked').each(function() {
            var serviceId = $(this).closest('.id-business-services-item').data('id-business-services');
            var typeId = $(this).closest('.id-business-services-item').data('id-service-types');
            var typeName = $(this).closest('.id-business-services-item').data('type-name');
            var categoryId = $(this).closest('.id-business-services-item').data('id-service-category');
            var categoryName = $(this).closest('.id-business-services-item').data('category-name');
            var serviceFlag = $(this).closest('.id-business-services-item').data('service-flag');

            var serviceName = $(this).closest('.id-business-services-item').find('.service-name').text();
            var servicePrice = $(this).closest('.id-business-services-item').find('.service-price').text();


            thtml += `<tr>
                        <td data-id-service-type="`+typeId+`" data-service-type-name="`+typeName+`" data-id-service-category="`+categoryId+`" data-service-category-name="`+categoryName+`" data-id-business-services="`+serviceId+`" data-service-name="`+serviceName+`" data-service-flag="` + serviceFlag + `" data-service-price="` + servicePrice + `"
                        data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-placement="top" data-bs-custom-class="tooltip-primary" data-bs-title="`+ typeName + ` ` +  serviceName +`-`+servicePrice+`"
                        >`+serviceName+`</td>
                        <td class="text-end">`+servicePrice+`</td>
                        <td><button type="button" onclick="removeServiceFromTable(`+serviceId+`,`+typeId+`,`+categoryId+`);" class="btn btn-sm btn-icon btn-danger"><i class="ri-close-line"></i></button></td>
                    </tr>`;
            total += parseFloat(servicePrice.replace(/[^0-9.-]+/g,""));
        });
        $("#visit-details-modal-selected-services-table tbody").html(thtml);
        $("#visit-details-modal-selected-services-total").html(total.toFixed(2));

        // Initialize tooltips for the newly added tds
        $('#visit-details-modal-selected-services-table tbody [data-bs-toggle="tooltip"]').each(function () {
            new bootstrap.Tooltip(this, {
                container: '#visit-details-modal' // keeps tooltips inside the modal
            });
        });
    }

    function removeServiceFromTable(business_service_id, id_service_types, id_service_category){
        // Uncheck the checkbox in the services list
        $('#visit-details-modal-services .list input[type="checkbox"]').each(function() {
            var serviceId = $(this).closest('.id-business-services-item').data('id-business-services');
            var typeId = $(this).closest('.id-business-services-item').data('id-service-types');
            var categoryId = $(this).closest('.id-business-services-item').data('id-service-category');

            if(serviceId == business_service_id && categoryId == id_service_category && typeId == id_service_types){
                $(this).prop('checked', false);
            }
        });

        // Remove the service from the selected services table
        $("#visit-details-modal-selected-services-table tbody tr").each(function() {
            var serviceId = $(this).find('td:first').data('id-business-services');
            var typeId = $(this).find('td:first').data('id-service-type');
            var categoryId = $(this).find('td:first').data('id-service-category');

            if(serviceId == business_service_id && categoryId == id_service_category && typeId == id_service_types){
                $(this).remove();
            }
        });

        // Recalculate the total
        var total = 0;
        $("#visit-details-modal-selected-services-table tbody tr").each(function() {
            var servicePrice = $(this).find('td:nth-child(2)').text();
            total += parseFloat(servicePrice.replace(/[^0-9.-]+/g,""));
        });
        $("#visit-details-modal-selected-services-total").html(total.toFixed(2));
    }

    function addServicesToVisits(){

        if($("#visit-details-id-customer-visits").html()!=""){
            var selectedServices = [];
            $('#visit-details-modal-services .list input[type="checkbox"]:checked').each(function() {
                let cross_sell_staff = $("#crosssell").select2('data');
                let data = {
                    "id_business_services": $(this).closest('.id-business-services-item').data('id-business-services'),
                    "service_name": $(this).closest('.id-business-services-item').find('.service-name').text(),
                    "id_service_types": $(this).closest('.id-business-services-item').data('id-service-types'),
                    "type_name": $(this).closest('.id-business-services-item').data('type-name'),
                    "id_service_category": $(this).closest('.id-business-services-item').data('id-service-category'),
                    "category_name": $(this).closest('.id-business-services-item').data('category-name'),
                    "service_flag": $(this).closest('.id-business-services-item').data('service-flag'),
                    "service_price": $(this).closest('.id-business-services-item').find('.service-price').text(),
                    "crosssell": cross_sell_staff[0].text || null
                };
                selectedServices.push(data);
            });

            if(selectedServices.length < 1){
                Swal.fire({
                    text: "Please select at least one service to add.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
            return false;
            }

            var id_visit = $("#visit-details-id-customer-visits").html();  

            if(id_visit != ""){
                $.ajax({
                    url : "{{ route('add_services_to_visit') }}",
                    data: { "id_customer_visits" : id_visit,  "add_services" : selectedServices},
                    type: "POST", // The POST method
                    dataType: "json", // Expected data type of the response
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                    success: function(data) {
                        
                        var btn = "btn btn-" +data.message_btn;
                        Swal.fire({
                            text: data.message,
                            icon: data.message_type,
                            buttonsStyling: false,
                            confirmButtonText: "Ok",
                            customClass: {
                                confirmButton: btn
                            }
                        });

                        $(".id-service-category-item").addClass('d-none');
                        $(".id-business-services-item").addClass('d-none');
                        //Reset the checkboxes
                        $('#visit-details-modal-services .list input[type="checkbox"]').prop('checked', false);
                        //Clear the Service Add Table
                        $('#visit-details-modal-selected-services-table tbody').html("");
                        $("#visit-details-modal-selected-services-total").html("0.00");
                        getvisitdetails();

                        slide_div_backwards('visit-detail-modal-add-service-panel');
                        

                    },
                    error: function(xhr, status, error) {
                        // Handle errors
                        console.error("AJAX Error:", status, error);
                    }
                });
            } else {
                Swal.fire({
                    text: "No visit selected to add services.",
                    icon: "error",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-danger"
                    }
                });
            }
        } else {
            Swal.fire({
                text: "No visit selected to add services.",
                icon: "error",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-danger"
                }
            });
        }
    }

    function cancelService(id_visit_services){
        var id_visit = $("#visit-details-id-customer-visits").html();  
        $.ajax({
            url : "{{ 'update_visit' }}",
            data: { "id_customer_visits" : id_visit,  "id_visit_services" : id_visit_services, "remove_service": "true"},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {                
                var btn = "btn btn-" +data.message_btn;
                Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });

                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });

    }
    
    function selectCustomerForVisit(){
        // $("#visit-detail-modal-add-service-panel").slideDown();
        // document.getElementById('visit-detail-modal-add-service-panel').classList.remove('d-none');
        if (!document.getElementById('visit-details-create-visit-btn').classList.contains('d-none')) {
           document.getElementById('visit-detail-modal-add-service-panel').classList.remove('d-none');
        }

    
        //Show Create Visit Button
        // $(".btn-create-on").removeClass('d-none');
        // $(".btn-customer-on").removeClass('d-none');
        //Hide Add Service Button
        $(".btn-back").addClass('d-none');
        $(".cross-sell").addClass('d-none');

        //get custome details
        var id_customer = $("#visit-details-new-visit-select-customer").val();
       // console.log("Selected Customer: " + id_customer);
        if(id_customer != "" && id_customer != null){
            $.ajax({
                url : "{{ 'get_customer_details' }}",
                data: { "id_customer" : id_customer},
                type: "GET", // The GET method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {
                    $("#customer_open_account_id").removeClass("d-none");
                    //Hide the customer-panel-extras-replacement
                    document.getElementsByClassName('customer-panel-extras-replacement')[0].classList.add('d-none');
                    //Show all the customer-panel-extras
                    var extras = document.getElementsByClassName('customer-panel-extras');
                    for (var i = 0; i < extras.length; i++) {
                        extras[i].classList.remove('d-none');
                    }

                    var customer_details = data.customer_details;
                    var recoveries = data.recoveries;
                    
                       // console.log(data.customer_details.customer_name);
                        $("#visit-details-id-customers").html(data.customer_details.id_customers);
                        $("#visit-details-customer-name").html(data.customer_details.customer_name);
                        $("#visit-details-customer-cell").html(data.customer_details.customer_cell);                        

                        //Show Selected Customer Div
                        $("#visit-details-id-customers").removeClass('d-none');
                        $("#visit-details-customer-name").removeClass('d-none');
                        $("#visit-details-customer-cell").removeClass('d-none');

                        if(data.customer_details.customer_alert != null && data.customer_details.customer_alert != ""){
                            $("#visit-details-customer-notification").html(data.customer_details.customer_alert+"<br>");
                            // $("#visit-details-customer-notification-div").show();
                            document.getElementById('visit-details-customer-notification-div').classList.remove('d-none'); 
                        
                            if(data.customer_details.customer_allergies != null && data.customer_details.customer_allergies != ""){
                                $("#visit-details-customer-notification").append("Allergies: " + data.customer_details.customer_allergies);
                                document.getElementById('visit-details-customer-notification-div').classList.remove('d-none'); 
                            }
                        } else {
                            document.getElementById('visit-details-customer-notification-div').classList.add('d-none'); 
                            $("#visit-details-customer-notification").html("");
                        }

                        if(recoveries.length > 0){
                            var rhtml = '<option value=""></option>';
                            $.each(recoveries, function(index, recovery){
                                rhtml += '<option value="'+ recovery.id_invoice +'">' +
                                    recovery.id_invoice + ' (Balance: ' + recovery.balance + ')' +
                                '</option>';
                            });
                            $("#visit-details-recovery-invoice").html(rhtml);
                            $("#visit-details-recovery-invoice-div").show();
                        } else {
                            $("#visit-details-recovery-invoice").html("");
                            $("#visit-details-recovery-invoice-div").hide();
                        }
                        //Recovery Invoice Buttons
                        var bhtml="";
                        $("#visit-details-recovery-btn-div").html();
                        if(recoveries.length > 0){
                            $("#visit-details-balance-div").removeClass('d-none');                        
                        } else { 
                            $("#visit-details-balance-div").addClass('d-none');                        
                        }

                        $.each(recoveries, function(index, invoice){
                            bhtml += '<button class="btn btn-soft-danger me-1" onclick="open_new_recovery_invoice(' + invoice.id_invoice+ ')" data-id-invoice = ' + invoice.id_invoice + '>' + invoice.balance + '</button>';
                        });
                        $("#visit-details-recovery-btn-div").html(bhtml);
                        //change the Create Visit Button to Save Visit
                        document.getElementById("visit-details-create-visit-btn").textContent = "Save Visit";
                        $("#btn-visit-details-create-visit").removeClass("d-none");

                        if (document.getElementById('visit-details-create-visit-btn').classList.contains('d-none') && document.getElementById('visit-details-create-voucher-btn').classList.contains('d-none')) {  
                            var extras = document.getElementsByClassName('customer-panel-extras');
                            for (var i = 0; i < extras.length; i++) {
                                extras[i].classList.add('d-none');
                            }
                            document.getElementById('selected-staff-combo-box-div').classList.remove('d-none');
                        }    
                }
            });
        }

    }

    function create_service_invoice(){
        //disable btn
        document.getElementById('visit-details-generate-invoice-btn').disabled=true;

        var id_visit = $("#visit-details-id-customer-visits").html();  

        if(id_visit != "" && id_visit != null){
            var url = "{{ url('new_service_invoice') }}" + "/" + id_visit;
            window.open(url, 'newinvoice');

            //enable btn
            //document.getElementById('visit-details-generate-invoice-btn').disabled=false;

            //close the modal
            // var modalEl = document.getElementById('visit-details-modal');
            // var modalObj = bootstrap.Modal.getInstance(modalEl);
            // modalObj.hide();

        } else {
            Swal.fire({
                text: "Visit Not Selected!",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            //enable btn
            document.getElementById('visit-details-generate-invoice-btn').disabled=false;

        }



    }

    function open_invoice(){
        var id_invoice = $("#visit-details-view-invoice-btn").attr("data-id-invoice");
        if(id_invoice != "" && id_invoice != null){
            var url = "{{ url('existing_service_invoice') }}" + "/" + id_invoice;
            window.open(url, '_blank');
        } else {
            Swal.fire({
                text: "No invoice linked to this visit.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
        }
    }

    function create_visit(){
        
        let mode = document.getElementById("visit-details-create-visit-btn").textContent;
        console.log("Button Mode: " + mode);
        if(mode == "Create Visit"){
            document.getElementById("visit-details-create-visit-btn").textContent = "Save Visit";
             //hide other buttons
            document.getElementById("visit-details-create-order-btn").classList.add('d-none');
            document.getElementById("visit-details-create-voucher-btn").classList.add('d-none');  

            //Hide the select products panel
            if(document.getElementById('visit-detail-modal-products-panel').classList.contains('d-none') == false){
                document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');
            }
           
            //Show the select services panel
            selectCustomerForVisit();
            return false;
        } else {            

             var id_customer = $("#visit-details-new-visit-select-customer").val();
            
            //Get the visit details
            var visit_date = $("#visit-details-new-visit-datetime").val().replace(" ", "T");        
            var staff_id = $("#visit-details-new-visit-selected-staff").val();
            var promo = $("#visit-details-new-visit-promo").prop('checked') ? 'Yes' : 'No';
            var requested = $("#visit-details-new-visit-requested").prop('checked') ? 'Yes' : 'No';
            var strict_time = $("#visit-details-new-visit-strict-time").prop('checked') ? 'Yes' : 'No';
            
            console.log("Creating Visit for Customer: " + id_customer + " on " + visit_date + " with Staff: " + staff_id);
            //return false;

            //Validations
            if(id_customer == "" || id_customer == null){
                Swal.fire({
                    text: "Please select a customer for the visit.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                
                return false;
            }

            if(visit_date == "" || visit_date == null){
                Swal.fire({
                    text: "Please select a date for the visit.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                return false;
            }

            if(staff_id == "" || staff_id == null){
                Swal.fire({
                    text: "Please select a staff member for the visit.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                return false;
            }

            var selectedServices = [];
                $('#visit-details-modal-services .list input[type="checkbox"]:checked').each(function() {
                    let data = {
                        "id_business_services": $(this).closest('.id-business-services-item').data('id-business-services'),
                        "service_name": $(this).closest('.id-business-services-item').find('.service-name').text(),
                        "id_service_types": $(this).closest('.id-business-services-item').data('id-service-types'),
                        "type_name": $(this).closest('.id-business-services-item').data('type-name'),
                        "id_service_category": $(this).closest('.id-business-services-item').data('id-service-category'),
                        "category_name": $(this).closest('.id-business-services-item').data('category-name'),
                        "service_flag": $(this).closest('.id-business-services-item').data('service-flag'),
                        "service_price": $(this).closest('.id-business-services-item').find('.service-price').text()
                    };
                    selectedServices.push(data);
                });

                if(selectedServices.length < 1){
                    Swal.fire({
                        text: "Please select at least one service to add.",
                        icon: "info",
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: "btn btn-info"
                        }
                    });
                return false;
                }
            
            //disable btn
            document.getElementById('visit-details-create-visit-btn').disabled=true;

            $.ajax({
                url : "{{ 'create_visit' }}",
                data: { "id_customer" : id_customer,  "visit_date" : visit_date,  "staff_id" : staff_id, strict_time: strict_time, "promo" : promo, "requested": requested, "add_services" : selectedServices},
                type: "POST", // The POST method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {
                    var btn = "btn btn-" +data.message_btn;
                    Swal.fire({
                        text: data.message,
                        icon: data.message_type,
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: btn
                        }
                    });
                    //enable btn
                    document.getElementById('visit-details-create-visit-btn').disabled=false;

                    if(data.message_type == "success"){
                        //Set the visit id
                        $("#visit-details-id-customer-visits").html(data.new_visit_id);
                        //Show Add Service Button
                        $(".btn-add-service-on").removeClass('d-none');
                        $(".btn-back").removeClass('d-none');
                        //Hide Create Visit Button
                        $(".btn-create-on").addClass('d-none');
                        $(".cross-sell").removeClass('d-none');

                        //Show main details div and hide other divs
                        //visit created viewing details
                        //$('#visit-detail-modal-select-customer-panel').hide();
                        document.getElementById('visit-detail-modal-select-customer-panel').classList.add('d-none');
                        document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
                        $('#visit-detail-modal-main-panel').show();
                        //Handle button visibilities
                        $(".btn-visit-on").removeClass("d-none");
                        $(".btn-customer-on").removeClass("d-none");
                        $(".btn-add-service-on").addClass("d-none");
                        $(".btn-create-on").addClass("d-none");

                        $(".id-service-category-item").addClass('d-none');
                        $(".id-business-services-item").addClass('d-none');
                        //Reset the checkboxes
                        $('#visit-details-modal-services .list input[type="checkbox"]').prop('checked', false);
                        //Clear the Service Add Table
                        $('#visit-details-modal-selected-services-table tbody').html("");
                        $("#visit-details-modal-selected-services-total").html("0.00");
                        
                        //Get the visit details
                        //getvisitdetails();

                        //close the modal if open
                        var modalEl = document.getElementById('visit-details-modal');
                        if (modalEl) {
                            var modal = bootstrap.Modal.getInstance(modalEl);
                            if (modal) {
                                modal.hide();
                            }
                        }
                    }
                },
                error: function(xhr, status, error) {
                    // Handle errors
                    //enable btn
                    document.getElementById('visit-details-create-visit-btn').disabled=false;

                    console.error("AJAX Error:", status, error);
                }  
            });
        }
    }

    function duplicate(id_visit_service){
       
        var id_visit = $("#visit-details-id-customer-visits").html();  
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : id_visit,  "id_visit_services" : id_visit_service, "duplicate_service": "true"},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {                
                var btn = "btn btn-" +data.message_btn;
                Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });

                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }
        });
    }

    function calculate_discount_apply(){
       
        var total = parseFloat($("#total_price").html());
        var discount_type = $("#visit-details-discount-reasons option:selected").data("discount-type");
        var discount_amount = parseFloat($("#visit-details-discount-reasons option:selected").attr('data-discount'));
        var discount = 0;

        if(discount_type == undefined || null == discount_type){
            return false;
        }

        if(isNaN(discount_amount)){
            discount_amount = 0;
        }

        if(discount_amount <= 0){
            Swal.fire({
                text: "Discount amount cannot be negative.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            $("#visit-details-discount-amount").val("0.00");
            return false;
        }

        if(discount_amount > total){
            Swal.fire({
                text: "Discount amount cannot be greater than the total amount.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            $("#visit-details-discount-amount").val("0.00");
            return false;
        }
        // console.log("Discount Type: " + discount_type);
        // console.log("Discount Amount: " + discount_amount);
        if(discount_type == "percentage"){
            if(discount_amount > 100){
                Swal.fire({
                    text: "Discount percentage cannot be greater than 100%.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                $("#visit-details-discount-amount").val("0.00");
                return false;
            }
            var discount = total * (discount_amount / 100);
            // console.log("Discount Amount: " + discount);
        } else {
            //Amount
            var discount =  discount_amount;
        }

        
        $("#visit-details-modal-discount-value").val(discount.toFixed(2));
    }

    function add_discount(){

        var discount = $("#visit-details-modal-discount-value").val();
        var reason=$("#visit-details-discount-reasons option:selected").text();
         var id_visit = $("#visit-details-id-customer-visits").html();  
        //update the visit 
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : id_visit,  "discount": discount, "reason": reason},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {                
                var btn = "btn btn-" +data.message_btn;
                Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });

                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }

        });

    }

    function add_remarks(){
        
        var remarks=$("#visit-details-visit-remarks").val();
        var id_visit = $("#visit-details-id-customer-visits").html();  

        if(remarks == "" ){
            return false;
        }

        //update the visit 
        $.ajax({
            url : "{{ route('update_visit') }}",
            data: { "id_customer_visits" : id_visit,  "remarks": remarks},
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {                
                var btn = "btn btn-" +data.message_btn;
                Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });

                getvisitdetails();

            },
            error: function(xhr, status, error) {
                // Handle errors
                console.error("AJAX Error:", status, error);
            }

        });
    }

    function remove_advance(id_advance){

        if(null != id_advance && id_advance >0){
           var id_visit = $("#visit-details-id-customer-visits").html();  

            $.ajax({
                url : "{{ route('update_visit') }}",
                data: { "id_customer_visits" : id_visit,  "id_visit_advance": id_advance, "remove_advance" : "true"},
                type: "POST", // The POST method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {                
                    var btn = "btn btn-" +data.message_btn;
                    Swal.fire({
                        text: data.message,
                        icon: data.message_type,
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: btn
                        }
                    });

                    getvisitdetails();

                },
                error: function(xhr, status, error) {
                    // Handle errors
                    console.error("AJAX Error:", status, error);
                }
            });
        }
    }

    function add_advance(){
        //disable btn
        document.getElementById('btn-add-adv').disabled=true;

        var id_visit = $("#visit-details-id-customer-visits").html();

        var advance_amount = $("#visit-details-adv-amount").val();
        var payment_mode = $("#visit-details-adv-mode option:selected").val();
        var advance_comment = $("#visit-details-adv-comment").val();
        var inst_number = $("#visit-details-adv-cc-inst").val();
        var cc_fee = $("#visit-details-adv-ccfee").val();
        var customer_name = $("#visit-details-customer-name").html();
        var id_customer = $("#visit-details-id-customers").html().trim();
        var business_id = "{{ $business->id_business }}";
        console.log("Adding Advance: " + advance_amount + " for visit: " + id_visit + " for customer: " + id_customer);
        $.ajax({
                url : "{{ route('update_visit') }}",
                data: { "id_customer_visits" : id_visit, 'business_id': business_id, 'id_customer': id_customer, 'customer_name': customer_name, "advance_amount": advance_amount, "advance_comment" : advance_comment, "inst_number": inst_number, "cc_fee":cc_fee, "payment_mode" : payment_mode, "add_advance" : "true" },
                type: "POST", // The POST method
                dataType: "json", // Expected data type of the response
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                success: function(data) {                
                    var btn = "btn btn-" +data.message_btn;
                    Swal.fire({
                        text: data.message,
                        icon: data.message_type,
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: btn
                        }
                    });

                    $("#visit-details-adv-amount").val("");                    
                    $("#visit-details-adv-comment").val("");
                    $("#visit-details-adv-ccfee").val("");
                    $("#visit-details-adv-cc-inst").val("");
                    $("#visit-details-adv-mode").prop("selectedIndex", 0).trigger("change");

                    $("#div-cc-inst").addClass("d-none");
                    $("#div-cc-fee").addClass("d-none");

                    //enable btn
                    document.getElementById('btn-add-adv').disabled=false;

                    getvisitdetails();

                },
                error: function(xhr, status, error) {
                    //enable btn
                    document.getElementById('btn-add-adv').disabled=false;
                    // Handle errors
                    console.error("AJAX Error:", status, error);
                }
            });
    }

    function payment_mode_changed(){

        var payment_mode = $("#visit-details-adv-mode option:selected").val();

        $("#visit-details-adv-cc-inst").val("");
        $("#visit-details-adv-ccfee").val("0.00");
        $("#visit-details-adv-amount").val("");
        if(payment_mode=="Cash"){                  
            $("#div-cc-inst").addClass("d-none");
        }else{
            $("#div-cc-inst").removeClass("d-none");                 
        }

        if(payment_mode == "Card"){
            $("#div-cc-fee").removeClass("d-none");            
        }else{
            $("#div-cc-fee").addClass("d-none");
        }

        // if(payment_mode == "D-Card"){
        //     $("#div-cc-fee").removeClass("d-none");            
        // }else{
        //     $("#div-cc-fee").addClass("d-none");
        // }

    }

    function checkAdvanceCCFee(){
        var cc_fee_percent = parseFloat($("#visit-details-adv-ccfee").attr("data-fee-percent"));
        var advance_amount = parseFloat($("#visit-details-adv-amount").val());

        if(isNaN(advance_amount) || advance_amount <= 0){
            $("#visit-details-adv-ccfee").val("0.00");
            return false;
        }

        if(isNaN(cc_fee_percent) || cc_fee_percent <= 0){
            $("#visit-details-adv-ccfee").val("0.00");
            return false;
        }
        if($("#visit-details-adv-mode option:selected").val() == "Card"){
            var cc_fee = (advance_amount * cc_fee_percent) / 100;
            $("#visit-details-adv-ccfee").val(cc_fee.toFixed(2));
        } else {
            $("#visit-details-adv-ccfee").val("0.00");
        }
    }

    function create_order(){
        
        let mode = document.getElementById("visit-details-create-order-btn").textContent;
        console.log("Button Mode: " + mode);
        if(mode == "Product Order"){
            document.getElementById("visit-details-create-order-btn").textContent = "Save Order"     
            //hide other buttons
            document.getElementById("visit-details-create-visit-btn").classList.add('d-none');
            document.getElementById("visit-details-create-voucher-btn").classList.add('d-none');   
            
            //hide customer panel extras
            var extras = document.getElementsByClassName('customer-panel-extras');
            for (var i = 0; i < extras.length; i++) {
                extras[i].classList.add('d-none');
            }

            let Selectedcustomer = $("#visit-details-new-visit-select-customer").select2('data');
            if( Selectedcustomer && Selectedcustomer.length > 0){
                document.getElementById('selected-staff-combo-box-div').classList.remove('d-none');
            }

            //display the product search panel            
            document.getElementById('visit-detail-modal-products-panel').classList.remove('d-none');
            //Hide the service panel
            if(document.getElementById('visit-detail-modal-add-service-panel').classList.contains('d-none') == false){
                document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
            }
            //Set the Create Visit button back to normal
            if(document.getElementById('visit-details-create-visit-btn').textContent != "Create Visit"){
                document.getElementById('visit-details-create-visit-btn').textContent = "Create Visit";
            }
            //Set the focus to the product search
            setTimeout(function(){
                $("#visit-details-modal-product-search").select2('open');
            }, 500);
            return false;
        } else {
            //document.getElementById("visit-details-create-order-btn").textContent = "Create Order"
            //Save the order using Post
            //get customer id from select2 customer select
            let customer = $("#visit-details-new-visit-select-customer").select2('data');
        
             //Validations
            if(!customer || customer.length === 0){
                Swal.fire({
                    text: "Please select a customer for the order.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                return false;
            }
            var customer_id = customer[0].id;
            var customer_name = customer[0].text;

            var staff = $("#visit-details-new-visit-selected-staff").select2('data');
            var staff_id = staff.length > 0 ? staff[0].id : null;
            var staff_name = staff.length > 0 ? staff[0].text : null;
            console.log("Selected Staff: " + staff_id + " - " + staff_name);

            var products = [];
            //pluck the product details from the table
            $("#visit-details-modal-products-tbody tr").each(function(){
                var product = {
                    "product_id": $(this).data('id-product'),
                    "product_name": $(this).find('td').eq(1).text(),
                    "product_brand": $(this).find('td').eq(2).text(),
                    "batch_id": $(this).find('td').eq(3).text(),
                    "batch_no": $(this).find('td').eq(3).attr('data-batch-no'),
                    "quantity": parseInt($(this).find('td').eq(4).text()),
                    "price": parseFloat($(this).find('td').eq(5).text()),
                    "customer_id": customer_id,
                    "customer_name": customer_name,
                    "staff_id": staff_id,
                    "staff_name": staff_name
                };
                products.push(product);
            });
            if(products.length < 1){
                Swal.fire({
                    text: "Please add at least one product to the order.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                return false;
            }

            //disable btn
            document.getElementById('visit-details-create-order-btn').disabled=true;

            console.log("Creating Order for Customer: " + customer_id + " with products: ", products);
            fetch("{{ route('create_product_order') }}", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                body: JSON.stringify({
                    customer_id: customer_id,
                    customer_name: customer_name,
                    products: products
                })
            }).then(response => response.json())
            .then(data => {
                var btn = "btn btn-" +data.message_btn;
                Swal.fire({
                    text: data.message,
                    icon: data.message_type,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: btn
                    }
                });

                //enable btn
                document.getElementById('visit-details-create-order-btn').disabled=false;

                if(data.message_type == "success"){
                   // toastr.success('Order Created Successfully. Order ID: ' + data.order_id, 'Success', {timeOut: 5000});
                    
                    var url = "{{ url('new_retail_invoice') }}" + "/" + data.order_id;
                    window.open(url, '_blank');

                    //Hide the product panel
                    document.getElementById('visit-detail-modal-products-panel').classList.add('d-none');
                    //Change the Create Order Button back to normal
                    document.getElementById('visit-details-create-order-btn').textContent = "Product Order";

                    //Reset the form
                    // $("#visit-details-modal-customer-select").val(null).trigger('change');
                    $("#visit-details-modal-product-search").val(null).trigger('change');
                    
                    $("#visit-details-modal-product-id").val("");
                    $("#visit-details-modal-product-name").val("");
                    $("#visit-details-modal-product-brand").val("");
                    $("#visit-details-modal-product-batch-id").val("");
                    $("#visit-details-modal-product-batch-no").val("");
                    $("#visit-details-modal-product-price").val("");
                    $("#visit-details-modal-product-measure-unit").val("");
                    $("#visit-details-modal-product-qty-per-unit").val("");
                    $("#visit-details-modal-product-quantity").val("1");
                    $("#visit-details-modal-products-tbody").html("");
                    
                }

            }).catch((error) => {
                //enable btn
                document.getElementById('visit-details-create-order-btn').disabled=false;
                console.error("Error:", error);
            });

        }

        
    }

    function update_product_details(){
        //pluck the product details from the selected option
        var product = $("#visit-details-modal-product-search").select2('data');
        console.log(product[0]);
        if(product[0].id != "" && product[0].id != null){
            $("#visit-details-modal-product-id").val(product[0].id);
            $("#visit-details-modal-product-name").val(product[0].product);
            $("#visit-details-modal-product-brand").val(product[0].brand);
            $("#visit-details-modal-product-batch-id").val(product[0].batch_id);
            $("#visit-details-modal-product-batch-no").val(product[0].batch_no);
            $("#visit-details-modal-product-price").val(parseFloat(product[0].price).toFixed(2));
            $("#visit-details-modal-product-measure-unit").val(product[0].measure_unit);
            $("#visit-details-modal-product-qty-per-unit").val(product[0].qty_per_unit);
            $("#visit-details-modal-product-quantity").val(1);
        }
    }

    function add_product_to_product_table(){
        var product_id = $("#visit-details-modal-product-id").val();
        var product_name = $("#visit-details-modal-product-name").val();
        var product_brand = $("#visit-details-modal-product-brand").val();
        var product_batch_id = $("#visit-details-modal-product-batch-id").val();
        var product_batch_no = $("#visit-details-modal-product-batch-no").val();
        var product_price = parseFloat($("#visit-details-modal-product-price").val());
        var product_qty_per_unit = parseFloat($("#visit-details-modal-product-qty-per-unit").val());
        var product_measure_unit = $("#visit-details-modal-product-measure-unit").val();
        var product_quantity = parseInt($("#visit-details-modal-product-quantity").val());
        
        if(product_id == "" || product_id == null){
            Swal.fire({
                text: "Please select a product to add.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        if(isNaN(product_quantity) || product_quantity <= 0){
            Swal.fire({
                text: "Please enter a valid quantity.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        if(isNaN(product_price) || product_price < 0){
            Swal.fire({
                text: "Please enter a valid price.",
                icon: "info",
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: "btn btn-info"
                }
            });
            return false;
        }

        var total_price = product_price * product_quantity;

        //Add to the table
        var newRow = '<tr data-id-product="' + product_id + '">' +
                        '<td>' + product_id + '</td>' +
                        '<td>' + product_name + '</td>' +
                        '<td>' + product_brand + '</td>' +
                        '<td data-batch-no="' + product_batch_no + '">' + product_batch_id + '</td>' +
                        '<td class="text-end">' + product_quantity + '</td>' +
                        '<td class="text-end">' + product_price.toFixed(2) + '</td>' +
                        '<td class="text-end">' + total_price.toFixed(2) + '</td>' +
                        '<td class="text-center"><button class="btn btn-sm btn-danger" onclick="remove_product_from_table(this);"><i class="ti ti-trash"></i></button></td>' +
                    '</tr>';

        $("#visit-details-modal-products-tbody").append(newRow);
    }

    function remove_product_from_table(button){
        //Remove the row
        $(button).closest('tr').remove();
    }

    function openCustomerAccount(){
        var id_customer = $("#visit-details-id-customers").html();
        if(id_customer != "" && id_customer != null){
            var baseUrl = (typeof baseURL !== 'undefined' ? baseURL : '{{ url("") }}');
            var url = baseUrl + "/open_customer_account/" + id_customer;
            //open in new window
            window.open(url, '_blank');
        }
    }

    function openConsentForms(){
        var customer_id = $("#visit-details-id-customers").html();
        var visit_id = $("#visit-details-id-customer-visits").html();
        var customer_name = $("#visit-details-customer-name").html();
        console.log("Opening Consent Forms for Customer ID: " + customer_id + " Visit ID: " + visit_id + " Customer Name: " + customer_name);

        //pass these as query params

        var url = baseURL +"/consent_forms?customer_id=" + customer_id + "&visit_id=" + visit_id + "&customer_name=" + encodeURIComponent(customer_name);
        //open in new window
        window.open(url, 'consentFormsWindow');

    }

    function open_new_customer_modal(){
        //Close the visit details modal
        // var visitModalEl = document.getElementById('visit-details-modal');
        // if (visitModalEl) {
        //     var visitModal = bootstrap.Modal.getInstance(visitModalEl);
        //     if (visitModal) {
        //         visitModal.hide();
        //     }
        // }

        //if visit-details-new-visit-select-customer has a numeric value in the search input then set it as the default value in the customer cell of the add modal
        let selectedCustomer = $("#temp_customer_search_value").val();
        console.log("Selected Customer: " + selectedCustomer);
        if($.isNumeric(selectedCustomer)){
            $("#customer_cell").val(selectedCustomer);
        } else {
            $("#customer_name").val(selectedCustomer);
        }

        //Open the customer add modal
        var customerModalEl = document.getElementById('customerAddModal');
        if (customerModalEl) {
            var customerModal = new bootstrap.Modal(customerModalEl, {
                backdrop: 'static',
                keyboard: false
            });
            customerModal.show();
        }
    }

    function getSelect2SearchValue(selectId) {
        const select2 = $(selectId).data('select2');
        if (!select2 || !select2.dropdown || !select2.dropdown.$search) {
            return null;
        }

        const val = select2.dropdown.$search.val();
        return $.isNumeric(val) ? val : null;
    }


    function create_gift_voucher(){
        let mode = document.getElementById("visit-details-create-voucher-btn").textContent;
        console.log("Button Mode: " + mode);
        if(mode == "Create Voucher"){
            document.getElementById("visit-details-create-voucher-btn").textContent = "Save Voucher"    
            
            //hide other buttons
            document.getElementById("visit-details-create-visit-btn").classList.add('d-none');
            document.getElementById("visit-details-create-order-btn").classList.add('d-none');
            
            //hide customer panel extras
            var extras = document.getElementsByClassName('customer-panel-extras');
            for (var i = 0; i < extras.length; i++) {
                extras[i].classList.add('d-none');
            }

            //default voucher type to amount
            document.getElementById("gift_voucher_type_amount").checked = true;

            //display the voucher creation panel
            
            document.getElementById('visit-detail-modal-gift-voucher-panel').classList.remove('d-none');
            //Hide the service panel
            if(document.getElementById('visit-detail-modal-add-service-panel').classList.contains('d-none') == false){
                document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
            }
            //Set the Create Visit button back to normal
            if(document.getElementById('visit-details-create-visit-btn').textContent != "Create Visit"){
                document.getElementById('visit-details-create-visit-btn').textContent = "Create Visit";
            }
            return false;
        } else {
            //Save the voucher using Post
            //disable btn
            document.getElementById('visit-details-create-voucher-btn').disabled=true;
            //get customer id from the select2 selected customer
     
            let customer = $("#visit-details-new-visit-select-customer").select2('data');
            if(!customer || customer.length === 0){
                Swal.fire({
                    text: "Please select a customer for the order.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                //enable btn
                document.getElementById('visit-details-create-voucher-btn').disabled=false;
                return false;
            }
            var id_customer = customer[0].id; 
            let amount_or_service_price = parseFloat($("#visit-details-modal-gift-voucher-paid").val());
            
            let gift_voucher_type = document.querySelector('input[name="gift_voucher_type"]:checked').value;
            let services = "";
            let service_names = "";
            if(gift_voucher_type == "service"){
                //pluck the selected services from the table
                let total=0;
                $("#visit-details-modal-selected-services-table tbody tr").each(function(index){
                    //get from td 0 data-id-service
                    let service = $(this).find('td:eq(0)').data('id-business-services');
                    let service_name = $(this).find('td:eq(0)').data('service-name');
                    let service_price = $(this).find('td:eq(1)').text();

                    if(index > 0){
                        services = services + "|";
                        service_names = service_names + "|";
                    }                   
                    services = services + service;                    
                    service_names = service_names + service_name;
                    total += parseFloat(service_price);
                });
                if(services.length < 1){
                    Swal.fire({
                        text: "Please add at least one service for the service voucher.",
                        icon: "info",
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: "btn btn-info"
                        }
                    });
                    //enable btn
                    document.getElementById('visit-details-create-voucher-btn').disabled=false;
                    return false;
                } else {
                    //put total service price in amount_or_service_price
                    amount_or_service_price = total;
                }
                $("#visit-details-modal-gift-voucher-paid").val(amount_or_service_price.toFixed(2));
                gift_voucher_paid_amount_changed();
            }
            
            let tax = parseFloat($("#visit-details-modal-gift-voucher-tax").val());
            let cc_fee = parseFloat($("#visit-details-modal-gift-voucher-cc-fee").val());
            let payment_mode = $("#visit-details-modal-gift-voucher-payment-mode option:selected").val();
            let instrument_number = $("#visit-details-modal-gift-voucher-instrument").val();
            let voucher_heading = $("#visit-details-modal-gift-voucher-heading").val();
            let valid_until = $("#visit-details-modal-gift-voucher-validity").val();
            
            //validate valid_until
            if(valid_until == "" || valid_until == null){
                Swal.fire({
                    text: "Please select a valid 'Valid Until' date for the voucher.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                //enable btn
                document.getElementById('visit-details-create-voucher-btn').disabled=false;
                return false;
            }

            //if payment mode is not cash, validate instrument number
            if(payment_mode != "Cash"){
                if(instrument_number == "" || instrument_number == null){
                    Swal.fire({
                        text: "Please enter the instrument number for the selected payment mode.",
                        icon: "info",
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: "btn btn-info"
                        }
                    });
                    //enable btn
                    document.getElementById('visit-details-create-voucher-btn').disabled=false;
                    return false;
                }
            }

            //validate amount_or_service_price
            if(isNaN(amount_or_service_price) || amount_or_service_price <= 0){
                Swal.fire({
                    text: "Please enter a valid amount/service price for the voucher.",
                    icon: "info",
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: "btn btn-info"
                    }
                });
                //enable btn
                document.getElementById('visit-details-create-voucher-btn').disabled=false;
                return false;
            }

            let data = {
                id_customer: id_customer,
                services: services,
                service_names: service_names,
                gift_voucher_type: gift_voucher_type,
                amount_or_service_price: amount_or_service_price,
                tax: tax,
                cc_fee: cc_fee,
                payment_mode: payment_mode,
                instrument_number: instrument_number,
                voucher_heading: voucher_heading,
                valid_until: valid_until
            };

            console.log("Saving Voucher: ", data);

            $.ajax({
                url: "{{ route('create_gift_voucher') }}",
                type: "POST",
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'),
                    data: data
                },
                success: function(response) {
                    var btnClass = response.message_btn;

                    Swal.fire({
                        text: response.message,
                        icon: response.message_type,
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: btnClass
                        }
                    });

                    // Enable button
                    const createVoucherBtn = document.getElementById('visit-details-create-voucher-btn');
                    createVoucherBtn.disabled = false;
                    data=response.data;
                    console.log(response);
                    console.log(data);
                    if (response.message_type === "success") {
                        // Reset the voucher form
                        $("#visit-details-modal-gift-voucher-paid").val("");
                        $("#visit-details-modal-gift-voucher-tax").val("0.00");
                        $("#visit-details-modal-gift-voucher-cc-fee").val("0.00");
                        $("#visit-details-modal-gift-voucher-instrument").val("");

                        // Hide the voucher panel
                        document.getElementById('visit-detail-modal-gift-voucher-panel').classList.add('d-none');

                        // Reset button text
                        createVoucherBtn.textContent = "Create Voucher";

                        // Show other buttons
                        document.getElementById("visit-details-create-visit-btn").classList.remove('d-none');
                        document.getElementById("visit-details-create-order-btn").classList.remove('d-none');

                        // Show customer panel extras
                        const extras = document.getElementsByClassName('customer-panel-extras');
                        for (let i = 0; i < extras.length; i++) {
                            extras[i].classList.remove('d-none');
                        }
                        //Close the modal
                        var visitModalEl = document.getElementById('visit-details-modal');
                        if (visitModalEl) {
                            var visitModal = bootstrap.Modal.getInstance(visitModalEl);
                            if (visitModal) {
                                visitModal.hide();
                            }
                        }
                        //open the voucher print page in new tab                        
                        var url = "{{ route('gift_voucher_print', ['id_gift_voucher' => ':id']) }}";
                        url = url.replace(':id', data.id_order_vouchers);

                        window.open(url, '_blank');
                    }
                },
                error: function(xhr, status, error) {
                    document.getElementById('visit-details-create-voucher-btn').disabled = false;
                    console.error("Error:", error);

                    Swal.fire({
                        text: "An error occurred while creating the voucher. Please try again.",
                        icon: "error",
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: "btn btn-danger"
                        }
                    });
                }
            });
        }
    }

    function gift_voucher_type_changed(){
        let type = document.querySelector('input[name="gift_voucher_type"]:checked').value;
        if(type == "amount"){            
             //Hide the service panel
            if(document.getElementById('visit-detail-modal-add-service-panel').classList.contains('d-none') == false){
                document.getElementById('visit-detail-modal-add-service-panel').classList.add('d-none');
            }
        } else {
            //Hide Add Service Button
            $(".btn-back").addClass('d-none');
            $(".cross-sell").addClass('d-none');

            // show service panel
            if(document.getElementById('visit-detail-modal-add-service-panel').classList.contains('d-none') == true){
                document.getElementById('visit-detail-modal-add-service-panel').classList.remove('d-none');
            }
        }
    }

    function gift_voucher_payment_mode_changed(){

        var payment_mode = $("#visit-details-modal-gift-voucher-payment-mode option:selected").val();

        $("#visit-details-modal-gift-voucher-tax").val("0.00");
        $("#visit-details-modal-gift-voucher-cc-fee").val("0.00");
        $("#visit-details-modal-gift-voucher-paid").val("");
        $("#visit-details-modal-gift-voucher-instrument").val("");

        if(payment_mode=="Card"){                  
            $("#visit-details-modal-gift-voucher-cc-fee").removeClass("d-none");
            $("#visit-details-modal-gift-voucher-instrument").removeClass("d-none");
        }else{
            $("#visit-details-modal-gift-voucher-cc-fee").addClass("d-none");    
            $("#visit-details-modal-gift-voucher-instrument").addClass("d-none");             
        }
    }

   function gift_voucher_paid_amount_changed(){
        var cc_fee_percent = parseFloat($("#business-cc-fee-percent").val());
        var paid_amount = parseFloat($("#visit-details-modal-gift-voucher-paid").val() || 0);

        if(isNaN(paid_amount) || paid_amount <= 0){
            $("#visit-details-modal-gift-voucher-cc-fee").val("0.00");
             $("#visit-details-modal-gift-voucher-tax").val("0.00");
            return false;
        }

        if(isNaN(cc_fee_percent) || cc_fee_percent <= 0){
            $("#visit-details-modal-gift-voucher-cc-fee").val("0.00");
             $("#visit-details-modal-gift-voucher-tax").val("0.00");
            return false;
        }
        if($("#visit-details-modal-gift-voucher-payment-mode option:selected").val() == "Card"){
            var cc_fee = (paid_amount * cc_fee_percent) / 100;
            $("#visit-details-modal-gift-voucher-cc-fee").val(cc_fee.toFixed(2));
        } else {
            $("#visit-details-modal-gift-voucher-cc-fee").val("0.00");
        }

        //calculate tax if applicable
        var tax_percent = parseFloat($("#business-tax-voucher").val());
        if(isNaN(tax_percent) || tax_percent <= 0){
            $("#visit-details-modal-gift-voucher-tax").val("0.00");
            return false;
        } else {
            var tax = (paid_amount * tax_percent) / 100;
            $("#visit-details-modal-gift-voucher-tax").val(tax.toFixed(2));
        }
        var total_gift_voucher_amount = ( parseFloat($("#visit-details-modal-gift-voucher-tax").val() || 0) + parseFloat($("#visit-details-modal-gift-voucher-cc-fee").val() || 0) + parseFloat(paid_amount) );
        $("#visit-details-modal-gift-voucher-total-amount").val(parseFloat(total_gift_voucher_amount).toFixed(2));

   }

</script>
