@extends('layouts.horizontal', ['title' => 'My Account', 'topbarTitle' => 'My Account'])

@section('css')
@vite(['node_modules/dropzone/dist/dropzone.css'])
@endsection

@section('content')

<div class="row">
    <div class="col-md-8">
        <!-- Profile Header Card -->
        <div class="card">
            <div class="bg-picture card-body">
                <div class="d-flex align-items-center">
                    <img id="profileImagePreview" 
                         src="{{ asset('images/users/' . ($user->user_image ?? 'avatar-1.jpg')) }}"
                         class="flex-shrink-0 rounded-circle avatar-xl img-thumbnail float-start me-3"
                         alt="profile-image"
                         style="cursor: pointer; object-fit: cover;"
                         onclick="openImageModal()">

                    <div class="flex-grow-1 overflow-hidden align-items-center">
                        <h4 class="m-0 lh-base">{{ $user->user_fullname ?? 'User' }}</h4>
                        <p class="text-muted"><i>{{ session('user_role') ?? 'User' }}</i></p>
                        <p class="mb-2"></p>
                        <div class="d-flex gap-2 mb-2">
                            @if($user->user_email)
                            <span class="text-muted"><i class="ri-mail-line me-1"></i>{{ $user->user_email }}</span>
                            @endif
                            @if($user->user_mobile)
                            <span class="text-muted"><i class="ri-phone-line me-1"></i>{{ $user->user_mobile }}</span>
                            @endif
                        </div>
                        <!-- <button type="button" class="btn btn-primary btn-sm mt-2" onclick="openImageModal()">
                            <i class="ri-image-add-line me-1"></i> Change Picture
                        </button> -->
                        <input type="hidden" id="user_image" name="user_image" value="{{ $user->user_image ?? 'avatar-1.jpg' }}">
                    </div>

                    <div class="clearfix"></div>
                </div>
            </div>
        </div>

        @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show mt-3" role="alert">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        @endif

        <!-- Account Details Card -->
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4">Account Details</h4>
                <form id="myAccountForm" method="POST" action="{{ route('my-account.update') }}">
                    @csrf
                    
                    <!-- Hidden input for user image - must be inside the form to be submitted -->
                    <input type="hidden" id="form_user_image" name="user_image" value="{{ $user->user_image ?? 'avatar-1.jpg' }}">

                    <!-- <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="user_id" class="form-label">User ID</label>
                            <input type="text" class="form-control bg-light" id="user_id" value="{{ $user->id_users }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="user_name" class="form-label">User Name</label>
                            <input type="text" class="form-control bg-light" id="user_name" value="{{ $user->user_name }}" readonly>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="user_fullname" class="form-label">Full Name</label>
                            <input type="text" class="form-control bg-light" id="user_fullname" value="{{ $user->user_fullname }}" readonly>
                        </div>
                    </div> -->

                    <!-- Password Section -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="new_password" class="form-label">New Password</label>
                            <input type="password" class="form-control" id="new_password" name="new_password" placeholder="Leave blank to keep current password">
                            <small class="text-muted">Leave blank if you don't want to change your password</small>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="confirm_password" class="form-label">Confirm New Password</label>
                            <input type="password" class="form-control" id="confirm_password" name="confirm_password" placeholder="Confirm new password">
                        </div>
                    </div>

                    <!-- Email - Changeable -->
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="user_email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="user_email" name="user_email" value="{{ $user->user_email }}">
                        </div>

                        <!-- Mobile - Changeable -->
                        <div class="col-md-6 mb-3">
                            <label for="user_mobile" class="form-label">Mobile</label>
                            <input type="text" class="form-control" id="user_mobile" name="user_mobile" value="{{ $user->user_mobile }}">
                        </div>
                    </div>

                    <!-- Address - Changeable -->
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label for="user_address" class="form-label">Address</label>
                            <textarea class="form-control" id="user_address" name="user_address" rows="3">{{ $user->user_address }}</textarea>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="row">
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="ri-save-line me-1"></i> Save Changes
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <!-- Account Information Card -->
        <div class="card overflow-hidden">
            <div class="card-header d-flex justify-content-between align-items-center border-bottom border-dashed">
                <h4 class="header-title mb-0">Account Information</h4>
            </div>

            <ul class="list-group mb-0 list-group-flush">
                <li class="list-group-item border-light">
                    <div class="d-flex align-items-center gap-2">
                        <div class="me-1">
                            <i class="ri-user-line text-primary"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">User ID</h5>
                            <span class="text-muted fs-12">{{ $user->id_users }}</span>
                        </div>
                    </div>
                </li>

                <li class="list-group-item border-light">
                    <div class="d-flex align-items-center gap-2">
                        <div class="me-1">
                            <i class="ri-at-line text-info"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">Username</h5>
                            <span class="text-muted fs-12">{{ $user->user_name }}</span>
                        </div>
                    </div>
                </li>

                <li class="list-group-item border-light">
                    <div class="d-flex align-items-center gap-2">
                        <div class="me-1">
                            <i class="ri-shield-user-line text-success"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">Role</h5>
                            <span class="text-muted fs-12">{{ session('user_role') ?? 'User' }}</span>
                        </div>
                    </div>
                </li>

                @if($user->user_email)
                <li class="list-group-item border-light">
                    <div class="d-flex align-items-center gap-2">
                        <div class="me-1">
                            <i class="ri-mail-line text-danger"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">Email</h5>
                            <span class="text-muted fs-12">{{ $user->user_email }}</span>
                        </div>
                    </div>
                </li>
                @endif

                @if($user->user_mobile)
                <li class="list-group-item border-light">
                    <div class="d-flex align-items-center gap-2">
                        <div class="me-1">
                            <i class="ri-phone-line text-warning"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">Mobile</h5>
                            <span class="text-muted fs-12">{{ $user->user_mobile }}</span>
                        </div>
                    </div>
                </li>
                @endif
            </ul>
        </div>

        <!-- Quick Actions Card -->
        <div class="card overflow-hidden mt-3">
            <div class="card-header d-flex justify-content-between align-items-center border-bottom border-dashed">
                <h4 class="header-title mb-0">Quick Actions</h4>
            </div>

            <ul class="list-group mb-0 list-group-flush">
                <li class="list-group-item border-light">
                    <a href="#" class="d-flex align-items-center gap-2 text-reset text-decoration-none" onclick="openImageModal(); return false;">
                        <div class="me-1">
                            <i class="ri-image-add-line text-primary"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">Change Profile Picture</h5>
                            <span class="text-muted fs-12">Update your profile image</span>
                        </div>
                    </a>
                </li>

                <!-- <li class="list-group-item border-light">
                    <a href="#" class="d-flex align-items-center gap-2 text-reset text-decoration-none" onclick="document.getElementById('new_password').focus(); return false;">
                        <div class="me-1">
                            <i class="ri-lock-password-line text-info"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">Change Password</h5>
                            <span class="text-muted fs-12">Update your account password</span>
                        </div>
                    </a>
                </li>

                <li class="list-group-item border-light">
                    <a href="#" class="d-flex align-items-center gap-2 text-reset text-decoration-none" onclick="document.getElementById('user_email').focus(); return false;">
                        <div class="me-1">
                            <i class="ri-mail-settings-line text-success"></i>
                        </div>
                        <div>
                            <h5 class="mb-0">Update Email</h5>
                            <span class="text-muted fs-12">Change your email address</span>
                        </div>
                    </a>
                </li> -->
            </ul>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="imageModalLabel">Select or Upload Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="imageDropzone" 
                  data-action="{{ route('my-account.upload-image') }}"
                  data-preview-base="{{ asset('images/users') }}">
                @csrf
                <div class="modal-body">
                    <h6>Choose Existing Image:</h6>
                    <div id="existingImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                        <!-- Existing images will be loaded here -->
                    </div>
                    
                    <input type="hidden" id="existing_image" name="existing_image">
                    <h6>Or Upload New Image:</h6>
                    <div id="dropzoneContainer" style="min-height: 200px; border: 2px dashed #dee2e6; border-radius: 8px; padding: 20px; text-align: center; cursor: pointer;">
                        <div class="dz-message needsclick">
                            <i class="ti ti-cloud-upload h1 text-muted"></i>
                            <h3>Drop files here or click to upload.</h3>
                            <span class="text-muted fs-13">(This is your dropzone. Selected files are
                                <strong>stored</strong> on the server.)</span>
                        </div>
                        <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                    </div>
                    <input type="hidden" name="user_image" id="user_image_upload">
                    <div id="selectedPreview" class="mt-3"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="saveImageSelection()">Done</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    // Global variable to store Dropzone instance
    var imageDropzoneInstance = null;

    // Function to initialize Dropzone when modal opens
    function initializeDropzone() {
        // Check if Dropzone is available
        if (typeof Dropzone === 'undefined' || typeof window.Dropzone === 'undefined') {
            console.warn('Dropzone is not available. Image upload will not work.');
            return;
        }

        // Disable autoDiscover
        Dropzone.autoDiscover = false;
        window.Dropzone.autoDiscover = false;

        // Get the container element (use the div inside modal-body, not the form)
        var dropzoneContainer = document.getElementById('dropzoneContainer');
        if (!dropzoneContainer) {
            console.warn('Dropzone container not found.');
            return;
        }

        var imageDropzoneEl = document.getElementById('imageDropzone');
        if (!imageDropzoneEl) {
            console.warn('Dropzone form element not found.');
            return;
        }

        // Destroy existing Dropzone instance if it exists
        if (imageDropzoneInstance) {
            imageDropzoneInstance.destroy();
            imageDropzoneInstance = null;
        }

        // Get CSRF token
        var csrfToken = document.querySelector('meta[name="csrf-token"]');
        var token = csrfToken ? csrfToken.getAttribute('content') : '';

        // Initialize Dropzone on the container div, not the form
        imageDropzoneInstance = new Dropzone(dropzoneContainer, {
            url: imageDropzoneEl.dataset.action,
            paramName: "file",
            maxFilesize: 2, // MB
            acceptedFiles: ".jpg,.jpeg,.png,.gif",
            addRemoveLinks: true,
            clickable: dropzoneContainer, // Make the entire container clickable
            autoProcessQueue: true,
            previewsContainer: document.getElementById('uploadPreviewTemplate'),
            headers: {
                'X-CSRF-TOKEN': token
            },
            dictDefaultMessage: `
                <i class="ti ti-cloud-upload h1 text-muted"></i>
                <h3>Drop files here or click to upload.</h3>
            `,
            init: function () {
                var dropzone = this;

                dropzone.on("success", function (file, response) {
                    // Handle response - check if it's a string or object
                    var filename = typeof response === 'string' ? response : (response.filename || response.name || '');
                    
                    if (filename) {
                        // Save filename into hidden input
                        document.getElementById('user_image_upload').value = filename;
                        
                        // Clear existing image selection
                        document.getElementById('existing_image').value = "";

                        // Immediately update the form field so it's ready when user clicks Save Changes
                        var formUserImageInput = document.getElementById('form_user_image');
                        var displayUserImageInput = document.getElementById('user_image');
                        if (formUserImageInput) {
                            formUserImageInput.value = filename;
                        }
                        if (displayUserImageInput) {
                            displayUserImageInput.value = filename;
                        }

                        // Show preview
                        var previewBase = imageDropzoneEl.dataset.previewBase;
                        document.getElementById('selectedPreview').innerHTML =
                            `<img src="${previewBase}/${filename}" width="120" class="border rounded">`;
                            
                        // Update profile preview immediately
                        var profilePreview = document.getElementById('profileImagePreview');
                        if (profilePreview) {
                            profilePreview.src = previewBase + '/' + filename;
                        }
                    }
                });

                dropzone.on("error", function (file, errorMessage) {
                    console.error("Dropzone upload error:", errorMessage);
                    var errorMsg = typeof errorMessage === 'string' ? errorMessage : (errorMessage.message || 'Upload failed');
                    if (typeof toastr !== 'undefined') {
                        toastr.error("Error uploading image: " + errorMsg);
                    } else {
                        alert("Error uploading image: " + errorMsg);
                    }
                });

                dropzone.on("addedfile", function(file) {
                    // Clear existing image selection when new file is added
                    document.getElementById('existing_image').value = "";
                });
            }
        });
    }

    // Load existing images and initialize Dropzone when modal opens
    document.getElementById('imageModal').addEventListener('show.bs.modal', function () {
        // Initialize Dropzone when modal is shown
        initializeDropzone();
        
        fetch("{{ route('my-account.existing-images') }}")
            .then(res => res.json())
            .then(urls => {
                const container = document.getElementById('existingImages');
                container.innerHTML = '';
                
                urls.forEach(url => {
                    const filename = url.split('/').pop();
                    const img = document.createElement('img');
                    img.src = url;
                    img.width = 80;
                    img.height = 80;
                    img.className = 'border rounded cursor-pointer';
                    img.style.cursor = 'pointer';
                    img.dataset.filename = filename;
                    img.style.objectFit = 'cover';
                    
                    img.addEventListener('click', function() {
                        // Remove border from all images
                        container.querySelectorAll('img').forEach(i => {
                            i.style.border = '1px solid #dee2e6';
                        });
                        
                        // Add border to selected image
                        this.style.border = "3px solid blue";
                        
                        var selectedFilename = this.dataset.filename;
                        document.getElementById('existing_image').value = selectedFilename;
                        document.getElementById('user_image_upload').value = ""; // Clear uploaded image
                        document.getElementById('selectedPreview').innerHTML = 
                            `<img src="${url}" width="120" class="border rounded">`;
                        
                        // Immediately update the form field so it's ready when user clicks Save Changes
                        var formUserImageInput = document.getElementById('form_user_image');
                        var displayUserImageInput = document.getElementById('user_image');
                        if (formUserImageInput) {
                            formUserImageInput.value = selectedFilename;
                        }
                        if (displayUserImageInput) {
                            displayUserImageInput.value = selectedFilename;
                        }
                        
                        // Update preview immediately
                        var profilePreview = document.getElementById('profileImagePreview');
                        if (profilePreview) {
                            profilePreview.src = url;
                        }
                    });
                    
                    container.appendChild(img);
                });
            })
            .catch(err => console.error("Image fetch error:", err));
    });

    // Function to save image selection
    function saveImageSelection() {
        let imageName = document.getElementById('existing_image').value || document.getElementById('user_image_upload').value;
        
        if (imageName) {
            // Update the hidden input INSIDE the form (this is what gets submitted)
            var formUserImageInput = document.getElementById('form_user_image');
            if (formUserImageInput) {
                formUserImageInput.value = imageName;
            }
            
            // Also update the one outside the form for display purposes
            var displayUserImageInput = document.getElementById('user_image');
            if (displayUserImageInput) {
                displayUserImageInput.value = imageName;
            }
            
            // Update profile image preview
            var profilePreview = document.getElementById('profileImagePreview');
            if (profilePreview) {
                var previewBase = document.getElementById('imageDropzone').dataset.previewBase;
                profilePreview.src = previewBase + '/' + imageName;
            }
        }
        
        var myModal = bootstrap.Modal.getInstance(document.getElementById('imageModal'));
        if (myModal) {
            myModal.hide();
        }
    }

    function openImageModal() {
        document.getElementById('existing_image').value = "";
        document.getElementById('user_image_upload').value = "";
        document.getElementById('selectedPreview').innerHTML = "";
        
        // Clear any existing Dropzone files
        if (imageDropzoneInstance) {
            imageDropzoneInstance.removeAllFiles(true);
        }
        
        var myModal = new bootstrap.Modal(document.getElementById('imageModal'));
        myModal.show();
    }

    // Form validation and ensure user_image is included
    document.getElementById('myAccountForm').addEventListener('submit', function(e) {
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = document.getElementById('confirm_password').value;
        
        // Ensure user_image is synced from display input to form input before submission
        var displayUserImage = document.getElementById('user_image');
        var formUserImage = document.getElementById('form_user_image');
        if (displayUserImage && formUserImage && displayUserImage.value) {
            formUserImage.value = displayUserImage.value;
        }
        
        if (newPassword || confirmPassword) {
            if (newPassword !== confirmPassword) {
                e.preventDefault();
                toastr.error('Password and confirmation do not match.');
                return false;
            }
            
            if (newPassword.length > 0 && newPassword.length < 6) {
                e.preventDefault();
                toastr.error('Password must be at least 6 characters long.');
                return false;
            }
        }
    });
</script>
@endsection
