@extends('layouts.horizontal', ['title' => 'Branch Requisitions', 'topbarTitle' => 'Branch Requisitions'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="Requisition-page">
     <div class="container-fluid">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Branch Requisitions</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @if (session('ho') !='Yes')
                        <a href="{{ route('branch_requisitions.add_new_requisition') }}" class="btn  btn-outline-success me-3a">
                            <iconify-icon icon="mdi:plus" width="16" height="16" class="me-1"></iconify-icon>
                            Add New Requisition
                        </a>
                    @endif
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    @if(session('ho')=="Yes")
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Filter Products</div>
                    <form id="filterform">
                        <div class="row gap-1">          
                            <div class="col-md-3">
                                <input type="hidden" name="ho" id="ho" value="{{ $ho }}">
                                <label class="form-label" for="business_type">Select  Branch Type</label>
                                <select id="business_type" name="business_type_id" class="form-select">  
                                    <option value="">-- All Business Types --</option>                                  
                                    @foreach($business_types as $type)
                                        <option value="{{ $type->id_business_type }}" @if($type->id_business_type == $business_type_id) selected @endif>{{ $type->business_type }}</option>
                                    @endforeach
                                </select>
                            </div>                           
                                              
                            <div class="col-md-3">
                                <label class="form-label" for="branch_id">Select  Branch</label>
                                <select id="branch_id" name="business_id" class="form-select">  
                                    <option value="">-- All Branches --</option>                                  
                                    @foreach($branches as $branch)
                                        <option value="{{ $branch->id_business }}" @if($branch->id_business == $business_id) selected @endif>{{ $branch->business_name }}</option>
                                    @endforeach
                                </select>
                            </div>                           
                            
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="button" id="filterButton" class="btn btn-ghost-primary btn-icon rounded-circle btn-sm mt-3">
                                    <iconify-icon icon="mdi:refresh" width="30px" ></iconify-icon>
                                </button>
                            </div>                           
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> <!-- end row-->
    @else
    <input type="hidden" name="business_id" id="branch_id" value="{{session('business_id')}}">
    @endif

    
   

    <!-- Requisitions Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="branchRequisitionsTable" class="table table-bordered table-sm dt-responsive fs-12 w-100">
                        <thead>
                            <tr>
                                <th>Req.#</th>
                                <th>Branch</th>
                                <th>Requested By</th>
                                <th>Requisition Date</th>
                                <th>Product ID</th>
                                <th>Product Name</th>
                                <th>Required Total</th>
                                <th>Transferred Total</th>
                                <th>Pending Total</th>
                                <th>Requisition Status</th>
                                <th>Details</th>
                            </tr>
                        </thead>

                        <tbody>
                            <!-- Data will be populated via DataTables AJAX -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- end row-->
</div>


@endsection

@section('scripts')
<script>

document.addEventListener('DOMContentLoaded', function () {

   let table = $('#branchRequisitionsTable').DataTable({
        processing: true,
        serverSide: true,
        destroy: true,
        autoWidth: false,
        responsive: false,
        ajax: {
            url: '{{ route("branch_requisitions.get_requisitions_data") }}',
            data: function (d) {
                d.business_type_id = $('#business_type').val();
                d.business_id      = $('#branch_id').val();
            }
        },
        "info": false,
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {     
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                
        },
        buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-light active" },
                    { extend: "csv",   className: "btn btn-sm btn-light" },
                    { extend: "print", className: "btn btn-sm btn-light" },
                    { extend: "pdf", className: "btn btn-sm btn-light" }
                ],
        columns: [
            { data: 'requisition_number', name: 'requisition_number' },
            { data: 'to_branch', name: 'to_branch' },
            { data: 'requested_by', name: 'requested_by' },
            { data: 'requisition_date', name: 'requisition_date' },
            {
                data: 'product_ids',
                name: 'product_ids',
                render: function (data) {
                    return data ? data.split(',').join('<br>') : '';
                }
            },
           {
                data: 'product_names',
                name: 'product_names',
                render: function (data) {
                    if (!data) return '-';
                    const MAX_LENGTH = 17;

                    return data
                        .split(',')
                        .map(item => {
                            item = item.trim();
                            if (item.length > MAX_LENGTH) {
                                return `<span title="${item}" data-bs-toggle="tooltip" data-bs-placement="top">
                                    ${item.substring(0, MAX_LENGTH)}...
                                </span>`;
                            }
                            return item;
                        })
                        .join('<br>');
                }
            },
            {
                data: 'required_qty',
                name: 'required_qty',
                render: function (data) {
                    return data ? data.split(',').join('<br>') : '';
                }
            },
            {
                data: 'transfered_qty',
                name: 'transfered_qty',
                render: function (data) {
                    return data ? data.split(',').join('<br>') : '';
                }
            },
            {
                data: null,
                name: 'pending_total',
                render: function (data, type, row) {
                    let req = row.required_qty.split(',');
                    let trans = row.transfered_qty.split(',');

                    let html = '';
                    req.forEach((r, i) => {
                        html += (parseFloat(r) - parseFloat(trans[i])) + '<br>';
                    });

                    return html;
                }
            },

            {
                data: 'requisition_status',
                name: 'requisition_status',
                render: function (data) {
                    return data ? data.split(',').join('<br>') : '';
                }
            },


            { data: null, name: 'details', orderable: false, searchable: false,
                    render: function (data, type, row) {
                        
                            url1 = '{{ route("branch_requisitions.ho_requisition_transfer", ["requisition_number" => ":requisition_number", "business_id" => ":business_id"]) }}'; 
                            url1 =  url1.replace(':requisition_number', row.requisition_number)
                                    .replace(':business_id', row.business_id);
                            
                        
                            let url = '{{ route("branch_requisitions.get_requisition_details", ["requisition_number" => ":requisition_number", "business_id" => ":business_id"]) }}';
                            url = url.replace(':requisition_number', row.requisition_number)
                                    .replace(':business_id', row.business_id);

                        
                        if($('#ho').val()=='Yes'){
                            return `<a href="` + url1 + `"  title="Process" data-bs-toggle="tooltip" data-bs-placement="top" class="btn btn-sm btn-success view-details btn-icon fs-12 me-1" data-id="` + row.requisition_number + `">
                                <iconify-icon icon="mdi:transfer" class="fs-18"></iconify-icon>
                            </a>
                            <a href="` + url + `" title="Details" data-bs-toggle="tooltip" data-bs-placement="top" class="btn btn-sm btn-secondary view-details btn-icon fs-12 me-1" data-id="` + row.requisition_number + `">
                                <iconify-icon icon="mdi:eye" class="fs-18"></iconify-icon>
                            </a>
                            `;
                        }else{
                            return `<a href="` + url + `" title="Details" data-bs-toggle="tooltip" data-bs-placement="top" class="btn btn-sm btn-secondary view-details btn-icon fs-12 me-1" data-id="` + row.requisition_number + `">
                                <iconify-icon icon="mdi:eye" class="fs-18"></iconify-icon>
                            </a>
                            `;
                        }
                    }
                }
            ],
            rowCallback: function (row, data, index) {
                const requiredTotal = data.required_qty
                    ? data.required_qty.split(',').reduce((sum, v) => sum + parseFloat(v || 0), 0)
                    : 0;

                const transferedTotal = data.transfered_qty
                    ? data.transfered_qty.split(',').reduce((sum, v) => sum + parseFloat(v || 0), 0)
                    : 0;
                // compare totals
                if (requiredTotal - transferedTotal > 0) {
                    $('td:eq(8)', row)
                        .addClass('text-danger')
                        .removeClass('text-success');
                } else {
                    $('td:eq(8)', row)
                        .addClass('text-success')
                        .removeClass('text-danger');
                }
            },
            drawCallback: function(settings, json) {
               var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
                })
            }
                      
    });
    // Filter button
    $('#filterButton').on('click', function () {
        table.ajax.reload();
    });

});
</script>
@endsection