@extends('layouts.horizontal', ['title' => 'HO Requisition Transfer', 'topbarTitle' => 'HO Requisition Transfer'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')
    <div class="row mb-2">
        <div class="card">
            <div class="col-12">
                <div class="card-body">
                    <div class="card-title mb-2">
                        <h4>Transfer Items To Relevant Stores</h4>
                    </div>
                    <div class="row g-3 align-items-center mb-2">
                        <div class="col-1">
                            <label for="requisition_number" class="form-label">Req.#</label>
                            <input type="text" id="requisition_number" name="requisition_number" class="form-control" disabled value="{{ $requisition_number }}">
                        </div>
                        <div class="col-3">
                            <label for="from_store_id" class="form-label">Transfer From Store</label>
                            <select id="from_store_id" name="from_store_id" class="form-select">  
                                    @foreach($stores as $store)
                                        <option  value="{{ $store->id_business_stores }}">{{ $store->business_store }}</option>
                                    @endforeach
                            </select>     
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped fs-13 table-sm" id="items_table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Product ID</th>
                                    <th>Brand</th>
                                    <th>Product</th>                                   
                                    <th class="text-end">Qty. Per Unit</th>
                                    <th>Measure Unit</th>
                                    <th>To Store</th>
                                    <th class="text-end">Requested Qty</th>
                                    <th class="text-end">Transferred Qty</th>
                                    <th class="text-success fw-bolder text-end">Pending Qty</th>
                                    <th>Transfer Now</th>
                                    <th>Check Stock</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($requisition_items as $item)
                                    <tr>
                                        <td>{{ $item->id_branch_requisition }}</td>
                                        <td>{{ $item->product_id }}</td>
                                        <td>{{ $item->brand_name }}</td>
                                        <td>{{ $item->product }}</td>                                        
                                        <td class="text-end">{{ $item->qty_per_unit }}</td>
                                        <td>{{ $item->measure_unit }}</td>
                                        <td store_id={{ $item->store_id }}>{{ $item->to_branch }}/{{ $item->store_name }}</td>
                                        <td class="text-end">{{ $item->required_qty }}</td>
                                        <td class="text-end">{{ $item->transfered_qty }}</td>
                                        <td class="text-success fw-bolder text-end">{{ $item->required_qty - $item->transfered_qty }}</td>
                                        <td>
                                            <input type="number" onkeyup="validateTransferQty(this)" class="form-control transfer-qty text-end" min="0" max="{{ $item->required_qty - $item->transfered_qty }}" value="0" data-req-id="{{ $item->id_branch_requisition }}" data-item-id="{{ $item->product_id }}">
                                        </td>
                                        <td>
                                            <a href="{{ route('products.batches', ['id_business_products' => $item->product_id]) }}" target="_blank" class="btn btn-sm btn-ghost-success">
                                                <iconify-icon icon="mdi:eye" class="fs-18"></iconify-icon>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <button onclick="transferSelectedItems()" id="transfer_button" class="btn btn-ghost-success ">
                        <iconify-icon icon="mdi:transfer" class="me-1 fs-22"></iconify-icon>
                        Transfer Selected Items
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
    function validateTransferQty(input) {
        const maxQty = parseInt(input.max);
        const currentQty = parseInt(input.value);

        if (currentQty > maxQty) {
            input.value = maxQty;
        } else if (currentQty < 0 || isNaN(currentQty)) {
            input.value = 0;
        }
    }

    function transferSelectedItems() {
        const transferData = [];
        document.querySelectorAll('.transfer-qty').forEach(input => {
            const qty = parseInt(input.value);
            if (qty > 0) {
                transferData.push({
                    id_business_products: input.getAttribute('data-item-id'),
                    id_branch_requisition: input.getAttribute('data-req-id'),
                    transfer_qty: qty,
                    store_id: input.closest('tr').querySelector('td[store_id]').getAttribute('store_id')
                });
            }
        });

        var from_store_id =  $("#from_store_id").val() || '';
        
        if (from_store_id == '') {
            toastr.error('Please select store');
            return;
        }

        if (transferData.length === 0) {
            toastr.error('Please enter quantities to transfer.');
            return;
        }

        $("#transfer_button").prop('disabled', true);

        fetch('{{ route("branch_requisitions.process_ho_transfer", ":requisition_number") }}'.replace(':requisition_number', '{{ $requisition_number }}'), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            body: JSON.stringify({from_store_id: from_store_id, transfers: transferData })
        })
        .then(response => response.json())
        .then(data => {
            $("#transfer_button").prop('disabled', false);
            if (data.message_type === 'success') {
                toastr.success('Items transferred successfully!');
                location.reload();
            } else {
                toastr.error('Error transferring items: ' + data.message);
            }
        })
        .catch(error => {
            $("#transfer_button").prop('disabled', false);
            console.error('Error:', error);
            toastr.error('An error occurred while processing the transfer.');
        });
    }

</script>
@endsection