@extends('layouts.horizontal', ['title' => 'New Requisition', 'topbarTitle' => 'New Requisition'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@endsection

@section('content')
    <div class="row mb-2">
        <div class="card">
            <div class="col-12">
                <div class="card-body">
                    <div class="card-title mb-2">
                        <h4>Add Item To Requisition</h4>
                    </div>
                    <div class="row g-3 align-items-center mb-2">
                        <div class="col-1">
                            <label for="requisition_number" class="form-label">Req.#</label>
                            <input type="text" id="requisition_number" name="requisition_number" class="form-control" disabled value="{{ $requisition_number }}">
                        </div>
                        <div class="col-3">
                            <label for="product_id" class="form-label">Product</label>
                            <select id="product_id" name="product_id" class="form-select">
                                <option value="">-- Select Product --</option>
                            </select>
                        </div>
                        <div class="col-2">
                            <label for="quantity" class="form-label">Required Qty</label>
                            <input type="number" id="quantity" name="quantity" class="form-control">
                        </div>
                        <div class="col-2">
                            <label for="store_id" class="form-label">For Store</label>
                            <select id="store_id" name="store_id" class="form-select">
                                <option value="">-- Select Store --</option>
                                @foreach($stores as $store)
                                    <option value="{{ $store->id_business_stores }}">{{ $store->business_store }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="self-align-end col-2">
                            <button onclick="addRequisitionItem()" type="button" id="addRequisitionItem" class="btn btn-ghost-success rounded-circle btn-icon mt-4">
                                <iconify-icon icon="ei:arrow-down" class="fs-60"></iconify-icon>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> <!-- end row-->

    <div class="row">
        <div class="card">
            <div class="col-12">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap mb-0">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>ID Product</th>
                                    <th>Brand</th>
                                    <th>Product</th>
                                    <th>Qty. Per Unit</th>
                                    <th>Measure Unit</th>
                                    <th>Barcode</th>
                                    <th>For Store</th>
                                    <th>Required Qty</th>
                                    <th>Transfered Qty</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="requisitionItemsBody">
                                @if(isset($requisition_items))
                                    @foreach($requisition_items as $item)
                                        <tr>
                                            <td>{{ $item->id_branch_requisition }}</td>
                                            <td>{{ $item->product_id }}</td>
                                            <td>{{ $item->brand_name }}</td>
                                            <td>{{ $item->product }}</td>
                                            <td>{{ $item->qty_per_unit }}</td>
                                            <td>{{ $item->measure_unit }}</td>
                                            <td>{{ $item->barcode }}</td>
                                            <td store_id="{{ $item->store_id }}">{{ $item->store_name }}</td>
                                            @php
                                                $isReadonly ='';
                                                if($item->transfered_qty  > 0){
                                                 $isReadonly ='readonly';
                                                }

                                                if($item->business_id != session('business_id')){
                                                    $isReadonly ='readonly';
                                                }
                                            @endphp

                                            <td> <input type="number" step="any" class="form-control requiredQty" style="width: 100px" value="{{ $item->required_qty }}"  {{$isReadonly}} /></td>
                                            <td>{{ $item->transfered_qty }}</td>
                                            <td>
                                                <select class="form-select" name="requisition_status" {{ session('user_role') == "Reception" || session('user_role')=="Store Operator" ? disabled : '' }}>
                                                    <option value="Not Approved" @if($item->requisition_status == 'Not Approved') selected @endif>Not Approved</option>
                                                    <option value="Active" @if($item->requisition_status == 'Active') selected @endif>Active</option>
                                                    @if ($item->transfered_qty  <= 0)
                                                     <option value="Cancelled" @if($item->requisition_status == 'Cancelled') selected @endif>Cancelled</option>
                                                    @endif
                                                </select>
                                            </td>
                                            <td></td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <button onclick="submitRequisition()" id="submitRequisitionBtn" type="button" class="btn btn-ghost-primary"><iconify-icon icon="vaadin:paperplane" class="fs-20 me-1"></iconify-icon>Submit Requisition</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
   <script>
        var branch_requisition_status = @json($branch_requisition_status ?? '');

        $(document).ready(function() {
            //make product_id select2 with ajax
            $('#product_id').select2({
                ajax: {
                    url: '{{ route("products.search_products") }}',
                    data: function (params) {
                        return {
                            q: params.term // search term
                        };
                    },
                    dataType: 'json',
                    delay: 250,
                    processResults: function (data) {
                        return {
                            results: data.map(function (item) {
                                return {
                                    id: item.id,
                                    text: item.business_brand_name + ' ' + item.product + ' ' + (item.mcategory ? ' (Category: ' + item.mcategory + ')' : ''),
                                    measure_unit: item.measure_unit,
                                    qty_per_unit: item.qty_per_unit,
                                    product: item.product,
                                    brand: item.business_brand_name,
                                    batch_id: item.batch_id,
                                    batch_no: item.batch_no,
                                    store: item.store,
                                    price: item.price,
                                    instock: item.instock
                                };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Search for a product',
            });
        });

    function addRequisitionItem() {

        var productData = $('#product_id').select2('data')[0];
        var quantity = $('#quantity').val();
        var storeId = $('#store_id option:selected').val();
        var storeText = $('#store_id option:selected').text();
         
        if (productData.id == "") {
            toastr.info('Please select a product.');
            return;
        }
        if (quantity == "" || quantity <= 0) {
            toastr.info('Please enter a valid quantity.');
            return;
        }
        if (storeId == "") {
            toastr.info('Please select a store.');
            return;
        }

        var newRow = `
            <tr>
                <td></td>
                <td>${productData.id}</td>
                <td>${productData.brand}</td>
                <td>${productData.text}</td>
                <td>${productData.qty_per_unit}</td>
                <td>${productData.measure_unit}</td>
                <td>${productData.barcode || ''}</td>
                <td store_id="${storeId}">${storeText}</td>
                <td><input type="number" step="any" class="form-control requiredQty" style="width: 100px" value="${quantity}" /></td>
                <td>0</td>
                <td><select class="form-select" name="requisition_status"><option value="${branch_requisition_status}" selected>${branch_requisition_status}</option></select></td>
                <td>
                    <button type="button" class="btn btn-ghost-danger  btn-icon rounded-circle" onclick="removeRequisitionItem(this)">
                        <iconify-icon icon="famicons:trash-outline" class="fs-20"></iconify-icon>
                    </button>
                </td>
            </tr>
        `;

        $('#requisitionItemsBody').append(newRow);

        // Clear inputs
        $('#product_id').val(null).trigger('change');
        $('#quantity').val('');
    }

    function removeRequisitionItem(button) {
        $(button).closest('tr').remove();
    }

    function submitRequisition() {
       
        

        var requisitionItems = [];
        $('#requisitionItemsBody tr').each(function() {
            var item = {
                id_branch_requisition: $(this).find('td:eq(0)').text(),
                requisition_number: $('#requisition_number').val(),
                product_id: $(this).find('td:eq(1)').text(),
                brand: $(this).find('td:eq(2)').text(),
                product: $(this).find('td:eq(3)').text(),
                qty_per_unit: $(this).find('td:eq(4)').text(),
                measure_unit: $(this).find('td:eq(5)').text(),
                barcode: $(this).find('td:eq(6)').text(),
                store_id: $(this).find('td:eq(7)').attr('store_id'),
                required_qty: $(this).find('td:eq(8)').find('.requiredQty').val(),
                transfered_qty: $(this).find('td:eq(9)').text(),
                requisition_status: $(this).find('td:eq(10) select[name="requisition_status"]').val()

            };
            requisitionItems.push(item);
        });

    
        if (requisitionItems.length === 0) {
            toastr.info('Please add at least one requisition item.');
            return;
        }

        $("#submitRequisitionBtn").prop('disabled', true);    
        $.ajax({
            url: '{{ route("branch_requisitions.save_requisition") }}',
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                requisition_number: $('#requisition_number').val(),
                items: requisitionItems
            },
            success: function(response) {
                $("#submitRequisitionBtn").prop('disabled', false);
                data = response;
               if(data.message_type=="success"){
                    //reload the page
                    location.reload();
               }
                toastr.success(response.message);
                // Optionally, redirect or clear the form
            },
            error: function(xhr) {
                $("#submitRequisitionBtn").prop('disabled', false);
                toastr.error(xhr.responseJSON.message || 'An error occurred while submitting the requisition.');
            }
        });
    }

    </script>
@endsection