@extends('layouts.horizontal', ['title' => 'Products', 'topbarTitle' => 'Products'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/select2/dist/css/select2.min.css'
])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="Tbrands ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0"><span>{{ $brand_name =="" ? "Brand" : $brand_name}}</span> Products</h2>
                <input type="hidden" id="id_brand" value="{{ $id_brand }}">
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
     <div class="row ">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">    
                    <div class="mb-3 d-flex align-items-center justify-content-between">
                        <h5 class="card-title mb-0 fw-bold">Filter Products</h5>
                        @can('create-brand_product')
                            <button type="button" class="btn btn-sm btn-outline-success" data-bs-toggle="modal" data-bs-target="#productEditModal" onclick='$("#productEditModalLabel").text("Add New Product")'><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon>Product</button>
                        @endcan
                    </div>               
                    <form id="filterform" method="GET" action="">
                        <div class="row mt-0 gap-1">                            
                            <div class="col-md-3 d-none">
                                <label class="form-label" for="branch_id">Select  Branch</label>
                                <select id="branch_id" name="business_id" class="form-select"> 
                                    @if(session('ho')=="Yes")
                                    <option value="">All Branches</option>                                   
                                    @endif
                                    @foreach($branches as $branch)
                                        <option value="{{ $branch->id_business }}" @if($branch->id_business == $business_id) selected @endif>{{ $branch->business_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3 d-none">
                                <label class="form-label" for="store_id">Select  Store</label>
                                <select id="store_id" name="store_id" class="form-select">
                                    <option value="0">All Stores</option>
                                    @foreach($stores as $store)
                                        <option value="{{ $store->id_business_stores }}" @if($store->id_business_stores == $store_id) selected @endif>{{ $store->business_store }} / {{ $store->business_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <div class="button-group">
                                    <input onclick="refresh_data()" id="btn_refresh_table_all" name="btn-refresh" value="All" type="button" class="btn btn-sm btn-primary " >
                                    <input onclick="refresh_data()" id="btn_refresh_table_professional" name="btn-refresh" value="Professional" type="button" class="btn btn-sm btn-success " >
                                    <input onclick="refresh_data()" id="btn_refresh_table_retail" name="btn-refresh" value="Retail" type="button" class="btn btn-sm btn-info " >
                                </div>
                            </div> 
                            <div class="col-md-3">
                                
                            </div>                           
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="products_table" class="table table-bordered dt-responsive fs-13 w-100">
                        <thead>
                            <tr>
                                <th>Images</th>
                                <th>ID</th>
                                <th>Brand Name</th>
                                <th>Product</th>
                                <th>Category</th>
                                <th>Type</th>
                                <th>Retail</th>
                                <th>Purchase</th>
                                <th>Total InStock</th>
                                <th>Threshold</th>
                                <th>Unit Type</th>
                                <th>Qty. Per Unit</th>
                                <th>Unit</th>                               
                                <th>Active</th>
                                <th>Commission</th>
                                <th>Sku</th>
                                <th>Barcode</th>
                                <th>Updated At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>                           
                        </tbody>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row-->

</div>
@include('modals.product_edit')

@endsection

@section('scripts')

@vite(['resources/js/modals/product_edit.js'])
<script>
    const editBrandProduct = "{{ auth()->user()->can('edit-brand_product') }}";

    const baseURL = '{{ url("") }}'; // Use relative paths
    const id_brand = "{{ $id_brand }}";
    document.addEventListener('DOMContentLoaded', function() {
       refresh_data(id_brand);
        $("#productBrand").select2({
            dropdownParent: $('#productEditModal')
        });
        
    });
    
    function initializeProductsTable(business_id, store_id, filter_type){
        console.log(baseURL + `/brands/${id_brand}/products/productsdata`);
        var table = $('#products_table').DataTable({
            scrollX:true,            
            scrollCollapse: true,
            fixedHeader: true,
            processing: true,
            serverSide: true,
            stateSave: true,
            responsive: false,
            ajax: {
                url: `${baseURL}/brands/${id_brand}/products/productsdata`,
                type: 'POST',
                contentType: 'application/json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                dataType: 'json',
                data: function (d) {
                    d.business_id = business_id;
                    d.store_id = store_id;
                    d.filter_type = filter_type;
                    console.log('AJAX params:', d);
                    return JSON.stringify(d);

                },
                error: function (xhr, error, thrown) {
                    console.error('DataTables AJAX error:', error, thrown, xhr.responseText);
                }
            },
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'>",
                    "next": "<i class='ti ti-chevron-right'>"
                }
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            lengthChange: true,   // show page length dropdown
            pageLength: 10,       // default rows per page
            searching: true,      // show search box
            info: true,           // show "Showing 1 to 10 of N entries"
            paging: true,         // show pagination
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            columns: [
                { data: 'images', title: 'Images', orderable: false, searchable: false,
                    render: function(data, type, row) {
                        if(data){
                            let imageUrls = data.split('|');
                            let imgTag = `<div class="avatar-lg border rounded" style="cursor:pointer"><img src="${baseURL}/images/products/${imageUrls[0]}" alt="Product Image" class="img-fluid rounded-2"></div>`;
                            return imgTag;
                        } else {
                            return `<div class="avatar-lg border rounded" style="cursor:pointer"><img src="${baseURL}/images/products/default_product.png" alt="Default Image" class="img-fluid rounded-2"></div>`;
                        }
                    }
                },
                { data: 'id_business_products', title: 'ID', orderable: true, searchable: true },
                { data: 'business_brand_name', title: 'Brand Name' },
                { data: 'product', title: 'Product' },
                { data: 'category', title: 'Category' },
                { data: null, title: 'Pro' , 
                    searchable: true,
                    orderable: true,
                    render: function(data, type, row) {
                        if(data.product_type === 'Professional')
                            return `<span class="badge bg-success fs-12 fw-bold">${data.product_type}</span>`;
                        else if(data.product_type === 'Retail')
                            return `<span class="badge bg-info fs-12 fw-bold">${data.product_type}</span>`;
                        else
                        return `<span class="badge bg-success fs-12 fw-bold">${data.product_type}</span>`;
                    }
                 },
                { data: 'price', title: 'Retail', searchable: false },
                { data: 'purchase_price', title: 'Purchase', searchable: false },
                { data: 'instock', title: 'Total InStock', orderable: true, searchable: false, 
                     render: function (data, type, row) {
                        if (type === 'display') {
                            // what is shown in the table
                            const badgeClass = row.instock <= row.threshold ? 'bg-danger' : 'bg-success';
                            return `<span class="badge ${badgeClass} fs-12 fw-bold">${row.instock}</span>`;
                        }
                        // for ordering, searching, etc., return raw integer
                        return parseInt(row.instock, 10);
                    }
                },
                { data: 'threshold', title: 'Threshold', searchable: false },
                { data: 'unit_type', title: 'Type', searchable: false },
                { data: 'qty_per_unit', title: 'Qty. Per Unit', searchable: false },
                { data: 'measure_unit', title: 'Unit', searchable: false },               
                { data: 'business_product_active', title: 'Active' ,
                    searchable: false,
                    orderable: true,
                    render: function(data, type, row) {
                        if(row.business_product_active === 'Yes')
                            return `<span class="badge bg-success fs-12 fw-bold">${row.business_product_active}</span>`;
                        else if(row.business_product_active === 'No')
                            return `<span class="badge bg-danger fs-12 fw-bold">${row.business_product_active}</span>`;
                        else
                        return `<span class="badge bg-secondary fs-12 fw-bold">${row.business_product_active}</span>`;
                    }

                },
                { data: 'commission', title: 'Commission', searchable: false },
                { data: 'sku', title: 'SKU', searchable: true },
                { data: 'barcode', title: 'Barcode', searchable: true },
                { data: 'updated_at', title: 'Updated', searchable: false },
                { data: 'actions', title: 'Actions', orderable: false, searchable: false,
                    render: function(data, type, row) {
                        let baseUrl = "{{ route('products.batches', ['id_business_products' => ':id']) }}";
                        let url = baseUrl.replace(':id', row.id_business_products);

                        var actionButtons = '';

                        if(editBrandProduct){
                            actionButtons += `<button data-bs-toggle="modal"  data-bs-target="#productEditModal"  onclick='$("#productEditModalLabel").text("Edit Product")' data-product-id="${row.id_business_products}"  class="btn btn-sm btn-ghost-info btn-icon rounded-circle" data-bs-tooltip  title="Edit Product">
                                <iconify-icon icon="line-md:edit-twotone" class="fs-22"></iconify-icon>
                            </button>`;
                        }

                        actionButtons += `<a href="${url}" target="_batches" data-bs-tooltip title="Product Batches" class="btn btn-sm btn-ghost-success rounded-circle flex-shrink-0 btn-icon product-batch">
                            <iconify-icon icon="carbon:classic-batch" style= "cursor:pointer;" class="fs-18"></iconify-icon>
                        </a>`;

                        return actionButtons;
                    }
                 }
            ],
            "rowCallback": function(row, data, displayNum, displayIndex, dataIndex) {
                if (data.active === 'No') {
                    $(row).addClass('strike-through');
                }
            }
        });

        // Initialize tooltips after table draw
        $('#products_table').on('draw.dt', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-tooltip]'))
            tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    }

    function refresh_data(){
        
        //serial form data
        
        let formData = $('#filterform').serializeArray();
        let params = {};
        formData.forEach(function(item) {
            params[item.name] = item.value;
        });
        let business_id = params['business_id'];
        let store_id = params['store_id'];
        let filter_type = event.target.value;

        $("#products_table").DataTable().destroy();

        initializeProductsTable(business_id, store_id, filter_type);

    }

</script>
@endsection