@extends('layouts.horizontal', ['title' => 'Brands', 'topbarTitle' => 'Brands'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="Tbrands ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Brands</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <!-- Brands Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="brands_table" class="table table-bordered dt-responsive fs-13 nowrap w-100">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Brand Name</th>
                                <th>Short</th>
                                <th>Active</th>
                                <th>Updated At</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($brands as $brand)
                            <tr {{ $brand->business_brand_active == 'No' ? 'class=strike-through' : '' }}>
                                <td>{{ $brand->id_business_brands }}</td>
                                <td>{{ $brand->business_brand_name }}</td>
                                <td>{{ $brand->business_brand_short }}</td>
                                <td>{{ $brand->business_brand_active }}</td>
                                <td>{{ $brand->updated_at }}</td>
                                <td>
                                    <a href="{{ route('brands.products', ['id_brand' => $brand->id_business_brands]) }}" class="btn btn-sm btn-ghost-primary me-2"><iconify-icon icon="mdi:package-variant-closed" class="fs-22"></iconify-icon> Products</a>
                                    @can('edit-brand')
                                        <button class="btn btn-sm btn-ghost-secondary rounded-circle btn-icon edit-brand-btn" onclick="openEditBrandModal({{ $brand->id_business_brands }})" data-id="{{ $brand->id_business_brands }}" data-name="{{ $brand->business_brand_name }}" data-short="{{ $brand->business_brand_short }}" data-website="{{ $brand->business_brand_website }}" data-active="{{ $brand->business_brand_active }}"><iconify-icon icon="line-md:edit-twotone" class="fs-22"></iconify-icon></button>
                                    @endcan
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div> <!-- end col -->
    </div> <!-- end row-->

</div>
{{-- Modal for Editing Brands --}}
<div class="modal fade" id="editBrandModal" tabindex="-1" aria-labelledby="editBrandModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editBrandModalLabel">Edit Brand</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editBrandForm">
                    <div class="mb-3">
                         <input type="hidden" id="brandId" name="id_business_brands" >
                        <label for="brandName" class="form-label">Brand Name</label>
                        <input type="text" class="form-control" id="brandName" name="business_brand_name" required>
                    </div>
                    <div class="mb-3">
                        <label for="brandShort" class="form-label">Brand Short</label>
                        <input type="text" class="form-control" id="brandShort" name="business_brand_short" required>
                    </div>
                    <div class="mb-3">
                        <label for="brandWebsite" class="form-label">Brand Website</label>
                        <input type="text" class="form-control" id="brandWebsite" name="business_brand_website" required>
                    </div>
                    <div class="mb-3">
                        <label for="brandActive" class="form-label">Active</label>
                        <select class="form-select" id="brandActive" name="business_brand_active" required>
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                   
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" onclick="saveBrandChanges()" class="btn btn-primary" id="saveBrandChanges">
                   <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="saveBrandSpinner"></span> Save changes</button>
            </div>
        </div>
    </div>

{{-- End Modal --}}
@endsection

@section('scripts')
<script>
    
    $(document).ready(function() {
        $('#brands_table').DataTable({
            responsive: true,
            fixedHeader: true,
            lengthChange: true,
            pageLength: 10,
            searching: true,
            info: true,
            paging: true,
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf",   className: "btn btn-sm btn-soft-primary" }
            ],
            layout: {
                topStart: "buttons",
                topEnd: function() {
                    // Return a flex container with search input and button
                    return '<div class="d-flex align-items-center gap-2" style="justify-content: flex-end; width: 100%;"><label class="dataTables_filter" style="margin: 0;"><input type="search" class="form-control form-control-sm" placeholder="Search..." aria-controls="brands_table" id="brands_table_search"></label>' +
                           @can('create-brand')
                           '<button class="btn btn-sm btn-outline-success" id="addBrandBtn" onclick="openAddBrandModal()"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Brand</button>' +
                           @endcan
                           '</div>';
                },
                bottomStart: {
                    pageLength: { menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]] },
                    info: {}
                },
                bottomEnd: "paging"
            },
            initComplete: function(settings) {
                // Manually wire up the search input to DataTables
                var searchInput = $('#brands_table_search');
                if (searchInput.length) {
                    searchInput.on('keyup', function() {
                        $('#brands_table').DataTable().search(this.value).draw();
                    });
                }
            }
        });
    });

    function openEditBrandModal(id) {
        var button = $('.edit-brand-btn[data-id="' + id + '"]');
        $('#brandId').val(id);
        $('#brandName').val(button.data('name'));
        $('#brandShort').val(button.data('short'));
        $('#brandWebsite').val(button.data('website'));
        $('#brandActive').val(button.data('active'));
        var editBrandModal = new bootstrap.Modal(document.getElementById('editBrandModal'));
        editBrandModal.show();
    }   

    function openAddBrandModal() {
        $('#brandId').val('');
        $('#brandName').val('');
        $('#brandShort').val('');
        $('#brandWebsite').val('');
        $('#brandActive').val('Yes');
        var editBrandModal = new bootstrap.Modal(document.getElementById('editBrandModal'));
        editBrandModal.show();
    }

    function saveBrandChanges() {
        var formData = $('#editBrandForm').serialize();
        document.getElementById('saveBrandChanges').disabled = true;
        document.getElementById('saveBrandSpinner').classList.remove('d-none');
        $.ajax({
            url: '{{ route("brands.save_brand") }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                document.getElementById('saveBrandChanges').disabled = false;
                document.getElementById('saveBrandSpinner').classList.add('d-none');

                if(response.message_type === 'success') {
                    toastr.success(response.message);
                    location.reload();
                } else {
                    toastr.error('Failed to save brand: ' + response.message);
                }
                
            },
            error: function(xhr) {
                document.getElementById('saveBrandChanges').disabled = false;
                document.getElementById('saveBrandSpinner').classList.add('d-none');
                
                toastr.error('An error occurred while saving the brand.');
            }
        });
    }

</script>
@endsection