@extends('layouts.horizontal', ['title' => 'Compiled Kits', 'topbarTitle' => 'Products'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
<style>
    /* Add bottom border to specific table rows */
    .table tr.border_bottom >td {
        border-bottom: 2px solid #dee2e6;
    }
    td.border-top-1 {
        border-top: 2px solid #dee2e6 !important;
    }
    tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>

@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="container-fluid">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Compiled Kits</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="compiledKitsTable" class="table table-bordered fs-13 w-100">
                        <thead>
                            <tr>
                                <th>ID Config</th>
                                <th>Kit Id</th>
                                <th>Kit Brand Name</th>
                                <th>Kit Name</th>                                  
                                <th>Kit Components</th>                                
                                <th>Kit Qty</th>                                
                                <th>Kit Measure</th>
                                <th>Unit</th>
                                <th>Kit Product unit Cost</th>
                                <th>Add Product</th>
                                <th>Add Inventory</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{-- AddEdit Kit Modal --}}
    <div class="modal fade" id="kitEditModal" tabindex="-1" aria-labelledby="kitEditModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="kitEditModalLabel">Create New Compiled Kit</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="kitForm">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-3">
                                 <div class="mb-3">
                                    <label for="KitId" class="form-label">Kit ID</label>
                                    <input type="text" class="form-control bg-light" id="kitId" name="id_business_products" readonly>
                                </div>
                                 <div class="mb-3">
                                    <label for="kitBrandName" class="form-label">Kit Brand Name</label>
                                    <select class="form-select select-2" id="kitBrandName" name="brand_id" required>                                
                                        @foreach($brands as $brand)
                                            <option value="{{ $brand->id_business_brands }}">{{ $brand->business_brand_name }} - {{ $brand->business_brand_active == "Yes" ? "Active" : "Inactive" }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="kitCommissionType" class="form-label">Commission Type</label>
                                    <select class="form-select" id="kitCommissionType" name="commission_type" required>                                
                                        <option value="Percentage">Percentage</option>
                                        <option value="Fixed">Fixed</option>
                                    </select>
                                </div>  
                            </div>
                            <div class="col-md-3">
                                 <div class="mb-3">
                                    <label for="kitName" class="form-label">Kit Name</label>
                                    <input type="text" class="form-control" id="kitName" name="product" required>
                                </div>
                           
                                <div class="mb-3">
                                    <label for="kitPrice" class="form-label">Price</label>
                                    <input type="number" step="0.01" class="form-control" id="kitPrice" name="price" required>
                                </div>
                                <div class="mb-3">
                                    <label for="kitCommissionValue" class="form-label">Kit Commission</label>
                                    <input type="number" step="0.01" class="form-control" id="kitCommissionValue" name="commission" required>
                                </div>
                               
                                
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="kitTrackInventory" class="form-label">Track Inventory</label>
                                    <select class="form-select" id="kitTrackInventory" name="track_inventory" required>                                
                                        <option value="Yes">Yes</option>
                                        <option value="No">No</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="kitTaxPercentage" class="form-label">Tax Percentage</label>
                                    <input type="number" step="0.01" class="form-control" id="kitTaxPercentage" name="tax_percentage" required>
                                </div>
                                 
                                
                            </div>
                            <div class="col-md-3">
                                 <div class="mb-3">
                                    <label for="kitMeasureUnit" class="form-label">Measure Unit</label>
                                    <select class="form-select" id="kitMeasureUnit" name="measure_unit" required>                                
                                        @foreach($measure_units as $measure_unit)
                                            <option value="{{ $measure_unit->m_unit }}">{{ $measure_unit->m_unit }}</option>
                                        @endforeach
                                    </select>
                                </div>     
                                <div class="mb-3">
                                    <label for="kitComponents" class="form-label">Unit Type</label>
                                    <select class="form-select" id="kitUnitType" name="unit_type" required>                                
                                        @foreach($unit_types as $unit_type)
                                            <option value="{{ $unit_type->unit_type }}">{{ $unit_type->unit_type }}</option>
                                        @endforeach
                                    </select>
                                </div> 
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-4 mb-3">                                
                                <label class="form-label" for="select_product">Select Product</label>
                                <select class="form-select select2" id="select_product"></select>                                
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label" for="component_quantity">Quantity</label>
                                <input type="number" onkeyup="updateQty()" class="form-control" id="component_quantity" value="1" min="0">
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label" for="component_measure_qty">Measure Qty</label>
                                <input type="number" onkeyup="updateMeasureQty()" class="form-control" id="component_measure_qty" value="0" min="0">
                            </div>

                            <div class="col-md-4 mb-3 d-flex align-items-end">
                                <span class="spinner-border text-primary me-1 d-none" role="status" aria-hidden="true" id="addProductSpinner"></span>
                                <button type="button" class="btn btn-icon btn-ghost-success" id="addSelectedProductBtn" onclick="addSelectedProductToKit()">
                                    <iconify-icon icon="lets-icons:size-down" width="24"></iconify-icon>
                                </button>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-12">
                                <h5>Kit Components</h5>
                                <table class="table table-bordered" id="kitComponentsTable">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Component Product</th>
                                            <th>Quantity</th>
                                            <th>Measure Qty</th>
                                            <th>Measure Unit</th>
                                            <th>Product Unit Cost</th>
                                            <th>Product Total Cost</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Kit components will be dynamically added here -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td id="kit_total_cost"></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>                               
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="button" onclick="saveKit()" id="saveKitBtn" class="btn btn-primary">Save Kit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


    {{-- End AddEdit Kit Modal --}}

</div>

@endsection

@section("scripts")

<script>
    const baseURL = '{{ url("") }}'; // Use relative paths
    $(document).ready(function() {
        $('.select-2').select2({
            width: '100%',
            dropdownParent: $('#kitEditModal'), 
            minimumResultsForSearch: 0      
        });

        var last_kit_id = null;
        var table = $('#compiledKitsTable').DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            lengthChange: true,
            pageLength: 10,
            searching: true,
            info: true,
            paging: true,
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf",   className: "btn btn-sm btn-soft-primary" }
            ],
            layout: {
                topStart: "buttons",
                topEnd: function() {
                    // Return a flex container with search input and button
                    return '<div class="d-flex align-items-center gap-2" style="justify-content: flex-end; width: 100%;"><label class="dataTables_filter" style="margin: 0;"><input type="search" class="form-control form-control-sm" placeholder="Search..." aria-controls="compiledKitsTable" id="compiledKitsTable_search"></label><button class="btn btn-sm btn-outline-success" id="createNewKitBtn" onclick="openkitEditModal(0)"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Create New Kit</button></div>';
                },
                bottomStart: {
                    pageLength: { menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]] },
                    info: {}
                },
                bottomEnd: "paging"
            },
            initComplete: function(settings) {
                // Manually wire up the search input to DataTables
                var searchInput = $('#compiledKitsTable_search');
                if (searchInput.length) {
                    searchInput.on('keyup', function() {
                        $('#compiledKitsTable').DataTable().search(this.value).draw();
                    });
                }
            },
            ajax: {
                url: '{{ route("products.compiledkitsdata") }}',
                type: 'GET',
            },
            columns: [
                { data: 'id_kit_config', name: 'id_kit_config', orderable: false, searchable: false },
                { data: 'kit_id', name: 'kit_id' },
                { data: 'kit_brand_name', name: 'kit_brand_name',  orderable: false, },
                { data: 'kit_name', name: 'kit_name', orderable: false },                
                { data: 'component_product_name', name: 'component_product_name', orderable: false, },                
                { data: 'component_quantity', name: 'component_quantity',  orderable: false, searchable: false },
                { data: 'component_measure_qty', name: 'component_measure_qty' ,  orderable: false, searchable: false },                
                { data: 'component_measure_unit', name: 'component_measure_unit',  orderable: false, searchable: false },
                { data: 'component_product_cost', name: 'component_product_cost' ,  orderable: false, searchable: false },
                { data: null, orderable: false, searchable: false, 
                    render: function(data, type, row) {
                        if (last_kit_id != row.kit_id) {
                            return `<button onclick="openkitEditModal(${row.kit_id})" class="btn btn-ghost-info rounded-circle btn-icon">
                                <iconify-icon icon="line-md:file-plus-twotone" width="22"></iconify-icon>                                                         
                            </button>`;
                        } else {
                            return '';
                        }
                    }
                },
                { data: null, orderable: false, searchable: false,
                    render: function(data, type, row) {
                        if (last_kit_id != row.kit_id) {
                            let url = "{{ route('products.batches', ['id_business_products' => ':id_business_products']) }}".replace(':id_business_products', row.kit_id);
                            return `<a href="${url}" target="batches" class="btn btn-ghost-success rounded-circle btn-icon">
                                <iconify-icon icon="line-md:uploading-loop" width="22"></iconify-icon>                                                         
                            </a>`;
                        } else {
                            return '';
                        }                        
                    }
                 },
            ],
            responsive: true,
            fixedHeader: true,
            fixedColumns: {
                leftColumns: 1,
            },
            order: [[1, 'asc']],
            rowCallback: function(row, data) {
                if (last_kit_id !== null && last_kit_id === data.kit_id) {                    
                    $('td', row).eq(1).text(''); // Clear Kit Id
                    $('td', row).eq(2).text(''); // Clear Kit Brand Name
                    $('td', row).eq(3).text(''); // Clear Kit Name                    
                } else {
                    //add border_bottom class 
                     $(row).find('td').addClass('border-top-1');
                    last_kit_id = data.kit_id;
                }
                if (data.kit_config_deleted_at != null && data.kit_config_deleted_at  !='') {
                $(row).addClass('strike-through');
                }
            },
        });

    });


    function openkitEditModal(kit_id) {
        if(kit_id > 0){
            document.getElementById('addProductSpinner').classList.remove('d-none');
            $('#addSelectedProductBtn').prop('disabled', true);
            $('#saveKitBtn').prop('disabled', true);

            //Get the product details to fill the modal
            $.ajax({
                url: baseUrl + '/products/' + kit_id + '/details', 
                type: 'GET',
                success: function(response) {
                    //console.log(response);
                    document.getElementById('addProductSpinner').classList.add('d-none');
                    //Fill the modal fields with the product data
                    $("#kitId").val(response.id_business_products);
                    $("#kitBrandName").val(response.brand_id);
                    $("#kitName").val(response.product);
                    $("#kitPrice").val(response.price);
                    $("#kitCommissionType").val(response.commission_type);
                    $("#kitCommissionValue").val(response.commission);
                    $("#kitUnitType").val(response.unit_type);
                    $("#kitMeasureUnit").val(response.measure_unit);
                    $("#kitTaxPercentage").val(response.product_sales_tax);
                    $("#kitTrackInventory").val(response.track_inventory);

                

                    //Show the modal
                    let EL = document.getElementById('kitEditModal');
                    let modal = bootstrap.Modal.getOrCreateInstance(EL);
                    modal.show();

                    get_kit_components(kit_id);
                    
                    $('#addSelectedProductBtn').prop('disabled', false);
                    $('#saveKitBtn').prop('disabled', false);
                    document.getElementById('addProductSpinner').classList.add('d-none');

                },
                error: function(xhr) {
                    $('#addSelectedProductBtn').prop('disabled', false);
                    $('#saveKitBtn').prop('disabled', false);
                    document.getElementById('addProductSpinner').classList.add('d-none');
                    console.log(xhr.responseText);
                }
            });
        } else {
            //Clear the modal fields for new kit
            $("#kitForm")[0].reset();
            $("#kitId").val('');
            $('#kitComponentsTable tbody').empty();
            calculate_total_cost_of_kit();
            //Show the modal
            let EL = document.getElementById('kitEditModal');
            let modal = bootstrap.Modal.getOrCreateInstance(EL);
            modal.show();
        }
    
    }

    document.getElementById('kitEditModal').addEventListener('shown.bs.modal', function () {
        initialize_product_select2();
    });
    
    function updateQty() {
        let qty = $('#component_quantity').val();
        if (qty > 0) {            
            $('#component_measure_qty').val("0");
        } else {
            $('#component_measure_qty').val("0");
            $('#component_quantity').val("1");
        }

    }

    function updateMeasureQty() {
        let measureQty = $('#component_measure_qty').val();
        if (measureQty > 0) {
            $('#component_quantity').val("0");
        } else {
            $('#component_quantity').val("0");
            $('#component_measure_qty').val("1");
        }
    }

    function initialize_product_select2(){
        // Initialize Select2 on the product select element if not already initialized
        if ($.fn.select2 && $('#select_product').hasClass("select2-hidden-accessible")) {
            return; // Already initialized
        }

            $('#select_product').select2({
                placeholder: 'Select a product',
                 dropdownParent: $('#kitEditModal .modal-content'),
                ajax: {
                    url: '{{ route("products.search_products") }}',
                    dataType: 'json',
                    delay: 1000,
                    width: '100%',
                   
                    data: function(params) {
                        return {
                            q: params.term, // search term
                        };
                    },
                    processResults: function(data) {
                       return {
                            results: data.map(function (item) {
                                return {
                                    id: item.id,
                                    text: item.business_brand_name + ' ' + item.product + ' ' + item.qty_per_unit + ' ' + item.measure_unit,
                                    measure_unit: item.measure_unit,
                                    qty_per_unit: item.qty_per_unit,
                                    product: item.product,
                                    brand: item.business_brand_name,
                                    price: item.price,
                                    purchase_price: item.purchase_price,
                                };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 4
            });
    }

    function get_kit_components(kit_id){
        //disable the add and save buttons while loading
        $('#addSelectedProductBtn').prop('disabled', true);
        document.getElementById('addProductSpinner').classList.remove('d-none');


        $.ajax({
            url: baseUrl + '/products/compiled_kits/' + kit_id + '/components', 
            type: 'GET',
            success: function(response) {
               // console.log(response);
               document.getElementById('addProductSpinner').classList.add('d-none');
                $('#addSelectedProductBtn').prop('disabled', false);

                //Populate the kit components table
                let tbody = $('#kitComponentsTable tbody');
                tbody.empty();
                response.components.forEach(function(component, index) {
                    let row = `<tr data-component-product-id="${component.component_product_id}">
                        <td>${index + 1}</td>
                        <td>${component.component_product_name}</td>
                        <td>${component.component_quantity}</td>
                        <td>${component.component_measure_qty}</td>
                        <td>${component.component_measure_unit}</td>
                        <td>${component.component_product_cost}</td>
                        <td class="kitTotalCost">${ parseFloat(parseFloat(component.component_product_cost)* parseFloat(component.component_quantity)).toFixed(2)}</td>
                        <td>
                            <button type="button" class="btn btn-icon btn-ghost-danger rounded-circle" onclick="removeComponent(${component.id_kit_config})">
                                <iconify-icon icon="line-md:trash" width="20"></iconify-icon>
                            </button>
                        </td>
                    </tr>`;
                    tbody.append(row);
                });

                calculate_total_cost_of_kit();
            },
            error: function(xhr) {
                 document.getElementById('addProductSpinner').classList.add('d-none');
                $('#addSelectedProductBtn').prop('disabled', false);
                console.log(xhr.responseText);
            }
        });

    }

    function addSelectedProductToKit(){
        let kit_id = $('#kitId').val();

        if(kit_id != ''){
            
            //Get selected product details
            let selectedProduct = $('#select_product').select2('data')[0];
            let qtyPerUnit = parseFloat(selectedProduct.qty_per_unit || 0);
            let unitQtyInput = parseFloat($('#component_quantity').val() || 0);
            let measureQtyInput = parseFloat($('#component_measure_qty').val() || 0);

            let kitId = $('#kitId').val();
            

            if (!selectedProduct) {
                Swal.fire({
                    title: 'No Product Selected',
                    text: 'Please select a product to add.',
                    icon: 'warning',
                    customClass: {
                        confirmButton: 'btn btn-warning'
                    },
                });
                return;
            }

            if (unitQtyInput <= 0 && measureQtyInput <= 0) {
                Swal.fire({
                    title: 'Invalid Quantity',
                    text: 'Please enter a valid quantity or measure quantity.',
                    icon: 'warning',
                    customClass: {
                        confirmButton: 'btn btn-warning'
                    },
                });
                return;
            } 


            


            let unit_qty = 0;
            let measurement_qty = 0;

            if(!isNaN(unitQtyInput) && unitQtyInput > 0){
                unit_qty = unitQtyInput;
                measurement_qty = qtyPerUnit * unit_qty;
            } else {
                if(qtyPerUnit > 0){
                    unit_qty = measureQtyInput / qtyPerUnit;
                } else {
                    unit_qty = 0;
                }
                measurement_qty = measureQtyInput; 
            }


            //Prepare data to send
            let data = {
                kit_id: kitId,
                business_product_id: selectedProduct.id,
                kit_qty: unit_qty,
                kit_measure_qty: measurement_qty,
                kit_product_cost: selectedProduct.purchase_price
            };
        
            //Confirm with swal
            Swal.fire({
                title: 'Add Product to Kit?',
                text: `Are you sure you want to add ${selectedProduct.brand} ${selectedProduct.product} to the kit?`,
                icon: 'question',
                iconColor: '#93b373',
                showCancelButton: true,
                confirmButtonText: 'Yes, Add it!',
                cancelButtonText: 'No, Cancel',
                customClass: {
                    confirmButton: 'btn btn-success me-2',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
            }).then((result) => {
                if (result.isConfirmed) {
                    //Call function to add component to kit
                    sendAddComponentRequest(data, kitId);
                }
            });
        } else {

            //add component row to the table directly for new kit
            let selectedProduct = $('#select_product').select2('data')[0];

            console.log(selectedProduct,"selectedProduct");

            let product = selectedProduct.product;
            let unitQtyInput = parseFloat($('#component_quantity').val() || 0);
            let measureQtyInput = parseFloat($('#component_measure_qty').val() || 0);
            let qtyPerUnit = parseFloat(selectedProduct.qty_per_unit || 0);

            let unit_qty = 0;
            let measurement_qty = 0;

            if(!isNaN(unitQtyInput) && unitQtyInput > 0){
                unit_qty = unitQtyInput;
                measurement_qty = qtyPerUnit * unit_qty;
            } else {
                if(qtyPerUnit > 0){
                    unit_qty = measureQtyInput / qtyPerUnit;
                } else {
                    unit_qty = 0;
                }
                measurement_qty = measureQtyInput;
            }


            let tbody = $('#kitComponentsTable tbody');
            let row = `<tr data-component-product-id="${selectedProduct.id}">
                <td>${tbody.children().length + 1}</td>
                <td>${product}</td>
                <td>${unit_qty}</td>
                <td>${measurement_qty}</td>
                <td>${selectedProduct.measure_unit}</td>
                <td>${selectedProduct.purchase_price}</td>
                <td class="kitTotalCost">${ parseFloat(parseFloat(selectedProduct.purchase_price)* parseFloat(unit_qty)).toFixed(2)}</td>
                <td>
                    <button type="button" class="btn btn-icon btn-ghost-danger rounded-circle" onclick="removeComponentTemp(this)">
                        <iconify-icon icon="line-md:trash" width="20"></iconify-icon>
                    </button>
                </td>
            </tr>`;
            //check if the product is already in the table
            let exists = false;
            tbody.find('tr').each(function() {
                if ($(this).data('component-product-id') == selectedProduct.id) {
                    exists = true;
                    return false; //break the loop
                }
            });
            if (!exists) {
                tbody.append(row);
            }

            calculate_total_cost_of_kit();
        }
    }

    function sendAddComponentRequest(data, kitId) {
        //Send AJAX request to add component to kit
        $.ajax({
            url: baseUrl + '/products/compiled_kits/add_component_to_kit',
            type: 'POST',
            data: data,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                console.log(response);
                
                //Refresh the kit components table
                get_kit_components(kitId);
            },
            error: function(xhr) {
                console.log(xhr.responseText);
            }
        });

    }

    function removeComponent(id_kit_config){ 
        //Confirm with swal
        Swal.fire({
            title: 'Remove Component?',
            text: `Are you sure you want to remove this component from the kit?`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Yes, Remove it!',
            cancelButtonText: 'No, Cancel',
            customClass: {
                confirmButton: 'btn btn-danger me-2',
                cancelButton: 'btn btn-secondary'
            },
            buttonsStyling: false
        }).then((result) => {
            if (result.isConfirmed) {
                //Send AJAX request to remove component
                $.ajax({
                    url: baseUrl + '/products/compiled_kits/remove_component_from_kit',
                    type: 'POST',
                    data: { id_kit_config: id_kit_config },
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    success: function(response) {
                        console.log(response);
                        //Refresh the kit components table
                        let kitId = $('#kitId').val();
                        get_kit_components(kitId);
                    },
                    error: function(xhr) {
                        console.log(xhr.responseText);
                    }
                });
            }
        });
    }


    function saveKit(){
        //validate the form
        if($('#kitForm')[0].checkValidity() === false){
            $('#kitForm')[0].reportValidity();
            return;
        }

        //check if there are components in the kit
        let kitId = $('#kitId').val();
        let componentsCount = $('#kitComponentsTable tbody tr').length;
        let components = [];
        if (componentsCount == 0) {
            Swal.fire({
                title: 'No Components',
                text: 'Please add at least one component to the kit before saving.',
                icon: 'warning',
                customClass: {
                    confirmButton: 'btn btn-warning'
                },
            });
            return;
        } else {
            //loop over the components table to prepare data
            
            $('#kitComponentsTable tbody tr').each(function() {
                let component = {
                    component_product_id: $(this).data('component-product-id'),
                    component_product_name: $(this).find('td').eq(1).text(),
                    component_quantity: $(this).find('td').eq(2).text(),
                    component_measure_qty: $(this).find('td').eq(3).text(),
                    component_measure_unit: $(this).find('td').eq(4).text(),
                    component_product_cost: $(this).find('td').eq(5).text(),
                };
                components.push(component);
            });
        }

        //get serailized data from the kit form
        let formData = $('#kitForm').serialize();
        formData += '&components=' + JSON.stringify(components);
        //Send AJAX request to save the kit
        $.ajax({
            url: baseUrl + '/products/compiled_kits/save_compiled_kit',
            type: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                
                if(response.success){
                    Swal.fire({
                        title: 'Kit Saved',
                        text: response.message,
                        icon: response.message_type,
                        customClass: {
                            confirmButton: response.message_type == 'success' ? 'btn btn-success' : 'btn btn-danger'
                        },
                    });

                    //Close the modal
                    let EL = document.getElementById('kitEditModal');
                    let modal = bootstrap.Modal.getInstance(EL);
                    modal.hide();

                    //Reload the compiled kits table
                    $('#compiledKitsTable').DataTable().ajax.reload();

                }else{ 
                    Swal.fire({
                        title: 'Kit Saved',
                        text: response.message,
                        icon: response.message_type,
                        customClass: {
                            confirmButton: response.message_type == 'success' ? 'btn btn-success' : 'btn btn-danger'
                        },
                    });
                }    
            },
            error: function(xhr) {
                console.log(xhr.responseText);
            }
        });

    }

    function removeComponentTemp(button){
        //Remove the component row from the table
        $(button).closest('tr').remove();
        calculate_total_cost_of_kit();
    }

    function calculate_total_cost_of_kit(){
        var kitTotalCost =0 
        $('#kitComponentsTable tbody tr').each(function() {
          kitTotalCost +=  parseFloat($(this).find('.kitTotalCost').text() || 0);
        });
        $("#kit_total_cost").text(parseFloat(kitTotalCost).toFixed(2));
    }
</script>
@endsection