@extends('layouts.horizontal', ['title' => 'Dispatch Notes', 'topbarTitle' => 'Products'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
<style>
    td.border-top-1 {
        border-top: 2px solid #000 !important;
    }
    tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
@endsection

@section('content')
<div class="Dispatch-page">
     <div class="container-fluid">
        <!-- start page title -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-title-box d-flex align-items-center justify-content-between">
                    <h2 class="mb-0">Product Dispatch (Consumption)</h2>
                    <div class="page-title-right d-flex align-items-center gap-3">
                        @php
                            $breadcrumb = getCurrentMenuBreadcrumb();
                        @endphp
                        @if(!empty($breadcrumb))
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb mb-0 py-2">
                                    @foreach($breadcrumb as $index => $item)
                                        @if($index === count($breadcrumb) - 1)
                                            <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                        @else
                                            <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                        @endif
                                    @endforeach
                                </ol>
                            </nav>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <!-- end page title -->
        @if ($errors->any())
        <div class="alert alert-info alert-dismissible d-flex align-items-center" role="alert">
            <button type="button" class="btn-close btn-close-info" data-bs-dismiss="alert" aria-label="Close"></button>
            <iconify-icon icon="solar:bell-bing-bold-duotone" class="fs-20 me-1"></iconify-icon>
            <div class="lh-1"><strong>Alert - 
                @foreach ($errors->all() as $error)
                {{ $error }}
                @endforeach
                </strong>
            </div>
        </div>
        @endif
        
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title">Filter Products</div>
                        <form id="filterform" >
                            <div class="row gap-1">          
                                <div class="col-md-3">
                                    <label class="form-label" for="business_store_id">Select Store</label>
                                    <select id="business_store_id" name="business_store_id" class="form-select">  
                                        @foreach($stores as $store)
                                            <option business_id="{{ $store->business_id }}" value="{{ $store->id_business_stores }}" @if($store->id_business_stores == $store_id) selected @endif>{{ $store->business_store }} ({{ $store->business_name }})</option>
                                        @endforeach
                                    </select>
                                </div>                
                                <div class="col-md-3">
                                    <label class="form-label" for="product_id">Product</label>
                                    <select id="product_id" name="product_id" class="form-select">
                                    </select>
                                </div>                                                
                                <div class="col-md-3">
                                    <button onclick="get_product_batches()" type="button" id="filterButton" class="btn btn-primary btn-sm mt-4">Batches</button>
                                </div>  
                                <div class="spinner-border text-primary mt-4 d-none" role="status" id="loadingSpinner">
                                    <span class="visually-hidden">Loading...</span>
                                </div>     
                            </div>
                        </form>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div id="selectedProductInfo" class="d-none">
                                    <table class="table table-bordered table-sm fs-13">
                                        <thead>
                                            <tr>
                                                <th>Product</th>
                                                 <th>Qty Per Unit</th>
                                                <th>Measure Unit</th>  
                                                <th>Batch ID</th>
                                                <th>Batch No.</th>
                                                <th>Store</th>
                                                <th>In Stock</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>                                            
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
        </div><!-- end row-->   
       

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title mb-4">
                            Dispatch Notes
                            <button type="button" id="reloadHistoryButton" class="btn btn-sm btn-outline-secondary float-end" onclick="get_dispatch_notes()">
                                <iconify-icon icon="mdi:reload" class="fs-16"></iconify-icon> History
                            </button>
                        </div>
                        <div class="table-responsive">
                            <table id="dispatchNotesTable" class="table table-bordered table-sm fs-13">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Date</th>
                                        <th>Batch ID</th>
                                        <th>Batch</th>
                                        <th>Dispatch Qty.</th>
                                        <th>Dispatch Measure</th>
                                        <th>Measure Unit</th>
                                        <th>Dispatched To</th>
                                        <th>Remarks</th>
                                        <th>Visit</th>
                                        <th>Request</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>                               
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> <!-- container-fluid -->
</div>

{{-- Dispatch Add Modal --}}
<div class="modal fade" id="dispatchAddModal" tabindex="-1" aria-labelledby="dispatchAddModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="dispatchAddModalLabel">Add Dispatch Note</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="dispatchAddForm">
                <div class="modal-body">                    
                    @csrf               
                    <input type="hidden" id="dispatch_product_id" name="dispatch_product_id">     
                    <input type="hidden" id="dispatch_store_id" name="dispatch_store_id">
                    <input type="hidden" id="dispatch_batch_id" name="dispatch_batch_id">
                    <input type="hidden" id="dispatch_batch" name="dispatch_batch">
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="dispatch_product" class="form-label">Product</label>
                            <input type="text" class="form-control" id="dispatch_product" name="dispatch_product" readonly required>
                        </div>
                        <div class="col-md-2">
                            <label for="available_qty" class="form-label">Available</label>
                            <input type="number" class="form-control" id="available_qty" name="available_qty" readonly required>
                        </div>
                        <div class="col-md-2">
                            <label for="dispatch_unit_type" class="form-label">Unit Type</label>
                            <input type="text" class="form-control" id="dispatch_unit_type" name="dispatch_unit_type" readonly required>
                        </div>
                        <div class="col-md-2">
                            <label for="dispatch_qty_per_unit" class="form-label">Per Unit</label>
                            <input type="text" class="form-control" id="dispatch_qty_per_unit" name="dispatch_qty_per_unit" readonly required> 
                        </div>
                        <div class="col-md-2">
                            <label for="dispatch_measure_unit" class="form-label">Measure Unit</label>
                            <input type="text" class="form-control" id="dispatch_measure_unit" name="dispatch_measure_unit" readonly required>
                        </div>                        
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label for="dispatch_date" class="form-label">Dispatch Date</label>
                            <input type="date" class="form-control" id="dispatch_date" name="dispatch_date" value="{{ date('Y-m-d') }}" readonly required>
                        </div>
                        <div class="col-md-6">
                            <label for="dispatched_to" class="form-label">Dispatched To</label>
                            <select class="form-select select2" id="dispatched_to" name="dispatched_to" required>
                            </select>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <label for="dispatch_quantity" class="form-label">Dispatch Quantity</label>
                            <input type="text" onkeyup="$('#dispatch_measure').val('0.00'); validateDispatchQuantity()" class="form-control" id="dispatch_quantity" name="dispatch_quantity" required>
                            <p class="form-text fs-6">If you are dispatching whole Bottle/s then add the number of Bottles here</p>
                        </div>
                        <div class="col-md-6">
                            <label for="dispatch_measure" class="form-label">Dispatch Measure</label>
                            <input type="text" onkeyup="$('#dispatch_quantity').val('0'); validateDispatchQuantity()" class="form-control" id="dispatch_measure" name="dispatch_measure" required>
                            <p class="form-text fs-6">If you are dispatching ml/s then add the ml/s here</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <label for="dispatch_comment" class="form-label">Remarks</label>
                            <textarea class="form-control" id="dispatch_comment" name="dispatch_comment" rows="3"></textarea>
                        </div> 
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <label for="visit_id" class="form-label">Link to Visit (Optional)</label>
                                    <select onclick="fillCurrentOpenVisits()" id="visit_id" name="visit_id" class="form-select">
                                        <option value="">Select Visit</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-12">
                                    <label for="service_id" class="form-label">Link to Service (Optional)</label>
                                    <select onclick="fillVisitServices($('#visit_id').val())" id="service_id" name="service_id" class="form-select">
                                        <option value="">Select Service</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>              
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" id="dispatchAddButton" onclick="addDispatchNote()" class="btn btn-primary">
                        <span class="spinner-border spinner-border-sm d-none me-2" role="status" aria-hidden="true" id="dispatchAddSpinner"></span>
                        Add Dispatch Note
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
    <script>
        const baseURL = '{{ url("") }}'; // Use relative paths
        const staffImageBase = "{{ asset('images/staff') }}/";
        const ImageBase = "{{ asset('images') }}/";
        const canCanceldispatch = "{{ auth()->user()->can('cancel-dispatch') }}";
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize Select2 on the product select element
            $('#product_id').select2({
                placeholder: 'Select a product',
                ajax: {
                    url: '{{ route("products.search_products") }}',
                    dataType: 'json',
                    delay: 1000,
                    data: function(params) {
                        return {
                            q: params.term, // search term
                            //business_id: '{{ $business_id }}',
                            store_id: $('#business_store_id').val() // Pass selected store ID
                        };
                    },
                    processResults: function(data) {
                       return {
                            results: data.map(function (item) {
                                return {
                                    id: item.id,
                                    text: item.business_brand_name + ' ' + item.product + ' ' + item.qty_per_unit + ' ' + item.measure_unit,
                                    measure_unit: item.measure_unit,
                                    qty_per_unit: item.qty_per_unit,
                                    product: item.product,
                                    brand: item.business_brand_name,
                                    batch_id: item.batch_id,
                                    batch_no: item.batch_no,
                                    store: item.store,
                                    price: item.price,
                                    instock: item.instock
                                };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 4
            });
        });

        document.getElementById('dispatchAddModal').addEventListener('hide.bs.modal', function () {
            //clear the form
            $('#dispatched_to').val(null).trigger('change');
            $('#dispatchAddForm')[0].reset();
            $("#visit_id").empty().append('<option value="">Select Visit</option>');
            $("#service_id").empty().append('<option value="">Select Service</option>');
            $("#dispatch_store_id").val('');
            $("#dispatch_batch_id").val('');
            $("#dispatch_batch").val('');
            $("#dispatch_product_id").val('');
            $("#available_qty").val('');
            $("#dispatch_product").val('');
            $("#dispatch_unit_type").val('');
            $("#dispatch_qty_per_unit").val('');
            $("#dispatch_measure_unit").val('');

        });

        function get_product_batches() {
            document.getElementById('loadingSpinner').classList.remove('d-none');
            $("#filterButton").prop("disabled", true);

            var product_id = $('#product_id').val();
            var store_id = $('#business_store_id').val(); // Pass selected store ID

            $.ajax({
                url: baseURL + "/products/fetch_store_stock",
                type: 'GET',
                data: {
                    product_id: product_id,
                    store_id: store_id
                },
                success: function(response) {
                    // Handle the response to populate batch information if needed
                    data=response.data;
                    //data = $.parseJSON(data);
                    console.log(data);
                    var tbody = $('#selectedProductInfo tbody');
                    tbody.empty();
                    if(data.length === 0) {
                        toastr.info('No batches found for the selected product in the chosen store.');
                        document.getElementById('selectedProductInfo').classList.add('d-none');
                        document.getElementById('loadingSpinner').classList.add('d-none');
                        $("#filterButton").prop("disabled", false);
                        return;
                    }
                    var total_available = 0;
                    data.forEach(function(item) {
                        var row = '<tr>' +
                            '<td>' + item.product + '</td>' +
                            '<td>' + item.qty_per_unit + '</td>' +
                            '<td>' + item.measure_unit + '</td>' +
                            '<td>' + item.batch_id + '</td>' +
                            '<td>' + item.batch_no + '</td>' +
                            '<td>' + item.store + '</td>' +
                            '<td>' + item.instock + '</td>' +
                            '<td><button onclick="openDispatchModal(' + item.id + ', ' + item.store_id + ', ' + item.batch_id + ', \'' + item.batch_no + '\', ' + item.instock + ', \'' + item.product + '\', \'' + item.measure_unit + '\', \'' + item.unit_type + '\' , \'' + item.qty_per_unit + '\')" class="btn btn-outline-success btn-sm">Dispatch</button></td>' +
                            '</tr>';
                        total_available += parseFloat(item.instock);
                        tbody.append(row);
                       
                       // get_dispatch_notes();
                    });
                    //add total row
                    total_available = Math.round((total_available + Number.EPSILON) * 1000) / 1000;
                    var totalRow = '<tr class="border-top-1">' +
                        '<td colspan="6" class="text-end"><strong>Total Available:</strong></td>' +
                        '<td><strong>' + total_available + '</strong></td>' +
                        '<td><button onclick="openDispatchModal(' +data[0].id + ', ' +data[0].store_id + ', \'\' ' + ', \'\', '  + total_available + ', \'' +data[0].product.replace(/'/g, "\\'") + '\', \'' +data[0].measure_unit + '\', \'' +data[0].unit_type + '\', \'' +data[0].qty_per_unit +'\')" class="btn btn-outline-success btn-sm">Dispatch</button></td>'+
                        '</tr>';
                    tbody.append(totalRow);

                    document.getElementById('selectedProductInfo').classList.remove('d-none');

                    document.getElementById('loadingSpinner').classList.add('d-none');
                    $("#filterButton").prop("disabled", false);
                },
                error: function() {
                    toastr.error('Error retrieving product batches.');
                    document.getElementById('loadingSpinner').classList.add('d-none');
                    $("#filterButton").prop("disabled", false);
                }
            });

        }

        function get_dispatch_notes() {
            document.getElementById('loadingSpinner').classList.remove('d-none');
            $("#reloadHistoryButton").prop("disabled", true);
           
            var store_id = $('#business_store_id').val();
            var product_id = $('#product_id').val();

            $.ajax({
                url: '{{ route("dispatch_notes.get_dispatch_notes_data") }}',
                type: 'GET',
                data: {
                    store_id: store_id,
                    product_id: product_id
                },
                success: function(response) {
                    document.getElementById('loadingSpinner').classList.add('d-none');
                    $("#reloadHistoryButton").prop("disabled", false);

                    data=response.data;
                    // Re-initialize DataTable
                    if ($.fn.DataTable.isDataTable('#dispatchNotesTable')) {
                        $('#dispatchNotesTable').DataTable().destroy();
                    }

                    var tbody = $('#dispatchNotesTable tbody');
                    tbody.empty();
                    
                    data.forEach(function(note) {
                        var status = note.status;
                        var actionBtn = '';
                        if(canCanceldispatch){
                            actionBtn += '<button' + (note.status == 'Cancelled' ? ' disabled' : '') + ' type="button" onclick="cancel_dispatch_note(' + note.id_dispatch_note + ')" class="btn btn-ghost-danger btn-sm btn-icon rounded-circle"><i class="ri-delete-bin-line"></i></button></form>';
                        }

                        var row = '<tr' + (note.status == 'Cancelled' ? ' class="strike-through"' : '') + '>' +
                            '<td>' + note.id_dispatch_note + '</td>' +
                            '<td>' + note.formatted_dispatch_date + '</td>' +
                            '<td>' + note.batch_id + '</td>' +
                            '<td>' + note.batch + '</td>' +
                            '<td>' + note.dispatch_qty + '</td>' +
                            '<td>' + note.dispatch_measure + '</td>' +
                            '<td>' + note.measure_unit + '</td>' +
                            '<td>' + note.dispatched_to + '</td>' +
                            '<td>' + (note.dispatch_comment ? note.dispatch_comment : '') + '</td>' +
                            '<td>' + note.visit_id + '</td>' +
                            '<td>' + note.request_id + '</td>' +
                            '<td>' + actionBtn + '</td>' + '</tr>';
                        tbody.append(row);
                        
                    });
                    
                    
                    $('#dispatchNotesTable').DataTable({
                        "order": [[ 0, "desc" ]],
                        "pageLength": 10,
                        "lengthMenu": [10, 25, 50, 100, 200],
                        
                    });
                  
                },
                error: function() {
                    toastr.error('Error retrieving dispatch notes.');
                    document.getElementById('loadingSpinner').classList.add('d-none');
                    $("#reloadHistoryButton").prop("disabled", false);
                    $("#filterButton").prop("disabled", false);
                }
            });
        }
    
        function cancel_dispatch_note(id_dispatch_note) {
            Swal.fire({
                type: 'danger',
                title: 'Are you sure?',
                text: "You are about to cancel this dispatch note.",
                icon: 'question',
                showCancelButton: true,
                customClass: {
                    confirmButton: 'btn btn-secondary me-2',
                    cancelButton: 'btn btn-danger'
                },
                confirmButtonText: 'Yes, cancel it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    let url = "{{ route('dispatch_notes.cancel_dispatch', ['id' => ':id']) }}";
                    url = url.replace(':id', id_dispatch_note);

                    fetch(url, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            },
                            body: JSON.stringify({})
                        }).then(response => response.json())
                        .then(data => {
                            if(data.message_type=='success'){
                                toastr.success(data.message);
                                
                            } else {
                                toastr.error(data.message);
                            }
                            get_dispatch_notes(); // Refresh the dispatch notes list
                        }).catch(error => {
                            console.error('Error:', error);
                            toastr.error('An error occurred while cancelling the dispatch note.');
                    });
                }
            });
            
        }

        function openDispatchModal(product_id, store_id, batch_id, batch, available_qty, product_name, measure_unit, unit_type, qty_per_unit) {
            $('#dispatch_product_id').val(product_id);
            $('#dispatch_store_id').val(store_id);
            $('#dispatch_batch_id').val(batch_id);
            $('#dispatch_batch').val(batch);
            $('#available_qty').val(available_qty);
            $('#dispatch_product').val(product_name);
            $('#dispatch_measure_unit').val(measure_unit);
            $('#dispatch_unit_type').val(unit_type);
            $('#dispatch_qty_per_unit').val(qty_per_unit);

            let max_dispatch_measure = available_qty * qty_per_unit;
            $("#dispatch_measure").attr("max", max_dispatch_measure);
            $("#dispatch_measure").attr("placeholder", "Max: " + max_dispatch_measure + " " + measure_unit);

            $("#dispatch_quantity").attr("max", available_qty);
            $("#dispatch_quantity").attr("placeholder", "Max: " + available_qty + " " + unit_type);
            //reinitialize select2 for dispatched_to
            if ($('#dispatched_to').hasClass("select2-hidden-accessible")) {
                $('#dispatched_to').select2('destroy');   // 1. Destroy Select2 UI
            }
            $('#dispatched_to').empty();                   // 2. Remove old options
            $('#dispatched_to').val(null);                 // 3. Clear selected value

            search_staff();                                // 4. Reinitialize Select2

            let el= document.getElementById('dispatchAddModal');
            let modal = new bootstrap.Modal(el);
            modal.show();
        }

        function validateDispatchQuantity() {
            let max_qty = $("#dispatch_quantity").attr("max");
            let max_measure = $("#dispatch_measure").attr("max");
            let dispatch_quantity = parseFloat($('#dispatch_quantity').val());
            let dispatch_measure = parseFloat($('#dispatch_measure').val());

            
            //greater than zero check 
            if(dispatch_quantity < 0) {
                $("#dispatch_quantity").val('0');
            } if(dispatch_measure < 0) {
                $("#dispatch_measure").val('0.00');
            }

            //max limit check
            if (dispatch_quantity > max_qty) {
                toastr.error('Dispatch Quantity cannot exceed Available Quantity of ' + max_qty);
                $('#dispatch_quantity').val(max_qty);
            }

            if (dispatch_measure > max_measure) {
                toastr.error('Dispatch Quantity cannot exceed Available Quantity of ' + max_measure);
                $('#dispatch_measure').val(max_measure);
            }
        }

        function search_staff(){
            var business_id = $("#business_store_id option:selected").attr('business_id');

            // use select2 ajax to search staff
            $('#dispatched_to').select2({
                placeholder: 'Select Staff Member',
                dropdownParent: $('#dispatchAddModal'),
                minimumInputLength: 3,
                ajax: {
                    url: '{{ route("staff.staff_search") }}',
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            term: params.term, // search term
                            business_id: business_id
                        };
                    },
                    processResults: function (data) {
                        console.log(data);
                        return {
                            results: data.map(function(item){
                                return {
                                    id: item.id,
                                    text: item.text,
                                    staff_cell: item.staff_cell,
                                    branch: item.business_name,
                                    staff_type: item.staff_type,
                                    staff_image: item.staff_image // <- make sure server sends this
                                };
                            })
                        };
                    },
                    cache: true
                },
                templateResult: formatStaff,      // dropdown items
                templateSelection: formatStaff // selected item
                
            });
        }
        function formatStaff (option) {
           if (!option.id) {
                return option.text;
            }

            var imgSrc = staffImageBase + option.staff_image;
            return $('<span><img src="'+ imgSrc +'" class="avatar-sm rounded-circle me-2" /> ' + option.text + ' - ' + option.branch + ' - ' + option.staff_type + '</span>');
        }

        function fillCurrentOpenVisits() {

            if($('#visit_id').children().length > 1){
                //already filled
                return;
            }

            document.getElementById('dispatchAddSpinner').classList.remove('d-none');
            document.getElementById('dispatchAddButton').disabled = true;

            var business_id = $('#business_store_id').find('option:selected').attr('business_id');
            var for_day = '{{ date("Y-m-d") }}';

            $.ajax({
                url: '{{ route("get_day_visits_by_status") }}',
                type: 'GET',
                data: {
                    for_day: for_day,
                    business_id: business_id,
                    status: ['open', 'invoiced']
                },
                success: function(response) {
                    document.getElementById('dispatchAddSpinner').classList.add('d-none');
                    document.getElementById('dispatchAddButton').disabled = false;
                    if(response.message_type=='error'){
                        toastr.error(response.message);
                        return;
                    }
                    data=response.currently_open_visits;
                    var visitSelect = $('#visit_id');
                    visitSelect.empty();
                    visitSelect.append('<option value="">Select Visit</option>');

                    data.forEach(function(visit) {
                        var option = '<option value="' + visit.id + '">' + visit.text + ' (' + visit.service_time + ')</option>';
                        visitSelect.append(option);
                    });
                },
                error: function() {
                    document.getElementById('dispatchAddSpinner').classList.add('d-none');
                    document.getElementById('dispatchAddButton').disabled = false;
                    toastr.error('Error retrieving open visits.');
                }
            });
        }

        function fillVisitServices(visit_id) {
            //if already filled return
            if($('#service_id').children().length > 1){
                return;
            }

            if(!visit_id) {
                //$("#service_id").empty().append('<option value="">Select Service</option>');
                return;
            }

            document.getElementById('dispatchAddSpinner').classList.remove('d-none');
            document.getElementById('dispatchAddButton').disabled = true;

            $.ajax({
                url: baseURL + "/get_visit_services/" + visit_id,
                type: 'GET',
                success: function(response) {
                    document.getElementById('dispatchAddSpinner').classList.add('d-none');
                    document.getElementById('dispatchAddButton').disabled = false;

                    data=response.visit_services;
                    var serviceSelect = $('#service_id');
                    serviceSelect.empty();
                    serviceSelect.append('<option value="">Select Service</option>');

                    data.forEach(function(service) {
                        var option = '<option value="' + service.id + '">' + service.text + '</option>';
                        serviceSelect.append(option);
                    });
                },
                error: function() {
                    document.getElementById('dispatchAddSpinner').classList.add('d-none');
                    document.getElementById('dispatchAddButton').disabled = false;
                    toastr.error('Error retrieving visit services.');
                }
            });
        }

        function addDispatchNote() {
          

            //disable button
            document.getElementById('dispatchAddButton').disabled = true;
            document.getElementById('dispatchAddSpinner').classList.remove('d-none');

            var dispatch_qty = parseFloat($('#dispatch_quantity').val()) || 0;
            var dispatch_measure = parseFloat($('#dispatch_measure').val()) || 0;

            if(dispatch_qty > 0 && dispatch_measure == 0) {
                //calculate dispatch_measure
                var qty_per_unit = parseFloat($('#dispatch_qty_per_unit').val());
                dispatch_measure = dispatch_qty * qty_per_unit;
                //round to four decimal places
                dispatch_measure = Math.round((dispatch_measure + Number.EPSILON) * 10000) / 10000;
            } else if(dispatch_measure > 0 && dispatch_qty == 0) {
                //calculate dispatch_qty
                var qty_per_unit = parseFloat($('#dispatch_qty_per_unit').val());
                dispatch_qty = dispatch_measure / qty_per_unit;
                //round to four decimal places
                dispatch_qty = Math.round((dispatch_qty + Number.EPSILON) * 10000) / 10000;
            } else {
                document.getElementById('dispatchAddButton').disabled = false;
                document.getElementById('dispatchAddSpinner').classList.add('d-none');

                toastr.error('Please fill either Dispatch Quantity or Dispatch Measure.');
                return;
            }

            if(dispatch_qty == 0 || dispatch_measure == 0) {
                document.getElementById('dispatchAddButton').disabled = false;
                document.getElementById('dispatchAddSpinner').classList.add('d-none');
                toastr.error('Dispatch Quantity and Dispatch Measure must be greater than zero.');
                return;
            }

            var product_id = $('#dispatch_product_id').val();
            var store_id = $('#dispatch_store_id').val();
            var batch_id = $('#dispatch_batch_id').val();
            var batch = $('#dispach_batch').val();
            var dispatched_to = $('#dispatched_to').val();
            if(!dispatched_to) {
                document.getElementById('dispatchAddButton').disabled = false;
                document.getElementById('dispatchAddSpinner').classList.add('d-none');
                toastr.error('Please select the staff member to whom the product is dispatched.');
                return;
            }

            //serialize dispatchAddForm data
            var formData = $("#dispatchAddForm").serialize();

            //add dispatch_qty and dispatch_measure to formData
            formData += '&calculated_dispatch_qty=' + dispatch_qty + '&calculated_dispatch_measure=' + dispatch_measure;

            console.log(formData);

            fetch('{{ route("dispatch_notes.add_dispatch_note") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: formData
            }).then(response => response.json())
            .then(data => {
                document.getElementById('dispatchAddButton').disabled = false;
                document.getElementById('dispatchAddSpinner').classList.add('d-none');
                if(data.message_type=='success'){
                    toastr.success(data.message);

                    el = document.getElementById('dispatchAddModal');
                    modal = bootstrap.Modal.getInstance(el);
                    modal.hide();

                    get_product_batches(); // Refresh the product batches
                    get_dispatch_notes(); // Refresh the dispatch notes list
                } else {
                    toastr.error(data.message);
                }
            }).catch(error => {
                console.error('Error:', error);
                document.getElementById('dispatchAddButton').disabled = false;
                document.getElementById('dispatchAddSpinner').classList.add('d-none');
                toastr.error('An error occurred while adding the dispatch note.');
            });

        }

    </script>
@endsection