@extends('layouts.horizontal', ['title' => 'Dispatch Requests', 'topbarTitle' => 'Products'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
<style>
    tr.border-top-1 > td {
        border-top: 1px solid #000 !important;
    }
    tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
@endsection

@section('content')

<div class="Dispatch-Requests-page">
     <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h3 class="mb-sm-0 font-size-18">Dispatch Requests</h3>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="javascript: void(0);">Products</a></li>
                            <li class="breadcrumb-item active">Dispatch Requests</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row {{ session('user_role') != 'Super User' && session('user_role') != 'Super Admin' ? 'd-none' : '' }}">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title">
                            Filter
                        </div>
                        <div class="row">                                            
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">                                    
                                <label class="form-label" for="invoiceDate">Select Date</label>
                                <input type="date" class="form-control" id="invoiceDate" name="start_date" value="{{ $today ?? date('Y-m-d') }}" placeholder="Select Date" required>
                            </div>
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">  
                                <label class="form-label" for="business_id">Branch</label>    
                                <select class="form-select select2" id="business_id" name="business_id">
                                    @foreach($businesses as $business)
                                        <option value="{{ $business->id_business }}" {{ $business->id_business == $business_id ? 'selected' : '' }}>{{ $business->business_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3 d-flex align-items-end">
                                <button id="btn_refresh_table" type="button" class="btn btn-sm btn-ghost-primary btn-icon rounded-circle mt-3" >
                                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                    <iconify-icon icon="mdi:refresh" width="30px"></iconify-icon>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- end row-->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title mb-4">
                            <strong class="text-success fw-bold fs-16">Dispatch From :</strong>
                            <select id="store_id" class="form-select" name="store_id" style ="width: auto; display: inline-block; margin-left: 10px;">
                                <option value="0">Select Store</option>
                                @foreach($stores as $store)
                                    <option  value="{{ $store->id_business_stores }}" {{ $store->id_business_stores == $store_id ? 'selected' : '' }}>{{ $store->business_store }}</option>    
                                @endforeach
                            </select>                            
                        </div>
                        <table id="dispatch_requests_table" class="table table-bordered fs-13 dt-responsive w-100">
                            <thead>
                                <tr>
                                    <th>Request ID</th>
                                    <th>Visit ID</th>
                                    <th>Customer</th>
                                    <th>Service</th>
                                    <th>Staff</th>
                                    <th>Status</th>
                                    <th>Request Date</th>
                                    <th>Product</th>
                                    <th>Qty Per Unit</th>
                                    <th>Change</th>
                                    <th>Quantity</th>                                    
                                    <th>Unit</th>
                                    <th>Qty</th>
                                    <th>Dispatch</th>
                                    <th>Add</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be populated via JavaScript -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{{-- Modal Product Change --}}
<div class="modal fade" id="change_product_modal" tabindex="-1" aria-labelledby="changeProductModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="changeProductModalLabel">Change Product</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="change_product_modal_body">
                <input id="current_product_id" type="hidden" value="" />
                <input id="dispatch_request_id" type="hidden" value="" />
                <input id="visit_id" type="hidden" value="" />
                <div class="row mb-3">
                    <div class="col-6">
                        <label for="new_dispatch_qty" class="form-label">Dispatch Qty.</label>
                        <input id="new_dispatch_qty" name="new_dispatch_qty" class="form-control" type="text" readonly value="" />
                    </div>
                    <div class="col-6">
                        <label for="new_unit_type" class="form-label">Unit</label>
                        <input id="new_unit_type" name="new_unit_type" class="form-control" type="text" readonly value="" />
                    </div>
                </div>
                
                <label for="new_product_select" class="form-label">Select New Product</label>
                <select onchange="onProductChange()" class="form-select select2" id="new_product_select" name="new_product_select">
                </select>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="save_product_change()" id="save_product_change_btn" type="button" class="btn btn-primary">
                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                    Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- End Modal Product Change --}}
{{-- Modal Product Add --}}
<div class="modal fade" id="add_product_modal" tabindex="-1" aria-labelledby="addProductModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addProductModalLabel">Add Product to Dispatch Request</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="add_product_modal_body">
                <!-- Content will be loaded via JavaScript -->
            </div>
        </div>
    </div>
</div>
{{-- End Modal Product Add --}}
@endsection
@section('scripts')
<script>
    $(document).ready(function() {
        //make new product select a select2 with ajax
        $('#new_product_select').select2({
            placeholder: 'Select a product',
            dropdownParent: $('#change_product_modal'),
            ajax: {
                url: '{{ route("products.search_products") }}',
                dataType: 'json',
                delay: 500,
                
                data: function(params) {
                    return {
                        q: params.term, // search term
                        //store_id: $('#store_id').val() // Pass selected store ID
                    };
                },
                processResults: function(data) {
                    return {
                        results: data.map(function (item) {
                            return {
                                id: item.id,
                                text: item.business_brand_name + ' ' + item.product + ' ' + item.qty_per_unit + ' ' + item.measure_unit,
                                measure_unit: item.measure_unit,
                                qty_per_unit: item.qty_per_unit,
                                product: item.product,
                                brand: item.business_brand_name,
                                batch_id: item.batch_id,
                                batch_no: item.batch_no,
                                store: item.store,
                                price: item.price,
                                instock: item.instock
                            };
                        })
                    };
                },
                cache: true
            },
            minimumInputLength: 4
        });

        document.getElementById('btn_refresh_table').addEventListener('click', function() {
            $('#dispatch_requests_table').DataTable().ajax.reload();
        });

        console.log('Initializing Dispatch Requests DataTable');
        var last_visit_id = null;
        var table = $('#dispatch_requests_table').DataTable({
            processing: true,
            serverSide: true,
            stateSave: true,
            pageLength: 25,
            lengthMenu: [ [10, 25, 50, 100], [10, 25, 50, 100] ],
            ordering: false,
            ajax: {
                url: '{{ route("dispatch_request.get_dispatch_requests_data") }}',
                type: 'GET',
                data: function(d) {
                    d.business_id = $('#business_id').val(),
                    d.start_date = $('#invoiceDate').val()
                }
            },
            columns: [
                { data: 'id_dispatch_request', name: 'id_dispatch_request' },
                { data: 'id_customer_visits', name: 'id_customer_visits' },                
                { data: 'customer_name', name: 'customer_name' },
                { data: 'service_name', name: 'service_name', 
                    createdCell: function(td, cellData, rowData) {
                        $(td).attr('data-visit-service-id', rowData.visit_service_id);
                    }
                 },
                { data: 'staff', name: 'staff',
                    createdCell: function(td, cellData, rowData) {
                        $(td).attr('data-staff-id', rowData.staff_id);
                    }
                 },
                { data: 'dispatch_request_status', name: 'dispatch_request_status' },                
                { data: 'formatted_request_date', name: 'formatted_request_date' },
                { data: 'product', name: 'product', 
                    createdCell: function(td, cellData, rowData) {
                        $(td).attr('data-product-id', rowData.product_id);
                    }
                },
                { data: 'qty_per_unit', name: 'qty_per_unit'},
                { data: null, name: 'change',
                    render: function(data, type, row) {
                        if(data.remaining_qty > 0) {
                        return `<button class="btn btn-icon btn-ghost-secondary rounded-circle" onclick="open_change_product_modal(` + row.product_id + `, ` + row.id_dispatch_request + `, ` + row.remaining_qty + `, '` + row.product_unit + `', ` + row.id_customer_visits + `)">
                            <iconify-icon icon="mdi:square-edit-outline" width="20" height="20"></iconify-icon>    
                        </button>`;
                        }else{
                            return ``;
                        }
                    }
                 },
                { data: 'remaining_qty', name: 'remaining_qty' }, 
                { data: 'product_unit', name: 'product_unit',
                    createdCell: function(td, cellData, rowData) {
                        $(td).attr('data-unit-type', rowData.unit_type);
                    }
                 },               
                { data: null, name: 'dispatch',
                    render: function(data, type, row) {
                        return `<input type="number" onkeyup="if(parseInt(this.value) > ` + row.remaining_qty + ` || parseInt(this.value) < 0 || isNaN(parseInt(this.value))) this.value = ` + row.remaining_qty + `;" class="form-control form-control-sm" min="0" max=` + row.remaining_qty + ` step="1" value="` + row.remaining_qty + `" />`;
                    }
                },
                { data: null, name: null, 
                orderable: false, 
                searchable: false 
                    , render: function(data, type, row) {
                        if(data.remaining_qty <= 0) {
                            return `
                                <iconify-icon icon="mdi:check-circle-outline" width="20" height="20"></iconify-icon>
                            `;
                        }
                        return `<button class="btn btn-icon btn-ghost-success" onclick="dispatch(` + row.id_dispatch_request + `, this)">
                            <iconify-icon icon="solar:course-up-linear" width="20" height="20"></iconify-icon>
                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                        </button>`;
                    } 
                },
                { data: null, name: null, 
                orderable: false, searchable: false 
                    , render: function(data, type, row) {
                        return `<button class="btn btn-icon btn-ghost-secondary rounded-circle" onclick="open_add_product_modal(` + row.id_dispatch_request + `, ` + row.remaining_qty + `, '` + row.product_unit + `', ` + row.id_customer_visits + `)">
                            <iconify-icon icon="mdi:plus-box-outline" width="20" height="20"></iconify-icon>    
                        </button>`;
                    }
                 },
            ],
            rowCallback: function(row, data) {
                if (data.id_customer_visits != last_visit_id) {
                    $(row).addClass('border-top-1');
                } 
                last_visit_id = data.id_customer_visits;
                
            },
        });
    });

    function open_change_product_modal(product_id, dispatch_request_id, remaining_qty, unit_type, visit_id=null) {
        console.log(unit_type);
        $('#current_product_id').val(product_id);
        $('#new_dispatch_qty').val(remaining_qty);
        $("#new_dispatch_qty").prop("readonly", true);
        $('#new_unit_type').val(unit_type);
        $("#new_unit_type").prop("readonly", true);
        $('#dispatch_request_id').val(dispatch_request_id);
        $('#new_product_select').val(null).trigger('change');
        $('#visit_id').val(visit_id);
        

        let modal = new bootstrap.Modal(document.getElementById('change_product_modal'));
        modal.show();
       
    }

    function open_add_product_modal(dispatch_request_id, remaining_qty, unit_type, visit_id) {
        $('#current_product_id').val('');
        $("#dispatch_request_id").val(dispatch_request_id);
        $('#new_dispatch_qty').val(remaining_qty);
        $("#new_dispatch_qty").prop("readonly", false);
        $('#new_unit_type').val(unit_type);
        $("#new_unit_type").prop("readonly", true);
        $('#new_product_select').val(null).trigger('change');
        $('#visit_id').val(visit_id);

        let modal = new bootstrap.Modal(document.getElementById('change_product_modal'));
        modal.show();
       
    }

    function onProductChange() {
        let selectedData = $('#new_product_select').select2('data')[0];
        // if (selectedData) {
        //     console.log('Selected Product Details:');
        //     console.log('ID:', selectedData.id);
        //     console.log('Text:', selectedData.text);
        //     console.log('Measure Unit:', selectedData.measure_unit);
        //     console.log('Qty Per Unit:', selectedData.qty_per_unit);
        //     console.log('Batch ID:', selectedData.batch_id);
        //     console.log('Batch No:', selectedData.batch_no);
        //     console.log('Store:', selectedData.store);
        //     console.log('Price:', selectedData.price);
        //     console.log('In Stock:', selectedData.instock);
        // }

        $('#new_unit_type').val(selectedData ? selectedData.measure_unit : $("#new_unit_type").val());

    }

    function save_product_change() {
        $('#save_product_change_btn .spinner-border').removeClass('d-none');
        $('#save_product_change_btn').prop('disabled', true);

        let current_product_id = $('#current_product_id').val();
        let new_product_id = $('#new_product_select').select2('data')[0].id;
        let new_product_name = $('#new_product_select').select2('data')[0].product;
        let dispatch_request_id = $('#dispatch_request_id').val();

        
        // Perform AJAX request to save the product change
        $.ajax({
            url: '{{ route("dispatch_request.change_add_product") }}',
            method: 'POST',
            data: {
                current_product_id: current_product_id,
                new_product_id: new_product_id,
                new_product_name: new_product_name,
                dispatch_request_id: dispatch_request_id,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                $('#save_product_change_btn .spinner-border').addClass('d-none');
                    $('#save_product_change_btn').prop('disabled', false);
                if(response.message_type=='success'){
                    
                    toastr.success(response.message);
                    // Handle success response
                    $('#dispatch_requests_table').DataTable().ajax.reload();
                    let modal = bootstrap.Modal.getInstance(document.getElementById('change_product_modal'));
                    modal.hide();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                $('#save_product_change_btn .spinner-border').addClass('d-none');
                $('#save_product_change_btn').prop('disabled', false);

                // Handle error response
                toastr.error('Error changing product' + xhr.responseText);
            }
        });
    }

    function dispatch(dispatch_request_id, btn) {
        if($('#store_id').val() == 0) {
            toastr.error('Please select a store to dispatch from.');
            return;
        }
        
        let measure_qty_to_deduct = $(btn).closest('tr').find('input[type="number"]').val();
        let measure_unit = $(btn).closest('tr').find('td').eq(11).text();
        let qty_per_unit = $(btn).closest('tr').find('td').eq(8).text();

        let calculated_dispatch_qty = Math.round((parseFloat(measure_qty_to_deduct) / parseFloat(qty_per_unit)) * 10000) / 10000; //round 4 decimal places

        let product_id = $(btn).closest('tr').find('td').eq(7).data('product-id');
        let product_name = $(btn).closest('tr').find('td').eq(7).text();
        let staff_id = $(btn).closest('tr').find('td').eq(4).data('staff-id');
        let unit_type = $(btn).closest('tr').find('td').eq(11).data('unit-type');
        product_name = product_name.replace(/^\d+-/, '').trim(); // Remove product ID prefix
        let visit_service_id = $(btn).closest('tr').find('td').eq(3).data('visit-service-id');
        let visit_id = $(btn).closest('tr').find('td').eq(1).text();
        let request_id = $(btn).closest('tr').find('td').eq(0).text();

        // console.log("qty:"+qty_per_unit);
        // console.log("measure_unit:"+measure_unit);
        // console.log("measure_qty_to_deduct:"+measure_qty_to_deduct);
        // console.log("calculated_dispatch_qty:"+calculated_dispatch_qty);
        // console.log("product_id:"+product_id);
        // console.log("product_name:"+product_name);
        // console.log("staff_id:"+staff_id);
        // console.log("unit_type:"+unit_type);
        // console.log("visit_service_id:"+visit_service_id);
        // console.log("visit_id:"+visit_id);
        // console.log("request_id:"+request_id);
        // return;
        
        if(isNaN(measure_qty_to_deduct) || measure_qty_to_deduct <= 0) {
            toastr.error('Please enter a valid dispatch quantity greater than zero.');
            return;
        }

        $(btn).find('.spinner-border').removeClass('d-none');
        $(btn).prop('disabled', true);

        //get variable values from the current row


        $.ajax({
            url: '{{ route("dispatch_notes.add_dispatch_note") }}',
            method: 'POST',
            data: {
                dispatch_request_id: dispatch_request_id,
                calculated_dispatch_qty: calculated_dispatch_qty,
                measure_qty_to_deduct: measure_qty_to_deduct,
                dispatch_product_id: product_id,
                dispatch_product: product_name,
                dispatch_store_id: $('#store_id').val(),
                dispatch_qty_per_unit: qty_per_unit,
                dispatched_to: staff_id,
                dispatch_unit_type: unit_type,
                dispatch_measure_unit: measure_unit,
                dispatch_comment: 'Dispatched via Dispatch Requests Page against Request ID ' + dispatch_request_id + '. For Visit ID : ' + visit_id,
                visit_id: visit_id,
                visit_service_id: visit_service_id,
                request_id: request_id,

                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                $(btn).find('.spinner-border').addClass('d-none');
                $(btn).prop('disabled', false);

                if(response.message_type=='success'){
                    toastr.success(response.message);
                    $('#dispatch_requests_table').DataTable().ajax.reload();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                $(btn).find('.spinner-border').addClass('d-none');
                $(btn).prop('disabled', false);

                toastr.error('Error visiting dispatch request: ' + xhr.responseText);
            }
        });
    }

</script>
@endsection