@extends('layouts.horizontal', ['title' => 'Batches', 'topbarTitle' => 'Product Batches', 'nonav' => true])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
    .page-container {
        max-width: 98% !important;
        margin: 0 auto;
    }
    tr.strike-through > td {color:red;} 
</style>
<div class="batchesPage container-fullwidth">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Product Batches</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @if($product->product_type == "Compiled Kit")
                    <button type="button" class="btn btn-outline-success me-3" id="addBatchButton" onclick="openKitBatchEditModal()">
                        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="addBatchSpinner"></span> 
                        <iconify-icon icon="line-md:uploading-loop" class="me-1" width="18"></iconify-icon>
                        Add Inventory</button>
                    @else
                    <button type="button" class="btn btn-outline-success me-3" id="addBatchButton" onclick="openAddBatchModal()">
                        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="addBatchSpinner"></span><iconify-icon icon="line-md:uploading-loop" class="me-1" width="18"></iconify-icon> Add Batch</button>
                    @endif
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
     <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title"><h3>{{ $product->product }}</h3></div>
                    <form id="filterform" method="GET" action="">
                        <div class="row">                            
                            <div class="col-md-3">                                
                                <p class="m-0 p-0"><label class="form-label" for="branch_id">Product ID:</label> {{ $product->id_business_products }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="store_id">Product:</label> {{ $product->product }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="brand_id">Brand:</label> {{ $product->business_brand_name }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="category_id">Category:</label> {{ $product->category }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="sku">SKU:</label> {{ $product->sku }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="store_id">BarCode:</label> {{ $product->barcode_product }}</p>
                                <p class="m-0 p-0">
                                <select id="store_id" name="store_id" class="form-select form-select-sm" onchange="this.form.submit()">  
                                    <option value="">-- All Stores --</option>                                  
                                    @foreach($stores as $store)
                                        <option value="{{ $store->id_business_stores }}" @if($store->id_business_stores == $store_id) selected @endif>{{ $store->business_store }}</option>
                                    @endforeach
                                </select>
                                </p>
                            </div>
                            <div class="col-md-3">
                                <p class="m-0 p-0"><label class="form-label" for="branch_id">Qty. Per Unit:</label> {{ $product->qty_per_unit. ' '.$product->measure_unit }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="store_id">Unit Type:</label> {{ $product->unit_type }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="brand_id">Retail Price:</label> {{ $product->price }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="category_id">Purchase Price:</label> {{ $product->purchase_price }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="sku">Reorder Level:</label> {{ $product->product_threshold }}</p>
                                <p class="m-0 p-0"><label class="form-label" for="store_id">Use:</label> {!! $product->professional == 'y' ? '<span class="badge bg-success" >Professional</span>' : '<span class="badge bg-info">Retail</span>' !!}</p>
                                
                            </div>    
                            <div class="col-md-6">
                                <!- - Reserved for future use - ->
                                @if($product->product_type == "Compiled Kit")
                                    <p class="m-0 p-0"><label class="form-label" for="store_id">Kit Components:</label> 
                                        <table class="table table-bordered fs-12">
                                            <thead>
                                                <tr>
                                                    <th>Component Name</th>
                                                    <th>Quantity</th>                                                    
                                                    <th>Measure Qty</th>
                                                    <td>Measure Unit</td>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($product->kit_components as $component)
                                                <tr>
                                                    <td><a href="{{route('products.batches', $component->business_product_id)}}" target="_blank"> {{ $component->component_name }}</a></td>
                                                    <td>{{ $component->kit_qty }}</td>
                                                    <td>{{ $component->kit_measure_qty }}</td>                                                    
                                                    <td>{{ $component->measure_unit }}</td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </p>
                                @endif
                            </div> 
                                                   
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="productBatchesTable" class="table table-bordered dt-responsive fs-12 w-100">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Batch Number</th>
                                <th>Store</th>
                                <th>Batch Created</th>
                                <th>Expiry Date</th>
                                <th>Expires In</th>
                                <th>Added Manually</th>
                                <th>Purchased Qty</th>
                                <th>Transfer In</th>
                                <th>Transfer Out</th>
                                <th>Sold</th>
                                <th>Used</th>
                                <th>Returned</th>
                                <th>Remaining Qty</th>
                                <th>In Measure</th>
                                <th>Cost Price</th>
                                <th>Avaiable Stock Value</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($batches as $batch)
                            <tr>
                                <td>{{ $batch->id_batch }}</td>
                                <td>{{ $batch->batch_number }}</td>
                                <td store_id="{{ $batch->store_id }}">{{ $batch->business_store }}</td>
                                <td>{{ $batch->bdate }}</td>
                                <td>{{ $batch->batch_expiry }}</td>
                                <td>
                                    @php
                                        $expiryDate = \Carbon\Carbon::parse($batch->expiry_date);
                                        $currentDate = \Carbon\Carbon::now();
                                        $daysToExpire = round($currentDate->diffInDays($expiryDate, false));
                                    @endphp
                                    @if($daysToExpire < 0)
                                        Expired {{ abs($daysToExpire) }} days ago
                                    @else
                                        {{ $daysToExpire }} days
                                    @endif
                                </td>
                                <td>{{ $batch->manualQty ?? 0 }}</td>    
                                <td>{{ $batch->purchasedQty ?? 0 }}</td>
                                <td>{{ $batch->transfer_in ?? 0 }}</td>
                                <td>{{ $batch->transfer_out ?? 0 }}</td>
                                <td>{{ $batch->sold ?? 0 }}</td>
                                <td>{{ $batch->used ?? 0 }}</td>
                                <td>{{ $batch->returned ?? 0 }}</td>
                                <td>{{ $batch->total_stock ?? 0 }}</td>
                                <td>{{ $batch->total_stock * $product->qty_per_unit }} {{ $product->measure_unit }}</td>
                                <td>{{ $batch->batch_amount ? number_format($batch->batch_amount, 2) : '0.00' }}</td>

                                <td>{{ $batch->batch_amount ? number_format($batch->batch_amount*$batch->total_stock, 2) : '0.00' }}</td>

                                <td>
                                    @if($product->product_type != "Compiled Kit")
                                        <button onclick="openEditBatchModal({{ json_encode($batch) }})" data-bs-tooltip  title="Edit" class="btn btn-sm btn-ghost-info rounded-circle flex-shrink-0 btn-icon view-store-stock-data">
                                            <iconify-icon icon="line-md:pencil" style= "cursor:pointer;" class="fs-18"></iconify-icon>
                                        </button>
                                    @endif

                                    <button data-bs-tooltip title="Transfer Stock" data-bs-toggle="modal" data-bs-target="#transferStockModal" class="btn btn-sm btn-ghost-primary rounded-circle flex-shrink-0 btn-icon transfer-stock-button" data-dt-remaining="{{ $batch->total_stock ?? 0 }}" data-dt-productID="{{ $product->id_business_products }}" data-dt-productname = "{{ $product->product }}" data-dt-batchID="{{ $batch->id_batch }}" data-dt-storeFrom="{{ $batch->store_id }}">
                                        <iconify-icon icon="bitcoin-icons:transfer-outline" style= "cursor:pointer;" class="fs-20"></iconify-icon>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="6" class="text-right">Total:</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div> <!-- end row-->
</div>
@include('modals.transfer_note')

{{-- Batch Edit Modal --}}

<div class="modal fade" id="batchEditModal" tabindex="-1" aria-labelledby="batchEditModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="batchEditForm" class="needs-validation" novalidate>
                <div class="modal-header">
                    <h5 class="modal-title" id="batchEditModalLabel">Edit Batch</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    
                    <input type="hidden" id="id_batch" name="id_batch">
                    <input type="hidden" id="id_product" name="product_id" value="{{ $product->id_business_products }}">
                    <input type="hidden" id="remaining_quantity" name="remaining_quantity" value="">

                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="product" class="form-label">Product</label>
                            <input type="text" class="form-control" id="product" name="product" value="{{ $product->product }}" disabled>
                        </div>
                        <div class="col-6">
                            <label for="batch_date" class="form-label">Batch Date</label>
                            <input type="date" class="form-control" id="batch_date" name="batch_date" disabled>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="batch_number" class="form-label">Batch Number</label>
                            <input type="text" class="form-control" id="batch_number" name="batch_number"  required>
                        </div>
                        <div class="col-6">
                            <label for="batch_expiry" class="form-label">Expiry Date</label>
                            <input type="date" class="form-control" id="batch_expiry" name="expiry_date" required>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-6">
                            <label for="batch_amount" class="form-label">Cost Price</label>
                            <input onkeyup="$('#addPrice').val(this.value)" oninput="batch_amount_validation();" type="number" step="0.01" class="form-control" id="batch_amount" name="batch_amount" required>
                        </div>
                        <div class="col-6">
                            <label for="store_id" class="form-label">Store</label>
                            <select class="form-select" id="store_id" name="store_id" required onchange="getting_product_batch({{ $product->id_business_products }}, this.value, '#batch_number')">
                                @foreach($stores as $store)
                                    <option value="{{ $store->id_business_stores }}">{{ $store->business_store }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-6">
                            @if(session('user_role') == 'Super User' || session('user_role') == 'Super Admin')
                            <label for="batch_hidden" class="form-label">Batch Hidden</label>
                            <select type="number" class="form-select" id="batch_hidden" name="batch_hidden">
                                <option value="No">No</option>
                                <option value="Yes">Yes</option>
                            </select>
                            @else
                            <input type="hidden" id="batch_hidden" name="batch_hidden" value="No">
                            <p class="text-muted">Expiry Date is Mandatory</p>
                            @endif
                        </div>                        
                    </div>
                    <hr>
                    <div class="row mb-3">
                        <div class="col-2">
                            <label for="manualQty" class="form-label">Add</label>
                            <input type="number" step="1" class="form-control form-number" id="manualQty" name="manualQty">
                        </div>
                        <div class="col-2">
                            <label for="addPrice" class="form-label">Cost</label>
                            <input type="number" class="form-control bg-light" id="addPrice" name="addPrice" readonly>
                        </div>
                        <div class="col-6">
                            <label for="notes" class="form-label">Notes</label>
                            <input type="text" class="form-control" id="notes" name="notes">
                        </div>
                        <div class="col-2 d-flex align-items-end">
                            <button type="button" onclick="addBatchStock()" class="btn btn-sm btn-outline-dark btn-icon rounded-circle flex-shrink-0">
                                <iconify-icon icon="line-md:arrow-down" class="fs-22 fw-bold"></iconify-icon>
                            </button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <table class="table table-bordered fs-13">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Added Qty</th>
                                        <th>Cost Price</th>
                                        <th>Notes</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="batchAddManually">
                                    <!-- rows will be appended here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" id="saveBatcheChangesBtn" onclick="saveBatchChanges()" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>

{{-- End Batch Edit Modal --}}
<div class="modal fade" id="batchKitEditModal" tabindex="-1" aria-labelledby="batchKitEditModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form id="batchKitEditForm" class="needs-validation" novalidate>
                <div class="modal-header">
                    <h5 class="modal-title" id="batchKitEditModalLabel">Edit Kit Batch</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-4">
                            <label for="kitId" class="form-label">Kit ID</label>
                            <input type="text" class="form-control" id="kitId" name="id_business_products" value="{{ $product->id_business_products }}" readonly>
                        </div>
                        <div class="col-4">
                            <label for="kitName" class="form-label">Kit Name</label>
                            <input type="text" class="form-control" id="kitName" name="product" value="{{ $product->product }}" disabled>
                        </div>
                        <div class="col-4">
                            <label for="kitBatchDate" class="form-label">Batch Date</label>
                            <input type="date" class="form-control" id="kitBatchDate" name="batch_date" value="{{ date('Y-m-d') }}" disabled>
                        </div>
                        
                    </div>
                    <div class="row mb-3">
                        <div class="col-3">
                            <label for="kitBatchNumber" class="form-label">Batch Number</label>
                            <input type="text" class="form-control" id="kitBatchNumber" name="batch_number" required >
                        </div>
                        <div class="col-3">
                            <label for="kitBatchExpiry" class="form-label">Expiry Date</label>
                            <input type="date" class="form-control" id="kitBatchExpiry" name="expiry_date" required>
                        </div>
                        <div class="col-3">
                            <label for="kitStoreId" class="form-label">Store</label>
                            <select class="form-select" id="kitStoreId" name="store_id" required onchange="getting_product_batch({{ $product->id_business_products }}, this.value, '#kitBatchNumber')">
                                @foreach($stores as $store)
                                    <option value="{{ $store->id_business_stores }}">{{ $store->business_store }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-3">
                            <label for="kitBatchQty" class="form-label">Batch Qty</label>
                            <input onkeyup="calculateKitComponentConsumption()" type="number" step="0.01" class="form-control" id="kitBatchQty" name="batch_qty" required>
                        </div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-12">
                            <h5>Kit Components Consumption against Batch</h5>
                            <table class="table table-bordered fs-13">
                                <thead>
                                    <tr>
                                        <th>Component Name</th>
                                        <th>Quantity per Kit</th>
                                        <th>Measure Qty per Kit</th>
                                        <th>Measure Unit</th>
                                        <th>Total Consumption</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($product->kit_components as $component)
                                    <tr>
                                        <td data-component-id="{{ $component->business_product_id }}">{{ $component->component_name }}</td>
                                        <td>{{ $component->kit_qty }}</td>
                                        <td>{{ $component->kit_measure_qty }}</td>
                                        <td>{{ $component->measure_unit }}</td>
                                        <td class="component-consumption"></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" onclick="saveKitBatchChanges()" id="saveKitBatchBtn" class="btn btn-primary">Save changes</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- Batch Kit Edit Modal --}}

@endsection
@section('scripts')
@vite(['resources/js/modals/transfer_note.js'])
<script>
    let baseURL = '{{ url("") }}'; // Use relative paths
    $(document).ready(function() {
        var table = $('#productBatchesTable').DataTable({
            scrollX: true,
            lengthMenu: [[10, 25, 50, -1], [10, 25, 50, "All"]],
            order: [[ 0, "desc" ]],
            responsive: false,
            stateSave: true,
            paging:true,
            layout: {
                topStart: 'buttons',
                topEnd: 'search',
                bottomStart: 'info'
            },
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
            ],
            "rowCallback": function(row, data, displayNum, displayIndex, dataIndex) {
                // Apply strike-through style if batch is expired
                var expiryDate = data[5]; // Assuming expiry date is in the 5th column (index 4)
                console.log(expiryDate);
                if (expiryDate.includes("Expired")) {
                    $(row).addClass('strike-through');
                }
                
            },
            "footerCallback": function ( row, data, start, end, display ) {
                // add totals in the footer
                var api = this.api();
                // Remove the formatting to get integer data for summation
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };
                // Total over all pages
                totalManual = api
                    .column( 6 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                totalPurchased = api
                    .column( 7 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                totalTransferIn = api
                    .column( 8 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                totalTransferOut = api
                    .column( 9 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                totalSold = api
                    .column( 10 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                totalUsed = api
                    .column( 11 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                totalReturned = api
                    .column( 12 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                totalRemaining = api
                    .column( 13 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );

                    // NEW: total stock value (column 17 / index 16)
                var totalStockValue = api.column(16).data().reduce((a,b) => intVal(a) + intVal(b), 0);    

                // Update footer
                $( api.column( 6 ).footer() ).html(totalManual);
                $( api.column( 7 ).footer() ).html(totalPurchased);
                $( api.column( 8 ).footer() ).html(totalTransferIn);
                $( api.column( 9 ).footer() ).html(totalTransferOut);
                $( api.column( 10 ).footer() ).html(totalSold);
                $( api.column( 11 ).footer() ).html(totalUsed);
                $( api.column( 12 ).footer() ).html(totalReturned);
                $( api.column( 13 ).footer() ).html(totalRemaining);
                    // NEW: set total stock value
               $(api.column(16).footer()).html(totalStockValue.toFixed(2)); // format with 2 decimals
            }
        });

        //initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-tooltip]'));
        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl)
        });

    });

    function openEditBatchModal(batchData) {
        //console.log(batchData);
        $('#id_batch').val(batchData.id_batch);
        $("#store_id").val(batchData.store_id);
        $('#batch_date').val(batchData.batch_date);
        $('#batch_number').val(batchData.batch_number);
        $('#batch_expiry').val(batchData.expiry_date);
        $('#batch_amount').val(batchData.batch_amount);
        $("#addPrice").val(batchData.batch_amount);
        $("#manualQty").val('1');
        $("#remaining_quantity").val(batchData.total_stock);
        
        $('#batch_hidden').val(batchData.batch_hidden);
        // Clear previous manually added rows
        $('#batchAddManually').empty();

        // make batch number field readonly
        $('#batch_number').prop('readonly', true);

        $("#batchEditModalLabel").text("Edit Batch");
         $("#batch_amount").prop('readonly', true);
        // Show the modal
        let batchEditModal = new bootstrap.Modal(document.getElementById('batchEditModal'));
        batchEditModal.show();


    }

    function addBatchStock(){
        let date = $('#batch_date').val();
        let qty = $('#manualQty').val();
        let price = $('#addPrice').val();
        let notes = $('#notes').val();

        if(qty && price){
            let newRow = `<tr>
                <td>${date}</td>
                <td>${qty}</td>
                <td>${price}</td>
                <td>${notes}</td>
                <td><button onclick="removeAddBatchRow(this)" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger"> <iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button></td>
            </tr>`;
            $('#batchAddManually').append(newRow);

            // Clear input fields
            $('#manualQty').val('');
            // $('#addPrice').val('');
            $('#notes').val('');
            batch_amount_validation();
        } else {
             Swal.fire({
                            title: 'Warning',
                            text: "Please enter both quantity and cost price.",
                            icon: 'warning',
                            confirmButtonText: 'OK',
                            customClass: {
                                    confirmButton: 'btn btn-danger'
                            }
                        });
            return false        
        }
    }

    function saveBatchChanges(){
        event.preventDefault();
        var remainingQty = parseInt($('#remaining_quantity').val());
        var totalAddedQty = 0;
        $('#batchAddManually tr').each(function() {
            let adjustmentQty = parseInt($(this).find('td:eq(1)').text());
            totalAddedQty += adjustmentQty;
        });
        if(remainingQty + totalAddedQty < 0){
            toastr.error('The total added quantity cannot reduce the remaining quantity below zero.');
            return;
        }


        if (!$('#batchEditForm')[0].checkValidity()) {
            $('#batchEditForm')[0].reportValidity();
            return;
        }

        let formData = $('#batchEditForm').serialize();
        //get adjustments from the table
        let adjustments = [];
        $('#batchAddManually tr').each(function() {
            let adjustmentQty = $(this).find('td:eq(1)').text();
            let adjustmentDate = $(this).find('td:eq(0)').text();
            let adjustmentReason = $(this).find('td:eq(3)').text();
            adjustments.push({
                adjustment_qty: adjustmentQty,
                adjustment_date: adjustmentDate,
                adjustment_reason: adjustmentReason
            });
        });
        formData += '&adjustments=' + JSON.stringify(adjustments);
        document.getElementById('saveBatcheChangesBtn').disabled = true;
        document.getElementById('saveBatcheChangesBtn').classList.add('d-none');
        $.ajax({
            url: '{{ route("products.save_product_batch") }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                document.getElementById('saveBatcheChangesBtn').disabled = false;
                document.getElementById('saveBatcheChangesBtn').classList.remove('d-none');
                if(response.success){
                   toastr.success(response.message);
                   location.reload();
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr, status, error) {
                document.getElementById('saveBatcheChangesBtn').disabled = false;
                document.getElementById('saveBatcheChangesBtn').classList.remove('d-none');
                toastr.error('An error occurred while saving batch changes.');
            }
        });

    }

    openAddBatchModal = function(){

        // Clear previous values
        //$('#batchEditForm')[0].reset();
        $('#batch_number').prop('readonly', false);
        $("#batchEditModalLabel").text("Add New Batch");
        $("#batch_amount").prop('readonly', false);

        let maxBatchNumber = 0;
        $('#productBatchesTable tbody tr').each(function() {
            let batchNumber = parseInt($(this).find('td:eq(1)').text());
            if(batchNumber > maxBatchNumber){
                maxBatchNumber = batchNumber;
            }
        });

        $('#batch_number').val(maxBatchNumber + 1); 
        var id_batch =$("#batchEditForm #id_batch").val() || '';
        if(id_batch =='' || id_batch ==0){
            var id_product = $("#batchEditForm #id_product").val();
            var store_id = $("#batchEditForm #store_id").val();
            get_new_batch_number(id_product, store_id, "#batch_number");
        }
        // Show the modal
        let batchEditModal = new bootstrap.Modal(document.getElementById('batchEditModal'));
        batchEditModal.show();
    }

    document.getElementById('batchEditModal').addEventListener('hidden.bs.modal', function (event) {
        // Clear form fields when modal is closed
        // Clear previous values
        //$('#batchEditForm')[0].reset();
        $('#id_batch').val('');        
        $('#batch_number').val('');
        $('#batch_expiry').val('');
        $('#batch_amount').val('');
        $('#store_id').val('');
        $('#batch_hidden').val('No');
        $('#manualQty').val('1');
        $('#addPrice').val('');
        $('#notes').val('');

        $('#batchAddManually').empty();
        $('#batch_date').val(new Date().toISOString().split('T')[0]); // Set the batch date to now

    });
    
    function calculateKitComponentConsumption(){
        let batchQty = parseFloat($('#kitBatchQty').val());

        if(isNaN(batchQty) || batchQty <= 0){
            parseFloat($('#kitBatchQty').val('1'));
            batchQty = 1;
        }

        $('#batchKitEditForm tbody tr').each(function() {
            let qtyPerKit = parseFloat($(this).find('td:eq(2)').text());
            let totalConsumption = batchQty * qtyPerKit;
            $(this).find('td.component-consumption').text(totalConsumption.toFixed(2));
        });
    }

    function openKitBatchEditModal(){
        // Clear previous values
        $('#batchKitEditForm')[0].reset();
        $('#kitBatchDate').val(new Date().toISOString().split('T')[0]); // Set the batch date to now

        //Get max batch number from the table and increment by 1
        let maxBatchNumber = 0;
        $('#productBatchesTable tbody tr').each(function() {
            let batchNumber = parseInt($(this).find('td:eq(1)').text());
            if(batchNumber > maxBatchNumber){
                maxBatchNumber = batchNumber;
            }
        });

        // $('#kitBatchNumber').val(maxBatchNumber + 1);
        // $('#kitBatchQty').val('1'); 



        var id_product = $("#batchKitEditModal #kitId").val();
        var store_id = $("#batchKitEditModal #kitStoreId").val();
        get_new_batch_number(id_product, store_id, "#kitBatchNumber");
    

        calculateKitComponentConsumption();

        // Show the modal
        let batchKitEditModal = new bootstrap.Modal(document.getElementById('batchKitEditModal'));
        $("#batchKitEditModalLabel").text("Add new Batch");
        batchKitEditModal.show();
    }


    function saveKitBatchChanges(){
        event.preventDefault();

        if (!$('#batchKitEditForm')[0].checkValidity()) {
            $('#batchKitEditForm')[0].reportValidity();
            return;
        }

        let formData = $('#batchKitEditForm').serialize();

        //get kit components consumption from the table
        let components = [];
        $('#batchKitEditForm tbody tr').each(function() {
            let componentName = $(this).find('td:eq(0)').text();
            let qtyPerKit = $(this).find('td:eq(1)').text();
            let measureQtyPerKit = $(this).find('td:eq(2)').text();
            let measureUnit = $(this).find('td:eq(3)').text();
            let totalConsumption = $(this).find('td:eq(4)').text();
            components.push({
                component_id: $(this).find('td:eq(0)').data('component-id'),
                component_name: componentName,
                qty_per_kit: qtyPerKit,
                measure_qty_per_kit: measureQtyPerKit,
                measure_unit: measureUnit,
                total_consumption: totalConsumption
            });
        });

        formData += '&components=' + encodeURIComponent(JSON.stringify(components));

        document.getElementById('saveKitBatchBtn').disabled = true;
        document.getElementById('saveKitBatchBtn').classList.add('d-none');


        $.ajax({
            url: '{{ route("dispatch.save_kit_batch") }}',
            method: 'POST',
            data: formData,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(data) {
                document.getElementById('saveKitBatchBtn').disabled = false;
                document.getElementById('saveKitBatchBtn').classList.remove('d-none');

             if (data.success) {
                    toastr.success(data.message, 'Done!'); 
                    setTimeout(() => {
                         location.reload();                             
                    }, 300);
                } else {
                    let shortageHtml = "";
                    if (data.data && data.data.length > 0) {
                        shortageHtml += `
                            <table class="table table-bordered text-start" style="font-size:14px;">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Product</th>
                                        <th>O.Qty</th>
                                        <th>Avail</th>
                                        <th>Short</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;
                        data.data.forEach(item => {
                            shortageHtml += `
                                <tr>
                                    <td><a href="${item.product_batch_route}" target="_blank">${item.productid}</a></td>
                                    <td><a href="${item.product_batch_route}" target="_blank">${item.productname}</a></td>
                                    <td>${item.required_qty}</td>
                                    <td>${item.available_qty}</td>
                                    <td class="text-danger fw-bold">${item.shortage}</td>
                                </tr>
                            `;
                        });
                        shortageHtml += `</tbody></table>`;
                    }
                    Swal.fire({
                        icon: data.message_type,
                        title: data.message,
                        width: '40%',
                        html: `
                            <div style="text-align:left;">
                                ${shortageHtml}
                            </div>
                        `,
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                    });
                }

            },
            error: function(xhr, status, error) {
                document.getElementById('saveKitBatchBtn').disabled = false;
                document.getElementById('saveKitBatchBtn').classList.remove('d-none');
                toastr.error('An error occurred while saving kit batch changes.');
            }
        });

    }

   function batch_amount_validation(){
        let rowCount = $("#batchAddManually tr").length;
        if (rowCount > 0) {
            $("#batch_amount").prop('readonly', true);
        } else {
            $("#batch_amount").prop('readonly', false);
        }
   } 

    function removeAddBatchRow(this_btn){
        $(this_btn).closest('tr').remove();
        batch_amount_validation();
    }
    function getting_product_batch(product_id, store_id, inputSelector = null){
            get_new_batch_number(product_id, store_id, inputSelector);
    }
    
    function get_new_batch_number(product_id, store_id, inputSelector = null) {
        var url = "{{ route('products.get_new_batch_number') }}"; 

        $.ajax({
            url: url,
            type: 'GET',
            headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
            data: {
                product_id: product_id,
                store_id: store_id
            },
            success: function(response) {
              
                if (response.batch_number) {
      
                    if(inputSelector) {
                        $(inputSelector).val(response.batch_number);
                    }

                    // toastr.success(response.message || 'New batch number generated');
                } else {
                    toastr.error(response.message || 'Failed to get new batch number');
                }
            },
            error: function(xhr, status, error) {
                toastr.error('An error occurred while getting new batch number');
                console.error(xhr.responseText); 
            }
        });        
    }
    
</script>
@endsection