@extends('layouts.horizontal', ['title' => 'Product Orders', 'topbarTitle' => 'Products Orders'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="Torders ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Product Orders</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    
    <div class="row ">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Filter orders</div>
                    <!-- <form id="ordersform" method="GET" action="today_orders/todayordersdata"> -->
                        
                        <div class="row">                                            
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                
                                <label class="form-label" for="orderDate">Select Date</label>
                                <input type="date" class="form-control" id="orderDate" name="start_date" value="{{ $today ?? date('Y-m-d') }}" placeholder="Select Date" required>
                            </div>
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                <button id="btn_refresh_table" type="button" class="btn btn-sm btn-primary mt-4" >Run</button>
                            </div>                            
                        </div>
                    <!-- </form> -->
                </div>
            </div>
        </div>
    </div> <!-- end row-->
    

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <table style="font-size: .753rem !important;" id="orders-table"  class="table  dt-responsive nowrap w-100">
                                <thead>
                                    <tr>                                      
                                        <th>Order ID</th>
                                        <th>Customer</th>
                                        <th>Status</th>
                                        <th>Order Date</th>
                                        <th>Products</th>
                                        <th>Prices</th>
                                        <th>Total</th>                                        
                                        <th>By</th>   
                                        <th>Type</th>                                    
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                   

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="6" style="text-align:right">Totals:</th>
                                        <th></th> <!-- balance total -->
                                        <th></th> <!-- paid_amount total -->
                                        <th colspan="10"></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div> <!-- end row-->
</div> <!-- end Torders-->
@endsection

@section('scripts')
<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Initialize DataTables
        //Today orders Datatable
        var table = $('#orders-table').DataTable({
            scrollX:true,
            scrollY: 350,
            scrollCollapse: true,
            lengthChange: true,
            stateSave: true,
            ajax: {
                url: "{{ route('product_orders.productordersdata') }}",
                data: function (d) {
                    d.start_date = $('#orderDate').val();   // custom parameter                    
                }
            },       
            fixedHeader: true,
            processing: true,
            serverSide: true,
            buttons: ['copy', 'print'],
            responsive: false,            
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'>",
                    "next": "<i class='ti ti-chevron-right'>"
                }
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {   // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            lengthChange: true,   // show page length dropdown
            pageLength: 10,       // default rows per page
            searching: true,      // show search box
            info: true,           // show "Showing 1 to 10 of N entries"
            paging: true,         // show pagination
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            columns: [
                { data: 'id_customer_order', name: 'id_customer_order' },
                { data: 'customer_name', name: 'customer_name' },
                { data: 'order_status', name: 'order_status' },
                { data: 'customer_order_date', name: 'customer_order_date' },
                { data: 'items', name: 'items' },
                { data: 'prices', name: 'prices' },
                { data: 'total_amount', name: 'total_amount' },
                { data: 'created_by', name: 'created_by' },
                { data: 'order_type', name: 'order_type' },
                // Actions column with button
                { 
                    data: null, 
                    name: 'actions', 
                    orderable: false, 
                    searchable: false,
                    render: function (data, type, row) {
                        let flag = row.order_status.toLowerCase();
                        var mRoute = "";
                        if(flag == 'invoiced'){
                            mRoute = 'new_retail_invoice/';
                        } else if(flag == 'open'){
                            mRoute = 'new_retail_invoice/';
                        } else {
                            mRoute = '';
                        }
                        return `<a target="_blank" href="`+ mRoute +`${data.id_customer_order}" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn" data-id="${row.id}">
                                    <iconify-icon icon="line-md:watch-loop"class="fs-20"></iconify-icon>
                                </a>
                                <button onclick="cancelorder('${data.id_customer_order}', '${data.order_type}');" type="button" class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger" data-id="${row.id}">
                                    <iconify-icon icon="solar:trash-bin-trash-bold-duotone"class="fs-20"></iconify-icon>
                                </button>`;


                    }
                }
            ],
            "drawCallback": function () {
                $('.dataTables_paginate > .pagination').addClass('pagination-rounded');
                $('.dataTables_paginate > .pagination').addClass('btn-dark');
            },
            "rowCallback": function(row, data, displayNum, displayIndex, dataIndex) {              
                // Strike Through rows where a specific data field meets a condition
                if (data.order_status == 'Cancelled') {
                    $(row).addClass('strike-through'); // Add a class to the row
                }                
            },
            "footerCallback": function (row, data, start, end, display) {
                var api = this.api();

                // grab server totals
                var totals = api.ajax.json().totals;

                // balance is column index 8
                $(api.column(9).footer()).html(
                    totals ? totals.balance : 0
                );

                // paid_amount is column index 9
                $(api.column(10).footer()).html(
                    totals ? totals.paid_amount : 0
                );
            }

        });

        $('#btn_refresh_table').click(function() {
           // table.draw();
            table.ajax.reload(); 
        });

    });

   
    //////////////////////Open order and Cancel order Functions//////////////////////        
    function cancelorder(orderid, order_type, imsfiscal_order_number){
        //Warning Message
        Swal.fire({
                input: "text",
                inputLabel: "Give Reason For Cancelling This order:",
                inputPlaceholder: "Reason for cancelling...",
                inputAttributes: {
                    "aria-label": "Reason for cancelling"
                },
                showCancelButton: true,
                icon: "question",
                customClass: {
                    confirmButton: 'btn btn-primary me-2',
                    cancelButton: 'btn btn-secondary'
                },
                buttonsStyling: false // important so Swal doesn’t override your Bootstrap classes
            }).then((result) => {
                if (result.isConfirmed) {
                    var reason = result.value;
                    if (reason == "") {
                        Swal.fire({
                            title: "Oops!",
                            text: "You need to write something!",
                            icon: "error",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });
                        return false;
                    } else {
                        //Check if imsfiscal number is present (posted order)
                        //console.log(imsfiscal_order_number);
                        if(imsfiscal_order_number && imsfiscal_order_number !== 'null'){
                            Swal.fire({
                                title: "Oops!",
                                text: "Connected with IMS Fiscal. You Cannot Cancel orders!",
                                icon: "error",
                                customClass: {
                                    confirmButton: "btn btn-danger"
                                }
                            });
                            return false;
                        }

                       
                    }
                }
        });
        
    }

    function openorder(orderid){
        $.ajax({
                type: 'POST',
                url: "{{ route('any', 'open_order') }}",
                headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                dataType: 'json',
                data: {orderid: orderid},
                success: function(data) {
                    
                }
            });
    }




</script>

@endsection

