@extends('layouts.horizontal', ['title' => 'Product Orders', 'topbarTitle' => 'Products Orders'])

@section('css')
@vite([
'node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
'node_modules/select2/dist/css/select2.min.css'])
<style>
    .text-right{
        text-align: right !important;
    }
    .address-cell {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
</style>
@endsection

@section('content')

<style>
    tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="Torders ">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Online Product Orders</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    
    <div class="row {{ session('user_role') != 'Super User' ? 'd-none' : '' }} d-none ">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">Filter orders</div>
                    <!-- <form id="ordersform" method="GET" action="today_orders/todayordersdata"> -->
                        
                        <div class="row">                                            
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                
                                <label class="form-label" for="orderDate">Select Date</label>
                                <input type="date" class="form-control" id="orderDate" name="start_date" value="{{ $today ?? date('Y-m-d') }}" placeholder="Select Date" required>
                            </div>
                            <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                                <button id="btn_refresh_table" type="button" class="btn btn-sm btn-primary mt-4" >Run</button>
                            </div>                            
                        </div>
                    <!-- </form> -->
                </div>
            </div>
        </div>
    </div> <!-- end row-->
    

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <table style="font-size: .753rem !important;" id="online-orders-table"  class="table  dt-responsive nowrap w-100">
                                <thead>
                                    <tr>                                      
                                        <th>Order ID</th>                                 
                                        <th>Order Number</th>                                 
                                        <th>Platform</th>                                 
                                        <th>Customer Name</th>                                 
                                        <th>Customer Email</th>                                 
                                        <th>Customer Phone</th>                                 
                                        <th>Shipping Address</th>                                 
                                        <th>Status</th>                                 
                                        <th>Created At</th>                                 
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($onlineOrderLogs as $value)
                                        @php
                                            $orderPayload = $value->order_payload ? json_decode($value->order_payload, true) : [];
                                            $shippingAddress = $orderPayload['shipping_address'] ?? null;
                                            $billingAddress = $orderPayload['billing_address'] ?? $shippingAddress;
                                            
                                            $formatAddress = function($address) {
                                                if (!$address) return '-';
                                                $parts = array_filter([
                                                    $address['address1'] ?? '',
                                                    $address['city'] ?? '',
                                                    $address['zip'] ?? '',
                                                    $address['country'] ?? ''
                                                ]);
                                                return implode(', ', $parts) ?: '-';
                                            };
                                            
                                            $shippingFormatted = $formatAddress($shippingAddress);
                                            $billingFormatted = $formatAddress($billingAddress);
                                        @endphp
                                        <tr>
                                            <td>{{ $value->order_id }}</td>
                                            <td>{{ $value->order_number }}</td>
                                            <td>{{ $value->platform }}</td>
                                            <td>{{ $value->customer_name }}</td>
                                            <td>{{ $value->customer_email }}</td>
                                            <td>{{ $value->customer_phone }}</td>
                                            <td class="address-cell" title="{{ $shippingFormatted }}">{{ $shippingFormatted }}</td>
                                            <td> 
                                                <h4>
                                                    <span class="badge badge badge-soft-{{ $value->status == 'sale_order_not_created' ? 'danger' : 'success'}} rounded-pill" >{{ str_replace('_', ' ', $value->status) }}</span>
                                                </h4>
                                            </td>
                                            <td>{{ $value->created_at }}</td>
                                            <td>
                                                @if ($value->status == 'sale_order_not_created')
                                                    <button type="button" 
                                                            class="btn btn-soft-success process-order-btn" 
                                                            data-order='@json($value)'>
                                                        Process Order
                                                    </button>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    

                </div> <!-- end card body-->
            </div> <!-- end card -->
        </div><!-- end col-->
    </div> <!-- end row-->
</div> <!-- end Torders-->

<!-- process online order -->
<div class="modal fade" id="processOnlineOrderModal" tabindex="-1" aria-labelledby="processOnlineOrderModalLabel" style="display: none;" aria-hidden="true">
    <form action="{{ route('product_orders_online_store') }}" method="POST" id="post_online_product_order_form" onsubmit="return false;" >
        <div class="modal-dialog modal-fullscreen">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="processOnlineOrderModalLabel">Process Online Order</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="height: 75vh; overflow: auto;" >

                </div>
                <div class="modal-footer">
                    <a href="javascript:void(0);" class="btn btn-light" data-bs-dismiss="modal">Close</a>
                    <button type="button" onclick="storeOnlineProductOrder(this);" class="btn btn-primary">Create</button>
                </div>
            </div>
        </div>
    </form>
</div>
<!-- process online order END -->
@endsection

@section('scripts')
<script>
    document.addEventListener("DOMContentLoaded", function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
        });
        // Initialize DataTables
        //Today orders Datatable
        var table = $('#online-orders-table').DataTable({
            scrollX:true,
            scrollY: 350,
            scrollCollapse: true,
            lengthChange: true,
            fixedHeader: true,
            buttons: ['copy', 'print'],
            responsive: false,
            order: [[0, 'desc']], // Sort by Order ID (column 0) in descending order
            "language": {
                "paginate": {
                    "previous": "<i class='ti ti-chevron-left'>",
                    "next": "<i class='ti ti-chevron-right'>"
                }
            },
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {   // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            lengthChange: true,   // show page length dropdown
            pageLength: 10,       // default rows per page
            searching: true,      // show search box
            info: true,           // show "Showing 1 to 10 of N entries"
            paging: true,         // show pagination
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
            ],

        });

        $('#btn_refresh_table').click(function() {
           // table.draw();
            table.ajax.reload(); 
        });

    });

    let processOnlineOrderModal = null;
    let business_products = @json($business_products);

    document.addEventListener('DOMContentLoaded', function () {
        const modalEl = document.getElementById('processOnlineOrderModal');
        if (modalEl) {
            processOnlineOrderModal = new bootstrap.Modal(modalEl, {
                backdrop: 'static',
                keyboard: false
            });
        }

        // Handle process order button clicks
        $(document).on('click', '.process-order-btn', function() {
            const orderData = $(this).data('order');
            if (orderData) {
                showProcessOnlineOrderModal(orderData);
            }
        });
    });

    function showProcessOnlineOrderModal(onlineOrder){ 
        if (!processOnlineOrderModal){
            return;
        }
        if (!onlineOrder){
            return;
        }

        let shopify_order = onlineOrder.order_payload
            ? JSON.parse(onlineOrder.order_payload)
            : {};

        let html = generateProcessModalBody(shopify_order);
        html += `<input type="hidden" name="online_order_log_id" id="online_order_log_id" value="${onlineOrder.id_online_order_logs}" >
        <input type="hidden" name="online_order_customer_name" id="online_order_customer_name" value="${onlineOrder.customer_name}" >
        <input type="hidden" name="online_order_customer_email" id="online_order_customer_email" value="${onlineOrder.customer_email}" >
        <input type="hidden" name="online_order_customer_phone" id="online_order_customer_phone" value="${onlineOrder.customer_phone}" >
        `;
      
        document.querySelector('#processOnlineOrderModal .modal-body').innerHTML = html;
        $('.system_product_select_2').select2({
            dropdownParent: $('#processOnlineOrderModal')
        });
        processOnlineOrderModal.show();
    }

    function generateProcessModalBody(shopify_order) {
        if(!shopify_order) return '';

        // Format address helper function
        function formatAddress(address) {
            if (!address) return '-';
            const parts = [
                address.address1 || '',
                address.city || '',
                address.zip || '',
                address.country || ''
            ].filter(p => p);
            return parts.length > 0 ? parts.join(', ') : '-';
        }

        // Get addresses
        const shippingAddress = shopify_order.shipping_address || null;
        const billingAddress = shopify_order.billing_address || shippingAddress;
        const shippingFormatted = formatAddress(shippingAddress);
        const billingFormatted = formatAddress(billingAddress);

        let html = `
        <div class="row mb-3 pb-2">
            <!-- LEFT: Customer Info -->
            <div class="col-md-6">
                <h5 class="">Customer Info</h5>
                <div><strong>Name:</strong> ${shopify_order.customer?.first_name ?? ''} ${shopify_order.customer?.last_name ?? '-'}</div>
                <div><strong>Phone:</strong> ${shopify_order.billing_address?.phone ?? '-'}</div>
                <div><strong>Email:</strong> ${shopify_order.email ?? '-'}</div>
            </div>

            <!-- RIGHT: Order Info -->
            <div class="col-md-6">
                <h5 class="">Order Info</h5>
                <div><strong>Order #:</strong> ${shopify_order.order_number ?? shopify_order.id ?? '-'}</div>
                <div><strong>Payment:</strong> ${shopify_order.payment_gateway_names?.join(', ') ?? '-'}</div>
                <div><strong>Date:</strong> ${shopify_order.created_at ? new Date(shopify_order.created_at).toLocaleString() : '-'}</div>
            </div>
        </div>
        
        <div class="row mb-3 pb-2">
            <!-- LEFT: Shipping Address -->
            <div class="col-md-6">
                <h5 class="">Shipping Address</h5>
                <div>${shippingFormatted}</div>
            </div>

            <!-- RIGHT: Billing Address -->
            <div class="col-md-6">
                <h5 class="">Billing Address</h5>
                <div>${billingFormatted}</div>
            </div>
        </div>
        `;

        if(shopify_order && shopify_order.line_items.length > 0){
            html += `
                <table class="table table-sm table-striped table-hover" id="table_online_orders_detail" >
                    <thead class="table-light">
                        <tr>
                            <th width="360" >Shopify Product</th>
                            <th>System Product</th>
                            <th width="80">Qty</th>
                            <th width="120">Price</th>
                            <th width="120">Discount</th>
                            <th width="120">Tax</th>
                            <th width="120">Sub Total</th>
                        </tr>
                    </thead>
                    <tbody>
            `;

            shopify_order.line_items.forEach(item => {
                let taxAmount = 0;
                let totalTaxRate = 0;
                if (item.tax_lines?.length) {
                    item.tax_lines.forEach(tax => {
                        taxAmount += parseFloat(tax.price);
                        totalTaxRate += parseFloat(tax.rate * 100);
                    });
                }

                // Calculate discount for this item
                let totalDiscount = 0;
                
                // First, check if there are discount allocations in Shopify's format
                if (item.discount_allocations && item.discount_allocations.length > 0) {
                    // Sum all discount allocations for this item
                    item.discount_allocations.forEach(discount => {
                        totalDiscount += parseFloat(discount.amount || 0);
                    });
                } 
                // Fallback to total_discount if discount_allocations is not available
                else if (item.total_discount) {
                    totalDiscount = parseFloat(item.total_discount);
                }
                
                // Calculate per unit discount (discount / quantity)
                let discountPerUnit = 0;
                if (totalDiscount > 0 && item.quantity > 0) {
                    discountPerUnit = totalDiscount / item.quantity;
                }

                // Calculate subtotal for this line item
                const subtotal = (parseFloat(item.price) * item.quantity) - totalDiscount;

                html += `
                    <tr>
                        <td>${item.title}</td>
                        <td>${generateSystemProductOption(business_products, item.sku)}</td>
                        <td class="text-right" >
                            ${item.quantity}
                            <input type="hidden" name="order_qty[]" value="${item.quantity}" >
                        </td>
                        <td class="text-right">${parseFloat(item.price).toFixed(2)} ${shopify_order.currency}
                            <input type="hidden" name="item_price[]" value="${item.price}" >
                        </td>
                        <td class="text-right">
                            ${item.quantity > 1 && discountPerUnit > 0 ? `${discountPerUnit.toFixed(2)} ${shopify_order.currency}` : `${discountPerUnit.toFixed(2)} ${shopify_order.currency}`}
                            ${item.quantity > 1 && discountPerUnit > 0 ? `<br><small>(per unit)</small>` : ''}
                            <input type="hidden" name="item_discount[]" value="${discountPerUnit.toFixed(2)}" >
                        </td>
                        <td class="text-right">${taxAmount.toFixed(2)} ${shopify_order.currency}
                            <input type="hidden" name="item_tax[]" value="${taxAmount.toFixed(2)}" >
                            <input type="hidden" name="item_tax_rate[]" value="${totalTaxRate.toFixed(2)}" >
                        </td>
                        <td class="text-right">${subtotal.toFixed(2)} ${shopify_order.currency}</td>
                    </tr>
                `;
            });

            html += `</tbody></table>`;
        }
        
        /* ================= TOTALS ================= */
        html += `
            <hr>
            <div class="text-end">
                <div>Subtotal: <strong>${shopify_order.current_subtotal_price} ${shopify_order.currency}</strong></div>
                <div>Shipping: <strong>${shopify_order.shipping_lines?.[0]?.discounted_price ?? '0.00'}  ${shopify_order.currency}</strong></div>
                <div>Discount: <strong>${shopify_order.current_total_discounts ?? '0.00'} ${shopify_order.currency}</strong></div>
                <div>Tax: <strong>${shopify_order.current_total_tax ?? '0.00'} ${shopify_order.currency}</strong></div>
                <div class="fs-5 mt-2">
                    Total:
                    <strong class="text-success">
                        ${shopify_order.current_total_price ?? shopify_order.total_price} ${shopify_order.currency}
                    </strong>
                </div>
                <input type="hidden" name="online_order_delivery_charges" id="online_order_delivery_charges" value="${shopify_order.shipping_lines?.[0]?.discounted_price ?? '0.00'}" >
            </div>
        `;
    
        return html;
    }


    function generateSystemProductOption(businessProducts, sku=null){
        if(businessProducts && businessProducts.length > 0){
            let select = '<option value="">Select System Product</option>';
            businessProducts.forEach(item => {
                let isSelected = '';
                if(sku){
                    isSelected = (item.sku == sku) ? 'selected' : '';
                }
                select += `<option value="${item.id_business_products}" ${isSelected} >${item.product}</option>`;
            });
            select = `<select name="system_product_gainst_shopify[]" class="system_product_gainst_shopify system_product_select_2 form-control form-control-sm" required >${select}</select>`
            return select;
        }
        return '';
    }

    function storeOnlineProductOrder(button){
        button = $(button);
        let form = $('#post_online_product_order_form');
        button.prop('disabled', true);

        let isValid = true;
        let errorMsg = "";

        $('#table_online_orders_detail tbody tr').each(function(index, row){
            let systemProduct = $(row).find('.system_product_gainst_shopify').val();
            let qty = parseFloat($(row).find('input[name="order_qty[]"]').val());

            if(!systemProduct){
                isValid = false;
                errorMsg = "Please select System Product in row " + (index+1);
                return false;
            }

            if(!qty || qty <= 0){
                isValid = false;
                errorMsg = "Quantity must be greater than 0 in row " + (index+1);
                return false;
            }
        });

        if(!isValid){
            Swal.fire({
                text: errorMsg,
                icon: 'error',
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                    confirmButton: 'btn btn-danger'
                }
            });
            button.prop('disabled', false);
            return;
        }

        $.ajax({
            type: form.attr('method'),
            url: form.attr('action'),
            data: form.serialize(),
            success: function (response) {
                if(response.success){
                    Swal.fire({
                        text: response.message,
                        icon: 'success',
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: 'btn btn-success'
                        }
                    }).then(() => {

                        var url = "{{ url('new_retail_invoice') }}" + "/" + response.order_id;
                        window.open(url, '_blank');
                        
                        location.reload();
                    });
                }else{
                    Swal.fire({
                        text: response.message ?? 'some unexpected situation found.',
                        icon: 'error',
                        buttonsStyling: false,
                        confirmButtonText: "Ok",
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                    });
                }
            },
            error: function(xhr) {
                let message = "Something went wrong!";
                if(xhr.responseJSON && xhr.responseJSON.message){
                    message = xhr.responseJSON.message;
                }

                Swal.fire({
                    text: message,
                    icon: 'error',
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: 'btn btn-danger'
                    }
                });
            },
            complete: function() {
                button.prop('disabled', false);
            }
        });
    }

</script>
@endsection

