@extends('layouts.horizontal', ['title' => 'New Goods Receipt Note', 'topbarTitle' => 'Purchases', 'nonav' => true])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])

@endsection

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            @can('create_grn-Purchase_Orders')
            
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$purchase_order->business_logo }}" alt="{{ $purchase_order->business_name }}">
                    </div>  
                    <h4 class="card-title">New Goods Receipt Note (GRN) for Purchase Order #{{ $purchase_order->purchase_order_number }}</h4>
                </div>
                <div class="card-body">
                    <form id="new_grn_form">                        
                        @csrf
                        <div class="row">
                            <div class="mb-3 col-md-4">
                                <label for="grn_number" class="form-label">GRN#:</label>
                                <table class="table table-borderless fs-13 table-sm">
                                    <tr>
                                        <td><span class="fw-bold">Supplier:</span></td>
                                        <td><span class="fw-bold">{{ $purchase_order->supplier_name }}</span></td>
                                    </tr>
                                    <tr>
                                        <td><span class="fw-bold">Contact Person:</span></td>
                                        <td><span class="fw-bold">{{ $purchase_order->contact_person }}</span></td>
                                    </tr>
                                    <tr>
                                        <td><span class="fw-bold">Email:</span></td>
                                        <td><span class="fw-bold">{{ $purchase_order->email }}</span></td>
                                    </tr>
                                    <tr>
                                        <td><span class="fw-bold">Phone:</span></td>
                                        <td><span class="fw-bold">{{ $purchase_order->contact_number }}</span></td>
                                    <tr>
                                        <td><span class="fw-bold">Address:</span></td>
                                        <td><span class="fw-bold">{{ $purchase_order->ho_address }}</span></td>
                                    </tr>
                                    <tr>
                                        <td><span class="fw-bold">Receiving In:</span></td>
                                        <td>
                                            <select class="form-select form-select-sm" id="store_id" name="store_id" required>
                                                @foreach($stores as $store)
                                                    <option value="{{ $store->id_business_stores }}">{{ $store->business_store }}</option>
                                                @endforeach
                                            </select>

                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="mb-3 col-md-4"></div>
                            <div class="mb-3 col-md-4">
                                
                                <input type="hidden" id="business_id" name="business_id" value="{{ $purchase_order->business_id }}" readonly>
                                <input type="hidden" id="supplier_id" name="supplier_id" value="{{ $purchase_order->supplier_id }}" readonly>
                                <input type="hidden" id="supplier_name" name="supplier_name" value="{{ $purchase_order->supplier_name }}" readonly>

                                <label for="grn_date" class="form-label">GRN Date</label>
                                <input type="date" class="form-control mb-2" id="grn_date" name="grn_date" value="{{ date('Y-m-d') }}" required>

                                <label for="grn_comment" class="form-label">Comment</label>
                                <textarea class="form-control" id="grn_comment" name="grn_comment" rows="2"></textarea>
                            </div>
                        </div>
                        <input type="hidden" name="idpurchase_order" value="{{ $purchase_order->idpurchase_order }}">
                        <div class="mb-3">
                            
                        </div>
                        <div class="mb-3">
                            
                        </div>
                        
                    </form>

                    <div class="mt-2">
                        <h5>Purchase Order Items</h5>
                        <table class="table table-sm table-bordered fs-13 " id="grn_detail_table">
                            <thead>
                                <tr>
                                    <th>Product</th>
                                    <th>SKU</th>
                                    <th class="text-end" style="width: 100px;">Unit Price</th>
                                    <th>Ordered Qty</th>
                                    <th class="text-end" style="width: 100px;">Unit Discount</th>
                                    <th>Received Qty</th>
                                    <th>Returned Qty</th>
                                    <th>Pending Qty</th>
                                    <th>Receiving Now</th>
                                    <th>Cost</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($purchase_order_items as $item)
                                <tr>
                                    <td data-product-id="{{ $item->product_id }}" data-brand-id="{{ $item->brand_id }}" data-brand-name="{{ $item->brand_name }}">{{ $item->product_name }}</td>
                                    <td>{{ $item->sku }}</td>
                                    <td data-unit-price="{{ $item->product_purchase_price }}">
                                        <input onkeyup="calculate_costs()" type="number" step="0.01" readonly class="form-control form-control-sm text-end purchase_unit_price {{ auth()->user()->cannot('change_price_grn-Purchase_Orders') ? 'bg-light' : ''; }} " style="width: 100px;" name="unit_price[{{ $item->idpurchase_order_details }}]" value="{{ $item->product_purchase_price }}" 
                                         @cannot('change_price_grn-Purchase_Orders') readonly @endcannot >
                                    </td>
                                    <td>{{ $item->product_qty }}</td>
                                    <td>
                                        <input onkeyup="calculate_costs()" type="number" readonly step="0.01" class="form-control form-control-sm text-end unit_discount" name="unit_discount[{{ $item->idpurchase_order_details }}]" value="{{ $item->unit_discount }}" min="0">
                                    </td>
                                    <td>{{ $item->total_received }}</td>
                                    <td>{{ $item->total_returned }}</td>
                                    <td>{{ $item->product_qty - $item->total_received + $item->total_returned }}</td>
                                    <td>
                                        <input onkeyup="calculate_costs()" type="number" class="form-control form-control-sm receiving_quantity" name="receiving_quantity[{{ $item->idpurchase_order_details }}]" min="0" max="{{ $item->product_qty - $item->total_received + $item->total_returned }}" value="0">
                                    </td>
                                    <td></td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th colspan="8" class="text-end">Total</th>
                                    <th class="total-cost"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <a href="{{ route("purchase.open_purchase_order", ["idpurchase_order" => $idpurchase_order]) }}" class="btn btn-success " data-bs-toggle="tooltip" title="PO Detail">
                      Go back to purchase order detail          
                    </a>
                    <button type="button" id="saveGRNButton" onclick="create_grn()" form="new_grn_form" class="btn btn-primary">
                        <span id="saveGRNSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span> Create GRN</button>
                </div>
            </div>

            @else
                <h1>{{ config('permission.not_allowed') }}</h1>
            @endcan
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    $(document).ready(function() {        
        calculate_costs();
    });


    function create_grn() {
        data = $('#new_grn_form').serialize();

        //get items data
        let items = [];
        $('input[name^="receiving_quantity"]').each(function() {
            var row = $(this).closest('tr');
            var idpurchase_order_details = $(this).attr('name').match(/\d+/)[0];
            var receivingQty = parseInt($(this).val()) || 0;
            var unitPrice = parseFloat(row.find('td:nth-child(3) input').val()) || 0;
            var product_id = row.find('td:nth-child(1)').data('product-id');
            var brand_id = row.find('td:nth-child(1)').data('brand-id');
            var brand_name = row.find('td:nth-child(1)').data('brand-name');
            var product_name = row.find('td:nth-child(1)').text();
            var product_sku = row.find('td:nth-child(2)').text();

            if(receivingQty > 0) {
                items.push({
                    idpurchase_order_details: idpurchase_order_details,
                    receiving_quantity: receivingQty,
                    unit_discount: parseFloat(row.find('td:nth-child(5) input').val()) || 0,
                    unit_price: unitPrice,
                    product_id: product_id,
                    brand_id: brand_id,
                    brand_name: brand_name,
                    product_name: product_name,
                    product_sku: product_sku
                });
            }
        });

        console.log('Form Data:', data);
        console.log('Items Data:', items);
        if(items.length === 0) {
            toastr.error('Please enter receiving quantities for at least one item.');
            return;
        }

        //append items data to the form data
        data += '&items=' + encodeURIComponent(JSON.stringify(items));

        document.getElementById('saveGRNButton').disabled = true;
        document.getElementById('saveGRNSpinner').classList.remove('d-none');

        //submit the form via ajax
        $.ajax({
            url: '{{ route("purchase.save_grn") }}',
            type: 'POST',
            data: data,
            success: function(response) {
                document.getElementById('saveGRNButton').disabled = false;
                document.getElementById('saveGRNSpinner').classList.add('d-none');
                if(response.message_type === 'success') {
                    toastr.success('Success :' + response.message);
                    setTimeout(() => {
                        let url = "{{ url('') }}"; 
                        window.location.href = url + '/purchase/print_grn/' + response.idgrn;
                        //  window.location.reload();
                    }, 300);

                } else {
                    toastr.error('Error creating GRN: ' + response.message);
                }
            },
            error: function(xhr) {
                document.getElementById('saveGRNButton').disabled = false;
                document.getElementById('saveGRNSpinner').classList.add('d-none');
                
                toastr.error('An error occurred while creating the GRN.');
            }
        });
        
    }

    function calculate_costs() {

        let totalCost = 0;

        $('#grn_detail_table tbody tr').each(function () {
            let row = $(this);

            let unitPrice = parseFloat(
                row.find('input[name^="unit_price"]').val()
            ) || 0;

            let unitDiscount = parseFloat(
            row.find('input[name^="unit_discount"]').val()
            ) || 0;

            let receivingQty = parseInt(
                row.find('input[name^="receiving_quantity"]').val()
            ) || 0;

            if (receivingQty < 0) {
                receivingQty = 0;
                row.find('input[name^="receiving_quantity"]').val(0);
            }

            let maxQty = parseInt(row.find('td:nth-child(8)').text()) || 0;
            if (receivingQty > maxQty) {
                receivingQty = maxQty;
                row.find('input[name^="receiving_quantity"]').val(maxQty);
            }

            let cost = unitPrice * receivingQty - unitDiscount * receivingQty;
            row.find('td:nth-child(10)').text(cost.toFixed(2));

            totalCost += cost;
        });

        $('.total-cost').text(totalCost.toFixed(2));
        console.log('Total Cost:', totalCost.toFixed(2));
    }


    
</script>
@endsection