@extends('layouts.horizontal', ['title' => 'New Supplier Payment', 'topbarTitle' => 'Purchases', 'nonav' => true])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])

@endsection

@section('content')
@can('add_payment-Purchase_Orders')

<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$purchase_order->business_logo }}" alt="{{ $purchase_order->business_name }}">
                    </div>  
                    <h4 class="card-title">New Supplier Payment for Purchase Order #{{ $purchase_order->purchase_order_number }}</h4>
                </div>
                <div class="card-body">
                    <form id="new_supplier_payment_form">  
                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                        <input type="hidden" id="business_id" name="business_id" value="{{ $purchase_order->business_id }}">
                        <div class="row">
                            <div class="col-md-2">
                                <label for="supplier_name" class="form-label">Supplier Name</label>
                                <input type="text" class="form-control" id="supplier_name" name="supplier_name" value="{{ $purchase_order->supplier_name }}" readonly>
                            </div>
                            <div class="col-md-2">
                                <label for="payment_date" class="form-label">Payment Date</label>
                                <input type="date" class="form-control" id="payment_date" name="payment_date" value="{{ date('Y-m-d') }}" required>
                            </div>
                            <div class="col-md-2">
                                <label for="payment_mode" class="form-label">Payment Mode</label>
                                <select  onchange="get_cash_account_heads()" class="form-select" id="payment_mode" name="payment_mode" required>                                    
                                    <option value="Cash">Cash</option>
                                    <option value="Bank">Bank Transfer</option>
                                    <option value="Bank">Cheque</option>
                                    <option value="Card">Credit Card</option>
                                    <option value="Online">Online</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="amount" class="form-label">Account Head</label>
                                <select class="form-select" id="account_head_id" name="account_head_id" required>
                                </select>
                            </div>
                            <div class="col-md-1">
                                <div class="spinner-border text-dark mt-3 fs-12 d-none" role="status" id="loading_spinner">
                                    <span class="visually-hidden">Loading...</span>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <label for="instrument_number" class="form-label">Instrument#</label>
                                <input type="text" class="form-control" id="instrument_number" name="instrument_number">
                            </div>
                        </div>
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for="amount" class="form-label">Remaining Payable Amount</label>                                      
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" class="form-control form-control-sm text-end" id="amount" name="amount" value="{{ $remaining_amount->remaining_amount }}" disabled>
                                    </div>
                                </div>  
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for="amount" class="form-label">Discount {{ config('constants.CURRENCY') }}</label>                                      
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" class="form-control form-control-sm text-end" id="discount" name="discount" value="0.00">
                                    </div>
                                </div>  
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for="amount" class="form-label">Additional Charge {{ config('constants.CURRENCY') }}</label>                                      
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" class="form-control form-control-sm text-end" id="additional_charge" name="additional_charge" value="0.00">
                                    </div>
                                </div>     
                                <hr>
                                <div class="row mb-2">
                                    <div class="col-md-6">
                                        <label for="amount" class="form-label">Total Payment Amount {{ config('constants.CURRENCY') }}</label>                                      
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" class="form-control form-control-sm text-end" id="total_payment_amount" name="total_payment_amount" value="0.00" disabled>
                                    </div>
                                </div>      
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="amount" class="form-label">Sales Tax %</label>                                      
                                    </div>
                                    <div class="col-md-2">
                                        <input type="number" onkeyup="calculateSalesTax()" class="form-control form-control-sm text-end" id="sale_tax_percentage" name="sale_tax_percentage" value="0.00">
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" class="form-control form-control-sm text-end" id="sale_tax" name="sale_tax" value="0.00">
                                    </div>
                                </div>
                                <div class="row mb-2">
                                    <div class="col-md-4">
                                        <label for="amount" class="form-label">With Holding Tax %</label>                                      
                                    </div>
                                    <div class="col-md-2">
                                        <input type="number" onkeyup="calculateWithholdingTax()" class="form-control form-control-sm text-end" id="withholding_tax_percentage" name="withholding_tax_percentage" value="0.00">
                                    </div>
                                    <div class="col-md-6 text-start">                                        
                                        <input type="number" class="form-control form-control-sm text-end" id="withholding_tax" name="withholding_tax" value="0.00">
                                    </div>
                                </div>                         
                            </div>   
                            <div class="col-md-6">
                                <label for="notes" class="form-label">Narration</label>
                                <textarea class="form-control" id="notes" name="notes" rows="3">Payment against {{ $purchase_order->purchase_order_number }} to {{ $purchase_order->supplier_name }}.</textarea>
                                
                            </div>                             
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="form-label text-success fw-bolder">Paying Now</label>
                                    </div>
                                    <div class="col-md-6">
                                        <input type="number" class="form-control form-control-sm text-success fw-bolder text-end" id="paying_now" name="paying_now" value="{{ $remaining_amount->remaining_amount }}" required>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="card-footer text-end">
                    <button type="button" id="savePaymentButton" onclick="save_supplier_payment()" form="new_supplier_payment_form" class="btn btn-primary">
                        <span id="savePaymentSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span> Save Payment</button>
                </div>
            </div>
        </div>
    </div>
</div>

@else
    <h1>{{ config('permission.not_allowed') }}</h1>
@endcan
@endsection

@section('scripts')
<script>
    const purchase_order_id = "{{ $purchase_order_id }}";
    const remaining_amount = "{{ $remaining_amount }}";
    const baseURL = '{{ url("") }}'; // Use relative paths

    document.addEventListener('DOMContentLoaded', function() {

        get_cash_account_heads();
        calculate_total_payment_amount();

    });

    function get_cash_account_heads() {

        var account_type = $('#payment_mode').val();
        $('#loading_spinner').removeClass('d-none');
        $.ajax({
            url: baseURL + '/accounts/get_account_heads?' +'account_sub_control=' + account_type,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let accountHeads=data.account_heads;
                let accountHeadSelect = $('#account_head_id');
                accountHeadSelect.empty();
                accountHeads.forEach(function(accountHead) {
                    accountHeadSelect.append(new Option(accountHead.account_head_number + " - " + accountHead.account_head, accountHead.id_account_heads));
                });
                $('#loading_spinner').addClass('d-none');
            },
            error: function(xhr, status, error) {
                $('#loading_spinner').addClass('d-none');
                toastr.error('Error fetching account heads:', error);
            }
        });
    }

    function calculate_total_payment_amount() {
        let remainingAmount = parseFloat("{{ $remaining_amount->remaining_amount }}") || 0;
        let discount = parseFloat($('#discount').val()) || 0;
        let additionalCharge = parseFloat($('#additional_charge').val()) || 0;

        let totalPaymentAmount = remainingAmount - discount + additionalCharge;
        $('#total_payment_amount').val(totalPaymentAmount.toFixed(2));
        calculatePayingNow();
    }

    $('#discount, #additional_charge').on('input', function() {
        calculate_total_payment_amount();
    });

    function calculateSalesTax() {
        let totalPaymentAmount = parseFloat($('#total_payment_amount').val()) || 0;
        let salesTaxPercentage = parseFloat($('#sale_tax_percentage').val()) || 0;

        let salesTax = (totalPaymentAmount * salesTaxPercentage) / 100;
        $('#sale_tax').val(salesTax.toFixed(2));
        calculatePayingNow();
    }

    function calculateWithholdingTax() {
        let totalPaymentAmount = parseFloat($('#total_payment_amount').val()) || 0;
        let withholdingTaxPercentage = parseFloat($('#withholding_tax_percentage').val()) || 0;

        let withholdingTax = (totalPaymentAmount * withholdingTaxPercentage) / 100;
        $('#withholding_tax').val(withholdingTax.toFixed(2));
        calculatePayingNow();
    }

    function calculatePayingNow() {
        let totalPaymentAmount = parseFloat($('#total_payment_amount').val()) || 0;
        let salesTax = parseFloat($('#sale_tax').val()) || 0;
        let withholdingTax = parseFloat($('#withholding_tax').val()) || 0;

        let payingNow = totalPaymentAmount + salesTax - withholdingTax;
        $('#paying_now').val(payingNow.toFixed(2));
    }
    
    function save_supplier_payment() {
        let formData = $('#new_supplier_payment_form').serialize() + '&purchase_order_id=' + purchase_order_id;

        //console.log(formData);

        document.getElementById('savePaymentButton').disabled = true;
        document.getElementById('savePaymentSpinner').classList.remove('d-none');

        $.ajax({
            url: '{{  route('purchase.save_supplier_payment') }}',
            type: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: formData,
            dataType: 'json',
            success: function(data) {
                document.getElementById('savePaymentButton').disabled = false;
                document.getElementById('savePaymentSpinner').classList.add('d-none');
                if (data.message_type=='success') {
                    
                    Swal.fire({
                        title: 'Success!',
                        text: 'Supplier payment has been saved successfully.',
                        icon: 'success',
                        confirmButtonText: 'OK',
                        allowOutsideClick: false,
                        customClass: {
                            confirmButton: 'btn btn-success'
                        },
                    }).then(() => {
                        console.log(baseURL + '/accounts/account_voucher_print?id=' + data.id_account_voucher);
                        window.location.href = baseURL + '/accounts/account_voucher_print?id=' + data.id_account_voucher;
                    });
                } else {
                    toastr.error('Error saving supplier payment: ' + data.message);
                }
            },
            error: function(xhr, status, error) {
                document.getElementById('savePaymentButton').disabled = false;
                document.getElementById('savePaymentSpinner').classList.add('d-none');
                toastr.error(error);
            }
        });
    }

</script>
@endsection