@extends('layouts.horizontal', ['title' => 'Goods Receipt Note', 'topbarTitle' => 'Purchases', 'nonav' => true])

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$grn->business_logo }}" alt="{{ $grn->business_name }}">
                    </div>  
                    <h4 class="card-title">#: {{ $grn->grn_number }}</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-0">
                        <div class="mb-0 col-md-4">
                            <table class="table table-borderless fs-13 table-sm">
                                <tr>
                                    <td><span class="fw-bold">Supplier:</span></td>
                                    <td><span class="fw-bold">{{ $grn->supplier_name }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Contact Person:</span></td>
                                    <td><span class="fw-bold">{{ $grn->contact_person }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Email:</span></td>
                                    <td><span class="fw-bold">{{ $grn->email }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Phone:</span></td>
                                    <td><span class="fw-bold">{{ $grn->contact_number }}</span></td>
                                <tr>
                                    <td><span class="fw-bold">Address:</span></td>
                                    <td><span class="fw-bold">{{ $grn->ho_address }}</span></td>
                                </tr>
                                
                            </table>
                        </div>
                        <div class="mb-0 col-md-4"></div>
                        <div class="mb-0 col-md-4 text-end">
                            <label for="grn_date" class="form-label">GRN Date: {{ $grn->grn_created_date }}</label>                            
                            <p>{{ $grn->grn_comment }}</p>
                        </div>
                    </div>
                    <div class="mt-0">
                            <h5>Purchase Order Items</h5>
                            <table class="table table-sm table-bordered fs-13">
                                <thead>
                                    <tr>
                                        <th>Brand</th>
                                        <th>Product</th>
                                        <th>SKU</th>
                                        <th class="text-end">Unit Price</th>
                                        <th class="text-end">Unit Discount</th>
                                        <th>Received Qty</th>                                    
                                        <th>Cost</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $total_cost = 0; @endphp
                                    @foreach($grn_items as $item)
                                    <tr>
                                        <td>{{ $item->grn_brand_name }}</td>
                                        <td>{{ $item->grn_product_name }}</td>
                                        <td>{{ $item->grn_sku }}</td>
                                        <td class="text-end">{{ number_format($item->grn_unit_price, 2) }}</td>
                                        <td class="text-end">{{ number_format($item->grn_unit_discount, 2) }}</td>
                                        
                                        <td>{{ $item->grn_qty_received }}</td>                                    
                                        <td>
                                            {{ number_format($item->grn_qty_received * ($item->grn_unit_price - $item->grn_unit_discount), 2) }}
                                        </td>
                                    </tr>
                                    @php $total_cost += $item->grn_qty_received * ($item->grn_unit_price - $item->grn_unit_discount); @endphp
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="6" class="text-end">Total</th>
                                        <th class="total-cost">{{ number_format($total_cost, 2) }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-3 text-center">
                            <p class="mb-1">-----------------------------</p>
                            <p>Prepared By</p>
                        </div>
                        <div class="col-3 text-center">
                            <p class="mb-1">-----------------------------</p>
                            <p>Checked By</p>
                        </div>
                        <div class="col-3 text-center">    
                            <p class="mb-1">-----------------------------</p>                            
                            <p>Authorized By</p>                                                
                        </div>
                        <div class="col-3 text-center">
                            <p class="mb-1">-----------------------------</p>
                            <p>Received By</p>
                        </div>
                    </div>
                    <div class="card-footer text-end d-print-none">
                        <button type="button"  form="new_grn_form" class="btn btn-ghost-primary btn-icon" onclick="window.print()">
                            <iconify-icon icon="cil:print" class="fs-60"></iconify-icon>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection