@extends('layouts.horizontal', ['title' => 'Purchases', 'topbarTitle' => 'Purchases', 'nonav' => true])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])

@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>

@can('view_grn-Purchase_Orders')



<div class="PurchaseOrder">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 gap-3">
                <div class="card"> <!-- Purchase Order Details Card -->
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div>
                            <h4 class="card-title">Purchase Order #{{ $purchase_order->purchase_order_number }}</h4>
                        <h5 class="card-subtitle text-muted">For Branch: {{ $purchase_order->business_name }}</h5>
                        </div>
                        <div class="card-actions">                           
                            <a target="_po" href="{{ route('purchase.purchase_order_print', ['idpurchase_order' => $purchase_order->idpurchase_order]) }}" class="btn btn-outline-success btn-sm">
                                <iconify-icon icon="cil:print" class="fs-20"></iconify-icon>
                            </a>                        
                        </div>
                    </div>
                    
                    <div class="card-body">
                        <div class="row mb-1 g-4">
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Supplier Name:</strong> <span class="text-primary fw-bolder">{{ $purchase_order->supplier_name }}</span>
                            </div>
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Contact:</strong> <span class="text-primary fw-bolder">{{ $purchase_order->contact_person }}</span>
                            </div>
                        </div>
                        <div class="row mb-1 g-4">
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Supplier Address:</strong> <span class="text-primary fw-bolder">{{ $purchase_order->ho_address }}</span>
                            </div>
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Email:</strong> <span class="text-primary fw-bolder">{{ $purchase_order->email }}</span>
                            </div>
                        </div>
                        <div class="row mb-1 g-4">
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Order Date:</strong>  <span class="text-primary fw-bolder">{{ $purchase_order->formatted_order_date }}</span>
                            </div>
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Created On:</strong> <span class="text-primary fw-bolder">{{ \Carbon\Carbon::parse($purchase_order->created_on)->format('d-m-Y H:i') }}</span>
                            </div>
                                                   
                        </div>
                        <div class="row mb-1 g-4">
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Total Quantity:</strong>  <span class="text-primary fw-bolder">{{ $purchase_order->product_total_qty }}</span>
                            </div>
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Total Purchase Price:</strong>  <span class="text-primary fw-bolder">{{ config('constants.CURRENCY') }}{{ round($purchase_order->total_purchase_pirce, 2) }}</span>
                            </div>
                        </div>
                        
                        <div class="row mb-1 g-4">
                            
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <strong>Created By:</strong> <span class="text-primary fw-bolder">{{ $purchase_order->created_by }}</span>
                            </div>
                            <div class="col-md-6 d-flex align-items-center justify-content-between">
                                <div class="input-group">
                                    <select class="form-select form-select-sm" style="width: 150px !important;" aria-label="Status select"><option selected>{{ $purchase_order->status }}</option></select>
                                    <button class="btn btn-success btn-sm" type="button"><i class="ti ti-device-floppy fs-16"></i></button>
                                </div>
                            </div>     
                        </div>                        
                    </div>
                </div><!-- End Purchase Order Details Card -->

                <div class="card"> <!-- Purchase Order Items Card -->
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <div>
                            <h4 class="card-title">Purchase Order Items</h4>
                            <h5 class="card-subtitle text-muted">Items included in this Purchase Order</h5>
                        </div>
                        <div class="card-actions">
                            @can('create_grn-Purchase_Orders')
                                <a target="_grn" href="{{ route('purchase.new_grn', ['idpurchase_order' => $purchase_order->idpurchase_order]) }}" class="btn btn-outline-success btn-sm">
                                    <iconify-icon icon="vaadin:stock" class="me-1"></iconify-icon>Add GRN
                                </a>
                            @endcan
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-sm fs-13 mb-0">
                                <thead>
                                    <tr>
                                        <th>Product Name</th>
                                        <th>Brand</th>
                                        <th class="text-end">Ordered</th>
                                        <th class="text-end text-success">Received</th>
                                        <th class="text-end text-danger">Returned</th>
                                        <th class="text-end">Final Receiving</th>
                                        <th class="text-end">Unit Price</th>
                                        <th class="text-end">Unit Discount</th>
                                        <th class="text-end">Total Qty Value</th>
                                        <th class="text-end">Payable</th>                                     
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $total_received = 0;  $total_qty = 0; $total_discount = 0; $total_cost=0; $total_returned = 0; $total_qty_value=0; @endphp
                                    @foreach($purchase_order_details as $item)
  
                                    <tr>
                                        <td>{{ $item->product_name }}</td>
                                        <td>{{ $item->brand_name }}</td>
                                        <td class="text-end">{{ $item->product_qty }}</td>
                                        <td class="text-end text-success">{{ $item->total_received ?? 0 }}</td>
                                        <td class="text-end text-danger">{{ $item->total_returned ?? 0 }}</td>
                                        <td class="text-end">{{ $item->total_received - ($item->total_returned ?? 0) }}</td>
                                        <td class="text-end">{{ config('constants.CURRENCY') }}{{ round($item->product_purchase_price, 2) }}</td>
                                        <td class="text-end">{{ config('constants.CURRENCY') }}{{ round($item->unit_discount, 2) }}</td>
                                        <td class="text-end">{{ config('constants.CURRENCY') }}{{ round(($item->product_purchase_price - $item->unit_discount) * $item->product_qty, 2) }}</td>
                                        <td class="text-end">{{ config('constants.CURRENCY') }}{{ round($item->product_purchase_price * ($item->total_received - ($item->total_returned ?? 0)), 2) }}</td>                                                                    
                                    </tr>
                                    @php 
                                    $total_received += $item->total_received ?? 0; 
                                    $total_cost += $item->product_purchase_price * ($item->total_received - ($item->total_returned ?? 0));; 
                                    $total_qty += $item->product_qty;
                                    $total_qty_value += $item->product_purchase_price * $item->product_qty - ($item->unit_discount * $item->product_qty);
                                    $total_returned += $item->total_returned ?? 0;
                                    $total_discount += $item->unit_discount * $item->product_qty;
                                    @endphp 
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="2" class="text-end">Total</th>
                                        <th class="text-end">{{ $total_qty }}</th>
                                        <th class="text-end text-success">{{ $total_received }}</th>
                                        <th class="text-end text-danger">{{ $total_returned }}</th>
                                        <th class="text-end">{{ $total_received - $total_returned }}</th>
                                        <th></th>
                                        <th class="text-end">{{ config('constants.CURRENCY') }}{{ round($total_discount, 2) }}</th>
                                        <th class="text-end">{{ config('constants.CURRENCY') }}{{ round($total_qty_value, 2) }}</th>
                                        <th class="text-end">{{ config('constants.CURRENCY') }}{{ round($total_cost, 2) }}</th>                               
                                    </tr>
                            </table>
                        </div>
                    </div>
                </div><!-- End Purchase Order Items Card -->

                <div class="card"> <!-- GRN Create Card -->
                    <div class="card-header  align-items-left">
                        <h4 class="card-title">Existing Goods Received Note (GRN)</h4>
                        <h5 class="card-subtitle text-muted">GRNs for this Purchase Order</h5>
                        <div class="card-actions">
                            
                        </div>
                        <div class="card-body">
                            <div class="col-md-12">
                                <table class="table table-bordered table-sm fs-13 mb-0">
                                    <thead>
                                        <tr>
                                            <th>GRN ID</th>
                                            <th>GRN#</th>
                                            <th>GRN Date</th>
                                            <th>Products</th>
                                            <th>Comment</th>
                                            <th class="text-end">Received Qty</th>
                                            <th class="text-end">Returned Qty</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php $total_grn_received = 0;  $total_grn_cost=0; $total_returned = 0; @endphp
                                        @foreach($goods_received_notes as $grn)                                            
                                            <tr>
                                                <td>{{ $grn->grn_id }}</td>
                                                <td>{{ $grn->grn_number }}</td>
                                                <td>{{ $grn->formatted_grn_date }}</td>
                                                <td>{!! $grn->products_received !!}</td>       
                                                <td>{{ $grn->grn_comment }}</td>               
                                                <td class="text-end"><a target="_blank" class="text-success" href="{{ route('purchase.print_grn', ['idgrn' => $grn->grn_id]) }}">{{ $grn->total_received }}</a></td>       
                                                <td class="text-end"><a target="_blank" @php if($grn->total_returned > 0) echo 'href="'.route('purchase.print_return_note', ['idgrn' => $grn->grn_id]).'"'; else echo "#"; @endphp>{{ $grn->total_returned ?? 0 }}</a></td>                             
                                                <td class="text-center">
                                                    @can('return_GRN-Purchase_Orders')
                                                        <a href="{{ route('purchase.return_note', ['idgrn' => $grn->grn_id]) }}" class="btn btn-outline-danger btn-sm">Add Return Note</a>
                                                    @endcan
                                                </td>
                                            </tr>   
                                            @php 
                                                $total_grn_received += $grn->total_received;
                                                $total_grn_cost += $grn->total_cost; 
                                                $total_returned += $grn->total_returned ?? 0;
                                            @endphp                                        
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th colspan="5" class="text-end">Total</th>                                            
                                            <th class="text-end">{{ $total_grn_received }}</th>        
                                            <th class="text-end">{{ $total_returned }}</th>                                    
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div><!-- End GRN Create Card -->
                </div>

                <div class="card"> <!-- Account Vouchers Card -->
                    <div class="card-header  d-flex align-items-center justify-content-between">
                        <div>
                            <h4 class="card-title">Account Vouchers Linked to this Purchase Order</h4>
                            <h5 class="card-subtitle text-muted">{{$account_heads_name ?? ''}} Vouchers</h5>
                        </div>
                        <div class="card-actions">
                            @can('add_payment-Purchase_Orders')
                                <a href="{{ route('purchase.new_supplier_payment', ['purchase_order_id' => $purchase_order->idpurchase_order]) }}" class="btn btn-outline-success btn-sm">
                                    <iconify-icon icon="ph:money-wavy-thin" class="fs-20 me-1"></iconify-icon>
                                    Add Payment Voucher
                                </a>
                            @endcan
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="col-md-12">
                            <table class="table table-bordered table-sm fs-13 w-100">
                                <thead >
                                    <tr>
                                        <th>Date</th>
                                        <th>Voucher #</th>
                                        <th>GRN #</th>
                                        <th>Description</th>
                                        <th class="text-end">Debit</th>
                                        <th class="text-end">Credit</th>
                                        <th class="text-end">Running Total</th>
                                    </tr>
                                </thead>
                                
                                <tbody>
                                    @php
                                        $running_balance = 0;
                                    @endphp

                                    @forelse($account_vouchers as $av)

                                        @php
                                            // Payable increases balance
                                            if($av->total_credit > 0){
                                                $running_balance += $av->total_credit;
                                            }

                                            // Paid decreases balance
                                            if($av->total_debit > 0){
                                                $running_balance -= $av->total_debit;
                                            }
                                        @endphp

                                        <tr>
                                            <td>{{ $av->formatted_voucher_date }}</td>

                                            <td>
                                                <a target="_blank"
                                                href="{{ route('accounts.account_voucher_print', ['id' => $av->id_account_vouchers]) }}">
                                                    {{ $av->id_account_vouchers }}
                                                </a>
                                            </td>

                                            <td>{{ $av->grn_id ?? '-' }}</td>

                                            <td>
                                                {{ $av->description ?? 'Invoice / GRN Adjustment' }}
                                            </td>

                                            <td class="text-end ">
                                                {{ $av->total_debit > 0 ? config('constants.CURRENCY').number_format($av->total_debit,2) : '0' }}
                                            </td>

                                            <td class="text-end ">
                                                {{ $av->total_credit > 0 ? config('constants.CURRENCY').number_format($av->total_credit,2) : '0' }}
                                            </td>

                                            <td class="text-end ">
                                                {{ config('constants.CURRENCY') }}{{ number_format($running_balance,2) }}
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="7" class="text-center text-muted">
                                                No records found
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>

                                <tfoot class="fw-bold">
                                    <tr>
                                        <th colspan="4" class="text-end">Total</th>
                                        <th class="text-end">
                                            {{ config('constants.CURRENCY') }}{{ number_format($account_vouchers->sum('total_debit'),2) }}
                                        </th>
                                        <th class="text-end">
                                            {{ config('constants.CURRENCY') }}{{ number_format($account_vouchers->sum('total_credit'),2) }}
                                        </th>
                                        <th class="text-end">
                                            {{ config('constants.CURRENCY') }}{{ number_format($running_balance,2) }}
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>

                        </div>
                    </div>
                </div><!-- End Account Vouchers Card -->                
            </div>
        </div>
    </div>
</div>
@else
    <h1>{{ config('permission.not_allowed') }}</h1>
@endcan
@endsection
