@extends('layouts.horizontal', ['title' => 'PO print', 'topbarTitle' => 'Purchases', 'nonav' => true])

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$purchase_order->business_logo }}" alt="{{ $purchase_order->business_name }}">
                    </div>  
                    <h4 class="card-title">PO #: {{ $purchase_order->purchase_order_number }}</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-0">
                        <div class="mb-0 col-md-4">
                            <table class="table table-borderless fs-13 table-sm">
                                <tr>
                                    <td><span class="fw-bold">Supplier:</span></td>
                                    <td><span class="fw-bold">{{ $purchase_order->supplier_name }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Contact Person:</span></td>
                                    <td><span class="fw-bold">{{ $purchase_order->contact_person }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Email:</span></td>
                                    <td><span class="fw-bold">{{ $purchase_order->email }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Phone:</span></td>
                                    <td><span class="fw-bold">{{ $purchase_order->contact_number }}</span></td>
                                <tr>
                                    <td><span class="fw-bold">Address:</span></td>
                                    <td><span class="fw-bold">{{ $purchase_order->ho_address }}</span></td>
                                </tr>
                                
                            </table>
                        </div>
                        <div class="mb-0 col-md-4"> </div>
                        <div class="mb-0 col-md-4 text-end">                             
                            <label for="po_date" class="form-label">Date: {{ $purchase_order->formatted_order_date }}</label> 
                            <br>
                             <label for="po_validity" class="form-label">Printed On: {{ date('d-m-Y H:i')  }}</label>     
                        </div>
                    </div>
                    <div class="mt-0">
                            <h5>Purchase Order Items</h5>
                            <table class="table table-sm table-bordered fs-13">
                                <thead>
                                    <tr>
                                        <th>Brand</th>
                                        <th>Product</th>
                                        <th class="text-end">Unit Price</th>
                                        <th class="text-end">Unit Discount</th>                                        
                                        <th>Ordered Qty</th>                                    
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $total_cost = 0; @endphp
                                    @foreach($purchase_order_details as $item)
                                    @php 
                                        $item_cost = ($item->product_purchase_price - $item->unit_discount) * $item->product_qty;
                                        $total_cost += $item_cost;
                                    @endphp
                                    <tr>
                                        <td>{{ $item->brand_name }}</td>
                                        <td>{{ $item->product_name }}</td>
                                        <td class="text-end">{{ config('constants.CURRENCY') }}{{ number_format($item->product_purchase_price, 2) }}</td>                                        
                                        <td class="text-end">{{ config('constants.CURRENCY') }}{{ number_format($item->unit_discount, 2) }}</td>
                                        <td>{{ $item->product_qty }}</td>                                    
                                        <td>{{ config('constants.CURRENCY') }}{{ number_format($item_cost, 2) }}</td>
                                    </tr>
                                    @endforeach 
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-end">Total PO Value</th>
                                        <th>{{ config('constants.CURRENCY') }}{{ number_format($total_cost, 2) }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <div class="row mt-5">
                        <div class="col-4 text-center">
                            <p class="mb-3">-----------------------------</p>
                            <p>Prepared By</p>
                        </div>
                        <div class="col-4 text-center">
                            <p class="mb-3">-----------------------------</p>
                            <p>Checked By</p>
                        </div>
                        <div class="col-4 text-center">    
                            <p class="mb-3">-----------------------------</p>                            
                            <p>Authorized By</p>
                                                    
                        </div>
                        
                    </div>
                </div>
                
                <div class="card-footer text-end d-print-none">
                    <button type="button"  form="new_grn_form" class="btn btn-ghost-primary btn-icon" onclick="window.print()">
                        <iconify-icon icon="cil:print" width="30"></iconify-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection