@extends('layouts.horizontal', ['title' => 'Purchases', 'topbarTitle' => 'Purchases'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])

@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="PurchaseOrdersPage">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Purchase Orders</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="row ">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="mb-3 d-flex align-items-center justify-content-between">
                        <h5 class="card-title mb-0 fw-bold">Filter Products</h5>
                        @can('create-Purchase_Orders')
                            <button class="btn btn-sm btn-outline-success" onclick="open_add_purchase_order_modal()">
                                <iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon>
                                Add Purchase Order
                            </button>
                        @endcan
                    </div>
                    <form id="filterform">
                        <div class="row gap-1">          
                            <div class="col-md-2">
                                <label class="form-label" for="business_type">Select  Branch Type</label>
                                <select id="business_type" name="business_type_id" class="form-select">  
                                    <option value="">-- All Business Types --</option>                                  
                                    @foreach($business_types as $type)
                                        <option value="{{ $type->id_business_type }}" @if($type->id_business_type == $business_type_id) selected @endif>{{ $type->business_type }}</option>
                                    @endforeach
                                </select>
                            </div>                           
                                              
                            <div class="col-md-2">
                                <label class="form-label" for="branch_id">Select  Branch</label>
                                <select id="branch_id" name="business_id" class="form-select">  
                                    <option value="">-- All Branches --</option>                                  
                                    @foreach($branches as $branch)
                                        <option value="{{ $branch->id_business }}" @if($branch->id_business == $business_id) selected @endif>{{ $branch->business_name }}</option>
                                    @endforeach
                                </select>
                            </div>                           
                            <div class="col-md-2">
                                <label class="form-label" for="start_date">Start Date</label>
                                <input type="date" id="start_date" name="start_date" class="form-control" value="{{ $start_date }}">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label" for="end_date">End Date</label>
                                <input type="date" id="end_date" name="end_date" class="form-control" value="{{ $end_date }}">
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button id="refreshButton" type="button" class="btn btn-ghost-dark btn-icon rounded-circle mt-3" data-bs-toggle="tooltip" data-bs-placement="top" title="Refresh">
                                    <iconify-icon icon="mdi:refresh" class="fs-22" ></iconify-icon>
                                </button>
                            </div>                           
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> <!-- end row-->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="purchaseOrdersTable" class="table table-sm fs-13 dt-responsive w-100">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Supplier</th>
                                    <th>PO. Number</th>
                                    <th>Created By</th>
                                    <th>Branch</th>
                                    <th>Order Date</th>
                                    <th>Status</th>
                                    <th>Total Qty</th>
                                    <th>Total Discount</th>
                                    <th>Total Amount</th>
                                    <th>Amount Due</th>
                                    <th>Edit</th>
                                    <th>GRN</th>
                                    <th>Print</th>
                                </tr>
                            </thead>
                            <tbody>
                               
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- end page title -->
{{--  Modal Purchase Order Add Edit --}}
<div class="modal fade" id="purchaseOrderEditModal" tabindex="-1" aria-labelledby="purchaseOrderEditModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="purchaseOrderEditModalLabel"><span id="purchaseOrderEditModalLabelText">Add</span> Purchase Order</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="purchaseOrderEditModalForm">
                    <div class="row">
                        <div class="col-6">
                            <input type="hidden" id="business_id" name="business_id">
                            <label class="form-label" for="supplier_id">Select Supplier</label>
                            <select class="form-select select2" id="supplier_id" name="supplier_id">
                                @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id_business_supplier }}">{{ $supplier->supplier_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4">
                            <label class="form-label" for="order_date">Order Date</label>
                            <input type="date" id="order_date" name="order_date" class="form-control" value="{{ date('Y-m-d') }}">
                        </div>
                         <div class="col-2">
                            <label class="form-label" for="id_purchase_order">PO ID</label>
                            <input type="text" id="id_purchase_order" name="id_purchase_order" class="form-control" disabled>
                        </div>

                    </div>
                    <div class="row mt-3">
                        <div class="col-6">
                            <label class="form-label" for="brand_id">Select Brand</label>
                            <select onchange="get_products()" class="form-select select2" id="brand_id" name="brand_id">
                                <option value="">-- Select Brand --</option>
                                @foreach($brands as $brand)
                                    <option value="{{ $brand->id_business_brands }}">{{ $brand->business_brand_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-4">
                            <label class="form-label" for="product">Product</label>
                            <select id="product" name="product" class="form-control select2" placeholder="Enter product name or code">
                               
                            </select>
                        </div>
                        <div class="col-2 d-flex align-items-end">
                            
                            <button type="button" onclick="add_purchase_order_item_to_table()" id="addProductButton" class="btn btn-ghost-dark btn-icon rounded-circle mt-2 me-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Add Product">
                                <iconify-icon icon="line-md:arrow-open-down" class="fs-20"></iconify-icon>
                            </button>
                            <div class="spinner-grow avatar-sm m-2 d-none" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                            <table class="table table-bordered" id="purchaseOrderItemsTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Product</th>
                                        <th>Brand</th>
                                        <th>Quantity</th>
                                        <th>Price</th>
                                        <th>Unit Discount</th>
                                        <th>Total</th>                                                                                
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Purchase order items will be dynamically added here -->
                                </tbody>
                            </table>
                        </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="cancelPurchaseOrderButton" class="btn btn-danger" onclick="cancelPurchaseOrder()">Cancel PO</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button onclick="savePurchaseOrder()" id="savePurchaseOrderButton" type="button" class="btn btn-primary">
                    <span id="savePurchaseOrderSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span> Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- Modal End --}}
@endsection

@section('scripts')
<script>
    const editPurchaseOrders = "{{ auth()->user()->can('edit-Purchase_Orders') }}";
    const viewGRN = "{{ auth()->user()->can('view_grn-Purchase_Orders') }}";
    const changePricePurchaseOrders = "{{ auth()->user()->can('change_price-Purchase_Orders') }}";
    $(document).ready(function() {
        // set default dates if not set
        if (!$("#start_date").val()) {
            let today = new Date();
            let priorDate = new Date().setDate(today.getDate() - 30);
            let endDate = new Date().setDate(today.getDate() + 1);
            $("#start_date").val(new Date(priorDate).toISOString().split('T')[0]);
        
            $("#end_date").val(new Date(endDate).toISOString().split('T')[0]);
        }

        initializePurchaseOrdersTable();

        // Refresh button click
        $("#refreshButton").on("click", function() {
            //distroy existing table instance
            var table = $('#purchaseOrdersTable').DataTable();
            table.destroy();
            initializePurchaseOrdersTable();
        });

        //select2 initialization
        $('.select2').select2({
            dropdownParent: $("#purchaseOrderEditModal"),
            width: '100%'
        });
        
       
    });

    //on scroll close tooltips
    $(window).on('scroll', function () {
            $('[data-bs-toggle="tooltip"]').each(function () {
                let instance = bootstrap.Tooltip.getInstance(this);
                if (instance) {
                    instance.hide();
                }
            });
    });

    function initializePurchaseOrdersTable() {

        //Destroy existing table instance if exists
        
        var table = $('#purchaseOrdersTable').DataTable({
            ajax: {
                url: '{{ route("purchase.purchase_orders_data") }}',
                dataSrc: 'data',
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    start_date: $("#start_date").val(),
                    end_date: $("#end_date").val(),
                    business_id: $("#branch_id").val()
                }
            },           
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
             buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            columns: [
                { data: 'idpurchase_order' },
                { data: 'supplier_name' },
                { data: 'purchase_order_number',
                    render: function (data, type, row) {
                        return `<span class="badge bg-primary fs-10">` + data + `</span>`;
                    }
                 },
                { data: 'created_by' },
                { data: 'business_name' },
                { data: 'order_date' },
                { data: 'status' },
                { data: 'total_qty' },
                { data: 'total_discount' },
                { data: 'total_value' },
                { data: 'amount_due' , 
                    render: function (data, type, row) {
                        if(data > 0){
                            return `<span class="text-danger fw-bolder">` + data.toFixed(2) + `</span>`;
                        }else if(data <= 0){
                            //display 2 decimal places
                            return `<span class="text-success fw-bolder">` + data.toFixed(2) + `</span>`;
                        }else{
                            return `<span>` + data + `</span>`;
                        }
                    }
                },
                { 
                    data: null,
                    render: function (data, type, row) {

                        if(!editPurchaseOrders)
                            return '';

                        if(data.status.toLowerCase() == 'cancelled'){
                            return `<button disabled class="btn btn-sm btn-ghost-secondary rounded-circle btn-icon edit-order" data-bs-toggle="tooltip" title="Edit Order" data-id="` + row.idpurchase_order + `">
                            <iconify-icon icon="mdi:pencil" class="fs-22"></iconify-icon>
                            </button>`;
                        } else {
                        return `
                        <button onclick="open_edit_purchase_order_modal(` + row.idpurchase_order + `)" class="btn btn-sm btn-ghost-success rounded-circle btn-icon edit-order" data-bs-toggle="tooltip" title="Edit Order" data-id="` + row.idpurchase_order + `">
                            <iconify-icon icon="mdi:pencil" class="fs-22"></iconify-icon>
                            </button>`;
                        }
                    }
                },
                { data: null, 
                    render: function (data, type, row) {

                        if(!viewGRN)
                            return '';

                        if(data.status.toLowerCase() == 'cancelled'){
                            return `<button disabled class="btn btn-ghost-secondary rounded-circle btn-icon grn" data-bs-toggle="tooltip" title="View GRN" data-id="` + row.idpurchase_order + `">
                                <iconify-icon icon="vaadin:stock" class="fs-22"></iconify-icon>
                            </button>`;
                        } else {
                        let url = '{{ route("purchase.open_purchase_order", ["idpurchase_order" => ":idpurchase_order"]) }}';
                        url = url.replace(':idpurchase_order', row.idpurchase_order);
                        return `<a target="_blank" href="` + url + `" class="btn btn-ghost-warning rounded-circle btn-icon grn" data-bs-toggle="tooltip" title="View GRN" data-id="` + row.idpurchase_order + `">
                                <iconify-icon icon="vaadin:stock" class="fs-22"></iconify-icon>
                            </a>`;
                        }
                    }
                } ,
                { data: null, 
                    render: function (data, type, row) {
                        let url = '{{ route("purchase.purchase_order_print", ["idpurchase_order" => ":idpurchase_order"]) }}';
                        url = url.replace(':idpurchase_order', row.idpurchase_order);
                        return `<a target="_blank" href="` + url + `" class="btn btn-ghost-light rounded-circle btn-icon print-order" data-bs-toggle="tooltip" title="Print Order" data-id="` + row.idpurchase_order + `">
                                <iconify-icon icon="mdi:printer" class="fs-22"></iconify-icon>
                            </a>`;
                    }
                }
            ],
            responsive: true,
            order: [[0, 'desc']],
            pageLength: 10,
            lengthMenu: [10, 25, 50, 100],
            rowCallback: function(row, data, index){
                if(data.status.toLowerCase() == 'cancelled'){
                    $(row).addClass('strike-through');
                }
            },
            drawCallback: function(settings) {
                // Initialize tooltips after table draw
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('#purchaseOrdersTable [data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
                })
            }
        });
    }

    function open_add_purchase_order_modal() {
        // Clear previous data
        $("#cancelPurchaseOrderButton").hide();
        $('#purchaseOrderEditModalLabelText').text("Add");
        $('#supplier_id').val(null).trigger('change');
        $('#order_date').val('{{ date("Y-m-d") }}');
        $('#id_purchase_order').val('');
        $("#brand_id").val(null).trigger('change');
        $('#business_id').val('{{ session("business_id") }}');
        $("#product").empty();
        
        $('#purchaseOrderItemsTable tbody').empty();
        $('#purchaseOrderItemsTable tfoot').remove();

        // Open modal
        El = document.getElementById('purchaseOrderEditModal');
        var modal = new bootstrap.Modal(El);
        modal.show();
    }

    function open_edit_purchase_order_modal(purchase_order_id) {
        // Fetch modal content via AJAX
        $.ajax({
            url: '{{ url("purchase/open_purchase_details") }}/' + purchase_order_id,
            method: 'Post',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                //open modal and set response to modal body
                data = response;

                if(data.items.length == 0){
                    Swal.fire({
                        icon: 'info',
                        title: 'Info',
                        text: data.message,
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: data.message_btn
                        }
                    });
                    return;
                }
                $("#cancelPurchaseOrderButton").show();
                $("#purchaseOrderEditModalLabelText").text("Edit");
                $('#supplier_id').val(data.items[0].supplier_id).trigger('change');
                $('#order_date').val(data.items[0].formatted_order_date);
                $('#id_purchase_order').val(data.items[0].idpurchase_order);
                $('#business_id').val(data.items[0].business_id);
                //loop through response data and set to modal body
                $('#purchaseOrderItemsTable tbody').empty();
                
                data.items.forEach(function(item) {
                    var row = `
                        <tr>
                            <td data-id-purchase_order_details="` + item.idpurchase_order_details + `">` + item.product_id + `</td>
                            <td data-product-id="` + item.product_id + `">` + item.product_name + `</td>
                            <td data-brand-id="` + item.brand_id + `">` + item.brand_name + `</td>
                            <td><input type="number" onkeyup="recalculate_totals()" class="form-control form-control-sm quantity" value="` + item.product_qty + `" min="1"></td>
                            <td><input type="number" onkeyup="recalculate_totals()" class="form-control form-control-sm price ${changePricePurchaseOrders ? '' : 'bg-light'}" value="` + item.product_purchase_price + `" step="0.01" min="0" ${changePricePurchaseOrders ? '' : 'readonly'} ></td>
                            <td><input type="number" onkeyup="recalculate_totals()" class="form-control form-control-sm discount" value="` + item.unit_discount + `" step="0.01" min="0"></td>
                            <td class="total">` + (parseFloat(item.product_qty) * parseFloat(item.product_purchase_price)).toFixed(2) + `</td>               
                            <td>
                                <button type="button" disabled class="btn btn-sm btn-danger btn-icon remove-item" data-bs-toggle="tooltip" title="Remove Item">
                                    <iconify-icon icon="mdi:close" class="fs-18"></iconify-icon>
                                </button>
                            </td>
                        </tr>
                    `;
                    $('#purchaseOrderItemsTable tbody').append(row);
                });
                recalculate_totals();
                El = document.getElementById('purchaseOrderEditModal');
                var modal = new bootstrap.Modal(El);
                modal.show();
            },
            error: function() {
                alert('Failed to load purchase order details.');
            }
        });
    }
    
    function add_purchase_order_item_to_table() {
        let item = {};
        let product = $('#product').select2('data')[0];
        //console.log(product);
        item.product = product ? product.text : null;
        item.product_id = product ? product.id : null;
        if (!item.product) {
            toastr.error('Please select a product to add.');
            return;
        }
        let exists = false;
        $('#purchaseOrderItemsTable tbody tr').each(function() {
            var prodName = $(this).find('td:first').text();
           
            if (prodName === item.product_id) {
                exists = true;
                return false; // break loop
            }
        });
        if (exists) {
            toastr.error('Product already exists in the table.');
            return;
        }
        item.brand = $('#brand_id option:selected').text();
        item.price = parseFloat($('#product option:selected').data('product-price')) || 0;

        var item_brand = item.brand;
        var item_brand_id = $('#brand_id option:selected').val();

        if (product && (item_brand_id == '' || item_brand_id == undefined)) {
            item_brand = product.brand;
            item_brand_id = product.brand_id;
            console.log(product);
            console.log('1');
        }

        if (product && !item.price) {
            item.price = parseFloat(product.purchase_price) || 0;
        }
        console.log(item_brand_id, item_brand);
        
        var row = `
            <tr>
                <td data-id-purchase_order_details="0">` + item.product_id + `</td>
                <td data-product-id="` + item.product_id + `">` + item.product + `</td>
                <td data-brand-id="` + item_brand_id + `">` + item_brand + `</td>
                <td><input type="number" onkeyup="recalculate_totals()" class="form-control form-control-sm quantity" value="1" min="1"></td>
                <td><input type="number" onkeyup="recalculate_totals()" class="form-control form-control-sm price ${changePricePurchaseOrders ? '' : 'bg-light'}" value="` + item.price + `" step="0.01" min="0" ${changePricePurchaseOrders ? '' : 'readonly'} ></td>
                <td><input type="number" onkeyup="recalculate_totals()" class="form-control form-control-sm discount" value="` + item.unit_discount + `" step="0.01" min="0"></td>
                <td class="total">` + item.price.toFixed(2) + `</td>
                <td>
                    <button type="button" onclick="remove_purchase_order_item(this)" class="btn btn-sm btn-danger btn-icon remove-item" data-bs-toggle="tooltip" title="Remove Item">
                        <iconify-icon icon="mdi:close" class="fs-18"></iconify-icon>
                    </button>
                </td>
            </tr>
        `;
        $('#purchaseOrderItemsTable tbody').append(row);
        recalculate_totals();
    }

    function get_products(){
        //fetch products using brand id
        let brand_id = $('#brand_id option:selected').val();
        if(!brand_id){
            //toastr.error('Please select a brand to load products.');
            if ($('#product').hasClass('select2-hidden-accessible')) {
                $('#product').select2('destroy');
            }
            $('#product').val(null).empty();
            $('#product').select2({
                width: '100%',
                placeholder: 'Select a product',
                dropdownParent: $('#purchaseOrderEditModal'),
                placeholder: 'Select a product',
                ajax: {
                    url: '{{ route("products.search_products") }}',
                    dataType: 'json',
                    delay: 1000,
                    data: function(params) {
                        return {
                            q: params.term, 
                        
                        };
                    },
                    processResults: function(data) {
                       return {
                            results: data.map(function (item) {
                                var pro = item.professional == 'n' ? 'Retail' : 'Professional';
                                return {
                                id: item.id,
                                text: item.business_brand_name + ' ' + item.product + ' ' + (item.category ? ' (Category: ' + item.category + ')' : '') + ' '  + (pro ? ' (' + pro + ')' : '') ,
                                measure_unit: item.measure_unit,
                                qty_per_unit: item.qty_per_unit,
                                product: item.product,
                                brand: item.business_brand_name,
                                brand_id: item.brand_id,
                                price: item.price,
                                purchase_price: item.purchase_price,
                                category: item.category,
                                unit_type: item.unit_type,
                                product_type: item.product_type, 
                                };
                            })
                        };
                    },
                    cache: false
                },
                minimumInputLength: 4
            });


            return;
        }
        //console.log($('#brand_id option:selected').val());
        document.querySelector('#addProductButton + .spinner-grow').classList.remove('d-none');
        $.ajax({
            url: "{{ route('products.product_by_brand', ['id_business_brands' => ':id_business_brands']) }}".replace(':id_business_brands', brand_id),
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: {
                brand_id: brand_id
            },
            success: function(response) {
                // Handle the response containing products
                //console.log(response);
                // You can update your product dropdown or perform other actions here
                $('#product').empty(); // Clear existing options
                //destory product select2
                if ($('#product').hasClass("select2-hidden-accessible")) {
                    $('#product').select2('destroy');
                }   
                response.forEach(function(item) {
                    var pro = item.professional == 'n' ? 'Retail' : 'Professional';

                    var option = "<option data-product-price='" + item.purchase_price + "'  value='" + item.id + "'>" + item.business_brand_name + ' ' + item.product + ' ' + (item.mcategory ? ' (' + item.qty_per_unit + '  '+item.measure_unit+')' : '') +  ' ' + (pro ? ' (' + pro + ')' : '') + "</option>";
                    $('#product').append(option);
                });
                //initialize select2 again 
                 $('#product').select2({
                    width: '100%',
                    placeholder: 'Select a product',
                    dropdownParent: $('#purchaseOrderEditModal')
                });
                //$('#product').trigger('change'); // Notify Select2 to update options
                document.querySelector('#addProductButton + .spinner-grow').classList.add('d-none');
            },
            error: function() {
                document.querySelector('#addProductButton + .spinner-grow').classList.add('d-none');
                toastr.error('Failed to load products.');
            }
        });
    }

    function recalculate_totals() {
        
        let grandTotal = 0;
        let totalItems = 0;
        $('#purchaseOrderItemsTable tbody tr').each(function() {
            var quantity = parseFloat($(this).find('.quantity').val()) || 0;
            var price = parseFloat($(this).find('.price').val()) || 0;
            var discount = parseFloat($(this).find('.discount').val()) || 0;
            var total = (quantity * price) - (discount * quantity);
            totalItems += quantity;
            grandTotal += total;
            $(this).find('.total').text(total.toFixed(2));
        });

        // Append grand total and total items to the table footer
        $('#purchaseOrderItemsTable tfoot').remove();
        var footer = `
            <tfoot>
                <tr>
                    <td colspan="3" class="text-start">Total</td>
                    <td class="total-qty">` + totalItems + `</td>
                    <td></td>   
                    <td></td>                 
                    <td class="grand-total">` + grandTotal.toFixed(2) + `</td>
                    <td></td>
                </tr>
            </tfoot>
        `;
        $('#purchaseOrderItemsTable').append(footer);
    }

    function savePurchaseOrder() {
        if($("#purchaseOrderItemsTable tbody tr").length == 0){
            toastr.error('Please add at least one item to the purchase order.');
            return;
        }

        if($('#supplier_id').val() == null || $('#supplier_id').val() == ''){
            toastr.error('Please select a supplier for the purchase order.');
            return;
        }

        if($('#business_id').val() == null || $('#business_id').val() == ''){
            toastr.error('Please select a business for the purchase order.');
            return;
        }

        if($("#order_date").val() == null || $("#order_date").val() == ''){
            toastr.error('Please select an order date for the purchase order.');
            return;
        }

        $('#savePurchaseOrderButton').prop('disabled', true);

        let purchaseOrderData = {
            business_id: $('#business_id').val(),
            supplier_id: $('#supplier_id').val(),
            supplier_name: $('#supplier_id option:selected').text(),
            order_date: $('#order_date').val(),
            id_purchase_order: $('#id_purchase_order').val(),
            total_purchase_price: parseFloat($('.grand-total').text()) || 0,
            product_total_qty: parseInt($('.total-qty').text()) || 0,
            items: []
        };
        $('#purchaseOrderItemsTable tbody tr').each(function() {
            let item = {
                idpurchase_order_details: $(this).find('td:first').data('id-purchase_order_details'),
                product_id: $(this).find('td:first').text(),
                brand_id: $(this).find('td:nth-child(3)').data('brand-id'),
                product_name: $(this).find('td:nth-child(2)').text(),
                brand_name: $(this).find('td:nth-child(3)').text(),
                product_qty: parseInt($(this).find('.quantity').val()) || 0,
                product_purchase_price: parseFloat($(this).find('.price').val()) || 0,
                unit_discount: parseFloat($(this).find('.discount').val()) || 0
            };
            purchaseOrderData.items.push(item);
        });

       // console.log(purchaseOrderData);
        document.getElementById('savePurchaseOrderButton').disabled = true;
        document.getElementById('savePurchaseOrderSpinner').classList.remove('d-none');

        fetch('{{ route("purchase.save_purchase_order") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
            },
            body: JSON.stringify(purchaseOrderData),
        })
        .then(response => response.json())
        .then(data => {
            document.getElementById('savePurchaseOrderButton').disabled = false;
            document.getElementById('savePurchaseOrderSpinner').classList.add('d-none');
            
            if (data.message_type === 'success') {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.message,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: data.message_btn
                    }
                }).then(() => {
                    document.getElementById('savePurchaseOrderButton').disabled = false;
                    document.getElementById('savePurchaseOrderSpinner').classList.add('d-none');
                    
                    // Close modal and refresh table
                    let el = document.getElementById('purchaseOrderEditModal');
                    let modal = bootstrap.Modal.getInstance(el);
                    modal.hide();

                    $('#purchaseOrdersTable').DataTable().ajax.reload();
                    
                });

            } else {
                document.getElementById('savePurchaseOrderButton').disabled = false;
                document.getElementById('savePurchaseOrderSpinner').classList.add('d-none');
                toastr.error(data.message);
            }
        })
        .catch(error => {
            document.getElementById('savePurchaseOrderButton').disabled = false;
            document.getElementById('savePurchaseOrderSpinner').classList.add('d-none');

            toastr.error('An error occurred while saving the purchase order.');
            console.error('Error:', error);
        });
    }

    function remove_purchase_order_item(button) {
        $(button).closest('tr').remove();
        recalculate_totals();
    }

    function cancelPurchaseOrder() {
        let purchase_order_id = $('#id_purchase_order').val();
        if (!purchase_order_id) {
            toastr.error('No purchase order to cancel.');
            return;
        }

        Swal.fire({
            title: 'Are you sure?',
            text: "You are about to cancel this purchase order.",
            icon: 'warning',
            showCancelButton: true,            
            confirmButtonText: 'Yes, cancel it!',
            customClass: {
                confirmButton: 'btn btn-danger',
                cancelButton: 'btn btn-secondary ms-2'
            },
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('{{ url("purchase/cancel_purchase_order") }}/' + purchase_order_id, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.message_type === 'success') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Cancelled',
                            text: data.message,
                            confirmButtonText: 'OK',
                            customClass: {
                                confirmButton: data.message_btn
                            }
                        }).then(() => {
                            // Close modal and refresh table
                            let el = document.getElementById('purchaseOrderEditModal');
                            let modal = bootstrap.Modal.getInstance(el);
                            modal.hide();

                            $('#purchaseOrdersTable').DataTable().ajax.reload();
                        });
                    } else {
                        toastr.error(data.message);
                    }
                })
                .catch(error => {
                    toastr.error('An error occurred while cancelling the purchase order.');
                    console.error('Error:', error);
                });
            }
        });
    }

</script>
@endsection