@extends('layouts.horizontal', ['title' => 'New Return Note', 'topbarTitle' => 'Purchases', 'nonav' => true])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])

@endsection

@section('content')

@can('return_GRN-Purchase_Orders')



<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$grn->business_logo }}" alt="{{ $grn->business_name }}">
                    </div>  
                    <h5 class="card-title">New Goods Return Note Against {{ $grn->grn_number }} for Purchase Order #{{ $grn->purchase_order_number }}</h5>
                        
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-10">

                        </div>
                        <div class="col-md-2">
                            <label for="return_date" class="form-label">Return Date</label>
                            <input type="date" class="form-control mb-2" id="return_date" name="grn_date" value="{{ date('Y-m-d') }}" required>
                        </div>
                    </div>
                   
                    <form id="returnNoteForm">
                        @csrf
                        <input type="hidden" name="idgrn" value="{{ $grn->idgrn }}">
                        <div class="table-responsive">
                            <table id="returnNoteTable" class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Product</th>
                                        <th>Batch</th>
                                        <th class="text-info">Received Quantity</th>
                                        <th class="text-danger">Already Returned Quantity</th>
                                        <th class="text-success">Balance</th>
                                        <th>Return Quantity</th>
                                        <th>Unit Price ({{ config('constants.CURRENCY') }})</th>
                                        <th>Total ({{ config('constants.CURRENCY') }})</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($grn_items as $item)
                                    <tr>
                                        <td>{{ $item->grn_detail_id }}</td>
                                        <td data-product-id="{{ $item->grn_product_id }}">{{ $item->grn_product_name }}</td>
                                        <td>
                                            <input type="hidden" name="batch_id" value="{{ $item->grn_batch_id }}">
                                            {{ $item->grn_batch_number }}
                                        </td>
                                        <td class="text-info">{{$item->grn_qty_received ?? 0 }}</td>
                                        <td class="text-danger">{{$item->total_returned_qty ?? 0 }}</td>
                                        <td class="text-success"><span id="received_{{ $item->grn_detail_id }}">{{ $item->grn_qty_received - $item->total_returned_qty }}</span></td>
                                        <td>
                                            <input type="number" class="form-control " name="return_quantity_{{ $item->grn_detail_id }}" max="{{ $item->grn_qty_received -  $item->total_returned_qty }}" min="0" value="0" required>
                                        </td>
                                        <td class="unit_price" data-unit-price="{{ $item->grn_unit_price - $item->grn_unit_discount }}">{{ config('constants.CURRENCY') }}{{ number_format($item->grn_unit_price - $item->grn_unit_discount, 2) }}</td>
                                        <td>{{ config('constants.CURRENCY') }}<span id="total_{{ $item->grn_detail_id }}">0.00</span></td>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="8" class="text-start">Grand Total</th>
                                        <th>{{ config('constants.CURRENCY') }}<span id="grand_total">0.00</span></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="d-flex justify-content-end gap-1">
                            <a href="{{ route("purchase.open_purchase_order", ["idpurchase_order" => $grn->purchase_order_id]) }}" class="btn btn-success " data-bs-toggle="tooltip" title="PO Detail">
                             Go back to purchase order detail          
                             </a>
                            <button type="submit" id="createReturnNoteButton" class="btn btn-primary">Create Return Note</button>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@else
    <h1>{{ config('permission.not_allowed') }}</h1>
@endcan
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {

        const returnNoteForm = document.getElementById('returnNoteForm');
        const grandTotalElement = document.getElementById('grand_total');

        function updateTotals() {
            let grandTotal = 0;

            @foreach($grn_items as $item)
                var returnQuantityInput{{ $item->grn_detail_id }} =
                    returnNoteForm.querySelector('input[name="return_quantity_{{ $item->grn_detail_id }}"]');

                if (!returnQuantityInput{{ $item->grn_detail_id }}) return;

                var receivedQuantity{{ $item->grn_detail_id }} =
                    parseFloat(document.getElementById('received_{{ $item->grn_detail_id }}')?.textContent) || 0;

                var qty = parseFloat(returnQuantityInput{{ $item->grn_detail_id }}.value) || 0;

                if (qty > receivedQuantity{{ $item->grn_detail_id }} || qty < 0) {
                    qty = receivedQuantity{{ $item->grn_detail_id }};
                    returnQuantityInput{{ $item->grn_detail_id }}.value = qty;
                }

                var totalElement{{ $item->grn_detail_id }} =
                    document.getElementById('total_{{ $item->grn_detail_id }}');

                var unitPrice{{ $item->grn_detail_id }} = {{ $item->grn_unit_price - $item->grn_unit_discount }};

                var total = qty * unitPrice{{ $item->grn_detail_id }};

                totalElement{{ $item->grn_detail_id }}.textContent = total.toFixed(2);
                grandTotal += total;
            @endforeach

            grandTotalElement.textContent = grandTotal.toFixed(2);
        }

        returnNoteForm.addEventListener('input', updateTotals);
        updateTotals();
    });

    $('#returnNoteForm').on('submit', function(e) {
        e.preventDefault();
        $('#createReturnNoteButton').prop('disabled', true).text('Creating...');

        //get data from table
        let items = [];
        $('#returnNoteTable tbody tr').each(function() {
            let id_grn_details = $(this).find('td:eq(0)').text();
            let product_id = $(this).find('td:eq(1)').data('product-id');
            let return_qty = $(this).find('input[name^="return_quantity"]').val();
            let batch_id = $(this).find('input[name^="batch_id"]').val();
            let unit_price = parseFloat($(this).find('.unit_price').data('unit-price'));

            if (return_qty && return_qty > 0) {
                items.push({
                    id_grn_details: id_grn_details,
                    product_id: product_id,
                    return_qty: return_qty,
                    batch_id: batch_id,
                    unit_price: unit_price
                });
            }
        });

        $.ajax({
            type: 'POST',
            url: '{{ route("purchase.save_return_note") }}',
            data: {
                _token: '{{ csrf_token() }}',
                idgrn: '{{ $idgrn }}',
                return_date : $('#return_date').val(),
                items: JSON.stringify(items)
            },
            success: function(response) {
                 $('#createReturnNoteButton').prop('disabled', false).text('Creating Return Note');
                if(response.success){
                    toastr.success('Return Note created successfully!');
                    setTimeout(() => {
                        window.location.href = response.po_detail_url;
                    }, 200);

                }else{
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                toastr.error('An error occurred while creating the Return Note.');
                $('#createReturnNoteButton').prop('disabled', false).text('Create Return Note');
            }
        });
    });
</script>
@endsection