@extends('layouts.horizontal', ['title' => 'Goods Return Note', 'topbarTitle' => 'Purchases', 'nonav' => true])

@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <div class="overflow-hidden position-relative d-flex align-items-center justify-content-start px-2" style="height: 72px;">
                        <img id="logo" style="height: 72px;" src="{{ asset('images').'/business/'.$return_note[0]->business_logo }}" alt="{{ $return_note[0]->business_name }}">
                    </div>  
                    <h4 class="card-title">GRN #: {{ $return_note[0]->grn_number }}</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-0">
                        <div class="mb-0 col-md-4">
                            <table class="table table-borderless fs-13 table-sm">
                                <tr>
                                    <td><span class="fw-bold">Supplier:</span></td>
                                    <td><span class="fw-bold">{{ $return_note[0]->supplier_name }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Contact Person:</span></td>
                                    <td><span class="fw-bold">{{ $return_note[0]->contact_person }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Email:</span></td>
                                    <td><span class="fw-bold">{{ $return_note[0]->email }}</span></td>
                                </tr>
                                <tr>
                                    <td><span class="fw-bold">Phone:</span></td>
                                    <td><span class="fw-bold">{{ $return_note[0]->contact_number }}</span></td>
                                <tr>
                                    <td><span class="fw-bold">Address:</span></td>
                                    <td><span class="fw-bold">{{ $return_note[0]->ho_address }}</span></td>
                                </tr>
                                
                            </table>
                        </div>
                        <div class="mb-0 col-md-4"> </div>
                        <div class="mb-0 col-md-4 text-end">
                            <p for="return_note_id" class="form-label">Return Notes: @php foreach($return_note as $note) { echo $note->id_return_notes . ', '; } @endphp</p>
                            
                            <label for="grn_date" class="form-label">Date: {{ $return_note[0]->formatted_return_date }}</label>                            
                           
                        </div>
                    </div>
                    <div class="mt-0">
                            <h5>Return Note Items</h5>
                            <table class="table table-sm table-bordered fs-13">
                                <thead>
                                    <tr>
                                        <th>Brand</th>
                                        <th>Product</th>
                                        <th>SKU</th>
                                        <th class="text-end">Unit Price</th>                                        
                                        <th>Returned Qty</th>                                    
                                        <th>Cost</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $total_cost = 0; @endphp
                                    @foreach($return_note as $item)
                                    @php 
                                        $item_cost = $item->unit_price * $item->return_qty;
                                        $total_cost += $item_cost;
                                    @endphp
                                    <tr>
                                        <td>{{ $item->brand_name }}</td>
                                        <td>{{ $item->product_name }}</td>
                                        <td>{{ $item->product_sku }}</td>
                                        <td class="text-end">{{ config('constants.CURRENCY') }}{{ number_format($item->unit_price, 2) }}</td>                                        
                                        <td>{{ $item->return_qty }}</td>                                    
                                        <td>{{ config('constants.CURRENCY') }}{{ number_format($item_cost, 2) }}</td>
                                    </tr>
                                    @endforeach 
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="5" class="text-end">Total Return Value</th>
                                        <th>{{ config('constants.CURRENCY') }}{{ number_format($total_cost, 2) }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                </div>
                <div class="card-footer text-end d-print-none">
                    <button type="button"  form="new_grn_form" class="btn btn-ghost-primary btn-icon" onclick="window.print()">
                        <iconify-icon icon="cil:print" width="30"></iconify-icon>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection