@extends('layouts.horizontal', ['title' => 'Stock Status', 'topbarTitle' => 'Stock Status'])

@section('css')
@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',])
@endsection

@section('content')

<style>
     tr.strike-through > td {text-decoration:line-through !important; color:red;} 
</style>
<div class="Stock-Status-page">
     <div class="container-fluid">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Store Stock Status</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="row ">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="mb-3 d-flex align-items-center justify-content-between">
                        <h5 class="card-title mb-0 fw-bold">Filter Products</h5>
                        <button type="button" class="btn btn-sm btn-outline-success" data-bs-toggle="modal" data-bs-target="#productEditModal">
                            <iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon>
                            Product</button>
                    </div>
                    <form id="filterform" method="GET" action="{{ route('store_stock_data') }}">
                        <div class="row gap-1">   
                            @if(session("ho") == "Yes")       
                            <div class="col-md-3">
                                <label class="form-label" for="business_type">Select  Branch Type</label>
                                <select id="business_type" name="business_type_id" class="form-select">  
                                    <option value="">-- All Business Types --</option>                                  
                                    @foreach($business_types as $type)
                                        <option value="{{ $type->id_business_type }}" @if($type->id_business_type == $business_type_id) selected @endif>{{ $type->business_type }}</option>
                                    @endforeach
                                </select>
                            </div>                           
                            @endif
                            <div class="col-md-3">
                                <label class="form-label" for="branch_id">Select  Branch</label>
                                <select id="branch_id" name="business_id" class="form-select">  
                                    @if(session("ho") == "Yes")
                                    <option value="">-- All Branches --</option>                                  
                                    @endif
                                    @foreach($branches as $branch)
                                        <option value="{{ $branch->id_business }}" @if($branch->id_business == $business_id) selected @endif>{{ $branch->business_name }}</option>
                                    @endforeach
                                </select>
                            </div>                           
                            
                            <div class="col-md-3">
                                <button type="submit" class="btn btn-ghost-dark btn-icon rounded-circle p-2 mt-3">
                                    <iconify-icon icon="mdi:magnify" width="30"></iconify-icon>
                                    
                                </button>
                            </div>                           
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div> <!-- end row-->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="storeStockDataTable" class="table table-bordered dt-responsive w-100 fs-12">
                        <thead>
                            <tr>
                                @if(isset($data[0]))
                                    @foreach(array_keys((array) $data[0]) as $column)
                                        <th>{{ ucfirst(str_replace('_', ' ', $column)) }}</th>
                                    @endforeach
                                @endif
                                <th>Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            @foreach($data as $store)
                                <tr>
                                    @foreach((array) $store as $value)
                                        <td>
                                            @if(is_array($value))
                                                {{ json_encode($value) }}
                                            @else
                                                {{ $value ?? '' }}
                                            @endif
                                        </td>
                                       
                                    @endforeach
                                    <td>
                                        <button data-bs-toggle="modal" data-bs-target="#productEditModal" data-product-id="{{ json_encode($store->ID) }}" data-bs-tooltip title="Edit" class="btn btn-sm btn-ghost-info rounded-circle flex-shrink-0 btn-icon view-store-stock-data">
                                            <iconify-icon icon="line-md:pencil" style= "cursor:pointer;" class="fs-18"></iconify-icon>
                                        </button>
                                        <a href="{{ route('products.batches', ['id_business_products' => json_encode($store->ID)]) }}" target="_batches" data-bs-tooltip title="Product Batches" class="btn btn-sm btn-ghost-success rounded-circle flex-shrink-0 btn-icon product-batch">
                                            <iconify-icon icon="carbon:classic-batch" style= "cursor:pointer;" class="fs-18"></iconify-icon>
                                        </a>   
                                        <a href="" data-bs-tooltip title="Transfer Stock" data-bs-toggle="modal" data-bs-target="#transferStockModal" data-dt-remaining="{{ 0 }}" data-dt-productID="{{ json_encode($store->ID) }}" data-dt-productname = "{{ json_encode($store->Product) ?? '' }}" data-dt-batchID="" data-dt-storeFrom="" class="btn btn-sm btn-ghost-dark rounded-circle flex-shrink-0 btn-icon transfer-product">
                                            <iconify-icon icon="bitcoin-icons:transfer-outline" style= "cursor:pointer;" class="fs-20"></iconify-icon>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach                            
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@include('modals.product_edit')
@include('modals.transfer_note')

@endsection

@section('scripts')
@vite(['resources/js/modals/product_edit.js', 'resources/js/modals/transfer_note.js'])
<script>
    let baseURL = '{{ url("") }}'; // Use relative paths
    $(document).ready(function() {

        //initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-tooltip=""]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });

        $('#storeStockDataTable').DataTable({
            scrollX:true,
            scrollY: 550,
            scrollCollapse: true,
            lengthChange: true,
            stateSave: true,
            responsive: false,
            autoWidth: false,
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
            buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            
        });
    });

    function productEditModal(productID) {

        document.getElementById('productID').value = productID;
        
        var productEditModal = new bootstrap.Modal(document.getElementById('productEditModal'), {
            keyboard: false
        });
        productEditModal.show();
    }

   

</script>
@endsection