@extends('layouts.horizontal', ['title' => 'Batch Transfers', 'topbarTitle' => 'Batch Transfers'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
<style>
    td.border-top-1 {
        border-top: 2px solid #000 !important;
    }
</style>
@endsection

@section('content')
    <div class="row mb-2">
        <div class="card">
            <div class="col-12">
                <div class="card-body">
                    <div class="card-title mb-2">
                        <h4>Batch Transfer</h4>
                    </div>
                    <div class="row g-3 mb-3">                        
                        <div class="col-md-3">
                            <label for="from_store" class="form-label">From Store</label>
                            <select id="from_store" name="from_store" class="form-select">
                                @foreach($stores as $store)
                                    <option value="{{ $store->id_business_stores }}">{{ $store->business_store }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-1">
                            <label for="to" class="form-label">&nbsp;</label>
                            <span class="form-control-plaintext text-center fs-20">→</span>
                        </div>
                        <div class="col-md-3">
                            <label for="to_store" class="form-label">To Store</label>
                            <select id="to_store" name="to_store" class="form-select">
                                @php $stores = $stores->sortByDesc('id_business_stores'); @endphp
                                @foreach($stores as $store)
                                    <option value="{{ $store->id_business_stores }}">{{ $store->business_store }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label for="product_select" class="form-label">Product</label>
                            <select id="product_select" name="product_select" class="form-select">
                                <option value="">Select Product</option>
                                <!-- Options will be populated dynamically -->
                            </select>
                        </div>
                        <div class="col-md-1 d-flex align-items-end">
                            <button id="add_to_batch" class="btn btn-ghost-success btn-icon rounded-circle p-3 mt-3" title="Add for transfer">
                                <iconify-icon icon="lets-icons:size-down" width="30px" class=""></iconify-icon>
                            </button>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered fs-13 table-sm" id="batch_transfers_table">
                            <thead>
                                <tr>
                                    <th>From Store</th>
                                    <th>To Store</th>
                                    <th>Product ID</th>
                                    <th>Product Name</th>
                                    <th>Batch ID</th>
                                    <th>Transfer Qty.</th>                                    
                                    <th>Action</th>                             
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be populated dynamically -->
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer text-end">
                    <button class="btn btn-primary btn-sm" id="create_transfer_notes_button">
                        <iconify-icon icon="mdi:content-save" width="20px" class="me-1"></iconify-icon>
                        Create Transfer Notes
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

<script>
    $(document).ready(function() {
        // initialize Select2 for product selection
        
        $("#product_select").select2({
            width: '100%',
            dropdownParent: $('#product_select').parent(),
            ajax: {
                url: '{{ route("products.search_products_instock") }}',
                dataType: 'json',
                delay: 250,
                data: function (params) {
                    return {
                        q: params.term // search term
                    };
                },
                processResults: function (data) {
                    return {
                        results: data.map(function (item) {
                            return {
                                id: item.id,
                                text: item.business_brand_name + ' ' + item.product + ' ' + (item.mcategory ? ' (Category: ' + item.mcategory + ')' : '') + ' ' + (item.batch_id ? ' Batch: ' + item.batch_id : '')  + ' ' + (item.instock ? ' instock: ' + item.instock : ''),
                                measure_unit: item.measure_unit,
                                qty_per_unit: item.qty_per_unit,
                                product: item.product,
                                brand: item.business_brand_name,
                                price: item.price,
                                batch_id: item.batch_id,
                                instock: item.instock
                            };
                        })
                    };
                },
                cache: true
            },
            minimumInputLength: 3,

            // Formatting should be outside the ajax block
            templateResult: function (item) {
                if (item.loading) return item.text;

                return $(
                    "<div class='d-flex justify-content-between'>" +
                        "<div class='col-md-6 d-flex justify-content-between'>" + item.text + "</div>" +
                        "<div class='col-md-6 me-auto text-end text-muted' style='font-size: 0.8em;'>" + (item.qty_per_unit ? item.qty_per_unit : '') + ' ' + (item.measure_unit ? item.measure_unit : '') + ' PRICE: ' + (item.price ? parseFloat(item.price).toFixed(2) : '0.00') + "</div>" +
                    "</div>"
                );
            },

            templateSelection: function (item) {
                return item.text || item.id;
            },

            escapeMarkup: function (markup) {
                return markup;
            }
        });

        // Add to batch transfers table
        $('#add_to_batch').on('click', function() {
            var fromStore = $('#from_store').val();
            var fromStoreText = $('#from_store option:selected').text();
            var toStore = $('#to_store').val();
            var toStoreText = $('#to_store option:selected').text();
            var productData = $('#product_select').select2('data')[0];
            console.log(productData);
            if (!productData) {
                alert('Please select a product.');
                return;
            }

            var newRow = `
                <tr>
                    <td data-from-store=${fromStore}>${fromStoreText}</td>
                    <td data-to-store=${toStore}>${toStoreText}</td>
                    <td>${productData.id}</td>
                    <td>${productData.product}</td>
                    <td>${productData.batch_id || 'N/A'}</td>
                    <td><input type="number" class="form-control form-control-sm" min="1" value="${productData.instock || 1}"></td>                    
                    <td><button class="btn btn-danger btn-sm remove-row">Remove</button></td>
                </tr>
            `;

            $('#batch_transfers_table tbody').append(newRow);
        });

        // Remove row from batch transfers table
        $('#batch_transfers_table').on('click', '.remove-row', function() {
            $(this).closest('tr').remove();
        });

        // Create transfer notes
        $('#create_transfer_notes_button').on('click', function() {
            var transfers = [];
            $('#batch_transfers_table tbody tr').each(function() {
                var fromStore = $(this).find('td:eq(0)').data('from-store');
                var toStore = $(this).find('td:eq(1)').data('to-store');
                var productId = $(this).find('td:eq(2)').text();
                var batchId = $(this).find('td:eq(4)').text();
                var transferQty = $(this).find('td:eq(5) input').val();

                transfers.push({
                    from_store: fromStore,
                    to_store: toStore,
                    product_id: productId,
                    batch_id: batchId,
                    transfer_qty: transferQty
                });
            });

            if(transfers.length === 0) {
                toastr.error('No transfers requests added to the table yet!');
                return;
            }
            //console.log(transfers);


            $.ajax({
                url: '{{ route("products.multiple_product_batch_transfer_notes") }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    transfers: transfers
                },
                success: function(response) {
                    if(response.success) {
                        toastr.success('Transfer Notes created successfully!');
                        // Clear the table
                        $('#batch_transfers_table tbody').empty();

                        window.location.href = '{{ route("transfer_notes.transfer_notes") }}';
                    } else {
                        toastr.error('Error creating Transfer Notes: ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    toastr.error('An error occurred while creating Transfer Notes.');
                }
            });

        });

    });

</script>


@endsection