@extends('layouts.horizontal', ['title' => 'Transfer Notes', 'topbarTitle' => 'Transfer Notes'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
<style>
    td.border-top-1 {
        border-top: 2px solid #000 !important;
    }
</style>
@endsection

@section('content')
    <div class="row mb-2">
        <div class="card">
            <div class="col-12">
                <div class="card-body">
                    <div class="card-title mb-2">
                        <h4>Transfer Notes</h4>
                    </div>
                    <div class="row g-3 align-items-center mb-2">                        
                        <div class="col-md-3">
                            <label for="start_date" class="form-label">Start Date</label>
                            <input type="date" id="start_date" name="start_date" class="form-control">
                        </div>
                        <div class="col-md-3">
                            <label for="end_date" class="form-label">End Date</label>
                            <input type="date" id="end_date" name="end_date" class="form-control">
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <button id="filter_button" class="btn btn-ghost-primary btn-icon rounded-circle p-3 mt-3">
                                <iconify-icon icon="mdi:magnify" width="30px"></iconify-icon>
                            </button>
                        </div>
                        <div class="col-md-3 d-flex align-items-end justify-content-end">
                            <a href="{{ route('transfer_notes.batch_transfers') }}" class="btn btn-outline-success btn-sm">Create Batch Transfers</a>
                        </div>
                    </div>
                    <div class="row g-3 mb-2">
                        <div class="col-md-12">
                            <label class="form-label">Additional Columns</label>
                            <ul class="list-group">
                                @can('view_tn_unit_price')
                                <li class="list-group-item">
                                    <input class="form-check-input me-1" type="checkbox" name="additional_columns[]" value="unit_price" id="unit_price_checkbox">
                                    <label class="form-check-label" for="unit_price_checkbox">Unit Price</label>
                                </li>
                                @endcan
                                @can('view_tn_amount')
                                <li class="list-group-item">
                                    <input class="form-check-input me-1" type="checkbox" name="additional_columns[]" value="amount" id="amount_checkbox">
                                    <label class="form-check-label" for="amount_checkbox">Amount</label>
                                </li>
                                @endcan
                            </ul>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-bordered fs-13 table-sm" id="transfer_notes_table">
                            <thead>
                                <tr>
                                    <th>GTN #</th>
                                    <th>Transfer Note #</th>
                                    <th>Date</th>
                                    <th>From Store</th>
                                    <th>To Store</th>
                                    <th>Brand</th>
                                    <th>Product ID</th>
                                    <th>Product</th>   
                                    <th>Requisition ID</th>    
                                    <th>Transfer Out Qty</th>                             
                                    <th>Transfer In Qty</th>
                                    @can('view_tn_unit_price')
                                    <th class="unit_price_col">Unit Price</th>
                                    @endcan
                                    @can('view_tn_amount')
                                    <th class="amount_col">Amount</th>
                                    @endcan
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Data will be populated by DataTables -->
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')

<script>
    $(document).ready(function() {

        let last_gtn_id = null;
        
        // Build columns array - include conditional columns
        var columns = [
            { data: 'id_gtn', name: 'id_gtn' },
            { data: 'id_transfer_notes', name: 'id_transfer_notes' },
            { data: 'created_at', name: 'created_at' },
            { data: null, name: 'from_store',
                render: function(data, type, row) {
                    if(row.tranfer_out_qty > 0){
                        return row.business_store + ' ' + '(' + row.batch + ')';
                    } else {
                        return '';
                    }
                }
             },
            { data: null, name: 'to_store' ,
                render: function(data, type, row) {
                    if(row.tranfer_in_qty > 0){
                        return row.business_store + ' ' + '(' + row.batch + ')';
                    } else {
                        return '';
                    }
                }
            },
            { data: 'brand_name', name: 'brand_name' },                
            { data: 'product_id', name: 'product_id' },
            { data: 'product', name: 'product' },             
            { data: 'requisition_id', name: 'requisition_id' },             
            { data: 'tranfer_out_qty', name: 'tranfer_out_qty', searchable: false }, 
            { data: 'tranfer_in_qty', name: 'tranfer_in_qty', searchable: false },
        ];

        // Track column indices for conditional columns
        var unitPriceColIndex = -1;
        var amountColIndex = -1;

        // Add conditional columns if user has permissions (they'll be hidden by default)
        @can('view_tn_unit_price')
        unitPriceColIndex = columns.length;
        columns.push({ 
            data: 'unit_price', 
            name: 'unit_price', 
            searchable: false,
            visible: false,
            className: 'unit_price_col',
            render: function(data, type, row) {
                return data ? parseFloat(data).toFixed(2) : '0.00';
            }
        });
        @endcan

        @can('view_tn_amount')
        amountColIndex = columns.length;
        columns.push({ 
            data: 'amount', 
            name: 'amount', 
            searchable: false,
            visible: false,
            className: 'amount_col',
            render: function(data, type, row) {
                return data ? parseFloat(data).toFixed(2) : '0.00';
            }
        });
        @endcan

        var table = $('#transfer_notes_table').DataTable({
            processing: true,
            serverSide: true,
            responsive: false,
            
            ajax: {
                url: '{{ route("transfer_notes.get_transfer_notes_data") }}',
                data: function (d) {
                    d.store_id = $('#store_filter').val();
                    d.start_date = $('#start_date').val();
                    d.end_date = $('#end_date').val();
                    var selectedColumns = [];
                    $('input[name="additional_columns[]"]:checked').each(function() {
                        selectedColumns.push($(this).val());
                    });
                    d.additional_columns = selectedColumns;
                }
            },           
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
             buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
            columns: columns,
            rowCallback: function(row, data) {
                // if GTN ID changes, add a class or style to differentiate
                if (data.id_gtn !== last_gtn_id) {
                    $(row).find('td').addClass('border-top-1');
                    last_gtn_id = data.id_gtn;
                }   
            }
        });

        // Function to update column visibility based on checkbox selection
        function updateColumnVisibility() {
            var showUnitPrice = $('#unit_price_checkbox').is(':checked');
            var showAmount = $('#amount_checkbox').is(':checked');
            
            @can('view_tn_unit_price')
            if (unitPriceColIndex !== -1) {
                table.column(unitPriceColIndex).visible(showUnitPrice);
            }
            @endcan

            @can('view_tn_amount')
            if (amountColIndex !== -1) {
                table.column(amountColIndex).visible(showAmount);
            }
            @endcan
        }

        $('#filter_button').on('click', function() {
            updateColumnVisibility();
            table.ajax.reload();
        });

        // Listen for checkbox changes
        $('input[name="additional_columns[]"]').on('change', function() {
            updateColumnVisibility();
            table.ajax.reload();
        });
    });
</script>
@endsection