@extends('layouts.horizontal', ['title' => 'MIS Reporting', 'topbarTitle' => 'Reports', 'nonav' => true])

@section('css')
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
<style>

    .page-container {
        max-width: 98% !important;
        margin: 0 auto;
    }

     tr.strike-through > td {text-decoration:line-through !important; color:red;} 

</style>
@endsection
@section('content')

<div class="reportpage container-fullwidth">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title">{{ $reportName }}</h4>
                </div>
                <div class="card-body">
                    <div class="row mb-1">
                        <div class="col-md-3">
                            <p class="mb-1">Date Range: <span id="dateRangeLabel">{{ \Carbon\Carbon::parse($start_date)->format('d/m/Y') }} to {{ \Carbon\Carbon::parse($end_date)->format('d/m/Y') }}</span></p>
                            <input class="form-control" id="dateRange" type="text" value="{{ \Carbon\Carbon::parse($start_date)->format('d-m-Y') }} - {{ \Carbon\Carbon::parse($end_date)->format('d-m-Y') }}" />
                        </div>
                        @if(session("ho")=="Yes")
                        <div class="col-md-2">
                            <p class="mb-1">Branch Sector</p>
                            <select onchange="businessTypeChanged()" class="form-select" id="business_type_id" name="business_type_id">
                                <option value="" selected>Branch Sector</option>
                                @foreach($business_types as $branch_type)
                                    <option value="{{ $branch_type->id_business_type }}">{{ $branch_type->business_type }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <p class="mb-1">Branch</p>
                            <select class="form-select" id="branchSelect">
                                <option value="" selected>All Branches</option>
                                @foreach($branches as $branch)
                                    <option value="{{ $branch->id_business }}">{{ $branch->business_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        @else
                        <input type="hidden" id="business_type_id" value="{{ $business_id }}">
                        <input type="hidden" id="branchSelect" value="{{ $business_id }}">
                        @endif

                        @if($reportID == 39)
                        <div class="col-md-2" >
                            <p class="mb-1">Stores</p>
                            <select class="form-select" id="store_id">
                            </select>
                        </div>
                        @endif

                        @if($reportID == 17 || $reportID == 16)
                            <div class="col-md-2 mb-2">
                                <p class="mb-1">Service Type</p>
                                <select class="form-select select2" id="service_type">
                                    <option value="0" selected>All Service Types</option>
                                    @foreach($service_types as $type)
                                        <option value="{{ $type->id_service_types }}">{{ $type->service_type }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-3">
                                <p class="mb-1">Service Category</p>
                                <select class="form-select select2" id="service_category">
                                    <option value="0" selected>All Service Categories</option>
                                    @foreach($service_categories as $category)
                                        <option value="{{ $category->id_service_category }}">{{ $category->service_type }} . . . {{ $category->service_category }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-3 ">
                                <p class="mb-1">Service Dept.</p>
                                <select class="form-select select2" id="service_department">
                                    <option value="0" selected>All Service Depts.</option>
                                    @foreach($service_departments as $department)
                                        <option value="{{ $department->service_department }}">{{ $department->service_department }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endif
                        @if($reportID == 20)
                            <div class="col-md-3 ">
                                <p class="mb-1">Invoice Type.</p>
                                <select class="form-select select2" id="invoice_type">
                                    <option selected="selected" value="0" selected>Both.</option>
                                    <option value="service" >Services.</option>
                                    <option value="sale" >Retail.</option>                            
                                </select>
                            </div>
                        @endif
                        @if($reportID == 22)
                            <div class="col-md-3 ">
                                <p class="mb-1">Visit Status.</p>
                                <select class="form-select select2" id="visit_status">
                                    <option selected="selected" value="open" selected>Open Visits.</option>
                                    <option value="invoiced" >Invoiced Visits.</option>
                                    <option value="canceled" >Cancelled Visits.</option>
                                    <option value="0" >All Visits.</option>                                   
                                </select>
                            </div>
                        @endif
                            <div class="col-md-2">
                                <p class="mb-1 text-white">Run</p>
                                <button id="runReportButton" class="btn btn-primary mb-3 " onclick="runReport({{ $reportID }})">
                                    <span class="spinner-border spinner-border-sm me-2 d-none" role="status" aria-hidden="true"></span>
                                    <span class="visually-hidden">Loading . . .</span> Run Report
                                </button>
                            </div>
                        </div>
                    
                  
                    <div class="table-responsive">
                        <table id="reportTable" class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12">
                            <thead>
                                <tr>
                                   @if(isset($data[0]))
                                    @foreach(array_keys((array) $data[0]) as $column)
                                        <th>{{ ucfirst(str_replace('_', ' ', $column)) }}</th>
                                    @endforeach
                                @endif
                                </tr>
                            </thead>
                            <tbody>
                                 @foreach($data as $store)
                                <tr>
                                    @foreach((array) $store as $value)
                                        <td>
                                            @if(is_array($value))
                                                {!! json_encode($value) !!}
                                            @else
                                                {!! $value ?? '' !!}
                                            @endif
                                        </td>
                                       
                                    @endforeach
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<!-- Required for PDF export -->
<script>
    document.addEventListener("DOMContentLoaded", function() {
        get_branch_store();
        $("#branchSelect").change(function() {
            get_branch_store();
        });

        //intiialize select2
        $('#service_type').select2({
            width: '100%'
        });
        $('#service_category').select2({
            width: '100%'
        });

        // Initialize DataTable if $permission_type is set
        @if(isset($permission_type))

            let table = $('#reportTable').DataTable({
                paging: true,
                searching: true,
                info: true,
                "layout": {
                    topStart: "buttons",
                    topEnd: "search",
                    bottomStart: {                 // page length selector
                        pageLength: {
                            menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                        },
                        info: {}
                    },                
                    bottomEnd: "paging"       // pagination
                },
                buttons: [
                    @if($permission_type == 'Any')
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                    @elseif($permission_type == 'Export CSV')
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    @elseif($permission_type == 'Export PDF')
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                    @endif
                ],
                @if($permission_type == 'Any' || $permission_type == 'Export CSV')
                    drawCallback: function(settings) {
                        var api = this.api();
                        var baseURL = '{{ url("") }}'; // Use relative paths

                        api.columns().every(function() {
                            var column = this;
                            var header = $(column.header()).text().toLowerCase();
                            console.log("Header:", header);
                            if (header.includes('grn id')) {
                                column.nodes().to$().each(function(index, cell) {
                                    var cellText = $(cell).text().trim();
                                    if (cellText) {
                                        $(cell).html(
                                            `<a target="_blank" href="${baseURL}/purchase/print_grn/${cellText}">${cellText}</a>`
                                        );
                                    }
                                });
                            } else if(header.includes('customer id')) {
                                column.nodes().to$().each(function(index, cell) {
                                    var cellText = $(cell).text().trim();
                                    if (cellText) {
                                        $(cell).html(
                                            `<a target="_blank" href="{{ url('open_customer_account') }}/${cellText}">${cellText}</a>`
                                        );
                                    }
                                });
                            }
                        });
                    },
                @endif
            });
            
        @else
            $('#reportTable').DataTable({
                paging: false,
                searching: false,
                info: false
            });
        @endif

        // Initialize Date Range Picker
        flatpickr("#dateRange", {
            mode: "range",
            dateFormat: "Y-m-d",
            // minDate: "today",
            // maxDate: new Date().fp_incr(30) // 30 days from today
            defaultDate: ["{{ $start_date }}", "{{ $end_date }}"]
        });
    });

    function runReport(reportId) {
        console.log("Running report with ID:", reportId);
        document.getElementById('runReportButton').disabled = true;
        document.querySelector("#runReportButton .spinner-border").classList.remove("d-none");
        // You can add your AJAX call or form submission logic here
        // Example AJAX call using Fetch API
         const params = new URLSearchParams({
            start_date: document.getElementById('dateRange').value.split(' to ')[0],
            end_date: document.getElementById('dateRange').value.split(' to ')[1],
            datareport: true,
            business_id: document.getElementById('branchSelect').value,
            business_type_id: document.getElementById('business_type_id').value,
            store_id: document.getElementById('store_id') ? document.getElementById('store_id').value : '',
            service_type: document.getElementById('service_type') ? document.getElementById('service_type').value : '',
            service_category: document.getElementById('service_category') ? document.getElementById('service_category').value : '',
            service_department: document.getElementById('service_department') ? document.getElementById('service_department').value : '',
            visit_status: document.getElementById('visit_status') ? document.getElementById('visit_status').value : '',
            invoice_type: document.getElementById('invoice_type') ? document.getElementById('invoice_type').value : '',
        });

        const url = `{{ route('reports.run', ['id' => ':id']) }}`.replace(':id', reportId)  + '?' + params.toString();
       
        fetch(url, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
        })
        .then(response => response.json())
        .then(data => {
            //put data in table or handle response
            //console.log("Report data:", data);
            let permission_type = data.permission_type;
             // reinitialize DataTable if necessary
            if ($.fn.DataTable.isDataTable('#reportTable')) {
                $('#reportTable').DataTable().destroy();
            }
            document.getElementById('runReportButton').disabled = false;
            document.querySelector("#runReportButton .spinner-border").classList.add("d-none");

            const tableBody = document.querySelector("#reportTable tbody");
            tableBody.innerHTML = ""; // Clear existing table rows
            data = data.data; // assuming the returned data is in data property
            if (data.length > 0) {
                const tableHead = document.querySelector("#reportTable thead tr");
                const tableBody = document.querySelector("#reportTable tbody");
                const table = document.querySelector("#reportTable");

                tableHead.innerHTML = "";
                tableBody.innerHTML = "";

                // Create headers
                Object.keys(data[0]).forEach(column => {
                    const th = document.createElement("th");
                    th.textContent = column.charAt(0).toUpperCase() + column.slice(1).replace(/_/g, ' ');
                    tableHead.appendChild(th);
                });

                // Add data rows
                data.forEach(row => {
                    const tr = document.createElement("tr");
                    Object.values(row).forEach(cell => {
                        const td = document.createElement("td");
                        if (typeof cell === 'string' && cell.includes('<br>')) {
                            td.innerHTML = decodeHtml(cell); // render line breaks
                        } else if(typeof cell === 'string' && cell.includes('badge')) {
                            td.innerHTML = decodeHtml(cell); // render line breaks
                        }else {
                            td.textContent = cell; // default safe behavior
                        }
                        tr.appendChild(td);
                    });
                    tableBody.appendChild(tr);
                });

                // Remove old footer if exists
                const oldFooter = table.querySelector("tfoot");
                if (oldFooter) oldFooter.remove();

                // Create footer with totals
                const footer = document.createElement("tfoot");
                const footerRow = document.createElement("tr");
                Object.keys(data[0]).forEach(column => {
                    const td = document.createElement("td");
                    
                    if(column.toLowerCase().includes('amount') || column.toLowerCase().includes('total') || column.toLowerCase().includes('price') || column.toLowerCase().includes('quantity') || column.toLowerCase().includes('stock')  || column.toLowerCase().includes('value') || column.toLowerCase().includes('qty') ) {
                        
                        td.style.fontWeight = 'bold';
                        td.textContent = data.filter(row => String(row.Cancelled).toLowerCase() !== 'yes' && String(row.Removed).toLowerCase() !== 'yes'
                        )
                        .reduce((sum, row) => {
                            const value = parseFloat(row[column]);
                            return !isNaN(value) ? Math.round((sum + value) * 10000) / 10000 : sum;
                        }, 0);
                    
                    } else {
                        td.textContent = '';
                    }
                    footerRow.appendChild(td);
                });
                footer.appendChild(footerRow);
                table.appendChild(footer); // ✅ Append directly to table, not tbody

                //update date range label and format d-m-Y
                const startDate = new Date(document.getElementById('dateRange').value.split(' to ')[0]);
                const endDate = new Date(document.getElementById('dateRange').value.split(' to ')[1]);
                const options = { day: '2-digit', month: '2-digit', year: 'numeric' };
                document.getElementById('dateRangeLabel').textContent = startDate.toLocaleDateString('en-GB', options) + ' to ' + endDate.toLocaleDateString('en-GB', options);

            }

           
            //inistialize datatable again with button depending on permission_type
            if(permission_type=='Any'){
                var table = $('#reportTable').DataTable({
                    paging: true,
                    searching: true,
                    info: true,
                    stateSave: true,
                    "layout": {
                        topStart: "buttons",
                        topEnd: "search",
                        bottomStart: {                 // page length selector
                            pageLength: {
                                menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                            },
                            info: {}
                        },                
                        bottomEnd: "paging"       // pagination
                    },
                    buttons: [
                        { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                        { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                        { extend: "print", className: "btn btn-sm btn-soft-primary" },
                        { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                    ],
                    drawCallback: function(settings) {
                        var api = this.api();
                        var baseURL = '{{ url("") }}'; // Use relative paths

                        api.columns().every(function() {
                            var column = this;
                            var header = $(column.header()).text().toLowerCase();

                            if (header.includes('grn id')) {
                                column.nodes().to$().each(function(index, cell) {
                                    var cellText = $(cell).text().trim();
                                    if (cellText) {
                                        $(cell).html(
                                            `<a target="_blank" href="${baseURL}/purchase/print_grn/${cellText}">${cellText}</a>`
                                        );
                                    }
                                });
                            } else if(header.includes('customer id')) {
                                column.nodes().to$().each(function(index, cell) {
                                    var cellText = $(cell).text().trim();
                                    if (cellText) {
                                        $(cell).html(
                                            `<a target="_blank" href="{{ url('open_customer_account') }}/${cellText}">${cellText}</a>`
                                        );
                                    }
                                });
                            } else if(header.includes('visit id')) {
                                column.nodes().to$().each(function(index, cell) {
                                    var cellText = $(cell).text().trim();
                                    if (cellText) {
                                        $(cell).html(
                                            `<a target="_blank" href="{{ url('open_customer_account') }}/${cellText}">${cellText}</a>`
                                        );
                                    }
                                });
                            }else if(header.includes('product id')) {
                                column.nodes().to$().each(function(index, cell) {
                                    var cellText = $(cell).text().trim();
                                    if (cellText) {
                                        $(cell).html(
                                            `<a target="_blank" href="${baseURL}/products/batches/${cellText}">${cellText}</a>`
                                        );
                                    }
                                });
                            }else if(header.includes('cancelled') || header.includes('removed')) {
                                column.nodes().to$().each(function(index, cell) {
                                    var cellText = $(cell).text().trim();
                                    if (cellText.toLowerCase() ==='yes') {
                                        $(cell).closest('tr').addClass('strike-through');                                       
                                    }
                                });
                            }
                        });
                    }
                });
            }
            else if(permission_type=='Export CSV'){
                var table = $('#reportTable').DataTable({
                    paging: true,
                    searching: true,
                    info: true,
                    stateSave: true,
                    "layout": {
                        topStart: "buttons",
                        topEnd: "search",
                        bottomStart: {                 // page length selector
                            pageLength: {
                                menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                            },
                            info: {}
                        },                
                        bottomEnd: "paging"       // pagination
                    },
                    buttons: [
                        { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                        { extend: "print", className: "btn btn-sm btn-soft-primary" },
                        { extend: "csv",   className: "btn btn-sm btn-soft-primary" }
                    ]
                });
            }
            else if(permission_type=='Export PDF'){
                var table = $('#reportTable').DataTable({
                    paging: true,
                    searching: true,
                    info: true,
                    stateSave: true,
                    "layout": {
                        topStart: "buttons",
                        topEnd: "search",
                        bottomStart: {                 // page length selector
                            pageLength: {
                                menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                            },
                            info: {}
                        },                
                        bottomEnd: "paging"       // pagination
                    },
                    buttons: [
                        { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                        { extend: "print", className: "btn btn-sm btn-soft-primary" },
                        { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                    ]
                });

                
            }
            else{
                var table = $('#reportTable').DataTable({
                    paging: false,
                    searching: false,
                    info: false,
                    stateSave: true,
                })
                
            }

            // Add links if header 
            table.columns().every(function() {
                var column = this;
                var header = $(column.header()).text().toLowerCase();
                console.log("Header:", header);
                var baseURL = '{{ url("") }}'; // Use relative paths
                if (header.includes('grn id')) {
                    column.nodes().to$().each(function(index, cell) {
                        var cellText = $(cell).text();
                        if (cellText) {
                            var link = `<a target="_blank" href="${baseURL}/purchase/print_grn/${cellText}">${cellText}</a>`;
                            $(cell).html(link);
                        }
                    });
                } else if(header.includes('customer id')) {
                    column.nodes().to$().each(function(index, cell) {
                        var cellText = $(cell).text().trim();
                        if (cellText) {
                            $(cell).html(
                                `<a target="_blank" href="{{ url('open_customer_account') }}/${cellText}">${cellText}</a>`
                            );
                        }
                    });
                } 
                // else if(header.includes('visit id')) {
                //     column.nodes().to$().each(function(index, cell) {
                //         var cellText = $(cell).text().trim();
                //         if (cellText) {
                //             $(cell).html(
                //                 `<a target="_blank" href="{{ url('open_customer_account') }}/${cellText}">${cellText}</a>`
                //             );
                //         }
                //     });
                // } 
                else if(header.includes('invoice id')) {
                    column.nodes().to$().each(function(index, cell) {
                        var cellText = $(cell).text().trim();
                        if (cellText) {
                            $(cell).html(
                                `<a target="_blank" href="${baseURL}/existing_retail_invoice/${cellText}">${cellText}</a>`
                            );
                        }
                    });
                } else if(header.includes('batch id')) {
                    column.nodes().to$().each(function(index, cell) {
                        var cellText = $(cell).text().trim();
                        if (cellText) {
                            // Split by comma and trim each ID
                            var ids = cellText.split(',').map(id => id.trim());
                            // Generate links for each ID
                            var links = ids.map(id => 
                                `<a target="_blank" href="${baseURL}/products/product_batch_details/${id}">${id}</a>`
                            );
                            // Join links with commas or spaces
                            $(cell).html(links.join(', '));
                        }
                    });
                }else if (header.includes('voucher id')) {
                        column.nodes().to$().each(function(index, cell) {
                            var cellText = $(cell).text().trim();

                            if (cellText) {
                                // Split by comma and trim each ID
                                var ids = cellText.split(',').map(id => id.trim());

                                // Generate links with query parameter
                                var links = ids.map(id =>
                                    `<a target="_blank" href="${baseURL}/accounts/account_voucher_print?id=${id}">${id}</a>`
                                );
                                // Join links with comma + space
                                $(cell).html(links.join(', '));
                            }
                        });
                }

            });

        })
        .catch(error => {
            document.getElementById('runReportButton').disabled = false;
            document.querySelector("#runReportButton .spinner-border").classList.add("d-none");
            console.error("Error running report:", error);
        });
    }

    function businessTypeChanged() {
        document.getElementById('runReportButton').disabled = true;
        document.querySelector("#runReportButton .spinner-border").classList.remove("d-none");
        const businessTypeId = document.getElementById('business_type_id').value;
        console.log("Selected Business Type ID:", businessTypeId);
        // You can add your AJAX call or logic to update branches based on selected business type
        fetch(`{{ route('business.getBranchesByType') }}?business_type_id=${businessTypeId}`, {
            method: 'GET',
            headers: {
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest',
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
        })
        .then(response => response.json())
        .then(data => {
            document.getElementById('runReportButton').disabled = false;
            document.querySelector("#runReportButton .spinner-border").classList.add("d-none");
           // console.log("Branches:", data);
            // Update your branches dropdown or any other UI element with the fetched data
            const branchSelect = document.getElementById('branchSelect');
            branchSelect.innerHTML = '<option value="" selected>All Branches</option>'; // Clear existing options
            data.forEach(branch => {
                const option = document.createElement('option');
                option.value = branch.id_business;
                option.textContent = branch.business_name;
                branchSelect.appendChild(option);
            });
        })
        .catch(error => {
            document.getElementById('runReportButton').disabled = false;
            document.querySelector("#runReportButton .spinner-border").classList.add("d-none");
            console.error("Error fetching branches:", error);
        });
    }

    function decodeHtml(str) {
        const temp = document.createElement("textarea");
        temp.innerHTML = str;
        return temp.value;
    }

    function get_branch_store() {
        var branch_id = $("#branchSelect").val() || 0;
        $.ajax({
            url: '{{ route("reports.get_branch_store") }}',
            type: 'GET',
            data: { branch_id: branch_id },
            dataType: 'json',
            success: function (response) {
                var $storeSelect = $("#store_id");
                $storeSelect.empty(); 
                if (response.success && response.data.length > 0) {
                    $.each(response.data, function (index, store) {
                        $storeSelect.append(
                            '<option value="' + store.id_business_stores + '">' + store.business_store + '</option>'
                        );
                    });
                    if(branch_id > 0){
                        $storeSelect.append('<option value="0">All Stores</option>');
                    }
                } else {
                    $storeSelect.append('<option value="0">No stores found</option>');
                }
            },
            error: function (err) {
                console.error('Error fetching branch stores', err);
            }
        });
    }
</script>