@extends('layouts.horizontal', ['title' => 'MIS Reporting', 'topbarTitle' => 'Reports'])

@section('content')

<div class="d-flex gap-2">
    <div class=" offcanvas-xl offcanvas-start file-manager" tabindex="-1" id="fileManagerSidebar"
        aria-labelledby="fileManagerSidebarLabel">
        <!-- users -->
        <div class="card d-flex flex-column">
            <div class="p-3">
                <div class="d-flex flex-column">
                    <div class="d-flex justify-content-between gap-2 align-items-center mb-2">
                       <h4 class="mb-0 text-danger">Report Categories</h4>
                        <button type="button" class="btn btn-sm btn-icon btn-light d-xl-none d-flex p-1"
                            data-bs-dismiss="offcanvas" aria-label="Close">
                            <i class="ri-close-line lh-1 fs-17"></i>
                        </button>
                    </div>


                    <div class="file-menu">
                        @foreach ($report_category as $category)
                            <a style="cursor: pointer;" onclick="show_tr({{ $category->id_report_category }})" targeTab="1" class="list-group-item rounded active_tr_mis_reports"><i class="{!! $category->category_icon !!} fs-18 align-middle me-2"></i>{!! $category->category_name !!}</a>
                        @endforeach
                    </div>

                    <div class="mt-5 pt-5">
                        <div class="alert alert-info p-3 pt-0 text-center mb-0" role="alert">
                            <img src="/images/coffee-cup.svg" alt="" class="img-fluid mt-n5"
                                style="max-width: 135px;">
                            <div>
                                <h5 class="alert-heading fw-medium fs-18 mt-2">Get more out
                                    of your data</h5>
                                <p>Use reports to get maximum insights for all your needs</p>

                                <a href="https://www.skedwise.com" target="_blank" class="btn btn-secondary">Get Additional Modules</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="card w-100">
        <div class="p-3 d-flex align-items-center gap-3">
            <button type="button" class="btn btn-sm btn-icon btn-light d-xl-none d-flex p-1"
                data-bs-toggle="offcanvas" data-bs-target="#fileManagerSidebar" aria-controls="fileManagerSidebar">
                <i class="ri-menu-2-line lh-1 fs-17"></i>
            </button>

            <h4 class="header-title me-auto" id="category-header">Selected Report Category</h4>
            <input type="text" id="search-report" class="form-control w-75" placeholder="Search Report...">
        </div>

        <div class="table-responsive">
            <table class="table table-centered table-nowrap border-top mb-0">
                <thead class="bg-light bg-opacity-25">
                    <tr>
                        <th class="ps-3 fw-bold fs-12 text-uppercase text-muted">Name</th>
                        <th class="fs-12 fw-bold text-uppercase text-muted">Last Viewed By</th>
                        
                        <th class="fs-12 fw-bold text-uppercase text-muted">Last Viewed</th>
                        <th class="fs-12 fw-bold text-uppercase text-muted">Permission</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($report_list as $report)
                    <tr class="d-none" data-report-category-id = "{{ $report->report_category_id }}">
                        <td class="ps-3 list">
                            <div class="d-flex align-items-center gap-2 list-item">
                                @if(str_contains($report->report_name, 'Cancel'))
                                    <div class="flex-shrink-0 avatar-md  bg-danger-subtle d-inline-flex align-items-center justify-content-center rounded-2">
                                        <i class="ri-file-zip-line fs-22 text-danger"></i>
                                    </div>
                                    <div>
                                        <span class="fw-medium report-name"><a href="{{ route('reports.run', ['id' => $report->report_file_path]) }}" target="_blank" class="text-reset">{{ $report->report_name }}</a></span>
                                        <p title="{{ $report->report_description }}" data-bs-toggle="tooltip" data-bs-placement="right" class="mb-0 fs-12">{{ Str::limit($report->report_description, 75) }}</p>
                                    </div>
                                @elseif(str_contains($report->report_name, 'Invoice'))
                                    <div class="flex-shrink-0 avatar-md bg-success-subtle d-inline-flex align-items-center justify-content-center rounded-2">
                                        <i class="ti ti-file-dollar fs-22 text-success"></i>
                                    </div>
                                    <div>
                                        <span class="fw-medium report-name"><a href="{{ route('reports.run', ['id' => $report->report_file_path]) }}"  target="_blank"  class="text-reset">{{ $report->report_name }}</a></span>
                                        <p title="{{ $report->report_description }}" data-bs-toggle="tooltip" data-bs-placement="right" class="mb-0 fs-12">{{ Str::limit($report->report_description, 75) }}</p>
                                    </div>
                                @elseif(str_contains($report->report_name, 'Sale') && !str_contains($report->report_name, 'Product'))
                                    <div class="flex-shrink-0 avatar-md bg-success-subtle d-inline-flex align-items-center justify-content-center rounded-2">
                                        <i class="ti ti-file-analytics fs-22 text-success"></i>
                                    </div>
                                    <div>
                                        <span class="fw-medium report-name"><a href="{{ route('reports.run', ['id' => $report->report_file_path]) }}" target="_blank"  class="text-reset">{{ $report->report_name }}</a></span>
                                        <p title="{{ $report->report_description }}" data-bs-toggle="tooltip" data-bs-placement="right" class="mb-0 fs-12">{{ Str::limit($report->report_description, 75) }}</p>
                                    </div>
                                @elseif(str_contains($report->report_name, 'Staff'))
                                    <div class="flex-shrink-0 avatar-md bg-success-subtle d-inline-flex align-items-center justify-content-center rounded-2">
                                        <i class="ri-file-zip-line fs-22 text-success"></i>
                                    </div>
                                    <div>
                                        <span class="fw-medium report-name"><a href="{{ route('reports.run', ['id' => $report->report_file_path]) }}" target="_blank"  class="text-reset">{{ $report->report_name }}</a></span>
                                        <p title="{{ $report->report_description }}" data-bs-toggle="tooltip" data-bs-placement="right" class="mb-0 fs-12">{{ Str::limit($report->report_description, 75) }}</p>
                                    </div>
                                @elseif(str_contains($report->report_name, 'Retail') || str_contains($report->report_name, 'Stock') || str_contains($report->report_name, 'Product'))
                                    <div class="flex-shrink-0 avatar-md bg-secondary-subtle d-inline-flex align-items-center justify-content-center rounded-2">
                                        <i class="ri-file-shield-line fs-22 text-secondary"></i>
                                    </div>
                                    <div>
                                        <span class="fw-medium report-name"><a href="{{ route('reports.run', ['id' => $report->report_file_path]) }}" target="_blank"  class="text-reset">{{ $report->report_name }}</a></span>
                                        <p title="{{ $report->report_description }}" data-bs-toggle="tooltip" data-bs-placement="right" class="mb-0 fs-12">{{ Str::limit($report->report_description, 75) }}</p>
                                    </div>
                                @elseif(str_contains($report->report_name, 'Customer'))
                                    <div class="flex-shrink-0 avatar-md bg-info-subtle d-inline-flex align-items-center justify-content-center rounded-2">
                                        <i class="ri-file-user-line fs-22 text-info"></i>
                                    </div>
                                    <div>
                                        <span class="fw-medium report-name"><a href="{{ route('reports.run', ['id' => $report->report_file_path]) }}" target="_blank"  class="text-reset">{{ $report->report_name }}</a></span>
                                        <p title="{{ $report->report_description }}" data-bs-toggle="tooltip" data-bs-placement="right" class="mb-0 fs-12">{{ Str::limit($report->report_description, 75) }}</p>
                                    </div>
                                @else
                                    <div class="flex-shrink-0 avatar-md bg-warning-subtle d-inline-flex align-items-center justify-content-center rounded-2">
                                        <i class="ri-file-copy-line fs-22 text-warning"></i>
                                    </div>
                                    <div>
                                        <span class="fw-medium report-name"><a href="{{ route('reports.run', ['id' => $report->report_file_path]) }}" target="_blank"  class="text-reset">{{ $report->report_name }}</a></span>
                                        <p title="{{ $report->report_description }}" data-bs-toggle="tooltip" data-bs-placement="right" class="mb-0 fs-12">{{ Str::limit($report->report_description, 75) }}</p>
                                    </div>
                                @endif
                            </div>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-2">
                                <div>
                                    <a href="javascript: void(0);">
                                        @if($report->last_viewed_by != null)
                                        <img src="{{ $report->last_viewed_by_image ? asset('/images/users/'. $report->last_viewed_by_image) : asset('/images/users/avatar-2.jpg') }}" class="rounded-circle avatar-md" alt="friend">
                                        @else
                                        <img src="{{ asset('/images/users/avatar-18.jpg') }}" class="rounded-circle avatar-md" alt="friend">
                                        @endif
                                    </a>
                                </div>
                                <div>
                                    <p class="mb-0 fw-medium">{{ $report->last_viewed_by }}</p>
                                    <span class="fs-12"></span>
                                </div>
                            </div>
                        </td>
                        <td>{{ $report->last_viewed_at != '' ? \Carbon\Carbon::parse($report->last_viewed_at)->format('d-m-Y H:i') : '' }}</td>
                        <td>
                            <div class="avatar-group flex-nowrap">                                
                                @if(sizeOf($report->permissions) > 0)
                                    @foreach($report->permissions as $permission)  
                                    @if($permission->permission_type == 'View Only')   
                                    <div class="avatar avatar-sm permission" title="View Only" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-success rounded-circle fw-bold">
                                            V
                                        </span>
                                    </div>
                                    @elseif($permission->permission_type == 'Any')
                                    <div class="avatar avatar-sm permission" title="All" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-warning rounded-circle fw-bold">
                                            A
                                        </span>
                                    </div>
                                    <div class="avatar avatar-sm permission" title="PDF Export" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-primary rounded-circle fw-bold">
                                            P
                                        </span>
                                    </div>
                                    <div class="avatar avatar-sm permission" title="CSV Export" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-secondary rounded-circle fw-bold">
                                            C
                                        </span>
                                    </div>
                                    @elseif($permission->permission_type == 'Export PDF')
                                    <div class="avatar avatar-sm permission" title="PDF Export" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-primary rounded-circle fw-bold">
                                            P
                                        </span>
                                    </div>
                                    @elseif($permission->permission_type == 'Export CSV')
                                    <div class="avatar avatar-sm permission" title="CSV Export" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-secondary rounded-circle fw-bold">
                                            C
                                        </span>
                                    </div>
                                    @elseif($permission->permission_type == 'Delete')                                       
                                    <div class="avatar avatar-sm permission" title="Delete" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-danger rounded-circle fw-bold">
                                            D
                                        </span>
                                    </div>
                                    @endif
                                    @endforeach
                                @else
                                    <div class="avatar avatar-sm permission" title="View" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-success rounded-circle fw-bold tooltip-label" data-bs-toggle="tooltip" data-bs-placement="top" title="Veiw">
                                            V
                                        </span>
                                    </div>
                                    <div class="avatar avatar-sm permission" title="All" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-warning rounded-circle fw-bold tooltip-label" data-bs-toggle="tooltip" data-bs-placement="top" title="All">
                                            A
                                        </span>
                                    </div>
                                    <div class="avatar avatar-sm permission" title="PDF Export" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-primary rounded-circle fw-bold tooltip-label" data-bs-toggle="tooltip" data-bs-placement="top" title="PDF Export">
                                            P
                                        </span>
                                    </div>
                                    <div class="avatar avatar-sm permission" title="CSV Export" data-bs-toggle="tooltip" data-bs-placement="top">
                                        <span class="avatar-title bg-secondary rounded-circle fw-bold tooltip-label" data-bs-toggle="tooltip" data-bs-placement="top" title="CSV Export">
                                            C
                                        </span>
                                    </div>
                                @endif                                
                            </div>
                        </td>
                    </tr>
                    @endforeach                    
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection

@section('scripts')

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const reportRows = document.querySelectorAll('tr[data-report-category-id]');
            reportRows.forEach(row => {
                const categoryId = row.getAttribute('data-report-category-id');
                row.classList.add('d-none');
            });

            //initialize search functionality
            const searchInput = document.getElementById('search-report');
            searchInput.addEventListener('input', function () {
                const searchTerm = this.value.toLowerCase();
                const reportRows = document.querySelectorAll('tr[data-report-category-id]');
                reportRows.forEach(row => {
                    const reportNameElement = row.querySelector('.report-name');
                    const reportName = reportNameElement ? reportNameElement.textContent.toLowerCase() : '';
                    if (reportName.includes(searchTerm)) {
                        row.classList.remove('d-none');
                    } else {
                        row.classList.add('d-none');
                    }
                });
            });

            // Show reports of the first category by default
            if ($('.active_tr_mis_reports').length) {
                let firstEl = $('.active_tr_mis_reports').first();
                firstEl.addClass('active');
                show_tr(firstEl.attr('targeTab'));
            }

        });

        function show_tr(report_category_id){

            const listGroupItems = document.querySelectorAll('.list-group-item');
            
            // console.log(event.currentTarget);
            //if currentTarget is not document (to avoid errors on initial load)
            if(event.currentTarget !== document){
                listGroupItems.forEach(item => {
                    item.classList.remove('active');
                });
                event.currentTarget.classList.add('active');
            
                const categoryHeader = document.getElementById('category-header');
                let headerText = event.currentTarget.textContent.trim();
                categoryHeader.textContent = headerText; //+ ' Reports';
            } else {
                //set header text to first category
                const firstItem = document.querySelector('.list-group-item');
                let headerText = firstItem.textContent.trim();
                const categoryHeader = document.getElementById('category-header');
                categoryHeader.textContent = headerText; //+ ' Reports';
            }

            const reportRows = document.querySelectorAll('tr[data-report-category-id]');
            reportRows.forEach(row => {
                const categoryId = row.getAttribute('data-report-category-id');
                if(categoryId == report_category_id){
                    row.classList.remove('d-none');
                } else {
                    row.classList.add('d-none');
                }
            });
        }

        function runReport(reportId) {
            // Implement the logic to run the report based on the reportId
            // console.log("Running report with ID:", reportId);
            // You can add your AJAX call or form submission logic here
            // Example AJAX call using Fetch API
           const url = `{{ route('reports.run', ['id' => ':id']) }}`.replace(':id', reportId);
            fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ reportId })
            })
            .then(response => response.json())
            .then(data => {
                // console.log("Report run successfully:", data);
                // Handle success (e.g., show a success message, update the UI)
            })
            .catch(error => {
                console.error("Error running report:", error);
                // Handle error (e.g., show an error message)
            });
        }

    </script>

@endsection