@extends('layouts.horizontal', ['title' => 'Pos', 'topbarTitle' => 'Point of Sale'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])

@vite(['node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css',
    'node_modules/choices.js/public/assets/styles/choices.min.css',
    'node_modules/select2/dist/css/select2.min.css',
    'node_modules/select2/dist/css/select2.min.css'
])
<style>

    
    .page-container {
        max-width: 100% !important;
        margin: 0 auto;
    }

    .order_type_btn{
        transition: background-color 0.3s ease, box-shadow 0.3s ease;
    }

    .order_type_btn.active{
        background-color: #da786c;
        color: #fff;
        animation: softPulse 1.5s ease-in-out infinite;
        margin-left:2px;
        margin-right:2px;
    }

    @keyframes softPulse {
        0% {
            box-shadow: 0 0 0 0 rgba(218,120,108,0.6);
        }
        70% {
            box-shadow: 0 0 0 10px rgba(218,120,108,0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(218,120,108,0);
        }
    }
    
    /* Running Orders Container */
    .order-card:hover {
        background: #f8f9fa;
    }
    .order-card.active {
        border-color: #0d6efd;
        background: #eef5ff;
    }


    .modal-body {
        overflow-y: auto; 
        max-height: 80vh; 
    }


</style>
@endsection

@section('content')
<div class="container-fluid">

    <input type="hidden" id="posView" value="1">

    <!-- CC charges hidden feild -->
    <input type="hidden" id="business-cc-fee-percent" value="{{ $business_data->cc_charge ?? 0 }}">


    <!-- Loader -->
    <div class="row g-1">
        <!-- Left Column: Products & Categories (6 columns) -->
        <div class="col-lg-6">
            <div class="card h-100 border-0 shadow-sm" style="max-height:80vh; !important;">
                <div class="card-body pt-2 ps-1 pe-1 pb-0">

                    <!-- Search + Category Button -->
                    <div class="row g-2 mb-3">
                        <div class="col-md-3">
                            <button class="btn btn-outline-secondary w-100"
                                    data-bs-toggle="offcanvas"
                                    data-bs-target="#categoryOffcanvas">
                                <i class="ti ti-category-2 me-1"></i> Categories
                            </button>
                        </div>
                        <div class="col-md-9">
                            <div class="input-group">
                            
                                <input type="text"
                                    class="form-control"
                                    id="searchItemList"
                                    placeholder="Search products...">
                                <span class="input-group-text bg-light">
                                    <i class="ti ti-search"></i>
                                </span>       
                            </div>
                        </div>

                    
                    </div>

                    <!-- Products Area -->
                    <div class="row g-1">
                        <div class="col-12">
                            <div class="row g-1"
                                id="for_appending_all_products"
                                style="max-height:59vh; overflow-y:auto;">
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        <!-- Center Column: Current Order (4 columns) -->
        <!-- Current Order -->
        <div class="col-12 col-md-4" >
            <div class="card h-100 border-0 shadow-sm" style="max-height:80vh; !important;">
                <div class="card-body d-flex flex-column pt-2 ps-1 pe-1 pb-0">

                    <!-- Staff & Customer Selection -->
                    <div class="row g-2 mb-1">
                        <div class="col-4">
                            <select class="form-select form-select-sm" id="for_appending_staffs">
                                <option value="">Select Staff</option>
                                <!-- Staff will be loaded here -->
                            </select>
                        </div>
                       <div class="col-8">
                        <div class="input-group input-group-sm mb-2 flex-nowrap">
                            <input type="hidden" id="for_appending_customers">

                            <select class="form-select" id="for_customer_search_customers"
                                    onchange="search_customer(); setting_customer_name_on_cart_div();"
                                    name="for_customer_search_customers" required>
                            </select>
                            <button class="btn btn-outline-primary" type="button" id="Add_customer" onclick="open_new_customer_modal()">
                                <iconify-icon icon="mdi:user-plus" class="fs-16"></iconify-icon>
                            </button>
                        </div>
                    </div>

                    </div>
                    <!-- Order Type Buttons -->
                   <div class="d-flex gap-1 mb-1 flex-wrap">
                    <button type="button"
                        class="btn btn-primary btn-sm flex-fill order_type_btn <?= ($restaurant_pos_order_type == 'Dine-in') ? 'active' : '' ?>"
                        data-typeid="Dine-in">
                        <span class="iconify me-1" data-icon="mdi:table-chair"></span>
                        <iconify-icon icon="mdi:table-chair" class="fs-20"></iconify-icon>
                        Dine-In
                    </button>

                    <button type="button"
                        class="btn btn-info btn-sm flex-fill order_type_btn <?= ($restaurant_pos_order_type == 'Take away') ? 'active' : '' ?>"
                        data-typeid="Take away">
                        <span class="iconify me-1" data-icon="mdi:food-takeout-box"></span>
                        <iconify-icon icon="mdi:shopping-outline" class="fs-20"></iconify-icon>
                        Take-Away
                    </button>

                    <button type="button"
                        class="btn btn-warning btn-sm flex-fill order_type_btn <?= ($restaurant_pos_order_type == 'Delivery') ? 'active' : '' ?>"
                        data-typeid="Delivery">
                        <span class="iconify me-1" data-icon="mdi:motorbike-delivery"></span>
                        <iconify-icon icon="mdi:moped" class="fs-20"></iconify-icon>
                        Delivery
                    </button>

                </div>

                   
                    <!-- Order Info -->
                    <div class="d-flex justify-content-between mb-1 text-white bg-dark p-2 rounded">
                        <div id="displaying_order_no_on_cart"><i class="ti ti-receipt me-1"></i> Order #: <span id="order_number">-</span></div>
                        <div id="displaying_customer_name_no_on_cart"><i class="ti ti-user me-1"></i> <span id="customer_name_for_display"></span></div>
                    </div>

                    <!-- Cart Items Table -->
                   <div class="table-responsive flex-grow-1 mb-2 table-scroll">
                        <table class="table table-sm table-hover align-middle fs-11" id="table-new-order">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 50%;">ITEM</th>
                                    <th class="text-end" style="width: 10%;">PRICE</th>
                                    <th class="text-end" style="width: 5%;">QTY</th>
                                    <th class="text-end" style="width: 5%;">DISC.</th>
                                    <th class="text-end" style="width: 5%;">TAX</th>
                                    <th class="text-end" style="width: 20%;">TOTAL</th>
                                    <th style="width: 5%;"></th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>

                    <!-- Order Summary & Actions -->
                    <div class="card mt-auto mb-1">
                        <div class="card-body p-2">

                            <!-- Notes & Totals -->
                            <div class="row g-1 mb-1">
                                <div class="col-9">
                                    <textarea class="form-control form-control-sm"
                                            id="order_description"
                                            rows="2"
                                            placeholder="Customer notes..."></textarea>
                                </div>
                                <div class="col-3 small">
                                    <div>Qty: <span id="final_cart_total_qty">0</span></div>
                                    <div>Amt: <span id="final_cart_total">0.00</span></div>
                                </div>
                            </div>

                            <!-- Advance Toggle Button -->
                           

                            <!-- Advance Section (Hidden) -->
                            <div id="advance-pos-section" class="d-none mb-1">

                                <div class="border rounded p-1">

                                    <div class="row g-1">
                                        <div class="col-4">
                                            <input class="form-control form-control-sm decimal" id="product_order-adv-amount" placeholder="Amount">
                                        </div>

                                        <div class="col-4">
                                            <select class="form-select form-select-sm"
                                                    id="product_order-adv-mode"
                                                    onchange="payment_mode_changed();">
                                                <option>Cash</option>
                                                <option value="Card">Card</option>
                                                <option value="D-Card">Debit</option>
                                                <option value="Check">Check</option>
                                                <option value="Online">Online</option>
                                            </select>
                                        </div>

                                        <div class="col-4">
                                            <div class="btn-group w-100" role="group">
                                                <button class="btn btn-sm btn-success w-100" onclick="add_advance();" id="btn-add-adv">
                                                    <iconify-icon icon="tabler:check" class="fs-20"></iconify-icon>
                                                </button>
                                                <button class="btn btn-sm btn-dark w-100">
                                                    <iconify-icon icon="ri:printer-fill" class="fs-20"></iconify-icon>
                                                </button>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row g-1 mt-1 d-none" id="div-cc-inst">
                                        <div class="col-6">
                                            <input class="form-control form-control-sm"
                                                id="product_order-adv-cc-inst"
                                                placeholder="Inst">
                                        </div>
                                        <div class="col-6 d-none" id="div-cc-fee">
                                            <input disabled
                                                class="form-control form-control-sm"
                                                id="product_order-adv-ccfee"
                                                placeholder="Fee">
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <!-- Action Buttons -->
                            
                            <div class="row g-1 mb-0">
                             <div class="btn-group ">
                             <!-- Clear Cart -->
                            <button class="btn btn-primary btn-sm flex-fill" id="clear_cart_btn" data-bs-toggle="tooltip"  data-bs-placement="top" title="Clear Cart">
           
                                <iconify-icon icon="line-md:rotate-270" class="fs-20"></iconify-icon>
                            </button>
                            <button class="btn btn-secondary btn-sm flex-fill d-none" id="view_advance_section" onclick="toggleAdvancePOS()" data-bs-toggle="tooltip" data-bs-placement="top" title="Advance">
                                <iconify-icon icon="ph:money-wavy-thin" class="fs-20"></iconify-icon>
                            </button>
                            <!-- Generate Invoice -->
                            <button class="btn btn-success btn-sm flex-fill"
                                    id="create_quick_invoice"
                                    data-bs-toggle="tooltip"
                                    data-bs-placement="top"
                                    title="Generate Invoice"
                                    onclick="placeOrder('invoice_btn','#create_quick_invoice')">

                                <iconify-icon icon="material-symbols:receipt-long" class="fs-20"></iconify-icon>
                            </button>

                            <!-- Place Order -->
                           <button class="btn btn-info btn-sm flex-fill"
                                    id="add_place_order"
                                    data-bs-toggle="tooltip"
                                    data-bs-placement="top"
                                    title="Place Order"
                                    onclick="placeOrder('order_btn','#add_place_order')">
                                <iconify-icon icon="solar:course-up-linear" class="fs-20"></iconify-icon>
                            </button>

                            </div>   

                            </div>

                        </div>
                    </div>


                </div>
            </div>
        </div>

        <!-- Right Column: Orders -->
        <div class="col-lg-2">
            <div class="card  border-0 shadow-sm" style="height:80vh; !important;">
                <div class="card-body pt-2 ps-1 pe-1 pb-1 d-flex flex-column"  >

                    <!-- Header -->
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <h6 class="mb-0 fw-bold text-uppercase">
                            <i class="ti ti-list-check me-1"></i> Orders
                        </h6>
                        <div class="btn-group btn-group-sm">
                            <button class="btn btn-light" onclick="toggleFullScreen()"  title="Fullscreen">
                                <i class="ti ti-maximize"></i>
                            </button>
                            <button class="btn btn-light" id="refresh_runing_orders" title="Refresh">
                                <i class="ti ti-refresh"></i>
                            </button>
                        </div>
                    </div>

                    <!-- Tabs -->
                    <ul class="nav nav-pills nav-sm mb-2" role="tablist">
                        <li class="nav-item w-50">
                            <button class="nav-link active w-100"
                                data-bs-toggle="tab"
                                data-bs-target="#running_orders_tab"
                                onclick="getting_runing_order()">
                                <iconify-icon icon="bi:clock-history" class="fs-14"></iconify-icon> Running
                            </button>
                        </li>
                        <li class="nav-item w-50">
                            <button class="nav-link w-100"
                                data-bs-toggle="tab"
                                data-bs-target="#balance_orders_tab"
                                onclick="getting_orders_with_balance()">
                                <iconify-icon icon="ph:money-wavy-thin" class="fs-14"></iconify-icon> Balance
                            </button>
                        </li>
                    </ul>

                    <!-- Tab Content -->
                    <div class="tab-content flex-grow-1">

                        <!-- Running Orders -->
                        <div class="tab-pane fade show active" id="running_orders_tab">
                            <input type="text"
                                class="form-control form-control-sm mb-2"
                                id="search_runing_order_list"
                                placeholder="Search running orders">

                            <div id="runing_order_main_div"class="border rounded p-2" style="height:52vh; overflow-y:auto;">
                                <!-- running orders -->
                            </div>
                        </div>

                        <!-- Balance Orders -->
                        <div class="tab-pane fade" id="balance_orders_tab">
                            <input type="text"
                                class="form-control form-control-sm mb-2"
                                id="search_balance_order_list"
                                placeholder="Search balance orders">

                            <div id="balance_order_main_div" class="border rounded p-2" style="height:52vh; overflow-y:auto;">
                                <!-- balance orders -->
                            </div>
                        </div>
                    </div>

                    <!-- Actions -->
                    <div class="pt-0 mt-0 border-top p-2">
                        <div class="d-grid gap-1">
                            <div class="btn-group d-none">
                                <button class="btn btn-sm btn-warning"
                                    data-bs-toggle="modal"
                                    data-bs-target="#cashRegisterModal">
                                    <i class="ti ti-cash"></i> Register
                                </button>
                                <button class="btn btn-sm btn-info" id="btnCashTill">
                                    <i class="ti ti-lock"></i> Close
                                </button>
                            </div>
                             <div class="btn-group ">
                            <button class="btn btn-sm btn-success" data-bs-toggle="tooltip" data-bs-placement="top" title="Recent Invoices" onclick="getting_recent_invoices()">
                                <iconify-icon icon="bi:clock-history" class="fs-20"></iconify-icon>
                            </button>

                            <button class="btn btn-sm btn-primary" id="print_bill"    data-bs-toggle="tooltip" data-bs-placement="top" title="Print Bill">
                                <iconify-icon icon="ri:printer-fill" class="fs-20"></iconify-icon>
                            </button>
                            <button class="btn btn-sm btn-danger"id="cancel_order_btn" data-co="0"    data-bs-toggle="tooltip" data-bs-placement="top"title="Cancel Order">
                                <iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon> 
                            </button>
                            </div>

                        </div>
                    </div>

                </div>
            </div>
        </div>


    </div>
</div>


<!-- Categories Sidebar -->
<div class="offcanvas offcanvas-start"
     tabindex="-1"
     id="categoryOffcanvas">

    <div class="offcanvas-header border-bottom">
        <h5 class="offcanvas-title">
            <i class="ti ti-category me-1"></i> Categories
        </h5>
        <button type="button"
                class="btn-close"
                data-bs-dismiss="offcanvas"></button>
    </div>

    <div class="offcanvas-body p-0"> <div class="list-group list-group-flush" id="sub_category_div">
            <!-- Categories JS se append hongi -->
        </div>
    </div>
</div>


<!-- Simple Invoice Modal -->
<div class="modal fade" id="invoiceModal" aria-labelledby="invoiceModalLabel" tabindex="-1" aria-hidden="true">
<div class="modal-dialog modal-full-width modal-custom modal-dialog-centered modal-full-width ">

        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="invoiceModalLabel">
                    <i class="ti ti-receipt me-2"></i>Invoice
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="invoiceModalBody" style="max-height: 80vh; overflow-y: auto;">
                <!-- Yahan AJAX response ka view load hoga -->
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2 text-muted">Loading invoice...</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="categoryTabsModal" tabindex="-1" aria-labelledby="categoryTabsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Category Forms <span id="orderIdForCategoryForm"></span></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <!-- Tabs navigation -->
                <ul class="nav nav-pills nav-justified mb-3" id="categoryTabsNav"></ul>

                <!-- Tabs content -->
                <div class="tab-content" id="categoryTabsContent"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" id="saveCategoryForms" onclick="saveCategoryForms()">Save</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="recentInvoicesModal">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Recent Invoices (Last 50)</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-centered table-bordered table-nowrap mb-0 table-sm fs-12" id="recentInvoicesTable">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Invoice #</th>
                                <th>Order #</th>
                                <th>Date</th>
                                <th>Customer</th>
                                <th>Staff</th>
                                <th>Net Amount</th>
                                <th>Paid</th>
                                <th>Balance</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="9" class="text-center">Loading...</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

@include('modals.customer_add')
@endsection

@section('scripts')
<script>
    let orderLastUpdatedAt =null;
    var category_name ='';
    let filteredProducts = [];  
    let allProducts = [];       
    let currentPage = 1;
    const itemsPerPage = 12;

    // Global variables
    let allRunningOrders = [];
    let allBalanceOrders = [];
    let selectedOrderId = null;
    let selectedOrderType = 'running'; // 'running' or 'balance'

    // Global variables
    let all_product_data_for_search = [];
    const business_id = {{ session('business_id', 0) }};
    const currency_code = '{{ config("constants.CURRENCY", "$") }}';
    const asset_url = "{{ asset('') }}";
    const storage_url = "{{ Storage::url('') }}";
    const csrf_token = "{{ csrf_token() }}";
    const baseURL = "{{ url('') }}";
    let invoiceModal;
    let invoiceInitialized = false;


    $(document).ready(function() {
      var timer;

        // let categories = [
        //     { id: 'Sherwani', name: 'Sherwani' },
        //     { id: 'Jacket,Princecoat', name: 'Jacket,Princecoat' },
        //     { id: 'Jacket,Princecoat', name: 'Trouser,Pajama' }
        // ];
        // openCategoryModal(categories)
        initBootstrapComponents();
        loadCategories();

        getting_runing_order();
        search_customer();
        getting_staff_list();
        setTimeout(function () {
         fetchDefaultCustomer();
        //  loadProducts();
        }, 300);

        document.getElementById('refresh_runing_orders').addEventListener('click', function() {
            orderLastUpdatedAt =null;
            getting_runing_order();
        });
        

        document.getElementById('search_runing_order_list').addEventListener('input', function() {
            filterRunningOrders(this.value.toLowerCase());
        });
        
        document.getElementById('search_balance_order_list').addEventListener('input', function() {
            filterBalanceOrders(this.value.toLowerCase());
        });
        
        document.getElementById('print_bill').addEventListener('click', function() {
            printSelectedBill();
        });
        
        document.getElementById('cancel_order_btn').addEventListener('click', function() {
            cancelSelectedOrder();
        });
        

        const modalEl = document.getElementById('invoiceModal');
        invoiceModal = new bootstrap.Modal(modalEl);
        modalEl.addEventListener('hidden.bs.modal', function () {
            $('#invoiceModalBody').html('');   
            invoiceInitialized = false; 
        });
        
        // initializeKeyboardShortcuts();

    });


    $(document).on('input', '#searchItemList' ,function() {
            const query = $(this).val().toLowerCase().trim();
            currentPage = 1;
            filterAndRenderProducts(query);
    });

    // Initialize all Bootstrap components
    function initBootstrapComponents() {
        // Wait for Bootstrap to be available
        const waitForBootstrap = () => {
            if (typeof bootstrap !== 'undefined') {
                // Bootstrap is available, initialize components
                initializeBootstrap();
            } else {
                // Wait and try again
                setTimeout(waitForBootstrap, 100);
            }
        };
        
        function initializeBootstrap() {
            // Initialize tooltips
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl, {
                    trigger: 'hover'
                });
            });
            
            // Initialize offcanvas
            const offcanvasElementList = [].slice.call(document.querySelectorAll('.offcanvas'));
            offcanvasElementList.map(function(offcanvasEl) {
                return new bootstrap.Offcanvas(offcanvasEl);
            });
            
            // Initialize modals
            const modalElementList = [].slice.call(document.querySelectorAll('.modal'));
            modalElementList.map(function(modalEl) {
                return new bootstrap.Modal(modalEl);
            });
        }
        
        // Start waiting for Bootstrap
        waitForBootstrap();
    }

    function getting_products_by_cat(category_name='all',flag='all') {
        category_name = category_name;
        currentPage = 1;
        const search_field = category_name.toLowerCase();

        // If products already fetched
        if (window.all_product_data_for_search && window.all_product_data_for_search.length > 0) {
            allProducts = [...window.all_product_data_for_search];
            filterAndRenderProducts(search_field,flag);
        } else {
            // Fetch products from server
            fetchProductsByCategory(search_field).then(data => {
                allProducts = data;
                filterAndRenderProducts(search_field,flag);
            });
        }

         // Return functions for external access if needed
        return {
            nextPage: function() {
                if (currentPage < totalPages) {
                    currentPage++;
                    renderProducts();
                }
            },
            prevPage: function() {
                if (currentPage > 1) {
                    currentPage--;
                    renderProducts();
                }
            },
            goToPage: function(page) {
                if (page >= 1 && page <= totalPages) {
                    currentPage = page;
                    renderProducts();
                }
            },
            refresh: function() {
                filterProducts();
                currentPage = 1;
                renderProducts();
            },
            getCurrentPage: function() {
                return currentPage;
            },
            getTotalPages: function() {
                return totalPages;
            },
            getFilteredCount: function() {
                return filteredProducts.length;
            }
        };

    }  
    
    function filterAndRenderProducts(categoryOrSearch,flag ='All') {
        const query = categoryOrSearch?.toLowerCase().trim() || '';

        filteredProducts.length = 0;

        $.each(allProducts, function(index, product) {
            const name = product.product?.toLowerCase() || "";
            const category = product.category?.toLowerCase() || "";
            const business_brand_name = product.business_brand_name?.toLowerCase() || "";
            const barcode_products = product.barcode_products?.toLowerCase() || "";
            const sku = product.sku?.toLowerCase() || "";
            const batch = product.batch_number?.toLowerCase() || "";
            const trackInventory = product.track_inventory;

            // Special case for 'track_inventory_no'
            if (query === 'track_inventory_no') {
                if (trackInventory === 'No') filteredProducts.push(product);
            }
            // 'all' category
            else if (query === 'all' || query === "") {
                filteredProducts.push(product);
            }
            // Normal category / search filter
            else {
                if(flag=='only_search_by_category'){
                    if (category.includes(query)) {
                      filteredProducts.push(product);
                   }
                }else{
                  if (business_brand_name.includes(query)  || category.includes(query) || name.includes(query) || sku.includes(query) || batch.includes(query) ||  barcode_products.includes(query)) {
                      filteredProducts.push(product);
                   }
                }

            }
        });

        totalPages = Math.ceil(filteredProducts.length / itemsPerPage);
        renderProducts();
    }

        function filterProducts() {
            const search_field = category_name.toLowerCase();
            filteredProducts.length = 0;
            
            console.log("Filtering products for category:", search_field);
            
            // If we already have all products data, filter locally
            if (window.all_product_data_for_search && window.all_product_data_for_search.length > 0) {
                $.each(window.all_product_data_for_search, function(index, product) {
                    let category = product.category ? product.category.toLowerCase() : "";
                    
                    if (search_field === 'track_inventory_no') {
                        if (product.track_inventory === 'No') {
                            filteredProducts.push(product);
                        }
                    } else if (search_field === 'all') {
                        filteredProducts.push(product);
                    } else {
                        if (category.includes(search_field)) {
                            filteredProducts.push(product);
                        }
                    }
                });
                
                totalPages = Math.ceil(filteredProducts.length / itemsPerPage);
                renderProducts();
            } else {
                // Fetch products from server
                fetchProductsByCategory(search_field);
            }
        }
        
        function fetchProductsByCategory(category) {
            showLoader();
            
            const url = "{{ route('pos.category.products') }}";
            const data = {
                businessid: business_id,
                category: 'All'
            };
            
            $.ajax({
                url: url,
                method: 'GET',
                data: data,
                headers: {
                    'X-CSRF-TOKEN': csrf_token
                },
                success: function(response) {
                    console.log("Products received:", response);
                    
                    // Store in global variable
                    window.all_product_data_for_search = response;
                    
                    // Filter products
                    filteredProducts.length = 0;
                    
                    if (category === 'track_inventory_no') {
                        $.each(response, function(index, product) {
                            if (product.track_inventory === 'No') {
                                filteredProducts.push(product);
                            }
                        });
                    } else if (category === 'all') {
                        $.each(response, function(index, product) {
                            filteredProducts.push(product);
                        });
                    } else {
                        $.each(response, function(index, product) {
                            let productCategory = product.category ? product.category.toLowerCase() : "";
                            if (productCategory.includes(category.toLowerCase())) {
                                filteredProducts.push(product);
                            }
                        });
                    }
                    
                    totalPages = Math.ceil(filteredProducts.length / itemsPerPage);
                    hideLoader();
                    renderProducts();
                },
                error: function(xhr, status, error) {
                    console.error("Error fetching products:", error);
                    hideLoader();
                    
                    $("#for_appending_all_products").html(`
                        <div class="col-12 text-center py-5">
                            <div class="empty-state">
                                <i class="ti ti-alert-triangle fs-48 text-danger mb-3"></i>
                                <h5 class="text-danger">Error Loading Products</h5>
                                <p class="text-muted">Failed to load products. Please try again.</p>
                            </div>
                        </div>
                    `);
                }
            });
        }
        
        function renderProducts() {
            const startIndex = (currentPage - 1) * itemsPerPage;
            const endIndex = startIndex + itemsPerPage;
            const productsToRender = filteredProducts.slice(startIndex, endIndex);
            
            $("#for_appending_all_products").html("");
            
            if (filteredProducts.length === 0) {
                $("#for_appending_all_products").html(`
                    <div class="col-12 text-center py-5">
                        <div class="empty-state">
                            <i class="ti ti-package-off fs-16 text-muted mb-3"></i>
                            <h5 class="text-muted">No products found</h5>
                        </div>
                    </div>
                `);
                return;
            }
            
            $.each(productsToRender, function(index, product) {
                let trackInventoryFlag = "";
                if (product.track_inventory === "No") {
                    trackInventoryFlag = `<span class="badge bg-danger-subtle text-danger ms-1">Untracked</span>`;
                }
                
                // Determine icon based on category or type
                let productIcon = "ti ti-package";
                if (product.product_type === 'Compiled Kit') {
                    productIcon = "ti ti-box";
                } else if (product.category?.toLowerCase().includes('food')) {
                    productIcon = "ti ti-pizza";
                } else if (product.category?.toLowerCase().includes('drink')) {
                    productIcon = "ti ti-cup";
                }
                
                // Image URL handling with Laravel asset() helper
                const imageUrl = product.image 
                    ? `${asset_url}images/products/${product.image}`
                    : `${asset_url}images/products/default_product.png`;
                
                // Format price
                const formattedPrice = parseFloat(product.price).toFixed(2);
                
                // Escape special characters for JavaScript
                const escapedProductName = escapeHtml(product.product);
                const escapedCategory = escapeHtml(product.category || '');
                const escapedSku = escapeHtml(product.sku || '');
                const escapedBatchNumber = escapeHtml(product.batch_number || '');
                
               const html = `
                            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 mb-3" style="cursor:pointer;">
                                <div class="card h-100 border-0 shadow-sm position-relative cursor-pointer"
                                    onclick="add_product_to_cart_table(
                                        '${escapedProductName}',
                                        '${escapedSku}',
                                        ${product.price},
                                        ${product.product_sales_tax || 0},
                                        ${product.id_business_products},
                                        '${escapedCategory}',
                                        ${product.brand_id || 0},
                                        ${product.id_batch || 0},
                                        '${escapedBatchNumber}',
                                        1,
                                        0
                                    )">

                    
                                    <div class="position-relative">
                                        <img src="${imageUrl}"
                                            class="card-img-top rounded-top"
                                            style="height:140px; object-fit:cover;"
                                            onerror="this.src='${asset_url}images/products/default_product.png'">

                                      
                                        <span class="position-absolute top-0 start-0 m-2 badge bg-primary-subtle text-primary">
                                            <i class="${productIcon}"></i>
                                        </span>

                                        ${trackInventoryFlag}
                                    </div>

                                    <div class="card-body p-2">
                                        <h6 class="fw-semibold mb-1" >
                                          ${product.product}
                                        </h6>
                                        <small class="text-muted d-flex align-items-center mb-1">
                                            <i class="ti ti-tag me-1"></i>
                                           ${product.business_brand_name || ''}
                                        </small>
                                        ${product.sku ? `
                                        <small class="text-muted">
                                            ${product.sku}
                                        </small>` : ``}

                                        
                                        <div class="d-flex justify-content-between align-items-center">
                                            <span class="badge bg-success-subtle text-success fw-semibold">
                                                ${currency_code} ${formattedPrice}
                                            </span>
                                         
                               
                                            <small class="text-muted">
                                                <i class="ti ti-barcode me-1"></i>${product.barcode_products ?? 'N/A'}
                                            </small>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            `;
                $("#for_appending_all_products").append(html);
            });
            // Update pagination controls
            updatePaginationControls();
            // Initialize tooltips for new elements
            initTooltipsForProducts();
        }
        
        function updatePaginationControls() {
            if ($("#productsPagination").length === 0) {
                $("#for_appending_all_products").after(`
                    <div class="row mt-4" id="productsPagination">
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <span class="text-muted">
                                        Showing ${((currentPage - 1) * itemsPerPage) + 1} to 
                                        ${Math.min(currentPage * itemsPerPage, filteredProducts.length)} of 
                                        ${filteredProducts.length} products
                                    </span>
                                </div>
                                <div>
                                    <nav>
                                        <ul class="pagination pagination-sm mb-0">
                                            <li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
                                                <button class="page-link" id="prev-btn" ${currentPage === 1 ? 'disabled' : ''}>
                                                    <i class="ti ti-chevron-left"></i>
                                                </button>
                                            </li>
                                            ${generatePaginationNumbers()}
                                            <li class="page-item ${currentPage >= totalPages ? 'disabled' : ''}">
                                                <button class="page-link" id="next-btn" ${currentPage >= totalPages ? 'disabled' : ''}>
                                                    <i class="ti ti-chevron-right"></i>
                                                </button>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                `);
                
                // Bind pagination events
                $("#prev-btn").off("click").on("click", function() {
                    if (currentPage > 1) {
                        currentPage--;
                        renderProducts();
                    }
                });
                
                $("#next-btn").off("click").on("click", function() {
                    if (currentPage < totalPages) {
                        currentPage++;
                        renderProducts();
                    }
                });
            } else {
                // Update existing pagination
                $("#prev-btn").prop("disabled", currentPage === 1);
                $("#next-btn").prop("disabled", currentPage >= totalPages);
                $(".page-item").removeClass("active");
                $(`.page-item[data-page="${currentPage}"]`).addClass("active");
            }
        }
        
        function generatePaginationNumbers() {
            let paginationHTML = "";
            const maxVisiblePages = 5;
            let startPage = Math.max(1, currentPage - Math.floor(maxVisiblePages / 2));
            let endPage = Math.min(totalPages, startPage + maxVisiblePages - 1);
            
            if (endPage - startPage + 1 < maxVisiblePages) {
                startPage = Math.max(1, endPage - maxVisiblePages + 1);
            }
            
            // First page
            if (startPage > 1) {
                paginationHTML += `
                    <li class="page-item" data-page="1">
                        <button class="page-link pagination-number">1</button>
                    </li>
                    ${startPage > 2 ? '<li class="page-item disabled"><span class="page-link">...</span></li>' : ''}
                `;
            }
            
            // Page numbers
            for (let i = startPage; i <= endPage; i++) {
                paginationHTML += `
                    <li class="page-item ${currentPage === i ? 'active' : ''}" data-page="${i}">
                        <button class="page-link pagination-number">${i}</button>
                    </li>
                `;
            }
            
            // Last page
            if (endPage < totalPages) {
                paginationHTML += `
                    ${endPage < totalPages - 1 ? '<li class="page-item disabled"><span class="page-link">...</span></li>' : ''}
                    <li class="page-item" data-page="${totalPages}">
                        <button class="page-link pagination-number">${totalPages}</button>
                    </li>
                `;
            }
            
            return paginationHTML;
        }
        
        function initTooltipsForProducts() {
            $('[data-bs-toggle="tooltip"]').each(function () {
                try {
                    // Check if bootstrap is available
                    if (typeof bootstrap !== 'undefined' && bootstrap.Tooltip) {
                        let instance = bootstrap.Tooltip.getInstance(this);
                        if (instance) {
                            instance.hide();
                        }
                    } else {
                        console.warn('Bootstrap not available for tooltips');
                    }
                } catch (error) {
                    console.error('Tooltip error:', error);
                }
            });
            
            // Bind pagination number clicks
            $(".pagination-number").off("click").on("click", function() {
                const page = $(this).parent().data("page");
                if (page) {
                    currentPage = page;
                    renderProducts();
                }
            });
        }
        // Initialize the function
        filterProducts();
    
    // Helper functions
    function escapeHtml(text) {
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.replace(/[&<>"']/g, function(m) { return map[m]; });
    }

    function showLoader() {
        // $("#loader").removeClass("d-none");
    }

    function hideLoader() {
        // $("#loader").addClass("d-none");
    }

   

    // Global function to add product to cart
    function add_product_to_cart_table(product_name, sku, price, product_sales_tax,product_id, category, brand_id, batch_id, batch_number,OrderQty,orderId,product_discount_amount=0) {

            if(orderId ==0){
             $("#order_number").text('');
            }


            console.log(product_discount_amount,"product_discount_amount");

            price = parseFloat(price);
            product_sales_tax = parseFloat(product_sales_tax) || 0;

            let found = false;
            let qty = OrderQty;
            if(orderId ==0){
                $('#table-new-order tbody tr').each(function () {
                    if ($(this).find('.product_name').val() === product_name) {
                      qty  = parseFloat($(this).find('.product_qty').val()) + 1;
                        $(this).find('.product_qty').val(qty);

                        recalculateRow($(this));
                        found = true;
                        return false;
                    }
                });
            }
            if (found) {
                final_calculation_for_total();
                return;
            }

            let netPrice   = (price - product_discount_amount) * OrderQty;
            let taxAmount  = (netPrice * product_sales_tax) / 100;
            let totalPrice = netPrice + taxAmount;

            let html = `
            <tr>
                <td>
                    <input type="hidden" class="product_name" value="${product_name}">
                    <strong>${product_name}</strong>
                    <textarea class="form-control form-control-sm product_desc d-none" rows="1" placeholder="Item description..."></textarea> 
                </td>
                <td class="text-end">${price.toFixed(2)}</td>
                <td class="text-end">
                    <input type="number" class="form-control form-control-sm product_qty text-end" style="width:60px;" value="${qty}" step="any">
                </td>
                <td class="text-end">
                    <input type="number" class="form-control form-control-sm product_discount text-end" style="width:60px;" value="${parseFloat(parseFloat(product_discount_amount)).toFixed(2)}"  step="any">
                </td>
                <td class="text-end product_sale_tax_amount">${taxAmount.toFixed(2)}</td>
                <td class="text-end product_final_price">${totalPrice.toFixed(2)}</td>

                <input type="hidden" class="product_price" value="${price}">
                <input type="hidden" class="product_sale_tax" value="${product_sales_tax}">
                <input type="hidden" class="product_id" value="${product_id}">
                <input type="hidden" class="category_name" value="${category}">
                <input type="hidden" class="brand_id" value="${brand_id}">
                <input type="hidden" class="batch_id" value="${batch_id || 0}">
                <input type="hidden" class="batch_number" value="${batch_number || 0}">

                <td class="text-end">
                   <button type="button" class=" remove_product_from_table btn   btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger open-btn"><iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-20"></iconify-icon></button>
                </td>
            </tr>`;

            $('#table-new-order tbody').append(html);
            final_calculation_for_total();
    }
    
    function quickAddToCart(productId) {
        const product = window.all_product_data_for_search.find(p => p.id_business_products == productId);
        if (product) {
            const escapedProductName = escapeHtml(product.product);
            const escapedCategory = escapeHtml(product.category || '');
            const escapedSku = escapeHtml(product.sku || '');
            const escapedBatchNumber = escapeHtml(product.batch_number || '');
            
            add_product_to_cart_table(
                escapedProductName,
                escapedSku,
                product.price,
                product.product_sales_tax || 0,
                product.id_business_products,
                escapedCategory,
                product.brand_id || 0,
                product.id_batch || 0,
                escapedBatchNumber,
                1,
                0
            );
        }
    }

    // Load categories from server
    function loadCategories() {
        showLoader();

        $.ajax({
            url: "{{ route('pos.categories') }}",
            method: "GET",
            data: { businessid: business_id },
            headers: { 'X-CSRF-TOKEN': csrf_token },

            success: function (response) {
                populateCategories(response);
                hideLoader();
                getting_products_by_cat('all');
            },

            error: function () {
                hideLoader();
                console.log("Failed to load categories");
            }
        });
    }

        function populateCategories(categories) {
            const $sidebar = $("#sub_category_div");
            $sidebar.empty();

            // ALL PRODUCTS
            $sidebar.append(`
                <button class="list-group-item list-group-item-action active category-sidebar-filter"
                        data-category="all">
                    <i class="ti ti-apps me-2"></i> All Products
                </button>
            `);

            // OTHER CATEGORIES
            categories.forEach(category => {
                if (category.category && category.category !== 'All') {
                    $sidebar.append(`
                        <button class="list-group-item list-group-item-action
                                d-flex justify-content-between align-items-center
                                category-sidebar-filter"
                                data-category="${category.category}">
                            
                            <span>
                                <i class="ti ti-tag me-2"></i>
                                ${category.category}
                            </span>

                            ${category.product_count
                                ? `<span class="badge bg-primary rounded-pill">${category.product_count}</span>`
                                : ''
                            }
                        </button>
                    `);
                }
            });

            attachCategoryEvents();
        }

        function attachCategoryEvents() {
            $(".category-sidebar-filter").off("click").on("click", function() {
                const category = $(this).data("category");
                $(".category-sidebar-filter").removeClass("active");
                $(this).addClass("active");
                getting_products_by_cat(category, 'only_search_by_category');
                
                // SAFE: Close sidebar
                try {
                    const offcanvasElement = document.getElementById('categoryOffcanvas');
                    if (offcanvasElement) {
                        const offcanvasInstance = bootstrap.Offcanvas.getInstance(offcanvasElement);
                        if (offcanvasInstance) {
                            offcanvasInstance.hide();
                        }
                    }
                } catch (error) {
                    console.error('Error closing offcanvas:', error);
                    // Fallback: just hide it
                    $('#categoryOffcanvas').removeClass('show');
                }
            });
        }
    // Load initial products
    function loadProducts() {
        getting_products_by_cat('all');
    }
    function toggleFullScreen() {
        if (!document.fullscreenElement) {
            document.documentElement.requestFullscreen().catch(err => {
                console.error(`Error enabling fullscreen: ${err.message}`);
            });
        } else {
            if (document.exitFullscreen) {
                document.exitFullscreen();
            }
        }
    }

    // Search Customer 
    function initializeSelect2(url, type) {
            $('#for_customer_search_customers').select2({
                ajax: {
                    url: url,
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        // Ensure 'data' is a valid array before returning
                        if (!data || typeof data !== 'object') {
                            console.error('Invalid response for Select2:', data);
                            return { results: [] };
                        }

                        return {
                            results: data.map(function (item) {
                                return { id: item.id, text: item.text };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                placeholder: 'Select ' + type ,
                width: '100%'
            });

        // $('#for_customer_search_customers').on("select2:selecting select2-selecting", function(e) {
        //     $("#for_customer_search_customers").val(null).trigger("change");
        // });
    } 

    function fetchDefaultCustomer() {
        $.ajax({
            url: '{{ route('pos.search_restaurant_customer') }}',
            method: 'GET',
            dataType: 'json',
            data: { customername: 'Walk In' },

            success: function (data) {
                if (Array.isArray(data) && data.length > 0) {

                    let customer_id   = data[0].id_customers;
                    let customer_name = data[0].customer_name;
                    
                    $("#for_appending_customers").val(customer_id);
                    $("#customer_name_for_display").html(
                        `${customer_name}`
                    );

                    let option = new Option(customer_name, customer_id, true, true);
                    $('#for_customer_search_customers')
                        .append(option)
                        .trigger('change');
                }
            },
            error: function (err) {
                console.error("Walk-In fetch error", err);
            }
        });
    }


    function search_customer(){
      const search_term = $('#for_customer_search_customers option:selected').text() || 'Walk In';
     var mURL = "{{ route('customer_search') }}";
     initializeSelect2(mURL, search_term)
    }

    function setting_customer_name_on_cart_div() {

        // Select2 se selected data lo
        let selectedData = $('#for_customer_search_customers').select2('data');

        if (selectedData.length > 0) {
            let customer_id = selectedData[0].id;
            let customer_name = selectedData[0].text;

            $("#for_appending_customers").val(customer_id);
            $("#customer_name_for_display").html(customer_name);
        }
    }


    function recalculateRow($row) {

        let qty      = parseFloat($row.find('.product_qty').val()) || 1;
        let price    = parseFloat($row.find('.product_price').val()) || 0;
        let discount = parseFloat($row.find('.product_discount').val()) || 0;
        let taxRate  = parseFloat($row.find('.product_sale_tax').val()) || 0;

        let subTotal = price * qty;

        // discount cannot exceed subtotal
        if (discount > subTotal) {
            discount = subTotal;
            $row.find('.product_discount').val(discount);
        }

        let taxableAmount = subTotal - (discount*qty);
        let taxAmount = (taxableAmount * taxRate) / 100;
        let finalTotal = taxableAmount + taxAmount;

        $row.find('.product_sale_tax_amount').text(taxAmount.toFixed(2));
        $row.find('.product_final_price').text(finalTotal.toFixed(2));
    }



    function final_calculation_for_total() {
        let finalTotal = 0;
        let totalQty = 0;

        $('#table-new-order tbody tr').each(function () {
            finalTotal += parseFloat($(this).find('.product_final_price').text()) || 0;
            totalQty   += parseFloat($(this).find('.product_qty').val()) || 0;
        });

        let tip = parseFloat($('#tip_on_final_cart').val()) || 0;
        finalTotal += tip;

        $('#final_cart_total').text(finalTotal.toFixed(2));
        $('#final_cart_total_qty').text(totalQty);
    }


    $(document).on('input', '.product_qty, .product_discount', function () {
        let $row = $(this).closest('tr');
        recalculateRow($row);
        final_calculation_for_total();
    });



    function getting_staff_list() {
            $.ajax({
                url: "{{ url('/pos/staff_listing') }}",
                method: "GET",
                data: {
                    businessid: "{{ session('business_id') }}"
                },
                success: function (response) {

                    if (response.length > 0) {
                        var flag = true;
                        var html = '';
                        $.each(response, function (index, staff) {
                                html += `<option value="${staff.id}" >${staff.text}</option>`;
                        });
                        html += `<option value="0" selected>Select Staff</option>`;
                        // $("#txt-customer-refstaff").html(html);
                        $("#for_appending_staffs").html(html).select2();

                    } else {
                        swal({
                            title: 'Staff Not Available',
                            icon: 'warning',
                            button: 'OK'
                        });
                    }
                },
                error: function () {
                    $(".loader").fadeOut("slow");
                    swal({
                        title: 'Something went wrong',
                        icon: 'error',
                        button: 'OK'
                    });
                }
            });
    }

    $(document).on('click','.order_type_btn',function() {
        $(".order_type_btn").removeClass("active");
        $(this).addClass("active");
        var typeId = $(this).attr('data-typeid');         
   }); 

   // =============================> Place Order Stat <==============================
    function placeOrder(button_type='', btn_id) {
        // Get all cart data
        let cartData = [];
        var buttonLabel ='Place Order';
        if(button_type =='order_btn'){
            var buttonLabel ='Place Order';
        }else if(button_type =='invoice_btn'){
            var buttonLabel ='Invoice';
        }
        
        $('#table-new-order tbody tr').each(function() {
            let row = $(this);
            let productData = {
                product_name: row.find('.product_name').val(),
                product_id: row.find('.product_id').val(),
                category: row.find('.category_name').val(),
                brand_id: row.find('.brand_id').val(),
                batch_id: row.find('.batch_id').val(),
                batch_number: row.find('.batch_number').val(),
                price: parseFloat(row.find('.product_price').val()),
                qty: parseFloat(row.find('.product_qty').val()),
                discount: parseFloat(row.find('.product_discount').val()) || 0,
                tax_rate: parseFloat(row.find('.product_sale_tax').val()) || 0,
                tax_amount: parseFloat(row.find('.product_sale_tax_amount').text()) || 0,
                total: parseFloat(row.find('.product_final_price').text()) || 0,
                description: row.find('.product_desc').val() || ''
            };
            cartData.push(productData);
        });

        // Get customer, staff and order type data
        let customerId = $('#for_appending_customers').val() || 0;
        let customerName = $('#customer_name_for_display').text();
        let staffId = $('#for_appending_staffs').val() || 0;
        let orderType = $('.order_type_btn.active').data('typeid') || 'Take away';
        let orderDescription = $('#order_description').val() || '';
        let orderTotal = parseFloat($('#final_cart_total').text()) || 0;
        let totalQty = parseFloat($('#final_cart_total_qty').text()) || 0;
        let businessid = {{ session('business_id') ?? 0 }} ;
        let  order_id_for_edit = parseFloat($("#order_number").text() || 0);
        // Prepare complete order data
        let orderData = {
            cart_items: cartData,
            customer_id: customerId,
            businessid: businessid,
            customer_name: customerName,
            staff_id: staffId,
            order_type: orderType,
            order_description: orderDescription,
            total_amount: orderTotal,
            total_qty: totalQty,
            business_id: business_id,
            order_id_for_edit: order_id_for_edit,
            order_date: new Date().toISOString(),
            status: 'pending' 
        };
        
        $.ajax({
            url: "{{ route('pos.place_order') }}", 
            method: "POST",
            data: {
                _token: csrf_token,
                order_data: JSON.stringify(orderData)
            },
            beforeSend: function() {

                $(btn_id).html('<i class="fa fa-spinner fa-spin me-1"></i> Processing...');
                $(btn_id).prop('disabled', true);
            },
            success: function(response) {
                if (response.success) {

                    if(button_type =='invoice_btn'){
                        // getting_runing_order();   
                        generateInvoice(response.order_id) 
                        return false;
                    }else{
            
                        Swal.fire({
                            title: 'Done',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK',
                            customClass: {
                                confirmButton: 'btn btn-success'
                            }
                        });
                        clearCart();
                        $('#order_description').val('');
                        $('#final_cart_total').text('0.00');
                        $('#final_cart_total_qty').text('0');
                        if (response.order_id) {
                            $('#order_number').text(response.order_id);
                        }
                        getting_runing_order(response.order_id);
                        // selectRunningOrder(response.order_id);
                    }

                } else {

                    Swal.fire({
                        title: 'Warning',
                        text: response.message,
                        icon: 'warning',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-danger'
                        }
                    });
                }
            },
            error: function(xhr, status, error) {
                console.error("Error placing order:", error);
              
            },
            complete: function() {

                $(btn_id).html('<i class="fa fa-cutlery me-1"></i>'+buttonLabel);
                $(btn_id).prop('disabled', false);
            }
        });
    }


    function clearCart() {
        $("#running-order-" + $('#order_number').text()).removeClass('active');
        $('#table-new-order tbody').empty();
        $('#order_number').text('');
        $('#order_description').val('');
        $('#final_cart_total').text('0.00');
        $('#final_cart_total_qty').text('0');
        $("#for_appending_staffs").val(0).trigger('change');
        $("#view_advance_section").addClass('d-none');
        fetchDefaultCustomer();
        final_calculation_for_total();
        selectedOrderId ='';
    }

    function final_calculation_for_total() {
        let finalTotal = 0;
        let totalQty = 0;
        let cartItemsCount = 0;

        $('#table-new-order tbody tr').each(function() {
            finalTotal += parseFloat($(this).find('.product_final_price').text()) || 0;
            totalQty += parseFloat($(this).find('.product_qty').val()) || 0;
            cartItemsCount++;
        });
        
        if (cartItemsCount > 0) {
            $('#add_place_order').html(`<iconify-icon icon="solar:course-up-linear" class="fs-20"></iconify-icon> (${cartItemsCount})`);
        } else {
            $('#add_place_order').html('<iconify-icon icon="solar:course-up-linear" class="fs-20"></iconify-icon>');
        }

        $('#final_cart_total').text(finalTotal.toFixed(2));
        $('#final_cart_total_qty').text(totalQty);
    }


    $(document).on('click', '.remove_product_from_table', function() {
        $(this).closest('tr').remove();
        final_calculation_for_total();
    });


    $(document).on('click', '#clear_cart_btn', function() {
        clearCart();    
    }); 
    
  // Get running orders
function getting_runing_order(order_id = '') {
    selectedOrderType = 'running';
    const container = document.getElementById('runing_order_main_div');
    
    // // Show loading
    // container.innerHTML = `
    //     <div class="text-center py-5">
    //         <div class="spinner-border spinner-border-sm text-primary" role="status">
    //             <span class="visually-hidden">Loading...</span>
    //         </div>
    //         <p class="text-muted mt-2">Loading running orders...</p>
    //     </div>
    // `;
    
    // AJAX call
    $.ajax({
        url: "{{ route('pos.runningOrders') }}",
        type: "GET",
        data: {
            _token: csrf_token,
            businessid: '{{ session('business_id') ?? 0 }}',
            last_updated_at: orderLastUpdatedAt 
        },
        dataType: "json",
        success: function(response) {
   
            if (!orderLastUpdatedAt) {
                allRunningOrders = response;
            } else {
                allRunningOrders = [...response, ...allRunningOrders];
            }

            if (response.length > 0) {
                orderLastUpdatedAt = response[0].updated_at;
            }
            displayRunningOrders(response, order_id);
            
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
            container.innerHTML = `
                <div class="text-center py-4">
                    <i class="ti ti-alert-circle text-danger fs-4 mb-2"></i>
                    <p class="text-muted">Failed to load orders</p>
                    <button class="btn btn-sm btn-outline-primary" onclick="getting_runing_order()">
                        <i class="ti ti-refresh me-1"></i> Retry
                    </button>
                </div>
            `;
        }
    });
}

// Get balance orders
function getting_orders_with_balance() {
    selectedOrderType = 'balance';
    const container = document.getElementById('balance_order_main_div');
    
    // Show loading
    container.innerHTML = `
        <div class="text-center py-5">
            <div class="spinner-border spinner-border-sm text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <p class="text-muted mt-2">Loading balance orders...</p>
        </div>
    `;
    
    // AJAX call
    $.ajax({
        url: "{{ route('pos.getting_orders_with_balance') }}",
        type: "GET",
        data: {
            _token: csrf_token,
            businessid: '{{ session('business_id') ?? 0 }}'
        },
        dataType: "json",
        success: function(response) {
            allBalanceOrders = response;
            displayBalanceOrders(response);
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
            container.innerHTML = `
                <div class="text-center py-4">
                    <i class="ti ti-alert-circle text-danger fs-4 mb-2"></i>
                    <p class="text-muted">Failed to load orders</p>
                    <button class="btn btn-sm btn-outline-primary" onclick="getting_orders_with_balance()">
                        <i class="ti ti-refresh me-1"></i> Retry
                    </button>
                </div>
            `;
        }
    });
}

// Display running orders
function displayRunningOrders(orders, selectedId = '') {
    const container = document.getElementById('runing_order_main_div');
    
    if (!orders || orders.length === 0) {
        // container.innerHTML = `
        //     <div class="text-center py-4">
        //         <i class="ti ti-clock-off text-muted fs-4 mb-2"></i>
        //         <p class="text-muted">No running orders</p>
        //     </div>
        // `;
        // return;
    }
    
    let html = '';

    orders.forEach(order => {
        const isSelected = selectedId === order.order_id;
        // Order type color
        let typeClass = 'bg-secondary';
        if ((order.order_type).toLowerCase() === 'dine in') typeClass = 'bg-primary';
        if ((order.order_type).toLowerCase() === 'take away') typeClass = 'bg-info';
        if ((order.order_type).toLowerCase() === 'delivery') typeClass = 'bg-danger';

        const formattedDate = formatDate(order.order_date);

        html += `
            <div class="order-card d-flex mb-1 border rounded-2 ${isSelected ? 'active' : ''}"
                id="running-order-${order.order_id}"
                data-order-id="${order.order_id}"
                onclick="selectRunningOrder(${order.order_id})"
                data-bs-toggle="tooltip"
                data-bs-placement="top"
                title="Customer: ${order.customer_name || 'No Customer'} | Staff: ${order.staff_fullname || 'No Staff'} | Date: ${formattedDate} | Total: ${currency_code} ${Number(order.total || 0).toLocaleString()} | Items: ${order.total_qty || 0}"
                style="cursor:pointer; font-size:11px;">

                <!-- Vertical Order Type Strip -->
                <div class="${typeClass} text-white d-flex align-items-center justify-content-center px-1"
                    style="writing-mode: vertical-rl; transform: rotate(180deg); font-size:10px; min-width:18px;
                        border-top-right-radius: 4px; border-bottom-right-radius: 4px;">
                    ${order.order_type || 'N/A'}
                </div>

                <!-- Card Content -->
                <div class="flex-grow-1 p-2">
                    <div class="d-flex justify-content-between align-items-start">

                        <!-- Left: Order Info -->
                        <div>
                            <div class="d-flex align-items-center gap-1 mb-1">
                                <strong class="text-primary">#${order.order_id}</strong>
                                <span class="status-dot status-running"></span>
                            </div>

                            <div class="text-muted fs-9">
                                <div class="d-flex align-items-center">
                                    <i class="ti ti-user me-1"></i>
                                    ${order.customer_name || 'No Customer'}
                                </div>
                                <div class="d-flex align-items-center ">
                                    <i class="ti ti-id-badge me-1"></i>
                                    ${order.staff_fullname || 'No Staff'}
                                </div>
                            </div>
                        </div>

                        <!-- Right: Amount + Qty -->
                        <div class="text-end">
                            <div class="fw-bold text-success lh-1">
                                ${currency_code} ${Number(order.total || 0).toLocaleString()}
                            </div>
                            <div class="text-muted" style="font-size:10px;">
                                ${formattedDate}
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        `;
    });

    // container.innerHTML = html;
    container.insertAdjacentHTML('afterbegin', html);


    // Select order if specified
    if (selectedId) {
        selectRunningOrder(selectedId);
    }
        // After rendering HTML, initialize tooltips
     setTimeout(() => {
            try {
                if (typeof bootstrap !== 'undefined') {
                    const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                    tooltipTriggerList.map(function(tooltipTriggerEl) {
                        return new bootstrap.Tooltip(tooltipTriggerEl);
                    });
                }
            } catch (error) {
                console.error('Error initializing tooltips:', error);
            }
        }, 100);
    }

// Display balance orders
function displayBalanceOrders(orders,selectedId ='') {
    const container = document.getElementById('balance_order_main_div');

    if (!orders || orders.length === 0) {
        container.innerHTML = `
            <div class="text-center py-4">
                <i class="ti ti-cash-off text-muted fs-4 mb-2"></i>
                <p class="text-muted">No balance orders</p>
            </div>
        `;
        return;
    }

    let html = '';
    
    orders.forEach(order => {
        const isSelected = selectedId === order.order_id;

        // Order type color
        let typeClass = 'bg-secondary';
        if (order.order_type === 'Dine In') typeClass = 'bg-primary';
        if (order.order_type === 'Take Away') typeClass = 'bg-info';
        if (order.order_type === 'Delivery') typeClass = 'bg-danger';

        const formattedDate = formatDate(order.order_date);

        html += `
             <div class="order-card d-flex mb-1 border rounded-2 ${isSelected ? 'active' : ''}"
                id="balance-order-${order.order_id}"
                data-order-id="${order.order_id}"
                data-bs-toggle="tooltip"
                data-bs-placement="top"
                title="Customer: ${order.customer_name || 'No Customer'} | Staff: ${order.staff_fullname || 'No Staff'} | Date: ${formattedDate} | Total: ${currency_code} ${Number(order.total || 0).toLocaleString()} | Items: ${order.total_qty || 0}"
                style="cursor:pointer; font-size:11px;">

                <!-- Vertical Order Type Strip -->
                <div class="${typeClass} text-white d-flex align-items-center justify-content-center px-1"
                    style="writing-mode: vertical-rl; transform: rotate(180deg); font-size:10px; min-width:18px;
                        border-top-right-radius: 4px; border-bottom-right-radius: 4px;">
                    ${order.order_type || 'N/A'}
                </div>

                <!-- Card Content -->
                <div class="flex-grow-1 p-2">
                    <div class="d-flex justify-content-between align-items-start">

                        <!-- Left: Order Info -->
                        <div>
                            <div class="d-flex align-items-center gap-1 mb-1">
                                <strong class="text-primary">#${order.order_id}</strong>
                                <span class="status-dot status-running"></span>
                            </div>

                            <div class="text-muted fs-9">
                                <div class="d-flex align-items-center">
                                    <i class="ti ti-user me-1"></i>
                                    ${order.customer_name || 'No Customer'}
                                </div>
                                <div class="d-flex align-items-center ">
                                    <i class="ti ti-id-badge me-1"></i>
                                    ${order.staff_fullname || 'No Staff'}
                                </div>
                            </div>
                        </div>

                        <!-- Right: Amount + Qty -->
                        <div class="text-end">
                            <div class="fw-bold text-success lh-1">
                                NET ${Number(order.net_amount || 0).toLocaleString()}
                            </div>
                            <div class="fw-bold text-info lh-1">
                                PAID ${Number(order.paid_amount || 0).toLocaleString()}
                            </div>
                            <div class="fw-bold text-warning lh-1">
                                BAL ${Number(order.balance || 0).toLocaleString()}
                            </div>
                            <div class="text-muted" style="font-size:10px;">
                                ${formattedDate}
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        `;
    });

    container.innerHTML = html;
}

// Select running order
function selectRunningOrder(orderId) {
    // Deselect all
    document.querySelectorAll('.order-card').forEach(card => {
        card.classList.remove('active');
    });
    
    // Select this one
    const selectedCard = document.getElementById(`running-order-${orderId}`);
    if (selectedCard) {
        selectedCard.classList.add('active');
        selectedOrderId = orderId;
        
        // Update cart with selected order
        $("#table-new-order tbody").html('');
        modify_order(orderId);
    }
}

// Select balance order
function selectBalanceOrder(orderId) {
    // Deselect all
    document.querySelectorAll('.order-card').forEach(card => {
        card.classList.remove('active');
    });
    
    // Select this one
    const selectedCard = document.getElementById(`balance-order-${orderId}`);
    if (selectedCard) {
        selectedCard.classList.add('active');
        selectedOrderId = orderId;
        
        // Clear cart for balance orders
        clearCart();
    }
}

// Filter running orders
function filterRunningOrders(searchTerm) {
    if (!searchTerm) {
        displayRunningOrders(allRunningOrders, selectedOrderId);
        return;
    }
    
    const filtered = allRunningOrders.filter(order => {
        return (
            (order.order_id && order.order_id.toString().includes(searchTerm)) ||
            (order.customer_name && order.customer_name.toLowerCase().includes(searchTerm)) ||
            (order.staff_fullname && order.staff_fullname.toLowerCase().includes(searchTerm))
        );
    });
    
    displayRunningOrders(filtered);
}

// Filter balance orders
function filterBalanceOrders(searchTerm) {
    if (!searchTerm) {
        displayBalanceOrders(allBalanceOrders);
        return;
    }
    
    const filtered = allBalanceOrders.filter(order => {
        return (
            (order.order_id && order.order_id.toString().includes(searchTerm)) ||
            (order.customer_name && order.customer_name.toLowerCase().includes(searchTerm)) ||
            (order.staff_fullname && order.staff_fullname.toLowerCase().includes(searchTerm))
        );
    });
    
    displayBalanceOrders(filtered);
}

// Print selected bill
function printSelectedBill() {
    if (!selectedOrderId) {
        Swal.fire({
            icon: 'warning',
            title: 'Invalid Order',
            text: 'Please select a valid order first',
            customClass: {
                confirmButton: 'btn btn-danger',
                cancelButton: 'btn btn-secondary'
            }
        });
        return;
    }

    // Laravel route URL (Blade ke andar)
    const url = "{{ route('customer_order_view', ':order_id') }}".replace(':order_id', selectedOrderId);

    // Open in new tab
    window.open(url, '_blank');
}


// Cancel selected order
function cancelSelectedOrder() {
    // Validate selection
    if (!selectedOrderId || isNaN(selectedOrderId)) {
        Swal.fire({
            icon: 'warning',
            title: 'Invalid Order',
            text: 'Please select a valid order first',
            customClass: {
                confirmButton: 'btn btn-danger',
                cancelButton: 'btn btn-secondary' 
            }
        });
        return;
    }

    Swal.fire({
        title: 'Are you sure?',
        text: "This order will be cancelled!",
        icon: 'warning',
        showCancelButton: true,
        showCancelButton: true,
        confirmButtonText: 'Yes, cancel it',
        cancelButtonText: 'No',
        customClass: {
            confirmButton: 'btn btn-danger',
            cancelButton: 'btn btn-secondary' 
        }
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "{{ route('pos.cancelOrder') }}",
                type: "POST",
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'),
                    order_id: selectedOrderId
                },
                success: function (response) {
                    if(response.success){
                        $('running-order-'+selectedOrderId).remove();
                        clearCart();
                        Swal.fire(
                            'Cancelled!',
                            response.message || 'Order has been cancelled successfully.',
                            'success'
                        );
                    } else {
                        Swal.fire(
                            'Error!',
                            response.message || 'Failed to cancel the order.',
                            'error'
                        );

                    }
                },
                error: function (xhr) {
                    let message = 'Something went wrong';
                    if (xhr.status === 422 && xhr.responseJSON) {
                        message = Object.values(xhr.responseJSON.errors).join('\n');
                    } else if (xhr.responseJSON && xhr.responseJSON.message) {
                        message = xhr.responseJSON.message;
                    }
                    Swal.fire(
                        'Error!',
                        message,
                        'error'
                    );
                }
            });
        }
    });
}
// Helper functions
function getOrderTypeClass(orderType) {
    switch(orderType?.toLowerCase()) {
        case 'dine-in':
            return 'badge-dinein';
        case 'take away':
        case 'takeaway':
            return 'badge-takeaway';
        case 'delivery':
            return 'badge-delivery';
        default:
            return 'bg-secondary';
    }
}

function getOrderTypeIcon(orderType) {
    switch(orderType?.toLowerCase()) {
        case 'dine-in':
            return '🍽️';
        case 'take away':
        case 'takeaway':
            return '🥡';
        case 'delivery':
            return '🚚';
        default:
            return '📝';
    }
}

function formatDate(dateString) {
    if (!dateString) return 'N/A';
    
    try {
        const date = new Date(dateString);
        return date.toLocaleDateString('en-US', {
            month: 'short',
            day: 'numeric',
            hour: '2-digit',
            minute: '2-digit',
            hour12: false 
        });
    } catch (e) {
        return dateString;
    }
}

function formatCurrency(amount) {
    return new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: currency_code,
        minimumFractionDigits: 0
    }).format(amount || 0);
}

// These functions should be defined elsewhere in your code
function modify_order(orderId) {
    $.ajax({
        url: "{{ route('pos.order_details') }}",
        type: "GET",
        data: {
            _token: csrf_token,
            order_id: orderId,
            businessid: '{{ session('business_id') ?? 0 }}',
        },
        dataType: "json",
        success: function(response) {
            $("#view_advance_section").removeClass('d-none');
            if (response.order_id > 0) {

                $('.order_type_btn').each(function () {
                    if ($(this).data('typeid').toLowerCase() === response.order_type.toLowerCase()) {
                        $(this).addClass('active');
                    }else{
                        $(this).removeClass('active');
                    }
                });

                /* =========================
                   SET CUSTOMER
                ========================= */
                $("#for_appending_customers").val(response.id_customers);
                $("#customer_name_for_display").html(response.customer_name);

                let option = new Option(
                    response.customer_name,
                    response.id_customers,
                    true,
                    true
                );
                $('#for_customer_search_customers')
                    .append(option)
                    .trigger('change');

                /* =========================
                   SET STAFF
                ========================= */
                if (response.id_staff) {
                    $("#for_appending_staffs")
                        .val(response.id_staff)
                        .trigger('change');
                }

                /* =========================
                   SET ORDER NUMBER
                ========================= */
                $("#order_number").text(response.order_id);
                $("#order_description").val(response.order_description);

                /* =========================
                   ADD PRODUCTS TO CART
                ========================= */
                if (response.products && response.products.length > 0) {
                     let categoryMap = {};
                    $("#table-new-order tbody").html('');
                    // Optional: clear previous cart
                    // $("#cart_table tbody").html('');

                    response.products.forEach(function (item) {

                        if (item.product_category) {
                            let cat = item.product_category.trim().toLowerCase();

                            if (!categoryMap[cat]) {
                                categoryMap[cat] = {
                                    id: item.product_category.trim(),
                                    name: item.product_category.trim()
                                };
                            }
                        }

                        add_product_to_cart_table(
                            item.product_name,                     
                            item.product_id,                 
                            parseFloat(item.product_unit_price),  
                            parseFloat(item.product_sale_tax_percentage), 
                            item.product_id,                     
                            item.category,                         
                            item.business_brand_id,              
                            item.batch_id,                      
                            item.batch,                          
                            item.qty,                          
                            response.order_id ,
                            item.product_discount_amount 
                        );
                    });

                    let categories = Object.values(categoryMap || {});
                    if (Array.isArray(categories) && categories.length) {
                        openCategoryModal(categories, response.order_id);
                    }

                }

            }
        },
        error: function () {
            console.log("FAILED TO FETCH ORDER DETAIL.");
        }
    });
}


let recentInvoicesTable;

function getting_recent_invoices() {
    const El = document.getElementById('recentInvoicesModal');
    const modal = new bootstrap.Modal(El);
    modal.show();

    
    if ($.fn.DataTable.isDataTable('#recentInvoicesTable')) {
        $('#recentInvoicesTable').DataTable().destroy();
    }


    recentInvoicesTable = $('#recentInvoicesTable').DataTable({
        processing: true,
        serverSide: false, 
        ajax: {
            url: "{{ route('pos.getting_recent_invoices') }}",
            type: "POST",
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            data: { businessid: '{{ session('business_id') ?? 0 }}' },
            dataSrc: ''
        },
        columns: [
            { data: null, render: (data, type, row, meta) => meta.row + 1 }, // serial #
            { data: 'invoice_number', defaultContent: '-' },
            { data: 'order_id', defaultContent: '-' },
            { data: 'invoice_date' },
            { data: 'customer_name', defaultContent: '-' },
            { data: 'staff_fullname', defaultContent: '-' },
            { data: 'net_amount' },
            { data: 'paid_amount' },
            { data: 'balance' },
            {
                data: null,
                orderable: false,
                searchable: false,
                render: function (data, type, row) {
                    const printRoute = 'existing_retail_invoice/' + row.invoice_id;
                    return `
                        <a target="_blank" href="${printRoute}" 
                           class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-info open-btn">
                            <iconify-icon icon="line-md:watch-loop" class="fs-18"></iconify-icon>
                        </a>
                        <button onclick="cancelinvoice(
                            '${row.invoice_id}',
                            '${row.invoice_type}',
                            null
                        )"
                        class="btn flex-shrink-0 rounded-circle btn-icon btn-ghost-danger">
                            <iconify-icon icon="solar:trash-bin-trash-bold-duotone" class="fs-18"></iconify-icon>
                        </button>
                    `;
                }
            }
        ],
        order: [[1, 'desc']], // newest first
        lengthChange: false,
        pageLength: 50
    });
}




function generateInvoice(orderId) {

    if (!orderId) {
        Swal.fire({
            icon: 'warning',
            title: 'Required',
            text: 'Please enter Order ID',
            confirmButtonText: 'OK'
        });
        return;
    }

    // Loading state
    $('#invoiceModalBody').html(`
        <div class="text-center py-5">
            <div class="spinner-border text-primary"></div>
            <p class="mt-2 text-muted">Generating invoice...</p>
        </div>
    `);

    invoiceModal.show();

    $.ajax({
        url: "{{ route('new_retail_invoice', ['order_id' => ':order_id']) }}".replace(':order_id', orderId),
        type: 'GET',
        data: { ajax_request: 'Yes' },
        dataType: 'html',
        headers: { 'X-CSRF-TOKEN': csrf_token },

        beforeSend() {
            $('#generateInvoiceBtn')
                .prop('disabled', true)
                .html('<i class="ti ti-loader me-1"></i> Processing...');
        },

        success(response) {
            $('#invoiceModalBody').html('');
            $('#invoiceModalBody').html(response);
            if (!invoiceInitialized) {
                invoiceInitialized = true;

                setTimeout(() => {
                    document
                        .querySelectorAll('select[id^="order_discount_type_"]')
                        .forEach(el => {
                            if (el && !el.disabled && el.selectedIndex !== -1) {
                                el.dispatchEvent(new Event('change', { bubbles: true }));
                            }
                        });

                    paymentModeChange('Cash');
                }, 300); 
            }
        },

        error(xhr) {
            $('#invoiceModalBody').html(`
                <div class="text-center py-5">
                    <i class="ti ti-alert-circle text-danger fs-1"></i>
                    <h5 class="text-danger mt-2">Error</h5>
                    <p class="text-muted">Invoice load failed</p>
                </div>
            `);
        },

        complete() {
            $('#generateInvoiceBtn')
                .prop('disabled', false)
                .html('<i class="ti ti-file-invoice me-1"></i> Generate Invoice');
        }
    });
}


function openCategoryModal(categories, order_id) {
    // Clear previous tabs
    $('#categoryTabsNav').empty();
    $('#categoryTabsContent').empty();

    let hasAnyForm = false;

    categories.forEach((category, index) => {
        let tabId = 'categoryTab' + category.id;

        $('#categoryTabsNav').append(`
            <li class="nav-item">
                <a href="#${tabId}" class="nav-link" data-bs-toggle="tab">
                    ${category.name}
                </a>
            </li>
        `);

        $('#categoryTabsContent').append(`
            <div class="tab-pane" id="${tabId}" data-category="${category.id}">
                <div class="category-form-loading text-center py-3">Loading form...</div>
            </div>
        `);

        // Fetch form
        $.ajax({
            url: "{{ route('pos.product_categories_form', ':id') }}".replace(':id', category.id),
            type: 'GET',
            data: {
                _token: csrf_token,
                order_id: order_id
            },
            success: function(response) {
                if (response && response.form_schema) {
                    hasAnyForm = true; // 👈 at least one form found
                    $('#' + tabId).html(renderForm(response.form_schema));

                    // First valid tab ko active karo
                    if (!$('#categoryTabsNav a.active').length) {
                        $('#categoryTabsNav a[href="#' + tabId + '"]').addClass('active');
                        $('#' + tabId).addClass('show active');
                    }
                } else {
                    $('#' + tabId).remove();
                    $('#categoryTabsNav a[href="#' + tabId + '"]').parent().remove();
                }
            },
            error: function() {
                $('#' + tabId).remove();
                $('#categoryTabsNav a[href="#' + tabId + '"]').parent().remove();
            },
            complete: function () {
                // LAST AJAX ke baad modal decision
                if (
                    categories.indexOf(category) === categories.length - 1 &&
                    hasAnyForm
                ) {
                    $("#orderIdForCategoryForm").text(order_id);
                    let El = document.getElementById('categoryTabsModal');
                    let modal = new bootstrap.Modal(El);
                    modal.show();
                }
            }
        });
    });
}

function renderForm(schema) {
    return `
        <div class="form-wrapper" data-schema='${JSON.stringify(schema)}'>
            ${buildFields(schema)}
        </div>
    `;
}
function buildFields(schema) {
    let html = '<div class="row">';

    schema.sections.forEach(section => {
        html += `
            <div class="col-md-6 mb-4 p-3 border border-dashed border-primary">
                <h5 class="text-center">${section.title}</h5>
                <div class="row">
        `;

        section.fields.forEach(field => {
            let value = field.value ?? '';

            let input = '';

            if (field.type === 'textarea') {
                input = `
                    <textarea class="form-control" name="${field.name}">${value}</textarea>
                `;
            } else {
                input = `
                    <input 
                        type="${field.type}" 
                        class="form-control" 
                        name="${field.name}" 
                        value="${value}"
                    >
                `;
            }

            html += `
                <div class="col-md-6 mb-2">
                    <label>${field.label}</label>
                    ${input}
                </div>
            `;
        });

        html += `</div></div>`;
    });

    html += `</div>`;
    return html;
}



function saveCategoryForms() {
    let payload = [];
    $('#categoryTabsContent .tab-pane').each(function () {
        let category = $(this).data('category');
        let schema = $(this).find('.form-wrapper').data('schema');

        schema.sections.forEach(section => {
            section.fields.forEach(field => {
                let val = $(this)
                    .find(`[name="${field.name}"]`)
                    .val();

                field.value = val ?? '';
            });
        });
        payload.push({
            category: category,
            form_data: schema
        });
    });

    $.ajax({
        url: '{{ route('pos.save_customer_order_product_categories_form') }}',
        type: 'POST',
        dataType: 'json',
        data: {
            _token: csrf_token,
            order_id: $.trim($('#orderIdForCategoryForm').text()),
            data: payload
        },
        success: function (response) {
            if (response.success) {
              
                Swal.fire({
                        title: 'Saved!',
                        text:response.message ?? 'Form saved successfully',
                        icon: 'success',
                        confirmButtonText: 'OK',
                        customClass: {
                            confirmButton: 'btn btn-success'
                        }
                    });
            const el = document.getElementById('categoryTabsModal');
            const modal = bootstrap.Modal.getInstance(el) || new bootstrap.Modal(el);
            modal.hide();
            } else {
                Swal.fire('Warning', response.message ?? 'Something went wrong', 'warning');
            }
        },
        error: function (xhr) {
            let message = 'Something went wrong. Please try again.';
            if (xhr.status === 422 && xhr.responseJSON?.errors) {
                message = Object.values(xhr.responseJSON.errors)
                    .map(err => err[0])
                    .join('\n');
            } else if (xhr.status === 500) {
                message = xhr.responseJSON?.message ?? 'Server error occurred';
            } else if (xhr.status === 419) {
                message = 'Session expired. Please refresh the page.';
            }
            Swal.fire('Error', message, 'error');
        }
    });
}
function toggleAdvancePOS(){
    $('#advance-pos-section').toggleClass('d-none');
}

function hideAdvancePOS(){
    $('#advance-pos-section').addClass('d-none');
}

function payment_mode_changed(){

    var payment_mode = $("#product_order-adv-mode option:selected").val();
    var cc_charge = parseFloat($("#business-cc-fee-percent").val() || 0) ;
    $("#product_order-adv-cc-inst").val("");
    $("#product_order-adv-ccfee").val("0.00");
    $("#product_order-adv-amount").val("");
    if(payment_mode=="Cash"){                  
        $("#div-cc-inst").addClass("d-none");
    }else{
        $("#div-cc-inst").removeClass("d-none");                 
    }

    if(payment_mode == "Card"){
        $("#div-cc-fee").removeClass("d-none"); 
        $("#product_order-adv-ccfee").val(cc_charge.toFixed(2));           
    }else{
        $("#div-cc-fee").addClass("d-none");
    }
 } 


    function add_advance(){

        document.getElementById('btn-add-adv').disabled=true;
        var customer_order_id = $("#order_number").text() || '';
        if(customer_order_id ==''){
            Swal.fire({
                icon: 'info',
                title: 'No Order Selected',
                text: 'Please select an order to add advance payment.',
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                        confirmButton: 'btn btn-info'
                    }
            });
            //enable btn
            document.getElementById('btn-add-adv').disabled=false;
            return;

        }

        var advance_amount = $("#product_order-adv-amount").val() || 0;

        if(advance_amount <= 0 || advance_amount =='' ){
            Swal.fire({
                icon: 'info',
                title: 'Invalid Amount',
                text: 'Please enter a valid advance amount greater than zero.',
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                            confirmButton: 'btn btn-info'
                        }
            });
            document.getElementById('btn-add-adv').disabled=false;
            return;
        }

        var payment_mode = $("#product_order-adv-mode option:selected").val();
        var advance_comment = $("#product_order-adv-comment").val();
        var inst_number = $("#product_order-adv-cc-inst").val();
        var cc_fee = $("#product_order-adv-ccfee").val();
        var customer_name = $("#customer_name_for_display").text() || '';
        var id_customer = $("#for_appending_customers").val() || 0;
        if(id_customer == 0 || id_customer == ''){
            Swal.fire({
                icon: 'info',
                title: 'No Customer Selected',
                text: 'Please select a customer to add advance payment.',
                buttonsStyling: false,
                confirmButtonText: "Ok",
                customClass: {
                            confirmButton: 'btn btn-info'
                        }
            });
            //enable btn
            document.getElementById('btn-add-adv').disabled=false;
            return;
        }

        $('#btn-add-adv').prop('disabled', true);
        $.ajax({
            url: "{{ route('pos.add_customer_order_advance') }}",
            type: "POST",
            dataType: "json",
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: {
                customer_order_id: customer_order_id,
                business_id: business_id,
                id_customer: id_customer,
                customer_name: customer_name,
                advance_amount: advance_amount,
                advance_comment: advance_comment,
                inst_number: inst_number,
                cc_fee: cc_fee,
                payment_mode: payment_mode,
                add_advance: "true"
            },

            success: function (data) {

                Swal.fire({
                    icon: data.message_type || 'success',
                    title: data.message_type === 'success' ? 'Success' : 'Info',
                    text: data.message || 'Operation completed',
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: 'btn btn-info'
                    }
                });

                // Reset form
                $("#product_order-adv-amount").val("");
                $("#product_order-adv-comment").val("");
                $("#product_order-adv-ccfee").val("");
                $("#product_order-adv-cc-inst").val("");
                $("#product_order-adv-mode").prop("selectedIndex", 0).trigger("change");
                $('#btn-add-adv').prop('disabled', false);
                toggleAdvancePOS();
            },

            error: function (xhr, status, error) {

                $('#btn-add-adv').prop('disabled', false);

                let message = 'Something went wrong. Please try again.';

             
                if (xhr.status === 422 && xhr.responseJSON?.errors) {
                    message = Object.values(xhr.responseJSON.errors)
                        .map(err => err[0])
                        .join('\n');

               
                } else if (xhr.status === 500 && xhr.responseJSON?.message) {
                    message = xhr.responseJSON.message;

            
                } else if (status === 'timeout' || status === 'error') {
                    message = 'Network error. Please check your internet connection.';
                }

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: message,
                    buttonsStyling: false,
                    confirmButtonText: "Ok",
                    customClass: {
                        confirmButton: 'btn btn-danger'
                    }
                });

                console.error("AJAX Error:", {
                    status: xhr.status,
                    response: xhr.responseJSON,
                    error: error
                });
            }
        });

    } 

    function cancelinvoice(invoiceid, invoice_type, imsfiscal_invoice_number){
        // Warning Message
        Swal.fire({
            input: "text",
            inputLabel: "Give Reason For Cancelling This Invoice:",
            inputPlaceholder: "Reason for cancelling...",
            inputAttributes: {
                "aria-label": "Reason for cancelling"
            },
            showCancelButton: true,
            icon: "question",
            customClass: {
                confirmButton: 'btn btn-primary me-2',
                cancelButton: 'btn btn-secondary'
            },
            buttonsStyling: false,
            target: document.querySelector('#recentInvoicesModal')
        }).then((result) => {
            if (result.isConfirmed) {
                var reason = result.value;
                if(reason == "") {
                    Swal.fire({
                        title: "Oops!",
                        text: "You need to write something!",
                        icon: "error",
                        customClass: {
                            confirmButton: "btn btn-danger"
                        }
                    });
                    return false;
                } else {
                    // Check if imsfiscal number is present (posted invoice)
                    if(imsfiscal_invoice_number && imsfiscal_invoice_number !== 'null'){
                        Swal.fire({
                            title: "Oops!",
                            text: "Connected with IMS Fiscal. You Cannot Cancel Invoices!",
                            icon: "error",
                            customClass: {
                                confirmButton: "btn btn-danger"
                            }
                        });
                        return false;
                    }

                    // Proceed with cancellation
                    $.ajax({
                        type: 'POST',
                        url: "{{ route('cancel_invoice') }}",
                        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                        dataType: 'json',
                        data: {id_invoice: invoiceid, cancel_reason: reason},
                        success: function(data) {
                            var btn = "btn btn-" +  data.message_btn;
                            Swal.fire({
                                icon: data.message_type,
                                buttonsStyling: false,
                                confirmButtonText: "Ok",
                                customClass: {
                                    confirmButton: btn
                                }
                            }).then(() => {
                                if(data.message_type == 'success'){
                                    // Refresh modal DataTable if open
                                    if($.fn.DataTable.isDataTable('#recentInvoicesTable')){
                                        $('#recentInvoicesTable').DataTable().ajax.reload();
                                    }
                                    orderLastUpdatedAt =null;
                                    getting_runing_order();
                                }
                            });
                        },
                        error: function(){
                            Swal.fire({
                                icon: "error",
                                text: "Something went wrong while cancelling invoice!",
                                confirmButtonClass: "btn btn-danger",
                                buttonsStyling: false
                            });
                        }
                    });
                }
            }
        });
    }


    //on scroll close tooltips
    $(window).on('scroll', function () {
            $('[data-bs-toggle="tooltip"]').each(function () {
                let instance = bootstrap.Tooltip.getInstance(this);
                if (instance) {
                    instance.hide();
                }
            });
    });

   
   
   // Keyboard shortcuts function
function initializeKeyboardShortcuts() {
    $(document).off('keydown.shortcuts').on('keydown.shortcuts', function(e) {
        // Ctrl + Q: Quick search focus
        if (e.ctrlKey && e.key === 'q') {
            e.preventDefault();
            $('#searchItemList').focus().select();
        }
        
        // Ctrl + C: Clear cart
        if (e.ctrlKey && e.key === 'c') {
            e.preventDefault();
            clearCart();
        }
        
        // Ctrl + P: Place order
        if (e.ctrlKey && e.key === 'p') {
            e.preventDefault();
            $('#add_place_order').click();
        }
        
        // Ctrl + I: Generate invoice
        if (e.ctrlKey && e.key === 'i') {
            e.preventDefault();
            $('#create_quick_invoice').click();
        }
        
        // Ctrl + F: Fullscreen toggle
        if (e.ctrlKey && e.key === 'f') {
            e.preventDefault();
            toggleFullScreen();
        }
        
        // Ctrl + R: Refresh orders
        if (e.ctrlKey && e.key === 'r') {
            e.preventDefault();
            $('#refresh_runing_orders').click();
        }
        
        // F2: Focus customer search
        if (e.key === 'F2') {
            e.preventDefault();
            $('#for_customer_search_customers').select2('open');
        }
        
        // F3: Focus staff selection
        if (e.key === 'F3') {
            e.preventDefault();
            $('#for_appending_staffs').focus();
        }
        
        // ESC: Clear search/close modals
        if (e.key === 'Escape') {
            $('#searchItemList').val('').trigger('input');
            const openModal = document.querySelector('.modal.show');
            if (openModal) {
                bootstrap.Modal.getInstance(openModal)?.hide();
            }
        }
    });
}

function open_new_customer_modal(){
    
    var customerModalEl = document.getElementById('customerAddModal');
    if (customerModalEl) {
        var customerModal = new bootstrap.Modal(customerModalEl, {
            backdrop: 'static',
            keyboard: false
        });
        customerModal.show();
    }
}

</script>   
@endsection