@extends('layouts.horizontal', ['title' => 'Print View', 'topbarTitle' => 'Print View', 'nonav' => true])

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div id="cash_register_modal_content">
                            <!-- Cash register print content will be injected here -->
                             <input type="hidden" id="calendardate" value="{{ $register_date }}">
                             @include('modals.cash_register')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>  
    
@endsection

@section('scripts')
@vite(['resources/js/modals/cash_register.js'])
    <script>
        let baseURL = '{{ url("") }}'; // Use relative paths
        // Automatically open the cash register modal when the page loads
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById("cash_register_modal").classList.remove('modal');
            document.getElementById("cash_register_modal").classList.remove('fade');
            document.getElementById("cash_register_modal").classList.add('card');

            $("#cash_register_modal_dialog").removeClass('modal-dialog');
            $("#cash_register_modal_dialog").removeClass('modal-lg');
            $("#cash_register_modal_dialog").removeClass('modal-dialog-scrollable');
            $("#cash_register_modal_dialog").addClass('card-body');

            //hide buttons
            document.getElementById("saveCashRegisterBtn").style.display = "none";
            document.getElementById("cashRegisterPrintButton").style.display = "none";
            document.getElementById("btnCashRegisterReopen").style.display = "none";

            document.getElementById("cash_register_modal_body").classList.remove('fs-13');
            document.getElementById("cash_register_modal_body").classList.add('fs-12');

            $(".table").addClass('table-sm');

            //add a print class to body
            document.body.classList.add('print-view');

            getCashRegisterData();

            //add a print button to the top right corner
            let printButton = document.createElement('button');
            printButton.textContent = "Print";
            printButton.classList.add('btn', 'btn-primary', 'd-print-none');
            // printButton.style.position = 'absolute';
            // printButton.style.top = '100px';
            // printButton.style.right = '50px';
            printButton.addEventListener('click', function() {
                window.print();
            });

            document.getElementsByClassName("modal-footer")[0].appendChild(printButton);

            document.getElementsByClassName("btn-close")[0].classList.add('d-none');

            // document.body.appendChild(printButton);

            // var cashRegisterModal = new bootstrap.Modal(document.getElementById('cashRegisterModal'));
            // cashRegisterModal.show();
        });

    </script>


@endsection