@extends('layouts.horizontal', ['title' => 'Scheduler', 'topbarTitle' => 'Scheduler'])

@section('css')
@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])

    <link href="{{ asset('vendor/scheduler/scheduler.min.css') }}" rel="stylesheet" />
    
    <style>
        /* Custom styles for the scheduler */
        .page-container {
            max-width: 98% !important;
            margin: 0 auto;
        }

        .spin {
            display: inline-block;
            animation: spin 3s linear infinite;
        }

        @keyframes spin {
            0%   { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .fc-resourceTimeGridDay-view .fc-view .fc-timegrid,
        .fc-resourceTimeGridDay-view .fc-view .fc-timegrid .fc-timegrid-slot,
        .fc-resourceTimeGridDay-view .fc-view .fc-timegrid .fc-timegrid-col {
            background-color: var(--bs-body-bg) !important;            
            color: var(--bs-body-color); /* fallback to white if var missing */

            background-color: #37394dff !important;
            color : #fff !important;
        }

        .fc-time-grid .fc-slats tr>td {
            height: 2em !important;
        }

        .fc-time-grid-event .fc-title {
            padding: 2px 2px;
        }

        .fc-time-grid .fc-event,
        .fc-time-grid .fc-bgevent {
            margin: 5px;
        }

        .fc-today {
            background: transparent;
        }

        .fc-time-area .fc-widget-header {

            font-weight: normal;
        }

        .fc-timeline-event .fc-content {
            white-space: normal !important;
        }

        .fc-resource {
            background-position: center bottom !important;
            color: #000;
            font-size: 10px;

        }

        /* Styles added to show Horizontal Scroll Bar */
        .fc-view {
            width: auto;
        }

        .fc-view-harness .fc-view {
            height: 450px;
            overflow-x: scroll;
            overflow-y: scroll;
        }

        .fc-view-harness .fc-view>table {
            background-color: transparent;
            width: auto;
        }

        .fc .fc-col-header-cell-cushion {
            color: #ffffff;
        }


        .fc .fc-col-header-cell{
            background-color: var(--bs-body-bg) !important;
            color: #ffffff !;
        }

        .fc .fc-timegrid-slot-label-cushion {
            font-size: 11px;
            
            text-align: center !important;
        }
        th.fc-timegrid-axis {
            width: 55px;
        }

        /* Every full hour slot */
        .fc-timegrid-slot[data-time$="00:00"] {
            border-top: 1px solid #797979;
            font-weight: bold;
        }

        /* Every half-hour slot */
        .fc-timegrid-slot[data-time$="30:00"] {
            border-top: 1px dashed #ccc;
        }

        /* Control row height */
        .fc-timegrid-slot {
            height: 2em !important;
            
        }

        .fc-day-today {
            background: transparent !important;
        }

        .fc-resource {
            width:55px;
        }

        
        .fc-timegrid-event-harness {
            overflow: hidden;
        }

        .eventClass {
            font-size: 11px !important;
            font-weight: lighter !important;
            text-align: left !important;
            white-space: normal !important;   /* allow wrapping */
            overflow: hidden !important;     /* don't clip text */
            text-overflow: unset !important;  /* kill ellipses */
            line-height: 1.2em !important;    /* tighten spacing */
            height: auto !important;          /* let height expand with content */
        }
        .eventClass .fc-event-title,
        .eventClass .fc-event-main {
            white-space: normal !important;
            overflow: visible !important;
            text-overflow: unset !important;
            /* font-weight:200 !important; */
        }

        ul{
            padding-left: 0.5rem;
        }
        ul .active{
            /* background-color: rgba(85,110,230,.1) !important; */
            border-radius: var(--bs-border-radius)!important;
            --bs-bg-opacity: 1;
            background-color: rgba(var(--bs-body-bg-rgb),var(--bs-bg-opacity))!important;
            padding: 0.5rem!important;
            
        }
        li{
            list-style-type: none;
            margin-bottom: 0;
            font-size:12px;
        }
        .visit-list-div{
            margin:0;
            padding:0;
        }
        

        /* Scrollbar container */
        ::-webkit-scrollbar {
            width: 6px;      /* vertical scrollbar width */
            height: 6px;     /* horizontal scrollbar height */
        }

        /* Scrollbar track (background) */
        ::-webkit-scrollbar-track {
            background: #f9f9f9;
            border-radius: 10px;
        }

        /* Scrollbar thumb (the draggable part) */
        ::-webkit-scrollbar-thumb {
            background: #f1f1f1;
            border-radius: 10px;
        }

        /* Hover effect on thumb */
        ::-webkit-scrollbar-thumb:hover {
            background: #37394d;
        }

        .fullscreen-div {
            width: 100vw;
            height: 100vh;                
        }

        .toast-success {
            background-color: #51A351 !important;
            opacity: 1 !important;
        }

        .toast-error {
            background-color: #BD362F !important;
            opacity: 1 !important;
        }

        .toast-info {
            background-color: #2F96B4 !important;
            opacity: 1 !important;
        }

        .toast-warning {
            background-color: #F89406 !important;
            opacity: 1 !important;
        }


    </style>

@endsection

@section('content')
<div id="scheduler">
     <!-- start page title -->
    <div class="row mb-2">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h4 class="mb-0" id="forecast-banner">Scheduler</h4>
                <div class="page-title-right d-p-hidden d-md-block">
                    @if($business->imsfiscal == 'Yes' || $business->imsfiscalr == 'Yes' || $business->srb_fiscal_service == 'Yes' || $business->srb_fiscal_retail == 'Yes')
                    <button class="btn btn-md btn-dark me-2"><iconify-icon icon="material-symbols-light:receipt-long-outline-rounded" class="fs-16"></iconify-icon>  UnPosted Invoices</button></li>
                    @endif
                    <button id="btnCashRegister" class="btn btn-outline-dark me-2" ><iconify-icon icon="streamline-sharp:cashier-machine-2" class="align-middle me-1 fs-18"></iconify-icon>  Cash Register</button></li>
                    <button id="btnTillClose" class="btn btn-outline-success"><iconify-icon icon="fe-lock" class="align-middle me-1 fs-18"></iconify-icon>  Close Till</button></li>                    
                    <button class="btn btn-outline-danger"><iconify-icon icon="icon-park-outline:face-recognition" class="align-middle me-1 fs-18"></iconify-icon>  Attendance</button></li>
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row" id="calendar-row">
        <div class="col-12">
            <div class="row g-0">
                <div class="col-10" id="calendar-col">
                    <div class="card">
                        <div class="card-body">
                            <input type="hidden" id="lastupdatedate" value="" />
                            <input type="hidden" id="calendardate" value="" />
                            <input type="hidden" id="newdate" value="0" />
                            <div id="calendar" style="height: 450px;"></div>
                            <div id="calendarOverlay" style="height: 100%; width: 100%; position: absolute; top: 20px; left: 20px; z-index: 5; background: #fff; opacity: 0.6; text-align: center;">
                                <img style="height: 50px; margin-top: 180px;" src="{{ asset('images/spin-pink.gif') }}">
                            </div>
                        </div> <!-- end card body-->
                    </div> <!-- end card -->
                </div> <!-- end col -->

                <div class="col-2" id="visit-col">
                    <div class="card m-0 p-0" id="visit-card">
                        <div class="card-header d-flex align-items-center m-1 p-1">
                            <h4 class="card-title mb-0 text-muted flex-grow-1">Visits</h4>
                            <div class="flex-shrink-0">                                
                                <iconify-icon onclick="contract_visits();" icon="solar:hamburger-menu-broken" style="font-size: 24px; cursor:pointer;" class="text-muted mt-1 me-1"></iconify-icon>
                                <iconify-icon onclick="expand();" icon="tabler:screen-share" style="font-size: 24px; cursor:pointer;" class="text-muted mt-1 me-1 d-none"></iconify-icon>
                                <iconify-icon id="refreshCalendar" icon="solar:refresh-circle-broken" style="font-size: 24px; cursor:pointer;" class="text-muted mt-1 me-1"></iconify-icon>
                            </div>
                        </div>
                        <div class="card-body" class="p-0 m-0" style="margin: 0px; padding: 0px;">     
                            <div class="mt-1 pe-2 ps-0">
                                <input type="hidden" id="lastvisitcolor" value="" />
                                <input type="date" id="move-to-date" class="form-control form-control-sm" value="{{ date('Y-m-d') }}">
                            </div>
                            <div id="visit-search-div" class="mt-1 pe-2 ps-0">
                                <input class="form-control form-control-sm mb-1 search" id="visit-search" type="text" placeholder="Search..">         
                            </div>
                            <div id="visit-container" class="visit-list-div" class="list-group m-0 p-0" style="max-height: 500px; overflow-y: auto;">  
                                <!-- Visit items will be dynamically added here -->
                                <ul id="visit-list" class="list p-1" >
                                    <!-- Example visit item -->
                                    <li class="list-item" data-bs-toggle="tooltip" data-bs-placement="left" data-html="true" title="Visits - Of - They - Day">
                                        <div style="background-color: #8d5c86ff; color: #ffffff; padding: 0.5rem; border-radius: var(--bs-border-radius);">
                                            <strong>Waiting For</strong><br>
                                            <span>Data</span><br>
                                            <span>555-1234</span><br>
                                            <span>Scheduled : Today</span>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div> <!-- end card body-->
                    </div> <!-- end card -->
                   </div>
                </div> <!-- end col-->
            </div>  <!-- end row -->
            <!-- Add New Event MODAL -->
            <div class="modal fade" id="staff-detail-modal" tabindex="-1">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header py-3 px-4 border-bottom-0 d-block">
                            <button type="button" class="btn-close float-end" data-bs-dismiss="modal" aria-label="Close"></button>
                            <h5 class="modal-title" id="modal-title">Staff: <span id="staff-modal-name"></span></h5>
                        </div>
                        <div class="modal-body px-4 pb-4 pt-0">
                            <form class="needs-validation" name="staff-modal-form" id="form-event" novalidate>
                                <div class="row">
                                    <div class="col-2">
                                        <div class="mb-3">
                                            <label class="form-label">Staff ID</label>
                                            <input class="form-control" type="text" name="resource-details-id" id="resource-details-id" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-7">
                                        <div class="mb-3">
                                            <label class="form-label">Staff Name</label>
                                            <input class="form-control" type="text" name="resource-details-name" id="resource-details-name" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-lable">Designation</label>
                                            <input class="form-control" type="text" name="resource-details-designation" id="resource-details-designation" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-lable">Floor</label>
                                            <input class="form-control" type="text" name="resource-details-floor" id="resource-details-floor" readonly/>
                                        </div>
                                    </div>                                    
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-lable">Start Hours</label>
                                            <input class="form-control" type="text" name="resource-details-start-hours" id="resource-details-start-hours" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-lable">End Hours</label>
                                            <input class="form-control" type="text" name="resource-details-end-hours" id="resource-details-end-hours" readonly/>
                                        </div>
                                    </div>
                                    
                                    <div class="col-3">
                                        <div class="mb-3">
                                            <label class="form-lable">Off Days</label>
                                            <input class="form-control" type="text" name="resource-details-days-off" id="resource-details-days-off" readonly/>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="mb-3">
                                            <label class="form-label">Block Staff</label>
                                            <select class="form-control" placeholder="Select Reason" type="text" name="block_reason" id="block_reason">
                                                <option value="" selected>Select Reason</option>
                                                @foreach($staff_block_reasons as $reason)
                                                    <option value="{{ $reason->id_block_events }}">{{ $reason->block_event_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="mb-3">
                                            <label class="form-label">From:</label>
                                            <input type="datetime-local form-control" id="block_start" name="block_start" class="form-control staff-blocking-date-time flatpickr"/>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="mb-3">
                                            <label class="form-label">To:</label>
                                            <input type="datetime-local form-control" id="block_end" name="block_end" class="form-control staff-blocking-date-time flatpickr"/>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="mb-3">
                                            <label class="form-label">&nbsp;</label>
                                            <button type="button" onclick="$('#block_start').val('{{ substr($business->business_opening_time,0,5) }}'); $('#block_end').val('{{ substr($business->business_closing_time,0,5) }}');" class="btn btn-primary btn-sm w-100 mt-1" id="btn-add-blocking">All Day</button>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12">
                                        <div class="mb-3">
                                            <table class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>Existing Blockings</th>
                                                        <th>From</th>
                                                        <th>To</th>
                                                        <th>Reason</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="staff-blocking-events-tbody">
                                                    <!-- Existing blocking events will be populated here -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-2">
                                    <div class="col-md-6 col-4">                                        
                                    </div>
                                    <div class="col-md-6 col-8 text-end">
                                        <button type="button" class="btn btn-light me-1" data-bs-dismiss="modal">Close</button>
                                        <button type="button" onclick="save_staff_blocking()" class="btn btn-success" id="btn-save-event">Save</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div> <!-- end modal-content-->
                </div> <!-- end modal dialog-->
            </div>
            <!-- end modal-->
        </div>
    </div>
</div>
@include('modals.cash_register')
@include('modals.customer_add')
@include('modals.cash_till')

@endsection

@include('modals.visit_details')

@vite(['resources/js/modals/cash_register.js'])
@vite(['resources/js/modals/customer_add.js'])
@vite(['resources/js/modals/cash_till.js'])
<script src="{{ asset('vendor/scheduler/index.global.min.js') }}" ></script>

<script>
    let baseURL = '{{ url("") }}'; // Use relative paths
    let intervalID;
    document.addEventListener('DOMContentLoaded', function () {

        flatpickr(".staff-blocking-date-time", {
            enableTime: true,
            noCalendar: true,
            dateFormat: "H:i",
            time_24hr: true,
            minuteIncrement: 15,
            minTime: "{{ $business->business_opening_time }}",
            maxTime: "{{ $business->business_closing_time }}",
        });

        $("#visit-details-modal-service-types .list .id-service-type-item").remove();
       
        // btnCashRegister click handler
        document.getElementById('btnCashRegister').addEventListener('click', function() {

            var cashRegisterModal = new bootstrap.Modal(document.getElementById('cash_register_modal'));
            cashRegisterModal.show();

        });

        // btnTillClose click handler
        document.getElementById('btnTillClose').addEventListener('click', function() {

            document.getElementById('till_close_modal_date_input').value = $('#lastupdatedate').val().split(' ')[0];

            var tillCloseModal = new bootstrap.Modal(document.getElementById('till_close_modal'));
            tillCloseModal.show();

        });
       
        // Remove local Storage items related to calendar view
        localStorage.removeItem('staffList');
        
        // Add local Storage item to indicate scheduler view
        localStorage.setItem('staffList', JSON.stringify(@json($staff_list)));
        //const staffList = @json($staff_list); could also be used directly without localStorage
        
        let calendarEl = document.getElementById('calendar');
        let calendar = new FullCalendar.Calendar(calendarEl, {
            schedulerLicenseKey: 'CC-Attribution-NonCommercial-NoDerivatives',
            // Scheduler options
            initialView: 'resourceTimeGridDay',
            initialDate: '{{ date("Y-m-d") }}',
            themeSystem: 'bootstrap5',
            datesSet: function() {
                // Example: make all FC buttons Bootstrap buttons
                document.querySelectorAll('.fc .fc-button').forEach(btn => {
                    // btn.classList.remove('fc-button-primary'); // default
                    // btn.classList.remove('fc-today-button'); // default
                    // btn.classList.add('btn', 'btn-primary'); 
                });
            },
            locale: 'en',
            views: {
                dayGridMonth: {
                    titleFormat: { year: 'numeric', month: 'long' } // "October 2025"
                },
                timeGridWeek: {
                    titleFormat: { month: 'short', day: 'numeric' } // "Oct 1 – 7"
                },
                timeGridDay: {
                    titleFormat: { year: 'numeric', month: 'long', day: 'numeric' } // "October 1, 2025"
                },
                resourceTimeGridDay: {
                    titleFormat: { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' } // "October 1, 2025"
                }
            },
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'resourceTimeGridDay,timeGridWeek,dayGridMonth'
            },
            selectable: true,
            editable: true,
            allDaySlot: false,
            forceEventDuration: true,
            dayHeaders: true,
            stickyHeaderDates: true,
            editable: true,
            selectable: true,
            displayEventTime: false,
            dayMaxEventRows: 4,
            eventMaxStack: 4,
            height: 'auto', // will activate stickyHeaderDates automatically!s
            slotLabelFormat: [{
                hour: 'numeric',
                minute: '2-digit',
                omitZeroMinute: false,
                meridiem: false,
                hour12: false
            }],
            slotDuration: '00:15:00', // very small slots will make the calendar really tall
            slotLabelInterval: '00:15',
            slotMinTime: "{{ $business->business_opening_time }}",
            slotMaxTime: "{{ $business->business_closing_time }}",
            nowIndicator: true,
            resourceAreaHeaderContent: "Staff",
            resourceAreaWidth: 150,
            resourceAreaColumns: [{
                    group: true,
                    field: 'title',
                    headerContent: 'Name',
                    width: "50%"
                },
                {
                    field: 'designation',
                    headerContent: 'Desg',
                    width: "25%"
                },
                {
                    field: 'floor',
                    headerContent: 'Floor',
                    width: "25%"
                }
            ],
            resourceOrder: 'staff_order',
            resourcesInitiallyExpanded: true,           
            resources: @json($resourceList),
            resourceLabelContent: function(arg) {
                let el = document.createElement('a');
                el.href = "javascript:void(0)";
                el.innerHTML = `
                    <img src="${arg.resource.extendedProps.image || ''}" style="width:50px;height:50px;border-radius:50%;" />
                    <p class="mb-0 overflow-hidden">${arg.resource.title || ''}</p>
                    <p class="mb-0 overflow-hidden text-nowrap">${arg.resource.extendedProps.designation || ''}</p>
                    <p class="mb-0 overflow-hidden text-nowrap">${arg.resource.extendedProps.floor || ''}</p>
                `;

                // Attach the resource object properly
                el.addEventListener('click', function () {
                    openResourceModal(arg.resource);
                });

                return { domNodes: [el] };
            },
            resourceLabelDidMount: function(info) {
                // debug: uncomment when inspecting
                // //console.log('resourceLabelDidMount', info.resource.id, info.resource.extendedProps, info.el);

                const props = info.resource.extendedProps || {};
                const title = (info.resource.title || '').trim();
                const staffShared = String(props.staff_shared || '').toLowerCase();

                // normalize check (handles "Yes", "yes", "No", "no", true/false, etc)
               // let bgColor = '#252631'; 
                let bgColor = '#eef2f7'; // default background color
                let color = '#000'; // default text color
                if (staffShared === 'yes' || staffShared === 'true') {
                    bgColor = '#909090'; // shared
                    color = '#ffffff';
                } else if (title === 'Online Appointments') {
                    bgColor = '#4d2124ff';
                    color = '#ffffff';
                } else if (title === 'To Be Selected') {
                    bgColor = '#f0ad4e';
                    color = '#000000';
                }

                // pick a sensible container to style:
                // 1) closest ancestor that has data-resource-id (very likely),
                // 2) fall back to closest element with a common FC class,
                // 3) fall back to parentElement or the element itself.
                const container =
                    info.el.closest('[data-resource-id]') ||
                    info.el.closest('.fc-resource') ||
                    info.el.parentElement ||
                    info.el;

                if (container) {
                    // use setProperty with "important" to beat FC CSS if necessary
                    container.style.setProperty('background-color', bgColor, 'important');
                    // ensure the inner wrapper also uses white text (fallback for inline styles)
                    const wrapper = info.el.querySelector('div') || info.el;
                    if (wrapper) wrapper.style.setProperty('color', color, 'important');

                    // extra safety: force anchors/spans/ps in the container
                    container.querySelectorAll('a, p, span, div, strong, em').forEach(el => {
                        el.style.setProperty('color', color, 'important');
                    });
                }
            },            
            viewDidMount: function(info) {
               customCalendarView(calendar.getResources(), info);
               $("#calendardate").val(formatDateTime(calendar.getDate()));
            },
            windowResize: function(arg) {
                customCalendarView(calendar.getResources(), arg);
            },
            events: function(info, successCallback, failureCallback) {
                
                //console.log('going to get events refetch');
                var s = info.startStr.valueOf();
                var e = info.endStr.valueOf();
                start = formatDateTime(s);
                end = formatDateTime(e);
                
                // //console.log(start+' '+end);
                // $("#calendarOverlay").show();
                $.ajax({
                    type: "GET",
                    url: "{{ url('eventList') }}",
                    data: {
                        'start': start,
                        'end': end,
                        'lastupdatedate': 0,
                    },
                    dataType: 'json',
                    success: function(response) {
                        
                        var res_type = response.res_type;
                        var mdata = response.mdata;
                        var bdata = response.bdata;
                        var lastupdatedate = response.lastupdatedate;
                        var service_rate = response.service_rate;
                        var service_count = response.service_count;
                        var msg = response.msg;
                        if (res_type == 'error') {
                            $("#calendarOverlay").hide();
                             newdate = new Date();
                            $("#lastupdatedate").val(formatDateTime(newdate) + ' ' + '00:01:00');

                            Swal.fire({
                                title: 'Error',
                                text: msg,
                                icon: 'error'
                            });
                           
                        } else if (res_type == 'info') {
                            $("#calendarOverlay").hide();
                            newdate = new Date();
                            $("#lastupdatedate").val(formatDateTime(calendar.newdate) + ' ' + '00:01:00');

                        } else if (res_type == 'success') {
                            
                           ////console.log(mdata);
                           $("#calendarOverlay").hide();
                            $("#visit-list").html('');
                            var lastvisitid = 0;
                            var counter = 1;
                            $.each(mdata, function(index, value) {
                                ////console.log(value);
                                var eventId = value.id;
                                oldevent = calendar.getEventById(eventId);
                                if (oldevent != 'undefined' && oldevent != null) {
                                    oldevent.remove();
                                } 
                            });
                            console.log('Fetched Events: ', mdata);
                            console.log('Blocked Events: ', bdata);
                            // Add blocked events to calendar
                            bdata.forEach(function(blockedEvent) {
                                // Check if event already exists
                                var existingEvent = calendar.getEventById(blockedEvent.id);
                                if (existingEvent) {
                                    existingEvent.remove();
                                }
                                // Add blocking event
                                calendar.addEvent({
                                    id: blockedEvent.id,
                                    resourceId: blockedEvent.resourceId,
                                    start: blockedEvent.start,
                                    end: blockedEvent.end,
                                    title: blockedEvent.title,
                                    is_blocking_event: true,
                                    allDay: false,
                                    backgroundColor: '#1c1b1bff',
                                    borderColor: '#171515ff',
                                    textColor: '#ffffff',
                                    display: 'background',
                                    eventAllow: function(dropInfo, draggedEvent) {
                                       return dropInfo.event ? false : dropInfo.end.getHours() <= 13; // sample rule
                                    }
                                });
                            });

                            successCallback(mdata);

                            $("#lastupdatedate").val(lastupdatedate);

                            // handle side bar visits
                            const visits = groupBy(mdata, 'visitid');                            
                            $.each(visits, function(visitid, events) {
                                ////console.log('Visit ID: ' + visitid + ', Events: ', events);
                                $.each(events, function(idx, event) {
                                    ////console.log('  Event ID: ' + event.id + ', Title: ' + event.title);
                                    // Here you can handle the events for each visit
                                    add_event_to_visit_list(visitid, event);
                                });                                
                            });
                            if(mdata.length > 0) {
                                var options = {
                                    valueNames: [ 'Customer-Name', 'Customer-Cell', 'Visit-Status' ]
                                };
                                var searchedVisits = new List('visit-container', options); // parent div id
                                document.getElementById('visit-search').addEventListener('keyup', function() {
                                    searchedVisits.search(this.value);
                                });
                                if(document.getElementById('visit-col').classList.contains("col-1")) {
                                    $(".visit-info").hide();
                                } else {
                                    $(".visit-info").show();
                                }
                            }
                            //initialize tooltips
                            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                                return new bootstrap.Tooltip(tooltipTriggerEl);
                            });
                            //visit_list(visits);

                           $("#forecast-banner").html("Total Services "+ service_count + " | Total Expected Revenue: " + service_rate.toFixed(2));
                        }
                    },
                    error: function(e) {
                        $("#calendarOverlay").hide();
                        failureCallback();
                        Swal.fire('Error', 'There was an error while fetching events. Please try again.', 'error');
                        //console.log(e);
                    }
                });
                //var events = getEvents(start[0],end[0]);
                //successCallback(events);
            },
            eventDidMount: function(info) {
                console.log(info);
                if(info.event.display == 'background') {
                    
                    return; // skip further processing for blocking events
                }

                var existing = bootstrap.Tooltip.getInstance(info.el);
                if (existing) {
                    existing.dispose();
                }
                new bootstrap.Tooltip(info.el, {
                    title: `
                    <strong>${info.event.extendedProps.customer_name}</strong><br>
                    ${info.event.title}<br>
                    Status: ${info.event.extendedProps.visit_status}
                    `,
                    placement: 'top',
                    trigger: 'hover',
                    html: true,
                    container: 'body',
                    delay: { "show": 500, "hide": 100 }

                });
                // Customize event appearance based on visit_status 
                const status = info.event.extendedProps.visit_status;

                if (status === "cancelled" || status === "canceled") {
                    // Lock the event
                    info.event.setProp("editable", false);
                    info.event.setProp("durationEditable", false);
                    info.event.setProp("startEditable", false);

                    // Disable click/select
                    info.el.style.pointerEvents = "none";
                    info.el.style.opacity = "0.3"; // dim look

                    // Add cancel icon at the start
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "solar:call-cancel-broken");
                    icon.classList.add("me-1", "text-danger", "fs-18");

                    // Prepend before event title
                    const titleEl = info.el.querySelector(".fc-event-title");
                    if (titleEl) {
                    titleEl.prepend(icon);
                    } else {
                    // fallback: prepend to root if title isn't found
                    info.el.prepend(icon);
                    }
                }

                if (status === "invoiced") {
                    // Lock the event
                    //info.event.setProp("editable", false);
                    //info.event.setProp("durationEditable", false);
                    //info.event.setProp("startEditable", false);

                    // Disable click/select
                    //info.el.style.pointerEvents = "none";
                    info.el.style.backgroundColor = "#808080"; // gray
                    
                    // Add invoiced icon at the start
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "solar:hand-money-outline");
                    icon.classList.add("me-1", "text-light", "fs-18");

                    // Prepend before event title
                    const titleEl = info.el.querySelector(".fc-event-title");
                    if (titleEl) {
                    titleEl.prepend(icon);
                    } else {
                    // fallback: prepend to root if title isn't found
                    info.el.prepend(icon);
                    }
                }
                let staff_shared = info.event.extendedProps.staff_shared || "No";
                if (staff_shared == "Yes") {
                     // Lock the event
                    info.event.setProp("editable", false);
                    info.event.setProp("durationEditable", false);
                    info.event.setProp("startEditable", false);

                    // Disable click/select
                    info.el.style.pointerEvents = "none";
                    info.el.style.backgroundColor = "#000000"; // gray                    
                    info.el.style.color = "#f7f7f7 !important"; // black text
                    info.el.style.opacity = "0.7"; // dim look

                    // Add shared icon at the start
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "solar:graph-new-up-outline");
                    icon.classList.add("me-1", "text-danger", "fs-18");

                    // Prepend before event title
                    const titleEl = info.el.querySelector(".fc-event-title");
                    if (titleEl) {
                    titleEl.prepend(icon);
                    } else {
                    // fallback: prepend to root if title isn't found
                    info.el.prepend(icon);
                    }
                }    

                const reqeusted = info.event.extendedProps.requested;
                const blockOther = info.event.extendedProps.block_other;
                const reminder_sms = info.event.extendedProps.reminder_sms;
                const reminder_email = info.event.extendedProps.reminder_email;
                const reminder_call = info.event.extendedProps.reminder_call;
                const promo = info.event.extendedProps.promo;
                const reminder_stricttime = info.event.extendedProps.reminder_stricttime;
                const total_advance = parseFloat(info.event.extendedProps.total_advance) || 0.00;
                const inservice = info.event.extendedProps.inservice;

                const text_color = info.event.textColor || "#000000";
                const titleEl = info.el.querySelector(".fc-event-title");
                
                if (reqeusted == "Yes") {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "mdi:account-check-outline");
                        icon.style.color = text_color;
                    icon.classList.add("eventClass", "me-1", "fs-12");
                    info.el.prepend(icon);
                }
               
                if (reminder_sms == "Y") {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "mdi:message-text-outline");
                    icon.style.color = text_color;
                    icon.classList.add("eventClass","me-1", "fs-12");
                    info.el.prepend(icon);
                }
                if (reminder_email == "Y") {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "mdi:email-outline");
                    icon.style.color = text_color;
                    icon.classList.add("eventClass", "me-1", "fs-12");
                    info.el.prepend(icon);
                }
                if (reminder_call == "Y") {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "mdi:phone-outline");
                    icon.style.color = text_color;
                    icon.classList.add("eventClass","me-1", "fs-12");
                    info.el.prepend(icon);
                }
                if (promo == "Yes") {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "mdi:tag-outline");
                    icon.style.color = text_color;
                    icon.classList.add("eventClass","me-1", "fs-12");
                    info.el.prepend(icon);
                }
                if( reminder_stricttime == "Y") {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "mdi:clock-alert-outline");
                    icon.style.color = text_color;
                    icon.classList.add("eventClass","me-1", "fs-12");
                    info.el.prepend(icon);
                    info.event.setProp("editable", false); // not draggable not resizable
                }
                if (total_advance > 0) {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "mdi:cash-multiple");
                    icon.style.color = text_color;
                    icon.classList.add("eventClass", "me-1", "fs-12");
                    info.el.prepend(icon);
                }
               if (inservice == "Yes") {
                    const icon = document.createElement("iconify-icon");
                    icon.setAttribute("icon", "f7:scissors-alt");
                    icon.style.color = text_color;
                    icon.classList.add("eventClass", "me-1", "fs-14", "spin");
                    info.el.prepend(icon);
                }
            },
            eventWillUnmount: function(info) {
                // Clean up when the event element is removed
                var tooltip = bootstrap.Tooltip.getInstance(info.el);
                if (tooltip) {
                    tooltip.dispose();
                }
            },
            eventContent: function(arg) {
                console.log(arg.event.display);
                if(arg.event.display == "background") {
                    return {
                        html: `<div class="fs-10">
                                <strong><iconify-icon icon="solar:lock-outline" style="font-size: 14px; color: #ffffff;" class="me-1 fs-12"></iconify-icon> ${arg.event.title}</strong><br>
                                <span class="eventClass">Blocking Event</span>
                            </div>`
                    };
                }

                let props = arg.event.extendedProps;

                ///set icon based on customer_type extended prop
                let iconHtml = '';
                if (props.customer_type == 'orange') {
                    iconHtml = '<iconify-icon icon="material-symbols:star" style="font-size: 14px; color: gold; background: black;" class="me-1 fs-12"></iconify-icon>';
                } else if (props.customer_type == 'red') {
                    iconHtml = '<iconify-icon icon="solar:flag-2-broken" style="font-size: 14px; color: green; background: white;" class="me-1 fs-12"></iconify-icon>';
                } else if (props.customer_type == 'green') {
                    iconHtml = '<iconify-icon icon="solar:flag-2-broken" style="font-size: 14px; color: green; background: white;" class="me-1 fs-12"></iconify-icon>';
                } else {
                    iconHtml = '';
                }

                return {
                    html: `<div>
                            <strong >` + iconHtml + ` ${props.customer_name}</strong><br>
                            <span  class="eventClass">${props.customer_cell}</span>
                            <span class="eventClass">${arg.event.title}</span>
                            <span  class="eventClass">${props.created_by}</span>
                        </div>`
                };
            },
            select: function (info) {
                //clearInterval(IntervalID);
                ////console.log('selected ' + info.startStr + ' to ' + info.endStr + ' on resource ' + info.resource.id);  
                // Do not allow selecting within a blocked (background) range
                const blockedEvents = calendar.getEvents().filter(e =>
                    e.display === "background" &&
                    e.getResources().some(r => r.id === info.resource.id)
                );
                const overlapsBlocked = blockedEvents.some(b =>
                    info.start < b.end && info.end > b.start
                );
                if (overlapsBlocked) {
                    calendar.unselect();
                    Swal.fire({
                        title: 'Staff not available',
                        text: 'Staff is not available at this time.',
                        icon: 'error',
                        confirmButtonText: 'OK!',
                        customClass: {
                            confirmButton: 'btn btn-primary'
                        }
                    });
                    return;
                }

                // Populate modal fields with event data
                $("#visit-details-new-visit-selected-staff").val(info.resource.id).trigger("change");
                let cleanDate = info.startStr.replace("T", " ");
               
                $("#visit-details-new-visit-date").val(cleanDate);

                $('#visit-details-table tbody').html("");              
                // Open modal to add new event
                El = document.getElementById("visit-details-modal");
                modal = new bootstrap.Modal(El);
               
                modal.show();
            },
            eventClick: function (info) {
                //clearInterval(IntervalID);
                // Clicking a blocked/background event should not open visit details
                if (info.event.display === 'background' || info.event.extendedProps?.is_blocking_event) {
                    Swal.fire({
                        title: 'Staff not available',
                        text: 'Staff is not available at this time.',
                        icon: 'error',
                        confirmButtonText: 'OK!',
                        customClass: {
                            confirmButton: 'btn btn-primary'
                        }
                    });
                    return;
                }

                // Populate modal fields with event data
               $('#visit-details-id-customer-visits').html(info.event.extendedProps.visitid);
               $('#visit-details-table tbody').html("");

                // Open modal to edit/delete event
                El = document.getElementById("visit-details-modal");
                modal = new bootstrap.Modal(El);
                
                modal.show();
            },
            eventDrop: function(info) {
                //console.log('Event dropped to ' + info.event.startStr + ' to ' + info.event.endStr + ' on resource ' + (info.newResource ? info.newResource.id : 'none'));
                
                newstaff = info.newResource ? info.newResource.id == 'undefined' || info.newResource.id == null ? 0 : info.newResource.id : 0;
                oldstaff = info.oldResource ? info.oldResource.id == 'undefined' || info.oldResource.id == null ? 0 : info.oldResource.id : 0;
                if (newstaff > 0 && oldstaff > 0) {
                    if (info.event.extendedProps.requested == 'Yes' && newstaff != oldstaff) {
                        
                        Swal.fire({
                            title: "Customer has Requested This Staff",
                            text: "The Staff can not be changed for this service!",
                            icon: "error",
                            html: 'The Staff can not be changed for this service!',
                            confirmButtonText: 'OK!',
                            customClass: {
                                confirmButton: 'btn btn-primary'
                            }
                        });
                        info.revert();
                        return false;
                    }
                }

                newstart = info.event.startStr;
                oldstart = info.oldEvent.startStr;

                if (info.event.extendedProps.reminder_stricttime == 'Y' && newstart !== oldstart) {
                    
                    Swal.fire({
                        title: "Strict Time Marked",
                        text: "Time can not be changed for this service!",
                        icon: "error",
                        html: 'Time can not be changed for this service!',
                        confirmButtonText: 'OK!',
                        customClass: {
                            confirmButton: 'btn btn-success me-2'
                        }
                    });
                    info.revert();
                    return false;
                }


                var visitid = info.event.extendedProps.visitid;
                var visitserviceid = info.event.extendedProps.visitserviceid;
                var visitservicestaffid = info.event.extendedProps.visitstaffid;
                console.log('Visit Service Staff ID: ' + visitservicestaffid);
                var visitstatus = info.event.extendedProps.visit_status;

                var newstart = info.event.startStr;
                var newend = info.event.endStr;
                newstaff == "" ? newstaff = oldstaff : newstaff = newstaff;
                $.ajax({
                    url : "{{ 'update_visit' }}",
                    data: { "id_customer_visits" : info.event.extendedProps.visitid, "visit_status": visitstatus, "id_visit_service_staff": visitservicestaffid, "id_visit_services": info.event.extendedProps.visitserviceid, "reassign_service_staff" : [newstaff], "service_start_datetime" : newstart, "service_end_datetime": newend, "_token": "{{ csrf_token() }}" },
                    type: "POST", // The POST method
                    dataType: "json", // Expected data type of the response
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                    success: function(data) {
                        ////console.log(data);
                        if(data.message_type == "error") {
                            info.revert();
                            toastr.error(data.message);
                        } else {    
                            toastr.success(data.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        //revert on error
                        info.revert();
                        // Handle errors
                        console.error("AJAX Error:", status, error);
                    }
                });
               // newevents();
            },
            eventResize: function(info) {
                //console.log(info);
                //console.log('Event resized to ' + info.event.start + ' to ' + info.event.end + ' on resource ' + (info.event.getResources().length > 0 ? info.event.getResources()[0].id : 'none'));
                
                let newstart = info.event.startStr;
                newstart = newstart.substring(11, 19);  // → "11:30:00"
                oldstart = info.oldEvent.startStr;
                oldstart = oldstart.substring(11, 19);  // → "11:30:00"
                newend = info.event.endStr;
                newend = newend.substring(11, 19);  // → "11:30:00"
                oldend = info.oldEvent.endStr;
                oldend = oldend.substring(11, 19);  // → "11:30:00"

                if (info.event.extendedProps.reminder_stricttime == 'Y' && (newstart !== oldstart || newend !== oldend)) {
                    
                    Swal.fire({
                        title: "Strict Time Marked",
                        text: "Time can not be changed for this service!",
                        icon: "error",
                        html: 'Time can not be changed for this service!',
                        confirmButtonText: 'OK!',
                        customClass: {
                            confirmButton: 'btn btn-success me-2'
                        }
                    });
                    info.revert();
                    return false;
                }

                var visitid = info.event.extendedProps.visitid;
                var visitserviceid = info.event.extendedProps.visitserviceid;
                var visitservicestaffid = info.event.extendedProps.visitservicestaffid;

                $.ajax({
                    url : "{{ 'update_visit' }}",
                    data: { "update_service_time": "true", "id_customer_visits" : info.event.extendedProps.visitid, "id_visit_services": info.event.extendedProps.visitserviceid, "visit_service_start" : newstart, "visit_service_end" : newend, "_token": "{{ csrf_token() }}" },
                    type: "POST", // The POST method
                    dataType: "json", // Expected data type of the response
                    headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
                    success: function(data) {
                        if(data.message_type == "error") {
                            info.revert();
                            toastr.error(data.message);
                        } else {
                            toastr.success(data.message);
                        }
                    },
                    error: function(xhr, status, error) {
                        //revert on error
                        info.revert();
                        // Handle errors
                        console.error("AJAX Error:", status, error);
                    }
                });
               // newevents();
            },
            datesSet : function(info) {
                //console.log('View changed to ' + info.startStr + ' to ' + info.endStr);
                $("#calendardate").val(formatDateTime(calendar.getDate()));
            },
            eventAllow: function(dropInfo, draggedEvent) {
                const blockedEvents = calendar.getEvents().filter(e =>
                    e.display === "background" &&
                    e.getResources().some(r => r.id === dropInfo.resource.id)
                );

                const overlaps = blockedEvents.some(b =>
                    dropInfo.start < b.end && dropInfo.end > b.start
                );

                return !overlaps;
            }
        });

        calendar.render();

        const newevents = function() {
           var d = calendar.getDate();
           //console.log("calender date is " + d);
            d = d.getFullYear() + "-" 
            + String(d.getMonth() + 1).padStart(2, '0') + "-" 
            + String(d.getDate()).padStart(2, '0') + "T" 
            + String(d.getHours()).padStart(2, '0') + ":" 
            + String(d.getMinutes()).padStart(2, '0') + ":" 
            + String(d.getSeconds()).padStart(2, '0');

            tempd = d.split("T");
            var start = tempd[0] + " 00:00:00";
            var end = tempd[0] + " 24:59:59";
            var lastupdate = $("#lastupdatedate").val();
            //console.log('Fetching new events from ' + start + ' to ' + end + ' since ' + lastupdate);
            $.ajax({
                type: "GET",
                url: "{{ url('eventList') }}",
                data: {
                    'start': start,
                    'end': end,
                    'lastupdatedate': lastupdate
                },
                dataType: 'json',
                success: function(response) {
                    var res_type = response.res_type;
                    var mdata = response.mdata;
                    var lastupdatedate = response.lastupdatedate != null ? response.lastupdatedate : $("#lastupdatedate").val();
                    var msg = response.msg;
                    if (res_type == "success") {
                        ////console.log(mdata);                        
                        var lastvisitid = 0;
                        $.each(mdata, function(index, value) {                            
                            var oldevent = calendar.getEventById(value.id);
                            if (oldevent != 'undefined' && oldevent != null) {
                                //$('[data-bs-toggle="tooltip"], .tooltip').tooltip("hide");
                                oldevent.remove();
                            } 
                            // handle side bar visits
                            const visits = groupBy(mdata, 'visitid');
                            $.each(visits, function(visitid, events) {
                                ////console.log('Visit ID: ' + visitid + ', Events: ', events);
                                $.each(events, function(idx, event) {
                                    ////console.log('  Event ID: ' + event.id + ', Title: ' + event.title);
                                    // Here you can handle the events for each visit
                                    add_event_to_visit_list(visitid, event);
                                });                                
                            });
                            
                            setTimeout(() => {
                                calendar.addEvent(value);
                            }, 200);
                        });
                        $("#lastupdatedate").val(lastupdatedate);

                        if(mdata.length > 0) {
                            //enable search on visit list
                            var options = {
                                valueNames: [ 'Customer-Name', 'Customer-Cell', 'Visit-Status' ]
                            };
                            var searchedVisits = new List('visit-container', options); // parent div id
                            document.getElementById('visit-search').addEventListener('keyup', function() {
                                searchedVisits.search(this.value);
                            });
                            if(document.getElementById('visit-col').classList.contains("col-1")) {
                                Array.from(document.getElementsByClassName("visit-info")).forEach(function(element) {
                                    element.classList.add("d-none");
                                });
                            } else {
                                Array.from(document.getElementsByClassName("visit-info")).forEach(function(element) {
                                    element.classList.remove("d-none");
                                });
                            }
                        }   

                        //close existing tooltips
                        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
                            var tooltip = bootstrap.Tooltip.getInstance(tooltipTriggerEl);
                            if (tooltip) {
                                tooltip.hide();
                            }
                        });
                        // //initialize tooltips
                        // var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
                        // var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                        //     return new bootstrap.Tooltip(tooltipTriggerEl);
                        // });
                        
                        
                    } else if (res_type == "info") {
                        //console.log(msg);
                    } else if (res_type == "error") {
                        //console.log(msg);
                    }
                },
                error: function() {

                }
            });
        }

        var IntervalID = setInterval(newevents, 180000); //3 minutes
         // Bind once before showing
        
        
        document.getElementById('visit-details-modal').addEventListener("hidden.bs.modal", function () {                    
            //refetch events
            calendar.refetchEvents();
            IntervalID = setInterval(newevents, 180000); //3 min restart interval
        });

        // attach refresh handler
        document.getElementById("refreshCalendar").addEventListener("click", function() {
            calendar.refetchEvents();
        });

        // attach move to date handler
        document.getElementById("move-to-date").addEventListener("change", function() {
            document.getElementById("move-to-date").disabled = true;
            const dateStr = this.value;
            if (dateStr) {
                calendar.gotoDate(dateStr);
                calendar.refetchEvents();
            }
            document.getElementById("move-to-date").disabled = false;
        });

        // close tooltips on document click
        document.addEventListener('click', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.forEach(function (tooltipTriggerEl) {
                var tooltip = bootstrap.Tooltip.getInstance(tooltipTriggerEl);
                if (tooltip) {
                    tooltip.hide();
                }
            });
        });

    });

    function customCalendarView(resources, info) {
        ////console.log('formatting view')  ;
        //$(".fc-view-harness .fc-view").addClass('niceScroll').delay(250);
        newWidth = resources.length * 60;
        if (resources.length > 18 && info.view.type == 'resourceTimeGridDay') {
            $(".fc-view-harness .fc-view > table").css({
                'width': newWidth
            });
        } else {
            $(".fc-view-harness .fc-view > table").css({
                'width': 'auto'
            });
        }

        var h = getViewPort();
        var height = h.height;
        var newheight = height - 300;

        $(".fc-view-harness .fc-view").css({
            'height': newheight
        });

        $("#visit-card").css({
            'height': height - 200,
            'overflow-y': 'hidden'           
        });

        var today = new Date();
        var h = today.getHours();
        var m = today.getMinutes();
        var s = today.getSeconds();

        if (h < 10) {
            h = "0" + h;
        }
        if (m < 10) {
            m = "0" + m;
        }
        if (s < 10) {
            s = "0" + s;
        }

        var current = false;
        $('.fc-timegrid-slots').css({
            'background-color': 'transparent'
        }); //first set all to transparent
        $.each($('.fc-timegrid-slots table tr'), function(index1, tr) { //find current time

            var data_time1 = $(tr).find('td:eq(0)').attr('data-time');

            var data_time = data_time1.split(":");
            if (data_time[1] == "00") {
                $(tr).find('td:eq(0)').css({
                    'font-weight': 'bold'
                });
                $(tr).find('td:eq(0)').css({
                    'border-top': '1px solid #a0a0a0'
                });
                $(tr).find('td:eq(1)').css({
                    'border-top': '1px solid #a0a0a0'
                });
                $(tr).find('td:eq(1)').css({
                    'background': '#ffffff'
                });
            } else {
                $(tr).find('td:eq(0)').css({
                    'border-top': '1px dashed #e5e5e5'
                });
                $(tr).find('td:eq(1)').css({
                    'border-top': '1px dashed #e5e5e5'
                });
                $(tr).find('td:eq(1)').css({
                    'background': '#ffffff'
                });
            }

            if (h == data_time[0] && parseInt(m) >= parseInt(data_time[1]) && parseInt(m) < parseInt(data_time[
                    1]) + 15 && current == false) {
                $(this).find('.fc-widget-content').css({
                    'background-color': 'rgba(255, 0, 0, 0.1)'
                });
                current = true;
            }

        });
    }

    function formatDateTime(input) {
        const d = new Date(input);

        // toISOString() gives UTC time — "2025-09-30T12:34:56.000Z"
        // If you want local time instead of UTC, format manually:
        const pad = (n) => String(n).padStart(2, "0");

        return (
            d.getFullYear() + "-" +
            pad(d.getMonth() + 1) + "-" +
            pad(d.getDate()) + "T" +
            pad(d.getHours()) + ":" +
            pad(d.getMinutes()) + ":" +
            pad(d.getSeconds())
        );
    }

    function getViewPort() {
        var e = window,
            a = 'inner';
        if (!('innerWidth' in window)) {
            a = 'client';
            e = document.documentElement || document.body;
        }
        return {
            width: e[a + 'Width'],
            height: e[a + 'Height']
        };
    }

    /// Add visit event to visit List ///
    const add_event_to_visit_list = function(visitid, visit) {
        ////console.log('Adding to visit list - Visit ID: ' + visitid + ', Events: ', visit);
        let counter = document.getElementById("visit-list")
            .getElementsByTagName("li").length;
        if(counter > 0){
            counter = counter + 1;
        } else {
            counter = 1;
        }
        // Take the first event in this group for display
        const value = visit;

        const visit_status   = value.extendedProps?.visit_status;
        const customer_name  = value.extendedProps?.customer_name;
        const customer_cell  = value.extendedProps?.customer_cell;
        const visit_service_id = value.extendedProps?.visitserviceid;
        const staff_shared = value.extendedProps?.staff_shared || "No";

        const bColor = value.backgroundColor || "#ffffff";
        const tColor = value.textColor || "#000000";

        ////console.log("visitid:", visitid);

        // Handle colors depending on status
        let bg = bColor;
        let tc = tColor;
        if (visit_status === "cancelled" || visit_status === "canceled") {
            bg = "#f7f7f7";
            tc = "#808080";
        }
        if (visit_status == 'invoiced') {
            bg = "#808080"; // highlight invoiced visits
            tc = "#f7f7f7";
        }
        
        if (staff_shared == "Yes") {            
            bg = "#000000"; // highlight completed visits
            tc = "#f7f7f7";
        }
        //check if visit already exists in the list
        if (document.getElementById(visitid)) {
            //remove existing
            document.getElementById(visitid).remove();
            counter = document.getElementById("visit-list")
                .getElementsByTagName("li").length + 1;
        }
        
        // Build list item
        let mhtm = "";
        mhtm += '<li id="' + visitid + '" style="padding-right: 2px;" class="list-item"' +
                'data-bs-toggle="tooltip" data-bs-placement="left" data-bs-delay="1000" data-html="true" ' +
                'title="' + counter + '- ' + customer_name + ' ' + value.title + '">';

        if (visit_status === "open" || visit_status === "invoiced") {
            if(staff_shared === "No"){
                mhtm += '<a style="padding-top:4px; padding-right:10px !important; ' +
                    'background-color:' + bg + '; color:' + tc + '; border-radius:4px; padding:2px !important; margin-bottom:2px;" ' +
                    'class="d-flex visit-link" id="link_' + visitid + '" visit_id="' + visitid + '" href="#">';
            } else {
                mhtm += '<div style="padding-top:4px; padding-right:10px !important; ' +
                    'background-color:' + bg + '; border-radius:4px; padding:2px !important; margin-bottom:2px;" ' +
                    'class="d-flex visit-link"  visit_id="' + visitid + '">'; 
            }
        } else {
            mhtm += '<div style="padding-top:4px; padding-right:10px !important; ' +
                    'background-color:' + bg + '; border-radius:4px; padding:2px !important; margin-bottom:2px;" ' +
                    'class="d-flex visit-link"  visit_id="' + visitid + '">';
        }

        mhtm += '<div class="flex-shrink-0 me-1">';
        if(visit_status === "cancelled" || visit_status === "canceled") {
            mhtm += '<iconify-icon icon="solar:call-cancel-broken" style="font-size: 30px;" class="text-muted mt-2"></iconify-icon>';
        } else if(staff_shared === "Yes") {
            mhtm += '<iconify-icon icon="solar:graph-new-up-outline" style="font-size: 30px;" class="text-light mt-2"></iconify-icon>';
        } else if(visit_status === "invoiced") {
            mhtm += '<iconify-icon icon="solar:hand-money-outline" style="font-size: 30px;" class=" mt-2"></iconify-icon>';
        } else {
            mhtm += '<iconify-icon icon="arcticons:rakuten-beauty" style="font-size: 30px;" class=" mt-2"></iconify-icon>';
        }
        mhtm += '</div>';

        mhtm += '<div class="flex-grow-1 visit-info">';
        mhtm += '<p class="text-muted p-2 Visit-Status" style="color:' + tc + ' !important; float:right; position:top">' +
                visit_status + '</p>';
        mhtm += '<p class="user-title m-0 mt-2 Customer-Name" style="color:' + tc + ' !important;">' +
                counter + '- ' + customer_name + '</p>';
        mhtm += '<p class="text-muted Customer-Cell" style="color:' + tc + ' !important;">' + customer_cell + '</p>';
        mhtm += '</div>';            
        mhtm += "</a>";           
        mhtm += "</li>";

        // Append to list
        $("#visit-list").append(mhtm);
        
        // Bind click
        if (visit_status === "open" || visit_status === "invoiced") {
            $("#link_" + visitid).on("click", function() {
                //clearInterval(IntervalID);
                // Populate modal fields with event data
                $('#visit-details-id-customer-visits').html(visitid);
                $('#visit-details-table tbody').html("");

                // Open modal to edit/delete event                

                El = document.getElementById("visit-details-modal");
                modal = new bootstrap.Modal(El);
               

                modal.show();
            });
        }         
    }

    const groupBy = function(xs, keyPath) {
        // First, sort the source array before grouping
        xs.sort((a, b) => {
            const aStart = new Date(a.extendedProps?.visit_service_start || a.visit_service_start || 0);
            const bStart = new Date(b.extendedProps?.visit_service_start || b.visit_service_start || 0);
            return aStart - bStart;
        });
        return xs.reduce(function(rv, x) {            
            // Support both root and extendedProps 
            const value = keyPath in x ? x[keyPath] : x.extendedProps?.[keyPath];
            (rv[value] = rv[value] || []).push(x);

            return rv;
        }, {});
    };

    const expand = function() {
        var elem = document.getElementById("calendar-row");
        if (!document.fullscreenElement) {
            elem.requestFullscreen().catch(err => {
                alert(`Error attempting to enable full-screen mode: ${err.message} (${err.name})`);
            });
           
        } else {
            document.exitFullscreen();
        }
    };

    const contract_visits = function() {
        var elem1 = document.getElementById("visit-col");
        var elem2 = document.getElementById("calendar-col");
        if (elem1.classList.contains("col-2")) {
            
            elem1.classList.remove("col-2");
            elem1.classList.add("col-1");
       
            elem2.classList.remove("col-10");
            elem2.classList.add("col-11");
            //document.getElementById("refreshCalendar").click();

            Array.from(document.getElementsByClassName("visit-info")).forEach(function(element) {
               element.classList.add('d-none');
            });

            //close existing tooltips
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.forEach(function (tooltipTriggerEl) {
                var tooltip = bootstrap.Tooltip.getInstance(tooltipTriggerEl);
                if (tooltip) {
                    tooltip.hide();
                }
            });

            //initialize tooltip on the visit cards
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });

        } else {
            
            elem1.classList.remove("col-1");
            elem1.classList.add("col-2");
       
            elem2.classList.remove("col-11");
            elem2.classList.add("col-10");
            //get element by class name visit-info
            Array.from(document.getElementsByClassName("visit-info")).forEach(function(element) {
               element.classList.remove('d-none');
            });

            //document.getElementById("refreshCalendar").click();
        }
        
    };

    function openResourceModal(resource) {
        //console.log(resource.extendedProps);
        // Populate modal fields with resource data
        $("#resource-details-id").val(resource.id);
        $("#resource-details-name").val(resource.title);
        var props = resource.extendedProps;
        $("#resource-details-designation").val(props.designation || '');
        $("#resource-details-floor").val(props.floor || '');
        $("#resource-details-start-hours").val(props.day_start_time || '');
        $("#resource-details-end-hours").val(props.day_end_time || '');
        $("#resource-details-days-off").val(props.days_off || '');

        //get existing blocking info for the resource for the selected date
        var staff_id = resource.id;
        var block_date = $("#calendardate").val().split('T')[0]; //calendar.getDate().toISOString().split('T')[0];
        $.ajax({
            url : "{{ 'get_staff_blocking' }}",
            data: { "staff_id" : staff_id, "block_date": block_date, "_token": "{{ csrf_token() }}" },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                ////console.log(data);
                if(data.message_type == "error") {
                    toastr.error(data.message);
                } else {    
                    //populate blocking info
                    $("#staff-blocking-events-tbody").empty();
                    if(data.blocking_events && data.blocking_events.length > 0) {
                        data.blocking_events.forEach(function(event) {
                            var row = '<tr>' +
                                '<td>' + event.id_staff_time_blocked + '</td>' +
                                '<td>' + event.block_start_time + '</td>' +
                                '<td>' + event.block_end_time + '</td>' +
                                '<td>' + event.title + '</td>' +
                                '<td><button type="button" class="btn btn-ghost-danger rounded-circle btn-icon btn-sm" onclick="remove_staff_blocking(' + event.id_staff_time_blocked + ')"><iconify-icon icon="iconamoon:trash-thin" class="fs-20"></iconify-icon></button></td>' +
                                '</tr>';
                            $("#staff-blocking-events-tbody").append(row);
                        });
                    } else {
                        var row = '<tr><td colspan="3" class="text-center">No blocking events found for this date.</td></tr>';
                        $("#staff-blocking-events-tbody").append(row);
                    }                    
                }
            },
            error: function(xhr, status, error) {
                // Handle errors
                toastr.error("AJAX Error:", status, error);
            }
        });


        // Open modal to view/edit resource
        El = document.getElementById("staff-detail-modal");
        modal = new bootstrap.Modal(El);
       
        modal.show();
    }

    function save_staff_blocking(){
        var staff_id = $("#resource-details-id").val();
        var block_date = $("#calendardate").val().split('T')[0]; //calendar.getDate().toISOString().split('T')[0];
            
        var block_start_time = $("#block_start").val();
        var block_end_time = $("#block_end").val();
        var block_reason_id = $("#block_reason").val();
        var staff_name = $("#resource-details-name").val();

        $.ajax({
            url : "{{ 'save_staff_blocking' }}",
            data: { "staff_id" : staff_id, "staff_name" : staff_name, "block_date": block_date, "block_start_time": block_start_time, "block_end_time": block_end_time, "block_reason_id": block_reason_id, "_token": "{{ csrf_token() }}" },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                ////console.log(data);
                if(data.message_type == "error") {
                    toastr.error(data.message);
                } else {    
                    toastr.success(data.message);
                    //close modal
                    let El= document.getElementById("staff-detail-modal");
                    let modal = bootstrap.Modal.getInstance(El);
                    modal.hide();
                    //refresh calendar
                    calendar.refetchEvents();
                }
            },
            error: function(xhr, status, error) {
                // Handle errors
                toastr.error("AJAX Error:", status, error);
            }
        });
    }

    function remove_staff_blocking(){
        var staff_id = $("#resource-details-id").val();
        var id_staff_time_blocked = $("#staff-blocking-events-tbody").find("tr:first td:first").text();

        $.ajax({
            url : "{{ 'remove_staff_blocking' }}",
            data: { "staff_id" : staff_id, "id_staff_time_blocked": id_staff_time_blocked, "_token": "{{ csrf_token() }}" },
            type: "POST", // The POST method
            dataType: "json", // Expected data type of the response
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            success: function(data) {
                ////console.log(data);
                if(data.message_type == "error") {
                    toastr.error(data.message);
                } else {    
                    toastr.success(data.message);
                    // close modal
                    let El= document.getElementById("staff-detail-modal");
                    let modal = bootstrap.Modal.getInstance(El);
                    modal.hide();
                    //refresh calendar
                    calendar.refetchEvents();
                }
            },
            error: function(xhr, status, error) {
                // Handle errors
                toastr.error("AJAX Error:", status, error);
            }
        });

    }

</script>

@endsection
