@extends('layouts.horizontal', ['title' => 'Service Departments', 'topbarTitle' => 'Service Departments'])

@section('css')
@vite([
    'node_modules/datatables.net-bs5/css/dataTables.bootstrap5.min.css',
    'node_modules/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css',
    'node_modules/datatables.net-fixedcolumns-bs5/css/fixedColumns.bootstrap5.min.css',
    'node_modules/datatables.net-fixedheader-bs5/css/fixedHeader.bootstrap5.min.css',
    'node_modules/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css',
    'node_modules/datatables.net-select-bs5/css/select.bootstrap5.min.css'
])
@endsection

@section('content')

<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Service Departments</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <table id="service_department_table" class="table table-bordered dt-responsive fs-13 w-100">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Service Department</th>
                                <th>Status</th>
                                <th class="noprint">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($departments as $dept)
                                <tr>
                                    <td>{{ $dept->id_service_department }}</td>
                                    <td>{{ $dept->service_department }}</td>
                                    <td>{{ $dept->department_status }}</td>
                                    <td>
                                        <button
                                            onclick="openEditDepartmentModal({{ $dept->id_service_department }})"
                                            class="btn btn-sm btn-ghost-info me-2 rounded-circle btn-icon edit-dept-btn"
                                            data-id="{{ $dept->id_service_department }}"
                                            data-service_department="{{ $dept->service_department }}"
                                            data-department_status="{{ $dept->department_status }}"
                                        >
                                            <iconify-icon icon="line-md:edit-twotone" class="fs-22"></iconify-icon>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- Add/Edit Modal --}}
<div class="modal fade" id="departmentModal" tabindex="-1" aria-labelledby="departmentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="departmentModalLabel"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="departmentModalForm">
                @csrf
                <div class="modal-body">
                    <input type="hidden" id="id_service_department" name="id_service_department">

                    <div class="mb-3">
                        <label for="service_department" class="form-label">Service Department</label>
                        <input type="text" class="form-control" id="service_department" name="service_department" required>
                    </div>

                    <div class="mb-3">
                        <label for="department_status" class="form-label">Status</label>
                        <select class="form-select" id="department_status" name="department_status" required>
                            <option value="Active">Active</option>
                            <option value="InActive">InActive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" onclick="save_department()" class="btn btn-primary" id="saveDepartmentBtn">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- End Modal --}}

@endsection

@section('scripts')
<script>
    let serviceDepartmentTable;

    $(document).ready(function() {
        initServiceDepartmentTable();
    });

    function initServiceDepartmentTable() {
        if ($.fn.DataTable.isDataTable('#service_department_table')) {
            $('#service_department_table').DataTable().clear().destroy();
        }

        serviceDepartmentTable = $('#service_department_table').DataTable({
            responsive: true,
            fixedHeader: true,
            lengthChange: true,
            pageLength: 10,
            searching: true,
            info: true,
            paging: true,
            buttons: [
                { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                { extend: "print", className: "btn btn-sm btn-soft-primary" },
                { extend: "pdf",   className: "btn btn-sm btn-soft-primary" }
            ],
            layout: {
                topStart: 'buttons',
                topEnd: function() {
                    // Return a flex container with search input and button
                    return '<div class="d-flex align-items-center gap-2" style="justify-content: flex-end; width: 100%;"><label class="dataTables_filter" style="margin: 0;"><input type="search" class="form-control form-control-sm" placeholder="Search..." aria-controls="service_department_table" id="service_department_search"></label><button class="btn btn-sm btn-outline-success" id="addDepartmentBtn" onclick="openAddDepartmentModal()"><iconify-icon icon="mdi:plus" class="me-1 fs-22"></iconify-icon> Add Department</button></div>';
                },
                bottomStart: {
                    pageLength: { menu: [[10, 25, 50, 100, 1000], [10, 25, 50, 100, 1000]] },
                    info: {}
                },
                bottomEnd: "paging"
            },
            initComplete: function(settings) {
                // Manually wire up the search input to DataTables
                var searchInput = $('#service_department_search');
                if (searchInput.length) {
                    searchInput.on('keyup', function() {
                        serviceDepartmentTable.search(this.value).draw();
                    });
                }
            }
        });
    }

    function reloadServiceDepartmentTable() {
        $.ajax({
            url: window.location.href,
            type: 'GET',
            success: function(response) {
                const $newContent = $(response);
                const $newTableBody = $newContent.find('#service_department_table tbody');
                const $newTable = $newContent.find('#service_department_table');
                
                if ($newTableBody.length && $newTable.length) {
                    $('#service_department_table tbody').html($newTableBody.html());
                    initServiceDepartmentTable();
                } else {
                    window.location.reload();
                }
            },
            error: function() {
                window.location.reload();
            }
        });
    }

    function openAddDepartmentModal() {
        $('#id_service_department').val('');
        $('#service_department').val('');
        $('#department_status').val('Active');

        $('#departmentModalLabel').text('Add Department');

        let el = document.getElementById('departmentModal');
        let modal = bootstrap.Modal.getInstance(el);
        if (!modal) modal = new bootstrap.Modal(el);
        modal.show();
    }

    function openEditDepartmentModal(id) {
        let button = $('.edit-dept-btn[data-id="' + id + '"]');
        $('#id_service_department').val(button.data('id'));
        $('#service_department').val(button.data('service_department'));
        $('#department_status').val(button.data('department_status'));

        $('#departmentModalLabel').text('Edit Department');

        let el = document.getElementById('departmentModal');
        let modal = bootstrap.Modal.getInstance(el);
        if (!modal) modal = new bootstrap.Modal(el);
        modal.show();
    }

    function save_department() {
        if ($('#service_department').val().trim() === '') {
            toastr.warning('Service department is required.');
            return;
        }

        $('#saveDepartmentBtn').prop('disabled', true);

        $.ajax({
            url: '{{ route("service_departments.save_or_update") }}',
            method: 'POST',
            data: $('#departmentModalForm').serialize(),
            success: function(res) {
                $('#saveDepartmentBtn').prop('disabled', false);
                if (res.success) {
                    toastr.success(res.message);
                    $('#departmentModal').modal('hide');
                    reloadServiceDepartmentTable();
                } else {
                    toastr.error(res.message || 'Failed to save department');
                }
            },
            error: function(xhr) {
                $('#saveDepartmentBtn').prop('disabled', false);
                toastr.error('Failed to save department: ' + xhr.responseText);
            }
        });
    }
</script>
@endsection
