@extends('layouts.horizontal', ['title' => 'All Deal Packages', 'topbarTitle' => 'All Packages'])

@section('content')

<style>
     td.strike-through {text-decoration:line-through !important; color:red;} 
</style>

<div class="Services-list">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">All Services</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered table-nowrap mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Section</th>
                                    <th>ID Type</th>
                                    <th>S. Type</th>
                                    <th>ID Category</th>
                                    <th>S. Category</th>
                                    <th>ID Service</th>
                                    <th>Service</th>
                                    <th>option_for</th>
                                    <th>Price</th>
                                    <th>Active</th>
                                    <th>Created At</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($package_types as $service)
                                <tr >
                                    <td >{{ $service->business_type }}</td>
                                    <td @if($service->service_type_active == 'No') class="strike-through" @endif>{{ $service->id_package_type }}</td>
                                    <td @if($service->service_type_active == 'No') class="strike-through" @endif>{{ $service->service_type }}</td>
                                    <td @if($service->service_category_active == 'No') class="strike-through" @endif>{{ $service->id_package_category }}</td>
                                    <td @if($service->service_category_active == 'No') class="strike-through" @endif>{{ $service->service_category }}</td>
                                    <td @if($service->service_active == 'No') class="strike-through" @endif>{{ $service->id_package_services }}</td>
                                    <td @if($service->service_active == 'No') class="strike-through" @endif>{{ $service->service_name }}</td>
                                    <td @if($service->service_active == 'No') class="strike-through" @endif>{{ $service->option_for }}</td>
                                    <td @if($service->service_active == 'No') class="strike-through" @endif>{{ config('constants.CURRENCY') }} {{ number_format($service->service_rate, 2) }}</td>
                                    <td @if($service->service_active == 'No') class="strike-through" @endif>{!! $service->service_active == 'Yes' && $service->service_category_active == 'Yes' && $service->service_type_active == 'Yes' ? '<span class="badge badge-soft-success fs-14">Yes</span>' : '<span class="badge badge-soft-danger fs-14">No</span>' !!}</td>
                                    <td @if($service->service_active == 'No') class="strike-through" @endif></td>
                                </tr>
                                @if($service->options)
                                    @foreach($service->options as $option)
                                        <tr >
                                            <td ></td>
                                            <td ></td>
                                            <td ></td>
                                            <td ></td>
                                            <td >Optional: </td>
                                            <td @if($option->service_active == 'No') class="strike-through" @endif>{{ $option->id_package_services }}</td>
                                            <td @if($option->service_active == 'No') class="strike-through" @endif>{{ $option->service_name }}</td>
                                            <td @if($option->service_active == 'No') class="strike-through" @endif>{{ $option->option_for }}</td>
                                            <td @if($option->service_active == 'No') class="strike-through" @endif>{{ config('constants.CURRENCY') }} {{ number_format($option->service_rate, 2) }}</td>
                                            <td @if($option->service_active == 'No') class="strike-through" @endif>{!! $option->service_active == 'Yes' && $option->service_category_active == 'Yes' && $option->service_type_active == 'Yes' ? '<span class="badge badge-soft-success fs-14">Yes</span>' : '<span class="badge badge-soft-danger fs-14">No</span>' !!}</td>
                                            <td @if($option->service_active == 'No') class="strike-through" @endif></td>
                                        </tr>
                                    @endforeach
                                @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection
@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Initialize Datatable
        var table = $('.table').DataTable({
            paging: false,
            searching: true,
            info: true,
            responsive: false,
           
            ordering:false,
            "layout": {
                topStart: "buttons",
                topEnd: "search",
                bottomStart: {                 // page length selector
                    pageLength: {
                        menu: [[10, 25, 50, -1], [10, 25, 50, "Show all"]]
                    },
                    info: {}
                },                
                bottomEnd: "paging"       // pagination
            },
             buttons: [
                    { extend: "copy",  className: "btn btn-sm btn-soft-primary" },
                    { extend: "csv",   className: "btn btn-sm btn-soft-primary" },
                    { extend: "print", className: "btn btn-sm btn-soft-primary" },
                    { extend: "pdf", className: "btn btn-sm btn-soft-primary" }
                ],
        });
    });
</script>

@endsection