@extends('layouts.horizontal', ['title' => 'Deal Packages', 'topbarTitle' => 'Packages'])
@section('css')
@vite(['node_modules/dropzone/dist/dropzone.css'])
@vite(['node_modules/select2/dist/css/select2.min.css'])
@vite(['node_modules/flatpickr/dist/flatpickr.min.css'])

@endsection
@section('content')
<style>
    .strike-through {text-decoration:line-through !important; color:red !important;} 

    /* Scrollbar container */
    ::-webkit-scrollbar {
        width: 6px;      /* vertical scrollbar width */
        height: 6px;     /* horizontal scrollbar height */
    }

    /* Scrollbar track (background) */
    ::-webkit-scrollbar-track {
    background: #ccccccff;
    border-radius: 10px;
    }

    /* Scrollbar thumb (the draggable part) */
    ::-webkit-scrollbar-thumb {
    background: #808080;
    border-radius: 10px;
    }

    /* Hover effect on thumb */
    ::-webkit-scrollbar-thumb:hover {
    background: #37394d;
    }

</style>

<div class="container-fluid">
    <!-- start page title -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between">
                <h2 class="mb-0">Deal Packages</h2>
                <div class="page-title-right d-flex align-items-center gap-3">
                    @php
                        $breadcrumb = getCurrentMenuBreadcrumb();
                    @endphp
                    @if(!empty($breadcrumb))
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb mb-0 py-2">
                                @foreach($breadcrumb as $index => $item)
                                    @if($index === count($breadcrumb) - 1)
                                        <li class="breadcrumb-item active" aria-current="page">{{ $item }}</li>
                                    @else
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">{{ $item }}</a></li>
                                    @endif
                                @endforeach
                            </ol>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">           
            <div class="row">
                <div class="col-md-4"><!-- Left Column: Package Types -->
                    <div class="card mb-2">
                        <div class="card-body">                            
                            <!-- justify the div using class -->
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <h4 class="mb-2">Package Type</h4>
                                <button title="Add Package Type" onclick="open_type_edit(0)" class="btn btn-primary btn-sm"><i class="ti ti-plus"></i> Add</button>
                            </div>
                            <input type="text" id="typesearch-input" class="form-control mb-1" placeholder="Search types...">
                        </div>
                    </div>
                    <div id="type-list">
                        <div class="list border drag-type-container" data-plugin="dragula" style="height:500px; overflow-y:auto; border-radius:6px;">
                        @foreach($package_types as $pt)

                        @php
                            $today = strtotime(date('Y-m-d'));
                            $expiry = strtotime($pt->expiry_date);
                            $daysLeft = floor(($expiry - $today) / (60 * 60 * 24));
                        @endphp

                            <div id="{{ $pt->id_package_type }}_type" class="card mb-1 shadow-sm service-type-card">
                                <div class="card-body p-2">
                                    <div class="d-flex align-items-center">
                                        <img onclick="open_typeImageModal({{ $pt->id_package_type }});" src="{{ asset('images/services/types/'.$pt->service_type_image) }}" height="30" class="me-2">
                                        <h5 style="cursor: pointer;" onclick="getCategories({{ $pt->id_package_type }}, '{{ $pt->service_type }}');" class="mb-0 type-name {{ $pt->service_type_active == 'No' ? 'strike-through' : '' }} {{ $expiry <= $today ? 'strike-through' : ''  }}"  
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Click to load categories for {{ $pt->service_type }}">{{ $pt->service_type }}</h5>
                                        <div class="ms-auto">
                                            <button title="Edit Type" onclick="open_type_edit({{ $pt->id_package_type }});" class="btn btn-sm {{ $pt->service_type_active == 'No' ? 'btn-light' : 'btn-default' }}">                                                
                                                {!! $pt->service_type_active == 'No' ? '<iconify-icon icon="mingcute:unlock-line" class="fs-16"></iconify-icon>' : '<iconify-icon icon="line-md:edit-twotone" class="fs-16"></iconify-icon>' !!}
                                            </button>
                                        </div>
                                    </div>

                                    <div class="d-flex align-items-center mt-0">
                                        <p style="cursor: pointer;" onclick="getCategories({{ $pt->id_package_type }}, '{{ $pt->service_type }}');" class="mb-0 ms-2 text-muted">Order# ({{ $pt->order_id }}) ID: {{ $pt->id_package_type }} </p>
                                        <p class="mb-0 ms-auto text-danger fs-6">
                                        </p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        </div>
                    </div>
                </div><!-- End of Left Column: Package Types -->

                <div class="col-md-4"><!-- LEFT Column: Package Categories  -->
                    <div class="card mb-2">
                        <div class="card-body">                            
                            <!-- justify the div using class -->
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <h4 class="mb-2">Category <span id="type_name"></span></h4>
                                <button  title="Add Category" onclick="open_category_edit(0);" class="btn btn-primary btn-sm mb-1"><i class="ti ti-plus"></i> Add</button>
                            </div>
                            <input type="text" id="categorysearch-input" class="form-control mb-1" placeholder="Search categories...">
                        </div>
                    </div>
                    <div id="category-list">
                        <div class="list border drag-category-container" data-plugin="dragula" id="categories" style="height:500px; overflow-y:auto; border-radius:6px;">                               
                            <!-- Categories will be populated here based on selected service type -->
                            
                        </div>
                    </div>
                </div> <!-- End of LEFT Column: Package Categories  -->

                <div class="col-md-4 mb-4"> <!-- RIGHT Column: Services  -->
                    <div class="card mb-2">
                        <div class="card-body">                            
                            <!-- justify the div using class -->
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <h4 class="mb-2">Service <span id="category_name"></span></h4>
                                <button title="Add Service" onclick="open_service_edit(0);" class="btn btn-primary btn-sm"><i class="ti ti-plus"></i> Add</button>
                            </div>
                            <input type="text" id="servicesearch-input" class="form-control mb-1" placeholder="Search services...">
                        </div>
                    </div>    
                    <div id="service-list">                
                        <div class="list border drag-service-container" data-plugin="dragula" id="services" style="height:500px; overflow-y:auto; border-radius:6px;">                          
                            <!-- Services will be populated here based on selected category -->
                        </div>
                    </div>
                </div><!-- End of RIGHT Column: Services  -->


            </div>                
        </div><!-- end col-->
    </div>
</div> <!-- container-fluid -->

{{-- Modal for adding/editing service options --}}
<div class="modal fade" id="serviceOptionsModal" tabindex="-1" aria-labelledby="serviceOptionsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceOptionsModalLabel">Service Options</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="serviceOptionsForm">
                    @csrf
                    <input type="hidden" name="id_package_services" id="id_package_service_options" value="">
                    <input type="hidden" name="return_category_id" id="return_option_category_id" value="">
                    <input type="hidden" name="service_category_name" id="return_option_category_name" value="">
                    <div class="mb-3">
                        <label for="option_name" class="form-label">Optional Service Name</label>
                        <select class="form-select" id="option_name" name="service_id">
                        </select>
                    </div>
                    
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="saveOptionsBtn">Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Service Options Modal --}}

{{-- Modal for Type image upload using Dropzone --}}
 <div class="modal fade" id="typeImageModal" tabindex="-1" aria-labelledby="typeImageModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg">
               <div class="modal-content">
                    <div class="modal-header">
                         <h5 class="modal-title" id="typeImageModalLabel">Select or Upload Image</h5>
                         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form id="typeDropzone" class="dropzone"
                              data-action="{{ route('deal_packages.package_type_uploadimage') }}"
                              data-preview-base="{{ asset('images/services/types') }}">
                              @csrf
                         <div class="modal-body">
                                <h6>Choose Existing Image:</h6>
                                <input type="hidden" id="type_image_id" name="id_package_type">
                                <div id="existingTypeImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                                    <!-- Existing images will be loaded here -->
                                </div>
                                
                                <input type="hidden" id="existing_type_image" name="existing_type_image">
                                <h6>Or Upload New Image:</h6>
                                <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                                <div class="dz-message needsclick">
                                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                                    <h3>Drop files here or click to upload.</h3>
                                    <span class="text-muted fs-13">(This is your dropzone. Selected files are
                                            <strong>stored</strong> on the server.)</span>
                                </div>
                                <input type="hidden" name="service_type_image" id="service_type_image">
                                <div id="selectedTypePreview" class="mt-3"></div>                              
                         </div>
                         <div class="modal-footer">
                              <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal">Done</button>
                         </div>
                    </form>
               </div>
          </div>
     </div>
{{-- End of Modal --}}

{{-- Modal for adding/editing package type --}}
<div class="modal fade" id="typeModal" tabindex="-1" role="dialog" aria-labelledby="typeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="typeModalLabel">Add/Edit Package Type</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="typeForm">
                    <input type="hidden" id="id_package_type" name="id_package_type">
                    <input type="hidden" id="order_id" name="order_id" value="0">
                    <input type="hidden" id="package_type_image" name="service_type_image" value="nu.png">
                    <div class="form-group mb-3">
                        <label for="service_type">Service Type Name</label>
                        <input type="text" class="form-control" id="service_type" name="service_type" required>
                    </div>
                    <div class="form-group mb-3">
                        <label for="service_type">Expiry Date</label>
                        <input type="date" class="form-control" id="expiry_date" name="expiry_date" required>
                    </div>
                    <div class="form-group mb-3 d-none">
                        <label for="business_type">Section</label>
                        <select class="form-select" id="business_type_id" name="business_type_id">
                            <option value="0">Select Section</option>
                            @foreach($business_types as $bt)
                                <option value="{{ $bt->id_business_type }}">{{ $bt->business_type }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group  mb-3">
                        <label for="type_description">active</label>
                        <select class="form-select" name="service_type_active" id="service_type_active">
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                    @if (isset($business_with_common_services) && !empty($business_with_common_services))
                    <div class="mb-3">
                        <label class="fw-bold">
                            Package Type Visibility by Branch
                            <small class="text-muted">(Uncheck = Hide)</small>
                        </label>
                        <div class="border rounded p-3"
                             style="max-height:220px; overflow-y:auto">
                            @foreach($business_with_common_services as $branch)
                                <div class="form-check">
                                    <input class="form-check-input branch-check-for-package-type" id="package_type_visible_check_box_{{$branch->id_business}}" type="checkbox" name="visible_branches[]" value="{{ $branch->id_business }}" checked>
                                    <label class="form-check-label">
                                        {{ $branch->business_name }}
                                    </label>
                                </div> 
                            @endforeach
                        </div>
                        <small class="text-danger">
                            Unchecked branch means this service type will NOT be visible in that branch.
                        </small>
                    </div>
                   @endif 

                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                <button type="button" id="saveTypeBtn" class="btn btn-primary">Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Modal --}}

{{-- DropZone Modal For Category Image Update --}}
<div class="modal fade" id="categoryImageModal" tabindex="-1" aria-labelledby="categoryImageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="categoryImageModalLabel">Select or Upload Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="categoryDropzone" class="dropzone"
                  data-action="{{ route('deal_packages.category_uploadimage') }}"
                  data-preview-base="{{ asset('images/services/categories') }}">
                  @csrf
                <div class="modal-body">
                    <h6>Choose Existing Image:</h6>
                    
                    <input type="hidden" id="category_image_id" name="id_package_category">
                    <div id="existingCategoryImages" class="d-flex flex-wrap gap-2 mb-3" style="max-height: 300px; overflow-y: auto;">
                        <!-- Existing images will be loaded here -->
                    </div>
                    
                    <input type="hidden" id="existing_category_image" name="existing_category_image">
                    <h6>Or Upload New Image:</h6>
                    <div class="dropzone-previews" id="uploadPreviewTemplate"></div>
                    <div class="dz-message needsclick">
                        <i class="ti ti-cloud-upload h1 text-muted"></i>
                        <h3>Drop files here or click to upload.</h3>
                        <span class="text-muted fs-13">(This is your dropzone. Selected files are
                            <strong>stored</strong> on the server.)</span>
                    </div>
                    <input type="hidden" name="service_category_image" id="service_category_image">
                    <div id="selectedCategoryPreview" class="mt-3"></div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-secondary" data-bs-dismiss="modal">Done</button>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- End of DropZone Modal --}}

{{-- Modal for adding/editing service category --}}
<div class="modal fade" id="categoryModal" tabindex="-1" aria-labelledby="categoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">                
                <h5 class="modal-title" id="categoryModalLabel">Add/Edit Package Category</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="categoryForm">                    
                    <input type="hidden" id="id_package_category" name="id_package_category">
                    <input type="hidden" id="category_order_id" name="order_id">
                    <input type="hidden" id="return_type_name" name="return_type_name">
                    <input type="hidden" id="existing_package_category_image" name="service_category_image" value="nu.png">
                    <div class="form-group mb-3">
                        <label for="category_name">Category Name</label>
                        <input type="text" class="form-control" id="service_category" name="service_category" required>
                    </div>
                    <div class="form-group  mb-3">
                        <label for="package_type_id">Package Type</label>
                        <select class="form-select" name="package_type_id" id="package_type_id">
                            <option value="">Select Package Type</option>
                            @foreach($package_types as $st)
                                <option value="{{ $st->id_package_type }}">{{ $st->service_type_active=="Yes" ? $st->id_package_type.' - '.$st->service_type.'  /  '. 'active' : $st->id_package_type.'-'.$st->service_type.'  /  '.'Inactive' }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group  mb-3">
                        <label for="category_description">active</label>
                        <select class="form-select" name="service_category_active" id="service_category_active">
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                 <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" aria-label="Close">Close</button>
                <button type="button" id="saveCategoryBtn" class="btn btn-primary">Save changes</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Modal --}}

{{-- Modal for adding/editing service --}}
<div class="modal fade" id="serviceModal" tabindex="-1" aria-labelledby="serviceModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="serviceModalLabel">Add/Edit Service</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="serviceForm">
                    <input type="hidden" id="id_package_service" name="id_package_services">
                    <input type="hidden" id="service_id" name="service_id">
                    <input type="hidden" id="service_order_id" name="order_id" value="0">
                    <input type="hidden" id="return_category_name" name="return_category_name">
                    <input type="hidden" id="return_category_id" name="return_category_id">
                    <div class="row mb-3">
                        <div class="col-md-6">                            
                            <div class="form-group mb-3" id="serviceNameDiv">
                                <label for="service_name">Service Name</label>
                                <input type="text" class="form-control" id="service_name" name="service_name">
                            </div>
                            <div class="form-group mb-3" id="selectServiceDiv">
                                <label for="select_service">Select Service</label>
                                <select onchange="updateServiceDetails()" class="form-select" id="select_service" name="select_service">
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="package_category">Category</label>
                                <select class="form-select" name="package_category_id" id="package_category_id">
                                    <option value="">Select Package Category</option>
                                    <!-- Categories will be populated dynamically based on selected service type -->
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="service_rate">Rate</label>
                                <input type="number" class="form-control" id="service_rate" name="service_rate" step="0.01" required>
                            </div>
                           
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-3">
                                <label for="package_service_optional">Service Has Options</label>
                                <select class="form-select" id="package_service_optional" name="package_service_optional" required>                                    
                                    <option value="No">No</option>
                                    <option value="Yes">Yes</option>
                                </select>
                            </div>
                            <div class="form-group mb-3">
                                <label for="package_service_active">Active</label>
                                <select class="form-select" name="package_services_active" id="package_service_active">
                                    <option value="Yes">Yes</option>
                                    <option value="No">No</option>
                                </select>
                            </div> 

                             <div class="form-group mb-3">
                                <label for="package_service_qty">Quantity</label>
                                <input type="number" class="form-control" id="package_service_qty" name="package_service_qty" step="1" required>
                            </div>
                        </div>
                        @if (isset($business_with_common_services) && !empty($business_with_common_services))
                        <div class="col-md-12">
                            <div class="mb-2">
                                <label class="fw-bold">
                                    Service Settings by Branch
                                    <small class="text-muted">(Uncheck = Hide)</small>
                                </label>

                                <div class="border border-dashed border-primary rounded p-2  " style="height:240px; overflow-y:auto;">
                                   @foreach($business_with_common_services as $branch)
                                        <div class="row  align-items-center {{ !$loop->last ? 'border-bottom border-dashed border-primary pb-1 mb-1' : '' }} ">
                                            <div class="col-md-8">
                                                {{ $branch->business_name }}
                                            </div>
                                            <!-- Visibility -->
                                            <div class="col-md-2">
                                                <input type="checkbox"
                                                    class="form-check-input branch-visibility"
                                                    value="{{ $branch->id_business }}"
                                                    checked>
                                                <label>Visible</label>
                                            </div>
                                            <!-- Price -->
                                            <div class="col-md-2">
                                                <input type="number"
                                                    step="0.01"
                                                    class="form-control branch-price"
                                                    data-branch-id="{{ $branch->id_business }}"
                                                    placeholder="rate" value="">
                                            </div>
                                        </div>
                                    @endforeach
                                </div>

                                <small class="text-danger">
                                    Unchecked branch means this Service will NOT be visible in that branch.
                                </small>
                            </div>
                        </div>
                        @endif

                      
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="saveServiceBtn" class="btn btn-primary">Save changes</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
{{-- End of Service Add/Edit Modal --}}



@endsection

@section('scripts')
<script>
    document.addEventListener("DOMContentLoaded", function () {    

        // $("#package_type_id").select2({
        //     dropdownParent: $('#categoryModal'),
        //     width: '100%'
        // });

        

        var vp = getViewPort();
        document.querySelectorAll('.list').forEach(function(list) {
            list.style.height = (vp.height - 400) + 'px'; // Adjust 400 as needed for other UI elements
        });

        // Enable Dragula for drag-and-drop reordering
        // Select type containers with the class
        var containers = Array.from(document.querySelectorAll('.drag-type-container'));
                
        // Init Type Dragula
        var drake_type = dragula(containers);
        drake_type.on('drop', function (el, target, source, sibling) {
            // Get the new order of type IDs            
            let typeOrder = Array.from(target.children).map((child, index) => ({
                id_package_type: child.id.replace('_type', ''),
                type_order: index + 1
            }));

            // Send the new order to the server via Fetch update_type_order
            fetch("{{ route('deal_packages.update_package_type_order') }}", {
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ order: typeOrder })
            })
            .then(response => response.json())
            .then(data => {
                //console.log('Type order updated successfully');
                toastr.success('Type order updated successfully');
                window.location.reload(); // Reload the page to reflect changes
            })
            .catch(error => {
                toastr.error('Error updating type order');
                //console.error('Error updating type order:', error);
            });
        });
        
        // Select category containers with the class
        var cat_containers = Array.from(document.querySelectorAll('.drag-category-container'));
        //console.log("Category Containers:", cat_containers);
        // Init Category Dragula
        var drake_category = dragula(cat_containers);
        drake_category.on('drop', function (el, target, source, sibling) {
            // Get the new order of category IDs            
            let categoryOrder = Array.from(target.children).map((child, index) => ({
                id_package_category: child.id.replace('_category', ''),
                category_order: index + 1
            }));
            //get the active type id
            let activeElement = document.querySelector('#type-list .active');
            let return_type_id = activeElement ? activeElement.id.replace('_type', '') : null;
            console.log("Return Type ID:", return_type_id);
            // Send the new order to the server via Fetch update_category_order
            fetch("{{ route('deal_packages.update_category_order') }}", {               
                method: "POST",
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ order: categoryOrder, return_type_id: return_type_id })
            })
            .then(response => response.json())
            .then(data => {
                console.log('Category order updated successfully');
                toastr.success('Category order updated successfully');
                //get the selected type id using active class
                let selectedTypeId = data.return_type_id;
                console.log("Selected Type ID:", selectedTypeId);
                if(selectedTypeId){
                    getCategories(selectedTypeId, '');
                }
                
            })
            .catch(error => {
                toastr.error('Error updating category order');
                console.error('Error updating category order:', error);
            });
        });

        // Disable autoDiscover so Dropzone doesn’t try to bind twice
        Dropzone.autoDiscover = false;

        // Initialize Bootstrap tooltips
        const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
        tooltipTriggerList.forEach(el => {
            new bootstrap.Tooltip(el, { trigger: 'hover focus' });            
        });
        // Close tooltips on document click
        document.addEventListener('click', function (e) {
            const openTooltips = document.querySelectorAll('.tooltip.show');
            openTooltips.forEach(tt => tt.remove());
        });

        //add search functionality to type list using typesearch-input and list.js
        var options = {
            valueNames: [ 'type-name' ]
        };
        var typeList = new List('type-list', options);
        document.getElementById('typesearch-input').addEventListener('keyup', function() {
            console.log("Searching for:", this.value);
            var searchString = this.value.toLowerCase();
            typeList.search(searchString);
        });

        // Initialize Select2 for the day off dropdown
        $('.select2').select2({
                width: '100%'
        });

        // Initialize Type Dropzone manually
        let typeDropzone = new Dropzone("#typeDropzone", {
            url: document.getElementById('typeDropzone').dataset.action, 
            paramName: "file", // field name sent to server
            maxFilesize: 2, // MB
            acceptedFiles: ".jpg,.jpeg,.png,.gif",
            addRemoveLinks: true,
            dictDefaultMessage: `
                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                    <h3>Drop files here or click to upload.</h3>
            `,
            init: function () {
                this.on("success", function (file, response) {
                    // Save filename into hidden input
                    document.getElementById('service_type_image').value = response.filename;

                    // Show preview
                    document.getElementById('selectedTypePreview').innerHTML =
                        `<img src="${document.getElementById('typeDropzone').dataset.previewBase}/${response.filename}" width="120" class="border rounded">`;
                });

                this.on("error", function (file, errorMessage) {
                    console.error("Dropzone upload error:", errorMessage);
                });
            }
        });

        //Initialize Category Dropzone manually
        let categoryDropzone = new Dropzone("#categoryDropzone", {
            url: document.getElementById('categoryDropzone').dataset.action, 
            paramName: "file", // field name sent to server
            maxFilesize: 2, // MB
            acceptedFiles: ".jpg,.jpeg,.png,.gif",
            addRemoveLinks: true,
            dictDefaultMessage: `
                    <i class="ti ti-cloud-upload h1 text-muted"></i>
                    <h3>Drop files here or click to upload.</h3>
            `,
            init: function () {
                this.on("success", function (file, response) {
                    // Save filename into hidden input
                    document.getElementById('service_category_image').value = response.filename;

                    // Show preview
                    document.getElementById('selectedCategoryPreview').innerHTML =
                        `<img src="${document.getElementById('categoryDropzone').dataset.previewBase}/${response.filename}" width="120" class="border rounded">`;
                });

                this.on("error", function (file, errorMessage) {
                    console.error("Dropzone upload error:", errorMessage);
                });
            }
        });

        document.getElementById('saveServiceBtn').addEventListener('click', function() {

            let service_visibility_checked = [];
            let service_visibility_unchecked = [];

            $('.branch-visibility').each(function () {
                let branchId = $(this).val();
                let price = $('.branch-price[data-branch-id="' + branchId + '"]').val();
                let rowData = {
                    business_id: branchId,
                    price: price
                };

                if ($(this).is(':checked')) {
                    service_visibility_checked.push(rowData);
                } else {
                    service_visibility_unchecked.push(rowData);
                }
            });

            let formData = new FormData(document.getElementById('serviceForm'));

            formData.append(
                'package_services_visibility_checked',
                JSON.stringify(service_visibility_checked)
            );

            formData.append(
                'package_services_visibility_unchecked',
                JSON.stringify(service_visibility_unchecked)
            );


            fetch("{{ route('deal_packages.save_package_service') }}", {
                method: "POST",
                headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if(data.success) {
                    // Close modal
                    var serviceModal = bootstrap.Modal.getInstance(document.getElementById('serviceModal'));
                    serviceModal.hide();

                    // Reload services for the selected category
                    let return_category_name = document.getElementById('return_category_name').value;
                    let activeElement = document.querySelector('#category-list .active');
                    let return_category_id = activeElement ? activeElement.id.replace('_category', '') : null;
                    if(return_category_id) {
                        getServices(return_category_id, return_category_name);
                    }

                    toastr.success('Service saved successfully');
                }
            });
        });

        document.getElementById('saveOptionsBtn').addEventListener('click', function() {
            let formData = new FormData(document.getElementById('serviceOptionsForm'));

            fetch("{{ route('deal_packages.save_service_option') }}", {
                method: "POST",
                headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
                body: formData
            })
            .then(res => res.json())
            .then(data => {
                if(data.success) {
                    // Close modal
                    var optionsModal = bootstrap.Modal.getInstance(document.getElementById('serviceOptionsModal'));
                    optionsModal.hide();

                    let service_category_name = document.getElementById('return_option_category_name').value;
                    let package_category_id = data.package_service_option.package_category_id;
                    getServices(package_category_id, service_category_name);

                    toastr.success('Service options saved successfully');
                } else {
                    toastr.error(data.message);
                }
            });
        });


        $('#select_service').on('select2:select', function (e) {
            let data = e.params.data;

            $('#service_rate').val(
                data.service_rate ? parseFloat(data.service_rate).toFixed(2) : '0.00'
            );
        });


    }); // End page load

    /// Image processing for Service Type Image Modal


    // Load existing images when Type modal opens
    document.getElementById('typeImageModal').addEventListener('show.bs.modal', function () {
        console.log("Loading existing type images...");
        fetch("{{ route('services.get_existing_type_images') }}")
            .then(res => {
                if (!res.ok) throw new Error("Network response was not ok " + res.statusText);
                return res.json();
            })
            .then(images => {
                //console.log("Loaded images:", images);  // DEBUG
                let container = document.getElementById('existingTypeImages');
                container.innerHTML = "";

                if (!images.length) {
                    container.innerHTML = "<p class='text-muted'>No images found</p>";
                    return;
                }

                images.forEach(url => {
                    let filename = url.split('/').pop();
                    let img = document.createElement('img');
                    img.src = url;
                    img.dataset.filename = filename;
                    img.style.width = "50px";
                    img.style.height = "50px";
                    img.style.objectFit = "cover";
                    img.style.cursor = "pointer";
                    img.classList.add("border", "rounded", "m-1");

                    img.addEventListener('click', function() {
                        document.querySelectorAll('#existingTypeImages img').forEach(i => i.style.border = "1px solid #ddd");
                        this.style.border = "3px solid blue";

                        document.getElementById('existing_type_image').value = this.dataset.filename;
                        document.getElementById('selectedTypePreview').innerHTML = 
                            `<img src="${url}" width="120" class="border rounded">`;
                    });

                    container.appendChild(img);
                });
            })
            .catch(err => console.error("Image fetch error:", err));
        });

    

    // Submit Type Image form via AJAX
     document.getElementById('typeDropzone').addEventListener('submit', function(e) {
          e.preventDefault();
          let formData = new FormData(this);

          fetch("{{ route('deal_packages.update_package_type_image') }}", {
               method: "POST",
               headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
               body: formData
          })
          .then(res => res.json())
          .then(data => {
               if(data.success) {                    
                  window.location.reload();
               }
          });
     });

    function open_typeImageModal(id_service_type){
        // Set the service type ID in the hidden input
        document.getElementById('type_image_id').value = id_service_type;

        // Clear previous selections
        document.getElementById('existing_type_image').value = '';
        document.getElementById('selectedTypePreview').innerHTML = '';

        // Open the modal
        var typeImageModal = new bootstrap.Modal(document.getElementById('typeImageModal'));
        typeImageModal.show();        
    }

    // Open Type Edit Modal and populate data
    function open_type_edit(id_package_type) {

        //if id_package_type = 0 then open for Add New
        if(id_package_type == 0) {
            $(".branch-check-for-package-type").each(function() {
             $(this).prop('checked', true); 
            });
            document.getElementById('typeModalLabel').innerText = "Add New Package Type";
            document.getElementById('id_package_type').value = 0;
            document.getElementById('service_type').value = '';
            document.getElementById('service_type_active').value = 'Yes';
            document.getElementById('business_type_id').value = '';
            document.getElementById('order_id').value = 0;
            document.getElementById('package_type_image').value = 'nu.png';
            var typeModal = new bootstrap.Modal(document.getElementById('typeModal'));
            typeModal.show();
            return;
        } else {

            document.getElementById('typeModalLabel').innerText = "Edit Package Type";
            // Fetch type details via AJAX
            const baseUrl = "{{ route('deal_packages.get_package_type', ':id') }}".replace(':id', id_package_type);
            fetch(baseUrl)
                .then(res => res.json())
                .then(data => {
                    if(data.message === "Success") {
                        let service_type = data.package_type;

                        let package_type_business_mapping = data.package_type_business_mapping;

                        $(".branch-check-for-package-type").each(function() {
                            $(this).prop('checked', true); 
                        });

                        if (package_type_business_mapping.length > 0) {
                            package_type_business_mapping.forEach(function(data) {                  
                                if (data.is_visible == 'No') {
                                    $("#package_type_visible_check_box_"+data.business_id).prop('checked', false);
                                }
                            });
                        }

                        // Populate modal fields
                        document.getElementById('id_package_type').value = service_type.id_package_type;
                        document.getElementById('service_type').value = service_type.service_type;
                        document.getElementById('business_type_id').value = service_type.business_type_id;
                        document.getElementById('service_type_active').value = service_type.service_type_active;
                        document.getElementById('order_id').value = service_type.order_id;
                        document.getElementById('package_type_image').value = service_type.service_type_image;
                        document.getElementById('expiry_date').value = service_type.expiry_date;
                    
                        // Show modal
                        var typeModal = new bootstrap.Modal(document.getElementById('typeModal'));
                        typeModal.show();
                    }
                });
        }
    }

    // Save Type (Add/Edit)
    document.getElementById('saveTypeBtn').addEventListener('click', function() {

            let package_type_visibility_checked = [];
            let package_type_visibility_unchecked = [];

            $('.branch-check-for-package-type').each(function () {
                if ($(this).is(':checked')) {
                    package_type_visibility_checked.push($(this).val());
                } else {
                    package_type_visibility_unchecked.push($(this).val());
                }
            });

            let formData = new FormData(document.getElementById('typeForm'));

            package_type_visibility_checked.forEach(function (val) {
                formData.append('package_type_visibility_checked[]', val);
            });

            package_type_visibility_unchecked.forEach(function (val) {
                formData.append('package_type_visibility_unchecked[]', val);
            });


        fetch("{{ route('deal_packages.save_package_type') }}", {
            method: "POST",
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal
                var typeModalEl = document.getElementById('typeModal');
                var typeModal = bootstrap.Modal.getInstance(typeModalEl);
                typeModal.hide();

                toastr.success(data.message);
                let newType = data.service_type;
                // If it's a new type, add it to the list
                if(formData.get('id_package_type') == 0) {
                    let typeList = document.querySelector('#type-list .list');
                    let newTypeHtml = `
                        <div id="${newType.id_package_type}_type" class="card mb-1 shadow-sm service-type-card" style="cursor: pointer;" onclick="getCategories(${newType.id_package_type}, '${newType.service_type}')">
                            <div class="card-body p-2 d-flex align-items-center ${newType.service_type_active == "No" ? "bg-light text-muted" : ""}">
                                <h5 class="type-name mb-0">${newType.service_type} ${newType.service_type_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : ""}</h5>
                                <div class="ms-auto">
                                    <button title="Edit Type" onclick="event.stopPropagation(); open_type_edit(${newType.id_package_type});" class="btn btn-sm ${newType.service_type_active == "No" ? "btn-light" : "btn-default"}">
                                        <iconify-icon icon="line-md:edit-twotone" class="fs-16"></iconify-icon>
                                    </button>
                                </div>
                            </div>
                            <div class="d-flex align-items-center mt-0">
                                <p  style="cursor: pointer;" onclick="getCategories(${newType.id_package_type}, '${newType.service_type}');" class="mb-0 ms-2 text-muted">Order# (${newType.order_id}) ID: ${newType.id_package_type}</p>                                        
                            </div>
                        </div>`;
                    typeList.insertAdjacentHTML('afterbegin', newTypeHtml);
                } else {
                    // /console.log(`Updating existing type card ${newType.id_package_type}_type`);
                    // If editing, update the existing card
                    let existingCard = document.getElementById(`${newType.id_package_type}_type`);
                    if(existingCard) {
                        existingCard.querySelector('.type-name').innerHTML = `${newType.service_type} ${newType.service_type_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : ""}`;
                        if(newType.service_type_active == "No") {
                            existingCard.querySelector('.card-body').classList.add("bg-light", "text-muted");
                        } else {
                            existingCard.querySelector('.card-body').classList.remove("bg-light", "text-muted");
                        }
                    }
                }
            } else {
                toastr.error(data.message);
            }
        });
    });

    // Fetch and display categories based on selected package type
    function getCategories(id_package_type, type_name){
       
        // reset background color of all package type cards
        var cards = document.getElementsByClassName('service-type-card');
        for(var i=0; i<cards.length; i++){
            cards[i].classList.remove("bg-primary");
            cards[i].classList.remove("text-white");
            cards[i].classList.remove("active");
        }
        // set background color of selected card
        document.getElementById(id_package_type + '_type').classList.add("bg-primary");
        document.getElementById(id_package_type + '_type').classList.add("text-white");
        document.getElementById(id_package_type + '_type').classList.add("active");
        // set type name in category header

        document.getElementById('type_name').innerText = ' - ' + type_name;

       // document.getElementById('services').innerText = '';

        // AJAX call to get categories based on service type
        $.ajax({
            url: "{{ route('deal_packages.get_package_categories_by_service_type') }}",
            type: "GET",
            data: {id_package_type: id_package_type},
            success: function(response){
                // Populate categories div
                // For now, just alert the response
                //console.log(response);
                package_category = response.package_category;
                var categoriesDiv = document.getElementById('categories');
                let mHtml = ''; let ohtml = "";
                for(var i=0; i<package_category.length; i++){
                    mHtml += '<div id="' + package_category[i].id_package_category + '_category" class="card mb-1 shadow-sm service-category-card">';
                    mHtml += '<div class="card-body p-2">';
                    mHtml += '<div class="d-flex align-items-center">';
                    mHtml += '<img onclick="open_categoryImageModal(' + package_category[i].id_package_category + ')" src="{{ asset('images/services/categories') }}' + '/' + package_category[i].service_category_image + '" height="30" class="me-2">';
                    mHtml += '<h5 class="category-name mb-0 ' + (package_category[i].package_category_active == "No" ? "strike-through" : "") + '" ';
                    mHtml += 'data-bs-toggle="tooltip" data-bs-placement="top" title="Click to load Services for ' + package_category[i].service_category + '" style="cursor: pointer;" onclick="getServices(' + package_category[i].id_package_category + ', \'' + package_category[i].service_category + '\');">'+ package_category[i].service_category + '</h5>';
                    mHtml += '<div class="ms-auto">';
                    mHtml += '<button title="Edit Category" onclick="open_category_edit(' + package_category[i].id_package_category + ')" class="btn btn-sm ' + (package_category[i].service_category_active == "No" ? "btn-light" : "btn-default") + '">';
                    mHtml +=  (package_category[i].service_category_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : "<iconify-icon icon='line-md:edit-twotone' class='fs-16'></iconify-icon>") + '</button>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '<div class="d-flex align-items-center mt-0">';
                    mHtml += '<p class="mb-0 ms-2 text-muted" style="cursor: pointer;" onclick="getServices(' + package_category[i].id_package_category + ', \'' + package_category[i].service_category + '\');">Order# (' + package_category[i].order_id + ') ID: ' + package_category[i].id_package_category + '</p>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '</div>';

                    ohtml += "<option value='" + package_category[i].id_package_category + "'>" + (package_category[i].service_category_active == "Yes" ? package_category[i].service_category + ' - ' + package_category[i].service_category + '  /  ' + 'active' : package_category[i].id_package_category + ' - ' + package_category[i].service_category + '  /  ' + 'Inactive') + "</option>";
                }
                categoriesDiv.innerHTML = mHtml;
                document.getElementById('package_category_id').innerHTML = ohtml;
               

                //Enable tooltip
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl)
                });

                //add search functionality to category list using membersearch-input and list.js
                var options = {
                    valueNames: [ 'category-name' ]
                };
                if(package_category.length > 0){
                    var categoryList = new List('category-list', options);
                    document.getElementById('categorysearch-input').addEventListener('keyup', function() {
                        var searchString = this.value.toLowerCase();
                        
                            categoryList.search(searchString);
                        
                    });
                }

            },
            error: function(xhr){
                alert("An error occurred while fetching categories.");
            }
        });
    }

    ///CATEGORY IMAGE MODAL FUNCTIONS
    //Load Existing Images when Category modal opens
    document.getElementById('categoryImageModal').addEventListener('show.bs.modal', function () {
        fetch("{{ route('deal_packages.get_existing_package_category_images') }}")
            .then(res => {
                    if (!res.ok) throw new Error("Network response was not ok " + res.statusText);
                    return res.json();
            })
            .then(images => {
                    //console.log("Loaded images:", images);  // DEBUG
                    let container = document.getElementById('existingCategoryImages');
                    container.innerHTML = "";

                    if (!images.length) {
                        container.innerHTML = "<p class='text-muted '>No images found</p>";
                        return;
                    }
                    images.forEach(url => {
                        let filename = url.split('/').pop();
                        let img = document.createElement('img');
                        img.src = url;
                        img.dataset.filename = filename;
                        img.style.width = "50px";
                        img.style.height = "50px";
                        img.style.objectFit = "cover";
                        img.style.cursor = "pointer";
                        img.classList.add("border", "rounded", "m-1");

                        img.addEventListener('click', function() {
                            document.querySelectorAll('#existingCategoryImages img').forEach(i => i.style.border = "1px solid #ddd");
                            this.style.border = "3px solid blue";

                            document.getElementById('existing_category_image').value = this.dataset.filename;
                            document.getElementById('selectedCategoryPreview').innerHTML = 
                                `<img src="${url}" width="120" class="border rounded">`;
                        });

                        container.appendChild(img);
                    });
            })
            .catch(err => console.error("Image fetch error:", err));
    });

    function open_categoryImageModal(id_package_category){
        // Set the service category ID in the hidden input
        document.getElementById('category_image_id').value = id_package_category;

        // Clear previous selections
        document.getElementById('existing_category_image').value = '';
        document.getElementById('selectedCategoryPreview').innerHTML = '';

        // Open the modal
        var categoryImageModal = new bootstrap.Modal(document.getElementById('categoryImageModal'));
        categoryImageModal.show();        
    }

    // Submit Category Image form via AJAX
     document.getElementById('categoryDropzone').addEventListener('submit', function(e) {
          e.preventDefault();
          let formData = new FormData(this);

          fetch("{{ route('deal_packages.update_package_category_image') }}", {
               method: "POST",
               headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
               body: formData
          })
          .then(res => res.json())
          .then(data => {
               if(data.success) {          
                    getCategories(data.id_package_type, '');          
                  // window.location.reload();
               }
          });
     });

    //open Category Edit Modal and populate data
    function open_category_edit(id_package_category) {
        // Similar logic to open_type_edit can be implemented here for categories
        document.getElementById('return_type_name').value = document.getElementById('type_name').innerText.replace(' - ', '');
        //if id_package_category = 0 then open for Add New
        if(id_package_category == 0) {
            
            document.getElementById('categoryModalLabel').innerText = "Add New Service Category";
            document.getElementById('id_package_category').value = 0;
            document.getElementById('category_order_id').value = 0;
            document.getElementById('service_category').value = '';
            document.getElementById('service_category_active').value = 'Yes';
            document.getElementById('existing_package_category_image').value = 'nu.png';

            //get the id_service_type of the active service type card
            let activeTypeCard = document.querySelector('.service-type-card.bg-primary');
            if(activeTypeCard) {
                let id_package_type = activeTypeCard.id.split('_')[0];
                document.getElementById('package_type_id').value = id_package_type;
                $("#package_type_id").val(id_package_type).trigger('change');
            }


            var categoryModal = new bootstrap.Modal(document.getElementById('categoryModal'));
            categoryModal.show();
            return;
        } else {

            document.getElementById('categoryModalLabel').innerText = "Edit Service Category";
            // Fetch category details via AJAX
            const baseUrl = "{{ route('deal_packages.get_package_category', ':id') }}".replace(':id', id_package_category);
            fetch(baseUrl)
                .then(res => res.json())
                .then(data => {
                    if(data.message === "Success") {
                        let package_category = data.package_category;
                        console.log(package_category);
                        // Populate modal fields                        
                        document.getElementById('id_package_category').value = package_category.id_package_category;
                        document.getElementById('category_order_id').value = package_category.order_id;
                        document.getElementById('service_category').value = package_category.service_category;
                        document.getElementById('package_type_id').value = package_category.package_type_id;
                        $("#package_type_id").val(package_category.package_type_id).trigger('change');
                        document.getElementById('service_category_active').value = package_category.service_category_active;
                        document.getElementById('existing_package_category_image').value = package_category.service_category_image;

                        // Show modal
                        var categoryModal = new bootstrap.Modal(document.getElementById('categoryModal'));
                        categoryModal.show();
                    }
                });
        }
    }

    //Save Category (Add/Edit)
    document.getElementById('saveCategoryBtn').addEventListener('click', function() {
        let formData = new FormData(document.getElementById('categoryForm'));

        fetch("{{ route('deal_packages.save_package_category') }}", {
            method: "POST",
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}'},
            body: formData
        })
        .then(res => res.json())
        .then(data => {
            if(data.success) {
                // Close modal
                var categoryModalEl = document.getElementById('categoryModal');
                var categoryModal = bootstrap.Modal.getInstance(categoryModalEl);
                categoryModal.hide();

                toastr.success(data.message);
                let newCategory = data.package_category;
                 // just reload the categories for the current package type
                getCategories(newCategory.package_type_id, '');
                //set the type name in the header
                document.getElementById('type_name').innerText = ' - ' + document.getElementById('return_type_name').value.replace('- ', '');
               
            } else {
                toastr.error(data.message);
            }
        });
    });

    // Get Services based on selected category
    function getServices(id_package_category, category_name){
        document.getElementById('services').innerHTML="";
        // alert(id_service_category);
        // reset background color of all service category cards
        var cards = document.getElementsByClassName('service-category-card');
        for(var i=0; i<cards.length; i++){
            cards[i].classList.remove("bg-primary");
            cards[i].classList.remove("text-white");
            cards[i].classList.remove("active");
        }
        // set background color of selected card
        document.getElementById(id_package_category + '_category').classList.add("bg-primary");
        document.getElementById(id_package_category + '_category').classList.add("text-white");
        document.getElementById(id_package_category + '_category').classList.add("active");

        document.getElementById('category_name').innerText = ' - ' + category_name;

        // AJAX call to get services based on category
        $.ajax({
            url: "{{ route('deal_packages.get_services_by_category') }}",
            type: "GET",
            data: {id_package_category: id_package_category},
            success: function(response){
                // Populate services div
                // For now, just alert the response
                //console.log(response);
                services = response.services;
                var servicesDiv = document.getElementById('services');
                let mHtml = ''; ohtml="";
                for(var i=0; i<services.length; i++){
                    if(services[i].option_for > 0){
                        //find the service card div with id = services[i].option_for + '_service_options' and append option service card html to it
                        let optionServiceHtml = '';
                        optionServiceHtml += '<div id="' + services[i].id_package_services + '_option_service" class="card mb-1 ms-4 shadow-sm service-option-card">';
                        optionServiceHtml += '<div class="card-body p-2">';
                        optionServiceHtml += '<div class="d-flex align-items-center">';
                        optionServiceHtml += '<h5 class="me-2">Option: ' + services[i].package_option_number + '</h5>';
                        optionServiceHtml += '<h5  class="service-name mb-0 ' + (services[i].package_services_active == "No" ? "strike-through" : "") + '">' + services[i].service_name + '</h5>';
                        optionServiceHtml += '<div class="ms-auto">';
                        optionServiceHtml += '<button data-bs-toggle="tooltip" data-bs-placement="top" title="Remove Option" onclick="deactivate_package_service(' + services[i].id_package_services + ')" class="btn btn-sm ' + (services[i].service_active == "No" ? "btn-light" : "btn-default") + '" title="Edit Service">';
                        optionServiceHtml +=  (services[i].service_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : "<iconify-icon icon='line-md:trash' class='text-danger fs-16'></iconify-icon>") + '</button>';
                        optionServiceHtml += '</div>';
                        optionServiceHtml += '</div>';
                        optionServiceHtml += '<div class="d-flex align-items-center mt-0">';
                        optionServiceHtml += '<p class="mb-0 ms-2 text-muted">ID: ' + services[i].id_package_services + '</p><p class="mb-0 ms-2 text-muted">Price: (' + parseFloat(services[i].service_rate).toFixed(2) + ')</p>';
                        optionServiceHtml += '</div>';
                        optionServiceHtml += '</div>';
                        optionServiceHtml += '</div>';
                        let parentServiceDiv = document.getElementById(services[i].option_for + '_service');
                        if(parentServiceDiv){
                            parentServiceDiv.insertAdjacentHTML('beforeend', optionServiceHtml);
                        }
                        continue; //skip option services
                    }
                    mHtml += '<div id="' + services[i].id_package_services + '_service" class="card mb-1 shadow-sm service-card">';
                    mHtml += '<div class="card-body p-2">';
                    mHtml += '<div class="d-flex align-items-center">';
                    mHtml += '<img src="{{ asset('images/services/categories') }}' + '/' + services[i].service_image + '" height="30" class="me-2">';
                    mHtml += '<h5  class="service-name mb-0 ' + (services[i].service_active == "No" ? "strike-through" : "") + '">' + services[i].service_name + '</h5>';
                    mHtml += '<div class="ms-auto">';
                    if(services[i].package_service_optional == "Yes"){
                    mHtml += '<button data-bs-toggle="tooltip" data-bs-placement="top" title="Add Optional Services" onclick="add_service_options(' + services[i].id_package_services + ')" class="btn btn-sm btn-default me-1" title="Add Options"><iconify-icon icon="vaadin:options" class="fs-20"></iconify-icon></button>';
                    }
                    mHtml += '<button data-bs-toggle="tooltip" data-bs-placement="top" title="Edit Service" onclick="open_service_edit(' + services[i].id_package_services + ')" class="btn btn-sm ' + (services[i].service_active == "No" ? "btn-light" : "btn-default") + '" title="Edit Service">';
                    mHtml +=  (services[i].service_active == "No" ? "<iconify-icon icon='mingcute:unlock-line' class='fs-16'></iconify-icon>" : "<iconify-icon icon='line-md:edit-twotone' class='fs-16'></iconify-icon>") + '</button>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '<div class="d-flex align-items-center mt-0">';
                    mHtml += '<p class="mb-0 ms-2 text-muted">ID: ' + services[i].id_package_services + '</p><p class="mb-0 ms-2 text-muted">Price: (' + parseFloat(services[i].service_rate).toFixed(2) + ')</p>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    mHtml += '</div>';
                    
                    servicesDiv.innerHTML += mHtml;
                    mHtml = '';
                    ohtml+= "<option value='" + services[i].id_package_services + "'>" + (services[i].service_active == "Yes" ? services[i].id_package_services + ' - ' + services[i].service_name + '  /  ' + 'active' : services[i].id_package_services + ' - ' + services[i].service_name + '  /  ' + 'Inactive') + "</option>";
                }
                //servicesDiv.innerHTML = mHtml;
                // document.getElementById('service_name_for_recipe').innerHTML = ohtml;

                //Initialize tooltip
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl)
                });

                //add search functionality to services list using membersearch-input and list.js
                var options = {
                    valueNames: [ 'service-name' ]
                };
                var serviceList = new List('service-list', options);
                document.getElementById('servicesearch-input').addEventListener('keyup', function() {
                    var searchString = this.value.toLowerCase();
                    serviceList.search(searchString);
                });
            },
            error: function(xhr){
                alert("An error occurred while fetching services.");
            }
        });
    }

    function open_service_edit(id_package_service) {
        // Implement similar to open_type_edit and open_category_edit
        if(id_package_service == 0) {

            $(".branch-visibility").prop("checked", true);
            $(".branch-price").val("");

            document.getElementById('selectServiceDiv').classList.remove('d-none');
            document.getElementById('serviceNameDiv').classList.add('d-none');
            
            document.getElementById('serviceModalLabel').innerText = "Add New Service";
            document.getElementById('package_category_id').value = 0;
            document.getElementById('service_name').value = '';
            document.getElementById('service_rate').value = '';            
            document.getElementById('package_service_active').value = 'Yes';
            document.getElementById('package_service_qty').value = 1;
            document.getElementById('package_service_optional').value = 'No';

            let activeTypeCategroyCard = document.querySelector('.service-category-card.bg-primary');
            if(activeTypeCategroyCard) {
                let id_package_type = activeTypeCategroyCard.id.split('_')[0];
                document.getElementById('package_category_id').value = id_package_type;
                $("#package_category_id").val(id_package_type).trigger('change');
            }
            
            $("#select_service").val('');
            //Initialize select2 on select_service using ajax to fetch services
            $('#select_service').select2({
                width: '100%',
                placeholder: 'Select a service',
                dropdownParent: $('#serviceModal'),
                ajax: {
                    url: "{{ route('services.search_service') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            search_term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: data.map(function (item) {
                                return {
                                    id: item.id_business_services,
                                    text: item.business_type + ' | ' + item.service_name + ' ' + item.service_rate + ' ' + (item.service_type ? ' (Category: ' + item.service_category + ')' : ''),
                                    business_type: item.business_type,
                                    service_rate: item.service_rate,
                                    duration: item.service_duration,
                                    service_id: item.id_business_services,
                                };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                // Formatting should be outside the ajax block
                templateResult: function (item) {
                    if (item.loading) return item.text;

                    return $(
                        "<div class='d-flex justify-content-between'>" +
                            "<div class='col-md-6 d-flex justify-content-between'>" + item.text + "</div>" +
                            "<div class='col-md-6 me-auto text-end text-muted' style='font-size: 0.8em;'>" + (item.service_duration ? item.service_duration : '') + ' ' + (item.service_type ? item.service_type : '') + ' PRICE: ' + (item.service_rate ? parseFloat(item.service_rate).toFixed(2) : '0.00') + "</div>" +
                        "</div>"
                    );
                },

                templateSelection: function (item) {
                    return item.text || item.id;
                },

                escapeMarkup: function (markup) {
                    return markup;
                }
            });
            
            var serviceModal = new bootstrap.Modal(document.getElementById('serviceModal'));
            serviceModal.show();
            return;
        } else {
            document.getElementById('selectServiceDiv').classList.add('d-none');
            document.getElementById('serviceNameDiv').classList.remove('d-none');
            
            // Fetch service details via AJAX
            const baseUrl = "{{ route('deal_packages.get_service', ':id') }}".replace(':id', id_package_service);
            fetch(baseUrl)
                .then(res => res.json())
                .then(data => {
                    if(data.message === "Success") {

                        let package_services_business_mapping = data.package_services_business_mapping;
                        $(".branch-visibility").prop("checked", true);
                        $(".branch-price").val("");

                        if(package_services_business_mapping.length > 0){
                            package_services_business_mapping.forEach(function (item) {
                                let businessId = item.business_id;
                                // ===== Visibility =====
                                let checkbox = $(".branch-visibility[value='" + businessId + "']");
                                if (item.is_visible === 'Yes') {
                                    checkbox.prop("checked", true);
                                } else {
                                    checkbox.prop("checked", false);
                                }
                                // ===== Price =====
                                $(".branch-price[data-branch-id='" + businessId + "']")
                                    .val(item.price);
                            });
                        }

                        let service = data.service;
                        // console.log(service);
                        // Populate modal fields                        
                        document.getElementById('id_package_service').value = service.id_package_services;
                        document.getElementById('service_id').value = service.service_id;
                        document.getElementById('service_name').value = service.service_name;
                        document.getElementById('service_rate').value = parseFloat(service.service_rate);
                        document.getElementById('package_service_active').value = service.package_services_active;
                        document.getElementById('package_service_qty').value = service.package_service_qty;
                        document.getElementById('package_category_id').value = service.package_category_id;
                        document.getElementById('package_service_optional').value = service.package_service_optional;
                        document.getElementById('return_category_id').value = service.package_category_id;
                        document.getElementById('return_category_name').value = service.service_category;

                        // Show modal
                        El = document.getElementById('serviceModal');
                        var serviceModal = new bootstrap.Modal(El);
                        serviceModal.show();
                    } else {
                        toastr.error(data.message);
                    }
            });
        }
    }

    function updateServiceDetails(){
        data = $("#select_service").select2('data');
        if(data.length > 0){
            document.getElementById('service_name').value = data[0].text;
            document.getElementById('service_id').value = parseFloat(data[0].service_id);
        }
    }

    function add_service_options(id_package_service){
        // Implement functionality to add optional services
        console.log("Add optional services for package service ID: " + id_package_service);

        // Show modal
        document.getElementById('id_package_service_options').value = id_package_service;
        
        return_service_name = document.getElementById(id_package_service + '_service').querySelector('.service-name').innerText;
        return_category_name = document.getElementById('category_name').innerText.replace('-', '');

        document.getElementById('serviceOptionsModalLabel').innerText = "Add Options for Service: " + return_service_name;
        document.getElementById('return_option_category_name').value = return_category_name;

        // Fetch the service list
        //Initialize select2 on option_name using ajax to fetch services
            $('#option_name').select2({
                width: '100%',
                placeholder: 'Select a service',
                dropdownParent: $('#serviceOptionsModal'),
                ajax: {
                    url: "{{ route('services.search_service') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                            search_term: params.term // search term
                        };
                    },
                    processResults: function (data) {
                        return {
                            results: data.map(function (item) {
                                return {
                                    id: item.id_business_services,
                                    text: item.business_type + ' | ' + item.service_name + ' ' + item.service_rate + ' ' + (item.service_type ? ' (Category: ' + item.service_category + ')' : ''),
                                    business_type: item.business_type,
                                    service_rate: item.service_rate,
                                    duration: item.service_duration,
                                    service_id: item.id_business_services,
                                };
                            })
                        };
                    },
                    cache: true
                },
                minimumInputLength: 3,
                // Formatting should be outside the ajax block
                templateResult: function (item) {
                    if (item.loading) return item.text;

                    return $(
                        "<div class='d-flex justify-content-between'>" +
                            "<div class='col-md-6 d-flex justify-content-between'>" + item.text + "</div>" +
                            "<div class='col-md-6 me-auto text-end text-muted' style='font-size: 0.8em;'>" + (item.service_duration ? item.service_duration : '') + ' ' + (item.service_type ? item.service_type : '') + ' PRICE: ' + (item.service_rate ? parseFloat(item.service_rate).toFixed(2) : '0.00') + "</div>" +
                        "</div>"
                    );
                },

                templateSelection: function (item) {
                    return item.text || item.id;
                },

                escapeMarkup: function (markup) {
                    return markup;
                }
            });


        var optionalServiceModal = new bootstrap.Modal(document.getElementById('serviceOptionsModal'));
        optionalServiceModal.show();
    }

    function deactivate_package_service(id_package_service){
        // Implement functionality to deactivate package service
        console.log("Deactivate package service ID: " + id_package_service);

        fetch("{{ route('deal_packages.deactivate_package_service', 'id') }}".replace('id', id_package_service), {
            method: "POST",
            headers: {'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type': 'application/json'},
            body: JSON.stringify({id_package_service: id_package_service})
        })
        .then(res => res.json())
        .then(data => {
            if (data.success) {
                toastr.success(data.message);
            } else {
                toastr.error(data.error);
            }
        });
    }

    // if page orientation changes, recalculate viewport dimensions
    window.addEventListener('orientationchange', function() {
        var vp = getViewPort();
        //console.log('Orientation changed. New viewport dimensions: ', vp.width, 'x', vp.height);

         document.querySelectorAll('.list').forEach(function(list) {
            list.style.height = (vp.height - 400) + 'px'; // Adjust 400 as needed for other UI elements
        });
    });

    // if zoom level changes, recalculate viewport dimensions
    window.addEventListener('resize', function() {
        var vp = getViewPort();
        //console.log('Window resized. New viewport dimensions: ', vp.width, 'x', vp.height);

        document.querySelectorAll('.list').forEach(function(list) {
            list.style.height = (vp.height - 400) + 'px'; // Adjust 400 as needed for other UI elements
        });

    });

    function getViewPort() {
        var e = window,
            a = 'inner';
        if (!('innerWidth' in window)) {
            a = 'client';
            e = document.documentElement || document.body;
        }
        return {
            width: e[a + 'Width'],
            height: e[a + 'Height']
        };
    }
    
    $(document).on('input','#service_rate',function(){
        var service_rate =  $(this).val();
        $(".branch-price").val(parseFloat(service_rate).toFixed(2));
    });
</script>
@endsection